/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SMountEntityPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.network.play.server.SUpdateChunkPositionPacket;
import net.minecraft.network.play.server.SUpdateLightPacket;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.DelegatedTaskExecutor;
import net.minecraft.util.concurrent.ITaskExecutor;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.GameRules;
import net.minecraft.world.TrackedEntity;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.ChunkTaskPriorityQueue;
import net.minecraft.world.chunk.ChunkTaskPriorityQueueSorter;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.PlayerGenerationTracker;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.storage.ChunkLoader;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;
import net.minecraft.world.server.TicketManager;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.SessionLockException;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkManager
extends ChunkLoader
implements ChunkHolder.IPlayerProvider {
    private static final Logger field_219250_d = LogManager.getLogger();
    public static final int field_219249_a = 33 + ChunkStatus.func_222600_b();
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> field_219251_e = new Long2ObjectLinkedOpenHashMap();
    private volatile Long2ObjectLinkedOpenHashMap<ChunkHolder> field_219252_f = this.field_219251_e.clone();
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> field_219253_g = new Long2ObjectLinkedOpenHashMap();
    private final LongSet field_219254_h = new LongOpenHashSet();
    private final ServerWorld field_219255_i;
    private final ServerWorldLightManager field_219256_j;
    private final ThreadTaskExecutor<Runnable> field_219257_k;
    private final ChunkGenerator<?> field_219258_l;
    private final Supplier<DimensionSavedDataManager> field_219259_m;
    private final PointOfInterestManager field_219260_n;
    private final LongSet field_219261_o = new LongOpenHashSet();
    private boolean field_219262_p;
    private final ChunkTaskPriorityQueueSorter field_219263_q;
    private final ITaskExecutor<ChunkTaskPriorityQueueSorter.FunctionEntry<Runnable>> field_219264_r;
    private final ITaskExecutor<ChunkTaskPriorityQueueSorter.FunctionEntry<Runnable>> field_219265_s;
    private final IChunkStatusListener field_219266_t;
    private final ProxyTicketManager field_219267_u;
    private final AtomicInteger field_219268_v = new AtomicInteger();
    private final TemplateManager field_219269_w;
    private final File field_219270_x;
    private final PlayerGenerationTracker field_219271_y = new PlayerGenerationTracker();
    private final Int2ObjectMap<EntityTracker> field_219272_z = new Int2ObjectOpenHashMap();
    private final Queue<Runnable> field_223181_A = Queues.newConcurrentLinkedQueue();
    private int field_219247_A;

    public ChunkManager(ServerWorld p_i51538_1_, File p_i51538_2_, DataFixer p_i51538_3_, TemplateManager p_i51538_4_, Executor p_i51538_5_, ThreadTaskExecutor<Runnable> p_i51538_6_, IChunkLightProvider p_i51538_7_, ChunkGenerator<?> p_i51538_8_, IChunkStatusListener p_i51538_9_, Supplier<DimensionSavedDataManager> p_i51538_10_, int p_i51538_11_) {
        super(new File(p_i51538_1_.func_201675_m().func_186058_p().func_212679_a(p_i51538_2_), "region"), p_i51538_3_);
        this.field_219269_w = p_i51538_4_;
        this.field_219270_x = p_i51538_1_.func_201675_m().func_186058_p().func_212679_a(p_i51538_2_);
        this.field_219255_i = p_i51538_1_;
        this.field_219258_l = p_i51538_8_;
        this.field_219257_k = p_i51538_6_;
        DelegatedTaskExecutor delegatedtaskexecutor = DelegatedTaskExecutor.func_213144_a((Executor)p_i51538_5_, (String)"worldgen");
        ITaskExecutor itaskexecutor = ITaskExecutor.func_213140_a((String)"main", arg_0 -> p_i51538_6_.func_212871_a_(arg_0));
        this.field_219266_t = p_i51538_9_;
        DelegatedTaskExecutor delegatedtaskexecutor1 = DelegatedTaskExecutor.func_213144_a((Executor)p_i51538_5_, (String)"light");
        this.field_219263_q = new ChunkTaskPriorityQueueSorter((List)ImmutableList.of((Object)delegatedtaskexecutor, (Object)itaskexecutor, (Object)delegatedtaskexecutor1), p_i51538_5_, Integer.MAX_VALUE);
        this.field_219264_r = this.field_219263_q.func_219087_a((ITaskExecutor)delegatedtaskexecutor, false);
        this.field_219265_s = this.field_219263_q.func_219087_a(itaskexecutor, false);
        this.field_219256_j = new ServerWorldLightManager(p_i51538_7_, this, this.field_219255_i.func_201675_m().func_191066_m(), delegatedtaskexecutor1, this.field_219263_q.func_219087_a((ITaskExecutor)delegatedtaskexecutor1, false));
        this.field_219267_u = new ProxyTicketManager(p_i51538_5_, (Executor)p_i51538_6_);
        this.field_219259_m = p_i51538_10_;
        this.field_219260_n = new PointOfInterestManager(new File(this.field_219270_x, "poi"), p_i51538_3_);
        this.func_219175_a(p_i51538_11_);
    }

    private static double func_219217_a(ChunkPos chunkPosIn, Entity entityIn) {
        double d0 = chunkPosIn.field_77276_a * 16 + 8;
        double d1 = chunkPosIn.field_77275_b * 16 + 8;
        double d2 = d0 - entityIn.func_226277_ct_();
        double d3 = d1 - entityIn.func_226281_cx_();
        return d2 * d2 + d3 * d3;
    }

    private static int func_219215_b(ChunkPos p_219215_0_, ServerPlayerEntity p_219215_1_, boolean p_219215_2_) {
        int j;
        int i;
        if (p_219215_2_) {
            SectionPos sectionpos = p_219215_1_.func_213842_M();
            i = sectionpos.func_218149_a();
            j = sectionpos.func_218148_c();
        } else {
            i = MathHelper.func_76128_c((double)(p_219215_1_.func_226277_ct_() / 16.0));
            j = MathHelper.func_76128_c((double)(p_219215_1_.func_226281_cx_() / 16.0));
        }
        return ChunkManager.func_219232_a(p_219215_0_, i, j);
    }

    private static int func_219232_a(ChunkPos chunkPosIn, int x, int y) {
        int i = chunkPosIn.field_77276_a - x;
        int j = chunkPosIn.field_77275_b - y;
        return Math.max(Math.abs(i), Math.abs(j));
    }

    protected ServerWorldLightManager func_219207_a() {
        return this.field_219256_j;
    }

    @Nullable
    protected ChunkHolder func_219220_a(long p_219220_1_) {
        return (ChunkHolder)this.field_219251_e.get(p_219220_1_);
    }

    @Nullable
    protected ChunkHolder func_219219_b(long chunkPosIn) {
        return (ChunkHolder)this.field_219252_f.get(chunkPosIn);
    }

    protected IntSupplier func_219191_c(long p_219191_1_) {
        return () -> {
            ChunkHolder chunkholder = this.func_219219_b(p_219191_1_);
            return chunkholder == null ? ChunkTaskPriorityQueue.field_219419_a - 1 : Math.min(chunkholder.func_219281_j(), ChunkTaskPriorityQueue.field_219419_a - 1);
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_219170_a(ChunkPos p_219170_1_) {
        ChunkHolder chunkholder = this.func_219219_b(p_219170_1_.func_201841_a());
        if (chunkholder == null) {
            return "null";
        }
        String s = chunkholder.func_219299_i() + "\n";
        ChunkStatus chunkstatus = chunkholder.func_219285_d();
        IChunk ichunk = chunkholder.func_219287_e();
        if (chunkstatus != null) {
            s = s + "St: \u00a7" + chunkstatus.func_222584_c() + (Object)((Object)chunkstatus) + '\u00a7' + "r\n";
        }
        if (ichunk != null) {
            s = s + "Ch: \u00a7" + ichunk.func_201589_g().func_222584_c() + (Object)((Object)ichunk.func_201589_g()) + '\u00a7' + "r\n";
        }
        ChunkHolder.LocationType chunkholder$locationtype = chunkholder.func_219300_g();
        s = s + "\u00a7" + chunkholder$locationtype.ordinal() + (Object)((Object)chunkholder$locationtype);
        return s + '\u00a7' + "r";
    }

    private CompletableFuture<Either<List<IChunk>, ChunkHolder.IChunkLoadingError>> func_219236_a(ChunkPos p_219236_1_, final int p_219236_2_, IntFunction<ChunkStatus> p_219236_3_) {
        ArrayList list = Lists.newArrayList();
        final int i = p_219236_1_.field_77276_a;
        final int j = p_219236_1_.field_77275_b;
        for (int k = -p_219236_2_; k <= p_219236_2_; ++k) {
            for (int l = -p_219236_2_; l <= p_219236_2_; ++l) {
                int i1 = Math.max(Math.abs(l), Math.abs(k));
                final ChunkPos chunkpos = new ChunkPos(i + l, j + k);
                long j1 = chunkpos.func_201841_a();
                ChunkHolder chunkholder = this.func_219220_a(j1);
                if (chunkholder == null) {
                    return CompletableFuture.completedFuture(Either.right((Object)new ChunkHolder.IChunkLoadingError(){

                        public String toString() {
                            return "Unloaded " + chunkpos.toString();
                        }
                    }));
                }
                ChunkStatus chunkstatus = p_219236_3_.apply(i1);
                CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> completablefuture = chunkholder.func_219276_a(chunkstatus, this);
                list.add(completablefuture);
            }
        }
        CompletableFuture completablefuture1 = Util.func_215079_b((List)list);
        return completablefuture1.thenApply(p_219227_4_ -> {
            ArrayList list1 = Lists.newArrayList();
            int k1 = 0;
            for (final Either either : p_219227_4_) {
                Optional optional = either.left();
                if (!optional.isPresent()) {
                    final int l1 = k1;
                    return Either.right((Object)new ChunkHolder.IChunkLoadingError(){

                        public String toString() {
                            return "Unloaded " + new ChunkPos(i + l1 % (p_219236_2_ * 2 + 1), j + l1 / (p_219236_2_ * 2 + 1)) + " " + ((ChunkHolder.IChunkLoadingError)either.right().get()).toString();
                        }
                    });
                }
                list1.add(optional.get());
                ++k1;
            }
            return Either.left((Object)list1);
        });
    }

    public CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>> func_219188_b(ChunkPos p_219188_1_) {
        return this.func_219236_a(p_219188_1_, 2, p_219218_0_ -> ChunkStatus.field_222617_m).thenApplyAsync(p_219242_0_ -> p_219242_0_.mapLeft(p_219238_0_ -> (Chunk)p_219238_0_.get(p_219238_0_.size() / 2)), (Executor)this.field_219257_k);
    }

    @Nullable
    private ChunkHolder func_219213_a(long p_219213_1_, int p_219213_3_, @Nullable ChunkHolder p_219213_4_, int p_219213_5_) {
        if (p_219213_5_ > field_219249_a && p_219213_3_ > field_219249_a) {
            return p_219213_4_;
        }
        if (p_219213_4_ != null) {
            p_219213_4_.func_219292_a(p_219213_3_);
        }
        if (p_219213_4_ != null) {
            if (p_219213_3_ > field_219249_a) {
                this.field_219261_o.add(p_219213_1_);
            } else {
                this.field_219261_o.remove(p_219213_1_);
            }
        }
        if (p_219213_3_ <= field_219249_a && p_219213_4_ == null) {
            p_219213_4_ = (ChunkHolder)this.field_219253_g.remove(p_219213_1_);
            if (p_219213_4_ != null) {
                p_219213_4_.func_219292_a(p_219213_3_);
            } else {
                p_219213_4_ = new ChunkHolder(new ChunkPos(p_219213_1_), p_219213_3_, (WorldLightManager)this.field_219256_j, (ChunkHolder.IListener)this.field_219263_q, this);
            }
            this.field_219251_e.put(p_219213_1_, (Object)p_219213_4_);
            this.field_219262_p = true;
        }
        return p_219213_4_;
    }

    public void close() throws IOException {
        try {
            this.field_219263_q.close();
            this.field_219260_n.close();
        }
        finally {
            super.close();
        }
    }

    protected void func_219177_a(boolean flush) {
        if (flush) {
            List list = this.field_219252_f.values().stream().filter(ChunkHolder::func_219289_k).peek(ChunkHolder::func_219303_l).collect(Collectors.toList());
            MutableBoolean mutableboolean = new MutableBoolean();
            do {
                mutableboolean.setFalse();
                list.stream().map(p_222974_1_ -> {
                    CompletableFuture<IChunk> completablefuture;
                    do {
                        completablefuture = p_222974_1_.func_219302_f();
                        this.field_219257_k.func_213161_c(completablefuture::isDone);
                    } while (completablefuture != p_222974_1_.func_219302_f());
                    return completablefuture.join();
                }).filter(p_222952_0_ -> p_222952_0_ instanceof ChunkPrimerWrapper || p_222952_0_ instanceof Chunk).filter(this::func_219229_a).forEach(p_222959_1_ -> mutableboolean.setTrue());
            } while (mutableboolean.isTrue());
            this.func_223155_b(() -> true);
            this.func_227079_i_();
            field_219250_d.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)this.field_219270_x.getName());
        } else {
            this.field_219252_f.values().stream().filter(ChunkHolder::func_219289_k).forEach(p_222965_1_ -> {
                IChunk ichunk = p_222965_1_.func_219302_f().getNow(null);
                if (ichunk instanceof ChunkPrimerWrapper || ichunk instanceof Chunk) {
                    this.func_219229_a(ichunk);
                    p_222965_1_.func_219303_l();
                }
            });
        }
    }

    protected void func_219204_a(BooleanSupplier hasMoreTime) {
        IProfiler iprofiler = this.field_219255_i.func_217381_Z();
        iprofiler.func_76320_a("poi");
        this.field_219260_n.func_219115_a(hasMoreTime);
        iprofiler.func_219895_b("chunk_unload");
        if (!this.field_219255_i.func_217402_u()) {
            this.func_223155_b(hasMoreTime);
            if (this.field_219251_e.isEmpty()) {
                DimensionManager.unloadWorld((ServerWorld)this.field_219255_i);
            }
        }
        iprofiler.func_76319_b();
    }

    private void func_223155_b(BooleanSupplier p_223155_1_) {
        Runnable runnable;
        LongIterator longiterator = this.field_219261_o.iterator();
        int i = 0;
        while (longiterator.hasNext() && (p_223155_1_.getAsBoolean() || i < 200 || this.field_219261_o.size() > 2000)) {
            long j = longiterator.nextLong();
            ChunkHolder chunkholder = (ChunkHolder)this.field_219251_e.remove(j);
            if (chunkholder != null) {
                this.field_219253_g.put(j, (Object)chunkholder);
                this.field_219262_p = true;
                ++i;
                this.func_219212_a(j, chunkholder);
            }
            longiterator.remove();
        }
        while ((p_223155_1_.getAsBoolean() || this.field_223181_A.size() > 2000) && (runnable = this.field_223181_A.poll()) != null) {
            runnable.run();
        }
    }

    private void func_219212_a(long chunkPosIn, ChunkHolder chunkHolderIn) {
        CompletableFuture<IChunk> completablefuture = chunkHolderIn.func_219302_f();
        ((CompletableFuture)completablefuture.thenAcceptAsync(p_219185_5_ -> {
            CompletableFuture<IChunk> completablefuture1 = chunkHolderIn.func_219302_f();
            if (completablefuture1 != completablefuture) {
                this.func_219212_a(chunkPosIn, chunkHolderIn);
            } else if (this.field_219253_g.remove(chunkPosIn, (Object)chunkHolderIn) && p_219185_5_ != null) {
                if (p_219185_5_ instanceof Chunk) {
                    ((Chunk)p_219185_5_).func_177417_c(false);
                    MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Unload((IChunk)((Chunk)p_219185_5_)));
                }
                this.func_219229_a((IChunk)p_219185_5_);
                if (this.field_219254_h.remove(chunkPosIn) && p_219185_5_ instanceof Chunk) {
                    Chunk chunk = (Chunk)p_219185_5_;
                    this.field_219255_i.func_217466_a(chunk);
                }
                this.field_219256_j.func_215581_a(p_219185_5_.func_76632_l());
                this.field_219256_j.func_215588_z_();
                this.field_219266_t.func_219508_a(p_219185_5_.func_76632_l(), (ChunkStatus)null);
            }
        }, this.field_223181_A::add)).whenComplete((p_223171_1_, p_223171_2_) -> {
            if (p_223171_2_ != null) {
                field_219250_d.error("Failed to save chunk " + chunkHolderIn.func_219277_h(), p_223171_2_);
            }
        });
    }

    protected boolean func_219245_b() {
        if (!this.field_219262_p) {
            return false;
        }
        this.field_219252_f = this.field_219251_e.clone();
        this.field_219262_p = false;
        return true;
    }

    public CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_219244_a(ChunkHolder p_219244_1_, ChunkStatus p_219244_2_) {
        ChunkPos chunkpos = p_219244_1_.func_219277_h();
        if (p_219244_2_ == ChunkStatus.field_223226_a_) {
            return this.func_223172_f(chunkpos);
        }
        CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> completablefuture = p_219244_1_.func_219276_a(p_219244_2_.func_222593_e(), this);
        return completablefuture.thenComposeAsync(p_223180_4_ -> {
            IChunk ichunk;
            Optional optional = p_223180_4_.left();
            if (!optional.isPresent()) {
                return CompletableFuture.completedFuture(p_223180_4_);
            }
            if (p_219244_2_ == ChunkStatus.field_222614_j) {
                this.field_219267_u.func_219356_a(TicketType.field_219492_e, chunkpos, 33 + ChunkStatus.func_222599_a(ChunkStatus.field_222613_i), chunkpos);
            }
            if ((ichunk = (IChunk)optional.get()).func_201589_g().func_209003_a(p_219244_2_)) {
                CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> completablefuture1 = p_219244_2_ == ChunkStatus.field_222614_j ? this.func_223156_b(p_219244_1_, p_219244_2_) : p_219244_2_.func_223201_a(this.field_219255_i, this.field_219269_w, this.field_219256_j, p_223175_2_ -> this.func_219200_b(p_219244_1_), ichunk);
                this.field_219266_t.func_219508_a(chunkpos, p_219244_2_);
                return completablefuture1;
            }
            return this.func_223156_b(p_219244_1_, p_219244_2_);
        }, (Executor)this.field_219257_k);
    }

    private CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_223172_f(ChunkPos p_223172_1_) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.field_219255_i.func_217381_Z().func_230035_c_("chunkLoad");
                CompoundNBT compoundnbt = this.func_219178_f(p_223172_1_);
                if (compoundnbt != null) {
                    boolean flag;
                    boolean bl = flag = compoundnbt.func_150297_b("Level", 10) && compoundnbt.func_74775_l("Level").func_150297_b("Status", 8);
                    if (flag) {
                        ChunkPrimer ichunk = ChunkSerializer.func_222656_a(this.field_219255_i, this.field_219269_w, this.field_219260_n, p_223172_1_, compoundnbt);
                        ichunk.func_177432_b(this.field_219255_i.func_82737_E());
                        MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Load((IChunk)ichunk));
                        return Either.left((Object)ichunk);
                    }
                    field_219250_d.error("Chunk file at {} is missing level data, skipping", (Object)p_223172_1_);
                }
            }
            catch (ReportedException reportedexception) {
                Throwable throwable = reportedexception.getCause();
                if (!(throwable instanceof IOException)) {
                    throw reportedexception;
                }
                field_219250_d.error("Couldn't load chunk {}", (Object)p_223172_1_, (Object)throwable);
            }
            catch (Exception exception) {
                field_219250_d.error("Couldn't load chunk {}", (Object)p_223172_1_, (Object)exception);
            }
            return Either.left((Object)new ChunkPrimer(p_223172_1_, UpgradeData.field_196994_a));
        }, this.field_219257_k);
    }

    private CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_223156_b(ChunkHolder p_223156_1_, ChunkStatus p_223156_2_) {
        ChunkPos chunkpos = p_223156_1_.func_219277_h();
        CompletableFuture<Either<List<IChunk>, ChunkHolder.IChunkLoadingError>> completablefuture = this.func_219236_a(chunkpos, p_223156_2_.func_202128_c(), p_219195_2_ -> this.func_219205_a(p_223156_2_, p_219195_2_));
        this.field_219255_i.func_217381_Z().func_230036_c_(() -> "chunkGenerate " + p_223156_2_.func_222596_d());
        return completablefuture.thenComposeAsync(p_219235_4_ -> (CompletionStage)p_219235_4_.map(p_223148_4_ -> {
            try {
                CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> completablefuture1 = p_223156_2_.func_223198_a(this.field_219255_i, this.field_219258_l, this.field_219269_w, this.field_219256_j, p_222954_2_ -> this.func_219200_b(p_223156_1_), (List<IChunk>)p_223148_4_);
                this.field_219266_t.func_219508_a(chunkpos, p_223156_2_);
                return completablefuture1;
            }
            catch (Exception exception) {
                CrashReport crashreport = CrashReport.func_85055_a(exception, "Exception generating new chunk");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Chunk to be generated");
                crashreportcategory.func_71507_a("Location", String.format("%d,%d", chunkpos.field_77276_a, chunkpos.field_77275_b));
                crashreportcategory.func_71507_a("Position hash", ChunkPos.func_77272_a((int)chunkpos.field_77276_a, (int)chunkpos.field_77275_b));
                crashreportcategory.func_71507_a("Generator", this.field_219258_l);
                throw new ReportedException(crashreport);
            }
        }, p_219211_2_ -> {
            this.func_219209_c(chunkpos);
            return CompletableFuture.completedFuture(Either.right((Object)p_219211_2_));
        }), p_219216_2_ -> this.field_219264_r.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219081_a((ChunkHolder)p_223156_1_, (Runnable)p_219216_2_)));
    }

    protected void func_219209_c(ChunkPos p_219209_1_) {
        this.field_219257_k.func_212871_a_(Util.func_215075_a(() -> this.field_219267_u.func_219345_b(TicketType.field_219492_e, p_219209_1_, 33 + ChunkStatus.func_222599_a(ChunkStatus.field_222613_i), p_219209_1_), () -> "release light ticket " + p_219209_1_));
    }

    private ChunkStatus func_219205_a(ChunkStatus p_219205_1_, int p_219205_2_) {
        ChunkStatus chunkstatus = p_219205_2_ == 0 ? p_219205_1_.func_222593_e() : ChunkStatus.func_222581_a(ChunkStatus.func_222599_a(p_219205_1_) + p_219205_2_);
        return chunkstatus;
    }

    private CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_219200_b(ChunkHolder p_219200_1_) {
        CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> completablefuture = p_219200_1_.func_219301_a(ChunkStatus.field_222617_m.func_222593_e());
        return completablefuture.thenApplyAsync(p_219193_2_ -> {
            ChunkStatus chunkstatus = ChunkHolder.func_219278_b(p_219200_1_.func_219299_i());
            return !chunkstatus.func_209003_a(ChunkStatus.field_222617_m) ? ChunkHolder.field_219306_a : p_219193_2_.mapLeft(p_219237_2_ -> {
                Chunk chunk;
                ChunkPos chunkpos = p_219200_1_.func_219277_h();
                if (p_219237_2_ instanceof ChunkPrimerWrapper) {
                    chunk = ((ChunkPrimerWrapper)p_219237_2_).func_217336_u();
                } else {
                    chunk = new Chunk(this.field_219255_i, (ChunkPrimer)p_219237_2_);
                    p_219200_1_.func_219294_a(new ChunkPrimerWrapper(chunk));
                }
                chunk.func_217314_a(() -> ChunkHolder.func_219286_c(p_219200_1_.func_219299_i()));
                chunk.func_217318_w();
                if (this.field_219254_h.add(chunkpos.func_201841_a())) {
                    chunk.func_177417_c(true);
                    this.field_219255_i.func_147448_a(chunk.func_177434_r().values());
                    Iterable list = null;
                    ClassInheritanceMultiMap<Entity>[] aclassinheritancemultimap = chunk.func_177429_s();
                    int i = aclassinheritancemultimap.length;
                    for (int j = 0; j < i; ++j) {
                        for (Entity entity : aclassinheritancemultimap[j]) {
                            if (entity instanceof PlayerEntity || this.field_219255_i.func_217440_f(entity)) continue;
                            if (list == null) {
                                list = Lists.newArrayList((Object[])new Entity[]{entity});
                                continue;
                            }
                            list.add(entity);
                        }
                    }
                    if (list != null) {
                        list.forEach(chunk::func_76622_b);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Load((IChunk)chunk));
                }
                return chunk;
            });
        }, p_219228_2_ -> this.field_219265_s.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219069_a((Runnable)p_219228_2_, (long)p_219200_1_.func_219277_h().func_201841_a(), p_219200_1_::func_219299_i)));
    }

    public CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>> func_219179_a(ChunkHolder p_219179_1_) {
        ChunkPos chunkpos = p_219179_1_.func_219277_h();
        CompletableFuture<Either<List<IChunk>, ChunkHolder.IChunkLoadingError>> completablefuture = this.func_219236_a(chunkpos, 1, p_219172_0_ -> ChunkStatus.field_222617_m);
        CompletionStage completablefuture1 = completablefuture.thenApplyAsync(p_219239_0_ -> p_219239_0_.flatMap(p_219208_0_ -> {
            Chunk chunk = (Chunk)p_219208_0_.get(p_219208_0_.size() / 2);
            chunk.func_201595_A();
            return Either.left((Object)chunk);
        }), p_219230_2_ -> this.field_219265_s.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219081_a((ChunkHolder)p_219179_1_, (Runnable)p_219230_2_)));
        ((CompletableFuture)completablefuture1).thenAcceptAsync(p_219176_2_ -> p_219176_2_.mapLeft(p_219196_2_ -> {
            this.field_219268_v.getAndIncrement();
            IPacket[] ipacket = new IPacket[2];
            this.func_219097_a(chunkpos, false).forEach(p_219233_3_ -> this.func_219180_a((ServerPlayerEntity)((Object)((Object)((Object)p_219233_3_))), (IPacket<?>[])ipacket, (Chunk)p_219196_2_));
            return Either.left((Object)p_219196_2_);
        }), p_219202_2_ -> this.field_219265_s.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219081_a((ChunkHolder)p_219179_1_, (Runnable)p_219202_2_)));
        return completablefuture1;
    }

    public CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>> func_222961_b(ChunkHolder p_222961_1_) {
        return p_222961_1_.func_219276_a(ChunkStatus.field_222617_m, this).thenApplyAsync(p_222976_0_ -> p_222976_0_.mapLeft(p_222955_0_ -> {
            Chunk chunk = (Chunk)p_222955_0_;
            chunk.func_222879_B();
            return chunk;
        }), p_222962_2_ -> this.field_219265_s.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219081_a((ChunkHolder)p_222961_1_, (Runnable)p_222962_2_)));
    }

    public int func_219174_c() {
        return this.field_219268_v.get();
    }

    private boolean func_219229_a(IChunk chunkIn) {
        this.field_219260_n.func_219112_a(chunkIn.func_76632_l());
        if (!chunkIn.func_201593_f()) {
            return false;
        }
        try {
            this.field_219255_i.func_217437_v();
        }
        catch (SessionLockException sessionlockexception) {
            field_219250_d.error("Couldn't save chunk; already in use by another instance of Minecraft?", (Throwable)sessionlockexception);
            return false;
        }
        chunkIn.func_177432_b(this.field_219255_i.func_82737_E());
        chunkIn.func_177427_f(false);
        ChunkPos chunkpos = chunkIn.func_76632_l();
        try {
            ChunkStatus chunkstatus = chunkIn.func_201589_g();
            if (chunkstatus.func_202129_d() != ChunkStatus.Type.LEVELCHUNK) {
                CompoundNBT compoundnbt = this.func_219178_f(chunkpos);
                if (compoundnbt != null && ChunkSerializer.func_222651_a(compoundnbt) == ChunkStatus.Type.LEVELCHUNK) {
                    return false;
                }
                if (chunkstatus == ChunkStatus.field_223226_a_ && chunkIn.func_201609_c().values().stream().noneMatch(StructureStart::func_75069_d)) {
                    return false;
                }
            }
            this.field_219255_i.func_217381_Z().func_230035_c_("chunkSave");
            CompoundNBT compoundnbt1 = ChunkSerializer.func_222645_a(this.field_219255_i, chunkIn);
            MinecraftForge.EVENT_BUS.post((Event)new ChunkDataEvent.Save(chunkIn, compoundnbt1));
            this.func_219100_a(chunkpos, compoundnbt1);
            return true;
        }
        catch (Exception exception) {
            field_219250_d.error("Failed to save chunk {},{}", (Object)chunkpos.field_77276_a, (Object)chunkpos.field_77275_b, (Object)exception);
            return false;
        }
    }

    protected void func_219175_a(int viewDistance) {
        int i = MathHelper.func_76125_a((int)(viewDistance + 1), (int)3, (int)33);
        if (i != this.field_219247_A) {
            int j = this.field_219247_A;
            this.field_219247_A = i;
            this.field_219267_u.func_219354_b(this.field_219247_A);
            for (ChunkHolder chunkholder : this.field_219251_e.values()) {
                ChunkPos chunkpos = chunkholder.func_219277_h();
                IPacket[] ipacket = new IPacket[2];
                this.func_219097_a(chunkpos, false).forEach(p_219224_4_ -> {
                    int k = ChunkManager.func_219215_b(chunkpos, p_219224_4_, true);
                    boolean flag = k <= j;
                    boolean flag1 = k <= this.field_219247_A;
                    this.func_219199_a((ServerPlayerEntity)((Object)p_219224_4_), chunkpos, (IPacket<?>[])ipacket, flag, flag1);
                });
            }
        }
    }

    protected void func_219199_a(ServerPlayerEntity player, ChunkPos chunkPosIn, IPacket<?>[] packetCache, boolean wasLoaded, boolean load) {
        if (player.field_70170_p == this.field_219255_i) {
            ChunkHolder chunkholder;
            if (load && !wasLoaded && (chunkholder = this.func_219219_b(chunkPosIn.func_201841_a())) != null) {
                Chunk chunk = chunkholder.func_219298_c();
                if (chunk != null) {
                    this.func_219180_a(player, packetCache, chunk);
                }
                DebugPacketSender.func_218802_a((ServerWorld)this.field_219255_i, (ChunkPos)chunkPosIn);
            }
            if (!load && wasLoaded) {
                player.func_213845_a(chunkPosIn);
            }
        }
    }

    public int func_219194_d() {
        return this.field_219252_f.size();
    }

    protected ProxyTicketManager func_219246_e() {
        return this.field_219267_u;
    }

    protected Iterable<ChunkHolder> func_223491_f() {
        return Iterables.unmodifiableIterable((Iterable)this.field_219252_f.values());
    }

    void func_225406_a(Writer p_225406_1_) throws IOException {
        CSVWriter csvwriter = CSVWriter.func_225428_a().func_225423_a("x").func_225423_a("z").func_225423_a("level").func_225423_a("in_memory").func_225423_a("status").func_225423_a("full_status").func_225423_a("accessible_ready").func_225423_a("ticking_ready").func_225423_a("entity_ticking_ready").func_225423_a("ticket").func_225423_a("spawning").func_225423_a("entity_count").func_225423_a("block_entity_count").func_225422_a(p_225406_1_);
        for (Long2ObjectMap.Entry entry : this.field_219252_f.long2ObjectEntrySet()) {
            ChunkPos chunkpos = new ChunkPos(entry.getLongKey());
            ChunkHolder chunkholder = (ChunkHolder)entry.getValue();
            Optional<IChunk> optional = Optional.ofNullable(chunkholder.func_219287_e());
            Optional<Object> optional1 = optional.flatMap(p_225407_0_ -> p_225407_0_ instanceof Chunk ? Optional.of((Chunk)p_225407_0_) : Optional.empty());
            csvwriter.func_225426_a(new Object[]{chunkpos.field_77276_a, chunkpos.field_77275_b, chunkholder.func_219299_i(), optional.isPresent(), optional.map(IChunk::func_201589_g).orElse(null), optional1.map(Chunk::func_217321_u).orElse(null), ChunkManager.func_225402_a(chunkholder.func_223492_c()), ChunkManager.func_225402_a(chunkholder.func_219296_a()), ChunkManager.func_225402_a(chunkholder.func_219297_b()), this.field_219267_u.func_225413_c(entry.getLongKey()), !this.func_219243_d(chunkpos), optional1.map(p_225401_0_ -> Stream.of(p_225401_0_.func_177429_s()).mapToInt(ClassInheritanceMultiMap::size).sum()).orElse(0), optional1.map(p_225405_0_ -> p_225405_0_.func_177434_r().size()).orElse(0)});
        }
    }

    private static String func_225402_a(CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>> p_225402_0_) {
        try {
            Either<Chunk, ChunkHolder.IChunkLoadingError> either = p_225402_0_.getNow((Either<Chunk, ChunkHolder.IChunkLoadingError>)((Either)null));
            return either != null ? (String)either.map(p_225408_0_ -> "done", p_225400_0_ -> "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException var3) {
            return "cancelled";
        }
    }

    @Nullable
    private CompoundNBT func_219178_f(ChunkPos pos) throws IOException {
        CompoundNBT compoundnbt = this.func_227078_e_(pos);
        return compoundnbt == null ? null : this.func_219166_a(this.field_219255_i.func_201675_m().func_186058_p(), this.field_219259_m, compoundnbt);
    }

    boolean func_219243_d(ChunkPos chunkPosIn) {
        long i = chunkPosIn.func_201841_a();
        return !this.field_219267_u.func_223494_d(i) ? true : this.field_219271_y.func_219444_a(i).noneMatch(p_219201_1_ -> !p_219201_1_.func_175149_v() && ChunkManager.func_219217_a(chunkPosIn, p_219201_1_) < 16384.0);
    }

    private boolean func_219187_b(ServerPlayerEntity player) {
        return player.func_175149_v() && !this.field_219255_i.func_82736_K().func_223586_b(GameRules.field_223613_p);
    }

    void func_219234_a(ServerPlayerEntity player, boolean track) {
        boolean flag = this.func_219187_b(player);
        boolean flag1 = this.field_219271_y.func_219448_c(player);
        int i = MathHelper.func_76128_c((double)player.func_226277_ct_()) >> 4;
        int j = MathHelper.func_76128_c((double)player.func_226281_cx_()) >> 4;
        if (track) {
            this.field_219271_y.func_219442_a(ChunkPos.func_77272_a((int)i, (int)j), player, flag);
            this.func_223489_c(player);
            if (!flag) {
                this.field_219267_u.func_219341_a(SectionPos.func_218157_a((Entity)player), player);
            }
        } else {
            SectionPos sectionpos = player.func_213842_M();
            this.field_219271_y.func_219443_a(sectionpos.func_218155_u().func_201841_a(), player);
            if (!flag1) {
                this.field_219267_u.func_219367_b(sectionpos, player);
            }
        }
        for (int l = i - this.field_219247_A; l <= i + this.field_219247_A; ++l) {
            for (int k = j - this.field_219247_A; k <= j + this.field_219247_A; ++k) {
                ChunkPos chunkpos = new ChunkPos(l, k);
                ForgeEventFactory.fireChunkWatch((boolean)track, (ServerPlayerEntity)player, (ChunkPos)chunkpos, (ServerWorld)this.field_219255_i);
                this.func_219199_a(player, chunkpos, new IPacket[2], !track, track);
            }
        }
    }

    private SectionPos func_223489_c(ServerPlayerEntity p_223489_1_) {
        SectionPos sectionpos = SectionPos.func_218157_a((Entity)p_223489_1_);
        p_223489_1_.func_213850_a(sectionpos);
        p_223489_1_.field_71135_a.func_147359_a((IPacket<?>)new SUpdateChunkPositionPacket(sectionpos.func_218149_a(), sectionpos.func_218148_c()));
        return sectionpos;
    }

    public void func_219183_a(ServerPlayerEntity player) {
        boolean flag2;
        for (EntityTracker chunkmanager$entitytracker : this.field_219272_z.values()) {
            if (chunkmanager$entitytracker.field_219403_c == player) {
                chunkmanager$entitytracker.func_219397_a(this.field_219255_i.func_217369_A());
                continue;
            }
            chunkmanager$entitytracker.func_219400_b(player);
        }
        int l1 = MathHelper.func_76128_c((double)player.func_226277_ct_()) >> 4;
        int i2 = MathHelper.func_76128_c((double)player.func_226281_cx_()) >> 4;
        SectionPos sectionpos = player.func_213842_M();
        SectionPos sectionpos1 = SectionPos.func_218157_a((Entity)player);
        long i = sectionpos.func_218155_u().func_201841_a();
        long j = sectionpos1.func_218155_u().func_201841_a();
        boolean flag = this.field_219271_y.func_225419_d(player);
        boolean flag1 = this.func_219187_b(player);
        boolean bl = flag2 = sectionpos.func_218146_v() != sectionpos1.func_218146_v();
        if (flag2 || flag != flag1) {
            this.func_223489_c(player);
            if (!flag) {
                this.field_219267_u.func_219367_b(sectionpos, player);
            }
            if (!flag1) {
                this.field_219267_u.func_219341_a(sectionpos1, player);
            }
            if (!flag && flag1) {
                this.field_219271_y.func_219446_a(player);
            }
            if (flag && !flag1) {
                this.field_219271_y.func_219447_b(player);
            }
            if (i != j) {
                this.field_219271_y.func_219445_a(i, j, player);
            }
        }
        int k = sectionpos.func_218149_a();
        int l = sectionpos.func_218148_c();
        if (Math.abs(k - l1) <= this.field_219247_A * 2 && Math.abs(l - i2) <= this.field_219247_A * 2) {
            int k2 = Math.min(l1, k) - this.field_219247_A;
            int i3 = Math.min(i2, l) - this.field_219247_A;
            int j3 = Math.max(l1, k) + this.field_219247_A;
            int k3 = Math.max(i2, l) + this.field_219247_A;
            for (int l3 = k2; l3 <= j3; ++l3) {
                for (int k1 = i3; k1 <= k3; ++k1) {
                    ChunkPos chunkpos1 = new ChunkPos(l3, k1);
                    boolean flag5 = ChunkManager.func_219232_a(chunkpos1, k, l) <= this.field_219247_A;
                    boolean flag6 = ChunkManager.func_219232_a(chunkpos1, l1, i2) <= this.field_219247_A;
                    this.func_219199_a(player, chunkpos1, new IPacket[2], flag5, flag6);
                }
            }
        } else {
            for (int i1 = k - this.field_219247_A; i1 <= k + this.field_219247_A; ++i1) {
                for (int j1 = l - this.field_219247_A; j1 <= l + this.field_219247_A; ++j1) {
                    ChunkPos chunkpos = new ChunkPos(i1, j1);
                    boolean flag3 = true;
                    boolean flag4 = false;
                    this.func_219199_a(player, chunkpos, new IPacket[2], true, false);
                }
            }
            for (int j2 = l1 - this.field_219247_A; j2 <= l1 + this.field_219247_A; ++j2) {
                for (int l2 = i2 - this.field_219247_A; l2 <= i2 + this.field_219247_A; ++l2) {
                    ChunkPos chunkpos2 = new ChunkPos(j2, l2);
                    boolean flag7 = false;
                    boolean flag8 = true;
                    this.func_219199_a(player, chunkpos2, new IPacket[2], false, true);
                }
            }
        }
    }

    @Override
    public Stream<ServerPlayerEntity> func_219097_a(ChunkPos pos, boolean boundaryOnly) {
        return this.field_219271_y.func_219444_a(pos.func_201841_a()).filter(p_219192_3_ -> {
            int i = ChunkManager.func_219215_b(pos, p_219192_3_, true);
            if (i > this.field_219247_A) {
                return false;
            }
            return !boundaryOnly || i == this.field_219247_A;
        });
    }

    protected void func_219210_a(Entity entityIn) {
        if (!(entityIn instanceof EnderDragonPartEntity) && !(entityIn instanceof LightningBoltEntity)) {
            EntityType<?> entitytype = entityIn.func_200600_R();
            int i = entitytype.func_220345_k() * 16;
            int j = entitytype.func_220332_l();
            if (this.field_219272_z.containsKey(entityIn.func_145782_y())) {
                throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("Entity is already tracked!"));
            }
            EntityTracker chunkmanager$entitytracker = new EntityTracker(entityIn, i, j, entitytype.func_220340_m());
            this.field_219272_z.put(entityIn.func_145782_y(), (Object)chunkmanager$entitytracker);
            chunkmanager$entitytracker.func_219397_a(this.field_219255_i.func_217369_A());
            if (entityIn instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)entityIn;
                this.func_219234_a(serverplayerentity, true);
                for (EntityTracker chunkmanager$entitytracker1 : this.field_219272_z.values()) {
                    if (chunkmanager$entitytracker1.field_219403_c == serverplayerentity) continue;
                    chunkmanager$entitytracker1.func_219400_b(serverplayerentity);
                }
            }
        }
    }

    protected void func_219231_b(Entity p_219231_1_) {
        EntityTracker chunkmanager$entitytracker1;
        if (p_219231_1_ instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)p_219231_1_;
            this.func_219234_a(serverplayerentity, false);
            for (EntityTracker chunkmanager$entitytracker : this.field_219272_z.values()) {
                chunkmanager$entitytracker.func_219399_a(serverplayerentity);
            }
        }
        if ((chunkmanager$entitytracker1 = (EntityTracker)this.field_219272_z.remove(p_219231_1_.func_145782_y())) != null) {
            chunkmanager$entitytracker1.func_219396_a();
        }
    }

    protected void func_219169_g() {
        ArrayList list = Lists.newArrayList();
        List<ServerPlayerEntity> list1 = this.field_219255_i.func_217369_A();
        for (EntityTracker chunkmanager$entitytracker : this.field_219272_z.values()) {
            SectionPos sectionpos1;
            SectionPos sectionpos = chunkmanager$entitytracker.field_219405_e;
            if (!Objects.equals(sectionpos, sectionpos1 = SectionPos.func_218157_a((Entity)chunkmanager$entitytracker.field_219403_c))) {
                chunkmanager$entitytracker.func_219397_a(list1);
                Entity entity = chunkmanager$entitytracker.field_219403_c;
                if (entity instanceof ServerPlayerEntity) {
                    list.add((ServerPlayerEntity)entity);
                }
                chunkmanager$entitytracker.field_219405_e = sectionpos1;
            }
            chunkmanager$entitytracker.field_219402_b.func_219453_a();
        }
        if (!list.isEmpty()) {
            for (EntityTracker chunkmanager$entitytracker1 : this.field_219272_z.values()) {
                chunkmanager$entitytracker1.func_219397_a(list);
            }
        }
    }

    protected void func_219222_a(Entity p_219222_1_, IPacket<?> p_219222_2_) {
        EntityTracker chunkmanager$entitytracker = (EntityTracker)this.field_219272_z.get(p_219222_1_.func_145782_y());
        if (chunkmanager$entitytracker != null) {
            chunkmanager$entitytracker.func_219391_a(p_219222_2_);
        }
    }

    protected void func_219225_b(Entity p_219225_1_, IPacket<?> p_219225_2_) {
        EntityTracker chunkmanager$entitytracker = (EntityTracker)this.field_219272_z.get(p_219225_1_.func_145782_y());
        if (chunkmanager$entitytracker != null) {
            chunkmanager$entitytracker.func_219392_b(p_219225_2_);
        }
    }

    private void func_219180_a(ServerPlayerEntity player, IPacket<?>[] packetCache, Chunk chunkIn) {
        if (packetCache[0] == null) {
            packetCache[0] = new SChunkDataPacket(chunkIn, 65535);
            packetCache[1] = new SUpdateLightPacket(chunkIn.func_76632_l(), (WorldLightManager)this.field_219256_j);
        }
        player.func_213844_a(chunkIn.func_76632_l(), packetCache[0], packetCache[1]);
        DebugPacketSender.func_218802_a((ServerWorld)this.field_219255_i, (ChunkPos)chunkIn.func_76632_l());
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (EntityTracker chunkmanager$entitytracker : this.field_219272_z.values()) {
            Entity entity = chunkmanager$entitytracker.field_219403_c;
            if (entity == player || entity.field_70176_ah != chunkIn.func_76632_l().field_77276_a || entity.field_70164_aj != chunkIn.func_76632_l().field_77275_b) continue;
            chunkmanager$entitytracker.func_219400_b(player);
            if (entity instanceof MobEntity && ((MobEntity)entity).func_110166_bE() != null) {
                list.add(entity);
            }
            if (entity.func_184188_bt().isEmpty()) continue;
            list1.add(entity);
        }
        if (!list.isEmpty()) {
            for (Entity entity1 : list) {
                player.field_71135_a.func_147359_a((IPacket<?>)new SMountEntityPacket(entity1, ((MobEntity)entity1).func_110166_bE()));
            }
        }
        if (!list1.isEmpty()) {
            for (Entity entity2 : list1) {
                player.field_71135_a.func_147359_a((IPacket<?>)new SSetPassengersPacket(entity2));
            }
        }
    }

    protected PointOfInterestManager func_219189_h() {
        return this.field_219260_n;
    }

    public CompletableFuture<Void> func_222973_a(Chunk p_222973_1_) {
        return this.field_219257_k.func_222817_e(() -> p_222973_1_.func_222880_a(this.field_219255_i));
    }

    class ProxyTicketManager
    extends TicketManager {
        protected ProxyTicketManager(Executor p_i50469_2_, Executor p_i50469_3_) {
            super(p_i50469_2_, p_i50469_3_);
        }

        protected boolean func_219371_a(long p_219371_1_) {
            return ChunkManager.this.field_219261_o.contains(p_219371_1_);
        }

        @Nullable
        protected ChunkHolder func_219335_b(long p_219335_1_) {
            return ChunkManager.this.func_219220_a(p_219335_1_);
        }

        @Nullable
        protected ChunkHolder func_219372_a(long p_219372_1_, int p_219372_3_, @Nullable ChunkHolder p_219372_4_, int p_219372_5_) {
            return ChunkManager.this.func_219213_a(p_219372_1_, p_219372_3_, p_219372_4_, p_219372_5_);
        }
    }

    class EntityTracker {
        private final TrackedEntity field_219402_b;
        private final Entity field_219403_c;
        private final int field_219404_d;
        private SectionPos field_219405_e;
        private final Set<ServerPlayerEntity> field_219406_f = Sets.newHashSet();

        public EntityTracker(Entity p_i50468_2_, int p_i50468_3_, int p_i50468_4_, boolean p_i50468_5_) {
            this.field_219402_b = new TrackedEntity(ChunkManager.this.field_219255_i, p_i50468_2_, p_i50468_4_, p_i50468_5_, this::func_219391_a);
            this.field_219403_c = p_i50468_2_;
            this.field_219404_d = p_i50468_3_;
            this.field_219405_e = SectionPos.func_218157_a((Entity)p_i50468_2_);
        }

        public boolean equals(Object p_equals_1_) {
            if (p_equals_1_ instanceof EntityTracker) {
                return ((EntityTracker)p_equals_1_).field_219403_c.func_145782_y() == this.field_219403_c.func_145782_y();
            }
            return false;
        }

        public int hashCode() {
            return this.field_219403_c.func_145782_y();
        }

        public void func_219391_a(IPacket<?> p_219391_1_) {
            for (ServerPlayerEntity serverplayerentity : this.field_219406_f) {
                serverplayerentity.field_71135_a.func_147359_a(p_219391_1_);
            }
        }

        public void func_219392_b(IPacket<?> p_219392_1_) {
            this.func_219391_a(p_219392_1_);
            if (this.field_219403_c instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)this.field_219403_c).field_71135_a.func_147359_a(p_219392_1_);
            }
        }

        public void func_219396_a() {
            for (ServerPlayerEntity serverplayerentity : this.field_219406_f) {
                this.field_219402_b.func_219454_a(serverplayerentity);
            }
        }

        public void func_219399_a(ServerPlayerEntity p_219399_1_) {
            if (this.field_219406_f.remove((Object)p_219399_1_)) {
                this.field_219402_b.func_219454_a(p_219399_1_);
            }
        }

        public void func_219400_b(ServerPlayerEntity p_219400_1_) {
            if (p_219400_1_ != this.field_219403_c) {
                boolean flag;
                Vec3d vec3d = p_219400_1_.func_213303_ch().func_178788_d(this.field_219402_b.func_219456_b());
                int i = Math.min(this.func_229843_b_(), (ChunkManager.this.field_219247_A - 1) * 16);
                boolean bl = flag = vec3d.field_72450_a >= (double)(-i) && vec3d.field_72450_a <= (double)i && vec3d.field_72449_c >= (double)(-i) && vec3d.field_72449_c <= (double)i && this.field_219403_c.func_174827_a(p_219400_1_);
                if (flag) {
                    ChunkPos chunkpos;
                    ChunkHolder chunkholder;
                    boolean flag1 = this.field_219403_c.field_98038_p;
                    if (!flag1 && (chunkholder = ChunkManager.this.func_219219_b((chunkpos = new ChunkPos(this.field_219403_c.field_70176_ah, this.field_219403_c.field_70164_aj)).func_201841_a())) != null && chunkholder.func_219298_c() != null) {
                        boolean bl2 = flag1 = ChunkManager.func_219215_b(chunkpos, p_219400_1_, false) <= ChunkManager.this.field_219247_A;
                    }
                    if (flag1 && this.field_219406_f.add(p_219400_1_)) {
                        this.field_219402_b.func_219455_b(p_219400_1_);
                    }
                } else if (this.field_219406_f.remove((Object)p_219400_1_)) {
                    this.field_219402_b.func_219454_a(p_219400_1_);
                }
            }
        }

        private int func_229843_b_() {
            Collection<Entity> collection = this.field_219403_c.func_184182_bu();
            int i = this.field_219404_d;
            for (Entity entity : collection) {
                int j = entity.func_200600_R().func_220345_k() * 16;
                if (j <= i) continue;
                i = j;
            }
            return i;
        }

        public void func_219397_a(List<ServerPlayerEntity> p_219397_1_) {
            for (ServerPlayerEntity serverplayerentity : p_219397_1_) {
                this.func_219400_b(serverplayerentity);
            }
        }
    }
}

