/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.spawner;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class WorldEntitySpawner {
    private static final Logger field_209383_a = LogManager.getLogger();

    public static void func_226701_a_(EntityClassification p_226701_0_, ServerWorld p_226701_1_, Chunk p_226701_2_, BlockPos p_226701_3_) {
        BlockState blockstate;
        ChunkGenerator chunkgenerator = p_226701_1_.func_72863_F().func_201711_g();
        int i = 0;
        BlockPos blockpos = WorldEntitySpawner.func_222262_a(p_226701_1_, p_226701_2_);
        int j = blockpos.func_177958_n();
        int k = blockpos.func_177956_o();
        int l = blockpos.func_177952_p();
        if (k >= 1 && !(blockstate = p_226701_2_.func_180495_p(blockpos)).func_215686_e(p_226701_2_, blockpos)) {
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            block2: for (int i1 = 0; i1 < 3; ++i1) {
                int j1 = j;
                int k1 = l;
                int l1 = 6;
                Biome.SpawnListEntry biome$spawnlistentry = null;
                ILivingEntityData ilivingentitydata = null;
                int i2 = MathHelper.func_76143_f((double)(Math.random() * 4.0));
                int j2 = 0;
                int k2 = 0;
                while (true) {
                    ChunkPos chunkpos;
                    double d0;
                    if (k2 >= i2) continue block2;
                    blockpos$mutable.func_181079_c(j1 += p_226701_1_.field_73012_v.nextInt(6) - p_226701_1_.field_73012_v.nextInt(6), k, k1 += p_226701_1_.field_73012_v.nextInt(6) - p_226701_1_.field_73012_v.nextInt(6));
                    float f = (float)j1 + 0.5f;
                    float f1 = (float)k1 + 0.5f;
                    PlayerEntity playerentity = p_226701_1_.func_217365_a(f, f1, -1.0);
                    if (playerentity != null && !((d0 = playerentity.func_70092_e(f, k, f1)) <= 576.0) && !p_226701_3_.func_218137_a((IPosition)new Vec3d(f, k, f1), 24.0) && (Objects.equals(chunkpos = new ChunkPos((BlockPos)blockpos$mutable), p_226701_2_.func_76632_l()) || p_226701_1_.func_72863_F().func_222865_a(chunkpos))) {
                        EntitySpawnPlacementRegistry.PlacementType entityspawnplacementregistry$placementtype;
                        EntityType<?> entitytype;
                        if (biome$spawnlistentry == null) {
                            biome$spawnlistentry = WorldEntitySpawner.getSpawnList(chunkgenerator, p_226701_0_, p_226701_1_.field_73012_v, (BlockPos)blockpos$mutable, (World)p_226701_1_);
                            if (biome$spawnlistentry == null) continue block2;
                            i2 = biome$spawnlistentry.field_76301_c + p_226701_1_.field_73012_v.nextInt(1 + biome$spawnlistentry.field_76299_d - biome$spawnlistentry.field_76301_c);
                        }
                        if (biome$spawnlistentry.field_200702_b.func_220339_d() != EntityClassification.MISC && (biome$spawnlistentry.field_200702_b.func_225437_d() || !(d0 > 16384.0)) && (entitytype = biome$spawnlistentry.field_200702_b).func_200720_b() && WorldEntitySpawner.getSpawnList(chunkgenerator, p_226701_0_, biome$spawnlistentry, (BlockPos)blockpos$mutable, (World)p_226701_1_) && WorldEntitySpawner.func_209382_a(entityspawnplacementregistry$placementtype = EntitySpawnPlacementRegistry.func_209344_a(entitytype), p_226701_1_, (BlockPos)blockpos$mutable, entitytype) && EntitySpawnPlacementRegistry.func_223515_a(entitytype, p_226701_1_, SpawnReason.NATURAL, (BlockPos)blockpos$mutable, p_226701_1_.field_73012_v) && p_226701_1_.func_226664_a_(entitytype.func_220328_a(f, k, f1))) {
                            MobEntity mobentity;
                            try {
                                Object entity = entitytype.func_200721_a(p_226701_1_);
                                if (!(entity instanceof MobEntity)) {
                                    throw new IllegalStateException("Trying to spawn a non-mob: " + Registry.field_212629_r.func_177774_c(entitytype));
                                }
                                mobentity = (MobEntity)((Object)entity);
                            }
                            catch (Exception exception) {
                                field_209383_a.warn("Failed to create mob", (Throwable)exception);
                                return;
                            }
                            mobentity.func_70012_b(f, k, f1, p_226701_1_.field_73012_v.nextFloat() * 360.0f, 0.0f);
                            int canSpawn = ForgeHooks.canEntitySpawn((MobEntity)mobentity, (IWorld)p_226701_1_, (double)f, (double)k, (double)f1, null, (SpawnReason)SpawnReason.NATURAL);
                            if (canSpawn != -1 && (canSpawn != 0 || (!(d0 > 16384.0) || !mobentity.func_213397_c(d0)) && mobentity.func_213380_a(p_226701_1_, SpawnReason.NATURAL) && mobentity.func_205019_a(p_226701_1_))) {
                                if (!ForgeEventFactory.doSpecialSpawn((MobEntity)mobentity, (World)p_226701_1_, (float)f, (float)k, (float)f1, null, (SpawnReason)SpawnReason.NATURAL)) {
                                    ilivingentitydata = mobentity.func_213386_a(p_226701_1_, p_226701_1_.func_175649_E(new BlockPos((Entity)mobentity)), SpawnReason.NATURAL, ilivingentitydata, null);
                                }
                                ++j2;
                                p_226701_1_.func_217376_c(mobentity);
                                if (++i >= ForgeEventFactory.getMaxSpawnPackSize((MobEntity)mobentity)) {
                                    return;
                                }
                                if (mobentity.func_204209_c(j2)) {
                                    continue block2;
                                }
                            }
                        }
                    }
                    ++k2;
                }
            }
        }
    }

    @Nullable
    private static Biome.SpawnListEntry getSpawnList(ChunkGenerator<?> p_222264_0_, EntityClassification p_222264_1_, Random p_222264_2_, BlockPos p_222264_3_, World world) {
        List list = p_222264_0_.func_177458_a(p_222264_1_, p_222264_3_);
        return (list = ForgeEventFactory.getPotentialSpawns((IWorld)world, (EntityClassification)p_222264_1_, (BlockPos)p_222264_3_, list)).isEmpty() ? null : (Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)p_222264_2_, (List)list);
    }

    private static boolean getSpawnList(ChunkGenerator<?> p_222261_0_, EntityClassification p_222261_1_, Biome.SpawnListEntry p_222261_2_, BlockPos p_222261_3_, World world) {
        List list = p_222261_0_.func_177458_a(p_222261_1_, p_222261_3_);
        return (list = ForgeEventFactory.getPotentialSpawns((IWorld)world, (EntityClassification)p_222261_1_, (BlockPos)p_222261_3_, list)).isEmpty() ? false : list.contains((Object)p_222261_2_);
    }

    private static BlockPos func_222262_a(World p_222262_0_, Chunk p_222262_1_) {
        ChunkPos chunkpos = p_222262_1_.func_76632_l();
        int i = chunkpos.func_180334_c() + p_222262_0_.field_73012_v.nextInt(16);
        int j = chunkpos.func_180333_d() + p_222262_0_.field_73012_v.nextInt(16);
        int k = p_222262_1_.func_201576_a(Heightmap.Type.WORLD_SURFACE, i, j) + 1;
        int l = p_222262_0_.field_73012_v.nextInt(k + 1);
        return new BlockPos(i, l, j);
    }

    public static boolean func_222266_a(IBlockReader p_222266_0_, BlockPos p_222266_1_, BlockState p_222266_2_, IFluidState p_222266_3_) {
        if (p_222266_2_.func_224756_o(p_222266_0_, p_222266_1_)) {
            return false;
        }
        if (p_222266_2_.func_185897_m()) {
            return false;
        }
        if (!p_222266_3_.func_206888_e()) {
            return false;
        }
        return !p_222266_2_.func_203425_a(BlockTags.field_203437_y);
    }

    public static boolean func_209382_a(EntitySpawnPlacementRegistry.PlacementType placeType, IWorldReader worldIn, BlockPos pos, @Nullable EntityType<?> entityTypeIn) {
        if (placeType == EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS) {
            return true;
        }
        if (entityTypeIn != null && worldIn.func_175723_af().func_177746_a(pos)) {
            return placeType.canSpawnAt(worldIn, pos, entityTypeIn);
        }
        return false;
    }

    public static boolean canSpawnAtBody(EntitySpawnPlacementRegistry.PlacementType placeType, IWorldReader worldIn, BlockPos pos, @Nullable EntityType<?> entityTypeIn) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        IFluidState ifluidstate = worldIn.func_204610_c(pos);
        BlockPos blockpos = pos.func_177984_a();
        BlockPos blockpos1 = pos.func_177977_b();
        switch (placeType) {
            case IN_WATER: {
                return ifluidstate.func_206884_a(FluidTags.field_206959_a) && worldIn.func_204610_c(blockpos1).func_206884_a(FluidTags.field_206959_a) && !worldIn.func_180495_p(blockpos).func_215686_e((IBlockReader)((Object)worldIn), blockpos);
            }
        }
        BlockState blockstate1 = worldIn.func_180495_p(blockpos1);
        if (!blockstate1.canCreatureSpawn(worldIn, blockpos1, placeType, entityTypeIn)) {
            return false;
        }
        return WorldEntitySpawner.func_222266_a((IBlockReader)((Object)worldIn), pos, blockstate, ifluidstate) && WorldEntitySpawner.func_222266_a((IBlockReader)((Object)worldIn), blockpos, worldIn.func_180495_p(blockpos), worldIn.func_204610_c(blockpos));
    }

    public static void func_77191_a(IWorld worldIn, Biome biomeIn, int centerX, int centerZ, Random diameterX) {
        List<Biome.SpawnListEntry> list = biomeIn.func_76747_a(EntityClassification.CREATURE);
        if (!list.isEmpty()) {
            int i = centerX << 4;
            int j = centerZ << 4;
            while (diameterX.nextFloat() < biomeIn.func_76741_f()) {
                Biome.SpawnListEntry biome$spawnlistentry = (Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)diameterX, list);
                int k = biome$spawnlistentry.field_76301_c + diameterX.nextInt(1 + biome$spawnlistentry.field_76299_d - biome$spawnlistentry.field_76301_c);
                ILivingEntityData ilivingentitydata = null;
                int l = i + diameterX.nextInt(16);
                int i1 = j + diameterX.nextInt(16);
                int j1 = l;
                int k1 = i1;
                for (int l1 = 0; l1 < k; ++l1) {
                    boolean flag = false;
                    for (int i2 = 0; !flag && i2 < 4; ++i2) {
                        BlockPos blockpos = WorldEntitySpawner.func_208498_a(worldIn, biome$spawnlistentry.field_200702_b, l, i1);
                        if (biome$spawnlistentry.field_200702_b.func_200720_b() && WorldEntitySpawner.func_209382_a(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, worldIn, blockpos, biome$spawnlistentry.field_200702_b)) {
                            Object entity;
                            float f = biome$spawnlistentry.field_200702_b.func_220333_h();
                            double d0 = MathHelper.func_151237_a((double)l, (double)((double)i + (double)f), (double)((double)i + 16.0 - (double)f));
                            double d1 = MathHelper.func_151237_a((double)i1, (double)((double)j + (double)f), (double)((double)j + 16.0 - (double)f));
                            if (!worldIn.func_226664_a_(biome$spawnlistentry.field_200702_b.func_220328_a(d0, blockpos.func_177956_o(), d1)) || !EntitySpawnPlacementRegistry.func_223515_a(biome$spawnlistentry.field_200702_b, worldIn, SpawnReason.CHUNK_GENERATION, new BlockPos(d0, (double)blockpos.func_177956_o(), d1), worldIn.func_201674_k())) continue;
                            try {
                                entity = biome$spawnlistentry.field_200702_b.func_200721_a(worldIn.func_201672_e());
                            }
                            catch (Exception exception) {
                                field_209383_a.warn("Failed to create mob", (Throwable)exception);
                                continue;
                            }
                            ((Entity)((Object)entity)).func_70012_b(d0, blockpos.func_177956_o(), d1, diameterX.nextFloat() * 360.0f, 0.0f);
                            if (entity instanceof MobEntity) {
                                MobEntity mobentity = (MobEntity)((Object)entity);
                                if (ForgeHooks.canEntitySpawn((MobEntity)mobentity, (IWorld)worldIn, (double)d0, (double)blockpos.func_177956_o(), (double)d1, null, (SpawnReason)SpawnReason.CHUNK_GENERATION) == -1) continue;
                                if (mobentity.func_213380_a(worldIn, SpawnReason.CHUNK_GENERATION) && mobentity.func_205019_a(worldIn)) {
                                    ilivingentitydata = mobentity.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos((Entity)mobentity)), SpawnReason.CHUNK_GENERATION, ilivingentitydata, null);
                                    worldIn.func_217376_c(mobentity);
                                    flag = true;
                                }
                            }
                        }
                        l += diameterX.nextInt(5) - diameterX.nextInt(5);
                        i1 += diameterX.nextInt(5) - diameterX.nextInt(5);
                        while (l < i || l >= i + 16 || i1 < j || i1 >= j + 16) {
                            l = j1 + diameterX.nextInt(5) - diameterX.nextInt(5);
                            i1 = k1 + diameterX.nextInt(5) - diameterX.nextInt(5);
                        }
                    }
                }
            }
        }
    }

    private static BlockPos func_208498_a(IWorldReader p_208498_0_, @Nullable EntityType<?> p_208498_1_, int p_208498_2_, int p_208498_3_) {
        BlockPos blockpos = new BlockPos(p_208498_2_, p_208498_0_.func_201676_a(EntitySpawnPlacementRegistry.func_209342_b(p_208498_1_), p_208498_2_, p_208498_3_), p_208498_3_);
        BlockPos blockpos1 = blockpos.func_177977_b();
        return p_208498_0_.func_180495_p(blockpos1).func_196957_g((IBlockReader)((Object)p_208498_0_), blockpos1, PathType.LAND) ? blockpos1 : blockpos;
    }
}

