/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.BinomialRange;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IntClamper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryManager;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootPredicateManager;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.ValidationTracker;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.ForgeHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableManager
extends JsonReloadListener {
    private static final Logger field_186525_a = LogManager.getLogger();
    private static final Gson field_186526_b = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(BinomialRange.class, (Object)new BinomialRange.Serializer()).registerTypeAdapter(ConstantRange.class, (Object)new ConstantRange.Serializer()).registerTypeAdapter(IntClamper.class, (Object)new IntClamper.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntryManager.Serializer()).registerTypeHierarchyAdapter(ILootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(ILootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
    private Map<ResourceLocation, LootTable> field_186527_c = ImmutableMap.of();
    private final LootPredicateManager field_227507_d_;

    public LootTableManager(LootPredicateManager p_i225887_1_) {
        super(field_186526_b, "loot_tables");
        this.field_227507_d_ = p_i225887_1_;
    }

    public LootTable func_186521_a(ResourceLocation ressources) {
        return this.field_186527_c.getOrDefault(ressources, LootTable.field_186464_a);
    }

    protected void func_212853_a_(Map<ResourceLocation, JsonObject> splashList, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        JsonObject jsonobject = splashList.remove(LootTables.field_186419_a);
        if (jsonobject != null) {
            field_186525_a.warn("Datapack tried to redefine {} loot table, ignoring", (Object)LootTables.field_186419_a);
        }
        splashList.forEach((p_223385_1_, p_223385_2_) -> {
            try {
                IResource res = resourceManagerIn.func_199002_a(this.getPreparedPath((ResourceLocation)p_223385_1_));
                LootTable loottable = ForgeHooks.loadLootTable((Gson)field_186526_b, (ResourceLocation)p_223385_1_, (JsonObject)p_223385_2_, (res == null || !res.func_199026_d().equals("Default") ? 1 : 0) != 0, (LootTableManager)this);
                builder.put(p_223385_1_, (Object)loottable);
            }
            catch (Exception exception) {
                field_186525_a.error("Couldn't parse loot table {}", p_223385_1_, (Object)exception);
            }
        });
        builder.put((Object)LootTables.field_186419_a, (Object)LootTable.field_186464_a);
        ImmutableMap immutablemap = builder.build();
        ValidationTracker validationtracker = new ValidationTracker(LootParameterSets.field_216266_g, arg_0 -> ((LootPredicateManager)this.field_227507_d_).func_227517_a_(arg_0), arg_0 -> ((ImmutableMap)immutablemap).get(arg_0));
        immutablemap.forEach((p_227509_1_, p_227509_2_) -> LootTableManager.func_227508_a_(validationtracker, p_227509_1_, p_227509_2_));
        validationtracker.func_227527_a_().forEach((p_215303_0_, p_215303_1_) -> field_186525_a.warn("Found validation problem in " + p_215303_0_ + ": " + p_215303_1_));
        this.field_186527_c = immutablemap;
    }

    public static void func_227508_a_(ValidationTracker p_227508_0_, ResourceLocation p_227508_1_, LootTable p_227508_2_) {
        p_227508_2_.func_227506_a_(p_227508_0_.func_227529_a_(p_227508_2_.func_216122_a()).func_227531_a_("{" + p_227508_1_ + "}", p_227508_1_));
    }

    public static JsonElement func_215301_a(LootTable lootTableIn) {
        return field_186526_b.toJsonTree((Object)lootTableIn);
    }

    public Set<ResourceLocation> func_215304_a() {
        return this.field_186527_c.keySet();
    }
}

