/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.extensions;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.model.pipeline.LightUtil;
import org.lwjgl.system.MemoryStack;

public interface IForgeVertexBuilder {
    default public IVertexBuilder getVertexBuilder() {
        return (IVertexBuilder)this;
    }

    default public void addVertexData(MatrixStack.Entry matrixStack, BakedQuad bakedQuad, float red, float green, float blue, int lightmapCoord, int overlayColor, boolean readExistingColor) {
        this.getVertexBuilder().func_227890_a_(matrixStack, bakedQuad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, red, green, blue, new int[]{lightmapCoord, lightmapCoord, lightmapCoord, lightmapCoord}, overlayColor, readExistingColor);
    }

    default public void addVertexData(MatrixStack.Entry matrixEntry, BakedQuad bakedQuad, float red, float green, float blue, float alpha, int lightmapCoord, int overlayColor) {
        this.addVertexData(matrixEntry, bakedQuad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, red, green, blue, alpha, new int[]{lightmapCoord, lightmapCoord, lightmapCoord, lightmapCoord}, overlayColor, false);
    }

    default public void addVertexData(MatrixStack.Entry matrixEntry, BakedQuad bakedQuad, float red, float green, float blue, float alpha, int lightmapCoord, int overlayColor, boolean readExistingColor) {
        this.addVertexData(matrixEntry, bakedQuad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, red, green, blue, alpha, new int[]{lightmapCoord, lightmapCoord, lightmapCoord, lightmapCoord}, overlayColor, readExistingColor);
    }

    default public void addVertexData(MatrixStack.Entry matrixEntry, BakedQuad bakedQuad, float[] baseBrightness, float red, float green, float blue, float alpha, int[] lightmapCoords, int overlayCoords, boolean readExistingColor) {
        int[] aint = bakedQuad.func_178209_a();
        Vec3i faceNormal = bakedQuad.func_178210_d().func_176730_m();
        Vector3f normal = new Vector3f((float)faceNormal.func_177958_n(), (float)faceNormal.func_177956_o(), (float)faceNormal.func_177952_p());
        Matrix4f matrix4f = matrixEntry.func_227870_a_();
        normal.func_229188_a_(matrixEntry.func_227872_b_());
        int intSize = DefaultVertexFormats.field_176600_a.func_181719_f();
        int vertexCount = aint.length / intSize;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormats.field_176600_a.func_177338_f());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int v = 0; v < vertexCount; ++v) {
                float ca;
                float cb;
                float cg;
                float cr;
                intbuffer.clear();
                intbuffer.put(aint, v * 8, 8);
                float f = bytebuffer.getFloat(0);
                float f1 = bytebuffer.getFloat(4);
                float f2 = bytebuffer.getFloat(8);
                if (readExistingColor) {
                    float r = (float)(bytebuffer.get(12) & 0xFF) / 255.0f;
                    float g = (float)(bytebuffer.get(13) & 0xFF) / 255.0f;
                    float b = (float)(bytebuffer.get(14) & 0xFF) / 255.0f;
                    float a = (float)(bytebuffer.get(15) & 0xFF) / 255.0f;
                    cr = r * baseBrightness[v] * red;
                    cg = g * baseBrightness[v] * green;
                    cb = b * baseBrightness[v] * blue;
                    ca = a * alpha;
                } else {
                    cr = baseBrightness[v] * red;
                    cg = baseBrightness[v] * green;
                    cb = baseBrightness[v] * blue;
                    ca = alpha;
                }
                int lightmapCoord = this.applyBakedLighting(lightmapCoords[v], bytebuffer);
                float f9 = bytebuffer.getFloat(16);
                float f10 = bytebuffer.getFloat(20);
                Vector4f pos = new Vector4f(f, f1, f2, 1.0f);
                pos.func_229372_a_(matrix4f);
                this.applyBakedNormals(normal, bytebuffer, matrixEntry.func_227872_b_());
                ((IVertexBuilder)this).func_225588_a_(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c(), cr, cg, cb, ca, f9, f10, overlayCoords, lightmapCoord, normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c());
            }
        }
    }

    default public int applyBakedLighting(int lightmapCoord, ByteBuffer data) {
        int bl = LightTexture.func_228450_a_((int)lightmapCoord);
        int sl = LightTexture.func_228454_b_((int)lightmapCoord);
        int offset = LightUtil.getLightOffset(0) * 4;
        int blBaked = Short.toUnsignedInt(data.getShort(offset)) >> 4;
        int slBaked = Short.toUnsignedInt(data.getShort(offset + 2)) >> 4;
        bl = Math.max(bl, blBaked);
        sl = Math.max(sl, slBaked);
        return LightTexture.func_228451_a_((int)bl, (int)sl);
    }

    default public void applyBakedNormals(Vector3f generated, ByteBuffer data, Matrix3f normalTransform) {
        byte nx = data.get(28);
        byte ny = data.get(29);
        byte nz = data.get(30);
        if (nx != 0 || ny != 0 || nz != 0) {
            generated.func_195905_a((float)nx / 127.0f, (float)ny / 127.0f, (float)nz / 127.0f);
            generated.func_229188_a_(normalTransform);
        }
    }
}

