/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.dto;

import com.google.gson.JsonObject;
import net.minecraft.realms.RealmsScreen;

public class RealmsWorldOptions
extends czd {
    public Boolean pvp;
    public Boolean spawnAnimals;
    public Boolean spawnMonsters;
    public Boolean spawnNPCs;
    public Integer spawnProtection;
    public Boolean commandBlocks;
    public Boolean forceGameMode;
    public Integer difficulty;
    public Integer gameMode;
    public String slotName;
    public long templateId;
    public String templateImage;
    public boolean adventureMap;
    public boolean empty;
    private static final boolean forceGameModeDefault = false;
    private static final boolean pvpDefault = true;
    private static final boolean spawnAnimalsDefault = true;
    private static final boolean spawnMonstersDefault = true;
    private static final boolean spawnNPCsDefault = true;
    private static final int spawnProtectionDefault = 0;
    private static final boolean commandBlocksDefault = false;
    private static final int difficultyDefault = 2;
    private static final int gameModeDefault = 0;
    private static final String slotNameDefault = "";
    private static final long templateIdDefault = -1L;
    private static final String templateImageDefault = null;
    private static final boolean adventureMapDefault = false;

    public RealmsWorldOptions(Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Integer n2, Boolean bl6, Integer n3, Integer n4, Boolean bl7, String string) {
        this.pvp = bl2;
        this.spawnAnimals = bl3;
        this.spawnMonsters = bl4;
        this.spawnNPCs = bl5;
        this.spawnProtection = n2;
        this.commandBlocks = bl6;
        this.difficulty = n3;
        this.gameMode = n4;
        this.forceGameMode = bl7;
        this.slotName = string;
    }

    public static RealmsWorldOptions getDefaults() {
        return new RealmsWorldOptions(true, true, true, true, 0, false, 2, 0, false, slotNameDefault);
    }

    public static RealmsWorldOptions getEmptyDefaults() {
        RealmsWorldOptions realmsWorldOptions = new RealmsWorldOptions(true, true, true, true, 0, false, 2, 0, false, slotNameDefault);
        realmsWorldOptions.setEmpty(true);
        return realmsWorldOptions;
    }

    public void setEmpty(boolean bl2) {
        this.empty = bl2;
    }

    public static RealmsWorldOptions parse(JsonObject jsonObject) {
        RealmsWorldOptions realmsWorldOptions = new RealmsWorldOptions(daq.a("pvp", jsonObject, true), daq.a("spawnAnimals", jsonObject, true), daq.a("spawnMonsters", jsonObject, true), daq.a("spawnNPCs", jsonObject, true), daq.a("spawnProtection", jsonObject, 0), daq.a("commandBlocks", jsonObject, false), daq.a("difficulty", jsonObject, 2), daq.a("gameMode", jsonObject, 0), daq.a("forceGameMode", jsonObject, false), daq.a("slotName", jsonObject, slotNameDefault));
        realmsWorldOptions.templateId = daq.a("worldTemplateId", jsonObject, -1L);
        realmsWorldOptions.templateImage = daq.a("worldTemplateImage", jsonObject, templateImageDefault);
        realmsWorldOptions.adventureMap = daq.a("adventureMap", jsonObject, false);
        return realmsWorldOptions;
    }

    public String getSlotName(int n2) {
        if (this.slotName == null || this.slotName.isEmpty()) {
            if (this.empty) {
                return RealmsScreen.getLocalizedString("mco.configure.world.slot.empty");
            }
            return this.getDefaultSlotName(n2);
        }
        return this.slotName;
    }

    public String getDefaultSlotName(int n2) {
        return RealmsScreen.getLocalizedString("mco.configure.world.slot", n2);
    }

    public String toJson() {
        JsonObject jsonObject = new JsonObject();
        if (!this.pvp.booleanValue()) {
            jsonObject.addProperty("pvp", this.pvp);
        }
        if (!this.spawnAnimals.booleanValue()) {
            jsonObject.addProperty("spawnAnimals", this.spawnAnimals);
        }
        if (!this.spawnMonsters.booleanValue()) {
            jsonObject.addProperty("spawnMonsters", this.spawnMonsters);
        }
        if (!this.spawnNPCs.booleanValue()) {
            jsonObject.addProperty("spawnNPCs", this.spawnNPCs);
        }
        if (this.spawnProtection != 0) {
            jsonObject.addProperty("spawnProtection", (Number)this.spawnProtection);
        }
        if (this.commandBlocks.booleanValue()) {
            jsonObject.addProperty("commandBlocks", this.commandBlocks);
        }
        if (this.difficulty != 2) {
            jsonObject.addProperty("difficulty", (Number)this.difficulty);
        }
        if (this.gameMode != 0) {
            jsonObject.addProperty("gameMode", (Number)this.gameMode);
        }
        if (this.forceGameMode.booleanValue()) {
            jsonObject.addProperty("forceGameMode", this.forceGameMode);
        }
        if (this.slotName != null && !this.slotName.equals(slotNameDefault)) {
            jsonObject.addProperty("slotName", this.slotName);
        }
        return jsonObject.toString();
    }

    public RealmsWorldOptions clone() {
        return new RealmsWorldOptions(this.pvp, this.spawnAnimals, this.spawnMonsters, this.spawnNPCs, this.spawnProtection, this.commandBlocks, this.difficulty, this.gameMode, this.forceGameMode, this.slotName);
    }
}

