/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.client.Ping;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.PingResult;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsServerPlayerList;
import com.mojang.realmsclient.dto.RealmsServerPlayerLists;
import com.mojang.realmsclient.dto.RegionPingResult;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import com.mojang.realmsclient.gui.screens.RealmsClientOutdatedScreen;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsCreateRealmScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongConfirmationScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.RealmsParentalConsentScreen;
import com.mojang.realmsclient.gui.screens.RealmsPendingInvitesScreen;
import com.mojang.realmsclient.util.RealmsPersistence;
import com.mojang.realmsclient.util.RealmsTasks;
import com.mojang.realmsclient.util.RealmsTextureManager;
import com.mojang.realmsclient.util.RealmsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.KeyCombo;
import net.minecraft.realms.RealmListEntry;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsMth;
import net.minecraft.realms.RealmsObjectSelectionList;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsMainScreen
extends RealmsScreen {
    private static final Logger field_224012_a = LogManager.getLogger();
    private static boolean field_224013_b;
    private final RateLimiter field_224014_c;
    private boolean field_224015_d;
    private static List<ResourceLocation> field_227918_e_;
    private static final RealmsDataFetcher field_224017_f;
    private static int field_224018_g;
    private final RealmsScreen field_224019_h;
    private volatile ServerList field_224020_i;
    private long field_224021_j = -1L;
    private RealmsButton field_224022_k;
    private RealmsButton field_224023_l;
    private RealmsButton field_224024_m;
    private RealmsButton field_224025_n;
    private RealmsButton field_224026_o;
    private String field_224027_p;
    private List<RealmsServer> field_224028_q = Lists.newArrayList();
    private volatile int field_224029_r;
    private int field_224030_s;
    private static volatile boolean field_224031_t;
    private static volatile boolean field_224032_u;
    private static volatile boolean field_224033_v;
    private boolean field_224034_w;
    private boolean field_224035_x;
    private boolean field_224036_y;
    private volatile boolean field_224037_z;
    private volatile boolean field_223993_A;
    private volatile boolean field_223994_B;
    private volatile boolean field_223995_C;
    private volatile String field_223996_D;
    private int field_223997_E;
    private int field_223998_F;
    private boolean field_223999_G;
    private static RealmsScreen field_224000_H;
    private static boolean field_224001_I;
    private List<KeyCombo> field_224002_J;
    private int field_224003_K;
    private ReentrantLock field_224004_L = new ReentrantLock();
    private boolean field_224005_M;
    private InfoButton field_224006_N;
    private PendingInvitesButton field_224007_O;
    private NewsButton field_224008_P;
    private RealmsButton field_224009_Q;
    private RealmsButton field_224010_R;
    private RealmsButton field_224011_S;

    public RealmsMainScreen(RealmsScreen realmsScreen) {
        this.field_224019_h = realmsScreen;
        this.field_224014_c = RateLimiter.create((double)0.01666666753590107);
    }

    public boolean func_223928_a() {
        if (!this.func_223968_l() || !this.field_224034_w) {
            return false;
        }
        if (this.field_224037_z && !this.field_223993_A) {
            return true;
        }
        for (RealmsServer realmsServer : this.field_224028_q) {
            if (!realmsServer.ownerUUID.equals(Realms.getUUID())) continue;
            return false;
        }
        return true;
    }

    public boolean func_223990_b() {
        if (!this.func_223968_l() || !this.field_224034_w) {
            return false;
        }
        if (this.field_224035_x) {
            return true;
        }
        if (this.field_224037_z && !this.field_223993_A && this.field_224028_q.isEmpty()) {
            return true;
        }
        return this.field_224028_q.isEmpty();
    }

    @Override
    public void init() {
        this.field_224002_J = Lists.newArrayList((Object[])new KeyCombo[]{new KeyCombo(new char[]{'3', '2', '1', '4', '5', '6'}, () -> {
            field_224013_b = !field_224013_b;
        }), new KeyCombo(new char[]{'9', '8', '7', '1', '2', '3'}, () -> {
            if (RealmsClient.field_224944_a.equals((Object)RealmsClient.Environment.STAGE)) {
                this.func_223973_x();
            } else {
                this.func_223884_v();
            }
        }), new KeyCombo(new char[]{'9', '8', '7', '4', '5', '6'}, () -> {
            if (RealmsClient.field_224944_a.equals((Object)RealmsClient.Environment.LOCAL)) {
                this.func_223973_x();
            } else {
                this.func_223962_w();
            }
        })});
        if (field_224000_H != null) {
            Realms.setScreen(field_224000_H);
            return;
        }
        this.field_224004_L = new ReentrantLock();
        if (field_224033_v && !this.func_223968_l()) {
            this.func_223975_u();
        }
        this.func_223895_s();
        this.func_223965_t();
        if (!this.field_224015_d) {
            Realms.setConnectedToRealms(false);
        }
        this.setKeyboardHandlerSendRepeatsToGui(true);
        if (this.func_223968_l()) {
            field_224017_f.func_225087_d();
        }
        this.field_223994_B = false;
        this.func_223970_d();
    }

    private boolean func_223968_l() {
        return field_224032_u && field_224031_t;
    }

    public void func_223901_c() {
        this.field_224025_n = new RealmsButton(1, this.width() / 2 - 190, this.height() - 32, 90, 20, RealmsMainScreen.getLocalizedString("mco.selectServer.configure")){

            @Override
            public void onPress() {
                RealmsMainScreen.this.func_223966_f(RealmsMainScreen.this.func_223967_a(RealmsMainScreen.this.field_224021_j));
            }
        };
        this.buttonsAdd(this.field_224025_n);
        this.field_224022_k = new RealmsButton(3, this.width() / 2 - 93, this.height() - 32, 90, 20, RealmsMainScreen.getLocalizedString("mco.selectServer.play")){

            @Override
            public void onPress() {
                RealmsMainScreen.this.func_223914_p();
            }
        };
        this.buttonsAdd(this.field_224022_k);
        this.field_224023_l = new RealmsButton(2, this.width() / 2 + 4, this.height() - 32, 90, 20, RealmsMainScreen.getLocalizedString("gui.back")){

            @Override
            public void onPress() {
                if (!RealmsMainScreen.this.field_224036_y) {
                    Realms.setScreen(RealmsMainScreen.this.field_224019_h);
                }
            }
        };
        this.buttonsAdd(this.field_224023_l);
        this.field_224024_m = new RealmsButton(0, this.width() / 2 + 100, this.height() - 32, 90, 20, RealmsMainScreen.getLocalizedString("mco.selectServer.expiredRenew")){

            @Override
            public void onPress() {
                RealmsMainScreen.this.func_223930_q();
            }
        };
        this.buttonsAdd(this.field_224024_m);
        this.field_224026_o = new RealmsButton(7, this.width() / 2 - 202, this.height() - 32, 90, 20, RealmsMainScreen.getLocalizedString("mco.selectServer.leave")){

            @Override
            public void onPress() {
                RealmsMainScreen.this.func_223906_g(RealmsMainScreen.this.func_223967_a(RealmsMainScreen.this.field_224021_j));
            }
        };
        this.buttonsAdd(this.field_224026_o);
        this.field_224007_O = new PendingInvitesButton();
        this.buttonsAdd(this.field_224007_O);
        this.field_224008_P = new NewsButton();
        this.buttonsAdd(this.field_224008_P);
        this.field_224006_N = new InfoButton();
        this.buttonsAdd(this.field_224006_N);
        this.field_224011_S = new CloseButton();
        this.buttonsAdd(this.field_224011_S);
        this.field_224009_Q = new RealmsButton(6, this.width() / 2 + 52, this.func_223932_C() + 137 - 20, 98, 20, RealmsMainScreen.getLocalizedString("mco.selectServer.trial")){

            @Override
            public void onPress() {
                RealmsMainScreen.this.func_223988_r();
            }
        };
        this.buttonsAdd(this.field_224009_Q);
        this.field_224010_R = new RealmsButton(5, this.width() / 2 + 52, this.func_223932_C() + 160 - 20, 98, 20, RealmsMainScreen.getLocalizedString("mco.selectServer.buy")){

            @Override
            public void onPress() {
                RealmsUtil.func_225190_c("https://aka.ms/BuyJavaRealms");
            }
        };
        this.buttonsAdd(this.field_224010_R);
        RealmsServer realmsServer = this.func_223967_a(this.field_224021_j);
        this.func_223915_a(realmsServer);
    }

    private void func_223915_a(RealmsServer realmsServer) {
        this.field_224022_k.active(this.func_223897_b(realmsServer) && !this.func_223990_b());
        this.field_224024_m.setVisible(this.func_223920_c(realmsServer));
        this.field_224025_n.setVisible(this.func_223941_d(realmsServer));
        this.field_224026_o.setVisible(this.func_223959_e(realmsServer));
        boolean bl = this.func_223990_b() && this.field_224037_z && !this.field_223993_A;
        this.field_224009_Q.setVisible(bl);
        this.field_224009_Q.active(bl);
        this.field_224010_R.setVisible(this.func_223990_b());
        this.field_224011_S.setVisible(this.func_223990_b() && this.field_224035_x);
        this.field_224024_m.active(!this.func_223990_b());
        this.field_224025_n.active(!this.func_223990_b());
        this.field_224026_o.active(!this.func_223990_b());
        this.field_224008_P.active(true);
        this.field_224007_O.active(true);
        this.field_224023_l.active(true);
        this.field_224006_N.active(!this.func_223990_b());
    }

    private boolean func_223977_m() {
        return (!this.func_223990_b() || this.field_224035_x) && this.func_223968_l() && this.field_224034_w;
    }

    private boolean func_223897_b(RealmsServer realmsServer) {
        return realmsServer != null && !realmsServer.expired && realmsServer.state == RealmsServer.Status.OPEN;
    }

    private boolean func_223920_c(RealmsServer realmsServer) {
        return realmsServer != null && realmsServer.expired && this.func_223885_h(realmsServer);
    }

    private boolean func_223941_d(RealmsServer realmsServer) {
        return realmsServer != null && this.func_223885_h(realmsServer);
    }

    private boolean func_223959_e(RealmsServer realmsServer) {
        return realmsServer != null && !this.func_223885_h(realmsServer);
    }

    public void func_223970_d() {
        if (this.func_223968_l() && this.field_224034_w) {
            this.func_223901_c();
        }
        this.field_224020_i = new ServerList();
        if (field_224018_g != -1) {
            this.field_224020_i.scroll(field_224018_g);
        }
        this.addWidget(this.field_224020_i);
        this.focusOn(this.field_224020_i);
    }

    @Override
    public void tick() {
        Object object;
        this.tickButtons();
        this.field_224036_y = false;
        ++this.field_224030_s;
        --this.field_224003_K;
        if (this.field_224003_K < 0) {
            this.field_224003_K = 0;
        }
        if (!this.func_223968_l()) {
            return;
        }
        field_224017_f.func_225086_b();
        if (field_224017_f.func_225083_a(RealmsDataFetcher.Task.SERVER_LIST)) {
            object = field_224017_f.func_225078_e();
            this.field_224020_i.clear();
            boolean bl = \u2603 = !this.field_224034_w;
            if (\u2603) {
                this.field_224034_w = true;
            }
            if (object != null) {
                boolean \u26032 = false;
                Iterator<Object> iterator = object.iterator();
                while (iterator.hasNext()) {
                    RealmsServer realmsServer = (RealmsServer)iterator.next();
                    if (!this.func_223991_i(realmsServer)) continue;
                    \u26032 = true;
                }
                this.field_224028_q = object;
                if (this.func_223928_a()) {
                    this.field_224020_i.addEntry(new TrialServerEntry());
                }
                for (RealmsServer realmsServer : this.field_224028_q) {
                    this.field_224020_i.addEntry(new ServerEntry(realmsServer));
                }
                if (!field_224001_I && \u26032) {
                    field_224001_I = true;
                    this.func_223944_n();
                }
            }
            if (\u2603) {
                this.func_223901_c();
            }
        }
        if (field_224017_f.func_225083_a(RealmsDataFetcher.Task.PENDING_INVITE)) {
            this.field_224029_r = field_224017_f.func_225081_f();
            if (this.field_224029_r > 0 && this.field_224014_c.tryAcquire(1)) {
                Realms.narrateNow(RealmsMainScreen.getLocalizedString("mco.configure.world.invite.narration", this.field_224029_r));
            }
        }
        if (field_224017_f.func_225083_a(RealmsDataFetcher.Task.TRIAL_AVAILABLE) && !this.field_223993_A) {
            boolean bl = field_224017_f.func_225071_g();
            if (bl != this.field_224037_z && this.func_223990_b()) {
                this.field_224037_z = bl;
                this.field_223994_B = false;
            } else {
                this.field_224037_z = bl;
            }
        }
        if (field_224017_f.func_225083_a(RealmsDataFetcher.Task.LIVE_STATS)) {
            object = field_224017_f.func_225079_h();
            block2: for (RealmsServerPlayerList realmsServerPlayerList : ((RealmsServerPlayerLists)object).servers) {
                for (RealmsServer realmsServer : this.field_224028_q) {
                    if (realmsServer.id != realmsServerPlayerList.serverId) continue;
                    realmsServer.updateServerPing(realmsServerPlayerList);
                    continue block2;
                }
            }
        }
        if (field_224017_f.func_225083_a(RealmsDataFetcher.Task.UNREAD_NEWS)) {
            this.field_223995_C = field_224017_f.func_225059_i();
            this.field_223996_D = field_224017_f.func_225063_j();
        }
        field_224017_f.func_225072_c();
        if (this.func_223990_b()) {
            ++this.field_223998_F;
        }
        if (this.field_224006_N != null) {
            this.field_224006_N.setVisible(this.func_223977_m());
        }
    }

    private void func_223921_a(String string) {
        Realms.setClipboard(string);
        RealmsUtil.func_225190_c(string);
    }

    private void func_223944_n() {
        new Thread(() -> {
            List<RegionPingResult> list = Ping.func_224864_a();
            RealmsClient \u26032 = RealmsClient.func_224911_a();
            PingResult \u26033 = new PingResult();
            \u26033.pingResults = list;
            \u26033.worldIds = this.func_223952_o();
            try {
                \u26032.func_224903_a(\u26033);
            }
            catch (Throwable \u26034) {
                field_224012_a.warn("Could not send ping result to Realms: ", \u26034);
            }
        }).start();
    }

    private List<Long> func_223952_o() {
        ArrayList arrayList = Lists.newArrayList();
        for (RealmsServer realmsServer : this.field_224028_q) {
            if (!this.func_223991_i(realmsServer)) continue;
            arrayList.add(realmsServer.id);
        }
        return arrayList;
    }

    @Override
    public void removed() {
        this.setKeyboardHandlerSendRepeatsToGui(false);
        this.func_223939_y();
    }

    private void func_223914_p() {
        RealmsServer realmsServer = this.func_223967_a(this.field_224021_j);
        if (realmsServer == null) {
            return;
        }
        this.func_223911_a(realmsServer, this);
    }

    private void func_223930_q() {
        RealmsServer realmsServer = this.func_223967_a(this.field_224021_j);
        if (realmsServer == null) {
            return;
        }
        String \u26032 = "https://aka.ms/ExtendJavaRealms?subscriptionId=" + realmsServer.remoteSubscriptionId + "&profileId=" + Realms.getUUID() + "&ref=" + (realmsServer.expiredTrial ? "expiredTrial" : "expiredRealm");
        this.func_223921_a(\u26032);
    }

    private void func_223988_r() {
        if (!this.field_224037_z || this.field_223993_A) {
            return;
        }
        RealmsUtil.func_225190_c("https://aka.ms/startjavarealmstrial");
        Realms.setScreen(this.field_224019_h);
    }

    private void func_223895_s() {
        if (!field_224033_v) {
            field_224033_v = true;
            new Thread("MCO Compatability Checker #1"){

                @Override
                public void run() {
                    RealmsClient realmsClient = RealmsClient.func_224911_a();
                    try {
                        RealmsClient.CompatibleVersionResponse compatibleVersionResponse = realmsClient.func_224939_i();
                        if (compatibleVersionResponse.equals((Object)RealmsClient.CompatibleVersionResponse.OUTDATED)) {
                            field_224000_H = new RealmsClientOutdatedScreen(RealmsMainScreen.this.field_224019_h, true);
                            Realms.setScreen(field_224000_H);
                            return;
                        }
                        if (compatibleVersionResponse.equals((Object)RealmsClient.CompatibleVersionResponse.OTHER)) {
                            field_224000_H = new RealmsClientOutdatedScreen(RealmsMainScreen.this.field_224019_h, false);
                            Realms.setScreen(field_224000_H);
                            return;
                        }
                        RealmsMainScreen.this.func_223975_u();
                    }
                    catch (RealmsServiceException realmsServiceException) {
                        field_224033_v = false;
                        field_224012_a.error("Couldn't connect to realms: ", (Object)realmsServiceException.toString());
                        if (realmsServiceException.field_224981_a == 401) {
                            field_224000_H = new RealmsGenericErrorScreen(RealmsScreen.getLocalizedString("mco.error.invalid.session.title"), RealmsScreen.getLocalizedString("mco.error.invalid.session.message"), RealmsMainScreen.this.field_224019_h);
                            Realms.setScreen(field_224000_H);
                            return;
                        }
                        Realms.setScreen(new RealmsGenericErrorScreen(realmsServiceException, RealmsMainScreen.this.field_224019_h));
                        return;
                    }
                    catch (IOException iOException) {
                        field_224033_v = false;
                        field_224012_a.error("Couldn't connect to realms: ", (Object)iOException.getMessage());
                        Realms.setScreen(new RealmsGenericErrorScreen(iOException.getMessage(), RealmsMainScreen.this.field_224019_h));
                        return;
                    }
                }
            }.start();
        }
    }

    private void func_223965_t() {
    }

    private void func_223975_u() {
        new Thread("MCO Compatability Checker #1"){

            @Override
            public void run() {
                RealmsClient realmsClient = RealmsClient.func_224911_a();
                try {
                    Boolean bl = realmsClient.func_224918_g();
                    if (bl.booleanValue()) {
                        field_224012_a.info("Realms is available for this user");
                        field_224031_t = true;
                    } else {
                        field_224012_a.info("Realms is not available for this user");
                        field_224031_t = false;
                        Realms.setScreen(new RealmsParentalConsentScreen(RealmsMainScreen.this.field_224019_h));
                    }
                    field_224032_u = true;
                }
                catch (RealmsServiceException realmsServiceException) {
                    field_224012_a.error("Couldn't connect to realms: ", (Object)realmsServiceException.toString());
                    Realms.setScreen(new RealmsGenericErrorScreen(realmsServiceException, RealmsMainScreen.this.field_224019_h));
                }
                catch (IOException iOException) {
                    field_224012_a.error("Couldn't connect to realms: ", (Object)iOException.getMessage());
                    Realms.setScreen(new RealmsGenericErrorScreen(iOException.getMessage(), RealmsMainScreen.this.field_224019_h));
                }
            }
        }.start();
    }

    private void func_223884_v() {
        if (!RealmsClient.field_224944_a.equals((Object)RealmsClient.Environment.STAGE)) {
            new Thread("MCO Stage Availability Checker #1"){

                @Override
                public void run() {
                    RealmsClient realmsClient = RealmsClient.func_224911_a();
                    try {
                        Boolean bl = realmsClient.func_224931_h();
                        if (bl.booleanValue()) {
                            RealmsClient.func_224940_b();
                            field_224012_a.info("Switched to stage");
                            field_224017_f.func_225087_d();
                        }
                    }
                    catch (RealmsServiceException realmsServiceException) {
                        field_224012_a.error("Couldn't connect to Realms: " + realmsServiceException);
                    }
                    catch (IOException iOException) {
                        field_224012_a.error("Couldn't parse response connecting to Realms: " + iOException.getMessage());
                    }
                }
            }.start();
        }
    }

    private void func_223962_w() {
        if (!RealmsClient.field_224944_a.equals((Object)RealmsClient.Environment.LOCAL)) {
            new Thread("MCO Local Availability Checker #1"){

                @Override
                public void run() {
                    RealmsClient realmsClient = RealmsClient.func_224911_a();
                    try {
                        Boolean bl = realmsClient.func_224931_h();
                        if (bl.booleanValue()) {
                            RealmsClient.func_224941_d();
                            field_224012_a.info("Switched to local");
                            field_224017_f.func_225087_d();
                        }
                    }
                    catch (RealmsServiceException realmsServiceException) {
                        field_224012_a.error("Couldn't connect to Realms: " + realmsServiceException);
                    }
                    catch (IOException iOException) {
                        field_224012_a.error("Couldn't parse response connecting to Realms: " + iOException.getMessage());
                    }
                }
            }.start();
        }
    }

    private void func_223973_x() {
        RealmsClient.func_224921_c();
        field_224017_f.func_225087_d();
    }

    private void func_223939_y() {
        field_224017_f.func_225070_k();
    }

    private void func_223966_f(RealmsServer realmsServer) {
        if (Realms.getUUID().equals(realmsServer.ownerUUID) || field_224013_b) {
            this.func_223949_z();
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.execute(() -> minecraft.func_147108_a(new RealmsConfigureWorldScreen(this, realmsServer.id).getProxy()));
        }
    }

    private void func_223906_g(@Nullable RealmsServer realmsServer) {
        if (realmsServer != null && !Realms.getUUID().equals(realmsServer.ownerUUID)) {
            this.func_223949_z();
            String string = RealmsMainScreen.getLocalizedString("mco.configure.world.leave.question.line1");
            \u2603 = RealmsMainScreen.getLocalizedString("mco.configure.world.leave.question.line2");
            Realms.setScreen(new RealmsLongConfirmationScreen(this, RealmsLongConfirmationScreen.Type.Info, string, \u2603, true, 4));
        }
    }

    private void func_223949_z() {
        field_224018_g = this.field_224020_i.getScroll();
    }

    private RealmsServer func_223967_a(long l) {
        for (RealmsServer realmsServer : this.field_224028_q) {
            if (realmsServer.id != l) continue;
            return realmsServer;
        }
        return null;
    }

    @Override
    public void confirmResult(boolean bl, int n) {
        if (n == 4) {
            if (bl) {
                new Thread("Realms-leave-server"){

                    @Override
                    public void run() {
                        try {
                            RealmsServer realmsServer = RealmsMainScreen.this.func_223967_a(RealmsMainScreen.this.field_224021_j);
                            if (realmsServer != null) {
                                RealmsClient realmsClient = RealmsClient.func_224911_a();
                                realmsClient.func_224912_c(realmsServer.id);
                                field_224017_f.func_225085_a(realmsServer);
                                RealmsMainScreen.this.field_224028_q.remove(realmsServer);
                                RealmsMainScreen.this.field_224020_i.children().removeIf(realmListEntry -> realmListEntry instanceof ServerEntry && ((ServerEntry)realmListEntry).field_223734_a.id == RealmsMainScreen.this.field_224021_j);
                                RealmsMainScreen.this.field_224020_i.setSelected(-1);
                                RealmsMainScreen.this.func_223915_a(null);
                                RealmsMainScreen.this.field_224021_j = -1L;
                                RealmsMainScreen.this.field_224022_k.active(false);
                            }
                        }
                        catch (RealmsServiceException realmsServiceException) {
                            field_224012_a.error("Couldn't configure world");
                            Realms.setScreen(new RealmsGenericErrorScreen(realmsServiceException, (RealmsScreen)RealmsMainScreen.this));
                        }
                    }
                }.start();
            }
            Realms.setScreen(this);
        }
    }

    public void func_223978_e() {
        this.field_224021_j = -1L;
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        switch (n) {
            case 256: {
                this.field_224002_J.forEach(KeyCombo::func_224800_a);
                this.func_223955_A();
                return true;
            }
        }
        return super.keyPressed(n, n2, n3);
    }

    private void func_223955_A() {
        if (this.func_223990_b() && this.field_224035_x) {
            this.field_224035_x = false;
        } else {
            Realms.setScreen(this.field_224019_h);
        }
    }

    @Override
    public boolean charTyped(char c, int n) {
        this.field_224002_J.forEach(keyCombo -> keyCombo.func_224799_a(c));
        return true;
    }

    @Override
    public void render(int n3, int n2, float f) {
        int n3;
        this.field_224005_M = false;
        this.field_224027_p = null;
        this.renderBackground();
        this.field_224020_i.render(n3, n2, f);
        this.func_223883_a(this.width() / 2 - 50, 7);
        if (RealmsClient.field_224944_a.equals((Object)RealmsClient.Environment.STAGE)) {
            this.func_223888_E();
        }
        if (RealmsClient.field_224944_a.equals((Object)RealmsClient.Environment.LOCAL)) {
            this.func_223964_D();
        }
        if (this.func_223990_b()) {
            this.func_223980_b(n3, n2);
        } else {
            if (this.field_223994_B) {
                this.func_223915_a(null);
                if (!this.hasWidget(this.field_224020_i)) {
                    this.addWidget(this.field_224020_i);
                }
                RealmsServer realmsServer = this.func_223967_a(this.field_224021_j);
                this.field_224022_k.active(this.func_223897_b(realmsServer));
            }
            this.field_223994_B = false;
        }
        super.render(n3, n2, f);
        if (this.field_224027_p != null) {
            this.func_223922_a(this.field_224027_p, n3, n2);
        }
        if (this.field_224037_z && !this.field_223993_A && this.func_223990_b()) {
            RealmsScreen.bind("realms:textures/gui/realms/trial_icon.png");
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.pushMatrix();
            \u2603 = 8;
            \u2603 = 8;
            \u2603 = 0;
            if ((System.currentTimeMillis() / 800L & 1L) == 1L) {
                \u2603 = 8;
            }
            RealmsScreen.blit(this.field_224009_Q.func_214457_x() + this.field_224009_Q.getWidth() - 8 - 4, this.field_224009_Q.func_223291_y_() + this.field_224009_Q.getHeight() / 2 - 4, 0.0f, \u2603, 8, 8, 8, 16);
            RenderSystem.popMatrix();
        }
    }

    private void func_223883_a(int n, int n2) {
        RealmsScreen.bind("realms:textures/gui/title/realms.png");
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.scalef(0.5f, 0.5f, 0.5f);
        RealmsScreen.blit(n * 2, n2 * 2 - 5, 0.0f, 0.0f, 200, 50, 200, 50);
        RenderSystem.popMatrix();
    }

    @Override
    public boolean mouseClicked(double d, double d2, int n) {
        if (this.func_223979_a(d, d2) && this.field_224035_x) {
            this.field_224035_x = false;
            this.field_224036_y = true;
            return true;
        }
        return super.mouseClicked(d, d2, n);
    }

    private boolean func_223979_a(double d, double d2) {
        int n = this.func_223989_B();
        \u2603 = this.func_223932_C();
        return d < (double)(n - 5) || d > (double)(n + 315) || d2 < (double)(\u2603 - 5) || d2 > (double)(\u2603 + 171);
    }

    private void func_223980_b(int n, int n2) {
        \u2603 = this.func_223989_B();
        \u2603 = this.func_223932_C();
        String string = RealmsMainScreen.getLocalizedString("mco.selectServer.popup");
        List<String> \u26032 = this.fontSplit(string, 100);
        if (!this.field_223994_B) {
            this.field_223997_E = 0;
            this.field_223998_F = 0;
            this.field_223999_G = true;
            this.func_223915_a(null);
            if (this.hasWidget(this.field_224020_i)) {
                this.removeWidget(this.field_224020_i);
            }
            Realms.narrateNow(string);
        }
        if (this.field_224034_w) {
            this.field_223994_B = true;
        }
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 0.7f);
        RenderSystem.enableBlend();
        RealmsScreen.bind("realms:textures/gui/realms/darken.png");
        RenderSystem.pushMatrix();
        boolean \u26033 = false;
        int \u26034 = 32;
        RealmsScreen.blit(0, 32, 0.0f, 0.0f, this.width(), this.height() - 40 - 32, 310, 166);
        RenderSystem.popMatrix();
        RenderSystem.disableBlend();
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RealmsScreen.bind("realms:textures/gui/realms/popup.png");
        RenderSystem.pushMatrix();
        RealmsScreen.blit(\u2603, \u2603, 0.0f, 0.0f, 310, 166, 310, 166);
        RenderSystem.popMatrix();
        if (!field_227918_e_.isEmpty()) {
            RealmsScreen.bind(field_227918_e_.get(this.field_223997_E).toString());
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.pushMatrix();
            RealmsScreen.blit(\u2603 + 7, \u2603 + 7, 0.0f, 0.0f, 195, 152, 195, 152);
            RenderSystem.popMatrix();
            if (this.field_223998_F % 95 < 5) {
                if (!this.field_223999_G) {
                    this.field_223997_E = (this.field_223997_E + 1) % field_227918_e_.size();
                    this.field_223999_G = true;
                }
            } else {
                this.field_223999_G = false;
            }
        }
        int \u26035 = 0;
        for (String string2 : \u26032) {
            this.drawString(string2, this.width() / 2 + 52, \u2603 + 10 * ++\u26035 - 3, 0x808080, false);
        }
    }

    private int func_223989_B() {
        return (this.width() - 310) / 2;
    }

    private int func_223932_C() {
        return this.height() / 2 - 80;
    }

    private void func_223960_a(int n5, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        int \u26033;
        int n6 = this.field_224029_r;
        boolean \u26032 = this.func_223931_b(n5, n2);
        boolean bl3 = \u2603 = bl2 && bl;
        if (\u2603) {
            float f = 0.25f + (1.0f + RealmsMth.sin((float)this.field_224030_s * 0.5f)) * 0.25f;
            \u26033 = 0xFF000000 | (int)(f * 64.0f) << 16 | (int)(f * 64.0f) << 8 | (int)(f * 64.0f) << 0;
            this.fillGradient(n3 - 2, n4 - 2, n3 + 18, n4 + 18, \u26033, \u26033);
            \u26033 = 0xFF000000 | (int)(f * 255.0f) << 16 | (int)(f * 255.0f) << 8 | (int)(f * 255.0f) << 0;
            this.fillGradient(n3 - 2, n4 - 2, n3 + 18, n4 - 1, \u26033, \u26033);
            this.fillGradient(n3 - 2, n4 - 2, n3 - 1, n4 + 18, \u26033, \u26033);
            this.fillGradient(n3 + 17, n4 - 2, n3 + 18, n4 + 18, \u26033, \u26033);
            this.fillGradient(n3 - 2, n4 + 17, n3 + 18, n4 + 18, \u26033, \u26033);
        }
        RealmsScreen.bind("realms:textures/gui/realms/invite_icon.png");
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        boolean bl4 = bl2 && bl;
        RealmsScreen.blit(n3, n4 - 6, bl4 ? 16.0f : 0.0f, 0.0f, 15, 25, 31, 25);
        RenderSystem.popMatrix();
        int n7 = \u26033 = bl2 && n6 != 0 ? 1 : 0;
        if (\u26033 != 0) {
            int n8 = (Math.min(n6, 6) - 1) * 8;
            \u2603 = (int)(Math.max(0.0f, Math.max(RealmsMth.sin((float)(10 + this.field_224030_s) * 0.57f), RealmsMth.cos((float)this.field_224030_s * 0.35f))) * -6.0f);
            RealmsScreen.bind("realms:textures/gui/realms/invitation_icons.png");
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.pushMatrix();
            RealmsScreen.blit(n3 + 4, n4 + 4 + \u2603, n8, \u26032 ? 8.0f : 0.0f, 8, 8, 48, 16);
            RenderSystem.popMatrix();
        }
        n8 = n5 + 12;
        \u2603 = n2;
        boolean bl5 = \u2603 = bl2 && \u26032;
        if (\u2603) {
            String string = RealmsMainScreen.getLocalizedString(n6 == 0 ? "mco.invites.nopending" : "mco.invites.pending");
            int \u26034 = this.fontWidth(string);
            this.fillGradient(n8 - 3, \u2603 - 3, n8 + \u26034 + 3, \u2603 + 8 + 3, -1073741824, -1073741824);
            this.fontDrawShadow(string, n8, \u2603, -1);
        }
    }

    private boolean func_223931_b(double d, double d2) {
        int n = this.width() / 2 + 50;
        \u2603 = this.width() / 2 + 66;
        \u2603 = 11;
        \u2603 = 23;
        if (this.field_224029_r != 0) {
            n -= 3;
            \u2603 += 3;
            \u2603 -= 5;
            \u2603 += 5;
        }
        return (double)n <= d && d <= (double)\u2603 && (double)\u2603 <= d2 && d2 <= (double)\u2603;
    }

    public void func_223911_a(RealmsServer realmsServer, RealmsScreen realmsScreen) {
        if (realmsServer != null) {
            try {
                if (!this.field_224004_L.tryLock(1L, TimeUnit.SECONDS)) {
                    return;
                }
                if (this.field_224004_L.getHoldCount() > 1) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.field_224015_d = true;
            this.func_223950_b(realmsServer, realmsScreen);
        }
    }

    private void func_223950_b(RealmsServer realmsServer, RealmsScreen realmsScreen) {
        RealmsLongRunningMcoTaskScreen realmsLongRunningMcoTaskScreen = new RealmsLongRunningMcoTaskScreen(realmsScreen, new RealmsTasks.RealmsGetServerDetailsTask(this, realmsScreen, realmsServer, this.field_224004_L));
        realmsLongRunningMcoTaskScreen.func_224233_a();
        Realms.setScreen(realmsLongRunningMcoTaskScreen);
    }

    private boolean func_223885_h(RealmsServer realmsServer) {
        return realmsServer.ownerUUID != null && realmsServer.ownerUUID.equals(Realms.getUUID());
    }

    private boolean func_223991_i(RealmsServer realmsServer) {
        return realmsServer.ownerUUID != null && realmsServer.ownerUUID.equals(Realms.getUUID()) && !realmsServer.expired;
    }

    private void func_223907_a(int n, int n2, int n3, int n4) {
        RealmsScreen.bind("realms:textures/gui/realms/expired_icon.png");
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        RealmsScreen.blit(n, n2, 0.0f, 0.0f, 10, 28, 10, 28);
        RenderSystem.popMatrix();
        if (n3 >= n && n3 <= n + 9 && n4 >= n2 && n4 <= n2 + 27 && n4 < this.height() - 40 && n4 > 32 && !this.func_223990_b()) {
            this.field_224027_p = RealmsMainScreen.getLocalizedString("mco.selectServer.expired");
        }
    }

    private void func_223909_a(int n, int n2, int n3, int n4, int n5) {
        RealmsScreen.bind("realms:textures/gui/realms/expires_soon_icon.png");
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        if (this.field_224030_s % 20 < 10) {
            RealmsScreen.blit(n, n2, 0.0f, 0.0f, 10, 28, 20, 28);
        } else {
            RealmsScreen.blit(n, n2, 10.0f, 0.0f, 10, 28, 20, 28);
        }
        RenderSystem.popMatrix();
        if (n3 >= n && n3 <= n + 9 && n4 >= n2 && n4 <= n2 + 27 && n4 < this.height() - 40 && n4 > 32 && !this.func_223990_b()) {
            this.field_224027_p = n5 <= 0 ? RealmsMainScreen.getLocalizedString("mco.selectServer.expires.soon") : (n5 == 1 ? RealmsMainScreen.getLocalizedString("mco.selectServer.expires.day") : RealmsMainScreen.getLocalizedString("mco.selectServer.expires.days", n5));
        }
    }

    private void func_223987_b(int n, int n2, int n3, int n4) {
        RealmsScreen.bind("realms:textures/gui/realms/on_icon.png");
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        RealmsScreen.blit(n, n2, 0.0f, 0.0f, 10, 28, 10, 28);
        RenderSystem.popMatrix();
        if (n3 >= n && n3 <= n + 9 && n4 >= n2 && n4 <= n2 + 27 && n4 < this.height() - 40 && n4 > 32 && !this.func_223990_b()) {
            this.field_224027_p = RealmsMainScreen.getLocalizedString("mco.selectServer.open");
        }
    }

    private void func_223912_c(int n, int n2, int n3, int n4) {
        RealmsScreen.bind("realms:textures/gui/realms/off_icon.png");
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        RealmsScreen.blit(n, n2, 0.0f, 0.0f, 10, 28, 10, 28);
        RenderSystem.popMatrix();
        if (n3 >= n && n3 <= n + 9 && n4 >= n2 && n4 <= n2 + 27 && n4 < this.height() - 40 && n4 > 32 && !this.func_223990_b()) {
            this.field_224027_p = RealmsMainScreen.getLocalizedString("mco.selectServer.closed");
        }
    }

    private void func_223945_d(int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (n3 >= n && n3 <= n + 28 && n4 >= n2 && n4 <= n2 + 28 && n4 < this.height() - 40 && n4 > 32 && !this.func_223990_b()) {
            bl = true;
        }
        RealmsScreen.bind("realms:textures/gui/realms/leave_icon.png");
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        RealmsScreen.blit(n, n2, bl ? 28.0f : 0.0f, 0.0f, 28, 28, 56, 28);
        RenderSystem.popMatrix();
        if (bl) {
            this.field_224027_p = RealmsMainScreen.getLocalizedString("mco.selectServer.leave");
        }
    }

    private void func_223916_e(int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (n3 >= n && n3 <= n + 28 && n4 >= n2 && n4 <= n2 + 28 && n4 < this.height() - 40 && n4 > 32 && !this.func_223990_b()) {
            bl = true;
        }
        RealmsScreen.bind("realms:textures/gui/realms/configure_icon.png");
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        RealmsScreen.blit(n, n2, bl ? 28.0f : 0.0f, 0.0f, 28, 28, 56, 28);
        RenderSystem.popMatrix();
        if (bl) {
            this.field_224027_p = RealmsMainScreen.getLocalizedString("mco.selectServer.configure");
        }
    }

    protected void func_223922_a(String string, int n3, int n2) {
        int n3;
        if (string == null) {
            return;
        }
        \u2603 = 0;
        \u2603 = 0;
        for (String string2 : string.split("\n")) {
            int n4 = this.fontWidth(string2);
            if (n4 <= \u2603) continue;
            \u2603 = n4;
        }
        \u2603 = n3 - \u2603 - 5;
        \u2603 = n2;
        if (\u2603 < 0) {
            \u2603 = n3 + 12;
        }
        for (String string3 : string.split("\n")) {
            this.fillGradient(\u2603 - 3, \u2603 - (\u2603 == 0 ? 3 : 0) + \u2603, \u2603 + \u2603 + 3, \u2603 + 8 + 3 + \u2603, -1073741824, -1073741824);
            this.fontDrawShadow(string3, \u2603, \u2603 + \u2603, 0xFFFFFF);
            \u2603 += 10;
        }
    }

    private void func_223933_a(int n, int n2, int n3, int n4, boolean bl) {
        \u2603 = false;
        if (n >= n3 && n <= n3 + 20 && n2 >= n4 && n2 <= n4 + 20) {
            \u2603 = true;
        }
        RealmsScreen.bind("realms:textures/gui/realms/questionmark.png");
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        RealmsScreen.blit(n3, n4, bl ? 20.0f : 0.0f, 0.0f, 20, 20, 40, 20);
        RenderSystem.popMatrix();
        if (\u2603) {
            this.field_224027_p = RealmsMainScreen.getLocalizedString("mco.selectServer.info");
        }
    }

    private void func_223982_a(int n, int n2, boolean bl, int n3, int n4, boolean bl2, boolean bl3) {
        \u2603 = false;
        if (n >= n3 && n <= n3 + 20 && n2 >= n4 && n2 <= n4 + 20) {
            \u2603 = true;
        }
        RealmsScreen.bind("realms:textures/gui/realms/news_icon.png");
        if (bl3) {
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            RenderSystem.color4f(0.5f, 0.5f, 0.5f, 1.0f);
        }
        RenderSystem.pushMatrix();
        \u2603 = bl3 && bl2;
        RealmsScreen.blit(n3, n4, \u2603 ? 20.0f : 0.0f, 0.0f, 20, 20, 40, 20);
        RenderSystem.popMatrix();
        if (\u2603 && bl3) {
            this.field_224027_p = RealmsMainScreen.getLocalizedString("mco.news");
        }
        if (bl && bl3) {
            int n5 = \u2603 ? 0 : (int)(Math.max(0.0f, Math.max(RealmsMth.sin((float)(10 + this.field_224030_s) * 0.57f), RealmsMth.cos((float)this.field_224030_s * 0.35f))) * -6.0f);
            RealmsScreen.bind("realms:textures/gui/realms/invitation_icons.png");
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.pushMatrix();
            RealmsScreen.blit(n3 + 10, n4 + 2 + n5, 40.0f, 0.0f, 8, 8, 48, 16);
            RenderSystem.popMatrix();
        }
    }

    private void func_223964_D() {
        String string = "LOCAL!";
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef(this.width() / 2 - 25, 20.0f, 0.0f);
        RenderSystem.rotatef(-20.0f, 0.0f, 0.0f, 1.0f);
        RenderSystem.scalef(1.5f, 1.5f, 1.5f);
        this.drawString("LOCAL!", 0, 0, 0x7FFF7F);
        RenderSystem.popMatrix();
    }

    private void func_223888_E() {
        String string = "STAGE!";
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef(this.width() / 2 - 25, 20.0f, 0.0f);
        RenderSystem.rotatef(-20.0f, 0.0f, 0.0f, 1.0f);
        RenderSystem.scalef(1.5f, 1.5f, 1.5f);
        this.drawString("STAGE!", 0, 0, -256);
        RenderSystem.popMatrix();
    }

    public RealmsMainScreen func_223942_f() {
        return new RealmsMainScreen(this.field_224019_h);
    }

    public static void func_227932_a_(IResourceManager iResourceManager) {
        Collection<ResourceLocation> collection = iResourceManager.func_199003_a("textures/gui/images", string -> string.endsWith(".png"));
        field_227918_e_ = (List)collection.stream().filter(resourceLocation -> resourceLocation.func_110624_b().equals("realms")).collect(ImmutableList.toImmutableList());
    }

    static {
        field_227918_e_ = ImmutableList.of();
        field_224017_f = new RealmsDataFetcher();
        field_224018_g = -1;
    }

    class CloseButton
    extends RealmsButton {
        public CloseButton() {
            super(11, RealmsMainScreen.this.func_223989_B() + 4, RealmsMainScreen.this.func_223932_C() + 4, 12, 12, RealmsScreen.getLocalizedString("mco.selectServer.close"));
        }

        @Override
        public void tick() {
            super.tick();
        }

        @Override
        public void render(int n, int n2, float f) {
            super.render(n, n2, f);
        }

        @Override
        public void renderButton(int n, int n2, float f) {
            RealmsScreen.bind("realms:textures/gui/realms/cross_icon.png");
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.pushMatrix();
            RealmsScreen.blit(this.func_214457_x(), this.func_223291_y_(), 0.0f, this.getProxy().isHovered() ? 12.0f : 0.0f, 12, 12, 12, 24);
            RenderSystem.popMatrix();
            if (this.getProxy().isMouseOver(n, n2)) {
                RealmsMainScreen.this.field_224027_p = this.getProxy().getMessage();
            }
        }

        @Override
        public void onPress() {
            RealmsMainScreen.this.func_223955_A();
        }
    }

    class InfoButton
    extends RealmsButton {
        public InfoButton() {
            super(10, RealmsMainScreen.this.width() - 37, 6, 20, 20, RealmsScreen.getLocalizedString("mco.selectServer.info"));
        }

        @Override
        public void tick() {
            super.tick();
        }

        @Override
        public void render(int n, int n2, float f) {
            super.render(n, n2, f);
        }

        @Override
        public void renderButton(int n, int n2, float f) {
            RealmsMainScreen.this.func_223933_a(n, n2, this.func_214457_x(), this.func_223291_y_(), this.getProxy().isHovered());
        }

        @Override
        public void onPress() {
            RealmsMainScreen.this.field_224035_x = !RealmsMainScreen.this.field_224035_x;
        }
    }

    class NewsButton
    extends RealmsButton {
        public NewsButton() {
            super(9, RealmsMainScreen.this.width() - 62, 6, 20, 20, "");
        }

        @Override
        public void tick() {
            this.setMessage(Realms.getLocalizedString("mco.news", new Object[0]));
        }

        @Override
        public void render(int n, int n2, float f) {
            super.render(n, n2, f);
        }

        @Override
        public void onPress() {
            if (RealmsMainScreen.this.field_223996_D == null) {
                return;
            }
            RealmsUtil.func_225190_c(RealmsMainScreen.this.field_223996_D);
            if (RealmsMainScreen.this.field_223995_C) {
                RealmsPersistence.RealmsPersistenceData realmsPersistenceData = RealmsPersistence.func_225188_a();
                realmsPersistenceData.field_225186_b = false;
                RealmsMainScreen.this.field_223995_C = false;
                RealmsPersistence.func_225187_a(realmsPersistenceData);
            }
        }

        @Override
        public void renderButton(int n, int n2, float f) {
            RealmsMainScreen.this.func_223982_a(n, n2, RealmsMainScreen.this.field_223995_C, this.func_214457_x(), this.func_223291_y_(), this.getProxy().isHovered(), this.active());
        }
    }

    class PendingInvitesButton
    extends RealmsButton {
        public PendingInvitesButton() {
            super(8, RealmsMainScreen.this.width() / 2 + 47, 6, 22, 22, "");
        }

        @Override
        public void tick() {
            this.setMessage(Realms.getLocalizedString(RealmsMainScreen.this.field_224029_r == 0 ? "mco.invites.nopending" : "mco.invites.pending", new Object[0]));
        }

        @Override
        public void render(int n, int n2, float f) {
            super.render(n, n2, f);
        }

        @Override
        public void onPress() {
            RealmsPendingInvitesScreen realmsPendingInvitesScreen = new RealmsPendingInvitesScreen(RealmsMainScreen.this.field_224019_h);
            Realms.setScreen(realmsPendingInvitesScreen);
        }

        @Override
        public void renderButton(int n, int n2, float f) {
            RealmsMainScreen.this.func_223960_a(n, n2, this.func_214457_x(), this.func_223291_y_(), this.getProxy().isHovered(), this.active());
        }
    }

    class ServerEntry
    extends RealmListEntry {
        final RealmsServer field_223734_a;

        public ServerEntry(RealmsServer realmsServer) {
            this.field_223734_a = realmsServer;
        }

        @Override
        public void render(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.func_223731_a(this.field_223734_a, n3, n2, n6, n7);
        }

        @Override
        public boolean mouseClicked(double d, double d2, int n) {
            if (this.field_223734_a.state == RealmsServer.Status.UNINITIALIZED) {
                RealmsMainScreen.this.field_224021_j = -1L;
                Realms.setScreen(new RealmsCreateRealmScreen(this.field_223734_a, RealmsMainScreen.this));
            } else {
                RealmsMainScreen.this.field_224021_j = this.field_223734_a.id;
            }
            return true;
        }

        private void func_223731_a(RealmsServer realmsServer, int n, int n2, int n3, int n4) {
            this.func_223733_b(realmsServer, n + 36, n2, n3, n4);
        }

        private void func_223733_b(RealmsServer realmsServer2, int n, int n2, int n3, int n4) {
            RealmsServer realmsServer2;
            if (realmsServer2.state == RealmsServer.Status.UNINITIALIZED) {
                RealmsScreen.bind("realms:textures/gui/realms/world_icon.png");
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.enableAlphaTest();
                RenderSystem.pushMatrix();
                RealmsScreen.blit(n + 10, n2 + 6, 0.0f, 0.0f, 40, 20, 40, 20);
                RenderSystem.popMatrix();
                float f = 0.5f + (1.0f + RealmsMth.sin((float)RealmsMainScreen.this.field_224030_s * 0.25f)) * 0.25f;
                int \u26032 = 0xFF000000 | (int)(127.0f * f) << 16 | (int)(255.0f * f) << 8 | (int)(127.0f * f);
                RealmsMainScreen.this.drawCenteredString(RealmsScreen.getLocalizedString("mco.selectServer.uninitialized"), n + 10 + 40 + 75, n2 + 12, \u26032);
                return;
            }
            int n5 = 225;
            \u2603 = 2;
            if (realmsServer2.expired) {
                RealmsMainScreen.this.func_223907_a(n + 225 - 14, n2 + 2, n3, n4);
            } else if (realmsServer2.state == RealmsServer.Status.CLOSED) {
                RealmsMainScreen.this.func_223912_c(n + 225 - 14, n2 + 2, n3, n4);
            } else if (RealmsMainScreen.this.func_223885_h(realmsServer2) && realmsServer2.daysLeft < 7) {
                RealmsMainScreen.this.func_223909_a(n + 225 - 14, n2 + 2, n3, n4, realmsServer2.daysLeft);
            } else if (realmsServer2.state == RealmsServer.Status.OPEN) {
                RealmsMainScreen.this.func_223987_b(n + 225 - 14, n2 + 2, n3, n4);
            }
            if (!RealmsMainScreen.this.func_223885_h(realmsServer2) && !field_224013_b) {
                RealmsMainScreen.this.func_223945_d(n + 225, n2 + 2, n3, n4);
            } else {
                RealmsMainScreen.this.func_223916_e(n + 225, n2 + 2, n3, n4);
            }
            if (!"0".equals(realmsServer2.serverPing.nrOfPlayers)) {
                String string = (Object)((Object)ChatFormatting.GRAY) + "" + realmsServer2.serverPing.nrOfPlayers;
                RealmsMainScreen.this.drawString(string, n + 207 - RealmsMainScreen.this.fontWidth(string), n2 + 3, 0x808080);
                if (n3 >= n + 207 - RealmsMainScreen.this.fontWidth(string) && n3 <= n + 207 && n4 >= n2 + 1 && n4 <= n2 + 10 && n4 < RealmsMainScreen.this.height() - 40 && n4 > 32 && !RealmsMainScreen.this.func_223990_b()) {
                    RealmsMainScreen.this.field_224027_p = realmsServer2.serverPing.playerList;
                }
            }
            if (RealmsMainScreen.this.func_223885_h(realmsServer2) && realmsServer2.expired) {
                boolean bl = false;
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.enableBlend();
                RealmsScreen.bind("minecraft:textures/gui/widgets.png");
                RenderSystem.pushMatrix();
                RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                String \u26033 = RealmsScreen.getLocalizedString("mco.selectServer.expiredList");
                String \u26034 = RealmsScreen.getLocalizedString("mco.selectServer.expiredRenew");
                if (realmsServer2.expiredTrial) {
                    \u26033 = RealmsScreen.getLocalizedString("mco.selectServer.expiredTrial");
                    \u26034 = RealmsScreen.getLocalizedString("mco.selectServer.expiredSubscribe");
                }
                int \u26035 = RealmsMainScreen.this.fontWidth(\u26034) + 17;
                int \u26036 = 16;
                int \u26037 = n + RealmsMainScreen.this.fontWidth(\u26033) + 8;
                int \u26038 = n2 + 13;
                if (n3 >= \u26037 && n3 < \u26037 + \u26035 && n4 > \u26038 && n4 <= \u26038 + 16 & n4 < RealmsMainScreen.this.height() - 40 && n4 > 32 && !RealmsMainScreen.this.func_223990_b()) {
                    bl = true;
                    RealmsMainScreen.this.field_224005_M = true;
                }
                int \u26039 = bl ? 2 : 1;
                RealmsScreen.blit(\u26037, \u26038, 0.0f, 46 + \u26039 * 20, \u26035 / 2, 8, 256, 256);
                RealmsScreen.blit(\u26037 + \u26035 / 2, \u26038, 200 - \u26035 / 2, 46 + \u26039 * 20, \u26035 / 2, 8, 256, 256);
                RealmsScreen.blit(\u26037, \u26038 + 8, 0.0f, 46 + \u26039 * 20 + 12, \u26035 / 2, 8, 256, 256);
                RealmsScreen.blit(\u26037 + \u26035 / 2, \u26038 + 8, 200 - \u26035 / 2, 46 + \u26039 * 20 + 12, \u26035 / 2, 8, 256, 256);
                RenderSystem.popMatrix();
                RenderSystem.disableBlend();
                int \u260310 = n2 + 11 + 5;
                int \u260311 = bl ? 0xFFFFA0 : 0xFFFFFF;
                RealmsMainScreen.this.drawString(\u26033, n + 2, \u260310 + 1, 15553363);
                RealmsMainScreen.this.drawCenteredString(\u26034, \u26037 + \u26035 / 2, \u260310 + 1, \u260311);
            } else {
                if (realmsServer2.worldType.equals((Object)RealmsServer.ServerType.MINIGAME)) {
                    int n6 = 0xCCAC5C;
                    String \u260312 = RealmsScreen.getLocalizedString("mco.selectServer.minigame") + " ";
                    \u2603 = RealmsMainScreen.this.fontWidth(\u260312);
                    RealmsMainScreen.this.drawString(\u260312, n + 2, n2 + 12, 0xCCAC5C);
                    RealmsMainScreen.this.drawString(realmsServer2.getMinigameName(), n + 2 + \u2603, n2 + 12, 0x808080);
                } else {
                    RealmsMainScreen.this.drawString(realmsServer2.getDescription(), n + 2, n2 + 12, 0x808080);
                }
                if (!RealmsMainScreen.this.func_223885_h(realmsServer2)) {
                    RealmsMainScreen.this.drawString(realmsServer2.owner, n + 2, n2 + 12 + 11, 0x808080);
                }
            }
            RealmsMainScreen.this.drawString(realmsServer2.getName(), n + 2, n2 + 1, 0xFFFFFF);
            RealmsTextureManager.func_225205_a(realmsServer2.ownerUUID, () -> {
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                RealmsScreen.blit(n - 36, n2, 8.0f, 8.0f, 8, 8, 32, 32, 64, 64);
                RealmsScreen.blit(n - 36, n2, 40.0f, 8.0f, 8, 8, 32, 32, 64, 64);
            });
        }
    }

    class TrialServerEntry
    extends RealmListEntry {
        @Override
        public void render(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.func_223736_a(n, n3, n2, n6, n7);
        }

        @Override
        public boolean mouseClicked(double d, double d2, int n) {
            RealmsMainScreen.this.field_224035_x = true;
            return true;
        }

        private void func_223736_a(int n, int n2, int n3, int n4, int n5) {
            \u2603 = n3 + 8;
            \u2603 = 0;
            String string = RealmsScreen.getLocalizedString("mco.trial.message.line1") + "\\n" + RealmsScreen.getLocalizedString("mco.trial.message.line2");
            boolean \u26032 = false;
            if (n2 <= n4 && n4 <= RealmsMainScreen.this.field_224020_i.getScroll() && n3 <= n5 && n5 <= n3 + 32) {
                \u26032 = true;
            }
            int \u26033 = 0x7FFF7F;
            if (\u26032 && !RealmsMainScreen.this.func_223990_b()) {
                \u26033 = 6077788;
            }
            for (String string2 : string.split("\\\\n")) {
                RealmsMainScreen.this.drawCenteredString(string2, RealmsMainScreen.this.width() / 2, \u2603 + \u2603, \u26033);
                \u2603 += 10;
            }
        }
    }

    class ServerList
    extends RealmsObjectSelectionList<RealmListEntry> {
        public ServerList() {
            super(RealmsMainScreen.this.width(), RealmsMainScreen.this.height(), 32, RealmsMainScreen.this.height() - 40, 36);
        }

        @Override
        public boolean isFocused() {
            return RealmsMainScreen.this.isFocused(this);
        }

        @Override
        public boolean keyPressed(int n, int n2, int n3) {
            if (n == 257 || n == 32 || n == 335) {
                Object e = this.getSelected();
                if (e == null) {
                    return super.keyPressed(n, n2, n3);
                }
                return ((RealmListEntry)e).mouseClicked(0.0, 0.0, 0);
            }
            return false;
        }

        @Override
        public boolean mouseClicked(double d, double d2, int n) {
            if (n == 0 && d < (double)this.getScrollbarPosition() && d2 >= (double)this.y0() && d2 <= (double)this.y1()) {
                \u2603 = RealmsMainScreen.this.field_224020_i.getRowLeft();
                \u2603 = this.getScrollbarPosition();
                \u2603 = (int)Math.floor(d2 - (double)this.y0()) - this.headerHeight() + this.getScroll() - 4;
                \u2603 = \u2603 / this.itemHeight();
                if (d >= (double)\u2603 && d <= (double)\u2603 && \u2603 >= 0 && \u2603 >= 0 && \u2603 < this.getItemCount()) {
                    this.itemClicked(\u2603, \u2603, d, d2, this.width());
                    RealmsMainScreen.this.field_224003_K = RealmsMainScreen.this.field_224003_K + 7;
                    this.selectItem(\u2603);
                }
                return true;
            }
            return super.mouseClicked(d, d2, n);
        }

        @Override
        public void selectItem(int n2) {
            RealmsServer \u26032;
            this.setSelected(n2);
            if (n2 == -1) {
                return;
            }
            if (RealmsMainScreen.this.func_223928_a()) {
                if (n2 == 0) {
                    Realms.narrateNow(RealmsScreen.getLocalizedString("mco.trial.message.line1"), RealmsScreen.getLocalizedString("mco.trial.message.line2"));
                    \u26032 = null;
                } else {
                    int n2;
                    if (n2 - 1 >= RealmsMainScreen.this.field_224028_q.size()) {
                        RealmsMainScreen.this.field_224021_j = -1L;
                        return;
                    }
                    \u26032 = (RealmsServer)RealmsMainScreen.this.field_224028_q.get(n2 - 1);
                }
            } else {
                if (n2 >= RealmsMainScreen.this.field_224028_q.size()) {
                    RealmsMainScreen.this.field_224021_j = -1L;
                    return;
                }
                \u26032 = (RealmsServer)RealmsMainScreen.this.field_224028_q.get(n2);
            }
            RealmsMainScreen.this.func_223915_a(\u26032);
            if (\u26032 == null) {
                RealmsMainScreen.this.field_224021_j = -1L;
                return;
            }
            if (\u26032.state == RealmsServer.Status.UNINITIALIZED) {
                Realms.narrateNow(RealmsScreen.getLocalizedString("mco.selectServer.uninitialized") + RealmsScreen.getLocalizedString("mco.gui.button"));
                RealmsMainScreen.this.field_224021_j = -1L;
                return;
            }
            RealmsMainScreen.this.field_224021_j = \u26032.id;
            if (RealmsMainScreen.this.field_224003_K >= 10 && RealmsMainScreen.this.field_224022_k.active()) {
                RealmsMainScreen.this.func_223911_a(RealmsMainScreen.this.func_223967_a(RealmsMainScreen.this.field_224021_j), RealmsMainScreen.this);
            }
            Realms.narrateNow(RealmsScreen.getLocalizedString("narrator.select", \u26032.name));
        }

        @Override
        public void itemClicked(int n, int n2, double d, double d2, int n3) {
            if (RealmsMainScreen.this.func_223928_a()) {
                if (n2 == 0) {
                    RealmsMainScreen.this.field_224035_x = true;
                    return;
                }
                --n2;
            }
            if (n2 >= RealmsMainScreen.this.field_224028_q.size()) {
                return;
            }
            RealmsServer realmsServer = (RealmsServer)RealmsMainScreen.this.field_224028_q.get(n2);
            if (realmsServer == null) {
                return;
            }
            if (realmsServer.state == RealmsServer.Status.UNINITIALIZED) {
                RealmsMainScreen.this.field_224021_j = -1L;
                Realms.setScreen(new RealmsCreateRealmScreen(realmsServer, RealmsMainScreen.this));
            } else {
                RealmsMainScreen.this.field_224021_j = realmsServer.id;
            }
            if (RealmsMainScreen.this.field_224027_p != null && RealmsMainScreen.this.field_224027_p.equals(RealmsScreen.getLocalizedString("mco.selectServer.configure"))) {
                RealmsMainScreen.this.field_224021_j = realmsServer.id;
                RealmsMainScreen.this.func_223966_f(realmsServer);
            } else if (RealmsMainScreen.this.field_224027_p != null && RealmsMainScreen.this.field_224027_p.equals(RealmsScreen.getLocalizedString("mco.selectServer.leave"))) {
                RealmsMainScreen.this.field_224021_j = realmsServer.id;
                RealmsMainScreen.this.func_223906_g(realmsServer);
            } else if (RealmsMainScreen.this.func_223885_h(realmsServer) && realmsServer.expired && RealmsMainScreen.this.field_224005_M) {
                RealmsMainScreen.this.func_223930_q();
            }
        }

        @Override
        public int getMaxPosition() {
            return this.getItemCount() * 36;
        }

        @Override
        public int getRowWidth() {
            return 300;
        }
    }
}

