/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.realmsclient.client.RealmsClientConfig;
import com.mojang.realmsclient.client.RealmsError;
import com.mojang.realmsclient.client.Request;
import com.mojang.realmsclient.dto.BackupList;
import com.mojang.realmsclient.dto.Ops;
import com.mojang.realmsclient.dto.PendingInvitesList;
import com.mojang.realmsclient.dto.PingResult;
import com.mojang.realmsclient.dto.PlayerInfo;
import com.mojang.realmsclient.dto.RealmsDescriptionDto;
import com.mojang.realmsclient.dto.RealmsNews;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsServerAddress;
import com.mojang.realmsclient.dto.RealmsServerList;
import com.mojang.realmsclient.dto.RealmsServerPlayerLists;
import com.mojang.realmsclient.dto.RealmsWorldOptions;
import com.mojang.realmsclient.dto.RealmsWorldResetDto;
import com.mojang.realmsclient.dto.Subscription;
import com.mojang.realmsclient.dto.UploadInfo;
import com.mojang.realmsclient.dto.WorldDownload;
import com.mojang.realmsclient.dto.WorldTemplatePaginatedList;
import com.mojang.realmsclient.exception.RealmsHttpException;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.exception.RetryCallException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.realms.Realms;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsClient {
    public static Environment field_224944_a = Environment.PRODUCTION;
    private static boolean field_224945_b;
    private static final Logger field_224946_c;
    private final String field_224947_d;
    private final String field_224948_e;
    private static final Gson field_224949_f;

    public static RealmsClient func_224911_a() {
        String string = Realms.userName();
        \u2603 = Realms.sessionId();
        if (string == null || \u2603 == null) {
            return null;
        }
        if (!field_224945_b) {
            field_224945_b = true;
            \u2603 = System.getenv("realms.environment");
            if (\u2603 == null) {
                \u2603 = System.getProperty("realms.environment");
            }
            if (\u2603 != null) {
                if ("LOCAL".equals(\u2603)) {
                    RealmsClient.func_224941_d();
                } else if ("STAGE".equals(\u2603)) {
                    RealmsClient.func_224940_b();
                }
            }
        }
        return new RealmsClient(\u2603, string, Realms.getProxy());
    }

    public static void func_224940_b() {
        field_224944_a = Environment.STAGE;
    }

    public static void func_224921_c() {
        field_224944_a = Environment.PRODUCTION;
    }

    public static void func_224941_d() {
        field_224944_a = Environment.LOCAL;
    }

    public RealmsClient(String string, String string2, Proxy proxy) {
        this.field_224947_d = string;
        this.field_224948_e = string2;
        RealmsClientConfig.func_224896_a(proxy);
    }

    public RealmsServerList func_224902_e() throws RealmsServiceException, IOException {
        String string = this.func_224926_c("worlds");
        \u2603 = this.func_224938_a(Request.func_224953_a(string));
        return RealmsServerList.parse(\u2603);
    }

    public RealmsServer func_224935_a(long l) throws RealmsServiceException, IOException {
        String string = this.func_224926_c("worlds" + "/$ID".replace("$ID", String.valueOf(l)));
        \u2603 = this.func_224938_a(Request.func_224953_a(string));
        return RealmsServer.parse(\u2603);
    }

    public RealmsServerPlayerLists func_224915_f() throws RealmsServiceException {
        String string = this.func_224926_c("activities/liveplayerlist");
        \u2603 = this.func_224938_a(Request.func_224953_a(string));
        return RealmsServerPlayerLists.parse(\u2603);
    }

    public RealmsServerAddress func_224904_b(long l) throws RealmsServiceException, IOException {
        String string = this.func_224926_c("worlds" + "/v1/$ID/join/pc".replace("$ID", "" + l));
        \u2603 = this.func_224938_a(Request.func_224960_a(string, 5000, 30000));
        return RealmsServerAddress.parse(\u2603);
    }

    public void func_224900_a(long l, String string, String string2) throws RealmsServiceException, IOException {
        RealmsDescriptionDto realmsDescriptionDto = new RealmsDescriptionDto(string, string2);
        String \u26032 = this.func_224926_c("worlds" + "/$WORLD_ID/initialize".replace("$WORLD_ID", String.valueOf(l)));
        String \u26033 = field_224949_f.toJson((Object)realmsDescriptionDto);
        this.func_224938_a(Request.func_224959_a(\u26032, \u26033, 5000, 10000));
    }

    public Boolean func_224918_g() throws RealmsServiceException, IOException {
        String string = this.func_224926_c("mco/available");
        \u2603 = this.func_224938_a(Request.func_224953_a(string));
        return Boolean.valueOf(\u2603);
    }

    public Boolean func_224931_h() throws RealmsServiceException, IOException {
        String string = this.func_224926_c("mco/stageAvailable");
        \u2603 = this.func_224938_a(Request.func_224953_a(string));
        return Boolean.valueOf(\u2603);
    }

    public CompatibleVersionResponse func_224939_i() throws RealmsServiceException, IOException {
        String string = this.func_224926_c("mco/client/compatible");
        \u2603 = this.func_224938_a(Request.func_224953_a(string));
        try {
            CompatibleVersionResponse compatibleVersionResponse = CompatibleVersionResponse.valueOf(\u2603);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RealmsServiceException(500, "Could not check compatible version, got response: " + \u2603, -1, "");
        }
        return compatibleVersionResponse;
    }

    public void func_224908_a(long l, String string) throws RealmsServiceException {
        \u2603 = this.func_224926_c("invites" + "/$WORLD_ID/invite/$UUID".replace("$WORLD_ID", String.valueOf(l)).replace("$UUID", string));
        this.func_224938_a(Request.func_224952_b(\u2603));
    }

    public void func_224912_c(long l) throws RealmsServiceException {
        String string = this.func_224926_c("invites" + "/$WORLD_ID".replace("$WORLD_ID", String.valueOf(l)));
        this.func_224938_a(Request.func_224952_b(string));
    }

    public RealmsServer func_224910_b(long l, String string) throws RealmsServiceException, IOException {
        PlayerInfo playerInfo = new PlayerInfo();
        playerInfo.setName(string);
        String \u26032 = this.func_224926_c("invites" + "/$WORLD_ID".replace("$WORLD_ID", String.valueOf(l)));
        String \u26033 = this.func_224938_a(Request.func_224951_b(\u26032, field_224949_f.toJson((Object)playerInfo)));
        return RealmsServer.parse(\u26033);
    }

    public BackupList func_224923_d(long l) throws RealmsServiceException {
        String string = this.func_224926_c("worlds" + "/$WORLD_ID/backups".replace("$WORLD_ID", String.valueOf(l)));
        \u2603 = this.func_224938_a(Request.func_224953_a(string));
        return BackupList.parse(\u2603);
    }

    public void func_224922_b(long l, String string, String string2) throws RealmsServiceException, UnsupportedEncodingException {
        RealmsDescriptionDto realmsDescriptionDto = new RealmsDescriptionDto(string, string2);
        String \u26032 = this.func_224926_c("worlds" + "/$WORLD_ID".replace("$WORLD_ID", String.valueOf(l)));
        this.func_224938_a(Request.func_224951_b(\u26032, field_224949_f.toJson((Object)realmsDescriptionDto)));
    }

    public void func_224925_a(long l, int n, RealmsWorldOptions realmsWorldOptions) throws RealmsServiceException, UnsupportedEncodingException {
        String string = this.func_224926_c("worlds" + "/$WORLD_ID/slot/$SLOT_ID".replace("$WORLD_ID", String.valueOf(l)).replace("$SLOT_ID", String.valueOf(n)));
        \u2603 = realmsWorldOptions.toJson();
        this.func_224938_a(Request.func_224951_b(string, \u2603));
    }

    public boolean func_224927_a(long l, int n) throws RealmsServiceException {
        String string = this.func_224926_c("worlds" + "/$WORLD_ID/slot/$SLOT_ID".replace("$WORLD_ID", String.valueOf(l)).replace("$SLOT_ID", String.valueOf(n)));
        \u2603 = this.func_224938_a(Request.func_224965_c(string, ""));
        return Boolean.valueOf(\u2603);
    }

    public void func_224928_c(long l, String string) throws RealmsServiceException {
        \u2603 = this.func_224907_b("worlds" + "/$WORLD_ID/backups".replace("$WORLD_ID", String.valueOf(l)), "backupId=" + string);
        this.func_224938_a(Request.func_224966_b(\u2603, "", 40000, 600000));
    }

    public WorldTemplatePaginatedList func_224930_a(int n, int n2, RealmsServer.ServerType serverType) throws RealmsServiceException {
        String string = this.func_224907_b("worlds" + "/templates/$WORLD_TYPE".replace("$WORLD_TYPE", serverType.toString()), String.format("page=%d&pageSize=%d", n, n2));
        \u2603 = this.func_224938_a(Request.func_224953_a(string));
        return WorldTemplatePaginatedList.parse(\u2603);
    }

    public Boolean func_224905_d(long l, String string) throws RealmsServiceException {
        \u2603 = "/minigames/$MINIGAME_ID/$WORLD_ID".replace("$MINIGAME_ID", string).replace("$WORLD_ID", String.valueOf(l));
        \u2603 = this.func_224926_c("worlds" + \u2603);
        return Boolean.valueOf(this.func_224938_a(Request.func_224965_c(\u2603, "")));
    }

    public Ops func_224906_e(long l, String string) throws RealmsServiceException {
        \u2603 = "/$WORLD_ID/$PROFILE_UUID".replace("$WORLD_ID", String.valueOf(l)).replace("$PROFILE_UUID", string);
        \u2603 = this.func_224926_c("ops" + \u2603);
        return Ops.parse(this.func_224938_a(Request.func_224951_b(\u2603, "")));
    }

    public Ops func_224929_f(long l, String string) throws RealmsServiceException {
        \u2603 = "/$WORLD_ID/$PROFILE_UUID".replace("$WORLD_ID", String.valueOf(l)).replace("$PROFILE_UUID", string);
        \u2603 = this.func_224926_c("ops" + \u2603);
        return Ops.parse(this.func_224938_a(Request.func_224952_b(\u2603)));
    }

    public Boolean func_224942_e(long l) throws RealmsServiceException, IOException {
        String string = this.func_224926_c("worlds" + "/$WORLD_ID/open".replace("$WORLD_ID", String.valueOf(l)));
        \u2603 = this.func_224938_a(Request.func_224965_c(string, ""));
        return Boolean.valueOf(\u2603);
    }

    public Boolean func_224932_f(long l) throws RealmsServiceException, IOException {
        String string = this.func_224926_c("worlds" + "/$WORLD_ID/close".replace("$WORLD_ID", String.valueOf(l)));
        \u2603 = this.func_224938_a(Request.func_224965_c(string, ""));
        return Boolean.valueOf(\u2603);
    }

    public Boolean func_224943_a(long l, String string, Integer n, boolean bl) throws RealmsServiceException, IOException {
        RealmsWorldResetDto realmsWorldResetDto = new RealmsWorldResetDto(string, -1L, n, bl);
        String \u26032 = this.func_224926_c("worlds" + "/$WORLD_ID/reset".replace("$WORLD_ID", String.valueOf(l)));
        String \u26033 = this.func_224938_a(Request.func_224959_a(\u26032, field_224949_f.toJson((Object)realmsWorldResetDto), 30000, 80000));
        return Boolean.valueOf(\u26033);
    }

    public Boolean func_224924_g(long l, String string) throws RealmsServiceException, IOException {
        RealmsWorldResetDto realmsWorldResetDto = new RealmsWorldResetDto(null, Long.valueOf(string), -1, false);
        String \u26032 = this.func_224926_c("worlds" + "/$WORLD_ID/reset".replace("$WORLD_ID", String.valueOf(l)));
        String \u26033 = this.func_224938_a(Request.func_224959_a(\u26032, field_224949_f.toJson((Object)realmsWorldResetDto), 30000, 80000));
        return Boolean.valueOf(\u26033);
    }

    public Subscription func_224933_g(long l) throws RealmsServiceException, IOException {
        String string = this.func_224926_c("subscriptions" + "/$WORLD_ID".replace("$WORLD_ID", String.valueOf(l)));
        \u2603 = this.func_224938_a(Request.func_224953_a(string));
        return Subscription.parse(\u2603);
    }

    public int func_224909_j() throws RealmsServiceException {
        String string = this.func_224926_c("invites/count/pending");
        \u2603 = this.func_224938_a(Request.func_224953_a(string));
        return Integer.parseInt(\u2603);
    }

    public PendingInvitesList func_224919_k() throws RealmsServiceException {
        String string = this.func_224926_c("invites/pending");
        \u2603 = this.func_224938_a(Request.func_224953_a(string));
        return PendingInvitesList.parse(\u2603);
    }

    public void func_224901_a(String string) throws RealmsServiceException {
        \u2603 = this.func_224926_c("invites" + "/accept/$INVITATION_ID".replace("$INVITATION_ID", string));
        this.func_224938_a(Request.func_224965_c(\u2603, ""));
    }

    public WorldDownload func_224917_b(long l, int n) throws RealmsServiceException {
        String string = this.func_224926_c("worlds" + "/$WORLD_ID/slot/$SLOT_ID/download".replace("$WORLD_ID", String.valueOf(l)).replace("$SLOT_ID", String.valueOf(n)));
        \u2603 = this.func_224938_a(Request.func_224953_a(string));
        return WorldDownload.parse(\u2603);
    }

    public UploadInfo func_224934_h(long l, String string) throws RealmsServiceException {
        \u2603 = this.func_224926_c("worlds" + "/$WORLD_ID/backups/upload".replace("$WORLD_ID", String.valueOf(l)));
        UploadInfo uploadInfo = new UploadInfo();
        if (string != null) {
            uploadInfo.setToken(string);
        }
        GsonBuilder \u26032 = new GsonBuilder();
        \u26032.excludeFieldsWithoutExposeAnnotation();
        Gson \u26033 = \u26032.create();
        String \u26034 = \u26033.toJson((Object)uploadInfo);
        return UploadInfo.parse(this.func_224938_a(Request.func_224965_c(\u2603, \u26034)));
    }

    public void func_224913_b(String string) throws RealmsServiceException {
        \u2603 = this.func_224926_c("invites" + "/reject/$INVITATION_ID".replace("$INVITATION_ID", string));
        this.func_224938_a(Request.func_224965_c(\u2603, ""));
    }

    public void func_224937_l() throws RealmsServiceException {
        String string = this.func_224926_c("mco/tos/agreed");
        this.func_224938_a(Request.func_224951_b(string, ""));
    }

    public RealmsNews func_224920_m() throws RealmsServiceException, IOException {
        String string = this.func_224926_c("mco/v1/news");
        \u2603 = this.func_224938_a(Request.func_224960_a(string, 5000, 10000));
        return RealmsNews.parse(\u2603);
    }

    public void func_224903_a(PingResult pingResult) throws RealmsServiceException {
        String string = this.func_224926_c("regions/ping/stat");
        this.func_224938_a(Request.func_224951_b(string, field_224949_f.toJson((Object)pingResult)));
    }

    public Boolean func_224914_n() throws RealmsServiceException, IOException {
        String string = this.func_224926_c("trial");
        \u2603 = this.func_224938_a(Request.func_224953_a(string));
        return Boolean.valueOf(\u2603);
    }

    public void func_224916_h(long l) throws RealmsServiceException, IOException {
        String string = this.func_224926_c("worlds" + "/$WORLD_ID".replace("$WORLD_ID", String.valueOf(l)));
        this.func_224938_a(Request.func_224952_b(string));
    }

    private String func_224926_c(String string) {
        return this.func_224907_b(string, null);
    }

    private String func_224907_b(String string, String string2) {
        try {
            URI uRI = new URI(RealmsClient.field_224944_a.field_224899_e, RealmsClient.field_224944_a.field_224898_d, "/" + string, string2, null);
            return uRI.toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return null;
        }
    }

    private String func_224938_a(Request<?> request) throws RealmsServiceException {
        request.func_224962_a("sid", this.field_224947_d);
        request.func_224962_a("user", this.field_224948_e);
        request.func_224962_a("version", Realms.getMinecraftVersionString());
        try {
            int n = request.func_224958_b();
            if (n == 503) {
                \u2603 = request.func_224957_a();
                throw new RetryCallException(\u2603);
            }
            String \u26032 = request.func_224963_c();
            if (n < 200 || n >= 300) {
                if (n == 401) {
                    String string = request.func_224956_c("WWW-Authenticate");
                    field_224946_c.info("Could not authorize you against Realms server: " + string);
                    throw new RealmsServiceException(n, string, -1, string);
                }
                if (\u26032 == null || \u26032.length() == 0) {
                    field_224946_c.error("Realms error code: " + n + " message: " + \u26032);
                    throw new RealmsServiceException(n, \u26032, n, "");
                }
                RealmsError realmsError = new RealmsError(\u26032);
                field_224946_c.error("Realms http code: " + n + " -  error code: " + realmsError.func_224974_b() + " -  message: " + realmsError.func_224973_a() + " - raw body: " + \u26032);
                throw new RealmsServiceException(n, \u26032, realmsError);
            }
            return \u26032;
        }
        catch (RealmsHttpException realmsHttpException) {
            throw new RealmsServiceException(500, "Could not connect to Realms: " + realmsHttpException.getMessage(), -1, "");
        }
    }

    static {
        field_224946_c = LogManager.getLogger();
        field_224949_f = new Gson();
    }

    public static enum CompatibleVersionResponse {
        COMPATIBLE,
        OUTDATED,
        OTHER;

    }

    public static enum Environment {
        PRODUCTION("pc.realms.minecraft.net", "https"),
        STAGE("pc-stage.realms.minecraft.net", "https"),
        LOCAL("localhost:8080", "http");

        public String field_224898_d;
        public String field_224899_e;

        private Environment(String string2, String string3) {
            this.field_224898_d = string2;
            this.field_224899_e = string3;
        }
    }
}

