/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.Backup;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.RealmsConstants;
import com.mojang.realmsclient.gui.screens.RealmsBackupInfoScreen;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongConfirmationScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.RealmsTasks;
import com.mojang.realmsclient.util.RealmsUtil;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.realms.RealmListEntry;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsLabel;
import net.minecraft.realms.RealmsObjectSelectionList;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsBackupScreen
extends RealmsScreen {
    private static final Logger field_224114_a = LogManager.getLogger();
    private static int field_224115_b = -1;
    private final RealmsConfigureWorldScreen field_224116_c;
    private List<Backup> field_224117_d = Collections.emptyList();
    private String field_224118_e;
    private BackupObjectSelectionList field_224119_f;
    private int field_224120_g = -1;
    private final int field_224121_h;
    private RealmsButton field_224122_i;
    private RealmsButton field_224123_j;
    private RealmsButton field_224124_k;
    private Boolean field_224125_l = false;
    private final RealmsServer field_224126_m;
    private RealmsLabel field_224127_n;

    public RealmsBackupScreen(RealmsConfigureWorldScreen realmsConfigureWorldScreen, RealmsServer realmsServer, int n) {
        this.field_224116_c = realmsConfigureWorldScreen;
        this.field_224126_m = realmsServer;
        this.field_224121_h = n;
    }

    @Override
    public void init() {
        this.setKeyboardHandlerSendRepeatsToGui(true);
        this.field_224119_f = new BackupObjectSelectionList();
        if (field_224115_b != -1) {
            this.field_224119_f.scroll(field_224115_b);
        }
        new Thread("Realms-fetch-backups"){

            @Override
            public void run() {
                RealmsClient realmsClient = RealmsClient.func_224911_a();
                try {
                    List<Backup> list = realmsClient.func_224923_d((long)((RealmsBackupScreen)RealmsBackupScreen.this).field_224126_m.id).backups;
                    Realms.execute(() -> {
                        RealmsBackupScreen.this.field_224117_d = list;
                        RealmsBackupScreen.this.field_224125_l = RealmsBackupScreen.this.field_224117_d.isEmpty();
                        RealmsBackupScreen.this.field_224119_f.clear();
                        for (Backup backup : RealmsBackupScreen.this.field_224117_d) {
                            RealmsBackupScreen.this.field_224119_f.func_223867_a(backup);
                        }
                        RealmsBackupScreen.this.func_224112_b();
                    });
                }
                catch (RealmsServiceException realmsServiceException) {
                    field_224114_a.error("Couldn't request backups", (Throwable)realmsServiceException);
                }
            }
        }.start();
        this.func_224098_c();
    }

    private void func_224112_b() {
        if (this.field_224117_d.size() <= 1) {
            return;
        }
        for (int i = 0; i < this.field_224117_d.size() - 1; ++i) {
            Backup backup = this.field_224117_d.get(i);
            \u2603 = this.field_224117_d.get(i + 1);
            if (backup.metadata.isEmpty() || \u2603.metadata.isEmpty()) continue;
            for (String string : backup.metadata.keySet()) {
                if (!string.contains("Uploaded") && \u2603.metadata.containsKey(string)) {
                    if (backup.metadata.get(string).equals(\u2603.metadata.get(string))) continue;
                    this.func_224103_a(backup, string);
                    continue;
                }
                this.func_224103_a(backup, string);
            }
        }
    }

    private void func_224103_a(Backup backup, String string) {
        if (string.contains("Uploaded")) {
            \u2603 = DateFormat.getDateTimeInstance(3, 3).format(backup.lastModifiedDate);
            backup.changeList.put(string, \u2603);
            backup.setUploadedVersion(true);
        } else {
            backup.changeList.put(string, backup.metadata.get(string));
        }
    }

    private void func_224098_c() {
        this.field_224122_i = new RealmsButton(2, this.width() - 135, RealmsConstants.func_225109_a(1), 120, 20, RealmsBackupScreen.getLocalizedString("mco.backup.button.download")){

            @Override
            public void onPress() {
                RealmsBackupScreen.this.func_224088_g();
            }
        };
        this.buttonsAdd(this.field_224122_i);
        this.field_224123_j = new RealmsButton(3, this.width() - 135, RealmsConstants.func_225109_a(3), 120, 20, RealmsBackupScreen.getLocalizedString("mco.backup.button.restore")){

            @Override
            public void onPress() {
                RealmsBackupScreen.this.func_224104_b(RealmsBackupScreen.this.field_224120_g);
            }
        };
        this.buttonsAdd(this.field_224123_j);
        this.field_224124_k = new RealmsButton(4, this.width() - 135, RealmsConstants.func_225109_a(5), 120, 20, RealmsBackupScreen.getLocalizedString("mco.backup.changes.tooltip")){

            @Override
            public void onPress() {
                Realms.setScreen(new RealmsBackupInfoScreen(RealmsBackupScreen.this, (Backup)RealmsBackupScreen.this.field_224117_d.get(RealmsBackupScreen.this.field_224120_g)));
                RealmsBackupScreen.this.field_224120_g = -1;
            }
        };
        this.buttonsAdd(this.field_224124_k);
        this.buttonsAdd(new RealmsButton(0, this.width() - 100, this.height() - 35, 85, 20, RealmsBackupScreen.getLocalizedString("gui.back")){

            @Override
            public void onPress() {
                Realms.setScreen(RealmsBackupScreen.this.field_224116_c);
            }
        });
        this.addWidget(this.field_224119_f);
        this.field_224127_n = new RealmsLabel(RealmsBackupScreen.getLocalizedString("mco.configure.world.backup"), this.width() / 2, 12, 0xFFFFFF);
        this.addWidget(this.field_224127_n);
        this.focusOn(this.field_224119_f);
        this.func_224113_d();
        this.narrateLabels();
    }

    private void func_224113_d() {
        this.field_224123_j.setVisible(this.func_224111_f());
        this.field_224124_k.setVisible(this.func_224096_e());
    }

    private boolean func_224096_e() {
        if (this.field_224120_g == -1) {
            return false;
        }
        return !this.field_224117_d.get((int)this.field_224120_g).changeList.isEmpty();
    }

    private boolean func_224111_f() {
        if (this.field_224120_g == -1) {
            return false;
        }
        return !this.field_224126_m.expired;
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (n == 256) {
            Realms.setScreen(this.field_224116_c);
            return true;
        }
        return super.keyPressed(n, n2, n3);
    }

    private void func_224104_b(int n) {
        if (n >= 0 && n < this.field_224117_d.size() && !this.field_224126_m.expired) {
            this.field_224120_g = n;
            Date date = this.field_224117_d.get((int)n).lastModifiedDate;
            String \u26032 = DateFormat.getDateTimeInstance(3, 3).format(date);
            String \u26033 = RealmsUtil.func_225192_a(System.currentTimeMillis() - date.getTime());
            String \u26034 = RealmsBackupScreen.getLocalizedString("mco.configure.world.restore.question.line1", \u26032, \u26033);
            String \u26035 = RealmsBackupScreen.getLocalizedString("mco.configure.world.restore.question.line2");
            Realms.setScreen(new RealmsLongConfirmationScreen(this, RealmsLongConfirmationScreen.Type.Warning, \u26034, \u26035, true, 1));
        }
    }

    private void func_224088_g() {
        String string = RealmsBackupScreen.getLocalizedString("mco.configure.world.restore.download.question.line1");
        \u2603 = RealmsBackupScreen.getLocalizedString("mco.configure.world.restore.download.question.line2");
        Realms.setScreen(new RealmsLongConfirmationScreen(this, RealmsLongConfirmationScreen.Type.Info, string, \u2603, true, 2));
    }

    private void func_224100_h() {
        RealmsTasks.DownloadTask downloadTask = new RealmsTasks.DownloadTask(this.field_224126_m.id, this.field_224121_h, this.field_224126_m.name + " (" + this.field_224126_m.slots.get(this.field_224126_m.activeSlot).getSlotName(this.field_224126_m.activeSlot) + ")", this);
        RealmsLongRunningMcoTaskScreen \u26032 = new RealmsLongRunningMcoTaskScreen(this.field_224116_c.func_224407_b(), downloadTask);
        \u26032.func_224233_a();
        Realms.setScreen(\u26032);
    }

    @Override
    public void confirmResult(boolean bl, int n) {
        if (bl && n == 1) {
            this.func_224097_i();
        } else if (n == 1) {
            this.field_224120_g = -1;
            Realms.setScreen(this);
        } else if (bl && n == 2) {
            this.func_224100_h();
        } else {
            Realms.setScreen(this);
        }
    }

    private void func_224097_i() {
        Backup backup = this.field_224117_d.get(this.field_224120_g);
        this.field_224120_g = -1;
        RealmsTasks.RestoreTask \u26032 = new RealmsTasks.RestoreTask(backup, this.field_224126_m.id, this.field_224116_c);
        RealmsLongRunningMcoTaskScreen \u26033 = new RealmsLongRunningMcoTaskScreen(this.field_224116_c.func_224407_b(), \u26032);
        \u26033.func_224233_a();
        Realms.setScreen(\u26033);
    }

    @Override
    public void render(int n, int n2, float f) {
        this.field_224118_e = null;
        this.renderBackground();
        this.field_224119_f.render(n, n2, f);
        this.field_224127_n.render(this);
        this.drawString(RealmsBackupScreen.getLocalizedString("mco.configure.world.backup"), (this.width() - 150) / 2 - 90, 20, 0xA0A0A0);
        if (this.field_224125_l.booleanValue()) {
            this.drawString(RealmsBackupScreen.getLocalizedString("mco.backup.nobackups"), 20, this.height() / 2 - 10, 0xFFFFFF);
        }
        this.field_224122_i.active(this.field_224125_l == false);
        super.render(n, n2, f);
        if (this.field_224118_e != null) {
            this.func_224090_a(this.field_224118_e, n, n2);
        }
    }

    protected void func_224090_a(String string, int n, int n2) {
        if (string == null) {
            return;
        }
        \u2603 = n + 12;
        \u2603 = n2 - 12;
        \u2603 = this.fontWidth(string);
        this.fillGradient(\u2603 - 3, \u2603 - 3, \u2603 + \u2603 + 3, \u2603 + 8 + 3, -1073741824, -1073741824);
        this.fontDrawShadow(string, \u2603, \u2603, 0xFFFFFF);
    }

    class BackupObjectSelectionListEntry
    extends RealmListEntry {
        final Backup field_223742_a;

        public BackupObjectSelectionListEntry(Backup backup) {
            this.field_223742_a = backup;
        }

        @Override
        public void render(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.func_223740_a(this.field_223742_a, n3 - 40, n2, n6, n7);
        }

        private void func_223740_a(Backup backup, int n, int n2, int n3, int n4) {
            \u2603 = backup.isUploadedVersion() ? -8388737 : 0xFFFFFF;
            RealmsBackupScreen.this.drawString("Backup (" + RealmsUtil.func_225192_a(System.currentTimeMillis() - backup.lastModifiedDate.getTime()) + ")", n + 40, n2 + 1, \u2603);
            RealmsBackupScreen.this.drawString(this.func_223738_a(backup.lastModifiedDate), n + 40, n2 + 12, 0x808080);
            \u2603 = RealmsBackupScreen.this.width() - 175;
            \u2603 = -3;
            \u2603 = \u2603 - 10;
            boolean bl = false;
            if (!((RealmsBackupScreen)RealmsBackupScreen.this).field_224126_m.expired) {
                this.func_223739_a(\u2603, n2 + -3, n3, n4);
            }
            if (!backup.changeList.isEmpty()) {
                this.func_223741_b(\u2603, n2 + 0, n3, n4);
            }
        }

        private String func_223738_a(Date date) {
            return DateFormat.getDateTimeInstance(3, 3).format(date);
        }

        private void func_223739_a(int n, int n2, int n3, int n4) {
            boolean bl = n3 >= n && n3 <= n + 12 && n4 >= n2 && n4 <= n2 + 14 && n4 < RealmsBackupScreen.this.height() - 15 && n4 > 32;
            RealmsScreen.bind("realms:textures/gui/realms/restore_icon.png");
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.pushMatrix();
            RenderSystem.scalef(0.5f, 0.5f, 0.5f);
            RealmsScreen.blit(n * 2, n2 * 2, 0.0f, bl ? 28.0f : 0.0f, 23, 28, 23, 56);
            RenderSystem.popMatrix();
            if (bl) {
                RealmsBackupScreen.this.field_224118_e = RealmsScreen.getLocalizedString("mco.backup.button.restore");
            }
        }

        private void func_223741_b(int n, int n2, int n3, int n4) {
            boolean bl = n3 >= n && n3 <= n + 8 && n4 >= n2 && n4 <= n2 + 8 && n4 < RealmsBackupScreen.this.height() - 15 && n4 > 32;
            RealmsScreen.bind("realms:textures/gui/realms/plus_icon.png");
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.pushMatrix();
            RenderSystem.scalef(0.5f, 0.5f, 0.5f);
            RealmsScreen.blit(n * 2, n2 * 2, 0.0f, bl ? 15.0f : 0.0f, 15, 15, 15, 30);
            RenderSystem.popMatrix();
            if (bl) {
                RealmsBackupScreen.this.field_224118_e = RealmsScreen.getLocalizedString("mco.backup.changes.tooltip");
            }
        }
    }

    class BackupObjectSelectionList
    extends RealmsObjectSelectionList {
        public BackupObjectSelectionList() {
            super(RealmsBackupScreen.this.width() - 150, RealmsBackupScreen.this.height(), 32, RealmsBackupScreen.this.height() - 15, 36);
        }

        public void func_223867_a(Backup backup) {
            this.addEntry(new BackupObjectSelectionListEntry(backup));
        }

        @Override
        public int getRowWidth() {
            return (int)((double)this.width() * 0.93);
        }

        @Override
        public boolean isFocused() {
            return RealmsBackupScreen.this.isFocused(this);
        }

        @Override
        public int getItemCount() {
            return RealmsBackupScreen.this.field_224117_d.size();
        }

        @Override
        public int getMaxPosition() {
            return this.getItemCount() * 36;
        }

        @Override
        public void renderBackground() {
            RealmsBackupScreen.this.renderBackground();
        }

        @Override
        public boolean mouseClicked(double d, double d2, int n) {
            if (n != 0) {
                return false;
            }
            if (d < (double)this.getScrollbarPosition() && d2 >= (double)this.y0() && d2 <= (double)this.y1()) {
                \u2603 = this.width() / 2 - 92;
                \u2603 = this.width();
                \u2603 = (int)Math.floor(d2 - (double)this.y0()) - this.headerHeight() + this.getScroll();
                \u2603 = \u2603 / this.itemHeight();
                if (d >= (double)\u2603 && d <= (double)\u2603 && \u2603 >= 0 && \u2603 >= 0 && \u2603 < this.getItemCount()) {
                    this.selectItem(\u2603);
                    this.itemClicked(\u2603, \u2603, d, d2, this.width());
                }
                return true;
            }
            return false;
        }

        @Override
        public int getScrollbarPosition() {
            return this.width() - 5;
        }

        @Override
        public void itemClicked(int n, int n2, double d, double d2, int n3) {
            \u2603 = this.width() - 35;
            \u2603 = n2 * this.itemHeight() + 36 - this.getScroll();
            \u2603 = \u2603 + 10;
            \u2603 = \u2603 - 3;
            if (d >= (double)\u2603 && d <= (double)(\u2603 + 9) && d2 >= (double)\u2603 && d2 <= (double)(\u2603 + 9)) {
                if (!((Backup)((RealmsBackupScreen)RealmsBackupScreen.this).field_224117_d.get((int)n2)).changeList.isEmpty()) {
                    RealmsBackupScreen.this.field_224120_g = -1;
                    field_224115_b = this.getScroll();
                    Realms.setScreen(new RealmsBackupInfoScreen(RealmsBackupScreen.this, (Backup)RealmsBackupScreen.this.field_224117_d.get(n2)));
                }
            } else if (d >= (double)\u2603 && d < (double)(\u2603 + 13) && d2 >= (double)\u2603 && d2 < (double)(\u2603 + 15)) {
                field_224115_b = this.getScroll();
                RealmsBackupScreen.this.func_224104_b(n2);
            }
        }

        @Override
        public void selectItem(int n) {
            this.setSelected(n);
            if (n != -1) {
                Realms.narrateNow(RealmsScreen.getLocalizedString("narrator.select", ((Backup)((RealmsBackupScreen)RealmsBackupScreen.this).field_224117_d.get((int)n)).lastModifiedDate.toString()));
            }
            this.func_223866_a(n);
        }

        public void func_223866_a(int n) {
            RealmsBackupScreen.this.field_224120_g = n;
            RealmsBackupScreen.this.func_224113_d();
        }
    }
}

