/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsWorldOptions;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.RealmsConstants;
import com.mojang.realmsclient.gui.RealmsServerSlotButton;
import com.mojang.realmsclient.gui.screens.RealmsBackupScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongConfirmationScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.RealmsPlayerScreen;
import com.mojang.realmsclient.gui.screens.RealmsResetWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsScreenWithCallback;
import com.mojang.realmsclient.gui.screens.RealmsSelectWorldTemplateScreen;
import com.mojang.realmsclient.gui.screens.RealmsSettingsScreen;
import com.mojang.realmsclient.gui.screens.RealmsSlotOptionsScreen;
import com.mojang.realmsclient.gui.screens.RealmsSubscriptionInfoScreen;
import com.mojang.realmsclient.util.RealmsTasks;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nullable;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsConfigureWorldScreen
extends RealmsScreenWithCallback<WorldTemplate>
implements RealmsServerSlotButton.IHandler {
    private static final Logger field_224413_a = LogManager.getLogger();
    private String field_224414_b;
    private final RealmsMainScreen field_224415_c;
    @Nullable
    private RealmsServer field_224416_d;
    private final long field_224417_e;
    private int field_224418_f;
    private int field_224419_g;
    private final int field_224420_h = 80;
    private final int field_224421_i = 5;
    private RealmsButton field_224422_j;
    private RealmsButton field_224423_k;
    private RealmsButton field_224424_l;
    private RealmsButton field_224425_m;
    private RealmsButton field_224426_n;
    private RealmsButton field_224427_o;
    private RealmsButton field_224428_p;
    private boolean field_224429_q;
    private int field_224430_r;
    private int field_224431_s;

    public RealmsConfigureWorldScreen(RealmsMainScreen realmsMainScreen, long l) {
        this.field_224415_c = realmsMainScreen;
        this.field_224417_e = l;
    }

    @Override
    public void init() {
        if (this.field_224416_d == null) {
            this.func_224387_a(this.field_224417_e);
        }
        this.field_224418_f = this.width() / 2 - 187;
        this.field_224419_g = this.width() / 2 + 190;
        this.setKeyboardHandlerSendRepeatsToGui(true);
        this.field_224422_j = new RealmsButton(2, this.func_224374_a(0, 3), RealmsConstants.func_225109_a(0), 100, 20, RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.buttons.players")){

            @Override
            public void onPress() {
                Realms.setScreen(new RealmsPlayerScreen(RealmsConfigureWorldScreen.this, RealmsConfigureWorldScreen.this.field_224416_d));
            }
        };
        this.buttonsAdd(this.field_224422_j);
        this.field_224423_k = new RealmsButton(3, this.func_224374_a(1, 3), RealmsConstants.func_225109_a(0), 100, 20, RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.buttons.settings")){

            @Override
            public void onPress() {
                Realms.setScreen(new RealmsSettingsScreen(RealmsConfigureWorldScreen.this, RealmsConfigureWorldScreen.this.field_224416_d.clone()));
            }
        };
        this.buttonsAdd(this.field_224423_k);
        this.field_224424_l = new RealmsButton(4, this.func_224374_a(2, 3), RealmsConstants.func_225109_a(0), 100, 20, RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.buttons.subscription")){

            @Override
            public void onPress() {
                Realms.setScreen(new RealmsSubscriptionInfoScreen(RealmsConfigureWorldScreen.this, RealmsConfigureWorldScreen.this.field_224416_d.clone(), RealmsConfigureWorldScreen.this.field_224415_c));
            }
        };
        this.buttonsAdd(this.field_224424_l);
        for (int i = 1; i < 5; ++i) {
            this.func_224402_a(i);
        }
        this.field_224428_p = new RealmsButton(8, this.func_224411_b(0), RealmsConstants.func_225109_a(13) - 5, 100, 20, RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.buttons.switchminigame")){

            @Override
            public void onPress() {
                RealmsSelectWorldTemplateScreen realmsSelectWorldTemplateScreen = new RealmsSelectWorldTemplateScreen(RealmsConfigureWorldScreen.this, RealmsServer.ServerType.MINIGAME);
                realmsSelectWorldTemplateScreen.func_224483_a(RealmsScreen.getLocalizedString("mco.template.title.minigame"));
                Realms.setScreen(realmsSelectWorldTemplateScreen);
            }
        };
        this.buttonsAdd(this.field_224428_p);
        this.field_224425_m = new RealmsButton(5, this.func_224411_b(0), RealmsConstants.func_225109_a(13) - 5, 90, 20, RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.buttons.options")){

            @Override
            public void onPress() {
                Realms.setScreen(new RealmsSlotOptionsScreen(RealmsConfigureWorldScreen.this, ((RealmsConfigureWorldScreen)RealmsConfigureWorldScreen.this).field_224416_d.slots.get(((RealmsConfigureWorldScreen)RealmsConfigureWorldScreen.this).field_224416_d.activeSlot).clone(), ((RealmsConfigureWorldScreen)RealmsConfigureWorldScreen.this).field_224416_d.worldType, ((RealmsConfigureWorldScreen)RealmsConfigureWorldScreen.this).field_224416_d.activeSlot));
            }
        };
        this.buttonsAdd(this.field_224425_m);
        this.field_224426_n = new RealmsButton(6, this.func_224411_b(1), RealmsConstants.func_225109_a(13) - 5, 90, 20, RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.backup")){

            @Override
            public void onPress() {
                Realms.setScreen(new RealmsBackupScreen(RealmsConfigureWorldScreen.this, RealmsConfigureWorldScreen.this.field_224416_d.clone(), ((RealmsConfigureWorldScreen)RealmsConfigureWorldScreen.this).field_224416_d.activeSlot));
            }
        };
        this.buttonsAdd(this.field_224426_n);
        this.field_224427_o = new RealmsButton(7, this.func_224411_b(2), RealmsConstants.func_225109_a(13) - 5, 90, 20, RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.buttons.resetworld")){

            @Override
            public void onPress() {
                Realms.setScreen(new RealmsResetWorldScreen(RealmsConfigureWorldScreen.this, RealmsConfigureWorldScreen.this.field_224416_d.clone(), RealmsConfigureWorldScreen.this.func_224407_b()));
            }
        };
        this.buttonsAdd(this.field_224427_o);
        this.buttonsAdd(new RealmsButton(0, this.field_224419_g - 80 + 8, RealmsConstants.func_225109_a(13) - 5, 70, 20, RealmsConfigureWorldScreen.getLocalizedString("gui.back")){

            @Override
            public void onPress() {
                RealmsConfigureWorldScreen.this.func_224390_d();
            }
        });
        this.field_224426_n.active(true);
        if (this.field_224416_d == null) {
            this.func_224412_j();
            this.func_224377_h();
            this.field_224422_j.active(false);
            this.field_224423_k.active(false);
            this.field_224424_l.active(false);
        } else {
            this.func_224400_e();
            if (this.func_224376_g()) {
                this.func_224377_h();
            } else {
                this.func_224412_j();
            }
        }
    }

    private void func_224402_a(int n) {
        \u2603 = this.func_224368_c(n);
        \u2603 = RealmsConstants.func_225109_a(5) + 5;
        \u2603 = 100 + n;
        RealmsServerSlotButton realmsServerSlotButton = new RealmsServerSlotButton(\u2603, \u2603, 80, 80, () -> this.field_224416_d, string -> {
            this.field_224414_b = string;
        }, \u2603, n, this);
        this.getProxy().buttonsAdd(realmsServerSlotButton);
    }

    private int func_224411_b(int n) {
        return this.field_224418_f + n * 95;
    }

    private int func_224374_a(int n, int n2) {
        return this.width() / 2 - (n2 * 105 - 5) / 2 + n * 105;
    }

    @Override
    public void tick() {
        this.tickButtons();
        ++this.field_224430_r;
        --this.field_224431_s;
        if (this.field_224431_s < 0) {
            this.field_224431_s = 0;
        }
    }

    @Override
    public void render(int n, int n2, float f) {
        this.field_224414_b = null;
        this.renderBackground();
        this.drawCenteredString(RealmsConfigureWorldScreen.getLocalizedString("mco.configure.worlds.title"), this.width() / 2, RealmsConstants.func_225109_a(4), 0xFFFFFF);
        super.render(n, n2, f);
        if (this.field_224416_d == null) {
            this.drawCenteredString(RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.title"), this.width() / 2, 17, 0xFFFFFF);
            return;
        }
        String string = this.field_224416_d.getName();
        int \u26032 = this.fontWidth(string);
        int \u26033 = this.field_224416_d.state == RealmsServer.Status.CLOSED ? 0xA0A0A0 : 0x7FFF7F;
        int \u26034 = this.fontWidth(RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.title"));
        this.drawCenteredString(RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.title"), this.width() / 2, 12, 0xFFFFFF);
        this.drawCenteredString(string, this.width() / 2, 24, \u26033);
        int \u26035 = Math.min(this.func_224374_a(2, 3) + 80 - 11, this.width() / 2 + \u26032 / 2 + \u26034 / 2 + 10);
        this.func_224379_a(\u26035, 7, n, n2);
        if (this.func_224376_g()) {
            this.drawString(RealmsConfigureWorldScreen.getLocalizedString("mco.configure.current.minigame") + ": " + this.field_224416_d.getMinigameName(), this.field_224418_f + 80 + 20 + 10, RealmsConstants.func_225109_a(13), 0xFFFFFF);
        }
        if (this.field_224414_b != null) {
            this.func_224394_a(this.field_224414_b, n, n2);
        }
    }

    private int func_224368_c(int n) {
        return this.field_224418_f + (n - 1) * 98;
    }

    @Override
    public void removed() {
        this.setKeyboardHandlerSendRepeatsToGui(false);
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (n == 256) {
            this.func_224390_d();
            return true;
        }
        return super.keyPressed(n, n2, n3);
    }

    private void func_224390_d() {
        if (this.field_224429_q) {
            this.field_224415_c.func_223978_e();
        }
        Realms.setScreen(this.field_224415_c);
    }

    private void func_224387_a(long l) {
        new Thread(() -> {
            RealmsClient realmsClient = RealmsClient.func_224911_a();
            try {
                this.field_224416_d = realmsClient.func_224935_a(l);
                this.func_224400_e();
                if (this.func_224376_g()) {
                    this.func_224375_k();
                } else {
                    this.func_224399_i();
                }
            }
            catch (RealmsServiceException \u26032) {
                field_224413_a.error("Couldn't get own world");
                Realms.setScreen(new RealmsGenericErrorScreen(\u26032.getMessage(), (RealmsScreen)this.field_224415_c));
            }
            catch (IOException \u26033) {
                field_224413_a.error("Couldn't parse response getting own world");
            }
        }).start();
    }

    private void func_224400_e() {
        this.field_224422_j.active(!this.field_224416_d.expired);
        this.field_224423_k.active(!this.field_224416_d.expired);
        this.field_224424_l.active(true);
        this.field_224428_p.active(!this.field_224416_d.expired);
        this.field_224425_m.active(!this.field_224416_d.expired);
        this.field_224427_o.active(!this.field_224416_d.expired);
    }

    @Override
    public boolean mouseClicked(double d, double d2, int n) {
        return super.mouseClicked(d, d2, n);
    }

    private void func_224385_a(RealmsServer realmsServer) {
        if (this.field_224416_d.state == RealmsServer.Status.OPEN) {
            this.field_224415_c.func_223911_a(realmsServer, new RealmsConfigureWorldScreen(this.field_224415_c.func_223942_f(), this.field_224417_e));
        } else {
            this.func_224383_a(true, new RealmsConfigureWorldScreen(this.field_224415_c.func_223942_f(), this.field_224417_e));
        }
    }

    @Override
    public void func_224366_a(int n, RealmsServerSlotButton.Action action, boolean bl, boolean bl2) {
        switch (action) {
            case NOTHING: {
                break;
            }
            case JOIN: {
                this.func_224385_a(this.field_224416_d);
                break;
            }
            case SWITCH_SLOT: {
                if (bl) {
                    this.func_224401_f();
                    break;
                }
                if (bl2) {
                    this.func_224388_b(n, this.field_224416_d);
                    break;
                }
                this.func_224403_a(n, this.field_224416_d);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown action " + (Object)((Object)action));
            }
        }
    }

    private void func_224401_f() {
        RealmsSelectWorldTemplateScreen realmsSelectWorldTemplateScreen = new RealmsSelectWorldTemplateScreen(this, RealmsServer.ServerType.MINIGAME);
        realmsSelectWorldTemplateScreen.func_224483_a(RealmsConfigureWorldScreen.getLocalizedString("mco.template.title.minigame"));
        realmsSelectWorldTemplateScreen.func_224492_b(RealmsConfigureWorldScreen.getLocalizedString("mco.minigame.world.info.line1") + "\\n" + RealmsConfigureWorldScreen.getLocalizedString("mco.minigame.world.info.line2"));
        Realms.setScreen(realmsSelectWorldTemplateScreen);
    }

    private void func_224403_a(int n, RealmsServer realmsServer) {
        String string = RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.slot.switch.question.line1");
        \u2603 = RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.slot.switch.question.line2");
        Realms.setScreen(new RealmsLongConfirmationScreen((bl, n2) -> {
            if (bl) {
                this.func_224406_a(realmsServer.id, n);
            } else {
                Realms.setScreen(this);
            }
        }, RealmsLongConfirmationScreen.Type.Info, string, \u2603, true, 9));
    }

    private void func_224388_b(int n, RealmsServer realmsServer) {
        String string = RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.slot.switch.question.line1");
        \u2603 = RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.slot.switch.question.line2");
        Realms.setScreen(new RealmsLongConfirmationScreen((bl, n2) -> {
            if (bl) {
                RealmsResetWorldScreen realmsResetWorldScreen = new RealmsResetWorldScreen(this, realmsServer, this.func_224407_b(), RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.switch.slot"), RealmsConfigureWorldScreen.getLocalizedString("mco.configure.world.switch.slot.subtitle"), 0xA0A0A0, RealmsConfigureWorldScreen.getLocalizedString("gui.cancel"));
                realmsResetWorldScreen.func_224445_b(n);
                realmsResetWorldScreen.func_224432_a(RealmsConfigureWorldScreen.getLocalizedString("mco.create.world.reset.title"));
                Realms.setScreen(realmsResetWorldScreen);
            } else {
                Realms.setScreen(this);
            }
        }, RealmsLongConfirmationScreen.Type.Info, string, \u2603, true, 10));
    }

    protected void func_224394_a(String string, int n, int n2) {
        if (string == null) {
            return;
        }
        \u2603 = n + 12;
        \u2603 = n2 - 12;
        \u2603 = this.fontWidth(string);
        if (\u2603 + \u2603 + 3 > this.field_224419_g) {
            \u2603 = \u2603 - \u2603 - 20;
        }
        this.fillGradient(\u2603 - 3, \u2603 - 3, \u2603 + \u2603 + 3, \u2603 + 8 + 3, -1073741824, -1073741824);
        this.fontDrawShadow(string, \u2603, \u2603, 0xFFFFFF);
    }

    private void func_224379_a(int n, int n2, int n3, int n4) {
        if (this.field_224416_d.expired) {
            this.func_224408_b(n, n2, n3, n4);
        } else if (this.field_224416_d.state == RealmsServer.Status.CLOSED) {
            this.func_224409_d(n, n2, n3, n4);
        } else if (this.field_224416_d.state == RealmsServer.Status.OPEN) {
            if (this.field_224416_d.daysLeft < 7) {
                this.func_224381_a(n, n2, n3, n4, this.field_224416_d.daysLeft);
            } else {
                this.func_224382_c(n, n2, n3, n4);
            }
        }
    }

    private void func_224408_b(int n, int n2, int n3, int n4) {
        RealmsScreen.bind("realms:textures/gui/realms/expired_icon.png");
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        RealmsScreen.blit(n, n2, 0.0f, 0.0f, 10, 28, 10, 28);
        RenderSystem.popMatrix();
        if (n3 >= n && n3 <= n + 9 && n4 >= n2 && n4 <= n2 + 27) {
            this.field_224414_b = RealmsConfigureWorldScreen.getLocalizedString("mco.selectServer.expired");
        }
    }

    private void func_224381_a(int n, int n2, int n3, int n4, int n5) {
        RealmsScreen.bind("realms:textures/gui/realms/expires_soon_icon.png");
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        if (this.field_224430_r % 20 < 10) {
            RealmsScreen.blit(n, n2, 0.0f, 0.0f, 10, 28, 20, 28);
        } else {
            RealmsScreen.blit(n, n2, 10.0f, 0.0f, 10, 28, 20, 28);
        }
        RenderSystem.popMatrix();
        if (n3 >= n && n3 <= n + 9 && n4 >= n2 && n4 <= n2 + 27) {
            this.field_224414_b = n5 <= 0 ? RealmsConfigureWorldScreen.getLocalizedString("mco.selectServer.expires.soon") : (n5 == 1 ? RealmsConfigureWorldScreen.getLocalizedString("mco.selectServer.expires.day") : RealmsConfigureWorldScreen.getLocalizedString("mco.selectServer.expires.days", n5));
        }
    }

    private void func_224382_c(int n, int n2, int n3, int n4) {
        RealmsScreen.bind("realms:textures/gui/realms/on_icon.png");
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        RealmsScreen.blit(n, n2, 0.0f, 0.0f, 10, 28, 10, 28);
        RenderSystem.popMatrix();
        if (n3 >= n && n3 <= n + 9 && n4 >= n2 && n4 <= n2 + 27) {
            this.field_224414_b = RealmsConfigureWorldScreen.getLocalizedString("mco.selectServer.open");
        }
    }

    private void func_224409_d(int n, int n2, int n3, int n4) {
        RealmsScreen.bind("realms:textures/gui/realms/off_icon.png");
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.pushMatrix();
        RealmsScreen.blit(n, n2, 0.0f, 0.0f, 10, 28, 10, 28);
        RenderSystem.popMatrix();
        if (n3 >= n && n3 <= n + 9 && n4 >= n2 && n4 <= n2 + 27) {
            this.field_224414_b = RealmsConfigureWorldScreen.getLocalizedString("mco.selectServer.closed");
        }
    }

    private boolean func_224376_g() {
        return this.field_224416_d != null && this.field_224416_d.worldType.equals((Object)RealmsServer.ServerType.MINIGAME);
    }

    private void func_224377_h() {
        this.func_224378_a(this.field_224425_m);
        this.func_224378_a(this.field_224426_n);
        this.func_224378_a(this.field_224427_o);
    }

    private void func_224378_a(RealmsButton realmsButton) {
        realmsButton.setVisible(false);
        this.removeButton(realmsButton);
    }

    private void func_224399_i() {
        this.func_224404_b(this.field_224425_m);
        this.func_224404_b(this.field_224426_n);
        this.func_224404_b(this.field_224427_o);
    }

    private void func_224404_b(RealmsButton realmsButton) {
        realmsButton.setVisible(true);
        this.buttonsAdd(realmsButton);
    }

    private void func_224412_j() {
        this.func_224378_a(this.field_224428_p);
    }

    private void func_224375_k() {
        this.func_224404_b(this.field_224428_p);
    }

    public void func_224386_a(RealmsWorldOptions realmsWorldOptions) {
        \u2603 = this.field_224416_d.slots.get(this.field_224416_d.activeSlot);
        realmsWorldOptions.templateId = \u2603.templateId;
        realmsWorldOptions.templateImage = \u2603.templateImage;
        RealmsClient realmsClient = RealmsClient.func_224911_a();
        try {
            realmsClient.func_224925_a(this.field_224416_d.id, this.field_224416_d.activeSlot, realmsWorldOptions);
            this.field_224416_d.slots.put(this.field_224416_d.activeSlot, realmsWorldOptions);
        }
        catch (RealmsServiceException \u26032) {
            field_224413_a.error("Couldn't save slot settings");
            Realms.setScreen(new RealmsGenericErrorScreen(\u26032, (RealmsScreen)this));
            return;
        }
        catch (UnsupportedEncodingException \u26033) {
            field_224413_a.error("Couldn't save slot settings");
        }
        Realms.setScreen(this);
    }

    public void func_224410_a(String string, String string2) {
        \u2603 = string2 == null || string2.trim().isEmpty() ? null : string2;
        RealmsClient realmsClient = RealmsClient.func_224911_a();
        try {
            realmsClient.func_224922_b(this.field_224416_d.id, string, \u2603);
            this.field_224416_d.setName(string);
            this.field_224416_d.setDescription(\u2603);
        }
        catch (RealmsServiceException \u26032) {
            field_224413_a.error("Couldn't save settings");
            Realms.setScreen(new RealmsGenericErrorScreen(\u26032, (RealmsScreen)this));
            return;
        }
        catch (UnsupportedEncodingException \u26033) {
            field_224413_a.error("Couldn't save settings");
        }
        Realms.setScreen(this);
    }

    public void func_224383_a(boolean bl, RealmsScreen realmsScreen) {
        RealmsTasks.OpenServerTask openServerTask = new RealmsTasks.OpenServerTask(this.field_224416_d, this, this.field_224415_c, bl);
        RealmsLongRunningMcoTaskScreen \u26032 = new RealmsLongRunningMcoTaskScreen(realmsScreen, openServerTask);
        \u26032.func_224233_a();
        Realms.setScreen(\u26032);
    }

    public void func_224405_a(RealmsScreen realmsScreen) {
        RealmsTasks.CloseServerTask closeServerTask = new RealmsTasks.CloseServerTask(this.field_224416_d, this);
        RealmsLongRunningMcoTaskScreen \u26032 = new RealmsLongRunningMcoTaskScreen(realmsScreen, closeServerTask);
        \u26032.func_224233_a();
        Realms.setScreen(\u26032);
    }

    public void func_224398_a() {
        this.field_224429_q = true;
    }

    @Override
    void func_223627_a_(WorldTemplate worldTemplate) {
        if (worldTemplate == null) {
            return;
        }
        if (WorldTemplate.Type.MINIGAME.equals((Object)worldTemplate.type)) {
            this.func_224393_b(worldTemplate);
        }
    }

    private void func_224406_a(long l, int n2) {
        RealmsConfigureWorldScreen realmsConfigureWorldScreen = this.func_224407_b();
        RealmsTasks.SwitchSlotTask \u26032 = new RealmsTasks.SwitchSlotTask(l, n2, (bl, n) -> Realms.setScreen(realmsConfigureWorldScreen), 11);
        RealmsLongRunningMcoTaskScreen \u26033 = new RealmsLongRunningMcoTaskScreen(this.field_224415_c, \u26032);
        \u26033.func_224233_a();
        Realms.setScreen(\u26033);
    }

    private void func_224393_b(WorldTemplate worldTemplate) {
        RealmsTasks.SwitchMinigameTask switchMinigameTask = new RealmsTasks.SwitchMinigameTask(this.field_224416_d.id, worldTemplate, this.func_224407_b());
        RealmsLongRunningMcoTaskScreen \u26032 = new RealmsLongRunningMcoTaskScreen(this.field_224415_c, switchMinigameTask);
        \u26032.func_224233_a();
        Realms.setScreen(\u26032);
    }

    public RealmsConfigureWorldScreen func_224407_b() {
        return new RealmsConfigureWorldScreen(this.field_224415_c, this.field_224417_e);
    }
}

