/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.client.FileDownload;
import com.mojang.realmsclient.dto.WorldDownload;
import com.mojang.realmsclient.gui.screens.RealmsLongConfirmationScreen;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsDefaultVertexFormat;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.Tezzelator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsDownloadLatestWorldScreen
extends RealmsScreen {
    private static final Logger field_224175_a = LogManager.getLogger();
    private final RealmsScreen field_224176_b;
    private final WorldDownload field_224177_c;
    private final String field_224178_d;
    private final RateLimiter field_224179_e;
    private RealmsButton field_224180_f;
    private final String field_224181_g;
    private final DownloadStatus field_224182_h;
    private volatile String field_224183_i;
    private volatile String field_224184_j;
    private volatile String field_224185_k;
    private volatile boolean field_224186_l;
    private volatile boolean field_224187_m = true;
    private volatile boolean field_224188_n;
    private volatile boolean field_224189_o;
    private Long field_224190_p;
    private Long field_224191_q;
    private long field_224192_r;
    private int field_224193_s;
    private static final String[] field_224194_t = new String[]{"", ".", ". .", ". . ."};
    private int field_224195_u;
    private final int field_224196_v = 100;
    private int field_224197_w = -1;
    private boolean field_224198_x;
    private static final ReentrantLock field_224199_y = new ReentrantLock();

    public RealmsDownloadLatestWorldScreen(RealmsScreen realmsScreen, WorldDownload worldDownload, String string) {
        this.field_224176_b = realmsScreen;
        this.field_224181_g = string;
        this.field_224177_c = worldDownload;
        this.field_224182_h = new DownloadStatus();
        this.field_224178_d = RealmsDownloadLatestWorldScreen.getLocalizedString("mco.download.title");
        this.field_224179_e = RateLimiter.create((double)0.1f);
    }

    public void func_224167_a(int n) {
        this.field_224197_w = n;
    }

    @Override
    public void init() {
        this.setKeyboardHandlerSendRepeatsToGui(true);
        this.field_224180_f = new RealmsButton(0, this.width() / 2 - 100, this.height() - 42, 200, 20, RealmsDownloadLatestWorldScreen.getLocalizedString("gui.cancel")){

            @Override
            public void onPress() {
                RealmsDownloadLatestWorldScreen.this.field_224186_l = true;
                RealmsDownloadLatestWorldScreen.this.func_224174_d();
            }
        };
        this.buttonsAdd(this.field_224180_f);
        this.func_224162_c();
    }

    private void func_224162_c() {
        if (this.field_224188_n) {
            return;
        }
        if (!this.field_224198_x && this.func_224152_a(this.field_224177_c.downloadLink) >= 0x140000000L) {
            String string = RealmsDownloadLatestWorldScreen.getLocalizedString("mco.download.confirmation.line1", RealmsDownloadLatestWorldScreen.func_224150_b(0x140000000L));
            \u2603 = RealmsDownloadLatestWorldScreen.getLocalizedString("mco.download.confirmation.line2");
            Realms.setScreen(new RealmsLongConfirmationScreen(this, RealmsLongConfirmationScreen.Type.Warning, string, \u2603, false, 100));
        } else {
            this.func_224165_h();
        }
    }

    @Override
    public void confirmResult(boolean bl, int n) {
        this.field_224198_x = true;
        Realms.setScreen(this);
        this.func_224165_h();
    }

    private long func_224152_a(String string) {
        FileDownload fileDownload = new FileDownload();
        return fileDownload.func_224827_a(string);
    }

    @Override
    public void tick() {
        super.tick();
        ++this.field_224193_s;
        if (this.field_224184_j != null && this.field_224179_e.tryAcquire(1)) {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(this.field_224178_d);
            arrayList.add(this.field_224184_j);
            if (this.field_224185_k != null) {
                arrayList.add(this.field_224185_k + "%");
                arrayList.add(RealmsDownloadLatestWorldScreen.func_224153_a(this.field_224192_r));
            }
            if (this.field_224183_i != null) {
                arrayList.add(this.field_224183_i);
            }
            String \u26032 = String.join((CharSequence)System.lineSeparator(), arrayList);
            Realms.narrateNow(\u26032);
        }
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (n == 256) {
            this.field_224186_l = true;
            this.func_224174_d();
            return true;
        }
        return super.keyPressed(n, n2, n3);
    }

    private void func_224174_d() {
        if (this.field_224188_n && this.field_224197_w != -1 && this.field_224183_i == null) {
            this.field_224176_b.confirmResult(true, this.field_224197_w);
        }
        Realms.setScreen(this.field_224176_b);
    }

    @Override
    public void render(int n, int n2, float f) {
        this.renderBackground();
        if (this.field_224189_o && !this.field_224188_n) {
            this.field_224184_j = RealmsDownloadLatestWorldScreen.getLocalizedString("mco.download.extracting");
        }
        this.drawCenteredString(this.field_224178_d, this.width() / 2, 20, 0xFFFFFF);
        this.drawCenteredString(this.field_224184_j, this.width() / 2, 50, 0xFFFFFF);
        if (this.field_224187_m) {
            this.func_224161_e();
        }
        if (this.field_224182_h.field_225139_a != 0L && !this.field_224186_l) {
            this.func_224164_f();
            this.func_224149_g();
        }
        if (this.field_224183_i != null) {
            this.drawCenteredString(this.field_224183_i, this.width() / 2, 110, 0xFF0000);
        }
        super.render(n, n2, f);
    }

    private void func_224161_e() {
        int n = this.fontWidth(this.field_224184_j);
        if (this.field_224193_s % 10 == 0) {
            ++this.field_224195_u;
        }
        this.drawString(field_224194_t[this.field_224195_u % field_224194_t.length], this.width() / 2 + n / 2 + 5, 50, 0xFFFFFF);
    }

    private void func_224164_f() {
        double d = this.field_224182_h.field_225139_a.doubleValue() / this.field_224182_h.field_225140_b.doubleValue() * 100.0;
        this.field_224185_k = String.format(Locale.ROOT, "%.1f", d);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableTexture();
        Tezzelator \u26032 = Tezzelator.instance;
        \u26032.begin(7, RealmsDefaultVertexFormat.POSITION_COLOR);
        \u2603 = this.width() / 2 - 100;
        \u2603 = 0.5;
        \u26032.vertex(\u2603 - 0.5, 95.5, 0.0).color(217, 210, 210, 255).endVertex();
        \u26032.vertex(\u2603 + 200.0 * d / 100.0 + 0.5, 95.5, 0.0).color(217, 210, 210, 255).endVertex();
        \u26032.vertex(\u2603 + 200.0 * d / 100.0 + 0.5, 79.5, 0.0).color(217, 210, 210, 255).endVertex();
        \u26032.vertex(\u2603 - 0.5, 79.5, 0.0).color(217, 210, 210, 255).endVertex();
        \u26032.vertex(\u2603, 95.0, 0.0).color(128, 128, 128, 255).endVertex();
        \u26032.vertex(\u2603 + 200.0 * d / 100.0, 95.0, 0.0).color(128, 128, 128, 255).endVertex();
        \u26032.vertex(\u2603 + 200.0 * d / 100.0, 80.0, 0.0).color(128, 128, 128, 255).endVertex();
        \u26032.vertex(\u2603, 80.0, 0.0).color(128, 128, 128, 255).endVertex();
        \u26032.end();
        RenderSystem.enableTexture();
        this.drawCenteredString(this.field_224185_k + " %", this.width() / 2, 84, 0xFFFFFF);
    }

    private void func_224149_g() {
        if (this.field_224193_s % 20 == 0) {
            if (this.field_224190_p != null) {
                long l = System.currentTimeMillis() - this.field_224191_q;
                if (l == 0L) {
                    l = 1L;
                }
                this.field_224192_r = 1000L * (this.field_224182_h.field_225139_a - this.field_224190_p) / l;
                this.func_224156_c(this.field_224192_r);
            }
            this.field_224190_p = this.field_224182_h.field_225139_a;
            this.field_224191_q = System.currentTimeMillis();
        } else {
            this.func_224156_c(this.field_224192_r);
        }
    }

    private void func_224156_c(long l) {
        if (l > 0L) {
            int n = this.fontWidth(this.field_224185_k);
            String \u26032 = "(" + RealmsDownloadLatestWorldScreen.func_224153_a(l) + ")";
            this.drawString(\u26032, this.width() / 2 + n / 2 + 15, 84, 0xFFFFFF);
        }
    }

    public static String func_224153_a(long l) {
        int n = 1024;
        if (l < 1024L) {
            return l + " B/s";
        }
        \u2603 = (int)(Math.log(l) / Math.log(1024.0));
        String \u26032 = "KMGTPE".charAt(\u2603 - 1) + "";
        return String.format(Locale.ROOT, "%.1f %sB/s", (double)l / Math.pow(1024.0, \u2603), \u26032);
    }

    public static String func_224150_b(long l) {
        int n = 1024;
        if (l < 1024L) {
            return l + " B";
        }
        \u2603 = (int)(Math.log(l) / Math.log(1024.0));
        String \u26032 = "KMGTPE".charAt(\u2603 - 1) + "";
        return String.format(Locale.ROOT, "%.0f %sB", (double)l / Math.pow(1024.0, \u2603), \u26032);
    }

    private void func_224165_h() {
        new Thread(() -> {
            try {
                if (!field_224199_y.tryLock(1L, TimeUnit.SECONDS)) {
                    return;
                }
                this.field_224184_j = RealmsDownloadLatestWorldScreen.getLocalizedString("mco.download.preparing");
                if (this.field_224186_l) {
                    this.func_224159_i();
                    return;
                }
                this.field_224184_j = RealmsDownloadLatestWorldScreen.getLocalizedString("mco.download.downloading", this.field_224181_g);
                FileDownload fileDownload = new FileDownload();
                fileDownload.func_224827_a(this.field_224177_c.downloadLink);
                fileDownload.func_224830_a(this.field_224177_c, this.field_224181_g, this.field_224182_h, this.getLevelStorageSource());
                while (!fileDownload.func_224835_b()) {
                    if (fileDownload.func_224836_c()) {
                        fileDownload.func_224834_a();
                        this.field_224183_i = RealmsDownloadLatestWorldScreen.getLocalizedString("mco.download.failed");
                        this.field_224180_f.setMessage(RealmsDownloadLatestWorldScreen.getLocalizedString("gui.done"));
                        return;
                    }
                    if (fileDownload.func_224837_d()) {
                        this.field_224189_o = true;
                    }
                    if (this.field_224186_l) {
                        fileDownload.func_224834_a();
                        this.func_224159_i();
                        return;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        field_224175_a.error("Failed to check Realms backup download status");
                    }
                }
                this.field_224188_n = true;
                this.field_224184_j = RealmsDownloadLatestWorldScreen.getLocalizedString("mco.download.done");
                this.field_224180_f.setMessage(RealmsDownloadLatestWorldScreen.getLocalizedString("gui.done"));
            }
            catch (InterruptedException interruptedException) {
                field_224175_a.error("Could not acquire upload lock");
            }
            catch (Exception exception) {
                this.field_224183_i = RealmsDownloadLatestWorldScreen.getLocalizedString("mco.download.failed");
                exception.printStackTrace();
            }
            finally {
                if (!field_224199_y.isHeldByCurrentThread()) {
                    return;
                }
                field_224199_y.unlock();
                this.field_224187_m = false;
                this.field_224188_n = true;
            }
        }).start();
    }

    private void func_224159_i() {
        this.field_224184_j = RealmsDownloadLatestWorldScreen.getLocalizedString("mco.download.cancelled");
    }

    public class DownloadStatus {
        public volatile Long field_225139_a = 0L;
        public volatile Long field_225140_b = 0L;
    }
}

