/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.dto.WorldTemplatePaginatedList;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.RealmsConstants;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.RealmsResetNormalWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsScreenWithCallback;
import com.mojang.realmsclient.gui.screens.RealmsSelectFileToUploadScreen;
import com.mojang.realmsclient.gui.screens.RealmsSelectWorldTemplateScreen;
import com.mojang.realmsclient.util.RealmsTasks;
import com.mojang.realmsclient.util.RealmsTextureManager;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsLabel;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsResetWorldScreen
extends RealmsScreenWithCallback<WorldTemplate> {
    private static final Logger field_224456_b = LogManager.getLogger();
    private final RealmsScreen field_224457_c;
    private final RealmsServer field_224458_d;
    private final RealmsScreen field_224459_e;
    private RealmsLabel field_224460_f;
    private RealmsLabel field_224461_g;
    private String field_224462_h = RealmsResetWorldScreen.getLocalizedString("mco.reset.world.title");
    private String field_224463_i = RealmsResetWorldScreen.getLocalizedString("mco.reset.world.warning");
    private String field_224464_j = RealmsResetWorldScreen.getLocalizedString("gui.cancel");
    private int field_224465_k = 0xFF0000;
    private final int field_224466_l = 0;
    private final int field_224467_m = 100;
    private WorldTemplatePaginatedList field_224468_n;
    private WorldTemplatePaginatedList field_224469_o;
    private WorldTemplatePaginatedList field_224470_p;
    private WorldTemplatePaginatedList field_224471_q;
    public int field_224455_a = -1;
    private ResetType field_224472_r = ResetType.NONE;
    private ResetWorldInfo field_224473_s;
    private WorldTemplate field_224474_t;
    private String field_224475_u;
    private int field_224476_v = -1;

    public RealmsResetWorldScreen(RealmsScreen realmsScreen, RealmsServer realmsServer, RealmsScreen realmsScreen2) {
        this.field_224457_c = realmsScreen;
        this.field_224458_d = realmsServer;
        this.field_224459_e = realmsScreen2;
    }

    public RealmsResetWorldScreen(RealmsScreen realmsScreen, RealmsServer realmsServer, RealmsScreen realmsScreen2, String string, String string2, int n, String string3) {
        this(realmsScreen, realmsServer, realmsScreen2);
        this.field_224462_h = string;
        this.field_224463_i = string2;
        this.field_224465_k = n;
        this.field_224464_j = string3;
    }

    public void func_224444_a(int n) {
        this.field_224476_v = n;
    }

    public void func_224445_b(int n) {
        this.field_224455_a = n;
    }

    public void func_224432_a(String string) {
        this.field_224475_u = string;
    }

    @Override
    public void init() {
        this.buttonsAdd(new RealmsButton(0, this.width() / 2 - 40, RealmsConstants.func_225109_a(14) - 10, 80, 20, this.field_224464_j){

            @Override
            public void onPress() {
                Realms.setScreen(RealmsResetWorldScreen.this.field_224457_c);
            }
        });
        new Thread("Realms-reset-world-fetcher"){

            @Override
            public void run() {
                RealmsClient realmsClient = RealmsClient.func_224911_a();
                try {
                    WorldTemplatePaginatedList worldTemplatePaginatedList = realmsClient.func_224930_a(1, 10, RealmsServer.ServerType.NORMAL);
                    \u2603 = realmsClient.func_224930_a(1, 10, RealmsServer.ServerType.ADVENTUREMAP);
                    \u2603 = realmsClient.func_224930_a(1, 10, RealmsServer.ServerType.EXPERIENCE);
                    \u2603 = realmsClient.func_224930_a(1, 10, RealmsServer.ServerType.INSPIRATION);
                    Realms.execute(() -> {
                        RealmsResetWorldScreen.this.field_224468_n = worldTemplatePaginatedList;
                        RealmsResetWorldScreen.this.field_224469_o = \u2603;
                        RealmsResetWorldScreen.this.field_224470_p = \u2603;
                        RealmsResetWorldScreen.this.field_224471_q = \u2603;
                    });
                }
                catch (RealmsServiceException realmsServiceException) {
                    field_224456_b.error("Couldn't fetch templates in reset world", (Throwable)realmsServiceException);
                }
            }
        }.start();
        this.field_224460_f = new RealmsLabel(this.field_224462_h, this.width() / 2, 7, 0xFFFFFF);
        this.addWidget(this.field_224460_f);
        this.field_224461_g = new RealmsLabel(this.field_224463_i, this.width() / 2, 22, this.field_224465_k);
        this.addWidget(this.field_224461_g);
        this.buttonsAdd(new TexturedButton(this.func_224434_c(1), RealmsConstants.func_225109_a(0) + 10, RealmsResetWorldScreen.getLocalizedString("mco.reset.world.generate"), -1L, "realms:textures/gui/realms/new_world.png", ResetType.GENERATE){

            @Override
            public void onPress() {
                Realms.setScreen(new RealmsResetNormalWorldScreen(RealmsResetWorldScreen.this, RealmsResetWorldScreen.this.field_224462_h));
            }
        });
        this.buttonsAdd(new TexturedButton(this.func_224434_c(2), RealmsConstants.func_225109_a(0) + 10, RealmsResetWorldScreen.getLocalizedString("mco.reset.world.upload"), -1L, "realms:textures/gui/realms/upload.png", ResetType.UPLOAD){

            @Override
            public void onPress() {
                Realms.setScreen(new RealmsSelectFileToUploadScreen(((RealmsResetWorldScreen)RealmsResetWorldScreen.this).field_224458_d.id, RealmsResetWorldScreen.this.field_224455_a != -1 ? RealmsResetWorldScreen.this.field_224455_a : ((RealmsResetWorldScreen)RealmsResetWorldScreen.this).field_224458_d.activeSlot, RealmsResetWorldScreen.this));
            }
        });
        this.buttonsAdd(new TexturedButton(this.func_224434_c(3), RealmsConstants.func_225109_a(0) + 10, RealmsResetWorldScreen.getLocalizedString("mco.reset.world.template"), -1L, "realms:textures/gui/realms/survival_spawn.png", ResetType.SURVIVAL_SPAWN){

            @Override
            public void onPress() {
                RealmsSelectWorldTemplateScreen realmsSelectWorldTemplateScreen = new RealmsSelectWorldTemplateScreen(RealmsResetWorldScreen.this, RealmsServer.ServerType.NORMAL, RealmsResetWorldScreen.this.field_224468_n);
                realmsSelectWorldTemplateScreen.func_224483_a(RealmsScreen.getLocalizedString("mco.reset.world.template"));
                Realms.setScreen(realmsSelectWorldTemplateScreen);
            }
        });
        this.buttonsAdd(new TexturedButton(this.func_224434_c(1), RealmsConstants.func_225109_a(6) + 20, RealmsResetWorldScreen.getLocalizedString("mco.reset.world.adventure"), -1L, "realms:textures/gui/realms/adventure.png", ResetType.ADVENTURE){

            @Override
            public void onPress() {
                RealmsSelectWorldTemplateScreen realmsSelectWorldTemplateScreen = new RealmsSelectWorldTemplateScreen(RealmsResetWorldScreen.this, RealmsServer.ServerType.ADVENTUREMAP, RealmsResetWorldScreen.this.field_224469_o);
                realmsSelectWorldTemplateScreen.func_224483_a(RealmsScreen.getLocalizedString("mco.reset.world.adventure"));
                Realms.setScreen(realmsSelectWorldTemplateScreen);
            }
        });
        this.buttonsAdd(new TexturedButton(this.func_224434_c(2), RealmsConstants.func_225109_a(6) + 20, RealmsResetWorldScreen.getLocalizedString("mco.reset.world.experience"), -1L, "realms:textures/gui/realms/experience.png", ResetType.EXPERIENCE){

            @Override
            public void onPress() {
                RealmsSelectWorldTemplateScreen realmsSelectWorldTemplateScreen = new RealmsSelectWorldTemplateScreen(RealmsResetWorldScreen.this, RealmsServer.ServerType.EXPERIENCE, RealmsResetWorldScreen.this.field_224470_p);
                realmsSelectWorldTemplateScreen.func_224483_a(RealmsScreen.getLocalizedString("mco.reset.world.experience"));
                Realms.setScreen(realmsSelectWorldTemplateScreen);
            }
        });
        this.buttonsAdd(new TexturedButton(this.func_224434_c(3), RealmsConstants.func_225109_a(6) + 20, RealmsResetWorldScreen.getLocalizedString("mco.reset.world.inspiration"), -1L, "realms:textures/gui/realms/inspiration.png", ResetType.INSPIRATION){

            @Override
            public void onPress() {
                RealmsSelectWorldTemplateScreen realmsSelectWorldTemplateScreen = new RealmsSelectWorldTemplateScreen(RealmsResetWorldScreen.this, RealmsServer.ServerType.INSPIRATION, RealmsResetWorldScreen.this.field_224471_q);
                realmsSelectWorldTemplateScreen.func_224483_a(RealmsScreen.getLocalizedString("mco.reset.world.inspiration"));
                Realms.setScreen(realmsSelectWorldTemplateScreen);
            }
        });
        this.narrateLabels();
    }

    @Override
    public void removed() {
        this.setKeyboardHandlerSendRepeatsToGui(false);
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (n == 256) {
            Realms.setScreen(this.field_224457_c);
            return true;
        }
        return super.keyPressed(n, n2, n3);
    }

    @Override
    public boolean mouseClicked(double d, double d2, int n) {
        return super.mouseClicked(d, d2, n);
    }

    private int func_224434_c(int n) {
        return this.width() / 2 - 130 + (n - 1) * 100;
    }

    @Override
    public void render(int n, int n2, float f) {
        this.renderBackground();
        this.field_224460_f.render(this);
        this.field_224461_g.render(this);
        super.render(n, n2, f);
    }

    private void func_224440_a(int n, int n2, String string, long l, String string2, ResetType resetType, boolean bl, boolean bl2) {
        if (l == -1L) {
            RealmsResetWorldScreen.bind(string2);
        } else {
            RealmsTextureManager.func_225202_a(String.valueOf(l), string2);
        }
        if (bl) {
            RenderSystem.color4f(0.56f, 0.56f, 0.56f, 1.0f);
        } else {
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
        RealmsScreen.blit(n + 2, n2 + 14, 0.0f, 0.0f, 56, 56, 56, 56);
        RealmsResetWorldScreen.bind("realms:textures/gui/realms/slot_frame.png");
        if (bl) {
            RenderSystem.color4f(0.56f, 0.56f, 0.56f, 1.0f);
        } else {
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
        RealmsScreen.blit(n, n2 + 12, 0.0f, 0.0f, 60, 60, 60, 60);
        this.drawCenteredString(string, n + 30, n2, bl ? 0xA0A0A0 : 0xFFFFFF);
    }

    @Override
    void func_223627_a_(WorldTemplate worldTemplate) {
        if (worldTemplate != null) {
            if (this.field_224455_a == -1) {
                this.func_224435_b(worldTemplate);
            } else {
                switch (worldTemplate.type) {
                    case WORLD_TEMPLATE: {
                        this.field_224472_r = ResetType.SURVIVAL_SPAWN;
                        break;
                    }
                    case ADVENTUREMAP: {
                        this.field_224472_r = ResetType.ADVENTURE;
                        break;
                    }
                    case EXPERIENCE: {
                        this.field_224472_r = ResetType.EXPERIENCE;
                        break;
                    }
                    case INSPIRATION: {
                        this.field_224472_r = ResetType.INSPIRATION;
                    }
                }
                this.field_224474_t = worldTemplate;
                this.func_224454_b();
            }
        }
    }

    private void func_224454_b() {
        this.func_224446_a(this);
    }

    public void func_224446_a(RealmsScreen realmsScreen) {
        RealmsTasks.SwitchSlotTask switchSlotTask = new RealmsTasks.SwitchSlotTask(this.field_224458_d.id, this.field_224455_a, realmsScreen, 100);
        RealmsLongRunningMcoTaskScreen \u26032 = new RealmsLongRunningMcoTaskScreen(this.field_224457_c, switchSlotTask);
        \u26032.func_224233_a();
        Realms.setScreen(\u26032);
    }

    @Override
    public void confirmResult(boolean bl, int n) {
        if (n == 100 && bl) {
            switch (this.field_224472_r) {
                case ADVENTURE: 
                case SURVIVAL_SPAWN: 
                case EXPERIENCE: 
                case INSPIRATION: {
                    if (this.field_224474_t == null) break;
                    this.func_224435_b(this.field_224474_t);
                    break;
                }
                case GENERATE: {
                    if (this.field_224473_s == null) break;
                    this.func_224437_b(this.field_224473_s);
                    break;
                }
                default: {
                    return;
                }
            }
            return;
        }
        if (bl) {
            Realms.setScreen(this.field_224459_e);
            if (this.field_224476_v != -1) {
                this.field_224459_e.confirmResult(true, this.field_224476_v);
            }
        }
    }

    public void func_224435_b(WorldTemplate worldTemplate) {
        RealmsTasks.ResettingWorldTask resettingWorldTask = new RealmsTasks.ResettingWorldTask(this.field_224458_d.id, this.field_224459_e, worldTemplate);
        if (this.field_224475_u != null) {
            resettingWorldTask.func_225012_c(this.field_224475_u);
        }
        if (this.field_224476_v != -1) {
            resettingWorldTask.func_225011_a(this.field_224476_v);
        }
        RealmsLongRunningMcoTaskScreen \u26032 = new RealmsLongRunningMcoTaskScreen(this.field_224457_c, resettingWorldTask);
        \u26032.func_224233_a();
        Realms.setScreen(\u26032);
    }

    public void func_224438_a(ResetWorldInfo resetWorldInfo) {
        if (this.field_224455_a == -1) {
            this.func_224437_b(resetWorldInfo);
        } else {
            this.field_224472_r = ResetType.GENERATE;
            this.field_224473_s = resetWorldInfo;
            this.func_224454_b();
        }
    }

    private void func_224437_b(ResetWorldInfo resetWorldInfo) {
        RealmsTasks.ResettingWorldTask resettingWorldTask = new RealmsTasks.ResettingWorldTask(this.field_224458_d.id, this.field_224459_e, resetWorldInfo.field_225157_a, resetWorldInfo.field_225158_b, resetWorldInfo.field_225159_c);
        if (this.field_224475_u != null) {
            resettingWorldTask.func_225012_c(this.field_224475_u);
        }
        if (this.field_224476_v != -1) {
            resettingWorldTask.func_225011_a(this.field_224476_v);
        }
        RealmsLongRunningMcoTaskScreen \u26032 = new RealmsLongRunningMcoTaskScreen(this.field_224457_c, resettingWorldTask);
        \u26032.func_224233_a();
        Realms.setScreen(\u26032);
    }

    abstract class TexturedButton
    extends RealmsButton {
        private final long field_223822_a;
        private final String field_223824_c;
        private final ResetType field_223825_d;

        public TexturedButton(int n, int n2, String string, long l, String string2, ResetType resetType) {
            super(100 + resetType.ordinal(), n, n2, 60, 72, string);
            this.field_223822_a = l;
            this.field_223824_c = string2;
            this.field_223825_d = resetType;
        }

        @Override
        public void tick() {
            super.tick();
        }

        @Override
        public void render(int n, int n2, float f) {
            super.render(n, n2, f);
        }

        @Override
        public void renderButton(int n, int n2, float f) {
            RealmsResetWorldScreen.this.func_224440_a(this.func_214457_x(), this.func_223291_y_(), this.getProxy().getMessage(), this.field_223822_a, this.field_223824_c, this.field_223825_d, this.getProxy().isHovered(), this.getProxy().isMouseOver(n, n2));
        }
    }

    public static class ResetWorldInfo {
        String field_225157_a;
        int field_225158_b;
        boolean field_225159_c;

        public ResetWorldInfo(String string, int n, boolean bl) {
            this.field_225157_a = string;
            this.field_225158_b = n;
            this.field_225159_c = bl;
        }
    }

    static enum ResetType {
        NONE,
        GENERATE,
        UPLOAD,
        ADVENTURE,
        SURVIVAL_SPAWN,
        EXPERIENCE,
        INSPIRATION;

    }
}

