/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.google.common.collect.Lists;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.mojang.realmsclient.gui.RealmsConstants;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsResetWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsUploadScreen;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.realms.RealmListEntry;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsAnvilLevelStorageSource;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsLabel;
import net.minecraft.realms.RealmsLevelSummary;
import net.minecraft.realms.RealmsObjectSelectionList;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.Tezzelator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsSelectFileToUploadScreen
extends RealmsScreen {
    private static final Logger field_224547_a = LogManager.getLogger();
    private final RealmsResetWorldScreen field_224548_b;
    private final long field_224549_c;
    private final int field_224550_d;
    private RealmsButton field_224551_e;
    private final DateFormat field_224552_f = new SimpleDateFormat();
    private List<RealmsLevelSummary> field_224553_g = Lists.newArrayList();
    private int field_224554_h = -1;
    private WorldSelectionList field_224555_i;
    private String field_224556_j;
    private String field_224557_k;
    private final String[] field_224558_l = new String[4];
    private RealmsLabel field_224559_m;
    private RealmsLabel field_224560_n;
    private RealmsLabel field_224561_o;

    public RealmsSelectFileToUploadScreen(long l, int n, RealmsResetWorldScreen realmsResetWorldScreen) {
        this.field_224548_b = realmsResetWorldScreen;
        this.field_224549_c = l;
        this.field_224550_d = n;
    }

    private void func_224541_a() throws Exception {
        RealmsAnvilLevelStorageSource realmsAnvilLevelStorageSource = this.getLevelStorageSource();
        this.field_224553_g = realmsAnvilLevelStorageSource.getLevelList();
        Collections.sort(this.field_224553_g);
        for (RealmsLevelSummary realmsLevelSummary : this.field_224553_g) {
            this.field_224555_i.func_223881_a(realmsLevelSummary);
        }
    }

    @Override
    public void init() {
        this.setKeyboardHandlerSendRepeatsToGui(true);
        this.field_224555_i = new WorldSelectionList();
        try {
            this.func_224541_a();
        }
        catch (Exception exception) {
            field_224547_a.error("Couldn't load level list", (Throwable)exception);
            Realms.setScreen(new RealmsGenericErrorScreen("Unable to load worlds", exception.getMessage(), this.field_224548_b));
            return;
        }
        this.field_224556_j = RealmsSelectFileToUploadScreen.getLocalizedString("selectWorld.world");
        this.field_224557_k = RealmsSelectFileToUploadScreen.getLocalizedString("selectWorld.conversion");
        this.field_224558_l[Realms.survivalId()] = RealmsSelectFileToUploadScreen.getLocalizedString("gameMode.survival");
        this.field_224558_l[Realms.creativeId()] = RealmsSelectFileToUploadScreen.getLocalizedString("gameMode.creative");
        this.field_224558_l[Realms.adventureId()] = RealmsSelectFileToUploadScreen.getLocalizedString("gameMode.adventure");
        this.field_224558_l[Realms.spectatorId()] = RealmsSelectFileToUploadScreen.getLocalizedString("gameMode.spectator");
        this.addWidget(this.field_224555_i);
        this.buttonsAdd(new RealmsButton(1, this.width() / 2 + 6, this.height() - 32, 153, 20, RealmsSelectFileToUploadScreen.getLocalizedString("gui.back")){

            @Override
            public void onPress() {
                Realms.setScreen(RealmsSelectFileToUploadScreen.this.field_224548_b);
            }
        });
        this.field_224551_e = new RealmsButton(2, this.width() / 2 - 154, this.height() - 32, 153, 20, RealmsSelectFileToUploadScreen.getLocalizedString("mco.upload.button.name")){

            @Override
            public void onPress() {
                RealmsSelectFileToUploadScreen.this.func_224544_b();
            }
        };
        this.buttonsAdd(this.field_224551_e);
        this.field_224551_e.active(this.field_224554_h >= 0 && this.field_224554_h < this.field_224553_g.size());
        this.field_224559_m = new RealmsLabel(RealmsSelectFileToUploadScreen.getLocalizedString("mco.upload.select.world.title"), this.width() / 2, 13, 0xFFFFFF);
        this.addWidget(this.field_224559_m);
        this.field_224560_n = new RealmsLabel(RealmsSelectFileToUploadScreen.getLocalizedString("mco.upload.select.world.subtitle"), this.width() / 2, RealmsConstants.func_225109_a(-1), 0xA0A0A0);
        this.addWidget(this.field_224560_n);
        if (this.field_224553_g.isEmpty()) {
            this.field_224561_o = new RealmsLabel(RealmsSelectFileToUploadScreen.getLocalizedString("mco.upload.select.world.none"), this.width() / 2, this.height() / 2 - 20, 0xFFFFFF);
            this.addWidget(this.field_224561_o);
        } else {
            this.field_224561_o = null;
        }
        this.narrateLabels();
    }

    @Override
    public void removed() {
        this.setKeyboardHandlerSendRepeatsToGui(false);
    }

    private void func_224544_b() {
        if (this.field_224554_h != -1 && !this.field_224553_g.get(this.field_224554_h).isHardcore()) {
            RealmsLevelSummary realmsLevelSummary = this.field_224553_g.get(this.field_224554_h);
            Realms.setScreen(new RealmsUploadScreen(this.field_224549_c, this.field_224550_d, this.field_224548_b, realmsLevelSummary));
        }
    }

    @Override
    public void render(int n, int n2, float f) {
        this.renderBackground();
        this.field_224555_i.render(n, n2, f);
        this.field_224559_m.render(this);
        this.field_224560_n.render(this);
        if (this.field_224561_o != null) {
            this.field_224561_o.render(this);
        }
        super.render(n, n2, f);
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (n == 256) {
            Realms.setScreen(this.field_224548_b);
            return true;
        }
        return super.keyPressed(n, n2, n3);
    }

    @Override
    public void tick() {
        super.tick();
    }

    private String func_224532_a(RealmsLevelSummary realmsLevelSummary) {
        return this.field_224558_l[realmsLevelSummary.getGameMode()];
    }

    private String func_224533_b(RealmsLevelSummary realmsLevelSummary) {
        return this.field_224552_f.format(new Date(realmsLevelSummary.getLastPlayed()));
    }

    class WorldSelectionEntry
    extends RealmListEntry {
        final RealmsLevelSummary field_223759_a;

        public WorldSelectionEntry(RealmsLevelSummary realmsLevelSummary) {
            this.field_223759_a = realmsLevelSummary;
        }

        @Override
        public void render(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.func_223758_a(this.field_223759_a, n, n3, n2, n5, Tezzelator.instance, n6, n7);
        }

        @Override
        public boolean mouseClicked(double d, double d2, int n) {
            RealmsSelectFileToUploadScreen.this.field_224555_i.selectItem(RealmsSelectFileToUploadScreen.this.field_224553_g.indexOf(this.field_223759_a));
            return true;
        }

        protected void func_223758_a(RealmsLevelSummary realmsLevelSummary, int n, int n2, int n3, int n4, Tezzelator tezzelator, int n5, int n6) {
            String string = realmsLevelSummary.getLevelName();
            if (string == null || string.isEmpty()) {
                string = RealmsSelectFileToUploadScreen.this.field_224556_j + " " + (n + 1);
            }
            \u2603 = realmsLevelSummary.getLevelId();
            \u2603 = \u2603 + " (" + RealmsSelectFileToUploadScreen.this.func_224533_b(realmsLevelSummary);
            \u2603 = \u2603 + ")";
            \u2603 = "";
            if (realmsLevelSummary.isRequiresConversion()) {
                \u2603 = RealmsSelectFileToUploadScreen.this.field_224557_k + " " + \u2603;
            } else {
                \u2603 = RealmsSelectFileToUploadScreen.this.func_224532_a(realmsLevelSummary);
                if (realmsLevelSummary.isHardcore()) {
                    \u2603 = (Object)((Object)ChatFormatting.DARK_RED) + RealmsScreen.getLocalizedString("mco.upload.hardcore") + (Object)((Object)ChatFormatting.RESET);
                }
                if (realmsLevelSummary.hasCheats()) {
                    \u2603 = \u2603 + ", " + RealmsScreen.getLocalizedString("selectWorld.cheats");
                }
            }
            RealmsSelectFileToUploadScreen.this.drawString(string, n2 + 2, n3 + 1, 0xFFFFFF);
            RealmsSelectFileToUploadScreen.this.drawString(\u2603, n2 + 2, n3 + 12, 0x808080);
            RealmsSelectFileToUploadScreen.this.drawString(\u2603, n2 + 2, n3 + 12 + 10, 0x808080);
        }
    }

    class WorldSelectionList
    extends RealmsObjectSelectionList {
        public WorldSelectionList() {
            super(RealmsSelectFileToUploadScreen.this.width(), RealmsSelectFileToUploadScreen.this.height(), RealmsConstants.func_225109_a(0), RealmsSelectFileToUploadScreen.this.height() - 40, 36);
        }

        public void func_223881_a(RealmsLevelSummary realmsLevelSummary) {
            this.addEntry(new WorldSelectionEntry(realmsLevelSummary));
        }

        @Override
        public int getItemCount() {
            return RealmsSelectFileToUploadScreen.this.field_224553_g.size();
        }

        @Override
        public int getMaxPosition() {
            return RealmsSelectFileToUploadScreen.this.field_224553_g.size() * 36;
        }

        @Override
        public boolean isFocused() {
            return RealmsSelectFileToUploadScreen.this.isFocused(this);
        }

        @Override
        public void renderBackground() {
            RealmsSelectFileToUploadScreen.this.renderBackground();
        }

        @Override
        public void selectItem(int n) {
            this.setSelected(n);
            if (n != -1) {
                RealmsLevelSummary realmsLevelSummary = (RealmsLevelSummary)RealmsSelectFileToUploadScreen.this.field_224553_g.get(n);
                String \u26032 = RealmsScreen.getLocalizedString("narrator.select.list.position", n + 1, RealmsSelectFileToUploadScreen.this.field_224553_g.size());
                String \u26033 = Realms.joinNarrations(Arrays.asList(realmsLevelSummary.getLevelName(), RealmsSelectFileToUploadScreen.this.func_224533_b(realmsLevelSummary), RealmsSelectFileToUploadScreen.this.func_224532_a(realmsLevelSummary), \u26032));
                Realms.narrateNow(RealmsScreen.getLocalizedString("narrator.select", \u26033));
            }
            RealmsSelectFileToUploadScreen.this.field_224554_h = n;
            RealmsSelectFileToUploadScreen.this.field_224551_e.active(RealmsSelectFileToUploadScreen.this.field_224554_h >= 0 && RealmsSelectFileToUploadScreen.this.field_224554_h < this.getItemCount() && !((RealmsLevelSummary)RealmsSelectFileToUploadScreen.this.field_224553_g.get(RealmsSelectFileToUploadScreen.this.field_224554_h)).isHardcore());
        }
    }
}

