/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.dto.WorldTemplatePaginatedList;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.RealmsConstants;
import com.mojang.realmsclient.gui.screens.RealmsScreenWithCallback;
import com.mojang.realmsclient.util.RealmsTextureManager;
import com.mojang.realmsclient.util.RealmsUtil;
import com.mojang.realmsclient.util.TextRenderingUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.realms.RealmListEntry;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsObjectSelectionList;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsSelectWorldTemplateScreen
extends RealmsScreen {
    private static final Logger field_224515_a = LogManager.getLogger();
    private final RealmsScreenWithCallback<WorldTemplate> field_224516_b;
    private WorldTemplateSelectionList field_224517_c;
    private int field_224518_d = -1;
    private String field_224519_e;
    private RealmsButton field_224520_f;
    private RealmsButton field_224521_g;
    private RealmsButton field_224522_h;
    private String field_224523_i;
    private String field_224524_j;
    private final RealmsServer.ServerType field_224525_k;
    private int field_224526_l;
    private String field_224527_m;
    private String field_224528_n;
    private boolean field_224529_o;
    private boolean field_224530_p;
    private List<TextRenderingUtils.Line> field_224531_q;

    public RealmsSelectWorldTemplateScreen(RealmsScreenWithCallback<WorldTemplate> realmsScreenWithCallback, RealmsServer.ServerType serverType) {
        this(realmsScreenWithCallback, serverType, null);
    }

    public RealmsSelectWorldTemplateScreen(RealmsScreenWithCallback<WorldTemplate> realmsScreenWithCallback, RealmsServer.ServerType serverType, @Nullable WorldTemplatePaginatedList worldTemplatePaginatedList) {
        this.field_224516_b = realmsScreenWithCallback;
        this.field_224525_k = serverType;
        if (worldTemplatePaginatedList == null) {
            this.field_224517_c = new WorldTemplateSelectionList();
            this.func_224497_a(new WorldTemplatePaginatedList(10));
        } else {
            this.field_224517_c = new WorldTemplateSelectionList(Lists.newArrayList(worldTemplatePaginatedList.templates));
            this.func_224497_a(worldTemplatePaginatedList);
        }
        this.field_224519_e = RealmsSelectWorldTemplateScreen.getLocalizedString("mco.template.title");
    }

    public void func_224483_a(String string) {
        this.field_224519_e = string;
    }

    public void func_224492_b(String string) {
        this.field_224527_m = string;
        this.field_224529_o = true;
    }

    @Override
    public boolean mouseClicked(double d, double d2, int n) {
        if (this.field_224530_p && this.field_224528_n != null) {
            RealmsUtil.func_225190_c("https://beta.minecraft.net/realms/adventure-maps-in-1-9");
            return true;
        }
        return super.mouseClicked(d, d2, n);
    }

    @Override
    public void init() {
        this.setKeyboardHandlerSendRepeatsToGui(true);
        this.field_224517_c = new WorldTemplateSelectionList(this.field_224517_c.func_223879_b());
        this.field_224521_g = new RealmsButton(2, this.width() / 2 - 206, this.height() - 32, 100, 20, RealmsSelectWorldTemplateScreen.getLocalizedString("mco.template.button.trailer")){

            @Override
            public void onPress() {
                RealmsSelectWorldTemplateScreen.this.func_224496_i();
            }
        };
        this.buttonsAdd(this.field_224521_g);
        this.field_224520_f = new RealmsButton(1, this.width() / 2 - 100, this.height() - 32, 100, 20, RealmsSelectWorldTemplateScreen.getLocalizedString("mco.template.button.select")){

            @Override
            public void onPress() {
                RealmsSelectWorldTemplateScreen.this.func_224500_h();
            }
        };
        this.buttonsAdd(this.field_224520_f);
        this.buttonsAdd(new RealmsButton(0, this.width() / 2 + 6, this.height() - 32, 100, 20, RealmsSelectWorldTemplateScreen.getLocalizedString(this.field_224525_k == RealmsServer.ServerType.MINIGAME ? "gui.cancel" : "gui.back")){

            @Override
            public void onPress() {
                RealmsSelectWorldTemplateScreen.this.func_224484_g();
            }
        });
        this.field_224522_h = new RealmsButton(3, this.width() / 2 + 112, this.height() - 32, 100, 20, RealmsSelectWorldTemplateScreen.getLocalizedString("mco.template.button.publisher")){

            @Override
            public void onPress() {
                RealmsSelectWorldTemplateScreen.this.func_224511_j();
            }
        };
        this.buttonsAdd(this.field_224522_h);
        this.field_224520_f.active(false);
        this.field_224521_g.setVisible(false);
        this.field_224522_h.setVisible(false);
        this.addWidget(this.field_224517_c);
        this.focusOn(this.field_224517_c);
        Realms.narrateNow(Stream.of(this.field_224519_e, this.field_224527_m).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private void func_224514_b() {
        this.field_224522_h.setVisible(this.func_224510_d());
        this.field_224521_g.setVisible(this.func_224512_f());
        this.field_224520_f.active(this.func_224495_c());
    }

    private boolean func_224495_c() {
        return this.field_224518_d != -1;
    }

    private boolean func_224510_d() {
        return this.field_224518_d != -1 && !this.func_224487_e().link.isEmpty();
    }

    private WorldTemplate func_224487_e() {
        return this.field_224517_c.func_223877_a(this.field_224518_d);
    }

    private boolean func_224512_f() {
        return this.field_224518_d != -1 && !this.func_224487_e().trailer.isEmpty();
    }

    @Override
    public void tick() {
        super.tick();
        --this.field_224526_l;
        if (this.field_224526_l < 0) {
            this.field_224526_l = 0;
        }
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        switch (n) {
            case 256: {
                this.func_224484_g();
                return true;
            }
        }
        return super.keyPressed(n, n2, n3);
    }

    private void func_224484_g() {
        this.field_224516_b.func_223627_a_(null);
        Realms.setScreen(this.field_224516_b);
    }

    private void func_224500_h() {
        if (this.field_224518_d >= 0 && this.field_224518_d < this.field_224517_c.getItemCount()) {
            WorldTemplate worldTemplate = this.func_224487_e();
            this.field_224516_b.func_223627_a_(worldTemplate);
        }
    }

    private void func_224496_i() {
        if (this.field_224518_d >= 0 && this.field_224518_d < this.field_224517_c.getItemCount()) {
            WorldTemplate worldTemplate = this.func_224487_e();
            if (!"".equals(worldTemplate.trailer)) {
                RealmsUtil.func_225190_c(worldTemplate.trailer);
            }
        }
    }

    private void func_224511_j() {
        if (this.field_224518_d >= 0 && this.field_224518_d < this.field_224517_c.getItemCount()) {
            WorldTemplate worldTemplate = this.func_224487_e();
            if (!"".equals(worldTemplate.link)) {
                RealmsUtil.func_225190_c(worldTemplate.link);
            }
        }
    }

    private void func_224497_a(final WorldTemplatePaginatedList worldTemplatePaginatedList) {
        new Thread("realms-template-fetcher"){

            @Override
            public void run() {
                WorldTemplatePaginatedList \u26033 = worldTemplatePaginatedList;
                RealmsClient \u26032 = RealmsClient.func_224911_a();
                while (\u26033 != null) {
                    Either either = RealmsSelectWorldTemplateScreen.this.func_224509_a(\u26033, \u26032);
                    \u26033 = Realms.execute(() -> {
                        if (either.right().isPresent()) {
                            field_224515_a.error("Couldn't fetch templates: {}", either.right().get());
                            if (RealmsSelectWorldTemplateScreen.this.field_224517_c.func_223878_a()) {
                                RealmsSelectWorldTemplateScreen.this.field_224531_q = TextRenderingUtils.func_225224_a(RealmsScreen.getLocalizedString("mco.template.select.failure"), new TextRenderingUtils.LineSegment[0]);
                            }
                            return null;
                        }
                        assert (either.left().isPresent());
                        WorldTemplatePaginatedList worldTemplatePaginatedList2 = (WorldTemplatePaginatedList)either.left().get();
                        for (WorldTemplate worldTemplate : worldTemplatePaginatedList2.templates) {
                            RealmsSelectWorldTemplateScreen.this.field_224517_c.func_223876_a(worldTemplate);
                        }
                        if (worldTemplatePaginatedList2.templates.isEmpty()) {
                            if (RealmsSelectWorldTemplateScreen.this.field_224517_c.func_223878_a()) {
                                String string = RealmsScreen.getLocalizedString("mco.template.select.none", "%link");
                                TextRenderingUtils.LineSegment lineSegment = TextRenderingUtils.LineSegment.func_225214_a(RealmsScreen.getLocalizedString("mco.template.select.none.linkTitle"), "https://minecraft.net/realms/content-creator/");
                                RealmsSelectWorldTemplateScreen.this.field_224531_q = TextRenderingUtils.func_225224_a(string, lineSegment);
                            }
                            return null;
                        }
                        return worldTemplatePaginatedList2;
                    }).join();
                }
            }
        }.start();
    }

    private Either<WorldTemplatePaginatedList, String> func_224509_a(WorldTemplatePaginatedList worldTemplatePaginatedList, RealmsClient realmsClient) {
        try {
            return Either.left((Object)realmsClient.func_224930_a(worldTemplatePaginatedList.page + 1, worldTemplatePaginatedList.size, this.field_224525_k));
        }
        catch (RealmsServiceException realmsServiceException) {
            return Either.right((Object)realmsServiceException.getMessage());
        }
    }

    @Override
    public void render(int n, int n2, float f) {
        this.field_224523_i = null;
        this.field_224524_j = null;
        this.field_224530_p = false;
        this.renderBackground();
        this.field_224517_c.render(n, n2, f);
        if (this.field_224531_q != null) {
            this.func_224506_a(n, n2, this.field_224531_q);
        }
        this.drawCenteredString(this.field_224519_e, this.width() / 2, 13, 0xFFFFFF);
        if (this.field_224529_o) {
            int n3;
            String[] stringArray = this.field_224527_m.split("\\\\n");
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                \u2603 = this.fontWidth(stringArray[n3]);
                \u26032 = this.width() / 2 - \u2603 / 2;
                \u2603 = RealmsConstants.func_225109_a(-1 + n3);
                if (n < \u26032 || n > \u26032 + \u2603 || n2 < \u2603 || n2 > \u2603 + this.fontLineHeight()) continue;
                this.field_224530_p = true;
            }
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                String string = stringArray[n3];
                int \u26032 = 0xA0A0A0;
                if (this.field_224528_n != null) {
                    if (this.field_224530_p) {
                        \u26032 = 7107012;
                        string = "\u00a7n" + string;
                    } else {
                        \u26032 = 0x3366BB;
                    }
                }
                this.drawCenteredString(string, this.width() / 2, RealmsConstants.func_225109_a(-1 + n3), \u26032);
            }
        }
        super.render(n, n2, f);
        if (this.field_224523_i != null) {
            this.func_224488_a(this.field_224523_i, n, n2);
        }
    }

    private void func_224506_a(int n, int n2, List<TextRenderingUtils.Line> list) {
        for (int i = 0; i < list.size(); ++i) {
            TextRenderingUtils.Line line = list.get(i);
            int \u26032 = RealmsConstants.func_225109_a(4 + i);
            int \u26033 = line.field_225213_a.stream().mapToInt(lineSegment -> this.fontWidth(lineSegment.func_225215_a())).sum();
            int \u26034 = this.width() / 2 - \u26033 / 2;
            for (TextRenderingUtils.LineSegment lineSegment2 : line.field_225213_a) {
                int n3 = lineSegment2.func_225217_b() ? 0x3366BB : 0xFFFFFF;
                \u2603 = this.draw(lineSegment2.func_225215_a(), \u26034, \u26032, n3, true);
                if (lineSegment2.func_225217_b() && n > \u26034 && n < \u2603 && n2 > \u26032 - 3 && n2 < \u26032 + 8) {
                    this.field_224523_i = lineSegment2.func_225216_c();
                    this.field_224524_j = lineSegment2.func_225216_c();
                }
                \u26034 = \u2603;
            }
        }
    }

    protected void func_224488_a(String string, int n, int n2) {
        if (string == null) {
            return;
        }
        \u2603 = n + 12;
        \u2603 = n2 - 12;
        \u2603 = this.fontWidth(string);
        this.fillGradient(\u2603 - 3, \u2603 - 3, \u2603 + \u2603 + 3, \u2603 + 8 + 3, -1073741824, -1073741824);
        this.fontDrawShadow(string, \u2603, \u2603, 0xFFFFFF);
    }

    class WorldTemplateSelectionEntry
    extends RealmListEntry {
        final WorldTemplate field_223756_a;

        public WorldTemplateSelectionEntry(WorldTemplate worldTemplate) {
            this.field_223756_a = worldTemplate;
        }

        @Override
        public void render(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.func_223753_a(this.field_223756_a, n3, n2, n6, n7);
        }

        private void func_223753_a(WorldTemplate worldTemplate, int n, int n2, int n3, int n4) {
            \u2603 = n + 45 + 20;
            RealmsSelectWorldTemplateScreen.this.drawString(worldTemplate.name, \u2603, n2 + 2, 0xFFFFFF);
            RealmsSelectWorldTemplateScreen.this.drawString(worldTemplate.author, \u2603, n2 + 15, 0x808080);
            RealmsSelectWorldTemplateScreen.this.drawString(worldTemplate.version, \u2603 + 227 - RealmsSelectWorldTemplateScreen.this.fontWidth(worldTemplate.version), n2 + 1, 0x808080);
            if (!("".equals(worldTemplate.link) && "".equals(worldTemplate.trailer) && "".equals(worldTemplate.recommendedPlayers))) {
                this.func_223755_a(\u2603 - 1, n2 + 25, n3, n4, worldTemplate.link, worldTemplate.trailer, worldTemplate.recommendedPlayers);
            }
            this.func_223754_a(n, n2 + 1, n3, n4, worldTemplate);
        }

        private void func_223754_a(int n, int n2, int n3, int n4, WorldTemplate worldTemplate) {
            RealmsTextureManager.func_225202_a(worldTemplate.id, worldTemplate.image);
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            RealmsScreen.blit(n + 1, n2 + 1, 0.0f, 0.0f, 38, 38, 38, 38);
            RealmsScreen.bind("realms:textures/gui/realms/slot_frame.png");
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            RealmsScreen.blit(n, n2, 0.0f, 0.0f, 40, 40, 40, 40);
        }

        private void func_223755_a(int n, int n2, int n3, int n4, String string, String string2, String string3) {
            if (!"".equals(string3)) {
                RealmsSelectWorldTemplateScreen.this.drawString(string3, n, n2 + 4, 0x808080);
            }
            int n5 = "".equals(string3) ? 0 : RealmsSelectWorldTemplateScreen.this.fontWidth(string3) + 2;
            boolean \u26032 = false;
            boolean \u26033 = false;
            if (n3 >= n + n5 && n3 <= n + n5 + 32 && n4 >= n2 && n4 <= n2 + 15 && n4 < RealmsSelectWorldTemplateScreen.this.height() - 15 && n4 > 32) {
                if (n3 <= n + 15 + n5 && n3 > n5) {
                    if ("".equals(string)) {
                        \u26033 = true;
                    } else {
                        \u26032 = true;
                    }
                } else if (!"".equals(string)) {
                    \u26033 = true;
                }
            }
            if (!"".equals(string)) {
                RealmsScreen.bind("realms:textures/gui/realms/link_icons.png");
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.pushMatrix();
                RenderSystem.scalef(1.0f, 1.0f, 1.0f);
                RealmsScreen.blit(n + n5, n2, \u26032 ? 15.0f : 0.0f, 0.0f, 15, 15, 30, 15);
                RenderSystem.popMatrix();
            }
            if (!"".equals(string2)) {
                RealmsScreen.bind("realms:textures/gui/realms/trailer_icons.png");
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.pushMatrix();
                RenderSystem.scalef(1.0f, 1.0f, 1.0f);
                RealmsScreen.blit(n + n5 + ("".equals(string) ? 0 : 17), n2, \u26033 ? 15.0f : 0.0f, 0.0f, 15, 15, 30, 15);
                RenderSystem.popMatrix();
            }
            if (\u26032 && !"".equals(string)) {
                RealmsSelectWorldTemplateScreen.this.field_224523_i = RealmsScreen.getLocalizedString("mco.template.info.tooltip");
                RealmsSelectWorldTemplateScreen.this.field_224524_j = string;
            } else if (\u26033 && !"".equals(string2)) {
                RealmsSelectWorldTemplateScreen.this.field_224523_i = RealmsScreen.getLocalizedString("mco.template.trailer.tooltip");
                RealmsSelectWorldTemplateScreen.this.field_224524_j = string2;
            }
        }
    }

    class WorldTemplateSelectionList
    extends RealmsObjectSelectionList<WorldTemplateSelectionEntry> {
        public WorldTemplateSelectionList() {
            this(Collections.emptyList());
        }

        public WorldTemplateSelectionList(Iterable<WorldTemplate> iterable) {
            super(RealmsSelectWorldTemplateScreen.this.width(), RealmsSelectWorldTemplateScreen.this.height(), RealmsSelectWorldTemplateScreen.this.field_224529_o ? RealmsConstants.func_225109_a(1) : 32, RealmsSelectWorldTemplateScreen.this.height() - 40, 46);
            iterable.forEach(this::func_223876_a);
        }

        public void func_223876_a(WorldTemplate worldTemplate) {
            this.addEntry(new WorldTemplateSelectionEntry(worldTemplate));
        }

        @Override
        public boolean mouseClicked(double d, double d2, int n) {
            if (n == 0 && d2 >= (double)this.y0() && d2 <= (double)this.y1()) {
                \u2603 = this.width() / 2 - 150;
                if (RealmsSelectWorldTemplateScreen.this.field_224524_j != null) {
                    RealmsUtil.func_225190_c(RealmsSelectWorldTemplateScreen.this.field_224524_j);
                }
                \u2603 = (int)Math.floor(d2 - (double)this.y0()) - this.headerHeight() + this.getScroll() - 4;
                \u2603 = \u2603 / this.itemHeight();
                if (d >= (double)\u2603 && d < (double)this.getScrollbarPosition() && \u2603 >= 0 && \u2603 >= 0 && \u2603 < this.getItemCount()) {
                    this.selectItem(\u2603);
                    this.itemClicked(\u2603, \u2603, d, d2, this.width());
                    if (\u2603 >= RealmsSelectWorldTemplateScreen.this.field_224517_c.getItemCount()) {
                        return super.mouseClicked(d, d2, n);
                    }
                    RealmsSelectWorldTemplateScreen.this.field_224518_d = \u2603;
                    RealmsSelectWorldTemplateScreen.this.func_224514_b();
                    RealmsSelectWorldTemplateScreen.this.field_224526_l = RealmsSelectWorldTemplateScreen.this.field_224526_l + 7;
                    if (RealmsSelectWorldTemplateScreen.this.field_224526_l >= 10) {
                        RealmsSelectWorldTemplateScreen.this.func_224500_h();
                    }
                    return true;
                }
            }
            return super.mouseClicked(d, d2, n);
        }

        @Override
        public void selectItem(int n) {
            RealmsSelectWorldTemplateScreen.this.field_224518_d = n;
            this.setSelected(n);
            if (n != -1) {
                WorldTemplate worldTemplate = RealmsSelectWorldTemplateScreen.this.field_224517_c.func_223877_a(n);
                String \u26032 = RealmsScreen.getLocalizedString("narrator.select.list.position", n + 1, RealmsSelectWorldTemplateScreen.this.field_224517_c.getItemCount());
                String \u26033 = RealmsScreen.getLocalizedString("mco.template.select.narrate.version", worldTemplate.version);
                String \u26034 = RealmsScreen.getLocalizedString("mco.template.select.narrate.authors", worldTemplate.author);
                String \u26035 = Realms.joinNarrations(Arrays.asList(worldTemplate.name, \u26034, worldTemplate.recommendedPlayers, \u26033, \u26032));
                Realms.narrateNow(RealmsScreen.getLocalizedString("narrator.select", \u26035));
            }
            RealmsSelectWorldTemplateScreen.this.func_224514_b();
        }

        @Override
        public void itemClicked(int n, int n2, double d, double d2, int n3) {
            if (n2 >= RealmsSelectWorldTemplateScreen.this.field_224517_c.getItemCount()) {
                return;
            }
        }

        @Override
        public int getMaxPosition() {
            return this.getItemCount() * 46;
        }

        @Override
        public int getRowWidth() {
            return 300;
        }

        @Override
        public void renderBackground() {
            RealmsSelectWorldTemplateScreen.this.renderBackground();
        }

        @Override
        public boolean isFocused() {
            return RealmsSelectWorldTemplateScreen.this.isFocused(this);
        }

        public boolean func_223878_a() {
            return this.getItemCount() == 0;
        }

        public WorldTemplate func_223877_a(int n) {
            return ((WorldTemplateSelectionEntry)this.children().get((int)n)).field_223756_a;
        }

        public List<WorldTemplate> func_223879_b() {
            return this.children().stream().map(worldTemplateSelectionEntry -> worldTemplateSelectionEntry.field_223756_a).collect(Collectors.toList());
        }
    }
}

