/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.client.FileUpload;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.client.UploadStatus;
import com.mojang.realmsclient.dto.UploadInfo;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.exception.RetryCallException;
import com.mojang.realmsclient.gui.screens.RealmsResetWorldScreen;
import com.mojang.realmsclient.util.UploadTokenCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPOutputStream;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsDefaultVertexFormat;
import net.minecraft.realms.RealmsLevelSummary;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.Tezzelator;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsUploadScreen
extends RealmsScreen {
    private static final Logger field_224696_a = LogManager.getLogger();
    private final RealmsResetWorldScreen field_224697_b;
    private final RealmsLevelSummary field_224698_c;
    private final long field_224699_d;
    private final int field_224700_e;
    private final UploadStatus field_224701_f;
    private final RateLimiter field_224702_g;
    private volatile String field_224703_h;
    private volatile String field_224704_i;
    private volatile String field_224705_j;
    private volatile boolean field_224706_k;
    private volatile boolean field_224707_l;
    private volatile boolean field_224708_m = true;
    private volatile boolean field_224709_n;
    private RealmsButton field_224710_o;
    private RealmsButton field_224711_p;
    private int field_224712_q;
    private static final String[] field_224713_r = new String[]{"", ".", ". .", ". . ."};
    private int field_224714_s;
    private Long field_224715_t;
    private Long field_224716_u;
    private long field_224717_v;
    private static final ReentrantLock field_224718_w = new ReentrantLock();

    public RealmsUploadScreen(long l, int n, RealmsResetWorldScreen realmsResetWorldScreen, RealmsLevelSummary realmsLevelSummary) {
        this.field_224699_d = l;
        this.field_224700_e = n;
        this.field_224697_b = realmsResetWorldScreen;
        this.field_224698_c = realmsLevelSummary;
        this.field_224701_f = new UploadStatus();
        this.field_224702_g = RateLimiter.create((double)0.1f);
    }

    @Override
    public void init() {
        this.setKeyboardHandlerSendRepeatsToGui(true);
        this.field_224710_o = new RealmsButton(1, this.width() / 2 - 100, this.height() - 42, 200, 20, RealmsUploadScreen.getLocalizedString("gui.back")){

            @Override
            public void onPress() {
                RealmsUploadScreen.this.func_224679_c();
            }
        };
        this.field_224711_p = new RealmsButton(0, this.width() / 2 - 100, this.height() - 42, 200, 20, RealmsUploadScreen.getLocalizedString("gui.cancel")){

            @Override
            public void onPress() {
                RealmsUploadScreen.this.func_224695_d();
            }
        };
        this.buttonsAdd(this.field_224711_p);
        if (!this.field_224709_n) {
            if (this.field_224697_b.field_224455_a == -1) {
                this.func_224682_h();
            } else {
                this.field_224697_b.func_224446_a(this);
            }
        }
    }

    @Override
    public void confirmResult(boolean bl, int n) {
        if (bl && !this.field_224709_n) {
            this.field_224709_n = true;
            Realms.setScreen(this);
            this.func_224682_h();
        }
    }

    @Override
    public void removed() {
        this.setKeyboardHandlerSendRepeatsToGui(false);
    }

    private void func_224679_c() {
        this.field_224697_b.confirmResult(true, 0);
    }

    private void func_224695_d() {
        this.field_224706_k = true;
        Realms.setScreen(this.field_224697_b);
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (n == 256) {
            if (this.field_224708_m) {
                this.func_224695_d();
            } else {
                this.func_224679_c();
            }
            return true;
        }
        return super.keyPressed(n, n2, n3);
    }

    @Override
    public void render(int n3, int n2, float f) {
        int n3;
        this.renderBackground();
        if (!this.field_224707_l && this.field_224701_f.field_224978_a != 0L && this.field_224701_f.field_224978_a.longValue() == this.field_224701_f.field_224979_b.longValue()) {
            this.field_224704_i = RealmsUploadScreen.getLocalizedString("mco.upload.verifying");
            this.field_224711_p.active(false);
        }
        this.drawCenteredString(this.field_224704_i, this.width() / 2, 50, 0xFFFFFF);
        if (this.field_224708_m) {
            this.func_224678_e();
        }
        if (this.field_224701_f.field_224978_a != 0L && !this.field_224706_k) {
            this.func_224681_f();
            this.func_224664_g();
        }
        if (this.field_224703_h != null) {
            String[] stringArray = this.field_224703_h.split("\\\\n");
            for (int i = 0; i < stringArray.length; ++i) {
                this.drawCenteredString(stringArray[i], this.width() / 2, 110 + 12 * i, 0xFF0000);
            }
        }
        super.render(n3, n2, f);
    }

    private void func_224678_e() {
        int n = this.fontWidth(this.field_224704_i);
        if (this.field_224712_q % 10 == 0) {
            ++this.field_224714_s;
        }
        this.drawString(field_224713_r[this.field_224714_s % field_224713_r.length], this.width() / 2 + n / 2 + 5, 50, 0xFFFFFF);
    }

    private void func_224681_f() {
        double d = this.field_224701_f.field_224978_a.doubleValue() / this.field_224701_f.field_224979_b.doubleValue() * 100.0;
        if (d > 100.0) {
            d = 100.0;
        }
        this.field_224705_j = String.format(Locale.ROOT, "%.1f", d);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableTexture();
        \u2603 = this.width() / 2 - 100;
        \u2603 = 0.5;
        Tezzelator \u26032 = Tezzelator.instance;
        \u26032.begin(7, RealmsDefaultVertexFormat.POSITION_COLOR);
        \u26032.vertex(\u2603 - 0.5, 95.5, 0.0).color(217, 210, 210, 255).endVertex();
        \u26032.vertex(\u2603 + 200.0 * d / 100.0 + 0.5, 95.5, 0.0).color(217, 210, 210, 255).endVertex();
        \u26032.vertex(\u2603 + 200.0 * d / 100.0 + 0.5, 79.5, 0.0).color(217, 210, 210, 255).endVertex();
        \u26032.vertex(\u2603 - 0.5, 79.5, 0.0).color(217, 210, 210, 255).endVertex();
        \u26032.vertex(\u2603, 95.0, 0.0).color(128, 128, 128, 255).endVertex();
        \u26032.vertex(\u2603 + 200.0 * d / 100.0, 95.0, 0.0).color(128, 128, 128, 255).endVertex();
        \u26032.vertex(\u2603 + 200.0 * d / 100.0, 80.0, 0.0).color(128, 128, 128, 255).endVertex();
        \u26032.vertex(\u2603, 80.0, 0.0).color(128, 128, 128, 255).endVertex();
        \u26032.end();
        RenderSystem.enableTexture();
        this.drawCenteredString(this.field_224705_j + " %", this.width() / 2, 84, 0xFFFFFF);
    }

    private void func_224664_g() {
        if (this.field_224712_q % 20 == 0) {
            if (this.field_224715_t != null) {
                long l = System.currentTimeMillis() - this.field_224716_u;
                if (l == 0L) {
                    l = 1L;
                }
                this.field_224717_v = 1000L * (this.field_224701_f.field_224978_a - this.field_224715_t) / l;
                this.func_224673_c(this.field_224717_v);
            }
            this.field_224715_t = this.field_224701_f.field_224978_a;
            this.field_224716_u = System.currentTimeMillis();
        } else {
            this.func_224673_c(this.field_224717_v);
        }
    }

    private void func_224673_c(long l) {
        if (l > 0L) {
            int n = this.fontWidth(this.field_224705_j);
            String \u26032 = "(" + RealmsUploadScreen.func_224671_a(l) + ")";
            this.drawString(\u26032, this.width() / 2 + n / 2 + 15, 84, 0xFFFFFF);
        }
    }

    public static String func_224671_a(long l) {
        int n = 1024;
        if (l < 1024L) {
            return l + " B";
        }
        \u2603 = (int)(Math.log(l) / Math.log(1024.0));
        String \u26032 = "KMGTPE".charAt(\u2603 - 1) + "";
        return String.format(Locale.ROOT, "%.1f %sB/s", (double)l / Math.pow(1024.0, \u2603), \u26032);
    }

    @Override
    public void tick() {
        super.tick();
        ++this.field_224712_q;
        if (this.field_224704_i != null && this.field_224702_g.tryAcquire(1)) {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(this.field_224704_i);
            if (this.field_224705_j != null) {
                arrayList.add(this.field_224705_j + "%");
            }
            if (this.field_224703_h != null) {
                arrayList.add(this.field_224703_h);
            }
            Realms.narrateNow(String.join((CharSequence)System.lineSeparator(), arrayList));
        }
    }

    public static Unit func_224665_b(long l) {
        if (l < 1024L) {
            return Unit.B;
        }
        int n = (int)(Math.log(l) / Math.log(1024.0));
        String \u26032 = "KMGTPE".charAt(n - 1) + "";
        try {
            return Unit.valueOf(\u26032 + "B");
        }
        catch (Exception \u26033) {
            return Unit.GB;
        }
    }

    public static double func_224691_a(long l, Unit unit) {
        if (unit.equals((Object)Unit.B)) {
            return l;
        }
        return (double)l / Math.pow(1024.0, unit.ordinal());
    }

    public static String func_224667_b(long l, Unit unit) {
        return String.format("%." + (unit.equals((Object)Unit.GB) ? "1" : "0") + "f %s", RealmsUploadScreen.func_224691_a(l, unit), unit.name());
    }

    private void func_224682_h() {
        this.field_224709_n = true;
        new Thread(() -> {
            File \u26035 = null;
            RealmsClient \u26032 = RealmsClient.func_224911_a();
            long \u26033 = this.field_224699_d;
            try {
                if (!field_224718_w.tryLock(1L, TimeUnit.SECONDS)) {
                    return;
                }
                this.field_224704_i = RealmsUploadScreen.getLocalizedString("mco.upload.preparing");
                UploadInfo uploadInfo = null;
                for (int i = 0; i < 20; ++i) {
                    block35: {
                        try {
                            if (!this.field_224706_k) break block35;
                            this.func_224676_i();
                            return;
                        }
                        catch (RetryCallException retryCallException) {
                            Thread.sleep(retryCallException.field_224985_e * 1000);
                            continue;
                        }
                    }
                    uploadInfo = \u26032.func_224934_h(\u26033, UploadTokenCache.func_225235_a(\u26033));
                    break;
                }
                if (uploadInfo == null) {
                    this.field_224704_i = RealmsUploadScreen.getLocalizedString("mco.upload.close.failure");
                    return;
                }
                UploadTokenCache.func_225234_a(\u26033, uploadInfo.getToken());
                if (!uploadInfo.isWorldClosed()) {
                    this.field_224704_i = RealmsUploadScreen.getLocalizedString("mco.upload.close.failure");
                    return;
                }
                if (this.field_224706_k) {
                    this.func_224676_i();
                    return;
                }
                File \u26034 = new File(Realms.getGameDirectoryPath(), "saves");
                \u26035 = this.func_224675_b(new File(\u26034, this.field_224698_c.getLevelId()));
                if (this.field_224706_k) {
                    this.func_224676_i();
                    return;
                }
                if (!this.func_224692_a(\u26035)) {
                    long l = \u26035.length();
                    Unit \u26036 = RealmsUploadScreen.func_224665_b(l);
                    Unit \u26037 = RealmsUploadScreen.func_224665_b(0x140000000L);
                    if (RealmsUploadScreen.func_224667_b(l, \u26036).equals(RealmsUploadScreen.func_224667_b(0x140000000L, \u26037)) && \u26036 != Unit.B) {
                        Unit unit = Unit.values()[\u26036.ordinal() - 1];
                        this.field_224703_h = RealmsUploadScreen.getLocalizedString("mco.upload.size.failure.line1", this.field_224698_c.getLevelName()) + "\\n" + RealmsUploadScreen.getLocalizedString("mco.upload.size.failure.line2", RealmsUploadScreen.func_224667_b(l, unit), RealmsUploadScreen.func_224667_b(0x140000000L, unit));
                        return;
                    }
                    this.field_224703_h = RealmsUploadScreen.getLocalizedString("mco.upload.size.failure.line1", this.field_224698_c.getLevelName()) + "\\n" + RealmsUploadScreen.getLocalizedString("mco.upload.size.failure.line2", RealmsUploadScreen.func_224667_b(l, \u26036), RealmsUploadScreen.func_224667_b(0x140000000L, \u26037));
                    return;
                }
                this.field_224704_i = RealmsUploadScreen.getLocalizedString("mco.upload.uploading", this.field_224698_c.getLevelName());
                FileUpload \u26038 = new FileUpload(\u26035, this.field_224699_d, this.field_224700_e, uploadInfo, Realms.getSessionId(), Realms.getName(), Realms.getMinecraftVersionString(), this.field_224701_f);
                \u26038.func_224874_a(uploadResult -> {
                    if (uploadResult.field_225179_a >= 200 && uploadResult.field_225179_a < 300) {
                        this.field_224707_l = true;
                        this.field_224704_i = RealmsUploadScreen.getLocalizedString("mco.upload.done");
                        this.field_224710_o.setMessage(RealmsUploadScreen.getLocalizedString("gui.done"));
                        UploadTokenCache.func_225233_b(\u26033);
                    } else {
                        this.field_224703_h = uploadResult.field_225179_a == 400 && uploadResult.field_225180_b != null ? RealmsUploadScreen.getLocalizedString("mco.upload.failed", uploadResult.field_225180_b) : RealmsUploadScreen.getLocalizedString("mco.upload.failed", uploadResult.field_225179_a);
                    }
                });
                while (!\u26038.func_224881_b()) {
                    if (this.field_224706_k) {
                        \u26038.func_224878_a();
                        this.func_224676_i();
                        return;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        field_224696_a.error("Failed to check Realms file upload status");
                    }
                }
            }
            catch (IOException iOException) {
                this.field_224703_h = RealmsUploadScreen.getLocalizedString("mco.upload.failed", iOException.getMessage());
            }
            catch (RealmsServiceException realmsServiceException) {
                this.field_224703_h = RealmsUploadScreen.getLocalizedString("mco.upload.failed", realmsServiceException.toString());
            }
            catch (InterruptedException interruptedException) {
                field_224696_a.error("Could not acquire upload lock");
            }
            finally {
                this.field_224707_l = true;
                if (!field_224718_w.isHeldByCurrentThread()) {
                    return;
                }
                field_224718_w.unlock();
                this.field_224708_m = false;
                this.childrenClear();
                this.buttonsAdd(this.field_224710_o);
                if (\u26035 != null) {
                    field_224696_a.debug("Deleting file " + \u26035.getAbsolutePath());
                    \u26035.delete();
                }
            }
        }).start();
    }

    private void func_224676_i() {
        this.field_224704_i = RealmsUploadScreen.getLocalizedString("mco.upload.cancelled");
        field_224696_a.debug("Upload was cancelled");
    }

    private boolean func_224692_a(File file) {
        return file.length() < 0x140000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File func_224675_b(File file) throws IOException {
        try (TarArchiveOutputStream \u26032 = null;){
            File file2 = File.createTempFile("realms-upload-file", ".tar.gz");
            \u26032 = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(file2)));
            \u26032.setLongFileMode(3);
            this.func_224669_a(\u26032, file.getAbsolutePath(), "world", true);
            \u26032.finish();
            File file3 = file2;
            return file3;
        }
    }

    private void func_224669_a(TarArchiveOutputStream tarArchiveOutputStream, String string, String string2, boolean bl) throws IOException {
        if (this.field_224706_k) {
            return;
        }
        File file = new File(string);
        String \u26032 = bl ? string2 : string2 + file.getName();
        TarArchiveEntry \u26033 = new TarArchiveEntry(file, \u26032);
        tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)\u26033);
        if (file.isFile()) {
            IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)tarArchiveOutputStream);
            tarArchiveOutputStream.closeArchiveEntry();
        } else {
            tarArchiveOutputStream.closeArchiveEntry();
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    this.func_224669_a(tarArchiveOutputStream, file2.getAbsolutePath(), \u26032 + "/", false);
                }
            }
        }
    }

    static enum Unit {
        B,
        KB,
        MB,
        GB;

    }
}

