/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class MinMaxBounds<T extends Number> {
    public static final SimpleCommandExceptionType field_196978_b = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.range.empty", new Object[0]));
    public static final SimpleCommandExceptionType field_196980_d = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.range.swapped", new Object[0]));
    protected final T field_192517_b;
    protected final T field_192518_c;

    protected MinMaxBounds(@Nullable T t, @Nullable T t2) {
        this.field_192517_b = t;
        this.field_192518_c = t2;
    }

    @Nullable
    public T func_196973_a() {
        return this.field_192517_b;
    }

    @Nullable
    public T func_196977_b() {
        return this.field_192518_c;
    }

    public boolean func_211335_c() {
        return this.field_192517_b == null && this.field_192518_c == null;
    }

    public JsonElement func_200321_c() {
        if (this.func_211335_c()) {
            return JsonNull.INSTANCE;
        }
        if (this.field_192517_b != null && this.field_192517_b.equals(this.field_192518_c)) {
            return new JsonPrimitive(this.field_192517_b);
        }
        JsonObject jsonObject = new JsonObject();
        if (this.field_192517_b != null) {
            jsonObject.addProperty("min", this.field_192517_b);
        }
        if (this.field_192518_c != null) {
            jsonObject.addProperty("max", this.field_192518_c);
        }
        return jsonObject;
    }

    protected static <T extends Number, R extends MinMaxBounds<T>> R func_211331_a(@Nullable JsonElement jsonElement2, R r, BiFunction<JsonElement, String, T> biFunction, IBoundFactory<T, R> iBoundFactory) {
        JsonElement jsonElement2;
        if (jsonElement2 == null || jsonElement2.isJsonNull()) {
            return r;
        }
        if (JSONUtils.func_188175_b(jsonElement2)) {
            Number number = (Number)biFunction.apply(jsonElement2, "value");
            return iBoundFactory.create(number, number);
        }
        JsonObject \u26032 = JSONUtils.func_151210_l(jsonElement2, "value");
        Number \u26033 = \u26032.has("min") ? (Number)((Number)biFunction.apply(\u26032.get("min"), "min")) : (Number)null;
        Number \u26034 = \u26032.has("max") ? (Number)((Number)biFunction.apply(\u26032.get("max"), "max")) : (Number)null;
        return iBoundFactory.create(\u26033, \u26034);
    }

    protected static <T extends Number, R extends MinMaxBounds<T>> R func_211337_a(StringReader stringReader, IBoundReader<T, R> iBoundReader, Function<String, T> function, Supplier<DynamicCommandExceptionType> supplier, Function<T, T> function2) throws CommandSyntaxException {
        if (!stringReader.canRead()) {
            throw field_196978_b.createWithContext((ImmutableStringReader)stringReader);
        }
        int n = stringReader.getCursor();
        try {
            Number number = (Number)MinMaxBounds.func_196972_a(MinMaxBounds.func_196975_b(stringReader, function, supplier), function2);
            if (stringReader.canRead(2) && stringReader.peek() == '.' && stringReader.peek(1) == '.') {
                stringReader.skip();
                stringReader.skip();
                \u2603 = (Number)MinMaxBounds.func_196972_a(MinMaxBounds.func_196975_b(stringReader, function, supplier), function2);
                if (number == null && \u2603 == null) {
                    throw field_196978_b.createWithContext((ImmutableStringReader)stringReader);
                }
            } else {
                \u2603 = number;
            }
            if (number == null && \u2603 == null) {
                throw field_196978_b.createWithContext((ImmutableStringReader)stringReader);
            }
            return iBoundReader.create(stringReader, number, \u2603);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            stringReader.setCursor(n);
            throw new CommandSyntaxException(commandSyntaxException.getType(), commandSyntaxException.getRawMessage(), commandSyntaxException.getInput(), n);
        }
    }

    @Nullable
    private static <T extends Number> T func_196975_b(StringReader stringReader, Function<String, T> function, Supplier<DynamicCommandExceptionType> supplier) throws CommandSyntaxException {
        int n = stringReader.getCursor();
        while (stringReader.canRead() && MinMaxBounds.func_196970_c(stringReader)) {
            stringReader.skip();
        }
        String \u26032 = stringReader.getString().substring(n, stringReader.getCursor());
        if (\u26032.isEmpty()) {
            return null;
        }
        try {
            return (T)((Number)function.apply(\u26032));
        }
        catch (NumberFormatException \u26033) {
            throw supplier.get().createWithContext((ImmutableStringReader)stringReader, (Object)\u26032);
        }
    }

    private static boolean func_196970_c(StringReader stringReader) {
        char c = stringReader.peek();
        if (c >= '0' && c <= '9' || c == '-') {
            return true;
        }
        if (c == '.') {
            return !stringReader.canRead(2) || stringReader.peek(1) != '.';
        }
        return false;
    }

    @Nullable
    private static <T> T func_196972_a(@Nullable T t, Function<T, T> function) {
        return t == null ? null : (T)function.apply(t);
    }

    @FunctionalInterface
    public static interface IBoundReader<T extends Number, R extends MinMaxBounds<T>> {
        public R create(StringReader var1, @Nullable T var2, @Nullable T var3) throws CommandSyntaxException;
    }

    @FunctionalInterface
    public static interface IBoundFactory<T extends Number, R extends MinMaxBounds<T>> {
        public R create(@Nullable T var1, @Nullable T var2);
    }

    public static class FloatBound
    extends MinMaxBounds<Float> {
        public static final FloatBound field_211359_e = new FloatBound(null, null);
        private final Double field_211360_f;
        private final Double field_211361_g;

        private static FloatBound func_211352_a(StringReader stringReader, @Nullable Float f, @Nullable Float f2) throws CommandSyntaxException {
            if (f != null && f2 != null && f.floatValue() > f2.floatValue()) {
                throw field_196980_d.createWithContext((ImmutableStringReader)stringReader);
            }
            return new FloatBound(f, f2);
        }

        @Nullable
        private static Double func_211350_a(@Nullable Float f) {
            return f == null ? null : Double.valueOf(f.doubleValue() * f.doubleValue());
        }

        private FloatBound(@Nullable Float f, @Nullable Float f2) {
            super(f, f2);
            this.field_211360_f = FloatBound.func_211350_a(f);
            this.field_211361_g = FloatBound.func_211350_a(f2);
        }

        public static FloatBound func_211355_b(float f) {
            return new FloatBound(Float.valueOf(f), null);
        }

        public boolean func_211354_d(float f) {
            if (this.field_192517_b != null && ((Float)this.field_192517_b).floatValue() > f) {
                return false;
            }
            return this.field_192518_c == null || !(((Float)this.field_192518_c).floatValue() < f);
        }

        public boolean func_211351_a(double d) {
            if (this.field_211360_f != null && this.field_211360_f > d) {
                return false;
            }
            return this.field_211361_g == null || !(this.field_211361_g < d);
        }

        public static FloatBound func_211356_a(@Nullable JsonElement jsonElement) {
            return FloatBound.func_211331_a(jsonElement, field_211359_e, JSONUtils::func_151220_d, FloatBound::new);
        }

        public static FloatBound func_211357_a(StringReader stringReader) throws CommandSyntaxException {
            return FloatBound.func_211353_a(stringReader, f -> f);
        }

        public static FloatBound func_211353_a(StringReader stringReader, Function<Float, Float> function) throws CommandSyntaxException {
            return FloatBound.func_211337_a(stringReader, FloatBound::func_211352_a, Float::parseFloat, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidFloat(), function);
        }
    }

    public static class IntBound
    extends MinMaxBounds<Integer> {
        public static final IntBound field_211347_e = new IntBound(null, null);
        private final Long field_211348_f;
        private final Long field_211349_g;

        private static IntBound func_211338_a(StringReader stringReader, @Nullable Integer n, @Nullable Integer n2) throws CommandSyntaxException {
            if (n != null && n2 != null && n > n2) {
                throw field_196980_d.createWithContext((ImmutableStringReader)stringReader);
            }
            return new IntBound(n, n2);
        }

        @Nullable
        private static Long func_211343_a(@Nullable Integer n) {
            return n == null ? null : Long.valueOf(n.longValue() * n.longValue());
        }

        private IntBound(@Nullable Integer n, @Nullable Integer n2) {
            super(n, n2);
            this.field_211348_f = IntBound.func_211343_a(n);
            this.field_211349_g = IntBound.func_211343_a(n2);
        }

        public static IntBound func_211345_a(int n) {
            return new IntBound(n, n);
        }

        public static IntBound func_211340_b(int n) {
            return new IntBound(n, null);
        }

        public boolean func_211339_d(int n) {
            if (this.field_192517_b != null && (Integer)this.field_192517_b > n) {
                return false;
            }
            return this.field_192518_c == null || (Integer)this.field_192518_c >= n;
        }

        public static IntBound func_211344_a(@Nullable JsonElement jsonElement) {
            return IntBound.func_211331_a(jsonElement, field_211347_e, JSONUtils::func_151215_f, IntBound::new);
        }

        public static IntBound func_211342_a(StringReader stringReader) throws CommandSyntaxException {
            return IntBound.func_211341_a(stringReader, n -> n);
        }

        public static IntBound func_211341_a(StringReader stringReader, Function<Integer, Integer> function) throws CommandSyntaxException {
            return IntBound.func_211337_a(stringReader, IntBound::func_211338_a, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt(), function);
        }
    }
}

