/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IStateHolder;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;

public class BlockState
extends StateHolder<Block, BlockState>
implements IStateHolder<BlockState> {
    @Nullable
    private Cache field_215707_c;
    private final int field_215708_d;
    private final boolean field_215709_e;

    public BlockState(Block block, ImmutableMap<IProperty<?>, Comparable<?>> immutableMap) {
        super(block, immutableMap);
        this.field_215708_d = block.func_149750_m(this);
        this.field_215709_e = block.func_220074_n(this);
    }

    public void func_215692_c() {
        if (!this.func_177230_c().func_208619_r()) {
            this.field_215707_c = new Cache(this);
        }
    }

    public Block func_177230_c() {
        return (Block)this.field_206876_a;
    }

    public Material func_185904_a() {
        return this.func_177230_c().func_149688_o(this);
    }

    public boolean func_215688_a(IBlockReader iBlockReader, BlockPos blockPos, EntityType<?> entityType) {
        return this.func_177230_c().func_220067_a(this, iBlockReader, blockPos, entityType);
    }

    public boolean func_200131_a(IBlockReader iBlockReader, BlockPos blockPos) {
        if (this.field_215707_c != null) {
            return this.field_215707_c.field_222500_d;
        }
        return this.func_177230_c().func_200123_i(this, iBlockReader, blockPos);
    }

    public int func_200016_a(IBlockReader iBlockReader, BlockPos blockPos) {
        if (this.field_215707_c != null) {
            return this.field_215707_c.field_222501_e;
        }
        return this.func_177230_c().func_200011_d(this, iBlockReader, blockPos);
    }

    public VoxelShape func_215702_a(IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        if (this.field_215707_c != null && this.field_215707_c.field_222502_f != null) {
            return this.field_215707_c.field_222502_f[direction.ordinal()];
        }
        return VoxelShapes.func_216387_a(this.func_196951_e(iBlockReader, blockPos), direction);
    }

    public boolean func_215704_f() {
        return this.field_215707_c == null || this.field_215707_c.field_222503_g;
    }

    public boolean func_215691_g() {
        return this.field_215709_e;
    }

    public int func_185906_d() {
        return this.field_215708_d;
    }

    public boolean func_196958_f() {
        return this.func_177230_c().func_196261_e(this);
    }

    public MaterialColor func_185909_g(IBlockReader iBlockReader, BlockPos blockPos) {
        return this.func_177230_c().func_180659_g(this, iBlockReader, blockPos);
    }

    public BlockState func_185907_a(Rotation rotation) {
        return this.func_177230_c().func_185499_a(this, rotation);
    }

    public BlockState func_185902_a(Mirror mirror) {
        return this.func_177230_c().func_185471_a(this, mirror);
    }

    public BlockRenderType func_185901_i() {
        return this.func_177230_c().func_149645_b(this);
    }

    public boolean func_227035_k_() {
        return this.func_177230_c().func_225543_m_(this);
    }

    public float func_215703_d(IBlockReader iBlockReader, BlockPos blockPos) {
        return this.func_177230_c().func_220080_a(this, iBlockReader, blockPos);
    }

    public boolean func_215686_e(IBlockReader iBlockReader, BlockPos blockPos) {
        return this.func_177230_c().func_220081_d(this, iBlockReader, blockPos);
    }

    public boolean func_185897_m() {
        return this.func_177230_c().func_149744_f(this);
    }

    public int func_185911_a(IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        return this.func_177230_c().func_180656_a(this, iBlockReader, blockPos, direction);
    }

    public boolean func_185912_n() {
        return this.func_177230_c().func_149740_M(this);
    }

    public int func_185888_a(World world, BlockPos blockPos) {
        return this.func_177230_c().func_180641_l(this, world, blockPos);
    }

    public float func_185887_b(IBlockReader iBlockReader, BlockPos blockPos) {
        return this.func_177230_c().func_176195_g(this, iBlockReader, blockPos);
    }

    public float func_185903_a(PlayerEntity playerEntity, IBlockReader iBlockReader, BlockPos blockPos) {
        return this.func_177230_c().func_180647_a(this, playerEntity, iBlockReader, blockPos);
    }

    public int func_185893_b(IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        return this.func_177230_c().func_176211_b(this, iBlockReader, blockPos, direction);
    }

    public PushReaction func_185905_o() {
        return this.func_177230_c().func_149656_h(this);
    }

    public boolean func_200015_d(IBlockReader iBlockReader, BlockPos blockPos) {
        if (this.field_215707_c != null) {
            return this.field_215707_c.field_222499_c;
        }
        return this.func_177230_c().func_200012_i(this, iBlockReader, blockPos);
    }

    public boolean func_200132_m() {
        if (this.field_215707_c != null) {
            return this.field_215707_c.field_222498_b;
        }
        return this.func_177230_c().func_200124_e(this);
    }

    public boolean func_200017_a(BlockState blockState, Direction direction) {
        return this.func_177230_c().func_200122_a(this, blockState, direction);
    }

    public VoxelShape func_196954_c(IBlockReader iBlockReader, BlockPos blockPos) {
        return this.func_215700_a(iBlockReader, blockPos, ISelectionContext.func_216377_a());
    }

    public VoxelShape func_215700_a(IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return this.func_177230_c().func_220053_a(this, iBlockReader, blockPos, iSelectionContext);
    }

    public VoxelShape func_196952_d(IBlockReader iBlockReader, BlockPos blockPos) {
        if (this.field_215707_c != null) {
            return this.field_215707_c.field_230026_g;
        }
        return this.func_215685_b(iBlockReader, blockPos, ISelectionContext.func_216377_a());
    }

    public VoxelShape func_215685_b(IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return this.func_177230_c().func_220071_b(this, iBlockReader, blockPos, iSelectionContext);
    }

    public VoxelShape func_196951_e(IBlockReader iBlockReader, BlockPos blockPos) {
        return this.func_177230_c().func_196247_c(this, iBlockReader, blockPos);
    }

    public VoxelShape func_199611_f(IBlockReader iBlockReader, BlockPos blockPos) {
        return this.func_177230_c().func_199600_g(this, iBlockReader, blockPos);
    }

    public final boolean func_215682_a(IBlockReader iBlockReader, BlockPos blockPos, Entity entity) {
        return Block.func_208061_a(this.func_215685_b(iBlockReader, blockPos, ISelectionContext.func_216374_a(entity)), Direction.UP);
    }

    public Vec3d func_191059_e(IBlockReader iBlockReader, BlockPos blockPos) {
        return this.func_177230_c().func_190949_e(this, iBlockReader, blockPos);
    }

    public boolean func_189547_a(World world, BlockPos blockPos, int n, int n2) {
        return this.func_177230_c().func_189539_a(this, world, blockPos, n, n2);
    }

    public void func_215697_a(World world, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        this.func_177230_c().func_220069_a(this, world, blockPos, block, blockPos2, bl);
    }

    public void func_196946_a(IWorld iWorld, BlockPos blockPos, int n) {
        this.func_177230_c().func_196242_c(this, iWorld, blockPos, n);
    }

    public void func_196948_b(IWorld iWorld, BlockPos blockPos, int n) {
        this.func_177230_c().func_196248_b(this, iWorld, blockPos, n);
    }

    public void func_215705_a(World world, BlockPos blockPos, BlockState blockState, boolean bl) {
        this.func_177230_c().func_220082_b(this, world, blockPos, blockState, bl);
    }

    public void func_196947_b(World world, BlockPos blockPos, BlockState blockState, boolean bl) {
        this.func_177230_c().func_196243_a(this, world, blockPos, blockState, bl);
    }

    public void func_227033_a_(ServerWorld serverWorld, BlockPos blockPos, Random random) {
        this.func_177230_c().func_225534_a_(this, serverWorld, blockPos, random);
    }

    public void func_227034_b_(ServerWorld serverWorld, BlockPos blockPos, Random random) {
        this.func_177230_c().func_225542_b_(this, serverWorld, blockPos, random);
    }

    public void func_196950_a(World world, BlockPos blockPos, Entity entity) {
        this.func_177230_c().func_196262_a(this, world, blockPos, entity);
    }

    public void func_215706_a(World world, BlockPos blockPos, ItemStack itemStack) {
        this.func_177230_c().func_220062_a(this, world, blockPos, itemStack);
    }

    public List<ItemStack> func_215693_a(LootContext.Builder builder) {
        return this.func_177230_c().func_220076_a(this, builder);
    }

    public ActionResultType func_227031_a_(World world, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        return this.func_177230_c().func_225533_a_(this, world, blockRayTraceResult.func_216350_a(), playerEntity, hand, blockRayTraceResult);
    }

    public void func_196942_a(World world, BlockPos blockPos, PlayerEntity playerEntity) {
        this.func_177230_c().func_196270_a(this, world, blockPos, playerEntity);
    }

    public boolean func_229980_m_(IBlockReader iBlockReader, BlockPos blockPos) {
        return this.func_177230_c().func_229869_c_(this, iBlockReader, blockPos);
    }

    public boolean func_215696_m(IBlockReader iBlockReader, BlockPos blockPos) {
        return this.func_177230_c().func_229870_f_(this, iBlockReader, blockPos);
    }

    public BlockState func_196956_a(Direction direction, BlockState blockState, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        return this.func_177230_c().func_196271_a(this, direction, blockState, iWorld, blockPos, blockPos2);
    }

    public boolean func_196957_g(IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return this.func_177230_c().func_196266_a(this, iBlockReader, blockPos, pathType);
    }

    public boolean func_196953_a(BlockItemUseContext blockItemUseContext) {
        return this.func_177230_c().func_196253_a(this, blockItemUseContext);
    }

    public boolean func_227032_a_(Fluid fluid) {
        return this.func_177230_c().func_225541_a_(this, fluid);
    }

    public boolean func_196955_c(IWorldReader iWorldReader, BlockPos blockPos) {
        return this.func_177230_c().func_196260_a(this, iWorldReader, blockPos);
    }

    public boolean func_202065_c(IBlockReader iBlockReader, BlockPos blockPos) {
        return this.func_177230_c().func_201783_b(this, iBlockReader, blockPos);
    }

    @Nullable
    public INamedContainerProvider func_215699_b(World world, BlockPos blockPos) {
        return this.func_177230_c().func_220052_b(this, world, blockPos);
    }

    public boolean func_203425_a(Tag<Block> tag) {
        return this.func_177230_c().func_203417_a(tag);
    }

    public IFluidState func_204520_s() {
        return this.func_177230_c().func_204507_t(this);
    }

    public boolean func_204519_t() {
        return this.func_177230_c().func_149653_t(this);
    }

    public long func_209533_a(BlockPos blockPos) {
        return this.func_177230_c().func_209900_a(this, blockPos);
    }

    public SoundType func_215695_r() {
        return this.func_177230_c().func_220072_p(this);
    }

    public void func_215690_a(World world, BlockState blockState, BlockRayTraceResult blockRayTraceResult, Entity entity) {
        this.func_177230_c().func_220066_a(world, blockState, blockRayTraceResult, entity);
    }

    public boolean func_224755_d(IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        if (this.field_215707_c != null) {
            return this.field_215707_c.field_225493_i[direction.ordinal()];
        }
        return Block.func_220056_d(this, iBlockReader, blockPos, direction);
    }

    public boolean func_224756_o(IBlockReader iBlockReader, BlockPos blockPos) {
        if (this.field_215707_c != null) {
            return this.field_215707_c.field_225494_j;
        }
        return Block.func_208062_a(this.func_196952_d(iBlockReader, blockPos));
    }

    public static <T> Dynamic<T> func_215689_a(DynamicOps<T> dynamicOps, BlockState blockState) {
        ImmutableMap<IProperty<?>, Comparable<?>> immutableMap = blockState.func_206871_b();
        Object \u26032 = immutableMap.isEmpty() ? dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("Name"), (Object)dynamicOps.createString(Registry.field_212618_g.func_177774_c(blockState.func_177230_c()).toString()))) : dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("Name"), (Object)dynamicOps.createString(Registry.field_212618_g.func_177774_c(blockState.func_177230_c()).toString()), (Object)dynamicOps.createString("Properties"), (Object)dynamicOps.createMap(immutableMap.entrySet().stream().map(entry -> Pair.of((Object)dynamicOps.createString(((IProperty)entry.getKey()).func_177701_a()), (Object)dynamicOps.createString(IStateHolder.func_215670_b((IProperty)entry.getKey(), (Comparable)entry.getValue())))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)))));
        return new Dynamic(dynamicOps, \u26032);
    }

    public static <T> BlockState func_215698_a(Dynamic<T> dynamic2) {
        Block block = Registry.field_212618_g.func_82594_a(new ResourceLocation(dynamic2.getElement("Name").flatMap(arg_0 -> ((DynamicOps)dynamic2.getOps()).getStringValue(arg_0)).orElse("minecraft:air")));
        Map \u26032 = dynamic2.get("Properties").asMap(dynamic -> dynamic.asString(""), dynamic -> dynamic.asString(""));
        BlockState \u26033 = block.func_176223_P();
        StateContainer<Block, BlockState> \u26034 = block.func_176194_O();
        for (Map.Entry entry : \u26032.entrySet()) {
            String string = (String)entry.getKey();
            IProperty<?> \u26035 = \u26034.func_185920_a(string);
            if (\u26035 == null) continue;
            \u26033 = IStateHolder.func_215671_a(\u26033, \u26035, string, dynamic2.toString(), (String)entry.getValue());
        }
        return \u26033;
    }

    static final class Cache {
        private static final Direction[] field_222497_a = Direction.values();
        private final boolean field_222498_b;
        private final boolean field_222499_c;
        private final boolean field_222500_d;
        private final int field_222501_e;
        private final VoxelShape[] field_222502_f;
        private final VoxelShape field_230026_g;
        private final boolean field_222503_g;
        private final boolean[] field_225493_i;
        private final boolean field_225494_j;

        private Cache(BlockState blockState2) {
            BlockState blockState2;
            Block block = blockState2.func_177230_c();
            this.field_222498_b = block.func_200124_e(blockState2);
            this.field_222499_c = block.func_200012_i(blockState2, EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
            this.field_222500_d = block.func_200123_i(blockState2, EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
            this.field_222501_e = block.func_200011_d(blockState2, EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
            if (!blockState2.func_200132_m()) {
                this.field_222502_f = null;
            } else {
                this.field_222502_f = new VoxelShape[field_222497_a.length];
                VoxelShape voxelShape = block.func_196247_c(blockState2, EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
                Direction[] directionArray = field_222497_a;
                int n = directionArray.length;
                for (int i = 0; i < n; ++i) {
                    Direction direction = directionArray[i];
                    this.field_222502_f[direction.ordinal()] = VoxelShapes.func_216387_a(voxelShape, direction);
                }
            }
            this.field_230026_g = block.func_220071_b(blockState2, EmptyBlockReader.INSTANCE, BlockPos.field_177992_a, ISelectionContext.func_216377_a());
            this.field_222503_g = Arrays.stream(Direction.Axis.values()).anyMatch(axis -> this.field_230026_g.func_197762_b((Direction.Axis)axis) < 0.0 || this.field_230026_g.func_197758_c((Direction.Axis)axis) > 1.0);
            this.field_225493_i = new boolean[6];
            for (Direction direction : field_222497_a) {
                this.field_225493_i[direction.ordinal()] = Block.func_220056_d(blockState2, EmptyBlockReader.INSTANCE, BlockPos.field_177992_a, direction);
            }
            this.field_225494_j = Block.func_208062_a(blockState2.func_196952_d(EmptyBlockReader.INSTANCE, BlockPos.field_177992_a));
        }
    }
}

