/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class HoneyBlock
extends BreakableBlock {
    protected static final VoxelShape field_226930_a_ = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 15.0, 15.0);

    public HoneyBlock(Block.Properties properties) {
        super(properties);
    }

    private static boolean func_226937_c_(Entity entity) {
        return entity instanceof LivingEntity || entity instanceof AbstractMinecartEntity || entity instanceof TNTEntity || entity instanceof BoatEntity;
    }

    @Override
    public VoxelShape func_220071_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return field_226930_a_;
    }

    @Override
    public void func_180658_a(World world, BlockPos blockPos, Entity entity, float f) {
        entity.func_184185_a(SoundEvents.field_226139_eT_, 1.0f, 1.0f);
        if (!world.field_72995_K) {
            world.func_72960_a(entity, (byte)54);
        }
        if (entity.func_225503_b_(f, 0.2f)) {
            entity.func_184185_a(this.field_149762_H.func_185842_g(), this.field_149762_H.func_185843_a() * 0.5f, this.field_149762_H.func_185847_b() * 0.75f);
        }
    }

    @Override
    public void func_196262_a(BlockState blockState, World world, BlockPos blockPos, Entity entity) {
        if (this.func_226935_a_(blockPos, entity)) {
            this.func_226933_a_(entity, blockPos);
            this.func_226938_d_(entity);
            this.func_226934_a_(world, entity);
        }
        super.func_196262_a(blockState, world, blockPos, entity);
    }

    private boolean func_226935_a_(BlockPos blockPos, Entity entity) {
        if (entity.field_70122_E) {
            return false;
        }
        if (entity.func_226278_cu_() > (double)blockPos.func_177956_o() + 0.9375 - 1.0E-7) {
            return false;
        }
        if (entity.func_213322_ci().field_72448_b >= -0.08) {
            return false;
        }
        double d = Math.abs((double)blockPos.func_177958_n() + 0.5 - entity.func_226277_ct_());
        \u2603 = Math.abs((double)blockPos.func_177952_p() + 0.5 - entity.func_226281_cx_());
        \u2603 = 0.4375 + (double)(entity.func_213311_cf() / 2.0f);
        return d + 1.0E-7 > \u2603 || \u2603 + 1.0E-7 > \u2603;
    }

    private void func_226933_a_(Entity entity, BlockPos blockPos) {
        if (entity instanceof ServerPlayerEntity && entity.field_70170_p.func_82737_E() % 20L == 0L) {
            CriteriaTriggers.field_229864_K_.func_227152_a_((ServerPlayerEntity)entity, entity.field_70170_p.func_180495_p(blockPos));
        }
    }

    private void func_226938_d_(Entity entity2) {
        Vec3d vec3d = entity2.func_213322_ci();
        if (vec3d.field_72448_b < -0.13) {
            double d = -0.05 / vec3d.field_72448_b;
            entity2.func_213317_d(new Vec3d(vec3d.field_72450_a * d, -0.05, vec3d.field_72449_c * d));
        } else {
            Entity entity2;
            entity2.func_213317_d(new Vec3d(vec3d.field_72450_a, -0.05, vec3d.field_72449_c));
        }
        entity2.field_70143_R = 0.0f;
    }

    private void func_226934_a_(World world, Entity entity) {
        if (HoneyBlock.func_226937_c_(entity)) {
            if (world.field_73012_v.nextInt(5) == 0) {
                entity.func_184185_a(SoundEvents.field_226139_eT_, 1.0f, 1.0f);
            }
            if (!world.field_72995_K && world.field_73012_v.nextInt(5) == 0) {
                world.func_72960_a(entity, (byte)53);
            }
        }
    }

    public static void func_226931_a_(Entity entity) {
        HoneyBlock.func_226932_a_(entity, 5);
    }

    public static void func_226936_b_(Entity entity) {
        HoneyBlock.func_226932_a_(entity, 10);
    }

    private static void func_226932_a_(Entity entity, int n) {
        if (!entity.field_70170_p.field_72995_K) {
            return;
        }
        BlockState blockState = Blocks.field_226907_mc_.func_176223_P();
        for (int i = 0; i < n; ++i) {
            entity.field_70170_p.func_195594_a(new BlockParticleData(ParticleTypes.field_197611_d, blockState), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }
}

