/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;

public class ShulkerBoxBlock
extends ContainerBlock {
    public static final EnumProperty<Direction> field_190957_a = DirectionalBlock.field_176387_N;
    public static final ResourceLocation field_220169_b = new ResourceLocation("contents");
    @Nullable
    private final DyeColor field_190958_b;

    public ShulkerBoxBlock(@Nullable DyeColor dyeColor, Block.Properties properties) {
        super(properties);
        this.field_190958_b = dyeColor;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_190957_a, Direction.UP));
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new ShulkerBoxTileEntity(this.field_190958_b);
    }

    @Override
    public boolean func_229869_c_(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return true;
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (playerEntity.func_175149_v()) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof ShulkerBoxTileEntity) {
            boolean \u26033;
            Direction direction = blockState.func_177229_b(field_190957_a);
            ShulkerBoxTileEntity \u26032 = (ShulkerBoxTileEntity)tileEntity;
            if (\u26032.func_190591_p() == ShulkerBoxTileEntity.AnimationStatus.CLOSED) {
                AxisAlignedBB axisAlignedBB = VoxelShapes.func_197868_b().func_197752_a().func_72321_a(0.5f * (float)direction.func_82601_c(), 0.5f * (float)direction.func_96559_d(), 0.5f * (float)direction.func_82599_e()).func_191195_a(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e());
                \u26033 = world.func_226664_a_(axisAlignedBB.func_186670_a(blockPos.func_177972_a(direction)));
            } else {
                \u26033 = true;
            }
            if (\u26033) {
                playerEntity.func_213829_a(\u26032);
                playerEntity.func_195066_a(Stats.field_191272_ae);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return (BlockState)this.func_176223_P().func_206870_a(field_190957_a, blockItemUseContext.func_196000_l());
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_190957_a);
    }

    @Override
    public void func_176208_a(World world, BlockPos blockPos, BlockState blockState, PlayerEntity playerEntity) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof ShulkerBoxTileEntity) {
            ShulkerBoxTileEntity shulkerBoxTileEntity = (ShulkerBoxTileEntity)tileEntity;
            if (!world.field_72995_K && playerEntity.func_184812_l_() && !shulkerBoxTileEntity.func_191420_l()) {
                ItemStack itemStack = ShulkerBoxBlock.func_190953_b(this.func_190956_e());
                CompoundNBT \u26032 = shulkerBoxTileEntity.func_190580_f(new CompoundNBT());
                if (!\u26032.isEmpty()) {
                    itemStack.func_77983_a("BlockEntityTag", \u26032);
                }
                if (shulkerBoxTileEntity.func_145818_k_()) {
                    itemStack.func_200302_a(shulkerBoxTileEntity.func_200201_e());
                }
                ItemEntity \u26033 = new ItemEntity(world, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), itemStack);
                \u26033.func_174869_p();
                world.func_217376_c(\u26033);
            } else {
                shulkerBoxTileEntity.func_184281_d(playerEntity);
            }
        }
        super.func_176208_a(world, blockPos, blockState, playerEntity);
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState blockState, LootContext.Builder \u260322) {
        LootContext.Builder \u260322;
        TileEntity tileEntity = \u260322.func_216019_b(LootParameters.field_216288_h);
        if (tileEntity instanceof ShulkerBoxTileEntity) {
            ShulkerBoxTileEntity shulkerBoxTileEntity = (ShulkerBoxTileEntity)tileEntity;
            \u260322 = \u260322.func_216017_a(field_220169_b, (lootContext, consumer) -> {
                for (int i = 0; i < shulkerBoxTileEntity.func_70302_i_(); ++i) {
                    consumer.accept(shulkerBoxTileEntity.func_70301_a(i));
                }
            });
        }
        return super.func_220076_a(blockState, \u260322);
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        if (itemStack.func_82837_s() && (\u2603 = world.func_175625_s(blockPos)) instanceof ShulkerBoxTileEntity) {
            ((ShulkerBoxTileEntity)\u2603).func_213903_a(itemStack.func_200301_q());
        }
    }

    @Override
    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState.func_177230_c() == blockState2.func_177230_c()) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof ShulkerBoxTileEntity) {
            world.func_175666_e(blockPos, blockState.func_177230_c());
        }
        super.func_196243_a(blockState, world, blockPos, blockState2, bl);
    }

    @Override
    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader iBlockReader, List<ITextComponent> list2, ITooltipFlag iTooltipFlag) {
        super.func_190948_a(itemStack, iBlockReader, list2, iTooltipFlag);
        CompoundNBT compoundNBT = itemStack.func_179543_a("BlockEntityTag");
        if (compoundNBT != null) {
            if (compoundNBT.func_150297_b("LootTable", 8)) {
                list2.add(new StringTextComponent("???????"));
            }
            if (compoundNBT.func_150297_b("Items", 9)) {
                NonNullList<ItemStack> nonNullList = NonNullList.func_191197_a(27, ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b(compoundNBT, nonNullList);
                int \u26032 = 0;
                int \u26033 = 0;
                for (ItemStack itemStack2 : nonNullList) {
                    if (itemStack2.func_190926_b()) continue;
                    ++\u26033;
                    if (\u26032 > 4) continue;
                    ++\u26032;
                    ITextComponent iTextComponent = itemStack2.func_200301_q().func_212638_h();
                    iTextComponent.func_150258_a(" x").func_150258_a(String.valueOf(itemStack2.func_190916_E()));
                    list2.add(iTextComponent);
                }
                if (\u26033 - \u26032 > 0) {
                    List<ITextComponent> list2;
                    list2.add(new TranslationTextComponent("container.shulkerBox.more", \u26033 - \u26032).func_211708_a(TextFormatting.ITALIC));
                }
            }
        }
    }

    @Override
    public PushReaction func_149656_h(BlockState blockState) {
        return PushReaction.DESTROY;
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        TileEntity tileEntity = iBlockReader.func_175625_s(blockPos);
        if (tileEntity instanceof ShulkerBoxTileEntity) {
            return VoxelShapes.func_197881_a(((ShulkerBoxTileEntity)tileEntity).func_190584_a(blockState));
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    @Override
    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        return Container.func_94526_b((IInventory)((Object)world.func_175625_s(blockPos)));
    }

    @Override
    public ItemStack func_185473_a(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState) {
        ItemStack itemStack = super.func_185473_a(iBlockReader, blockPos, blockState);
        ShulkerBoxTileEntity \u26032 = (ShulkerBoxTileEntity)iBlockReader.func_175625_s(blockPos);
        CompoundNBT \u26033 = \u26032.func_190580_f(new CompoundNBT());
        if (!\u26033.isEmpty()) {
            itemStack.func_77983_a("BlockEntityTag", \u26033);
        }
        return itemStack;
    }

    @Nullable
    public static DyeColor func_190955_b(Item item) {
        return ShulkerBoxBlock.func_190954_c(Block.func_149634_a(item));
    }

    @Nullable
    public static DyeColor func_190954_c(Block block) {
        if (block instanceof ShulkerBoxBlock) {
            return ((ShulkerBoxBlock)block).func_190956_e();
        }
        return null;
    }

    public static Block func_190952_a(@Nullable DyeColor dyeColor) {
        if (dyeColor == null) {
            return Blocks.field_204409_il;
        }
        switch (dyeColor) {
            case WHITE: {
                return Blocks.field_190977_dl;
            }
            case ORANGE: {
                return Blocks.field_190978_dm;
            }
            case MAGENTA: {
                return Blocks.field_190979_dn;
            }
            case LIGHT_BLUE: {
                return Blocks.field_190980_do;
            }
            case YELLOW: {
                return Blocks.field_190981_dp;
            }
            case LIME: {
                return Blocks.field_190982_dq;
            }
            case PINK: {
                return Blocks.field_190983_dr;
            }
            case GRAY: {
                return Blocks.field_190984_ds;
            }
            case LIGHT_GRAY: {
                return Blocks.field_196875_ie;
            }
            case CYAN: {
                return Blocks.field_190986_du;
            }
            default: {
                return Blocks.field_190987_dv;
            }
            case BLUE: {
                return Blocks.field_190988_dw;
            }
            case BROWN: {
                return Blocks.field_190989_dx;
            }
            case GREEN: {
                return Blocks.field_190990_dy;
            }
            case RED: {
                return Blocks.field_190991_dz;
            }
            case BLACK: 
        }
        return Blocks.field_190975_dA;
    }

    @Nullable
    public DyeColor func_190956_e() {
        return this.field_190958_b;
    }

    public static ItemStack func_190953_b(@Nullable DyeColor dyeColor) {
        return new ItemStack(ShulkerBoxBlock.func_190952_a(dyeColor));
    }

    @Override
    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.func_206870_a(field_190957_a, rotation.func_185831_a(blockState.func_177229_b(field_190957_a)));
    }

    @Override
    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        return blockState.func_185907_a(mirror.func_185800_a(blockState.func_177229_b(field_190957_a)));
    }
}

