/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.audio.AudioStreamBuffer;
import net.minecraft.client.audio.AudioStreamManager;
import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.IAudioStream;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Listener;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEngineExecutor;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundSource;
import net.minecraft.client.audio.SoundSystem;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class SoundEngine {
    private static final Marker field_148623_a = MarkerManager.getMarker((String)"SOUNDS");
    private static final Logger field_148621_b = LogManager.getLogger();
    private static final Set<ResourceLocation> field_188775_c = Sets.newHashSet();
    private final SoundHandler field_148622_c;
    private final GameSettings field_148619_d;
    private boolean field_148617_f;
    private final SoundSystem field_217937_g = new SoundSystem();
    private final Listener field_217938_h = this.field_217937_g.func_216407_c();
    private final AudioStreamManager field_217939_i;
    private final SoundEngineExecutor field_217940_j = new SoundEngineExecutor();
    private final ChannelManager field_217941_k = new ChannelManager(this.field_217937_g, this.field_217940_j);
    private int field_148618_g;
    private final Map<ISound, ChannelManager.Entry> field_217942_m = Maps.newHashMap();
    private final Multimap<SoundCategory, ISound> field_217943_n = HashMultimap.create();
    private final List<ITickableSound> field_148625_l = Lists.newArrayList();
    private final Map<ISound, Integer> field_148626_m = Maps.newHashMap();
    private final Map<ISound, Integer> field_148624_n = Maps.newHashMap();
    private final List<ISoundEventListener> field_188777_o = Lists.newArrayList();
    private final List<ITickableSound> field_229361_s_ = Lists.newArrayList();
    private final List<Sound> field_204261_q = Lists.newArrayList();

    public SoundEngine(SoundHandler soundHandler, GameSettings gameSettings, IResourceManager iResourceManager) {
        this.field_148622_c = soundHandler;
        this.field_148619_d = gameSettings;
        this.field_217939_i = new AudioStreamManager(iResourceManager);
    }

    public void func_148596_a() {
        field_188775_c.clear();
        for (SoundEvent soundEvent : Registry.field_212633_v) {
            ResourceLocation resourceLocation = soundEvent.func_187503_a();
            if (this.field_148622_c.func_184398_a(resourceLocation) != null) continue;
            field_148621_b.warn("Missing sound for event: {}", (Object)Registry.field_212633_v.func_177774_c(soundEvent));
            field_188775_c.add(resourceLocation);
        }
        this.func_148613_b();
        this.func_148608_i();
    }

    private synchronized void func_148608_i() {
        if (this.field_148617_f) {
            return;
        }
        try {
            this.field_217937_g.func_216404_a();
            this.field_217938_h.func_216468_b();
            this.field_217938_h.func_216466_a(this.field_148619_d.func_186711_a(SoundCategory.MASTER));
            this.field_217939_i.func_217908_a(this.field_204261_q).thenRun(this.field_204261_q::clear);
            this.field_148617_f = true;
            field_148621_b.info(field_148623_a, "Sound engine started");
        }
        catch (RuntimeException runtimeException) {
            field_148621_b.error(field_148623_a, "Error starting SoundSystem. Turning off sounds & music", (Throwable)runtimeException);
        }
    }

    private float func_188769_a(SoundCategory soundCategory) {
        if (soundCategory == null || soundCategory == SoundCategory.MASTER) {
            return 1.0f;
        }
        return this.field_148619_d.func_186711_a(soundCategory);
    }

    public void func_188771_a(SoundCategory soundCategory, float f) {
        if (!this.field_148617_f) {
            return;
        }
        if (soundCategory == SoundCategory.MASTER) {
            this.field_217938_h.func_216466_a(f);
            return;
        }
        this.field_217942_m.forEach((iSound, entry) -> {
            float f = this.func_188770_e((ISound)iSound);
            entry.func_217888_a(soundSource -> {
                if (f <= 0.0f) {
                    soundSource.func_216418_f();
                } else {
                    soundSource.func_216430_b(f);
                }
            });
        });
    }

    public void func_148613_b() {
        if (this.field_148617_f) {
            this.func_148614_c();
            this.field_217939_i.func_217912_a();
            this.field_217937_g.func_216409_b();
            this.field_148617_f = false;
        }
    }

    public void func_148602_b(ISound iSound) {
        if (this.field_148617_f && (\u2603 = this.field_217942_m.get(iSound)) != null) {
            \u2603.func_217888_a(SoundSource::func_216418_f);
        }
    }

    public void func_148614_c() {
        if (this.field_148617_f) {
            this.field_217940_j.func_213176_a();
            this.field_217942_m.values().forEach(entry -> entry.func_217888_a(SoundSource::func_216418_f));
            this.field_217942_m.clear();
            this.field_217941_k.func_217903_b();
            this.field_148626_m.clear();
            this.field_148625_l.clear();
            this.field_217943_n.clear();
            this.field_148624_n.clear();
            this.field_229361_s_.clear();
        }
    }

    public void func_188774_a(ISoundEventListener iSoundEventListener) {
        this.field_188777_o.add(iSoundEventListener);
    }

    public void func_188773_b(ISoundEventListener iSoundEventListener) {
        this.field_188777_o.remove(iSoundEventListener);
    }

    public void func_217921_a(boolean bl) {
        if (!bl) {
            this.func_217927_h();
        }
        this.field_217941_k.func_217899_a();
    }

    private void func_217927_h() {
        ++this.field_148618_g;
        this.field_229361_s_.forEach(this::func_148611_c);
        this.field_229361_s_.clear();
        for (ITickableSound iTickableSound : this.field_148625_l) {
            iTickableSound.func_73660_a();
            if (iTickableSound.func_147667_k()) {
                this.func_148602_b(iTickableSound);
                continue;
            }
            float f = this.func_188770_e(iTickableSound);
            float f2 = this.func_188772_d(iTickableSound);
            Vec3d \u26032 = new Vec3d(iTickableSound.func_147649_g(), iTickableSound.func_147654_h(), iTickableSound.func_147651_i());
            ChannelManager.Entry \u26033 = this.field_217942_m.get(iTickableSound);
            if (\u26033 == null) continue;
            \u26033.func_217888_a(soundSource -> {
                soundSource.func_216430_b(f);
                soundSource.func_216422_a(f2);
                soundSource.func_216420_a(\u26032);
            });
        }
        Iterator<Map.Entry<ISound, ChannelManager.Entry>> iterator = this.field_217942_m.entrySet().iterator();
        while (iterator.hasNext()) {
            int n;
            Map.Entry<ISound, ChannelManager.Entry> entry = iterator.next();
            ChannelManager.Entry \u26034 = entry.getValue();
            ISound \u26035 = entry.getKey();
            float \u26036 = this.field_148619_d.func_186711_a(\u26035.func_184365_d());
            if (\u26036 <= 0.0f) {
                \u26034.func_217888_a(SoundSource::func_216418_f);
                iterator.remove();
                continue;
            }
            if (!\u26034.func_217889_a() || (n = this.field_148624_n.get(\u26035).intValue()) > this.field_148618_g) continue;
            int \u26037 = \u26035.func_147652_d();
            if (\u26035.func_147657_c() && \u26037 > 0) {
                this.field_148626_m.put(\u26035, this.field_148618_g + \u26037);
            }
            iterator.remove();
            field_148621_b.debug(field_148623_a, "Removed channel {} because it's not playing anymore", (Object)\u26034);
            this.field_148624_n.remove(\u26035);
            try {
                this.field_217943_n.remove((Object)\u26035.func_184365_d(), (Object)\u26035);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (!(\u26035 instanceof ITickableSound)) continue;
            this.field_148625_l.remove(\u26035);
        }
        Iterator<Map.Entry<ISound, Integer>> iterator2 = this.field_148626_m.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ISound, Integer> \u26038 = iterator2.next();
            if (this.field_148618_g < \u26038.getValue()) continue;
            ISound \u26039 = \u26038.getKey();
            if (\u26039 instanceof ITickableSound) {
                ((ITickableSound)\u26039).func_73660_a();
            }
            this.func_148611_c(\u26039);
            iterator2.remove();
        }
    }

    public boolean func_217933_b(ISound iSound) {
        if (!this.field_148617_f) {
            return false;
        }
        if (this.field_148624_n.containsKey(iSound) && this.field_148624_n.get(iSound) <= this.field_148618_g) {
            return true;
        }
        return this.field_217942_m.containsKey(iSound);
    }

    public void func_148611_c(ISound iSound2) {
        ISound iSound2;
        if (!this.field_148617_f) {
            return;
        }
        SoundEventAccessor soundEventAccessor = iSound2.func_184366_a(this.field_148622_c);
        ResourceLocation \u26032 = iSound2.func_147650_b();
        if (soundEventAccessor == null) {
            if (field_188775_c.add(\u26032)) {
                field_148621_b.warn(field_148623_a, "Unable to play unknown soundEvent: {}", (Object)\u26032);
            }
            return;
        }
        if (!this.field_188777_o.isEmpty()) {
            for (ISoundEventListener iSoundEventListener : this.field_188777_o) {
                iSoundEventListener.func_184067_a(iSound2, soundEventAccessor);
            }
        }
        if (this.field_217938_h.func_216467_a() <= 0.0f) {
            field_148621_b.debug(field_148623_a, "Skipped playing soundEvent: {}, master volume was zero", (Object)\u26032);
            return;
        }
        Sound \u26033 = iSound2.func_184364_b();
        if (\u26033 == SoundHandler.field_147700_a) {
            if (field_188775_c.add(\u26032)) {
                field_148621_b.warn(field_148623_a, "Unable to play empty soundEvent: {}", (Object)\u26032);
            }
            return;
        }
        float \u26034 = iSound2.func_147653_e();
        float \u26035 = Math.max(\u26034, 1.0f) * (float)\u26033.func_206255_j();
        SoundCategory \u26036 = iSound2.func_184365_d();
        float \u26037 = this.func_188770_e(iSound2);
        float \u26038 = this.func_188772_d(iSound2);
        ISound.AttenuationType \u26039 = iSound2.func_147656_j();
        boolean \u260310 = iSound2.func_217861_m();
        if (\u26037 == 0.0f && !iSound2.func_211503_n()) {
            field_148621_b.debug(field_148623_a, "Skipped playing sound {}, volume was zero.", (Object)\u26033.func_188719_a());
            return;
        }
        boolean \u260311 = iSound2.func_147657_c() && iSound2.func_147652_d() == 0;
        Vec3d \u260312 = new Vec3d(iSound2.func_147649_g(), iSound2.func_147654_h(), iSound2.func_147651_i());
        ChannelManager.Entry \u260313 = this.field_217941_k.func_217895_a(\u26033.func_188723_h() ? SoundSystem.Mode.STREAMING : SoundSystem.Mode.STATIC);
        field_148621_b.debug(field_148623_a, "Playing sound {} for event {}", (Object)\u26033.func_188719_a(), (Object)\u26032);
        this.field_148624_n.put(iSound2, this.field_148618_g + 20);
        this.field_217942_m.put(iSound2, \u260313);
        this.field_217943_n.put((Object)\u26036, (Object)iSound2);
        \u260313.func_217888_a(soundSource -> {
            soundSource.func_216422_a(\u26038);
            soundSource.func_216430_b(\u26037);
            if (\u26039 == ISound.AttenuationType.LINEAR) {
                soundSource.func_216423_c(\u26035);
            } else {
                soundSource.func_216419_h();
            }
            soundSource.func_216425_a(\u260311);
            soundSource.func_216420_a(\u260312);
            soundSource.func_216432_b(\u260310);
        });
        if (!\u26033.func_188723_h()) {
            this.field_217939_i.func_217909_a(\u26033.func_188721_b()).thenAccept(audioStreamBuffer -> \u260313.func_217888_a(soundSource -> {
                soundSource.func_216429_a((AudioStreamBuffer)audioStreamBuffer);
                soundSource.func_216438_c();
            }));
        } else {
            this.field_217939_i.func_217917_b(\u26033.func_188721_b()).thenAccept(iAudioStream -> \u260313.func_217888_a(soundSource -> {
                soundSource.func_216433_a((IAudioStream)iAudioStream);
                soundSource.func_216438_c();
            }));
        }
        if (iSound2 instanceof ITickableSound) {
            this.field_148625_l.add((ITickableSound)iSound2);
        }
    }

    public void func_229363_a_(ITickableSound iTickableSound) {
        this.field_229361_s_.add(iTickableSound);
    }

    public void func_204259_a(Sound sound) {
        this.field_204261_q.add(sound);
    }

    private float func_188772_d(ISound iSound) {
        return MathHelper.func_76131_a(iSound.func_147655_f(), 0.5f, 2.0f);
    }

    private float func_188770_e(ISound iSound) {
        return MathHelper.func_76131_a(iSound.func_147653_e() * this.func_188769_a(iSound.func_184365_d()), 0.0f, 1.0f);
    }

    public void func_148610_e() {
        if (this.field_148617_f) {
            this.field_217941_k.func_217897_a(stream -> stream.forEach(SoundSource::func_216439_d));
        }
    }

    public void func_148604_f() {
        if (this.field_148617_f) {
            this.field_217941_k.func_217897_a(stream -> stream.forEach(SoundSource::func_216437_e));
        }
    }

    public void func_148599_a(ISound iSound, int n) {
        this.field_148626_m.put(iSound, this.field_148618_g + n);
    }

    public void func_217920_a(ActiveRenderInfo activeRenderInfo) {
        if (!this.field_148617_f || !activeRenderInfo.func_216786_h()) {
            return;
        }
        Vec3d vec3d = activeRenderInfo.func_216785_c();
        Vector3f \u26032 = activeRenderInfo.func_227996_l_();
        Vector3f \u26033 = activeRenderInfo.func_227997_m_();
        this.field_217940_j.execute(() -> {
            this.field_217938_h.func_216465_a(vec3d);
            this.field_217938_h.func_227580_a_(\u26032, \u26033);
        });
    }

    public void func_195855_a(@Nullable ResourceLocation resourceLocation2, @Nullable SoundCategory soundCategory) {
        ResourceLocation resourceLocation2;
        if (soundCategory != null) {
            for (ISound iSound : this.field_217943_n.get((Object)soundCategory)) {
                if (resourceLocation2 != null && !iSound.func_147650_b().equals(resourceLocation2)) continue;
                this.func_148602_b(iSound);
            }
        } else if (resourceLocation2 == null) {
            this.func_148614_c();
        } else {
            for (ISound iSound : this.field_217942_m.keySet()) {
                if (!iSound.func_147650_b().equals(resourceLocation2)) continue;
                this.func_148602_b(iSound);
            }
        }
    }

    public String func_217932_f() {
        return this.field_217937_g.func_216402_d();
    }
}

