/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractGui {
    public static final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("textures/gui/options_background.png");
    public static final ResourceLocation STATS_ICON_LOCATION = new ResourceLocation("textures/gui/container/stats_icons.png");
    public static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private int blitOffset;

    protected void hLine(int n, int n2, int n3, int n4) {
        if (n2 < n) {
            \u2603 = n;
            n = n2;
            n2 = \u2603;
        }
        AbstractGui.fill(n, n3, n2 + 1, n3 + 1, n4);
    }

    protected void vLine(int n, int n2, int n3, int n4) {
        if (n3 < n2) {
            \u2603 = n2;
            n2 = n3;
            n3 = \u2603;
        }
        AbstractGui.fill(n, n2 + 1, n + 1, n3, n4);
    }

    public static void fill(int n, int n2, int n3, int n4, int n5) {
        AbstractGui.fill(TransformationMatrix.func_227983_a_().func_227988_c_(), n, n2, n3, n4, n5);
    }

    public static void fill(Matrix4f matrix4f, int n, int n2, int n3, int n4, int n5) {
        if (n < n3) {
            \u2603 = n;
            n = n3;
            n3 = \u2603;
        }
        if (n2 < n4) {
            \u2603 = n2;
            n2 = n4;
            n4 = \u2603;
        }
        float f = (float)(n5 >> 24 & 0xFF) / 255.0f;
        \u2603 = (float)(n5 >> 16 & 0xFF) / 255.0f;
        \u2603 = (float)(n5 >> 8 & 0xFF) / 255.0f;
        \u2603 = (float)(n5 & 0xFF) / 255.0f;
        BufferBuilder \u26032 = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        \u26032.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        \u26032.func_227888_a_(matrix4f, n, n4, 0.0f).func_227885_a_(\u2603, \u2603, \u2603, f).func_181675_d();
        \u26032.func_227888_a_(matrix4f, n3, n4, 0.0f).func_227885_a_(\u2603, \u2603, \u2603, f).func_181675_d();
        \u26032.func_227888_a_(matrix4f, n3, n2, 0.0f).func_227885_a_(\u2603, \u2603, \u2603, f).func_181675_d();
        \u26032.func_227888_a_(matrix4f, n, n2, 0.0f).func_227885_a_(\u2603, \u2603, \u2603, f).func_181675_d();
        \u26032.func_178977_d();
        WorldVertexBufferUploader.func_181679_a(\u26032);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    protected void fillGradient(int n, int n2, int n3, int n4, int n5, int n6) {
        float f = (float)(n5 >> 24 & 0xFF) / 255.0f;
        \u2603 = (float)(n5 >> 16 & 0xFF) / 255.0f;
        \u2603 = (float)(n5 >> 8 & 0xFF) / 255.0f;
        \u2603 = (float)(n5 & 0xFF) / 255.0f;
        \u2603 = (float)(n6 >> 24 & 0xFF) / 255.0f;
        \u2603 = (float)(n6 >> 16 & 0xFF) / 255.0f;
        \u2603 = (float)(n6 >> 8 & 0xFF) / 255.0f;
        \u2603 = (float)(n6 & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel(7425);
        Tessellator \u26032 = Tessellator.func_178181_a();
        BufferBuilder \u26033 = \u26032.func_178180_c();
        \u26033.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        \u26033.func_225582_a_(n3, n2, this.blitOffset).func_227885_a_(\u2603, \u2603, \u2603, f).func_181675_d();
        \u26033.func_225582_a_(n, n2, this.blitOffset).func_227885_a_(\u2603, \u2603, \u2603, f).func_181675_d();
        \u26033.func_225582_a_(n, n4, this.blitOffset).func_227885_a_(\u2603, \u2603, \u2603, \u2603).func_181675_d();
        \u26033.func_225582_a_(n3, n4, this.blitOffset).func_227885_a_(\u2603, \u2603, \u2603, \u2603).func_181675_d();
        \u26032.func_78381_a();
        RenderSystem.shadeModel(7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public void drawCenteredString(FontRenderer fontRenderer, String string, int n, int n2, int n3) {
        fontRenderer.func_175063_a(string, n - fontRenderer.func_78256_a(string) / 2, n2, n3);
    }

    public void drawRightAlignedString(FontRenderer fontRenderer, String string, int n, int n2, int n3) {
        fontRenderer.func_175063_a(string, n - fontRenderer.func_78256_a(string), n2, n3);
    }

    public void drawString(FontRenderer fontRenderer, String string, int n, int n2, int n3) {
        fontRenderer.func_175063_a(string, n, n2, n3);
    }

    public static void blit(int n, int n2, int n3, int n4, int n5, TextureAtlasSprite textureAtlasSprite) {
        AbstractGui.innerBlit(n, n + n4, n2, n2 + n5, n3, textureAtlasSprite.func_94209_e(), textureAtlasSprite.func_94212_f(), textureAtlasSprite.func_94206_g(), textureAtlasSprite.func_94210_h());
    }

    public void blit(int n, int n2, int n3, int n4, int n5, int n6) {
        AbstractGui.blit(n, n2, this.blitOffset, n3, n4, n5, n6, 256, 256);
    }

    public static void blit(int n, int n2, int n3, float f, float f2, int n4, int n5, int n6, int n7) {
        AbstractGui.innerBlit(n, n + n4, n2, n2 + n5, n3, n4, n5, f, f2, n7, n6);
    }

    public static void blit(int n, int n2, int n3, int n4, float f, float f2, int n5, int n6, int n7, int n8) {
        AbstractGui.innerBlit(n, n + n3, n2, n2 + n4, 0, n5, n6, f, f2, n7, n8);
    }

    public static void blit(int n, int n2, float f, float f2, int n3, int n4, int n5, int n6) {
        AbstractGui.blit(n, n2, n3, n4, f, f2, n3, n4, n5, n6);
    }

    private static void innerBlit(int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, float f2, int n8, int n9) {
        AbstractGui.innerBlit(n, n2, n3, n4, n5, (f + 0.0f) / (float)n8, (f + (float)n6) / (float)n8, (f2 + 0.0f) / (float)n9, (f2 + (float)n7) / (float)n9);
    }

    protected static void innerBlit(int n, int n2, int n3, int n4, int n5, float f, float f2, float f3, float f4) {
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_225582_a_(n, n4, n5).func_225583_a_(f, f4).func_181675_d();
        bufferBuilder.func_225582_a_(n2, n4, n5).func_225583_a_(f2, f4).func_181675_d();
        bufferBuilder.func_225582_a_(n2, n3, n5).func_225583_a_(f2, f3).func_181675_d();
        bufferBuilder.func_225582_a_(n, n3, n5).func_225583_a_(f, f3).func_181675_d();
        bufferBuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a(bufferBuilder);
    }

    public int getBlitOffset() {
        return this.blitOffset;
    }

    public void setBlitOffset(int n) {
        this.blitOffset = n;
    }
}

