/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.fonts.EmptyGlyph;
import net.minecraft.client.gui.fonts.Font;
import net.minecraft.client.gui.fonts.IGlyph;
import net.minecraft.client.gui.fonts.TexturedGlyph;
import net.minecraft.client.gui.fonts.providers.IGlyphProvider;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class FontRenderer
implements AutoCloseable {
    public final int field_78288_b = 9;
    public final Random field_78289_c = new Random();
    private final TextureManager field_78298_i;
    private final Font field_211127_e;
    private boolean field_78294_m;

    public FontRenderer(TextureManager textureManager, Font font) {
        this.field_78298_i = textureManager;
        this.field_211127_e = font;
    }

    public void func_211568_a(List<IGlyphProvider> list) {
        this.field_211127_e.func_211570_a(list);
    }

    @Override
    public void close() {
        this.field_211127_e.close();
    }

    public int func_175063_a(String string, float f, float f2, int n) {
        RenderSystem.enableAlphaTest();
        return this.func_228078_a_(string, f, f2, n, TransformationMatrix.func_227983_a_().func_227988_c_(), true);
    }

    public int func_211126_b(String string, float f, float f2, int n) {
        RenderSystem.enableAlphaTest();
        return this.func_228078_a_(string, f, f2, n, TransformationMatrix.func_227983_a_().func_227988_c_(), false);
    }

    public String func_147647_b(String string2) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(string2), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException arabicShapingException) {
            String string2;
            return string2;
        }
    }

    private int func_228078_a_(String string, float f, float f2, int n, Matrix4f matrix4f, boolean bl) {
        if (string == null) {
            return 0;
        }
        IRenderTypeBuffer.Impl impl = IRenderTypeBuffer.func_228455_a_(Tessellator.func_178181_a().func_178180_c());
        int \u26032 = this.func_228079_a_(string, f, f2, n, bl, matrix4f, impl, false, 0, 0xF000F0);
        impl.func_228461_a_();
        return \u26032;
    }

    public int func_228079_a_(String string, float f, float f2, int n, boolean bl, Matrix4f matrix4f, IRenderTypeBuffer iRenderTypeBuffer, boolean bl2, int n2, int n3) {
        return this.func_228080_b_(string, f, f2, n, bl, matrix4f, iRenderTypeBuffer, bl2, n2, n3);
    }

    private int func_228080_b_(String string2, float \u260332, float f, int n4, boolean bl, Matrix4f matrix4f, IRenderTypeBuffer iRenderTypeBuffer, boolean bl2, int n2, int n3) {
        int n4;
        if (this.field_78294_m) {
            String string2 = this.func_147647_b(string2);
        }
        if ((n4 & 0xFC000000) == 0) {
            n4 |= 0xFF000000;
        }
        if (bl) {
            this.func_228081_c_(string2, \u260332, f, n4, true, matrix4f, iRenderTypeBuffer, bl2, n2, n3);
        }
        Matrix4f \u26032 = matrix4f.func_226601_d_();
        \u26032.func_226597_a_(new Vector3f(0.0f, 0.0f, 0.001f));
        float \u260332 = this.func_228081_c_(string2, \u260332, f, n4, false, \u26032, iRenderTypeBuffer, bl2, n2, n3);
        return (int)\u260332 + (bl ? 1 : 0);
    }

    private float func_228081_c_(String string, float f, float f2, int n, boolean bl, Matrix4f matrix4f, IRenderTypeBuffer iRenderTypeBuffer, boolean bl2, int n2, int n3) {
        float f3;
        float f4 = bl ? 0.25f : 1.0f;
        \u2603 = (float)(n >> 16 & 0xFF) / 255.0f * f4;
        \u2603 = (float)(n >> 8 & 0xFF) / 255.0f * f4;
        \u2603 = (float)(n & 0xFF) / 255.0f * f4;
        f3 = f;
        \u26038 = \u2603;
        \u26039 = \u2603;
        \u260310 = \u2603;
        \u2603 = (float)(n >> 24 & 0xFF) / 255.0f;
        boolean \u26032 = false;
        boolean \u26033 = false;
        boolean \u26034 = false;
        boolean \u26035 = false;
        boolean \u26036 = false;
        ArrayList \u26037 = Lists.newArrayList();
        for (int i = 0; i < string.length(); ++i) {
            float \u260310;
            float \u26039;
            float \u26038;
            Object object;
            char c = string.charAt(i);
            if (c == '\u00a7' && i + 1 < string.length()) {
                object = TextFormatting.func_211165_a(string.charAt(i + 1));
                if (object != null) {
                    if (((TextFormatting)((Object)object)).func_211166_f()) {
                        \u26032 = false;
                        \u26033 = false;
                        \u26036 = false;
                        \u26035 = false;
                        \u26034 = false;
                        \u26038 = \u2603;
                        \u26039 = \u2603;
                        \u260310 = \u2603;
                    }
                    if (((TextFormatting)((Object)object)).func_211163_e() != null) {
                        int n4 = ((TextFormatting)((Object)object)).func_211163_e();
                        \u26038 = (float)(n4 >> 16 & 0xFF) / 255.0f * f4;
                        \u26039 = (float)(n4 >> 8 & 0xFF) / 255.0f * f4;
                        \u260310 = (float)(n4 & 0xFF) / 255.0f * f4;
                    } else if (object == TextFormatting.OBFUSCATED) {
                        \u26032 = true;
                    } else if (object == TextFormatting.BOLD) {
                        \u26033 = true;
                    } else if (object == TextFormatting.STRIKETHROUGH) {
                        \u26036 = true;
                    } else if (object == TextFormatting.UNDERLINE) {
                        \u26035 = true;
                    } else if (object == TextFormatting.ITALIC) {
                        \u26034 = true;
                    }
                }
                ++i;
                continue;
            }
            object = this.field_211127_e.func_211184_b(c);
            TexturedGlyph texturedGlyph = \u2603 = \u26032 && c != ' ' ? this.field_211127_e.func_211188_a((IGlyph)object) : this.field_211127_e.func_211187_a(c);
            if (!(\u2603 instanceof EmptyGlyph)) {
                float f5 = \u26033 ? object.func_223275_b_() : 0.0f;
                \u2603 = bl ? object.func_223276_c_() : 0.0f;
                IVertexBuilder \u260311 = iRenderTypeBuffer.getBuffer(\u2603.func_228163_a_(bl2));
                this.func_228077_a_(\u2603, \u26033, \u26034, f5, f3 + \u2603, f2 + \u2603, matrix4f, \u260311, \u26038, \u26039, \u260310, \u2603, n3);
            }
            f5 = object.func_223274_a_(\u26033);
            float f6 = \u2603 = bl ? 1.0f : 0.0f;
            if (\u26036) {
                \u26037.add(new TexturedGlyph.Effect(f3 + \u2603 - 1.0f, f2 + \u2603 + 4.5f, f3 + \u2603 + f5, f2 + \u2603 + 4.5f - 1.0f, -0.01f, \u26038, \u26039, \u260310, \u2603));
            }
            if (\u26035) {
                \u26037.add(new TexturedGlyph.Effect(f3 + \u2603 - 1.0f, f2 + \u2603 + 9.0f, f3 + \u2603 + f5, f2 + \u2603 + 9.0f - 1.0f, -0.01f, \u26038, \u26039, \u260310, \u2603));
            }
            f3 += f5;
        }
        if (n2 != 0) {
            \u2603 = (float)(n2 >> 24 & 0xFF) / 255.0f;
            \u2603 = (float)(n2 >> 16 & 0xFF) / 255.0f;
            \u2603 = (float)(n2 >> 8 & 0xFF) / 255.0f;
            \u2603 = (float)(n2 & 0xFF) / 255.0f;
            \u26037.add(new TexturedGlyph.Effect(f - 1.0f, f2 + 9.0f, f3 + 1.0f, f2 - 1.0f, 0.01f, \u2603, \u2603, \u2603, \u2603));
        }
        if (!\u26037.isEmpty()) {
            TexturedGlyph texturedGlyph = this.field_211127_e.func_228157_b_();
            IVertexBuilder \u260312 = iRenderTypeBuffer.getBuffer(texturedGlyph.func_228163_a_(bl2));
            for (TexturedGlyph.Effect effect : \u26037) {
                texturedGlyph.func_228162_a_(effect, matrix4f, \u260312, n3);
            }
        }
        return f3;
    }

    private void func_228077_a_(TexturedGlyph texturedGlyph, boolean bl, boolean bl2, float f, float f2, float f3, Matrix4f matrix4f, IVertexBuilder iVertexBuilder, float f4, float f5, float f6, float f7, int n) {
        texturedGlyph.func_225595_a_(bl2, f2, f3, matrix4f, iVertexBuilder, f4, f5, f6, f7, n);
        if (bl) {
            texturedGlyph.func_225595_a_(bl2, f2 + f, f3, matrix4f, iVertexBuilder, f4, f5, f6, f7, n);
        }
    }

    public int func_78256_a(String string) {
        if (string == null) {
            return 0;
        }
        float f = 0.0f;
        boolean \u26032 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u00a7' && i < string.length() - 1) {
                if ((\u2603 = TextFormatting.func_211165_a(string.charAt(++i))) == TextFormatting.BOLD) {
                    \u26032 = true;
                    continue;
                }
                if (\u2603 == null || !\u2603.func_211166_f()) continue;
                \u26032 = false;
                continue;
            }
            f += this.field_211127_e.func_211184_b(c).func_223274_a_(\u26032);
        }
        return MathHelper.func_76123_f(f);
    }

    public float func_211125_a(char c) {
        if (c == '\u00a7') {
            return 0.0f;
        }
        return this.field_211127_e.func_211184_b(c).func_223274_a_(false);
    }

    public String func_78269_a(String string, int n) {
        return this.func_78262_a(string, n, false);
    }

    public String func_78262_a(String string, int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        float \u26032 = 0.0f;
        int \u26033 = bl ? string.length() - 1 : 0;
        int \u26034 = bl ? -1 : 1;
        boolean \u26035 = false;
        boolean \u26036 = false;
        for (int i = \u26033; i >= 0 && i < string.length() && \u26032 < (float)n; i += \u26034) {
            char c = string.charAt(i);
            if (\u26035) {
                \u26035 = false;
                TextFormatting textFormatting = TextFormatting.func_211165_a(c);
                if (textFormatting == TextFormatting.BOLD) {
                    \u26036 = true;
                } else if (textFormatting != null && textFormatting.func_211166_f()) {
                    \u26036 = false;
                }
            } else if (c == '\u00a7') {
                \u26035 = true;
            } else {
                \u26032 += this.func_211125_a(c);
                if (\u26036) {
                    \u26032 += 1.0f;
                }
            }
            if (\u26032 > (float)n) break;
            if (bl) {
                stringBuilder.insert(0, c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private String func_78273_d(String string) {
        while (string != null && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public void func_78279_b(String string2, int n, int n2, int n3, int n4) {
        String string2 = this.func_78273_d(string2);
        this.func_211124_b(string2, n, n2, n3, n4);
    }

    private void func_211124_b(String string, int n, int n2, int n3, int n4) {
        List<String> list = this.func_78271_c(string, n3);
        Matrix4f \u26032 = TransformationMatrix.func_227983_a_().func_227988_c_();
        for (String string22 : list) {
            String string22;
            float f = n;
            if (this.field_78294_m) {
                int n5 = this.func_78256_a(this.func_147647_b(string22));
                f += (float)(n3 - n5);
            }
            this.func_228078_a_(string22, f, n2, n4, \u26032, false);
            n2 += 9;
        }
    }

    public int func_78267_b(String string, int n) {
        return 9 * this.func_78271_c(string, n).size();
    }

    public void func_78275_b(boolean bl) {
        this.field_78294_m = bl;
    }

    public List<String> func_78271_c(String string, int n) {
        return Arrays.asList(this.func_78280_d(string, n).split("\n"));
    }

    public String func_78280_d(String \u260352, int n) {
        String string = "";
        while (!\u260352.isEmpty()) {
            int n2 = this.func_78259_e(\u260352, n);
            if (\u260352.length() <= n2) {
                return string + \u260352;
            }
            String \u26032 = \u260352.substring(0, n2);
            char \u26033 = \u260352.charAt(n2);
            boolean \u26034 = \u26033 == ' ' || \u26033 == '\n';
            String \u260352 = TextFormatting.func_211164_a(\u26032) + \u260352.substring(n2 + (\u26034 ? 1 : 0));
            string = string + \u26032 + "\n";
        }
        return string;
    }

    public int func_78259_e(String string, int n) {
        int n2;
        \u2603 = Math.max(1, n);
        \u2603 = string.length();
        float f = 0.0f;
        int \u26032 = -1;
        boolean \u26033 = false;
        boolean \u26034 = true;
        for (n2 = 0; n2 < \u2603; ++n2) {
            char c = string.charAt(n2);
            switch (c) {
                case '\u00a7': {
                    if (n2 >= \u2603 - 1) break;
                    if ((\u2603 = TextFormatting.func_211165_a(string.charAt(++n2))) == TextFormatting.BOLD) {
                        \u26033 = true;
                        break;
                    }
                    if (\u2603 == null || !\u2603.func_211166_f()) break;
                    \u26033 = false;
                    break;
                }
                case '\n': {
                    --n2;
                    break;
                }
                case ' ': {
                    \u26032 = n2;
                }
                default: {
                    if (f != 0.0f) {
                        \u26034 = false;
                    }
                    f += this.func_211125_a(c);
                    if (!\u26033) break;
                    f += 1.0f;
                }
            }
            if (c == '\n') {
                \u26032 = ++n2;
                break;
            }
            if (!(f > (float)\u2603)) continue;
            if (!\u26034) break;
            ++n2;
            break;
        }
        if (n2 != \u2603 && \u26032 != -1 && \u26032 < n2) {
            return \u26032;
        }
        return n2;
    }

    public int func_216863_a(String string, int n, int n2, boolean bl) {
        int n3 = n2;
        boolean \u26032 = n < 0;
        \u2603 = Math.abs(n);
        for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
            if (\u26032) {
                while (bl && n3 > 0 && (string.charAt(n3 - 1) == ' ' || string.charAt(n3 - 1) == '\n')) {
                    --n3;
                }
                while (n3 > 0 && string.charAt(n3 - 1) != ' ' && string.charAt(n3 - 1) != '\n') {
                    --n3;
                }
                continue;
            }
            \u2603 = string.length();
            \u2603 = string.indexOf(32, n3);
            \u2603 = string.indexOf(10, n3);
            n3 = \u2603 == -1 && \u2603 == -1 ? -1 : (\u2603 != -1 && \u2603 != -1 ? Math.min(\u2603, \u2603) : (\u2603 != -1 ? \u2603 : \u2603));
            if (n3 == -1) {
                n3 = \u2603;
                continue;
            }
            while (bl && n3 < \u2603 && (string.charAt(n3) == ' ' || string.charAt(n3) == '\n')) {
                ++n3;
            }
        }
        return n3;
    }

    public boolean func_78260_a() {
        return this.field_78294_m;
    }
}

