/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public abstract class SlotGui
extends FocusableGui
implements IRenderable {
    protected static final int NO_DRAG = -1;
    protected static final int DRAG_OUTSIDE = -2;
    protected final Minecraft minecraft;
    protected int width;
    protected int height;
    protected int y0;
    protected int y1;
    protected int x1;
    protected int x0;
    protected final int itemHeight;
    protected boolean centerListVertically = true;
    protected int yDrag = -2;
    protected double yo;
    protected boolean visible = true;
    protected boolean renderSelection = true;
    protected boolean renderHeader;
    protected int headerHeight;
    private boolean scrolling;

    public SlotGui(Minecraft minecraft, int n, int n2, int n3, int n4, int n5) {
        this.minecraft = minecraft;
        this.width = n;
        this.height = n2;
        this.y0 = n3;
        this.y1 = n4;
        this.itemHeight = n5;
        this.x0 = 0;
        this.x1 = n;
    }

    public void updateSize(int n, int n2, int n3, int n4) {
        this.width = n;
        this.height = n2;
        this.y0 = n3;
        this.y1 = n4;
        this.x0 = 0;
        this.x1 = n;
    }

    public void setRenderSelection(boolean bl) {
        this.renderSelection = bl;
    }

    protected void setRenderHeader(boolean bl, int n) {
        this.renderHeader = bl;
        this.headerHeight = n;
        if (!bl) {
            this.headerHeight = 0;
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected abstract int getItemCount();

    @Override
    public List<? extends IGuiEventListener> children() {
        return Collections.emptyList();
    }

    protected boolean selectItem(int n, int n2, double d, double d2) {
        return true;
    }

    protected abstract boolean isSelectedItem(int var1);

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected abstract void renderBackground();

    protected void updateItemPosition(int n, int n2, int n3, float f) {
    }

    protected abstract void renderItem(int var1, int var2, int var3, int var4, int var5, int var6, float var7);

    protected void renderHeader(int n, int n2, Tessellator tessellator) {
    }

    protected void clickedHeader(int n, int n2) {
    }

    protected void renderDecorations(int n, int n2) {
    }

    public int getItemAtPosition(double d, double d2) {
        int n = this.x0 + this.width / 2 - this.getRowWidth() / 2;
        \u2603 = this.x0 + this.width / 2 + this.getRowWidth() / 2;
        \u2603 = MathHelper.func_76128_c(d2 - (double)this.y0) - this.headerHeight + (int)this.yo - 4;
        \u2603 = \u2603 / this.itemHeight;
        if (d < (double)this.getScrollbarPosition() && d >= (double)n && d <= (double)\u2603 && \u2603 >= 0 && \u2603 >= 0 && \u2603 < this.getItemCount()) {
            return \u2603;
        }
        return -1;
    }

    protected void capYPosition() {
        this.yo = MathHelper.func_151237_a(this.yo, 0.0, this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public void centerScrollOn(int n) {
        this.yo = n * this.itemHeight + this.itemHeight / 2 - (this.y1 - this.y0) / 2;
        this.capYPosition();
    }

    public int getScroll() {
        return (int)this.yo;
    }

    public boolean isMouseInList(double d, double d2) {
        return d2 >= (double)this.y0 && d2 <= (double)this.y1 && d >= (double)this.x0 && d <= (double)this.x1;
    }

    public int getScrollBottom() {
        return (int)this.yo - this.height - this.headerHeight;
    }

    public void scroll(int n) {
        this.yo += (double)n;
        this.capYPosition();
        this.yDrag = -2;
    }

    @Override
    public void render(int n, int n2, float f) {
        if (!this.visible) {
            return;
        }
        this.renderBackground();
        int n3 = this.getScrollbarPosition();
        \u2603 = n3 + 6;
        this.capYPosition();
        Tessellator \u26032 = Tessellator.func_178181_a();
        BufferBuilder \u26033 = \u26032.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(AbstractGui.BACKGROUND_LOCATION);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        float \u26034 = 32.0f;
        \u26033.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        \u26033.func_225582_a_(this.x0, this.y1, 0.0).func_225583_a_((float)this.x0 / 32.0f, (float)(this.y1 + (int)this.yo) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        \u26033.func_225582_a_(this.x1, this.y1, 0.0).func_225583_a_((float)this.x1 / 32.0f, (float)(this.y1 + (int)this.yo) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        \u26033.func_225582_a_(this.x1, this.y0, 0.0).func_225583_a_((float)this.x1 / 32.0f, (float)(this.y0 + (int)this.yo) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        \u26033.func_225582_a_(this.x0, this.y0, 0.0).func_225583_a_((float)this.x0 / 32.0f, (float)(this.y0 + (int)this.yo) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        \u26032.func_78381_a();
        \u2603 = this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
        \u2603 = this.y0 + 4 - (int)this.yo;
        if (this.renderHeader) {
            this.renderHeader(\u2603, \u2603, \u26032);
        }
        this.renderList(\u2603, \u2603, n, n2, f);
        RenderSystem.disableDepthTest();
        this.renderHoleBackground(0, this.y0, 255, 255);
        this.renderHoleBackground(this.y1, this.height, 255, 255);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel(7425);
        RenderSystem.disableTexture();
        \u2603 = 4;
        \u26033.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        \u26033.func_225582_a_(this.x0, this.y0 + 4, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        \u26033.func_225582_a_(this.x1, this.y0 + 4, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        \u26033.func_225582_a_(this.x1, this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        \u26033.func_225582_a_(this.x0, this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        \u26032.func_78381_a();
        \u26033.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        \u26033.func_225582_a_(this.x0, this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        \u26033.func_225582_a_(this.x1, this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        \u26033.func_225582_a_(this.x1, this.y1 - 4, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        \u26033.func_225582_a_(this.x0, this.y1 - 4, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        \u26032.func_78381_a();
        \u2603 = this.getMaxScroll();
        if (\u2603 > 0) {
            \u2603 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
            \u2603 = (int)this.yo * (this.y1 - this.y0 - (\u2603 = MathHelper.func_76125_a(\u2603, 32, this.y1 - this.y0 - 8))) / \u2603 + this.y0;
            if (\u2603 < this.y0) {
                \u2603 = this.y0;
            }
            \u26033.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            \u26033.func_225582_a_(n3, this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            \u26033.func_225582_a_(\u2603, this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            \u26033.func_225582_a_(\u2603, this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            \u26033.func_225582_a_(n3, this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            \u26032.func_78381_a();
            \u26033.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            \u26033.func_225582_a_(n3, \u2603 + \u2603, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            \u26033.func_225582_a_(\u2603, \u2603 + \u2603, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            \u26033.func_225582_a_(\u2603, \u2603, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            \u26033.func_225582_a_(n3, \u2603, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            \u26032.func_78381_a();
            \u26033.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            \u26033.func_225582_a_(n3, \u2603 + \u2603 - 1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            \u26033.func_225582_a_(\u2603 - 1, \u2603 + \u2603 - 1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            \u26033.func_225582_a_(\u2603 - 1, \u2603, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            \u26033.func_225582_a_(n3, \u2603, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            \u26032.func_78381_a();
        }
        this.renderDecorations(n, n2);
        RenderSystem.enableTexture();
        RenderSystem.shadeModel(7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
    }

    protected void updateScrollingState(double d, double d2, int n) {
        this.scrolling = n == 0 && d >= (double)this.getScrollbarPosition() && d < (double)(this.getScrollbarPosition() + 6);
    }

    @Override
    public boolean mouseClicked(double d, double d2, int n) {
        this.updateScrollingState(d, d2, n);
        if (!this.isVisible() || !this.isMouseInList(d, d2)) {
            return false;
        }
        \u2603 = this.getItemAtPosition(d, d2);
        if (\u2603 == -1 && n == 0) {
            this.clickedHeader((int)(d - (double)(this.x0 + this.width / 2 - this.getRowWidth() / 2)), (int)(d2 - (double)this.y0) + (int)this.yo - 4);
            return true;
        }
        if (\u2603 != -1 && this.selectItem(\u2603, n, d, d2)) {
            if (this.children().size() > \u2603) {
                this.setFocused(this.children().get(\u2603));
            }
            this.setDragging(true);
            return true;
        }
        return this.scrolling;
    }

    @Override
    public boolean mouseReleased(double d, double d2, int n) {
        if (this.getFocused() != null) {
            this.getFocused().mouseReleased(d, d2, n);
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double d, double d2, int n, double d3, double d4) {
        if (super.mouseDragged(d, d2, n, d3, d4)) {
            return true;
        }
        if (!this.isVisible() || n != 0 || !this.scrolling) {
            return false;
        }
        if (d2 < (double)this.y0) {
            this.yo = 0.0;
        } else if (d2 > (double)this.y1) {
            this.yo = this.getMaxScroll();
        } else {
            \u2603 = this.getMaxScroll();
            if (\u2603 < 1.0) {
                \u2603 = 1.0;
            }
            int n2 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
            double \u26032 = \u2603 / (double)(this.y1 - this.y0 - (n2 = MathHelper.func_76125_a(n2, 32, this.y1 - this.y0 - 8)));
            if (\u26032 < 1.0) {
                \u26032 = 1.0;
            }
            this.yo += d4 * \u26032;
            this.capYPosition();
        }
        return true;
    }

    @Override
    public boolean mouseScrolled(double d, double d2, double d3) {
        if (!this.isVisible()) {
            return false;
        }
        this.yo -= d3 * (double)this.itemHeight / 2.0;
        return true;
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (!this.isVisible()) {
            return false;
        }
        if (super.keyPressed(n, n2, n3)) {
            return true;
        }
        if (n == 264) {
            this.moveSelection(1);
            return true;
        }
        if (n == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int n) {
    }

    @Override
    public boolean charTyped(char c, int n) {
        if (!this.isVisible()) {
            return false;
        }
        return super.charTyped(c, n);
    }

    @Override
    public boolean isMouseOver(double d, double d2) {
        return this.isMouseInList(d, d2);
    }

    public int getRowWidth() {
        return 220;
    }

    protected void renderList(int n, int n2, int n3, int n4, float f) {
        int n5 = this.getItemCount();
        Tessellator \u26032 = Tessellator.func_178181_a();
        BufferBuilder \u26033 = \u26032.func_178180_c();
        for (n6 = 0; n6 < n5; ++n6) {
            int n6;
            \u2603 = n2 + n6 * this.itemHeight + this.headerHeight;
            \u2603 = this.itemHeight - 4;
            if (\u2603 > this.y1 || \u2603 + \u2603 < this.y0) {
                this.updateItemPosition(n6, n, \u2603, f);
            }
            if (this.renderSelection && this.isSelectedItem(n6)) {
                \u2603 = this.x0 + this.width / 2 - this.getRowWidth() / 2;
                \u2603 = this.x0 + this.width / 2 + this.getRowWidth() / 2;
                RenderSystem.disableTexture();
                float f2 = this.isFocused() ? 1.0f : 0.5f;
                RenderSystem.color4f(f2, f2, f2, 1.0f);
                \u26033.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                \u26033.func_225582_a_(\u2603, \u2603 + \u2603 + 2, 0.0).func_181675_d();
                \u26033.func_225582_a_(\u2603, \u2603 + \u2603 + 2, 0.0).func_181675_d();
                \u26033.func_225582_a_(\u2603, \u2603 - 2, 0.0).func_181675_d();
                \u26033.func_225582_a_(\u2603, \u2603 - 2, 0.0).func_181675_d();
                \u26032.func_78381_a();
                RenderSystem.color4f(0.0f, 0.0f, 0.0f, 1.0f);
                \u26033.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                \u26033.func_225582_a_(\u2603 + 1, \u2603 + \u2603 + 1, 0.0).func_181675_d();
                \u26033.func_225582_a_(\u2603 - 1, \u2603 + \u2603 + 1, 0.0).func_181675_d();
                \u26033.func_225582_a_(\u2603 - 1, \u2603 - 1, 0.0).func_181675_d();
                \u26033.func_225582_a_(\u2603 + 1, \u2603 - 1, 0.0).func_181675_d();
                \u26032.func_78381_a();
                RenderSystem.enableTexture();
            }
            this.renderItem(n6, n, \u2603, \u2603, n3, n4, f);
        }
    }

    protected boolean isFocused() {
        return false;
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    protected void renderHoleBackground(int n, int n2, int n3, int n4) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(AbstractGui.BACKGROUND_LOCATION);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        float \u26033 = 32.0f;
        \u26032.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        \u26032.func_225582_a_(this.x0, n2, 0.0).func_225583_a_(0.0f, (float)n2 / 32.0f).func_225586_a_(64, 64, 64, n4).func_181675_d();
        \u26032.func_225582_a_(this.x0 + this.width, n2, 0.0).func_225583_a_((float)this.width / 32.0f, (float)n2 / 32.0f).func_225586_a_(64, 64, 64, n4).func_181675_d();
        \u26032.func_225582_a_(this.x0 + this.width, n, 0.0).func_225583_a_((float)this.width / 32.0f, (float)n / 32.0f).func_225586_a_(64, 64, 64, n3).func_181675_d();
        \u26032.func_225582_a_(this.x0, n, 0.0).func_225583_a_(0.0f, (float)n / 32.0f).func_225586_a_(64, 64, 64, n3).func_181675_d();
        tessellator.func_78381_a();
    }

    public void setLeftPos(int n) {
        this.x0 = n;
        this.x1 = n + this.width;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }
}

