/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.provider.BiomeProviderType;

public class CreateBuffetWorldScreen
extends Screen {
    private static final List<ResourceLocation> field_205310_a = Registry.field_212627_p.func_148742_b().stream().filter(resourceLocation -> Registry.field_212627_p.func_82594_a((ResourceLocation)resourceLocation).func_205481_b()).collect(Collectors.toList());
    private final CreateWorldScreen field_205314_f;
    private final CompoundNBT field_213017_c;
    private BiomeList field_205311_s;
    private int field_205312_t;
    private Button field_205313_u;

    public CreateBuffetWorldScreen(CreateWorldScreen createWorldScreen, CompoundNBT compoundNBT) {
        super(new TranslationTextComponent("createWorld.customize.buffet.title", new Object[0]));
        this.field_205314_f = createWorldScreen;
        this.field_213017_c = compoundNBT;
    }

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.addButton(new Button((this.width - 200) / 2, 40, 200, 20, I18n.func_135052_a("createWorld.customize.buffet.generatortype", new Object[0]) + " " + I18n.func_135052_a(Util.func_200697_a("generator", field_205310_a.get(this.field_205312_t)), new Object[0]), button -> {
            ++this.field_205312_t;
            if (this.field_205312_t >= field_205310_a.size()) {
                this.field_205312_t = 0;
            }
            button.setMessage(I18n.func_135052_a("createWorld.customize.buffet.generatortype", new Object[0]) + " " + I18n.func_135052_a(Util.func_200697_a("generator", field_205310_a.get(this.field_205312_t)), new Object[0]));
        }));
        this.field_205311_s = new BiomeList();
        this.children.add(this.field_205311_s);
        this.field_205313_u = this.addButton(new Button(this.width / 2 - 155, this.height - 28, 150, 20, I18n.func_135052_a("gui.done", new Object[0]), button -> {
            this.field_205314_f.field_146334_a = this.func_210507_j();
            this.minecraft.func_147108_a(this.field_205314_f);
        }));
        this.addButton(new Button(this.width / 2 + 5, this.height - 28, 150, 20, I18n.func_135052_a("gui.cancel", new Object[0]), button -> this.minecraft.func_147108_a(this.field_205314_f)));
        this.func_210506_a();
        this.func_205306_h();
    }

    private void func_210506_a() {
        int n;
        Object object;
        if (this.field_213017_c.func_150297_b("chunk_generator", 10) && this.field_213017_c.func_74775_l("chunk_generator").func_150297_b("type", 8)) {
            object = new ResourceLocation(this.field_213017_c.func_74775_l("chunk_generator").func_74779_i("type"));
            for (n = 0; n < field_205310_a.size(); ++n) {
                if (!field_205310_a.get(n).equals(object)) continue;
                this.field_205312_t = n;
                break;
            }
        }
        if (this.field_213017_c.func_150297_b("biome_source", 10) && this.field_213017_c.func_74775_l("biome_source").func_150297_b("biomes", 9)) {
            object = this.field_213017_c.func_74775_l("biome_source").func_150295_c("biomes", 8);
            for (n = 0; n < ((ListNBT)object).size(); ++n) {
                ResourceLocation resourceLocation = new ResourceLocation(((ListNBT)object).func_150307_f(n));
                this.field_205311_s.setSelected((BiomeList.BiomeEntry)this.field_205311_s.children().stream().filter(biomeEntry -> Objects.equals(((BiomeList.BiomeEntry)biomeEntry).field_214394_b, resourceLocation)).findFirst().orElse(null));
            }
        }
        this.field_213017_c.func_82580_o("chunk_generator");
        this.field_213017_c.func_82580_o("biome_source");
    }

    private CompoundNBT func_210507_j() {
        CompoundNBT compoundNBT = new CompoundNBT();
        \u2603 = new CompoundNBT();
        \u2603.func_74778_a("type", Registry.field_212625_n.func_177774_c(BiomeProviderType.field_205461_c).toString());
        \u2603 = new CompoundNBT();
        ListNBT \u26032 = new ListNBT();
        \u26032.add(StringNBT.func_229705_a_(((BiomeList.BiomeEntry)this.field_205311_s.getSelected()).field_214394_b.toString()));
        \u2603.func_218657_a("biomes", \u26032);
        \u2603.func_218657_a("options", \u2603);
        \u2603 = new CompoundNBT();
        \u2603 = new CompoundNBT();
        \u2603.func_74778_a("type", field_205310_a.get(this.field_205312_t).toString());
        \u2603.func_74778_a("default_block", "minecraft:stone");
        \u2603.func_74778_a("default_fluid", "minecraft:water");
        \u2603.func_218657_a("options", \u2603);
        compoundNBT.func_218657_a("biome_source", \u2603);
        compoundNBT.func_218657_a("chunk_generator", \u2603);
        return compoundNBT;
    }

    public void func_205306_h() {
        this.field_205313_u.active = this.field_205311_s.getSelected() != null;
    }

    @Override
    public void render(int n, int n2, float f) {
        this.renderDirtBackground(0);
        this.field_205311_s.render(n, n2, f);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 8, 0xFFFFFF);
        this.drawCenteredString(this.font, I18n.func_135052_a("createWorld.customize.buffet.generator", new Object[0]), this.width / 2, 30, 0xA0A0A0);
        this.drawCenteredString(this.font, I18n.func_135052_a("createWorld.customize.buffet.biome", new Object[0]), this.width / 2, 68, 0xA0A0A0);
        super.render(n, n2, f);
    }

    class BiomeList
    extends ExtendedList<BiomeEntry> {
        private BiomeList() {
            super(CreateBuffetWorldScreen.this.minecraft, CreateBuffetWorldScreen.this.width, CreateBuffetWorldScreen.this.height, 80, CreateBuffetWorldScreen.this.height - 37, 16);
            Registry.field_212624_m.func_148742_b().stream().sorted(Comparator.comparing(resourceLocation -> Registry.field_212624_m.func_82594_a((ResourceLocation)resourceLocation).func_205403_k().getString())).forEach(resourceLocation -> this.addEntry(new BiomeEntry((ResourceLocation)resourceLocation)));
        }

        @Override
        protected boolean isFocused() {
            return CreateBuffetWorldScreen.this.getFocused() == this;
        }

        @Override
        public void setSelected(@Nullable BiomeEntry biomeEntry) {
            super.setSelected(biomeEntry);
            if (biomeEntry != null) {
                NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.select", Registry.field_212624_m.func_82594_a(biomeEntry.field_214394_b).func_205403_k().getString()).getString());
            }
        }

        @Override
        protected void moveSelection(int n) {
            super.moveSelection(n);
            CreateBuffetWorldScreen.this.func_205306_h();
        }

        @Override
        public /* synthetic */ void setSelected(@Nullable AbstractList.AbstractListEntry abstractListEntry) {
            this.setSelected((BiomeEntry)abstractListEntry);
        }

        class BiomeEntry
        extends ExtendedList.AbstractListEntry<BiomeEntry> {
            private final ResourceLocation field_214394_b;

            public BiomeEntry(ResourceLocation resourceLocation) {
                this.field_214394_b = resourceLocation;
            }

            @Override
            public void render(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
                BiomeList.this.drawString(CreateBuffetWorldScreen.this.font, Registry.field_212624_m.func_82594_a(this.field_214394_b).func_205403_k().getString(), n3 + 5, n2 + 2, 0xFFFFFF);
            }

            @Override
            public boolean mouseClicked(double d, double d2, int n) {
                if (n == 0) {
                    BiomeList.this.setSelected(this);
                    CreateBuffetWorldScreen.this.func_205306_h();
                    return true;
                }
                return false;
            }
        }
    }
}

