/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.SettingsScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.OptionButton;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.settings.AbstractOption;
import net.minecraft.util.text.TranslationTextComponent;

public class LanguageScreen
extends SettingsScreen {
    private List field_146450_f;
    private final LanguageManager field_146454_h;
    private OptionButton field_211832_i;
    private Button field_146452_r;

    public LanguageScreen(Screen screen, GameSettings gameSettings, LanguageManager languageManager) {
        super(screen, gameSettings, new TranslationTextComponent("options.language", new Object[0]));
        this.field_146454_h = languageManager;
    }

    @Override
    protected void init() {
        this.field_146450_f = new List(this.minecraft);
        this.children.add(this.field_146450_f);
        this.field_211832_i = this.addButton(new OptionButton(this.width / 2 - 155, this.height - 38, 150, 20, AbstractOption.field_216684_H, AbstractOption.field_216684_H.func_216743_c(this.field_228183_b_), button -> {
            AbstractOption.field_216684_H.func_216740_a(this.field_228183_b_);
            this.field_228183_b_.func_74303_b();
            button.setMessage(AbstractOption.field_216684_H.func_216743_c(this.field_228183_b_));
            this.minecraft.func_213226_a();
        }));
        this.field_146452_r = this.addButton(new Button(this.width / 2 - 155 + 160, this.height - 38, 150, 20, I18n.func_135052_a("gui.done", new Object[0]), button -> {
            List.LanguageEntry languageEntry = (List.LanguageEntry)this.field_146450_f.getSelected();
            if (languageEntry != null && !languageEntry.field_214398_b.getCode().equals(this.field_146454_h.func_135041_c().getCode())) {
                this.field_146454_h.func_135045_a(languageEntry.field_214398_b);
                this.field_228183_b_.field_74363_ab = languageEntry.field_214398_b.getCode();
                this.minecraft.func_213237_g();
                this.font.func_78275_b(this.field_146454_h.func_135044_b());
                this.field_146452_r.setMessage(I18n.func_135052_a("gui.done", new Object[0]));
                this.field_211832_i.setMessage(AbstractOption.field_216684_H.func_216743_c(this.field_228183_b_));
                this.field_228183_b_.func_74303_b();
            }
            this.minecraft.func_147108_a(this.field_228182_a_);
        }));
        super.init();
    }

    @Override
    public void render(int n, int n2, float f) {
        this.field_146450_f.render(n, n2, f);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 16, 0xFFFFFF);
        this.drawCenteredString(this.font, "(" + I18n.func_135052_a("options.languageWarning", new Object[0]) + ")", this.width / 2, this.height - 56, 0x808080);
        super.render(n, n2, f);
    }

    class List
    extends ExtendedList<LanguageEntry> {
        public List(Minecraft minecraft) {
            super(minecraft, LanguageScreen.this.width, LanguageScreen.this.height, 32, LanguageScreen.this.height - 65 + 4, 18);
            for (Language language : LanguageScreen.this.field_146454_h.func_135040_d()) {
                LanguageEntry languageEntry = new LanguageEntry(language);
                this.addEntry(languageEntry);
                if (!LanguageScreen.this.field_146454_h.func_135041_c().getCode().equals(language.getCode())) continue;
                this.setSelected(languageEntry);
            }
            if (this.getSelected() != null) {
                this.centerScrollOn(this.getSelected());
            }
        }

        @Override
        protected int getScrollbarPosition() {
            return super.getScrollbarPosition() + 20;
        }

        @Override
        public int getRowWidth() {
            return super.getRowWidth() + 50;
        }

        @Override
        public void setSelected(@Nullable LanguageEntry languageEntry) {
            super.setSelected(languageEntry);
            if (languageEntry != null) {
                NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.select", languageEntry.field_214398_b).getString());
            }
        }

        @Override
        protected void renderBackground() {
            LanguageScreen.this.renderBackground();
        }

        @Override
        protected boolean isFocused() {
            return LanguageScreen.this.getFocused() == this;
        }

        @Override
        public /* synthetic */ void setSelected(@Nullable AbstractList.AbstractListEntry abstractListEntry) {
            this.setSelected((LanguageEntry)abstractListEntry);
        }

        public class LanguageEntry
        extends ExtendedList.AbstractListEntry<LanguageEntry> {
            private final Language field_214398_b;

            public LanguageEntry(Language language) {
                this.field_214398_b = language;
            }

            @Override
            public void render(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
                LanguageScreen.this.font.func_78275_b(true);
                List.this.drawCenteredString(LanguageScreen.this.font, this.field_214398_b.toString(), List.this.width / 2, n2 + 1, 0xFFFFFF);
                LanguageScreen.this.font.func_78275_b(LanguageScreen.this.field_146454_h.func_135041_c().func_135035_b());
            }

            @Override
            public boolean mouseClicked(double d, double d2, int n) {
                if (n == 0) {
                    this.func_214395_a();
                    return true;
                }
                return false;
            }

            private void func_214395_a() {
                List.this.setSelected(this);
            }
        }
    }
}

