/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.util.concurrent.Runnables;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.gui.AccessibilityScreen;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.LanguageScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.MultiplayerWarningScreen;
import net.minecraft.client.gui.screen.OptionsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WinGameScreen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.RenderSkybox;
import net.minecraft.client.renderer.RenderSkyboxCube;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.realms.RealmsBridge;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldInfo;

public class MainMenuScreen
extends Screen {
    public static final RenderSkyboxCube field_213098_a = new RenderSkyboxCube(new ResourceLocation("textures/gui/title/background/panorama"));
    private static final ResourceLocation field_213099_c = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private static final ResourceLocation field_213100_d = new ResourceLocation("textures/gui/accessibility.png");
    private final boolean field_213101_e;
    @Nullable
    private String field_73975_c;
    private Button field_73973_d;
    private static final ResourceLocation field_110352_y = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation field_194400_H = new ResourceLocation("textures/gui/title/edition.png");
    private boolean field_183502_L;
    private Screen field_183503_M;
    private int field_193978_M;
    private int field_193979_N;
    private final RenderSkybox field_209101_K = new RenderSkybox(field_213098_a);
    private final boolean field_213102_y;
    private long field_213103_z;

    public MainMenuScreen() {
        this(false);
    }

    public MainMenuScreen(boolean bl) {
        super(new TranslationTextComponent("narrator.screen.title", new Object[0]));
        this.field_213102_y = bl;
        this.field_213101_e = (double)new Random().nextFloat() < 1.0E-4;
    }

    private boolean func_183501_a() {
        return this.minecraft.field_71474_y.field_183509_X && this.field_183503_M != null;
    }

    @Override
    public void tick() {
        if (this.func_183501_a()) {
            this.field_183503_M.tick();
        }
    }

    public static CompletableFuture<Void> func_213097_a(TextureManager textureManager, Executor executor) {
        return CompletableFuture.allOf(textureManager.func_215268_a(field_110352_y, executor), textureManager.func_215268_a(field_194400_H, executor), textureManager.func_215268_a(field_213099_c, executor), field_213098_a.func_217617_a(textureManager, executor));
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    protected void init() {
        if (this.field_73975_c == null) {
            this.field_73975_c = this.minecraft.func_213269_at().func_215276_a();
        }
        this.field_193978_M = this.font.func_78256_a("Copyright Mojang AB. Do not distribute!");
        this.field_193979_N = this.width - this.field_193978_M - 2;
        int n = 24;
        \u2603 = this.height / 4 + 48;
        if (this.minecraft.func_71355_q()) {
            this.func_73972_b(\u2603, 24);
        } else {
            this.func_73969_a(\u2603, 24);
        }
        this.addButton(new ImageButton(this.width / 2 - 124, \u2603 + 72 + 12, 20, 20, 0, 106, 20, Button.WIDGETS_LOCATION, 256, 256, button -> this.minecraft.func_147108_a(new LanguageScreen((Screen)this, this.minecraft.field_71474_y, this.minecraft.func_135016_M())), I18n.func_135052_a("narrator.button.language", new Object[0])));
        this.addButton(new Button(this.width / 2 - 100, \u2603 + 72 + 12, 98, 20, I18n.func_135052_a("menu.options", new Object[0]), button -> this.minecraft.func_147108_a(new OptionsScreen(this, this.minecraft.field_71474_y))));
        this.addButton(new Button(this.width / 2 + 2, \u2603 + 72 + 12, 98, 20, I18n.func_135052_a("menu.quit", new Object[0]), button -> this.minecraft.func_71400_g()));
        this.addButton(new ImageButton(this.width / 2 + 104, \u2603 + 72 + 12, 20, 20, 0, 0, 20, field_213100_d, 32, 64, button -> this.minecraft.func_147108_a(new AccessibilityScreen(this, this.minecraft.field_71474_y)), I18n.func_135052_a("narrator.button.accessibility", new Object[0])));
        this.minecraft.func_181537_a(false);
        if (this.minecraft.field_71474_y.field_183509_X && !this.field_183502_L) {
            RealmsBridge realmsBridge = new RealmsBridge();
            this.field_183503_M = realmsBridge.getNotificationScreen(this);
            this.field_183502_L = true;
        }
        if (this.func_183501_a()) {
            this.field_183503_M.init(this.minecraft, this.width, this.height);
        }
    }

    private void func_73969_a(int n, int n2) {
        this.addButton(new Button(this.width / 2 - 100, n, 200, 20, I18n.func_135052_a("menu.singleplayer", new Object[0]), button -> this.minecraft.func_147108_a(new WorldSelectionScreen(this))));
        this.addButton(new Button(this.width / 2 - 100, n + n2 * 1, 200, 20, I18n.func_135052_a("menu.multiplayer", new Object[0]), button -> {
            if (this.minecraft.field_71474_y.field_230152_Z_) {
                this.minecraft.func_147108_a(new MultiplayerScreen(this));
            } else {
                this.minecraft.func_147108_a(new MultiplayerWarningScreen(this));
            }
        }));
        this.addButton(new Button(this.width / 2 - 100, n + n2 * 2, 200, 20, I18n.func_135052_a("menu.online", new Object[0]), button -> this.func_140005_i()));
    }

    private void func_73972_b(int n, int n2) {
        this.addButton(new Button(this.width / 2 - 100, n, 200, 20, I18n.func_135052_a("menu.playdemo", new Object[0]), button -> this.minecraft.func_71371_a("Demo_World", "Demo_World", MinecraftServer.field_213219_c)));
        this.field_73973_d = this.addButton(new Button(this.width / 2 - 100, n + n2 * 1, 200, 20, I18n.func_135052_a("menu.resetdemo", new Object[0]), button -> {
            SaveFormat saveFormat = this.minecraft.func_71359_d();
            WorldInfo \u26032 = saveFormat.func_75803_c("Demo_World");
            if (\u26032 != null) {
                this.minecraft.func_147108_a(new ConfirmScreen(this::func_213087_a, new TranslationTextComponent("selectWorld.deleteQuestion", new Object[0]), new TranslationTextComponent("selectWorld.deleteWarning", \u26032.func_76065_j()), I18n.func_135052_a("selectWorld.deleteButton", new Object[0]), I18n.func_135052_a("gui.cancel", new Object[0])));
            }
        }));
        SaveFormat saveFormat = this.minecraft.func_71359_d();
        WorldInfo \u26032 = saveFormat.func_75803_c("Demo_World");
        if (\u26032 == null) {
            this.field_73973_d.active = false;
        }
    }

    private void func_140005_i() {
        RealmsBridge realmsBridge = new RealmsBridge();
        realmsBridge.switchToRealms(this);
    }

    @Override
    public void render(int n3, int n2, float f) {
        int n3;
        if (this.field_213103_z == 0L && this.field_213102_y) {
            this.field_213103_z = Util.func_211177_b();
        }
        \u2603 = this.field_213102_y ? (float)(Util.func_211177_b() - this.field_213103_z) / 1000.0f : 1.0f;
        MainMenuScreen.fill(0, 0, this.width, this.height, -1);
        this.field_209101_K.func_217623_a(f, MathHelper.func_76131_a(\u2603, 0.0f, 1.0f));
        int n4 = 274;
        \u2603 = this.width / 2 - 137;
        \u2603 = 30;
        this.minecraft.func_110434_K().func_110577_a(field_213099_c);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, this.field_213102_y ? (float)MathHelper.func_76123_f(MathHelper.func_76131_a(\u2603, 0.0f, 1.0f)) : 1.0f);
        MainMenuScreen.blit(0, 0, this.width, this.height, 0.0f, 0.0f, 16, 128, 16, 128);
        float \u26032 = this.field_213102_y ? MathHelper.func_76131_a(\u2603 - 1.0f, 0.0f, 1.0f) : 1.0f;
        \u2603 = MathHelper.func_76123_f(\u26032 * 255.0f) << 24;
        if ((\u2603 & 0xFC000000) == 0) {
            return;
        }
        this.minecraft.func_110434_K().func_110577_a(field_110352_y);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, \u26032);
        if (this.field_213101_e) {
            this.blit(\u2603 + 0, 30, 0, 0, 99, 44);
            this.blit(\u2603 + 99, 30, 129, 0, 27, 44);
            this.blit(\u2603 + 99 + 26, 30, 126, 0, 3, 44);
            this.blit(\u2603 + 99 + 26 + 3, 30, 99, 0, 26, 44);
            this.blit(\u2603 + 155, 30, 0, 45, 155, 44);
        } else {
            this.blit(\u2603 + 0, 30, 0, 0, 155, 44);
            this.blit(\u2603 + 155, 30, 0, 45, 155, 44);
        }
        this.minecraft.func_110434_K().func_110577_a(field_194400_H);
        MainMenuScreen.blit(\u2603 + 88, 67, 0.0f, 0.0f, 98, 14, 128, 16);
        if (this.field_73975_c != null) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef(this.width / 2 + 90, 70.0f, 0.0f);
            RenderSystem.rotatef(-20.0f, 0.0f, 0.0f, 1.0f);
            float f2 = 1.8f - MathHelper.func_76135_e(MathHelper.func_76126_a((float)(Util.func_211177_b() % 1000L) / 1000.0f * ((float)Math.PI * 2)) * 0.1f);
            f2 = f2 * 100.0f / (float)(this.font.func_78256_a(this.field_73975_c) + 32);
            RenderSystem.scalef(f2, f2, f2);
            this.drawCenteredString(this.font, this.field_73975_c, 0, -8, 0xFFFF00 | \u2603);
            RenderSystem.popMatrix();
        }
        String string = "Minecraft " + SharedConstants.func_215069_a().getName();
        string = this.minecraft.func_71355_q() ? string + " Demo" : string + ("release".equalsIgnoreCase(this.minecraft.func_184123_d()) ? "" : "/" + this.minecraft.func_184123_d());
        if (this.minecraft.func_230151_c_()) {
            string = string + I18n.func_135052_a("menu.modded", new Object[0]);
        }
        this.drawString(this.font, string, 2, this.height - 10, 0xFFFFFF | \u2603);
        this.drawString(this.font, "Copyright Mojang AB. Do not distribute!", this.field_193979_N, this.height - 10, 0xFFFFFF | \u2603);
        if (n3 > this.field_193979_N && n3 < this.field_193979_N + this.field_193978_M && n2 > this.height - 10 && n2 < this.height) {
            MainMenuScreen.fill(this.field_193979_N, this.height - 1, this.field_193979_N + this.field_193978_M, this.height, 0xFFFFFF | \u2603);
        }
        for (Widget widget : this.buttons) {
            widget.setAlpha(\u26032);
        }
        super.render(n3, n2, f);
        if (this.func_183501_a() && \u26032 >= 1.0f) {
            this.field_183503_M.render(n3, n2, f);
        }
    }

    @Override
    public boolean mouseClicked(double d, double d2, int n) {
        if (super.mouseClicked(d, d2, n)) {
            return true;
        }
        if (this.func_183501_a() && this.field_183503_M.mouseClicked(d, d2, n)) {
            return true;
        }
        if (d > (double)this.field_193979_N && d < (double)(this.field_193979_N + this.field_193978_M) && d2 > (double)(this.height - 10) && d2 < (double)this.height) {
            this.minecraft.func_147108_a(new WinGameScreen(false, Runnables.doNothing()));
        }
        return false;
    }

    @Override
    public void removed() {
        if (this.field_183503_M != null) {
            this.field_183503_M.removed();
        }
    }

    private void func_213087_a(boolean bl) {
        if (bl) {
            SaveFormat saveFormat = this.minecraft.func_71359_d();
            saveFormat.func_75802_e("Demo_World");
        }
        this.minecraft.func_147108_a(this);
    }
}

