/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.network.LanServerInfo;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerSelectionList
extends ExtendedList<Entry> {
    private static final Logger field_214357_a = LogManager.getLogger();
    private static final ThreadPoolExecutor field_214358_b = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_214357_a)).build());
    private static final ResourceLocation field_214359_c = new ResourceLocation("textures/misc/unknown_server.png");
    private static final ResourceLocation field_214360_d = new ResourceLocation("textures/gui/server_selection.png");
    private final MultiplayerScreen field_148200_k;
    private final List<NormalEntry> field_148198_l = Lists.newArrayList();
    private final Entry field_148196_n = new LanScanEntry();
    private final List<LanDetectedEntry> field_148199_m = Lists.newArrayList();

    public ServerSelectionList(MultiplayerScreen multiplayerScreen, Minecraft minecraft, int n, int n2, int n3, int n4, int n5) {
        super(minecraft, n, n2, n3, n4, n5);
        this.field_148200_k = multiplayerScreen;
    }

    private void func_195094_h() {
        this.clearEntries();
        this.field_148198_l.forEach(this::addEntry);
        this.addEntry(this.field_148196_n);
        this.field_148199_m.forEach(this::addEntry);
    }

    @Override
    public void setSelected(Entry entry) {
        super.setSelected(entry);
        if (this.getSelected() instanceof NormalEntry) {
            NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.select", ((NormalEntry)((NormalEntry)this.getSelected())).field_148301_e.field_78847_a).getString());
        }
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        Entry entry = (Entry)this.getSelected();
        return entry != null && entry.keyPressed(n, n2, n3) || super.keyPressed(n, n2, n3);
    }

    @Override
    protected void moveSelection(int n) {
        \u2603 = this.children().indexOf(this.getSelected());
        n2 = MathHelper.func_76125_a(\u2603 + n, 0, this.getItemCount() - 1);
        Entry \u26032 = (Entry)this.children().get(n2);
        if (\u26032 instanceof LanScanEntry) {
            int n2 = MathHelper.func_76125_a(n2 + (n > 0 ? 1 : -1), 0, this.getItemCount() - 1);
            \u26032 = (Entry)this.children().get(n2);
        }
        super.setSelected(\u26032);
        this.ensureVisible(\u26032);
        this.field_148200_k.func_214295_b();
    }

    public void func_148195_a(ServerList serverList) {
        this.field_148198_l.clear();
        for (int i = 0; i < serverList.func_78856_c(); ++i) {
            this.field_148198_l.add(new NormalEntry(this.field_148200_k, serverList.func_78850_a(i)));
        }
        this.func_195094_h();
    }

    public void func_148194_a(List<LanServerInfo> list) {
        this.field_148199_m.clear();
        for (LanServerInfo lanServerInfo : list) {
            this.field_148199_m.add(new LanDetectedEntry(this.field_148200_k, lanServerInfo));
        }
        this.func_195094_h();
    }

    @Override
    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 30;
    }

    @Override
    public int getRowWidth() {
        return super.getRowWidth() + 85;
    }

    @Override
    protected boolean isFocused() {
        return this.field_148200_k.getFocused() == this;
    }

    @Override
    public /* synthetic */ void setSelected(AbstractList.AbstractListEntry abstractListEntry) {
        this.setSelected((Entry)abstractListEntry);
    }

    public class NormalEntry
    extends Entry {
        private final MultiplayerScreen field_148303_c;
        private final Minecraft field_148300_d;
        private final ServerData field_148301_e;
        private final ResourceLocation field_148306_i;
        private String field_148299_g;
        private DynamicTexture field_148305_h;
        private long field_148298_f;

        protected NormalEntry(MultiplayerScreen multiplayerScreen, ServerData serverData) {
            this.field_148303_c = multiplayerScreen;
            this.field_148301_e = serverData;
            this.field_148300_d = Minecraft.func_71410_x();
            this.field_148306_i = new ResourceLocation("servers/" + Hashing.sha1().hashUnencodedChars((CharSequence)serverData.field_78845_b) + "/icon");
            this.field_148305_h = (DynamicTexture)this.field_148300_d.func_110434_K().func_229267_b_(this.field_148306_i);
        }

        @Override
        public void render(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            String \u26037;
            boolean bl2;
            if (!this.field_148301_e.field_78841_f) {
                this.field_148301_e.field_78841_f = true;
                this.field_148301_e.field_78844_e = -2L;
                this.field_148301_e.field_78843_d = "";
                this.field_148301_e.field_78846_c = "";
                field_214358_b.submit(() -> {
                    try {
                        this.field_148303_c.func_146789_i().func_147224_a(this.field_148301_e);
                    }
                    catch (UnknownHostException unknownHostException) {
                        this.field_148301_e.field_78844_e = -1L;
                        this.field_148301_e.field_78843_d = (Object)((Object)TextFormatting.DARK_RED) + I18n.func_135052_a("multiplayer.status.cannot_resolve", new Object[0]);
                    }
                    catch (Exception exception) {
                        this.field_148301_e.field_78844_e = -1L;
                        this.field_148301_e.field_78843_d = (Object)((Object)TextFormatting.DARK_RED) + I18n.func_135052_a("multiplayer.status.cannot_connect", new Object[0]);
                    }
                });
            }
            boolean bl3 = this.field_148301_e.field_82821_f > SharedConstants.func_215069_a().getProtocolVersion();
            \u2603 = this.field_148301_e.field_82821_f < SharedConstants.func_215069_a().getProtocolVersion();
            bl2 = bl3 || \u2603;
            this.field_148300_d.field_71466_p.func_211126_b(this.field_148301_e.field_78847_a, n3 + 32 + 3, n2 + 1, 0xFFFFFF);
            List<String> \u26032 = this.field_148300_d.field_71466_p.func_78271_c(this.field_148301_e.field_78843_d, n4 - 32 - 2);
            for (int i = 0; i < Math.min(\u26032.size(), 2); ++i) {
                this.field_148300_d.field_71466_p.func_211126_b(\u26032.get(i), n3 + 32 + 3, n2 + 12 + this.field_148300_d.field_71466_p.field_78288_b * i, 0x808080);
            }
            String \u26033 = bl2 ? (Object)((Object)TextFormatting.DARK_RED) + this.field_148301_e.field_82822_g : this.field_148301_e.field_78846_c;
            int \u26034 = this.field_148300_d.field_71466_p.func_78256_a(\u26033);
            this.field_148300_d.field_71466_p.func_211126_b(\u26033, n3 + n4 - \u26034 - 15 - 2, n2 + 1, 0x808080);
            int \u26035 = 0;
            String \u26036 = null;
            if (bl2) {
                int n8 = 5;
                \u26037 = I18n.func_135052_a(bl3 ? "multiplayer.status.client_out_of_date" : "multiplayer.status.server_out_of_date", new Object[0]);
                \u26036 = this.field_148301_e.field_147412_i;
            } else if (this.field_148301_e.field_78841_f && this.field_148301_e.field_78844_e != -2L) {
                n8 = this.field_148301_e.field_78844_e < 0L ? 5 : (this.field_148301_e.field_78844_e < 150L ? 0 : (this.field_148301_e.field_78844_e < 300L ? 1 : (this.field_148301_e.field_78844_e < 600L ? 2 : (this.field_148301_e.field_78844_e < 1000L ? 3 : 4))));
                if (this.field_148301_e.field_78844_e < 0L) {
                    \u26037 = I18n.func_135052_a("multiplayer.status.no_connection", new Object[0]);
                } else {
                    \u26037 = this.field_148301_e.field_78844_e + "ms";
                    \u26036 = this.field_148301_e.field_147412_i;
                }
            } else {
                \u26035 = 1;
                n8 = (int)(Util.func_211177_b() / 100L + (long)(n * 2) & 7L);
                if (n8 > 4) {
                    n8 = 8 - n8;
                }
                \u26037 = I18n.func_135052_a("multiplayer.status.pinging", new Object[0]);
            }
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.field_148300_d.func_110434_K().func_110577_a(AbstractGui.GUI_ICONS_LOCATION);
            AbstractGui.blit(n3 + n4 - 15, n2, \u26035 * 10, 176 + n8 * 8, 10, 8, 256, 256);
            if (this.field_148301_e.func_147409_e() != null && !this.field_148301_e.func_147409_e().equals(this.field_148299_g)) {
                this.field_148299_g = this.field_148301_e.func_147409_e();
                this.func_148297_b();
                this.field_148303_c.func_146795_p().func_78855_b();
            }
            if (this.field_148305_h != null) {
                this.func_178012_a(n3, n2, this.field_148306_i);
            } else {
                this.func_178012_a(n3, n2, field_214359_c);
            }
            \u2603 = n6 - n3;
            \u2603 = n7 - n2;
            if (\u2603 >= n4 - 15 && \u2603 <= n4 - 5 && \u2603 >= 0 && \u2603 <= 8) {
                this.field_148303_c.func_146793_a(\u26037);
            } else if (\u2603 >= n4 - \u26034 - 15 - 2 && \u2603 <= n4 - 15 - 2 && \u2603 >= 0 && \u2603 <= 8) {
                this.field_148303_c.func_146793_a(\u26036);
            }
            if (this.field_148300_d.field_71474_y.field_85185_A || bl) {
                this.field_148300_d.func_110434_K().func_110577_a(field_214360_d);
                AbstractGui.fill(n3, n2, n3 + 32, n2 + 32, -1601138544);
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                \u2603 = n6 - n3;
                \u2603 = n7 - n2;
                if (this.func_178013_b()) {
                    if (\u2603 < 32 && \u2603 > 16) {
                        AbstractGui.blit(n3, n2, 0.0f, 32.0f, 32, 32, 256, 256);
                    } else {
                        AbstractGui.blit(n3, n2, 0.0f, 0.0f, 32, 32, 256, 256);
                    }
                }
                if (n > 0) {
                    if (\u2603 < 16 && \u2603 < 16) {
                        AbstractGui.blit(n3, n2, 96.0f, 32.0f, 32, 32, 256, 256);
                    } else {
                        AbstractGui.blit(n3, n2, 96.0f, 0.0f, 32, 32, 256, 256);
                    }
                }
                if (n < this.field_148303_c.func_146795_p().func_78856_c() - 1) {
                    if (\u2603 < 16 && \u2603 > 16) {
                        AbstractGui.blit(n3, n2, 64.0f, 32.0f, 32, 32, 256, 256);
                    } else {
                        AbstractGui.blit(n3, n2, 64.0f, 0.0f, 32, 32, 256, 256);
                    }
                }
            }
        }

        protected void func_178012_a(int n, int n2, ResourceLocation resourceLocation) {
            this.field_148300_d.func_110434_K().func_110577_a(resourceLocation);
            RenderSystem.enableBlend();
            AbstractGui.blit(n, n2, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
        }

        private boolean func_178013_b() {
            return true;
        }

        private void func_148297_b() {
            String string = this.field_148301_e.func_147409_e();
            if (string == null) {
                this.field_148300_d.func_110434_K().func_147645_c(this.field_148306_i);
                if (this.field_148305_h != null && this.field_148305_h.func_195414_e() != null) {
                    this.field_148305_h.func_195414_e().close();
                }
                this.field_148305_h = null;
            } else {
                try {
                    NativeImage nativeImage = NativeImage.func_216511_b(string);
                    Validate.validState((nativeImage.func_195702_a() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState((nativeImage.func_195714_b() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    if (this.field_148305_h == null) {
                        this.field_148305_h = new DynamicTexture(nativeImage);
                    } else {
                        this.field_148305_h.func_195415_a(nativeImage);
                        this.field_148305_h.func_110564_a();
                    }
                    this.field_148300_d.func_110434_K().func_229263_a_(this.field_148306_i, this.field_148305_h);
                }
                catch (Throwable throwable) {
                    field_214357_a.error("Invalid icon for server {} ({})", (Object)this.field_148301_e.field_78847_a, (Object)this.field_148301_e.field_78845_b, (Object)throwable);
                    this.field_148301_e.func_147407_a(null);
                }
            }
        }

        @Override
        public boolean keyPressed(int n, int n2, int n3) {
            if (Screen.hasShiftDown()) {
                ServerSelectionList serverSelectionList = this.field_148303_c.field_146803_h;
                int \u26032 = serverSelectionList.children().indexOf(this);
                if (n == 264 && \u26032 < this.field_148303_c.func_146795_p().func_78856_c() - 1 || n == 265 && \u26032 > 0) {
                    this.func_228196_a_(\u26032, n == 264 ? \u26032 + 1 : \u26032 - 1);
                    return true;
                }
            }
            return super.keyPressed(n, n2, n3);
        }

        private void func_228196_a_(int n, int n2) {
            this.field_148303_c.func_146795_p().func_78857_a(n, n2);
            this.field_148303_c.field_146803_h.func_148195_a(this.field_148303_c.func_146795_p());
            Entry entry = (Entry)this.field_148303_c.field_146803_h.children().get(n2);
            this.field_148303_c.field_146803_h.setSelected(entry);
            ServerSelectionList.this.ensureVisible(entry);
        }

        @Override
        public boolean mouseClicked(double d, double d2, int n) {
            double d3 = d - (double)ServerSelectionList.this.getRowLeft();
            \u2603 = d2 - (double)ServerSelectionList.this.getRowTop(ServerSelectionList.this.children().indexOf(this));
            if (d3 <= 32.0) {
                if (d3 < 32.0 && d3 > 16.0 && this.func_178013_b()) {
                    this.field_148303_c.func_214287_a(this);
                    this.field_148303_c.func_146796_h();
                    return true;
                }
                int n2 = this.field_148303_c.field_146803_h.children().indexOf(this);
                if (d3 < 16.0 && \u2603 < 16.0 && n2 > 0) {
                    this.func_228196_a_(n2, n2 - 1);
                    return true;
                }
                if (d3 < 16.0 && \u2603 > 16.0 && n2 < this.field_148303_c.func_146795_p().func_78856_c() - 1) {
                    this.func_228196_a_(n2, n2 + 1);
                    return true;
                }
            }
            this.field_148303_c.func_214287_a(this);
            if (Util.func_211177_b() - this.field_148298_f < 250L) {
                this.field_148303_c.func_146796_h();
            }
            this.field_148298_f = Util.func_211177_b();
            return false;
        }

        public ServerData func_148296_a() {
            return this.field_148301_e;
        }
    }

    public static class LanDetectedEntry
    extends Entry {
        private final MultiplayerScreen field_148292_c;
        protected final Minecraft field_148293_a;
        protected final LanServerInfo field_148291_b;
        private long field_148290_d;

        protected LanDetectedEntry(MultiplayerScreen multiplayerScreen, LanServerInfo lanServerInfo) {
            this.field_148292_c = multiplayerScreen;
            this.field_148291_b = lanServerInfo;
            this.field_148293_a = Minecraft.func_71410_x();
        }

        @Override
        public void render(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.field_148293_a.field_71466_p.func_211126_b(I18n.func_135052_a("lanServer.title", new Object[0]), n3 + 32 + 3, n2 + 1, 0xFFFFFF);
            this.field_148293_a.field_71466_p.func_211126_b(this.field_148291_b.func_77487_a(), n3 + 32 + 3, n2 + 12, 0x808080);
            if (this.field_148293_a.field_71474_y.field_80005_w) {
                this.field_148293_a.field_71466_p.func_211126_b(I18n.func_135052_a("selectServer.hiddenAddress", new Object[0]), n3 + 32 + 3, n2 + 12 + 11, 0x303030);
            } else {
                this.field_148293_a.field_71466_p.func_211126_b(this.field_148291_b.func_77488_b(), n3 + 32 + 3, n2 + 12 + 11, 0x303030);
            }
        }

        @Override
        public boolean mouseClicked(double d, double d2, int n) {
            this.field_148292_c.func_214287_a(this);
            if (Util.func_211177_b() - this.field_148290_d < 250L) {
                this.field_148292_c.func_146796_h();
            }
            this.field_148290_d = Util.func_211177_b();
            return false;
        }

        public LanServerInfo func_189995_a() {
            return this.field_148291_b;
        }
    }

    public static class LanScanEntry
    extends Entry {
        private final Minecraft field_148288_a = Minecraft.func_71410_x();

        @Override
        public void render(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            String string;
            int n8 = n2 + n5 / 2 - this.field_148288_a.field_71466_p.field_78288_b / 2;
            this.field_148288_a.field_71466_p.func_211126_b(I18n.func_135052_a("lanServer.scanning", new Object[0]), this.field_148288_a.field_71462_r.width / 2 - this.field_148288_a.field_71466_p.func_78256_a(I18n.func_135052_a("lanServer.scanning", new Object[0])) / 2, n8, 0xFFFFFF);
            switch ((int)(Util.func_211177_b() / 300L % 4L)) {
                default: {
                    string = "O o o";
                    break;
                }
                case 1: 
                case 3: {
                    string = "o O o";
                    break;
                }
                case 2: {
                    string = "o o O";
                }
            }
            this.field_148288_a.field_71466_p.func_211126_b(string, this.field_148288_a.field_71462_r.width / 2 - this.field_148288_a.field_71466_p.func_78256_a(string) / 2, n8 + this.field_148288_a.field_71466_p.field_78288_b, 0x808080);
        }
    }

    public static abstract class Entry
    extends ExtendedList.AbstractListEntry<Entry> {
    }
}

