/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen.inventory;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class ContainerScreen<T extends Container>
extends Screen
implements IHasContainer<T> {
    public static final ResourceLocation field_147001_a = new ResourceLocation("textures/gui/container/inventory.png");
    protected int field_146999_f = 176;
    protected int field_147000_g = 166;
    protected final T field_147002_h;
    protected final PlayerInventory field_213127_e;
    protected int field_147003_i;
    protected int field_147009_r;
    protected Slot field_147006_u;
    private Slot field_147005_v;
    private boolean field_147004_w;
    private ItemStack field_147012_x = ItemStack.field_190927_a;
    private int field_147011_y;
    private int field_147010_z;
    private Slot field_146989_A;
    private long field_146990_B;
    private ItemStack field_146991_C = ItemStack.field_190927_a;
    private Slot field_146985_D;
    private long field_146986_E;
    protected final Set<Slot> field_147008_s = Sets.newHashSet();
    protected boolean field_147007_t;
    private int field_146987_F;
    private int field_146988_G;
    private boolean field_146995_H;
    private int field_146996_I;
    private long field_146997_J;
    private Slot field_146998_K;
    private int field_146992_L;
    private boolean field_146993_M;
    private ItemStack field_146994_N = ItemStack.field_190927_a;

    public ContainerScreen(T t, PlayerInventory playerInventory, ITextComponent iTextComponent) {
        super(iTextComponent);
        this.field_147002_h = t;
        this.field_213127_e = playerInventory;
        this.field_146995_H = true;
    }

    @Override
    protected void init() {
        super.init();
        this.field_147003_i = (this.width - this.field_146999_f) / 2;
        this.field_147009_r = (this.height - this.field_147000_g) / 2;
    }

    @Override
    public void render(int n, int n2, float f) {
        int \u26033;
        int \u26032;
        Object object;
        int n3 = this.field_147003_i;
        \u2603 = this.field_147009_r;
        this.func_146976_a(f, n, n2);
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        super.render(n, n2, f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef(n3, \u2603, 0.0f);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableRescaleNormal();
        this.field_147006_u = null;
        \u2603 = 240;
        \u2603 = 240;
        RenderSystem.glMultiTexCoord2f(33986, 240.0f, 240.0f);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        for (\u2603 = 0; \u2603 < ((Container)this.field_147002_h).field_75151_b.size(); ++\u2603) {
            object = ((Container)this.field_147002_h).field_75151_b.get(\u2603);
            if (((Slot)object).func_111238_b()) {
                this.func_146977_a((Slot)object);
            }
            if (!this.func_195362_a((Slot)object, n, n2) || !((Slot)object).func_111238_b()) continue;
            this.field_147006_u = object;
            RenderSystem.disableDepthTest();
            \u26032 = ((Slot)object).field_75223_e;
            \u26033 = ((Slot)object).field_75221_f;
            RenderSystem.colorMask(true, true, true, false);
            this.fillGradient(\u26032, \u26033, \u26032 + 16, \u26033 + 16, -2130706433, -2130706433);
            RenderSystem.colorMask(true, true, true, true);
            RenderSystem.enableDepthTest();
        }
        this.func_146979_b(n, n2);
        PlayerInventory playerInventory = this.minecraft.field_71439_g.field_71071_by;
        Object object2 = object = this.field_147012_x.func_190926_b() ? playerInventory.func_70445_o() : this.field_147012_x;
        if (!((ItemStack)object).func_190926_b()) {
            \u26032 = 8;
            \u26033 = this.field_147012_x.func_190926_b() ? 8 : 16;
            String string = null;
            if (!this.field_147012_x.func_190926_b() && this.field_147004_w) {
                object = ((ItemStack)object).func_77946_l();
                ((ItemStack)object).func_190920_e(MathHelper.func_76123_f((float)((ItemStack)object).func_190916_E() / 2.0f));
            } else if (this.field_147007_t && this.field_147008_s.size() > 1) {
                object = ((ItemStack)object).func_77946_l();
                ((ItemStack)object).func_190920_e(this.field_146996_I);
                if (((ItemStack)object).func_190926_b()) {
                    string = "" + (Object)((Object)TextFormatting.YELLOW) + "0";
                }
            }
            this.func_146982_a((ItemStack)object, n - n3 - 8, n2 - \u2603 - \u26033, string);
        }
        if (!this.field_146991_C.func_190926_b()) {
            float f2 = (float)(Util.func_211177_b() - this.field_146990_B) / 100.0f;
            if (f2 >= 1.0f) {
                f2 = 1.0f;
                this.field_146991_C = ItemStack.field_190927_a;
            }
            \u26033 = this.field_146989_A.field_75223_e - this.field_147011_y;
            int \u26034 = this.field_146989_A.field_75221_f - this.field_147010_z;
            int \u26035 = this.field_147011_y + (int)((float)\u26033 * f2);
            int \u26036 = this.field_147010_z + (int)((float)\u26034 * f2);
            this.func_146982_a(this.field_146991_C, \u26035, \u26036, null);
        }
        RenderSystem.popMatrix();
        RenderSystem.enableDepthTest();
    }

    protected void func_191948_b(int n, int n2) {
        if (this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            this.renderTooltip(this.field_147006_u.func_75211_c(), n, n2);
        }
    }

    private void func_146982_a(ItemStack itemStack, int n, int n2, String string) {
        RenderSystem.translatef(0.0f, 0.0f, 32.0f);
        this.setBlitOffset(200);
        this.itemRenderer.field_77023_b = 200.0f;
        this.itemRenderer.func_180450_b(itemStack, n, n2);
        this.itemRenderer.func_180453_a(this.font, itemStack, n, n2 - (this.field_147012_x.func_190926_b() ? 0 : 8), string);
        this.setBlitOffset(0);
        this.itemRenderer.field_77023_b = 0.0f;
    }

    protected void func_146979_b(int n, int n2) {
    }

    protected abstract void func_146976_a(float var1, int var2, int var3);

    private void func_146977_a(Slot slot) {
        int n = slot.field_75223_e;
        \u2603 = slot.field_75221_f;
        ItemStack \u26032 = slot.func_75211_c();
        boolean \u26033 = false;
        boolean \u26034 = slot == this.field_147005_v && !this.field_147012_x.func_190926_b() && !this.field_147004_w;
        ItemStack \u26035 = this.minecraft.field_71439_g.field_71071_by.func_70445_o();
        String \u26036 = null;
        if (slot == this.field_147005_v && !this.field_147012_x.func_190926_b() && this.field_147004_w && !\u26032.func_190926_b()) {
            \u26032 = \u26032.func_77946_l();
            \u26032.func_190920_e(\u26032.func_190916_E() / 2);
        } else if (this.field_147007_t && this.field_147008_s.contains(slot) && !\u26035.func_190926_b()) {
            if (this.field_147008_s.size() == 1) {
                return;
            }
            if (Container.func_94527_a(slot, \u26035, true) && ((Container)this.field_147002_h).func_94531_b(slot)) {
                \u26032 = \u26035.func_77946_l();
                \u26033 = true;
                Container.func_94525_a(this.field_147008_s, this.field_146987_F, \u26032, slot.func_75211_c().func_190926_b() ? 0 : slot.func_75211_c().func_190916_E());
                \u2603 = Math.min(\u26032.func_77976_d(), slot.func_178170_b(\u26032));
                if (\u26032.func_190916_E() > \u2603) {
                    \u26036 = TextFormatting.YELLOW.toString() + \u2603;
                    \u26032.func_190920_e(\u2603);
                }
            } else {
                this.field_147008_s.remove(slot);
                this.func_146980_g();
            }
        }
        this.setBlitOffset(100);
        this.itemRenderer.field_77023_b = 100.0f;
        if (\u26032.func_190926_b() && slot.func_111238_b() && (\u2603 = slot.func_225517_c_()) != null) {
            TextureAtlasSprite textureAtlasSprite = this.minecraft.func_228015_a_((ResourceLocation)\u2603.getFirst()).apply((ResourceLocation)\u2603.getSecond());
            this.minecraft.func_110434_K().func_110577_a(textureAtlasSprite.func_229241_m_().func_229223_g_());
            ContainerScreen.blit(n, \u2603, this.getBlitOffset(), 16, 16, textureAtlasSprite);
            \u26034 = true;
        }
        if (!\u26034) {
            if (\u26033) {
                ContainerScreen.fill(n, \u2603, n + 16, \u2603 + 16, -2130706433);
            }
            RenderSystem.enableDepthTest();
            this.itemRenderer.func_184391_a(this.minecraft.field_71439_g, \u26032, n, \u2603);
            this.itemRenderer.func_180453_a(this.font, \u26032, n, \u2603, \u26036);
        }
        this.itemRenderer.field_77023_b = 0.0f;
        this.setBlitOffset(0);
    }

    private void func_146980_g() {
        ItemStack itemStack = this.minecraft.field_71439_g.field_71071_by.func_70445_o();
        if (itemStack.func_190926_b() || !this.field_147007_t) {
            return;
        }
        if (this.field_146987_F == 2) {
            this.field_146996_I = itemStack.func_77976_d();
            return;
        }
        this.field_146996_I = itemStack.func_190916_E();
        for (Slot slot : this.field_147008_s) {
            ItemStack itemStack2 = itemStack.func_77946_l();
            \u2603 = slot.func_75211_c();
            int \u26032 = \u2603.func_190926_b() ? 0 : \u2603.func_190916_E();
            Container.func_94525_a(this.field_147008_s, this.field_146987_F, itemStack2, \u26032);
            int \u26033 = Math.min(itemStack2.func_77976_d(), slot.func_178170_b(itemStack2));
            if (itemStack2.func_190916_E() > \u26033) {
                itemStack2.func_190920_e(\u26033);
            }
            this.field_146996_I -= itemStack2.func_190916_E() - \u26032;
        }
    }

    private Slot func_195360_a(double d, double d2) {
        for (int i = 0; i < ((Container)this.field_147002_h).field_75151_b.size(); ++i) {
            Slot slot = ((Container)this.field_147002_h).field_75151_b.get(i);
            if (!this.func_195362_a(slot, d, d2) || !slot.func_111238_b()) continue;
            return slot;
        }
        return null;
    }

    @Override
    public boolean mouseClicked(double d, double d2, int n) {
        if (super.mouseClicked(d, d2, n)) {
            return true;
        }
        boolean bl = this.minecraft.field_71474_y.field_74322_I.func_197984_a(n);
        Slot \u26032 = this.func_195360_a(d, d2);
        long \u26033 = Util.func_211177_b();
        this.field_146993_M = this.field_146998_K == \u26032 && \u26033 - this.field_146997_J < 250L && this.field_146992_L == n;
        this.field_146995_H = false;
        if (n == 0 || n == 1 || bl) {
            int n2 = this.field_147003_i;
            \u2603 = this.field_147009_r;
            boolean \u26034 = this.func_195361_a(d, d2, n2, \u2603, n);
            \u2603 = -1;
            if (\u26032 != null) {
                \u2603 = \u26032.field_75222_d;
            }
            if (\u26034) {
                \u2603 = -999;
            }
            if (this.minecraft.field_71474_y.field_85185_A && \u26034 && this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                this.minecraft.func_147108_a(null);
                return true;
            }
            if (\u2603 != -1) {
                if (this.minecraft.field_71474_y.field_85185_A) {
                    if (\u26032 != null && \u26032.func_75216_d()) {
                        this.field_147005_v = \u26032;
                        this.field_147012_x = ItemStack.field_190927_a;
                        this.field_147004_w = n == 1;
                    } else {
                        this.field_147005_v = null;
                    }
                } else if (!this.field_147007_t) {
                    if (this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                        if (this.minecraft.field_71474_y.field_74322_I.func_197984_a(n)) {
                            this.func_184098_a(\u26032, \u2603, n, ClickType.CLONE);
                        } else {
                            boolean bl2 = \u2603 != -999 && (InputMappings.func_216506_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i(), 340) || InputMappings.func_216506_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i(), 344));
                            ClickType \u26035 = ClickType.PICKUP;
                            if (bl2) {
                                this.field_146994_N = \u26032 != null && \u26032.func_75216_d() ? \u26032.func_75211_c().func_77946_l() : ItemStack.field_190927_a;
                                \u26035 = ClickType.QUICK_MOVE;
                            } else if (\u2603 == -999) {
                                \u26035 = ClickType.THROW;
                            }
                            this.func_184098_a(\u26032, \u2603, n, \u26035);
                        }
                        this.field_146995_H = true;
                    } else {
                        this.field_147007_t = true;
                        this.field_146988_G = n;
                        this.field_147008_s.clear();
                        if (n == 0) {
                            this.field_146987_F = 0;
                        } else if (n == 1) {
                            this.field_146987_F = 1;
                        } else if (this.minecraft.field_71474_y.field_74322_I.func_197984_a(n)) {
                            this.field_146987_F = 2;
                        }
                    }
                }
            }
        }
        this.field_146998_K = \u26032;
        this.field_146997_J = \u26033;
        this.field_146992_L = n;
        return true;
    }

    protected boolean func_195361_a(double d, double d2, int n, int n2, int n3) {
        return d < (double)n || d2 < (double)n2 || d >= (double)(n + this.field_146999_f) || d2 >= (double)(n2 + this.field_147000_g);
    }

    @Override
    public boolean mouseDragged(double d, double d2, int n, double d3, double d4) {
        Slot slot = this.func_195360_a(d, d2);
        ItemStack \u26032 = this.minecraft.field_71439_g.field_71071_by.func_70445_o();
        if (this.field_147005_v != null && this.minecraft.field_71474_y.field_85185_A) {
            if (n == 0 || n == 1) {
                if (this.field_147012_x.func_190926_b()) {
                    if (slot != this.field_147005_v && !this.field_147005_v.func_75211_c().func_190926_b()) {
                        this.field_147012_x = this.field_147005_v.func_75211_c().func_77946_l();
                    }
                } else if (this.field_147012_x.func_190916_E() > 1 && slot != null && Container.func_94527_a(slot, this.field_147012_x, false)) {
                    long l = Util.func_211177_b();
                    if (this.field_146985_D == slot) {
                        if (l - this.field_146986_E > 500L) {
                            this.func_184098_a(this.field_147005_v, this.field_147005_v.field_75222_d, 0, ClickType.PICKUP);
                            this.func_184098_a(slot, slot.field_75222_d, 1, ClickType.PICKUP);
                            this.func_184098_a(this.field_147005_v, this.field_147005_v.field_75222_d, 0, ClickType.PICKUP);
                            this.field_146986_E = l + 750L;
                            this.field_147012_x.func_190918_g(1);
                        }
                    } else {
                        this.field_146985_D = slot;
                        this.field_146986_E = l;
                    }
                }
            }
        } else if (this.field_147007_t && slot != null && !\u26032.func_190926_b() && (\u26032.func_190916_E() > this.field_147008_s.size() || this.field_146987_F == 2) && Container.func_94527_a(slot, \u26032, true) && slot.func_75214_a(\u26032) && ((Container)this.field_147002_h).func_94531_b(slot)) {
            this.field_147008_s.add(slot);
            this.func_146980_g();
        }
        return true;
    }

    @Override
    public boolean mouseReleased(double d, double d2, int n2) {
        Slot slot = this.func_195360_a(d, d2);
        int \u26032 = this.field_147003_i;
        int \u26033 = this.field_147009_r;
        boolean \u26034 = this.func_195361_a(d, d2, \u26032, \u26033, n2);
        int \u26035 = -1;
        if (slot != null) {
            \u26035 = slot.field_75222_d;
        }
        if (\u26034) {
            \u26035 = -999;
        }
        if (this.field_146993_M && slot != null && n2 == 0 && ((Container)this.field_147002_h).func_94530_a(ItemStack.field_190927_a, slot)) {
            if (ContainerScreen.hasShiftDown()) {
                if (!this.field_146994_N.func_190926_b()) {
                    for (Slot slot2 : ((Container)this.field_147002_h).field_75151_b) {
                        if (slot2 == null || !slot2.func_82869_a(this.minecraft.field_71439_g) || !slot2.func_75216_d() || slot2.field_75224_c != slot.field_75224_c || !Container.func_94527_a(slot2, this.field_146994_N, true)) continue;
                        this.func_184098_a(slot2, slot2.field_75222_d, n2, ClickType.QUICK_MOVE);
                    }
                }
            } else {
                this.func_184098_a(slot, \u26035, n2, ClickType.PICKUP_ALL);
            }
            this.field_146993_M = false;
            this.field_146997_J = 0L;
        } else {
            if (this.field_147007_t && this.field_146988_G != n2) {
                this.field_147007_t = false;
                this.field_147008_s.clear();
                this.field_146995_H = true;
                return true;
            }
            if (this.field_146995_H) {
                this.field_146995_H = false;
                return true;
            }
            if (this.field_147005_v != null && this.minecraft.field_71474_y.field_85185_A) {
                if (n2 == 0 || n2 == 1) {
                    if (this.field_147012_x.func_190926_b() && slot != this.field_147005_v) {
                        this.field_147012_x = this.field_147005_v.func_75211_c();
                    }
                    boolean bl = Container.func_94527_a(slot, this.field_147012_x, false);
                    if (\u26035 != -1 && !this.field_147012_x.func_190926_b() && bl) {
                        this.func_184098_a(this.field_147005_v, this.field_147005_v.field_75222_d, n2, ClickType.PICKUP);
                        this.func_184098_a(slot, \u26035, 0, ClickType.PICKUP);
                        if (this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                            this.field_146991_C = ItemStack.field_190927_a;
                        } else {
                            this.func_184098_a(this.field_147005_v, this.field_147005_v.field_75222_d, n2, ClickType.PICKUP);
                            this.field_147011_y = MathHelper.func_76128_c(d - (double)\u26032);
                            this.field_147010_z = MathHelper.func_76128_c(d2 - (double)\u26033);
                            this.field_146989_A = this.field_147005_v;
                            this.field_146991_C = this.field_147012_x;
                            this.field_146990_B = Util.func_211177_b();
                        }
                    } else if (!this.field_147012_x.func_190926_b()) {
                        this.field_147011_y = MathHelper.func_76128_c(d - (double)\u26032);
                        this.field_147010_z = MathHelper.func_76128_c(d2 - (double)\u26033);
                        this.field_146989_A = this.field_147005_v;
                        this.field_146991_C = this.field_147012_x;
                        this.field_146990_B = Util.func_211177_b();
                    }
                    this.field_147012_x = ItemStack.field_190927_a;
                    this.field_147005_v = null;
                }
            } else if (this.field_147007_t && !this.field_147008_s.isEmpty()) {
                this.func_184098_a(null, -999, Container.func_94534_d(0, this.field_146987_F), ClickType.QUICK_CRAFT);
                for (Slot slot3 : this.field_147008_s) {
                    this.func_184098_a(slot3, slot3.field_75222_d, Container.func_94534_d(1, this.field_146987_F), ClickType.QUICK_CRAFT);
                }
                this.func_184098_a(null, -999, Container.func_94534_d(2, this.field_146987_F), ClickType.QUICK_CRAFT);
            } else if (!this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                int n2;
                if (this.minecraft.field_71474_y.field_74322_I.func_197984_a(n2)) {
                    this.func_184098_a(slot, \u26035, n2, ClickType.CLONE);
                } else {
                    boolean bl = \u2603 = \u26035 != -999 && (InputMappings.func_216506_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i(), 340) || InputMappings.func_216506_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i(), 344));
                    if (\u2603) {
                        this.field_146994_N = slot != null && slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : ItemStack.field_190927_a;
                    }
                    this.func_184098_a(slot, \u26035, n2, \u2603 ? ClickType.QUICK_MOVE : ClickType.PICKUP);
                }
            }
        }
        if (this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            this.field_146997_J = 0L;
        }
        this.field_147007_t = false;
        return true;
    }

    private boolean func_195362_a(Slot slot, double d, double d2) {
        return this.func_195359_a(slot.field_75223_e, slot.field_75221_f, 16, 16, d, d2);
    }

    protected boolean func_195359_a(int n, int n2, int n3, int n4, double d, double d2) {
        int n5 = this.field_147003_i;
        \u2603 = this.field_147009_r;
        return (d -= (double)n5) >= (double)(n - 1) && d < (double)(n + n3 + 1) && (d2 -= (double)\u2603) >= (double)(n2 - 1) && d2 < (double)(n2 + n4 + 1);
    }

    protected void func_184098_a(Slot slot, int n3, int n2, ClickType clickType) {
        int n3;
        if (slot != null) {
            n3 = slot.field_75222_d;
        }
        this.minecraft.field_71442_b.func_187098_a(((Container)this.field_147002_h).field_75152_c, n3, n2, clickType, this.minecraft.field_71439_g);
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (super.keyPressed(n, n2, n3)) {
            return true;
        }
        if (n == 256 || this.minecraft.field_71474_y.field_151445_Q.func_197976_a(n, n2)) {
            this.minecraft.field_71439_g.func_71053_j();
        }
        this.func_195363_d(n, n2);
        if (this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            if (this.minecraft.field_71474_y.field_74322_I.func_197976_a(n, n2)) {
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, 0, ClickType.CLONE);
            } else if (this.minecraft.field_71474_y.field_74316_C.func_197976_a(n, n2)) {
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, ContainerScreen.hasControlDown() ? 1 : 0, ClickType.THROW);
            }
        }
        return true;
    }

    protected boolean func_195363_d(int n, int n2) {
        if (this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null) {
            for (\u2603 = 0; \u2603 < 9; ++\u2603) {
                if (!this.minecraft.field_71474_y.field_151456_ac[\u2603].func_197976_a(n, n2)) continue;
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, \u2603, ClickType.SWAP);
                return true;
            }
        }
        return false;
    }

    @Override
    public void removed() {
        if (this.minecraft.field_71439_g == null) {
            return;
        }
        ((Container)this.field_147002_h).func_75134_a(this.minecraft.field_71439_g);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.minecraft.field_71439_g.func_70089_S() || this.minecraft.field_71439_g.field_70128_L) {
            this.minecraft.field_71439_g.func_71053_j();
        }
    }

    @Override
    public T func_212873_a_() {
        return this.field_147002_h;
    }
}

