/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.client.gui.screen.inventory.CreativeCraftingListener;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.CreativeSettings;
import net.minecraft.client.settings.HotbarSnapshot;
import net.minecraft.client.util.IMutableSearchTree;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class CreativeScreen
extends DisplayEffectsScreen<CreativeContainer> {
    private static final ResourceLocation field_147061_u = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final Inventory field_195378_x = new Inventory(45);
    private static int field_147058_w = ItemGroup.field_78030_b.func_78021_a();
    private float field_147067_x;
    private boolean field_147066_y;
    private TextFieldWidget field_147062_A;
    @Nullable
    private List<Slot> field_147063_B;
    @Nullable
    private Slot field_147064_C;
    private CreativeCraftingListener field_147059_E;
    private boolean field_195377_F;
    private boolean field_199506_G;
    private final Map<ResourceLocation, Tag<Item>> field_214085_w = Maps.newTreeMap();

    public CreativeScreen(PlayerEntity playerEntity) {
        super(new CreativeContainer(playerEntity), playerEntity.field_71071_by, new StringTextComponent(""));
        playerEntity.field_71070_bA = this.field_147002_h;
        this.passEvents = true;
        this.field_147000_g = 136;
        this.field_146999_f = 195;
    }

    @Override
    public void tick() {
        if (!this.minecraft.field_71442_b.func_78758_h()) {
            this.minecraft.func_147108_a(new InventoryScreen(this.minecraft.field_71439_g));
        } else if (this.field_147062_A != null) {
            this.field_147062_A.func_146178_a();
        }
    }

    @Override
    protected void func_184098_a(@Nullable Slot slot2, int n, int n22, ClickType clickType3) {
        if (this.func_208018_a(slot2)) {
            this.field_147062_A.func_146202_e();
            this.field_147062_A.func_146199_i(0);
        }
        boolean bl = clickType3 == ClickType.QUICK_MOVE;
        ClickType clickType2 = clickType3 = n == -999 && clickType3 == ClickType.PICKUP ? ClickType.THROW : clickType3;
        if (slot2 != null || field_147058_w == ItemGroup.field_78036_m.func_78021_a() || clickType3 == ClickType.QUICK_CRAFT) {
            ClickType clickType3;
            Slot slot2;
            if (slot2 != null && !slot2.func_82869_a(this.minecraft.field_71439_g)) {
                return;
            }
            if (slot2 == this.field_147064_C && bl) {
                for (int i = 0; i < this.minecraft.field_71439_g.field_71069_bz.func_75138_a().size(); ++i) {
                    this.minecraft.field_71442_b.func_78761_a(ItemStack.field_190927_a, i);
                }
            } else if (field_147058_w == ItemGroup.field_78036_m.func_78021_a()) {
                if (slot2 == this.field_147064_C) {
                    this.minecraft.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                } else if (clickType3 == ClickType.THROW && slot2 != null && slot2.func_75216_d()) {
                    ItemStack itemStack = slot2.func_75209_a(n22 == 0 ? 1 : slot2.func_75211_c().func_77976_d());
                    \u2603 = slot2.func_75211_c();
                    this.minecraft.field_71439_g.func_71019_a(itemStack, true);
                    this.minecraft.field_71442_b.func_78752_a(itemStack);
                    this.minecraft.field_71442_b.func_78761_a(\u2603, ((CreativeSlot)((CreativeSlot)slot2)).field_148332_b.field_75222_d);
                } else if (clickType3 == ClickType.THROW && !this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                    this.minecraft.field_71439_g.func_71019_a(this.minecraft.field_71439_g.field_71071_by.func_70445_o(), true);
                    this.minecraft.field_71442_b.func_78752_a(this.minecraft.field_71439_g.field_71071_by.func_70445_o());
                    this.minecraft.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                } else {
                    this.minecraft.field_71439_g.field_71069_bz.func_184996_a(slot2 == null ? n : ((CreativeSlot)((CreativeSlot)slot2)).field_148332_b.field_75222_d, n22, clickType3, this.minecraft.field_71439_g);
                    this.minecraft.field_71439_g.field_71069_bz.func_75142_b();
                }
            } else if (clickType3 != ClickType.QUICK_CRAFT && slot2.field_75224_c == field_195378_x) {
                int n22;
                PlayerInventory playerInventory = this.minecraft.field_71439_g.field_71071_by;
                ItemStack \u26032 = playerInventory.func_70445_o();
                ItemStack \u26033 = slot2.func_75211_c();
                if (clickType3 == ClickType.SWAP) {
                    if (!\u26033.func_190926_b() && n22 >= 0 && n22 < 9) {
                        ItemStack itemStack = \u26033.func_77946_l();
                        itemStack.func_190920_e(itemStack.func_77976_d());
                        this.minecraft.field_71439_g.field_71071_by.func_70299_a(n22, itemStack);
                        this.minecraft.field_71439_g.field_71069_bz.func_75142_b();
                    }
                    return;
                }
                if (clickType3 == ClickType.CLONE) {
                    if (playerInventory.func_70445_o().func_190926_b() && slot2.func_75216_d()) {
                        ItemStack itemStack = slot2.func_75211_c().func_77946_l();
                        itemStack.func_190920_e(itemStack.func_77976_d());
                        playerInventory.func_70437_b(itemStack);
                    }
                    return;
                }
                if (clickType3 == ClickType.THROW) {
                    if (!\u26033.func_190926_b()) {
                        ItemStack itemStack = \u26033.func_77946_l();
                        itemStack.func_190920_e(n22 == 0 ? 1 : itemStack.func_77976_d());
                        this.minecraft.field_71439_g.func_71019_a(itemStack, true);
                        this.minecraft.field_71442_b.func_78752_a(itemStack);
                    }
                    return;
                }
                if (!\u26032.func_190926_b() && !\u26033.func_190926_b() && \u26032.func_77969_a(\u26033) && ItemStack.func_77970_a(\u26032, \u26033)) {
                    if (n22 == 0) {
                        if (bl) {
                            \u26032.func_190920_e(\u26032.func_77976_d());
                        } else if (\u26032.func_190916_E() < \u26032.func_77976_d()) {
                            \u26032.func_190917_f(1);
                        }
                    } else {
                        \u26032.func_190918_g(1);
                    }
                } else if (\u26033.func_190926_b() || !\u26032.func_190926_b()) {
                    if (n22 == 0) {
                        playerInventory.func_70437_b(ItemStack.field_190927_a);
                    } else {
                        playerInventory.func_70445_o().func_190918_g(1);
                    }
                } else {
                    playerInventory.func_70437_b(\u26033.func_77946_l());
                    \u26032 = playerInventory.func_70445_o();
                    if (bl) {
                        \u26032.func_190920_e(\u26032.func_77976_d());
                    }
                }
            } else if (this.field_147002_h != null) {
                ItemStack \u26034 = slot2 == null ? ItemStack.field_190927_a : ((CreativeContainer)this.field_147002_h).func_75139_a(slot2.field_75222_d).func_75211_c();
                ((CreativeContainer)this.field_147002_h).func_184996_a(slot2 == null ? n : slot2.field_75222_d, n22, clickType3, this.minecraft.field_71439_g);
                if (Container.func_94532_c(n22) == 2) {
                    for (int i = 0; i < 9; ++i) {
                        this.minecraft.field_71442_b.func_78761_a(((CreativeContainer)this.field_147002_h).func_75139_a(45 + i).func_75211_c(), 36 + i);
                    }
                } else if (slot2 != null) {
                    ItemStack itemStack = ((CreativeContainer)this.field_147002_h).func_75139_a(slot2.field_75222_d).func_75211_c();
                    this.minecraft.field_71442_b.func_78761_a(itemStack, slot2.field_75222_d - ((CreativeContainer)this.field_147002_h).field_75151_b.size() + 9 + 36);
                    int \u26035 = 45 + n22;
                    if (clickType3 == ClickType.SWAP) {
                        this.minecraft.field_71442_b.func_78761_a(\u26034, \u26035 - ((CreativeContainer)this.field_147002_h).field_75151_b.size() + 9 + 36);
                    } else if (clickType3 == ClickType.THROW && !\u26034.func_190926_b()) {
                        \u2603 = \u26034.func_77946_l();
                        \u2603.func_190920_e(n22 == 0 ? 1 : \u2603.func_77976_d());
                        this.minecraft.field_71439_g.func_71019_a(\u2603, true);
                        this.minecraft.field_71442_b.func_78752_a(\u2603);
                    }
                    this.minecraft.field_71439_g.field_71069_bz.func_75142_b();
                }
            }
        } else {
            PlayerInventory playerInventory = this.minecraft.field_71439_g.field_71071_by;
            if (!playerInventory.func_70445_o().func_190926_b() && this.field_199506_G) {
                if (n22 == 0) {
                    this.minecraft.field_71439_g.func_71019_a(playerInventory.func_70445_o(), true);
                    this.minecraft.field_71442_b.func_78752_a(playerInventory.func_70445_o());
                    playerInventory.func_70437_b(ItemStack.field_190927_a);
                }
                if (n22 == 1) {
                    ItemStack itemStack = playerInventory.func_70445_o().func_77979_a(1);
                    this.minecraft.field_71439_g.func_71019_a(itemStack, true);
                    this.minecraft.field_71442_b.func_78752_a(itemStack);
                }
            }
        }
    }

    private boolean func_208018_a(@Nullable Slot slot) {
        return slot != null && slot.field_75224_c == field_195378_x;
    }

    @Override
    protected void func_175378_g() {
        int n = this.field_147003_i;
        super.func_175378_g();
        if (this.field_147062_A != null && this.field_147003_i != n) {
            this.field_147062_A.func_212952_l(this.field_147003_i + 82);
        }
    }

    @Override
    protected void init() {
        if (this.minecraft.field_71442_b.func_78758_h()) {
            super.init();
            this.minecraft.field_195559_v.func_197967_a(true);
            this.field_147062_A = new TextFieldWidget(this.font, this.field_147003_i + 82, this.field_147009_r + 6, 80, this.font.field_78288_b, I18n.func_135052_a("itemGroup.search", new Object[0]));
            this.field_147062_A.func_146203_f(50);
            this.field_147062_A.func_146185_a(false);
            this.field_147062_A.func_146189_e(false);
            this.field_147062_A.func_146193_g(0xFFFFFF);
            this.children.add(this.field_147062_A);
            int n = field_147058_w;
            field_147058_w = -1;
            this.func_147050_b(ItemGroup.field_78032_a[n]);
            this.minecraft.field_71439_g.field_71069_bz.func_82847_b(this.field_147059_E);
            this.field_147059_E = new CreativeCraftingListener(this.minecraft);
            this.minecraft.field_71439_g.field_71069_bz.func_75132_a(this.field_147059_E);
        } else {
            this.minecraft.func_147108_a(new InventoryScreen(this.minecraft.field_71439_g));
        }
    }

    @Override
    public void resize(Minecraft minecraft, int n, int n2) {
        String string = this.field_147062_A.func_146179_b();
        this.init(minecraft, n, n2);
        this.field_147062_A.func_146180_a(string);
        if (!this.field_147062_A.func_146179_b().isEmpty()) {
            this.func_147053_i();
        }
    }

    @Override
    public void removed() {
        super.removed();
        if (this.minecraft.field_71439_g != null && this.minecraft.field_71439_g.field_71071_by != null) {
            this.minecraft.field_71439_g.field_71069_bz.func_82847_b(this.field_147059_E);
        }
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    @Override
    public boolean charTyped(char c, int n) {
        if (this.field_195377_F) {
            return false;
        }
        if (field_147058_w != ItemGroup.field_78027_g.func_78021_a()) {
            return false;
        }
        String string = this.field_147062_A.func_146179_b();
        if (this.field_147062_A.charTyped(c, n)) {
            if (!Objects.equals(string, this.field_147062_A.func_146179_b())) {
                this.func_147053_i();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        this.field_195377_F = false;
        if (field_147058_w != ItemGroup.field_78027_g.func_78021_a()) {
            if (this.minecraft.field_71474_y.field_74310_D.func_197976_a(n, n2)) {
                this.field_195377_F = true;
                this.func_147050_b(ItemGroup.field_78027_g);
                return true;
            }
            return super.keyPressed(n, n2, n3);
        }
        boolean bl = \u2603 = !this.func_208018_a(this.field_147006_u) || this.field_147006_u != null && this.field_147006_u.func_75216_d();
        if (\u2603 && this.func_195363_d(n, n2)) {
            this.field_195377_F = true;
            return true;
        }
        String string = this.field_147062_A.func_146179_b();
        if (this.field_147062_A.keyPressed(n, n2, n3)) {
            if (!Objects.equals(string, this.field_147062_A.func_146179_b())) {
                this.func_147053_i();
            }
            return true;
        }
        if (this.field_147062_A.isFocused() && this.field_147062_A.func_146176_q() && n != 256) {
            return true;
        }
        return super.keyPressed(n, n2, n3);
    }

    @Override
    public boolean func_223281_a_(int n, int n2, int n3) {
        this.field_195377_F = false;
        return super.func_223281_a_(n, n2, n3);
    }

    private void func_147053_i() {
        ((CreativeContainer)this.field_147002_h).field_148330_a.clear();
        this.field_214085_w.clear();
        String string = this.field_147062_A.func_146179_b();
        if (string.isEmpty()) {
            for (Item item : Registry.field_212630_s) {
                item.func_150895_a(ItemGroup.field_78027_g, ((CreativeContainer)this.field_147002_h).field_148330_a);
            }
        } else {
            IMutableSearchTree<ItemStack> iMutableSearchTree;
            if (string.startsWith("#")) {
                string = string.substring(1);
                iMutableSearchTree = this.minecraft.func_213253_a(SearchTreeManager.field_215360_b);
                this.func_214080_a(string);
            } else {
                iMutableSearchTree = this.minecraft.func_213253_a(SearchTreeManager.field_215359_a);
            }
            ((CreativeContainer)this.field_147002_h).field_148330_a.addAll(iMutableSearchTree.func_194038_a(string.toLowerCase(Locale.ROOT)));
        }
        this.field_147067_x = 0.0f;
        ((CreativeContainer)this.field_147002_h).func_148329_a(0.0f);
    }

    private void func_214080_a(String string2) {
        Object \u26032;
        Predicate<ResourceLocation> \u26033;
        int n = string2.indexOf(58);
        if (n == -1) {
            \u26033 = resourceLocation -> resourceLocation.func_110623_a().contains(string2);
        } else {
            String string2;
            \u26032 = string2.substring(0, n).trim();
            \u2603 = string2.substring(n + 1).trim();
            \u26033 = arg_0 -> CreativeScreen.func_214081_a((String)\u26032, \u2603, arg_0);
        }
        \u26032 = ItemTags.func_199903_a();
        ((TagCollection)\u26032).func_199908_a().stream().filter(\u26033).forEach(arg_0 -> this.func_214082_a((TagCollection)\u26032, arg_0));
    }

    @Override
    protected void func_146979_b(int n, int n2) {
        ItemGroup itemGroup = ItemGroup.field_78032_a[field_147058_w];
        if (itemGroup.func_78019_g()) {
            RenderSystem.disableBlend();
            this.font.func_211126_b(I18n.func_135052_a(itemGroup.func_78024_c(), new Object[0]), 8.0f, 6.0f, 0x404040);
        }
    }

    @Override
    public boolean mouseClicked(double d3, double d2, int n) {
        double d3;
        if (n == 0) {
            double d4 = d3 - (double)this.field_147003_i;
            \u2603 = d2 - (double)this.field_147009_r;
            for (ItemGroup itemGroup : ItemGroup.field_78032_a) {
                if (!this.func_195375_a(itemGroup, d4, \u2603)) continue;
                return true;
            }
            if (field_147058_w != ItemGroup.field_78036_m.func_78021_a() && this.func_195376_a(d3, d2)) {
                this.field_147066_y = this.func_147055_p();
                return true;
            }
        }
        return super.mouseClicked(d3, d2, n);
    }

    @Override
    public boolean mouseReleased(double d3, double d2, int n) {
        double d3;
        if (n == 0) {
            double d4 = d3 - (double)this.field_147003_i;
            \u2603 = d2 - (double)this.field_147009_r;
            this.field_147066_y = false;
            for (ItemGroup itemGroup : ItemGroup.field_78032_a) {
                if (!this.func_195375_a(itemGroup, d4, \u2603)) continue;
                this.func_147050_b(itemGroup);
                return true;
            }
        }
        return super.mouseReleased(d3, d2, n);
    }

    private boolean func_147055_p() {
        return field_147058_w != ItemGroup.field_78036_m.func_78021_a() && ItemGroup.field_78032_a[field_147058_w].func_78017_i() && ((CreativeContainer)this.field_147002_h).func_148328_e();
    }

    private void func_147050_b(ItemGroup itemGroup) {
        Object object;
        int n;
        int n2 = field_147058_w;
        field_147058_w = itemGroup.func_78021_a();
        this.field_147008_s.clear();
        ((CreativeContainer)this.field_147002_h).field_148330_a.clear();
        if (itemGroup == ItemGroup.field_192395_m) {
            Object object2 = this.minecraft.func_199403_al();
            for (n = 0; n < 9; ++n) {
                HotbarSnapshot hotbarSnapshot = ((CreativeSettings)object2).func_192563_a(n);
                if (hotbarSnapshot.isEmpty()) {
                    for (int i = 0; i < 9; ++i) {
                        if (i == n) {
                            object = new ItemStack(Items.field_151121_aF);
                            ((ItemStack)object).func_190925_c("CustomCreativeLock");
                            String \u26032 = this.minecraft.field_71474_y.field_151456_ac[n].func_197978_k();
                            String \u26033 = this.minecraft.field_71474_y.field_193629_ap.func_197978_k();
                            ((ItemStack)object).func_200302_a(new TranslationTextComponent("inventory.hotbarInfo", \u26033, \u26032));
                            ((CreativeContainer)this.field_147002_h).field_148330_a.add((ItemStack)object);
                            continue;
                        }
                        ((CreativeContainer)this.field_147002_h).field_148330_a.add(ItemStack.field_190927_a);
                    }
                    continue;
                }
                ((CreativeContainer)this.field_147002_h).field_148330_a.addAll((Collection<ItemStack>)((Object)hotbarSnapshot));
            }
        } else if (itemGroup != ItemGroup.field_78027_g) {
            itemGroup.func_78018_a(((CreativeContainer)this.field_147002_h).field_148330_a);
        }
        if (itemGroup == ItemGroup.field_78036_m) {
            object2 = this.minecraft.field_71439_g.field_71069_bz;
            if (this.field_147063_B == null) {
                this.field_147063_B = ImmutableList.copyOf((Collection)((CreativeContainer)this.field_147002_h).field_75151_b);
            }
            ((CreativeContainer)this.field_147002_h).field_75151_b.clear();
            for (n = 0; n < ((Container)object2).field_75151_b.size(); ++n) {
                if (n >= 5 && n < 9) {
                    \u2603 = n - 5;
                    \u2603 = \u2603 / 2;
                    \u2603 = \u2603 % 2;
                    \u2603 = 54 + \u2603 * 54;
                    i = 6 + \u2603 * 27;
                } else if (n >= 0 && n < 5) {
                    \u2603 = -2000;
                    i = -2000;
                } else if (n == 45) {
                    \u2603 = 35;
                    i = 20;
                } else {
                    \u2603 = n - 9;
                    \u2603 = \u2603 % 9;
                    \u2603 = \u2603 / 9;
                    \u2603 = 9 + \u2603 * 18;
                    i = n >= 36 ? 112 : 54 + \u2603 * 18;
                }
                object = new CreativeSlot(((Container)object2).field_75151_b.get(n), n, \u2603, i);
                ((CreativeContainer)this.field_147002_h).field_75151_b.add(object);
            }
            this.field_147064_C = new Slot(field_195378_x, 0, 173, 112);
            ((CreativeContainer)this.field_147002_h).field_75151_b.add(this.field_147064_C);
        } else if (n2 == ItemGroup.field_78036_m.func_78021_a()) {
            ((CreativeContainer)this.field_147002_h).field_75151_b.clear();
            ((CreativeContainer)this.field_147002_h).field_75151_b.addAll(this.field_147063_B);
            this.field_147063_B = null;
        }
        if (this.field_147062_A != null) {
            if (itemGroup == ItemGroup.field_78027_g) {
                this.field_147062_A.func_146189_e(true);
                this.field_147062_A.func_146205_d(false);
                this.field_147062_A.func_146195_b(true);
                if (n2 != itemGroup.func_78021_a()) {
                    this.field_147062_A.func_146180_a("");
                }
                this.func_147053_i();
            } else {
                this.field_147062_A.func_146189_e(false);
                this.field_147062_A.func_146205_d(true);
                this.field_147062_A.func_146195_b(false);
                this.field_147062_A.func_146180_a("");
            }
        }
        this.field_147067_x = 0.0f;
        ((CreativeContainer)this.field_147002_h).func_148329_a(0.0f);
    }

    @Override
    public boolean mouseScrolled(double d, double d2, double d3) {
        if (!this.func_147055_p()) {
            return false;
        }
        int n = (((CreativeContainer)this.field_147002_h).field_148330_a.size() + 9 - 1) / 9 - 5;
        this.field_147067_x = (float)((double)this.field_147067_x - d3 / (double)n);
        this.field_147067_x = MathHelper.func_76131_a(this.field_147067_x, 0.0f, 1.0f);
        ((CreativeContainer)this.field_147002_h).func_148329_a(this.field_147067_x);
        return true;
    }

    @Override
    protected boolean func_195361_a(double d, double d2, int n, int n2, int n3) {
        boolean bl = d < (double)n || d2 < (double)n2 || d >= (double)(n + this.field_146999_f) || d2 >= (double)(n2 + this.field_147000_g);
        this.field_199506_G = bl && !this.func_195375_a(ItemGroup.field_78032_a[field_147058_w], d, d2);
        return this.field_199506_G;
    }

    protected boolean func_195376_a(double d, double d2) {
        int n = this.field_147003_i;
        \u2603 = this.field_147009_r;
        \u2603 = n + 175;
        \u2603 = \u2603 + 18;
        \u2603 = \u2603 + 14;
        \u2603 = \u2603 + 112;
        return d >= (double)\u2603 && d2 >= (double)\u2603 && d < (double)\u2603 && d2 < (double)\u2603;
    }

    @Override
    public boolean mouseDragged(double d5, double d2, int n, double d3, double d4) {
        double d5;
        if (this.field_147066_y) {
            int n2 = this.field_147009_r + 18;
            \u2603 = n2 + 112;
            this.field_147067_x = ((float)d2 - (float)n2 - 7.5f) / ((float)(\u2603 - n2) - 15.0f);
            this.field_147067_x = MathHelper.func_76131_a(this.field_147067_x, 0.0f, 1.0f);
            ((CreativeContainer)this.field_147002_h).func_148329_a(this.field_147067_x);
            return true;
        }
        return super.mouseDragged(d5, d2, n, d3, d4);
    }

    @Override
    public void render(int n3, int n2, float f) {
        int n3;
        this.renderBackground();
        super.render(n3, n2, f);
        for (ItemGroup itemGroup : ItemGroup.field_78032_a) {
            if (this.func_147052_b(itemGroup, n3, n2)) break;
        }
        if (this.field_147064_C != null && field_147058_w == ItemGroup.field_78036_m.func_78021_a() && this.func_195359_a(this.field_147064_C.field_75223_e, this.field_147064_C.field_75221_f, 16, 16, n3, n2)) {
            this.renderTooltip(I18n.func_135052_a("inventory.binSlot", new Object[0]), n3, n2);
        }
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.func_191948_b(n3, n2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void renderTooltip(ItemStack itemStack2, int n3, int n2) {
        if (field_147058_w == ItemGroup.field_78027_g.func_78021_a()) {
            void var7_10;
            Map<Enchantment, Integer> map;
            List<ITextComponent> list = itemStack2.func_82840_a(this.minecraft.field_71439_g, this.minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL);
            ArrayList \u26032 = Lists.newArrayListWithCapacity((int)list.size());
            for (ITextComponent iTextComponent : list) {
                \u26032.add(iTextComponent.func_150254_d());
            }
            Item \u26033 = itemStack2.func_77973_b();
            ItemGroup itemGroup = \u26033.func_77640_w();
            if (itemGroup == null && \u26033 == Items.field_151134_bR && (map = EnchantmentHelper.func_82781_a(itemStack2)).size() == 1) {
                Enchantment enchantment = map.keySet().iterator().next();
                for (ItemGroup itemGroup2 : ItemGroup.field_78032_a) {
                    if (!itemGroup2.func_111226_a(enchantment.field_77351_y)) continue;
                    ItemGroup itemGroup3 = itemGroup2;
                    break;
                }
            }
            this.field_214085_w.forEach((resourceLocation, tag) -> {
                if (tag.func_199685_a_(\u26033)) {
                    \u26032.add(1, "" + (Object)((Object)TextFormatting.BOLD) + (Object)((Object)TextFormatting.DARK_PURPLE) + "#" + resourceLocation);
                }
            });
            if (var7_10 != null) {
                \u26032.add(1, "" + (Object)((Object)TextFormatting.BOLD) + (Object)((Object)TextFormatting.BLUE) + I18n.func_135052_a(var7_10.func_78024_c(), new Object[0]));
            }
            for (int i = 0; i < \u26032.size(); ++i) {
                if (i == 0) {
                    \u26032.set(i, (Object)((Object)itemStack2.func_77953_t().field_77937_e) + (String)\u26032.get(i));
                    continue;
                }
                \u26032.set(i, (Object)((Object)TextFormatting.GRAY) + (String)\u26032.get(i));
            }
            this.renderTooltip(\u26032, n3, n2);
        } else {
            super.renderTooltip(itemStack2, n3, n2);
        }
    }

    @Override
    protected void func_146976_a(float f, int n, int n2) {
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        ItemGroup itemGroup = ItemGroup.field_78032_a[field_147058_w];
        for (ItemGroup itemGroup2 : ItemGroup.field_78032_a) {
            this.minecraft.func_110434_K().func_110577_a(field_147061_u);
            if (itemGroup2.func_78021_a() == field_147058_w) continue;
            this.func_147051_a(itemGroup2);
        }
        this.minecraft.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/container/creative_inventory/tab_" + itemGroup.func_78015_f()));
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_147062_A.render(n, n2, f);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        int \u26032 = this.field_147003_i + 175;
        int \u26033 = this.field_147009_r + 18;
        int \u26034 = \u26033 + 112;
        this.minecraft.func_110434_K().func_110577_a(field_147061_u);
        if (itemGroup.func_78017_i()) {
            this.blit(\u26032, \u26033 + (int)((float)(\u26034 - \u26033 - 17) * this.field_147067_x), 232 + (this.func_147055_p() ? 0 : 12), 0, 12, 15);
        }
        this.func_147051_a(itemGroup);
        if (itemGroup == ItemGroup.field_78036_m) {
            InventoryScreen.func_228187_a_(this.field_147003_i + 88, this.field_147009_r + 45, 20, this.field_147003_i + 88 - n, this.field_147009_r + 45 - 30 - n2, this.minecraft.field_71439_g);
        }
    }

    protected boolean func_195375_a(ItemGroup itemGroup, double d, double d2) {
        int n = itemGroup.func_78020_k();
        \u2603 = 28 * n;
        \u2603 = 0;
        if (itemGroup.func_192394_m()) {
            \u2603 = this.field_146999_f - 28 * (6 - n) + 2;
        } else if (n > 0) {
            \u2603 += n;
        }
        \u2603 = itemGroup.func_78023_l() ? (\u2603 -= 32) : (\u2603 += this.field_147000_g);
        return d >= (double)\u2603 && d <= (double)(\u2603 + 28) && d2 >= (double)\u2603 && d2 <= (double)(\u2603 + 32);
    }

    protected boolean func_147052_b(ItemGroup itemGroup, int n, int n2) {
        \u2603 = itemGroup.func_78020_k();
        \u2603 = 28 * \u2603;
        \u2603 = 0;
        if (itemGroup.func_192394_m()) {
            \u2603 = this.field_146999_f - 28 * (6 - \u2603) + 2;
        } else if (\u2603 > 0) {
            \u2603 += \u2603;
        }
        \u2603 = itemGroup.func_78023_l() ? (\u2603 -= 32) : (\u2603 += this.field_147000_g);
        if (this.func_195359_a(\u2603 + 3, \u2603 + 3, 23, 27, n, n2)) {
            this.renderTooltip(I18n.func_135052_a(itemGroup.func_78024_c(), new Object[0]), n, n2);
            return true;
        }
        return false;
    }

    protected void func_147051_a(ItemGroup itemGroup) {
        boolean bl = itemGroup.func_78021_a() == field_147058_w;
        \u2603 = itemGroup.func_78023_l();
        int \u26032 = itemGroup.func_78020_k();
        int \u26033 = \u26032 * 28;
        int \u26034 = 0;
        int \u26035 = this.field_147003_i + 28 * \u26032;
        int \u26036 = this.field_147009_r;
        int \u26037 = 32;
        if (bl) {
            \u26034 += 32;
        }
        if (itemGroup.func_192394_m()) {
            \u26035 = this.field_147003_i + this.field_146999_f - 28 * (6 - \u26032);
        } else if (\u26032 > 0) {
            \u26035 += \u26032;
        }
        if (\u2603) {
            \u26036 -= 28;
        } else {
            \u26034 += 64;
            \u26036 += this.field_147000_g - 4;
        }
        this.blit(\u26035, \u26036, \u26033, \u26034, 28, 32);
        this.setBlitOffset(100);
        this.itemRenderer.field_77023_b = 100.0f;
        int n = \u2603 ? 1 : -1;
        RenderSystem.enableRescaleNormal();
        ItemStack \u26038 = itemGroup.func_151244_d();
        this.itemRenderer.func_180450_b(\u26038, \u26035 += 6, \u26036 += 8 + n);
        this.itemRenderer.func_175030_a(this.font, \u26038, \u26035, \u26036);
        this.itemRenderer.field_77023_b = 0.0f;
        this.setBlitOffset(0);
    }

    public int func_147056_g() {
        return field_147058_w;
    }

    public static void func_192044_a(Minecraft minecraft2, int n, boolean bl, boolean bl22) {
        boolean bl22;
        ClientPlayerEntity clientPlayerEntity = minecraft2.field_71439_g;
        CreativeSettings \u26032 = minecraft2.func_199403_al();
        HotbarSnapshot \u26033 = \u26032.func_192563_a(n);
        if (bl) {
            for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
                ItemStack itemStack = ((ItemStack)\u26033.get(i)).func_77946_l();
                clientPlayerEntity.field_71071_by.func_70299_a(i, itemStack);
                minecraft2.field_71442_b.func_78761_a(itemStack, 36 + i);
            }
            clientPlayerEntity.field_71069_bz.func_75142_b();
        } else if (bl22) {
            Minecraft minecraft2;
            for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
                \u26033.set(i, clientPlayerEntity.field_71071_by.func_70301_a(i).func_77946_l());
            }
            String \u26034 = minecraft2.field_71474_y.field_151456_ac[n].func_197978_k();
            String \u26035 = minecraft2.field_71474_y.field_193630_aq.func_197978_k();
            minecraft2.field_71456_v.func_175188_a(new TranslationTextComponent("inventory.hotbarSaved", \u26035, \u26034), false);
            \u26032.func_192564_b();
        }
    }

    private /* synthetic */ void func_214082_a(TagCollection tagCollection, ResourceLocation resourceLocation) {
        this.field_214085_w.put(resourceLocation, tagCollection.func_199910_a(resourceLocation));
    }

    private static /* synthetic */ boolean func_214081_a(String string, String string2, ResourceLocation resourceLocation) {
        return resourceLocation.func_110624_b().contains(string) && resourceLocation.func_110623_a().contains(string2);
    }

    static class LockedSlot
    extends Slot {
        public LockedSlot(IInventory iInventory, int n, int n2, int n3) {
            super(iInventory, n, n2, n3);
        }

        @Override
        public boolean func_82869_a(PlayerEntity playerEntity) {
            if (super.func_82869_a(playerEntity) && this.func_75216_d()) {
                return this.func_75211_c().func_179543_a("CustomCreativeLock") == null;
            }
            return !this.func_75216_d();
        }
    }

    static class CreativeSlot
    extends Slot {
        private final Slot field_148332_b;

        public CreativeSlot(Slot slot, int n, int n2, int n3) {
            super(slot.field_75224_c, n, n2, n3);
            this.field_148332_b = slot;
        }

        @Override
        public ItemStack func_190901_a(PlayerEntity playerEntity, ItemStack itemStack) {
            return this.field_148332_b.func_190901_a(playerEntity, itemStack);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return this.field_148332_b.func_75214_a(itemStack);
        }

        @Override
        public ItemStack func_75211_c() {
            return this.field_148332_b.func_75211_c();
        }

        @Override
        public boolean func_75216_d() {
            return this.field_148332_b.func_75216_d();
        }

        @Override
        public void func_75215_d(ItemStack itemStack) {
            this.field_148332_b.func_75215_d(itemStack);
        }

        @Override
        public void func_75218_e() {
            this.field_148332_b.func_75218_e();
        }

        @Override
        public int func_75219_a() {
            return this.field_148332_b.func_75219_a();
        }

        @Override
        public int func_178170_b(ItemStack itemStack) {
            return this.field_148332_b.func_178170_b(itemStack);
        }

        @Override
        @Nullable
        public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
            return this.field_148332_b.func_225517_c_();
        }

        @Override
        public ItemStack func_75209_a(int n) {
            return this.field_148332_b.func_75209_a(n);
        }

        @Override
        public boolean func_111238_b() {
            return this.field_148332_b.func_111238_b();
        }

        @Override
        public boolean func_82869_a(PlayerEntity playerEntity) {
            return this.field_148332_b.func_82869_a(playerEntity);
        }
    }

    public static class CreativeContainer
    extends Container {
        public final NonNullList<ItemStack> field_148330_a = NonNullList.func_191196_a();

        public CreativeContainer(PlayerEntity playerEntity) {
            super(null, 0);
            int n;
            PlayerInventory playerInventory = playerEntity.field_71071_by;
            for (n = 0; n < 5; ++n) {
                for (\u2603 = 0; \u2603 < 9; ++\u2603) {
                    this.func_75146_a(new LockedSlot(field_195378_x, n * 9 + \u2603, 9 + \u2603 * 18, 18 + n * 18));
                }
            }
            for (n = 0; n < 9; ++n) {
                this.func_75146_a(new Slot(playerInventory, n, 9 + n * 18, 112));
            }
            this.func_148329_a(0.0f);
        }

        @Override
        public boolean func_75145_c(PlayerEntity playerEntity) {
            return true;
        }

        public void func_148329_a(float f) {
            int n = (this.field_148330_a.size() + 9 - 1) / 9 - 5;
            \u2603 = (int)((double)(f * (float)n) + 0.5);
            if (\u2603 < 0) {
                \u2603 = 0;
            }
            for (\u2603 = 0; \u2603 < 5; ++\u2603) {
                for (\u2603 = 0; \u2603 < 9; ++\u2603) {
                    \u2603 = \u2603 + (\u2603 + \u2603) * 9;
                    if (\u2603 >= 0 && \u2603 < this.field_148330_a.size()) {
                        field_195378_x.func_70299_a(\u2603 + \u2603 * 9, this.field_148330_a.get(\u2603));
                        continue;
                    }
                    field_195378_x.func_70299_a(\u2603 + \u2603 * 9, ItemStack.field_190927_a);
                }
            }
        }

        public boolean func_148328_e() {
            return this.field_148330_a.size() > 45;
        }

        @Override
        public ItemStack func_82846_b(PlayerEntity playerEntity, int n) {
            if (n >= this.field_75151_b.size() - 9 && n < this.field_75151_b.size() && (\u2603 = (Slot)this.field_75151_b.get(n)) != null && \u2603.func_75216_d()) {
                \u2603.func_75215_d(ItemStack.field_190927_a);
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public boolean func_94530_a(ItemStack itemStack, Slot slot) {
            return slot.field_75224_c != field_195378_x;
        }

        @Override
        public boolean func_94531_b(Slot slot) {
            return slot.field_75224_c != field_195378_x;
        }
    }
}

