/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.network.play;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.Block;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.BeeAngrySound;
import net.minecraft.client.audio.BeeFlightSound;
import net.minecraft.client.audio.BeeSound;
import net.minecraft.client.audio.GuardianSound;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MinecartTickableSound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.gui.IProgressMeter;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.client.gui.screen.CommandBlockScreen;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.gui.screen.DemoScreen;
import net.minecraft.client.gui.screen.DisconnectedScreen;
import net.minecraft.client.gui.screen.DownloadTerrainScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.ReadBookScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WinGameScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.HorseInventoryScreen;
import net.minecraft.client.gui.toasts.RecipeToast;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.particle.ItemPickupParticle;
import net.minecraft.client.renderer.debug.BeeDebugRenderer;
import net.minecraft.client.renderer.debug.EntityAIDebugRenderer;
import net.minecraft.client.renderer.debug.NeighborsUpdateDebugRenderer;
import net.minecraft.client.renderer.debug.PointOfInterestDebugRenderer;
import net.minecraft.client.renderer.debug.WorldGenAttemptsDebugRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ClientRecipeBook;
import net.minecraft.client.util.IMutableSearchTree;
import net.minecraft.client.util.NBTQueryManager;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.dispenser.Position;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.ExperienceBottleEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.EyeOfEnderEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.entity.item.minecart.HopperMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartCommandBlockEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.item.minecart.SpawnerMinecartEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.DragonFireballEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.HorseInventoryContainer;
import net.minecraft.inventory.container.MerchantContainer;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.PacketThreadUtil;
import net.minecraft.network.play.client.CClientStatusPacket;
import net.minecraft.network.play.client.CConfirmTeleportPacket;
import net.minecraft.network.play.client.CConfirmTransactionPacket;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.client.CKeepAlivePacket;
import net.minecraft.network.play.client.CMoveVehiclePacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.client.CResourcePackStatusPacket;
import net.minecraft.network.play.server.SAdvancementInfoPacket;
import net.minecraft.network.play.server.SAnimateBlockBreakPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.network.play.server.SBlockActionPacket;
import net.minecraft.network.play.server.SCameraPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SCloseWindowPacket;
import net.minecraft.network.play.server.SCollectItemPacket;
import net.minecraft.network.play.server.SCombatPacket;
import net.minecraft.network.play.server.SCommandListPacket;
import net.minecraft.network.play.server.SConfirmTransactionPacket;
import net.minecraft.network.play.server.SCooldownPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.network.play.server.SDestroyEntitiesPacket;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.network.play.server.SDisplayObjectivePacket;
import net.minecraft.network.play.server.SEntityEquipmentPacket;
import net.minecraft.network.play.server.SEntityHeadLookPacket;
import net.minecraft.network.play.server.SEntityMetadataPacket;
import net.minecraft.network.play.server.SEntityPacket;
import net.minecraft.network.play.server.SEntityPropertiesPacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SEntityTeleportPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.network.play.server.SJoinGamePacket;
import net.minecraft.network.play.server.SKeepAlivePacket;
import net.minecraft.network.play.server.SMapDataPacket;
import net.minecraft.network.play.server.SMerchantOffersPacket;
import net.minecraft.network.play.server.SMountEntityPacket;
import net.minecraft.network.play.server.SMoveVehiclePacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.network.play.server.SOpenBookWindowPacket;
import net.minecraft.network.play.server.SOpenHorseWindowPacket;
import net.minecraft.network.play.server.SOpenSignMenuPacket;
import net.minecraft.network.play.server.SOpenWindowPacket;
import net.minecraft.network.play.server.SPlaceGhostRecipePacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SPlayerDiggingPacket;
import net.minecraft.network.play.server.SPlayerListHeaderFooterPacket;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.network.play.server.SPlayerLookPacket;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.network.play.server.SQueryNBTResponsePacket;
import net.minecraft.network.play.server.SRecipeBookPacket;
import net.minecraft.network.play.server.SRemoveEntityEffectPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SScoreboardObjectivePacket;
import net.minecraft.network.play.server.SSelectAdvancementsTabPacket;
import net.minecraft.network.play.server.SSendResourcePackPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetExperiencePacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.network.play.server.SSpawnExperienceOrbPacket;
import net.minecraft.network.play.server.SSpawnGlobalEntityPacket;
import net.minecraft.network.play.server.SSpawnMobPacket;
import net.minecraft.network.play.server.SSpawnMovingSoundEffectPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.network.play.server.SSpawnPaintingPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.network.play.server.SSpawnPlayerPacket;
import net.minecraft.network.play.server.SSpawnPositionPacket;
import net.minecraft.network.play.server.SStatisticsPacket;
import net.minecraft.network.play.server.SStopSoundPacket;
import net.minecraft.network.play.server.STabCompletePacket;
import net.minecraft.network.play.server.STagsListPacket;
import net.minecraft.network.play.server.STeamsPacket;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.network.play.server.SUnloadChunkPacket;
import net.minecraft.network.play.server.SUpdateBossInfoPacket;
import net.minecraft.network.play.server.SUpdateChunkPositionPacket;
import net.minecraft.network.play.server.SUpdateHealthPacket;
import net.minecraft.network.play.server.SUpdateLightPacket;
import net.minecraft.network.play.server.SUpdateRecipesPacket;
import net.minecraft.network.play.server.SUpdateScorePacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.network.play.server.SUpdateTimePacket;
import net.minecraft.network.play.server.SUpdateViewDistancePacket;
import net.minecraft.network.play.server.SWindowItemsPacket;
import net.minecraft.network.play.server.SWindowPropertyPacket;
import net.minecraft.network.play.server.SWorldBorderPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.Path;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.realms.DisconnectedRealmsScreen;
import net.minecraft.realms.RealmsScreenProxy;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.tileentity.BedTileEntity;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.CampfireTileEntity;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.ConduitTileEntity;
import net.minecraft.tileentity.EndGatewayTileEntity;
import net.minecraft.tileentity.JigsawTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.LightType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.storage.MapData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientPlayNetHandler
implements IClientPlayNetHandler {
    private static final Logger field_147301_d = LogManager.getLogger();
    private final NetworkManager field_147302_e;
    private final GameProfile field_175107_d;
    private final Screen field_147307_j;
    private Minecraft field_147299_f;
    private ClientWorld field_147300_g;
    private boolean field_147309_h;
    private final Map<UUID, NetworkPlayerInfo> field_147310_i = Maps.newHashMap();
    private final ClientAdvancementManager field_191983_k;
    private final ClientSuggestionProvider field_195516_l;
    private NetworkTagManager field_199725_m = new NetworkTagManager();
    private final NBTQueryManager field_211524_l = new NBTQueryManager(this);
    private int field_217287_m = 3;
    private final Random field_147306_l = new Random();
    private CommandDispatcher<ISuggestionProvider> field_195517_n = new CommandDispatcher();
    private final RecipeManager field_199528_o = new RecipeManager();
    private final UUID field_217289_q = UUID.randomUUID();

    public ClientPlayNetHandler(Minecraft minecraft, Screen screen, NetworkManager networkManager, GameProfile gameProfile) {
        this.field_147299_f = minecraft;
        this.field_147307_j = screen;
        this.field_147302_e = networkManager;
        this.field_175107_d = gameProfile;
        this.field_191983_k = new ClientAdvancementManager(minecraft);
        this.field_195516_l = new ClientSuggestionProvider(this, minecraft);
    }

    public ClientSuggestionProvider func_195513_b() {
        return this.field_195516_l;
    }

    public void func_147296_c() {
        this.field_147300_g = null;
    }

    public RecipeManager func_199526_e() {
        return this.field_199528_o;
    }

    @Override
    public void func_147282_a(SJoinGamePacket sJoinGamePacket) {
        PacketThreadUtil.func_218797_a(sJoinGamePacket, this, this.field_147299_f);
        this.field_147299_f.field_71442_b = new PlayerController(this.field_147299_f, this);
        this.field_217287_m = sJoinGamePacket.func_218728_h();
        this.field_147300_g = new ClientWorld(this, new WorldSettings(sJoinGamePacket.func_229742_c_(), sJoinGamePacket.func_149198_e(), false, sJoinGamePacket.func_149195_d(), sJoinGamePacket.func_149196_i()), sJoinGamePacket.func_212642_e(), this.field_217287_m, this.field_147299_f.func_213239_aq(), this.field_147299_f.field_71438_f);
        this.field_147299_f.func_71403_a(this.field_147300_g);
        if (this.field_147299_f.field_71439_g == null) {
            this.field_147299_f.field_71439_g = this.field_147299_f.field_71442_b.func_199681_a(this.field_147300_g, new StatisticsManager(), new ClientRecipeBook(this.field_147300_g.func_199532_z()));
            this.field_147299_f.field_71439_g.field_70177_z = -180.0f;
            if (this.field_147299_f.func_71401_C() != null) {
                this.field_147299_f.func_71401_C().func_211527_b(this.field_147299_f.field_71439_g.func_110124_au());
            }
        }
        this.field_147299_f.field_184132_p.func_217737_a();
        this.field_147299_f.field_71439_g.func_70065_x();
        int n = sJoinGamePacket.func_149197_c();
        this.field_147300_g.func_217408_a(n, this.field_147299_f.field_71439_g);
        this.field_147299_f.field_71439_g.field_71158_b = new MovementInputFromOptions(this.field_147299_f.field_71474_y);
        this.field_147299_f.field_71442_b.func_78748_a(this.field_147299_f.field_71439_g);
        this.field_147299_f.field_175622_Z = this.field_147299_f.field_71439_g;
        this.field_147299_f.field_71439_g.field_71093_bK = sJoinGamePacket.func_212642_e();
        this.field_147299_f.func_147108_a(new DownloadTerrainScreen());
        this.field_147299_f.field_71439_g.func_145769_d(n);
        this.field_147299_f.field_71439_g.func_175150_k(sJoinGamePacket.func_179744_h());
        this.field_147299_f.field_71439_g.func_228355_a_(sJoinGamePacket.func_229743_k_());
        this.field_147299_f.field_71442_b.func_78746_a(sJoinGamePacket.func_149198_e());
        this.field_147299_f.field_71474_y.func_82879_c();
        this.field_147302_e.func_179290_a(new CCustomPayloadPacket(CCustomPayloadPacket.field_210344_a, new PacketBuffer(Unpooled.buffer()).func_180714_a(ClientBrandRetriever.getClientModName())));
        this.field_147299_f.func_213229_ar().func_216814_a();
    }

    @Override
    public void func_147235_a(SSpawnObjectPacket sSpawnObjectPacket) {
        Entity \u26034;
        Entity \u26033;
        PacketThreadUtil.func_218797_a(sSpawnObjectPacket, this, this.field_147299_f);
        double d = sSpawnObjectPacket.func_186880_c();
        \u2603 = sSpawnObjectPacket.func_186882_d();
        \u2603 = sSpawnObjectPacket.func_186881_e();
        EntityType<?> \u26032 = sSpawnObjectPacket.func_218694_l();
        if (\u26032 == EntityType.field_200773_M) {
            \u26033 = new ChestMinecartEntity(this.field_147300_g, d, \u2603, \u2603);
        } else if (\u26032 == EntityType.field_200775_O) {
            \u26033 = new FurnaceMinecartEntity(this.field_147300_g, d, \u2603, \u2603);
        } else if (\u26032 == EntityType.field_200778_R) {
            \u26033 = new TNTMinecartEntity(this.field_147300_g, d, \u2603, \u2603);
        } else if (\u26032 == EntityType.field_200777_Q) {
            \u26033 = new SpawnerMinecartEntity(this.field_147300_g, d, \u2603, \u2603);
        } else if (\u26032 == EntityType.field_200776_P) {
            \u26033 = new HopperMinecartEntity(this.field_147300_g, d, \u2603, \u2603);
        } else if (\u26032 == EntityType.field_200774_N) {
            \u26033 = new MinecartCommandBlockEntity(this.field_147300_g, d, \u2603, \u2603);
        } else if (\u26032 == EntityType.field_200772_L) {
            \u26033 = new MinecartEntity(this.field_147300_g, d, \u2603, \u2603);
        } else if (\u26032 == EntityType.field_200730_aI) {
            \u26034 = this.field_147300_g.func_73045_a(sSpawnObjectPacket.func_149009_m());
            \u26033 = \u26034 instanceof PlayerEntity ? new FishingBobberEntity(this.field_147300_g, (PlayerEntity)\u26034, d, \u2603, \u2603) : null;
        } else if (\u26032 == EntityType.field_200790_d) {
            \u26033 = new ArrowEntity(this.field_147300_g, d, \u2603, \u2603);
            \u26034 = this.field_147300_g.func_73045_a(sSpawnObjectPacket.func_149009_m());
            if (\u26034 != null) {
                ((AbstractArrowEntity)\u26033).func_212361_a(\u26034);
            }
        } else if (\u26032 == EntityType.field_200747_am) {
            \u26033 = new SpectralArrowEntity(this.field_147300_g, d, \u2603, \u2603);
            \u26034 = this.field_147300_g.func_73045_a(sSpawnObjectPacket.func_149009_m());
            if (\u26034 != null) {
                ((AbstractArrowEntity)\u26033).func_212361_a(\u26034);
            }
        } else if (\u26032 == EntityType.field_203098_aL) {
            \u26033 = new TridentEntity(this.field_147300_g, d, \u2603, \u2603);
            \u26034 = this.field_147300_g.func_73045_a(sSpawnObjectPacket.func_149009_m());
            if (\u26034 != null) {
                ((AbstractArrowEntity)\u26033).func_212361_a(\u26034);
            }
        } else {
            \u26033 = \u26032 == EntityType.field_200746_al ? new SnowballEntity(this.field_147300_g, d, \u2603, \u2603) : (\u26032 == EntityType.field_200770_J ? new LlamaSpitEntity(this.field_147300_g, d, \u2603, \u2603, sSpawnObjectPacket.func_218693_g(), sSpawnObjectPacket.func_218695_h(), sSpawnObjectPacket.func_218692_i()) : (\u26032 == EntityType.field_200766_F ? new ItemFrameEntity(this.field_147300_g, new BlockPos(d, \u2603, \u2603), Direction.func_82600_a(sSpawnObjectPacket.func_149009_m())) : (\u26032 == EntityType.field_200768_H ? new LeashKnotEntity(this.field_147300_g, new BlockPos(d, \u2603, \u2603)) : (\u26032 == EntityType.field_200752_ar ? new EnderPearlEntity(this.field_147300_g, d, \u2603, \u2603) : (\u26032 == EntityType.field_200808_v ? new EyeOfEnderEntity(this.field_147300_g, d, \u2603, \u2603) : (\u26032 == EntityType.field_200810_x ? new FireworkRocketEntity(this.field_147300_g, d, \u2603, \u2603, ItemStack.field_190927_a) : (\u26032 == EntityType.field_200767_G ? new FireballEntity(this.field_147300_g, d, \u2603, \u2603, sSpawnObjectPacket.func_218693_g(), sSpawnObjectPacket.func_218695_h(), sSpawnObjectPacket.func_218692_i()) : (\u26032 == EntityType.field_200799_m ? new DragonFireballEntity(this.field_147300_g, d, \u2603, \u2603, sSpawnObjectPacket.func_218693_g(), sSpawnObjectPacket.func_218695_h(), sSpawnObjectPacket.func_218692_i()) : (\u26032 == EntityType.field_200744_aj ? new SmallFireballEntity(this.field_147300_g, d, \u2603, \u2603, sSpawnObjectPacket.func_218693_g(), sSpawnObjectPacket.func_218695_h(), sSpawnObjectPacket.func_218692_i()) : (\u26032 == EntityType.field_200723_aB ? new WitherSkullEntity(this.field_147300_g, d, \u2603, \u2603, sSpawnObjectPacket.func_218693_g(), sSpawnObjectPacket.func_218695_h(), sSpawnObjectPacket.func_218692_i()) : (\u26032 == EntityType.field_200739_ae ? new ShulkerBulletEntity(this.field_147300_g, d, \u2603, \u2603, sSpawnObjectPacket.func_218693_g(), sSpawnObjectPacket.func_218695_h(), sSpawnObjectPacket.func_218692_i()) : (\u26032 == EntityType.field_200751_aq ? new EggEntity(this.field_147300_g, d, \u2603, \u2603) : (\u26032 == EntityType.field_200805_s ? new EvokerFangsEntity(this.field_147300_g, d, \u2603, \u2603, 0.0f, 0, null) : (\u26032 == EntityType.field_200754_at ? new PotionEntity(this.field_147300_g, d, \u2603, \u2603) : (\u26032 == EntityType.field_200753_as ? new ExperienceBottleEntity(this.field_147300_g, d, \u2603, \u2603) : (\u26032 == EntityType.field_200793_g ? new BoatEntity(this.field_147300_g, d, \u2603, \u2603) : (\u26032 == EntityType.field_200735_aa ? new TNTEntity(this.field_147300_g, d, \u2603, \u2603, null) : (\u26032 == EntityType.field_200789_c ? new ArmorStandEntity(this.field_147300_g, d, \u2603, \u2603) : (\u26032 == EntityType.field_200801_o ? new EnderCrystalEntity(this.field_147300_g, d, \u2603, \u2603) : (\u26032 == EntityType.field_200765_E ? new ItemEntity(this.field_147300_g, d, \u2603, \u2603) : (\u26032 == EntityType.field_200809_w ? new FallingBlockEntity(this.field_147300_g, d, \u2603, \u2603, Block.func_196257_b(sSpawnObjectPacket.func_149009_m())) : (\u26032 == EntityType.field_200788_b ? new AreaEffectCloudEntity(this.field_147300_g, d, \u2603, \u2603) : null))))))))))))))))))))));
        }
        if (\u26033 != null) {
            int \u26035 = sSpawnObjectPacket.func_149001_c();
            \u26033.func_213312_b(d, \u2603, \u2603);
            \u26033.field_70125_A = (float)(sSpawnObjectPacket.func_149008_j() * 360) / 256.0f;
            \u26033.field_70177_z = (float)(sSpawnObjectPacket.func_149006_k() * 360) / 256.0f;
            \u26033.func_145769_d(\u26035);
            \u26033.func_184221_a(sSpawnObjectPacket.func_186879_b());
            this.field_147300_g.func_217411_a(\u26035, \u26033);
            if (\u26033 instanceof AbstractMinecartEntity) {
                this.field_147299_f.func_147118_V().func_147682_a(new MinecartTickableSound((AbstractMinecartEntity)\u26033));
            }
        }
    }

    @Override
    public void func_147286_a(SSpawnExperienceOrbPacket sSpawnExperienceOrbPacket) {
        PacketThreadUtil.func_218797_a(sSpawnExperienceOrbPacket, this, this.field_147299_f);
        double d = sSpawnExperienceOrbPacket.func_186885_b();
        \u2603 = sSpawnExperienceOrbPacket.func_186886_c();
        \u2603 = sSpawnExperienceOrbPacket.func_186884_d();
        ExperienceOrbEntity \u26032 = new ExperienceOrbEntity(this.field_147300_g, d, \u2603, \u2603, sSpawnExperienceOrbPacket.func_148986_g());
        \u26032.func_213312_b(d, \u2603, \u2603);
        \u26032.field_70177_z = 0.0f;
        \u26032.field_70125_A = 0.0f;
        \u26032.func_145769_d(sSpawnExperienceOrbPacket.func_148985_c());
        this.field_147300_g.func_217411_a(sSpawnExperienceOrbPacket.func_148985_c(), \u26032);
    }

    @Override
    public void func_147292_a(SSpawnGlobalEntityPacket sSpawnGlobalEntityPacket) {
        PacketThreadUtil.func_218797_a(sSpawnGlobalEntityPacket, this, this.field_147299_f);
        double d = sSpawnGlobalEntityPacket.func_186888_b();
        \u2603 = sSpawnGlobalEntityPacket.func_186889_c();
        \u2603 = sSpawnGlobalEntityPacket.func_186887_d();
        if (sSpawnGlobalEntityPacket.func_149053_g() == 1) {
            LightningBoltEntity lightningBoltEntity = new LightningBoltEntity(this.field_147300_g, d, \u2603, \u2603, false);
            lightningBoltEntity.func_213312_b(d, \u2603, \u2603);
            lightningBoltEntity.field_70177_z = 0.0f;
            lightningBoltEntity.field_70125_A = 0.0f;
            lightningBoltEntity.func_145769_d(sSpawnGlobalEntityPacket.func_149052_c());
            this.field_147300_g.func_217410_a(lightningBoltEntity);
        }
    }

    @Override
    public void func_147288_a(SSpawnPaintingPacket sSpawnPaintingPacket) {
        PacketThreadUtil.func_218797_a(sSpawnPaintingPacket, this, this.field_147299_f);
        PaintingEntity paintingEntity = new PaintingEntity(this.field_147300_g, sSpawnPaintingPacket.func_179837_b(), sSpawnPaintingPacket.func_179836_c(), sSpawnPaintingPacket.func_201063_e());
        paintingEntity.func_145769_d(sSpawnPaintingPacket.func_148965_c());
        paintingEntity.func_184221_a(sSpawnPaintingPacket.func_186895_b());
        this.field_147300_g.func_217411_a(sSpawnPaintingPacket.func_148965_c(), paintingEntity);
    }

    @Override
    public void func_147244_a(SEntityVelocityPacket sEntityVelocityPacket) {
        PacketThreadUtil.func_218797_a(sEntityVelocityPacket, this, this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(sEntityVelocityPacket.func_149412_c());
        if (entity == null) {
            return;
        }
        entity.func_70016_h((double)sEntityVelocityPacket.func_149411_d() / 8000.0, (double)sEntityVelocityPacket.func_149410_e() / 8000.0, (double)sEntityVelocityPacket.func_149409_f() / 8000.0);
    }

    @Override
    public void func_147284_a(SEntityMetadataPacket sEntityMetadataPacket) {
        PacketThreadUtil.func_218797_a(sEntityMetadataPacket, this, this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(sEntityMetadataPacket.func_149375_d());
        if (entity != null && sEntityMetadataPacket.func_149376_c() != null) {
            entity.func_184212_Q().func_187218_a(sEntityMetadataPacket.func_149376_c());
        }
    }

    @Override
    public void func_147237_a(SSpawnPlayerPacket sSpawnPlayerPacket) {
        PacketThreadUtil.func_218797_a(sSpawnPlayerPacket, this, this.field_147299_f);
        double d = sSpawnPlayerPacket.func_186898_d();
        \u2603 = sSpawnPlayerPacket.func_186897_e();
        \u2603 = sSpawnPlayerPacket.func_186899_f();
        float \u26032 = (float)(sSpawnPlayerPacket.func_148941_i() * 360) / 256.0f;
        float \u26033 = (float)(sSpawnPlayerPacket.func_148945_j() * 360) / 256.0f;
        int \u26034 = sSpawnPlayerPacket.func_148943_d();
        RemoteClientPlayerEntity \u26035 = new RemoteClientPlayerEntity(this.field_147299_f.field_71441_e, this.func_175102_a(sSpawnPlayerPacket.func_179819_c()).func_178845_a());
        \u26035.func_145769_d(\u26034);
        \u26035.func_226286_f_(d, \u2603, \u2603);
        \u26035.func_213312_b(d, \u2603, \u2603);
        \u26035.func_70080_a(d, \u2603, \u2603, \u26032, \u26033);
        this.field_147300_g.func_217408_a(\u26034, \u26035);
    }

    @Override
    public void func_147275_a(SEntityTeleportPacket sEntityTeleportPacket) {
        PacketThreadUtil.func_218797_a(sEntityTeleportPacket, this, this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(sEntityTeleportPacket.func_149451_c());
        if (entity == null) {
            return;
        }
        double \u26032 = sEntityTeleportPacket.func_186982_b();
        double \u26033 = sEntityTeleportPacket.func_186983_c();
        double \u26034 = sEntityTeleportPacket.func_186981_d();
        entity.func_213312_b(\u26032, \u26033, \u26034);
        if (!entity.func_184186_bw()) {
            float f = (float)(sEntityTeleportPacket.func_149450_g() * 360) / 256.0f;
            \u2603 = (float)(sEntityTeleportPacket.func_149447_h() * 360) / 256.0f;
            if (Math.abs(entity.func_226277_ct_() - \u26032) >= 0.03125 || Math.abs(entity.func_226278_cu_() - \u26033) >= 0.015625 || Math.abs(entity.func_226281_cx_() - \u26034) >= 0.03125) {
                entity.func_180426_a(\u26032, \u26033, \u26034, f, \u2603, 3, true);
            } else {
                entity.func_180426_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), f, \u2603, 3, true);
            }
            entity.field_70122_E = sEntityTeleportPacket.func_179697_g();
        }
    }

    @Override
    public void func_147257_a(SHeldItemChangePacket sHeldItemChangePacket) {
        PacketThreadUtil.func_218797_a(sHeldItemChangePacket, this, this.field_147299_f);
        if (PlayerInventory.func_184435_e(sHeldItemChangePacket.func_149385_c())) {
            this.field_147299_f.field_71439_g.field_71071_by.field_70461_c = sHeldItemChangePacket.func_149385_c();
        }
    }

    @Override
    public void func_147259_a(SEntityPacket sEntityPacket) {
        PacketThreadUtil.func_218797_a(sEntityPacket, this, this.field_147299_f);
        Entity entity = sEntityPacket.func_149065_a(this.field_147300_g);
        if (entity == null) {
            return;
        }
        if (!entity.func_184186_bw()) {
            if (sEntityPacket.func_229745_h_()) {
                entity.field_70118_ct += (long)sEntityPacket.func_186952_a();
                entity.field_70117_cu += (long)sEntityPacket.func_186953_b();
                entity.field_70116_cv += (long)sEntityPacket.func_186951_c();
                Vec3d vec3d = SEntityPacket.func_218744_a(entity.field_70118_ct, entity.field_70117_cu, entity.field_70116_cv);
                float \u26032 = sEntityPacket.func_149060_h() ? (float)(sEntityPacket.func_149066_f() * 360) / 256.0f : entity.field_70177_z;
                float \u26033 = sEntityPacket.func_149060_h() ? (float)(sEntityPacket.func_149063_g() * 360) / 256.0f : entity.field_70125_A;
                entity.func_180426_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, \u26032, \u26033, 3, false);
            } else if (sEntityPacket.func_149060_h()) {
                float \u26034 = (float)(sEntityPacket.func_149066_f() * 360) / 256.0f;
                float \u26035 = (float)(sEntityPacket.func_149063_g() * 360) / 256.0f;
                entity.func_180426_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), \u26034, \u26035, 3, false);
            }
            entity.field_70122_E = sEntityPacket.func_179742_g();
        }
    }

    @Override
    public void func_147267_a(SEntityHeadLookPacket sEntityHeadLookPacket) {
        PacketThreadUtil.func_218797_a(sEntityHeadLookPacket, this, this.field_147299_f);
        Entity entity = sEntityHeadLookPacket.func_149381_a(this.field_147300_g);
        if (entity == null) {
            return;
        }
        float \u26032 = (float)(sEntityHeadLookPacket.func_149380_c() * 360) / 256.0f;
        entity.func_208000_a(\u26032, 3);
    }

    @Override
    public void func_147238_a(SDestroyEntitiesPacket sDestroyEntitiesPacket) {
        PacketThreadUtil.func_218797_a(sDestroyEntitiesPacket, this, this.field_147299_f);
        for (int i = 0; i < sDestroyEntitiesPacket.func_149098_c().length; ++i) {
            \u2603 = sDestroyEntitiesPacket.func_149098_c()[i];
            this.field_147300_g.func_217413_d(\u2603);
        }
    }

    @Override
    public void func_184330_a(SPlayerPositionLookPacket sPlayerPositionLookPacket) {
        double d;
        double d2;
        double d3;
        PacketThreadUtil.func_218797_a(sPlayerPositionLookPacket, this, this.field_147299_f);
        ClientPlayerEntity clientPlayerEntity = this.field_147299_f.field_71439_g;
        Vec3d \u26032 = clientPlayerEntity.func_213322_ci();
        boolean \u26033 = sPlayerPositionLookPacket.func_179834_f().contains((Object)SPlayerPositionLookPacket.Flags.X);
        boolean \u26034 = sPlayerPositionLookPacket.func_179834_f().contains((Object)SPlayerPositionLookPacket.Flags.Y);
        boolean \u26035 = sPlayerPositionLookPacket.func_179834_f().contains((Object)SPlayerPositionLookPacket.Flags.Z);
        if (\u26033) {
            d3 = \u26032.func_82615_a();
            \u2603 = clientPlayerEntity.func_226277_ct_() + sPlayerPositionLookPacket.func_148932_c();
            clientPlayerEntity.field_70142_S += sPlayerPositionLookPacket.func_148932_c();
        } else {
            d3 = 0.0;
            clientPlayerEntity.field_70142_S = \u2603 = sPlayerPositionLookPacket.func_148932_c();
        }
        if (\u26034) {
            d2 = \u26032.func_82617_b();
            \u2603 = clientPlayerEntity.func_226278_cu_() + sPlayerPositionLookPacket.func_148928_d();
            clientPlayerEntity.field_70137_T += sPlayerPositionLookPacket.func_148928_d();
        } else {
            d2 = 0.0;
            clientPlayerEntity.field_70137_T = \u2603 = sPlayerPositionLookPacket.func_148928_d();
        }
        if (\u26035) {
            d = \u26032.func_82616_c();
            \u2603 = clientPlayerEntity.func_226281_cx_() + sPlayerPositionLookPacket.func_148933_e();
            clientPlayerEntity.field_70136_U += sPlayerPositionLookPacket.func_148933_e();
        } else {
            d = 0.0;
            clientPlayerEntity.field_70136_U = \u2603 = sPlayerPositionLookPacket.func_148933_e();
        }
        clientPlayerEntity.func_226288_n_(\u2603, \u2603, \u2603);
        clientPlayerEntity.field_70169_q = \u2603;
        clientPlayerEntity.field_70167_r = \u2603;
        clientPlayerEntity.field_70166_s = \u2603;
        clientPlayerEntity.func_213293_j(d3, d2, d);
        float \u26036 = sPlayerPositionLookPacket.func_148931_f();
        float \u26037 = sPlayerPositionLookPacket.func_148930_g();
        if (sPlayerPositionLookPacket.func_179834_f().contains((Object)SPlayerPositionLookPacket.Flags.X_ROT)) {
            \u26037 += clientPlayerEntity.field_70125_A;
        }
        if (sPlayerPositionLookPacket.func_179834_f().contains((Object)SPlayerPositionLookPacket.Flags.Y_ROT)) {
            \u26036 += clientPlayerEntity.field_70177_z;
        }
        clientPlayerEntity.func_70080_a(\u2603, \u2603, \u2603, \u26036, \u26037);
        this.field_147302_e.func_179290_a(new CConfirmTeleportPacket(sPlayerPositionLookPacket.func_186965_f()));
        this.field_147302_e.func_179290_a(new CPlayerPacket.PositionRotationPacket(clientPlayerEntity.func_226277_ct_(), clientPlayerEntity.func_226278_cu_(), clientPlayerEntity.func_226281_cx_(), clientPlayerEntity.field_70177_z, clientPlayerEntity.field_70125_A, false));
        if (!this.field_147309_h) {
            this.field_147309_h = true;
            this.field_147299_f.func_147108_a(null);
        }
    }

    @Override
    public void func_147287_a(SMultiBlockChangePacket sMultiBlockChangePacket) {
        PacketThreadUtil.func_218797_a(sMultiBlockChangePacket, this, this.field_147299_f);
        for (SMultiBlockChangePacket.UpdateData updateData : sMultiBlockChangePacket.func_179844_a()) {
            this.field_147300_g.func_195597_b(updateData.func_180090_a(), updateData.func_180088_c());
        }
    }

    @Override
    public void func_147263_a(SChunkDataPacket sChunkDataPacket) {
        PacketThreadUtil.func_218797_a(sChunkDataPacket, this, this.field_147299_f);
        int n = sChunkDataPacket.func_149273_e();
        \u2603 = sChunkDataPacket.func_149271_f();
        Chunk \u26032 = this.field_147300_g.func_72863_F().func_228313_a_(n, \u2603, sChunkDataPacket.func_229739_i_(), sChunkDataPacket.func_186946_a(), sChunkDataPacket.func_218710_g(), sChunkDataPacket.func_149276_g());
        if (\u26032 != null && sChunkDataPacket.func_149274_i()) {
            this.field_147300_g.func_217417_b(\u26032);
        }
        for (\u2603 = 0; \u2603 < 16; ++\u2603) {
            this.field_147300_g.func_217427_b(n, \u2603, \u2603);
        }
        for (CompoundNBT compoundNBT : sChunkDataPacket.func_189554_f()) {
            BlockPos blockPos = new BlockPos(compoundNBT.func_74762_e("x"), compoundNBT.func_74762_e("y"), compoundNBT.func_74762_e("z"));
            TileEntity \u26033 = this.field_147300_g.func_175625_s(blockPos);
            if (\u26033 == null) continue;
            \u26033.func_145839_a(compoundNBT);
        }
    }

    @Override
    public void func_184326_a(SUnloadChunkPacket sUnloadChunkPacket) {
        PacketThreadUtil.func_218797_a(sUnloadChunkPacket, this, this.field_147299_f);
        int n = sUnloadChunkPacket.func_186940_a();
        \u2603 = sUnloadChunkPacket.func_186941_b();
        ClientChunkProvider \u26032 = this.field_147300_g.func_72863_F();
        \u26032.func_73234_b(n, \u2603);
        WorldLightManager \u26033 = \u26032.func_212863_j_();
        for (\u2603 = 0; \u2603 < 16; ++\u2603) {
            this.field_147300_g.func_217427_b(n, \u2603, \u2603);
            \u26033.func_215566_a(SectionPos.func_218154_a(n, \u2603, \u2603), true);
        }
        \u26033.func_215571_a(new ChunkPos(n, \u2603), false);
    }

    @Override
    public void func_147234_a(SChangeBlockPacket sChangeBlockPacket) {
        PacketThreadUtil.func_218797_a(sChangeBlockPacket, this, this.field_147299_f);
        this.field_147300_g.func_195597_b(sChangeBlockPacket.func_179827_b(), sChangeBlockPacket.func_197685_a());
    }

    @Override
    public void func_147253_a(SDisconnectPacket sDisconnectPacket) {
        this.field_147302_e.func_150718_a(sDisconnectPacket.func_149165_c());
    }

    @Override
    public void func_147231_a(ITextComponent iTextComponent) {
        this.field_147299_f.func_213254_o();
        if (this.field_147307_j != null) {
            if (this.field_147307_j instanceof RealmsScreenProxy) {
                this.field_147299_f.func_147108_a(new DisconnectedRealmsScreen(((RealmsScreenProxy)this.field_147307_j).getScreen(), "disconnect.lost", iTextComponent).getProxy());
            } else {
                this.field_147299_f.func_147108_a(new DisconnectedScreen(this.field_147307_j, "disconnect.lost", iTextComponent));
            }
        } else {
            this.field_147299_f.func_147108_a(new DisconnectedScreen(new MultiplayerScreen(new MainMenuScreen()), "disconnect.lost", iTextComponent));
        }
    }

    public void func_147297_a(IPacket<?> iPacket) {
        this.field_147302_e.func_179290_a(iPacket);
    }

    @Override
    public void func_147246_a(SCollectItemPacket sCollectItemPacket) {
        PacketThreadUtil.func_218797_a(sCollectItemPacket, this, this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(sCollectItemPacket.func_149354_c());
        LivingEntity \u26032 = (LivingEntity)this.field_147300_g.func_73045_a(sCollectItemPacket.func_149353_d());
        if (\u26032 == null) {
            \u26032 = this.field_147299_f.field_71439_g;
        }
        if (entity != null) {
            if (entity instanceof ExperienceOrbEntity) {
                this.field_147300_g.func_184134_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, (this.field_147306_l.nextFloat() - this.field_147306_l.nextFloat()) * 0.35f + 0.9f, false);
            } else {
                this.field_147300_g.func_184134_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (this.field_147306_l.nextFloat() - this.field_147306_l.nextFloat()) * 1.4f + 2.0f, false);
            }
            if (entity instanceof ItemEntity) {
                ((ItemEntity)entity).func_92059_d().func_190920_e(sCollectItemPacket.func_191208_c());
            }
            this.field_147299_f.field_71452_i.func_78873_a(new ItemPickupParticle(this.field_147299_f.func_175598_ae(), this.field_147299_f.func_228019_au_(), this.field_147300_g, entity, \u26032));
            this.field_147300_g.func_217413_d(sCollectItemPacket.func_149354_c());
        }
    }

    @Override
    public void func_147251_a(SChatPacket sChatPacket) {
        PacketThreadUtil.func_218797_a(sChatPacket, this, this.field_147299_f);
        this.field_147299_f.field_71456_v.func_191742_a(sChatPacket.func_192590_c(), sChatPacket.func_148915_c());
    }

    @Override
    public void func_147279_a(SAnimateHandPacket sAnimateHandPacket2) {
        SAnimateHandPacket sAnimateHandPacket2;
        PacketThreadUtil.func_218797_a(sAnimateHandPacket2, this, this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(sAnimateHandPacket2.func_148978_c());
        if (entity == null) {
            return;
        }
        if (sAnimateHandPacket2.func_148977_d() == 0) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.func_184609_a(Hand.MAIN_HAND);
        } else if (sAnimateHandPacket2.func_148977_d() == 3) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.func_184609_a(Hand.OFF_HAND);
        } else if (sAnimateHandPacket2.func_148977_d() == 1) {
            entity.func_70057_ab();
        } else if (sAnimateHandPacket2.func_148977_d() == 2) {
            PlayerEntity playerEntity = (PlayerEntity)entity;
            playerEntity.func_225652_a_(false, false);
        } else if (sAnimateHandPacket2.func_148977_d() == 4) {
            this.field_147299_f.field_71452_i.func_199282_a(entity, ParticleTypes.field_197614_g);
        } else if (sAnimateHandPacket2.func_148977_d() == 5) {
            this.field_147299_f.field_71452_i.func_199282_a(entity, ParticleTypes.field_197622_o);
        }
    }

    @Override
    public void func_147281_a(SSpawnMobPacket sSpawnMobPacket2) {
        PacketThreadUtil.func_218797_a(sSpawnMobPacket2, this, this.field_147299_f);
        double d = sSpawnMobPacket2.func_186891_e();
        \u2603 = sSpawnMobPacket2.func_186892_f();
        \u2603 = sSpawnMobPacket2.func_186893_g();
        float \u26032 = (float)(sSpawnMobPacket2.func_149028_l() * 360) / 256.0f;
        float \u26033 = (float)(sSpawnMobPacket2.func_149030_m() * 360) / 256.0f;
        LivingEntity \u26034 = (LivingEntity)EntityType.func_200717_a(sSpawnMobPacket2.func_149025_e(), this.field_147299_f.field_71441_e);
        if (\u26034 != null) {
            SSpawnMobPacket sSpawnMobPacket2;
            \u26034.func_213312_b(d, \u2603, \u2603);
            \u26034.field_70761_aq = (float)(sSpawnMobPacket2.func_149032_n() * 360) / 256.0f;
            \u26034.field_70759_as = (float)(sSpawnMobPacket2.func_149032_n() * 360) / 256.0f;
            if (\u26034 instanceof EnderDragonEntity) {
                EnderDragonPartEntity[] enderDragonPartEntityArray = ((EnderDragonEntity)\u26034).func_213404_dT();
                for (int i = 0; i < enderDragonPartEntityArray.length; ++i) {
                    enderDragonPartEntityArray[i].func_145769_d(i + sSpawnMobPacket2.func_149024_d());
                }
            }
            \u26034.func_145769_d(sSpawnMobPacket2.func_149024_d());
            \u26034.func_184221_a(sSpawnMobPacket2.func_186890_c());
            \u26034.func_70080_a(d, \u2603, \u2603, \u26032, \u26033);
            \u26034.func_213293_j((float)sSpawnMobPacket2.func_149026_i() / 8000.0f, (float)sSpawnMobPacket2.func_149033_j() / 8000.0f, (float)sSpawnMobPacket2.func_149031_k() / 8000.0f);
            this.field_147300_g.func_217411_a(sSpawnMobPacket2.func_149024_d(), \u26034);
            if (\u26034 instanceof BeeEntity) {
                boolean bl = ((BeeEntity)\u26034).func_226427_ez_();
                BeeSound \u26035 = bl ? new BeeAngrySound((BeeEntity)\u26034) : new BeeFlightSound((BeeEntity)\u26034);
                this.field_147299_f.func_147118_V().func_147682_a(\u26035);
            }
        } else {
            field_147301_d.warn("Skipping Entity with id {}", (Object)sSpawnMobPacket2.func_149025_e());
        }
    }

    @Override
    public void func_147285_a(SUpdateTimePacket sUpdateTimePacket) {
        PacketThreadUtil.func_218797_a(sUpdateTimePacket, this, this.field_147299_f);
        this.field_147299_f.field_71441_e.func_82738_a(sUpdateTimePacket.func_149366_c());
        this.field_147299_f.field_71441_e.func_72877_b(sUpdateTimePacket.func_149365_d());
    }

    @Override
    public void func_147271_a(SSpawnPositionPacket sSpawnPositionPacket) {
        PacketThreadUtil.func_218797_a(sSpawnPositionPacket, this, this.field_147299_f);
        this.field_147299_f.field_71439_g.func_226560_a_(sSpawnPositionPacket.func_179800_a(), true, false);
        this.field_147299_f.field_71441_e.func_72912_H().func_176143_a(sSpawnPositionPacket.func_179800_a());
    }

    @Override
    public void func_184328_a(SSetPassengersPacket sSetPassengersPacket) {
        PacketThreadUtil.func_218797_a(sSetPassengersPacket, this, this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(sSetPassengersPacket.func_186972_b());
        if (entity == null) {
            field_147301_d.warn("Received passengers for unknown entity");
            return;
        }
        boolean \u26032 = entity.func_184215_y(this.field_147299_f.field_71439_g);
        entity.func_184226_ay();
        for (int n : sSetPassengersPacket.func_186971_a()) {
            Entity entity2 = this.field_147300_g.func_73045_a(n);
            if (entity2 == null) continue;
            entity2.func_184205_a(entity, true);
            if (entity2 != this.field_147299_f.field_71439_g || \u26032) continue;
            this.field_147299_f.field_71456_v.func_110326_a(I18n.func_135052_a("mount.onboard", this.field_147299_f.field_71474_y.field_228046_af_.func_197978_k()), false);
        }
    }

    @Override
    public void func_147243_a(SMountEntityPacket sMountEntityPacket) {
        PacketThreadUtil.func_218797_a(sMountEntityPacket, this, this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(sMountEntityPacket.func_149403_d());
        if (entity instanceof MobEntity) {
            ((MobEntity)entity).func_213381_d(sMountEntityPacket.func_149402_e());
        }
    }

    private static ItemStack func_217282_a(PlayerEntity playerEntity) {
        for (Hand hand : Hand.values()) {
            ItemStack itemStack = playerEntity.func_184586_b(hand);
            if (itemStack.func_77973_b() != Items.field_190929_cY) continue;
            return itemStack;
        }
        return new ItemStack(Items.field_190929_cY);
    }

    @Override
    public void func_147236_a(SEntityStatusPacket sEntityStatusPacket) {
        PacketThreadUtil.func_218797_a(sEntityStatusPacket, this, this.field_147299_f);
        Entity entity = sEntityStatusPacket.func_149161_a(this.field_147300_g);
        if (entity != null) {
            if (sEntityStatusPacket.func_149160_c() == 21) {
                this.field_147299_f.func_147118_V().func_147682_a(new GuardianSound((GuardianEntity)entity));
            } else if (sEntityStatusPacket.func_149160_c() == 35) {
                int n = 40;
                this.field_147299_f.field_71452_i.func_199281_a(entity, ParticleTypes.field_197604_O, 30);
                this.field_147300_g.func_184134_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_191263_gW, entity.func_184176_by(), 1.0f, 1.0f, false);
                if (entity == this.field_147299_f.field_71439_g) {
                    this.field_147299_f.field_71460_t.func_190565_a(ClientPlayNetHandler.func_217282_a(this.field_147299_f.field_71439_g));
                }
            } else {
                entity.func_70103_a(sEntityStatusPacket.func_149160_c());
            }
        }
    }

    @Override
    public void func_147249_a(SUpdateHealthPacket sUpdateHealthPacket) {
        PacketThreadUtil.func_218797_a(sUpdateHealthPacket, this, this.field_147299_f);
        this.field_147299_f.field_71439_g.func_71150_b(sUpdateHealthPacket.func_149332_c());
        this.field_147299_f.field_71439_g.func_71024_bL().func_75114_a(sUpdateHealthPacket.func_149330_d());
        this.field_147299_f.field_71439_g.func_71024_bL().func_75119_b(sUpdateHealthPacket.func_149331_e());
    }

    @Override
    public void func_147295_a(SSetExperiencePacket sSetExperiencePacket) {
        PacketThreadUtil.func_218797_a(sSetExperiencePacket, this, this.field_147299_f);
        this.field_147299_f.field_71439_g.func_71152_a(sSetExperiencePacket.func_149397_c(), sSetExperiencePacket.func_149396_d(), sSetExperiencePacket.func_149395_e());
    }

    @Override
    public void func_147280_a(SRespawnPacket sRespawnPacket) {
        Object object;
        PacketThreadUtil.func_218797_a(sRespawnPacket, this, this.field_147299_f);
        DimensionType dimensionType = sRespawnPacket.func_212643_b();
        ClientPlayerEntity \u26032 = this.field_147299_f.field_71439_g;
        int \u26033 = \u26032.func_145782_y();
        if (dimensionType != \u26032.field_71093_bK) {
            this.field_147309_h = false;
            object = this.field_147300_g.func_96441_U();
            this.field_147300_g = new ClientWorld(this, new WorldSettings(sRespawnPacket.func_229747_c_(), sRespawnPacket.func_149083_e(), false, this.field_147299_f.field_71441_e.func_72912_H().func_76093_s(), sRespawnPacket.func_149080_f()), sRespawnPacket.func_212643_b(), this.field_217287_m, this.field_147299_f.func_213239_aq(), this.field_147299_f.field_71438_f);
            this.field_147300_g.func_96443_a((Scoreboard)object);
            this.field_147299_f.func_71403_a(this.field_147300_g);
            this.field_147299_f.func_147108_a(new DownloadTerrainScreen());
        }
        this.field_147300_g.func_72974_f();
        this.field_147300_g.func_73022_a();
        object = \u26032.func_142021_k();
        this.field_147299_f.field_175622_Z = null;
        ClientPlayerEntity \u26034 = this.field_147299_f.field_71442_b.func_199681_a(this.field_147300_g, \u26032.func_146107_m(), \u26032.func_199507_B());
        \u26034.func_145769_d(\u26033);
        \u26034.field_71093_bK = dimensionType;
        this.field_147299_f.field_71439_g = \u26034;
        this.field_147299_f.field_175622_Z = \u26034;
        \u26034.func_184212_Q().func_187218_a(\u26032.func_184212_Q().func_187231_c());
        \u26034.func_110140_aT().func_226303_a_(\u26032.func_110140_aT());
        \u26034.func_70065_x();
        \u26034.func_175158_f((String)object);
        this.field_147300_g.func_217408_a(\u26033, \u26034);
        \u26034.field_70177_z = -180.0f;
        \u26034.field_71158_b = new MovementInputFromOptions(this.field_147299_f.field_71474_y);
        this.field_147299_f.field_71442_b.func_78748_a(\u26034);
        \u26034.func_175150_k(\u26032.func_175140_cp());
        \u26034.func_228355_a_(\u26032.func_228353_F_());
        if (this.field_147299_f.field_71462_r instanceof DeathScreen) {
            this.field_147299_f.func_147108_a(null);
        }
        this.field_147299_f.field_71442_b.func_78746_a(sRespawnPacket.func_149083_e());
    }

    @Override
    public void func_147283_a(SExplosionPacket sExplosionPacket) {
        PacketThreadUtil.func_218797_a(sExplosionPacket, this, this.field_147299_f);
        Explosion explosion = new Explosion(this.field_147299_f.field_71441_e, null, sExplosionPacket.func_149148_f(), sExplosionPacket.func_149143_g(), sExplosionPacket.func_149145_h(), sExplosionPacket.func_149146_i(), sExplosionPacket.func_149150_j());
        explosion.func_77279_a(true);
        this.field_147299_f.field_71439_g.func_213317_d(this.field_147299_f.field_71439_g.func_213322_ci().func_72441_c(sExplosionPacket.func_149149_c(), sExplosionPacket.func_149144_d(), sExplosionPacket.func_149147_e()));
    }

    @Override
    public void func_217271_a(SOpenHorseWindowPacket sOpenHorseWindowPacket) {
        PacketThreadUtil.func_218797_a(sOpenHorseWindowPacket, this, this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(sOpenHorseWindowPacket.func_218703_d());
        if (entity instanceof AbstractHorseEntity) {
            ClientPlayerEntity clientPlayerEntity = this.field_147299_f.field_71439_g;
            AbstractHorseEntity \u26032 = (AbstractHorseEntity)entity;
            Inventory \u26033 = new Inventory(sOpenHorseWindowPacket.func_218702_c());
            HorseInventoryContainer \u26034 = new HorseInventoryContainer(sOpenHorseWindowPacket.func_218704_b(), clientPlayerEntity.field_71071_by, \u26033, \u26032);
            clientPlayerEntity.field_71070_bA = \u26034;
            this.field_147299_f.func_147108_a(new HorseInventoryScreen(\u26034, clientPlayerEntity.field_71071_by, \u26032));
        }
    }

    @Override
    public void func_217272_a(SOpenWindowPacket sOpenWindowPacket) {
        PacketThreadUtil.func_218797_a(sOpenWindowPacket, this, this.field_147299_f);
        ScreenManager.func_216909_a(sOpenWindowPacket.func_218749_c(), this.field_147299_f, sOpenWindowPacket.func_218750_b(), sOpenWindowPacket.func_218748_d());
    }

    @Override
    public void func_147266_a(SSetSlotPacket sSetSlotPacket2) {
        PacketThreadUtil.func_218797_a(sSetSlotPacket2, this, this.field_147299_f);
        ClientPlayerEntity clientPlayerEntity = this.field_147299_f.field_71439_g;
        ItemStack \u26032 = sSetSlotPacket2.func_149174_e();
        int \u26033 = sSetSlotPacket2.func_149173_d();
        this.field_147299_f.func_193032_ao().func_193301_a(\u26032);
        if (sSetSlotPacket2.func_149175_c() == -1) {
            if (!(this.field_147299_f.field_71462_r instanceof CreativeScreen)) {
                clientPlayerEntity.field_71071_by.func_70437_b(\u26032);
            }
        } else if (sSetSlotPacket2.func_149175_c() == -2) {
            clientPlayerEntity.field_71071_by.func_70299_a(\u26033, \u26032);
        } else {
            SSetSlotPacket sSetSlotPacket2;
            boolean bl = false;
            if (this.field_147299_f.field_71462_r instanceof CreativeScreen) {
                Object object = (CreativeScreen)this.field_147299_f.field_71462_r;
                boolean bl2 = bl = ((CreativeScreen)object).func_147056_g() != ItemGroup.field_78036_m.func_78021_a();
            }
            if (sSetSlotPacket2.func_149175_c() == 0 && sSetSlotPacket2.func_149173_d() >= 36 && \u26033 < 45) {
                if (!\u26032.func_190926_b() && (((ItemStack)(object = clientPlayerEntity.field_71069_bz.func_75139_a(\u26033).func_75211_c())).func_190926_b() || ((ItemStack)object).func_190916_E() < \u26032.func_190916_E())) {
                    \u26032.func_190915_d(5);
                }
                clientPlayerEntity.field_71069_bz.func_75141_a(\u26033, \u26032);
            } else if (!(sSetSlotPacket2.func_149175_c() != clientPlayerEntity.field_71070_bA.field_75152_c || sSetSlotPacket2.func_149175_c() == 0 && bl)) {
                clientPlayerEntity.field_71070_bA.func_75141_a(\u26033, \u26032);
            }
        }
    }

    @Override
    public void func_147239_a(SConfirmTransactionPacket sConfirmTransactionPacket) {
        PacketThreadUtil.func_218797_a(sConfirmTransactionPacket, this, this.field_147299_f);
        Container container = null;
        ClientPlayerEntity \u26032 = this.field_147299_f.field_71439_g;
        if (sConfirmTransactionPacket.func_148889_c() == 0) {
            container = \u26032.field_71069_bz;
        } else if (sConfirmTransactionPacket.func_148889_c() == \u26032.field_71070_bA.field_75152_c) {
            container = \u26032.field_71070_bA;
        }
        if (container != null && !sConfirmTransactionPacket.func_148888_e()) {
            this.func_147297_a(new CConfirmTransactionPacket(sConfirmTransactionPacket.func_148889_c(), sConfirmTransactionPacket.func_148890_d(), true));
        }
    }

    @Override
    public void func_147241_a(SWindowItemsPacket sWindowItemsPacket) {
        PacketThreadUtil.func_218797_a(sWindowItemsPacket, this, this.field_147299_f);
        ClientPlayerEntity clientPlayerEntity = this.field_147299_f.field_71439_g;
        if (sWindowItemsPacket.func_148911_c() == 0) {
            clientPlayerEntity.field_71069_bz.func_190896_a(sWindowItemsPacket.func_148910_d());
        } else if (sWindowItemsPacket.func_148911_c() == clientPlayerEntity.field_71070_bA.field_75152_c) {
            clientPlayerEntity.field_71070_bA.func_190896_a(sWindowItemsPacket.func_148910_d());
        }
    }

    @Override
    public void func_147268_a(SOpenSignMenuPacket sOpenSignMenuPacket) {
        PacketThreadUtil.func_218797_a(sOpenSignMenuPacket, this, this.field_147299_f);
        TileEntity tileEntity = this.field_147300_g.func_175625_s(sOpenSignMenuPacket.func_179777_a());
        if (!(tileEntity instanceof SignTileEntity)) {
            tileEntity = new SignTileEntity();
            tileEntity.func_226984_a_(this.field_147300_g, sOpenSignMenuPacket.func_179777_a());
        }
        this.field_147299_f.field_71439_g.func_175141_a((SignTileEntity)tileEntity);
    }

    @Override
    public void func_147273_a(SUpdateTileEntityPacket sUpdateTileEntityPacket) {
        PacketThreadUtil.func_218797_a(sUpdateTileEntityPacket, this, this.field_147299_f);
        if (this.field_147299_f.field_71441_e.func_175667_e(sUpdateTileEntityPacket.func_179823_a())) {
            TileEntity tileEntity = this.field_147299_f.field_71441_e.func_175625_s(sUpdateTileEntityPacket.func_179823_a());
            int \u26032 = sUpdateTileEntityPacket.func_148853_f();
            boolean bl = \u2603 = \u26032 == 2 && tileEntity instanceof CommandBlockTileEntity;
            if (\u26032 == 1 && tileEntity instanceof MobSpawnerTileEntity || \u2603 || \u26032 == 3 && tileEntity instanceof BeaconTileEntity || \u26032 == 4 && tileEntity instanceof SkullTileEntity || \u26032 == 6 && tileEntity instanceof BannerTileEntity || \u26032 == 7 && tileEntity instanceof StructureBlockTileEntity || \u26032 == 8 && tileEntity instanceof EndGatewayTileEntity || \u26032 == 9 && tileEntity instanceof SignTileEntity || \u26032 == 11 && tileEntity instanceof BedTileEntity || \u26032 == 5 && tileEntity instanceof ConduitTileEntity || \u26032 == 12 && tileEntity instanceof JigsawTileEntity || \u26032 == 13 && tileEntity instanceof CampfireTileEntity || \u26032 == 14 && tileEntity instanceof BeehiveTileEntity) {
                tileEntity.func_145839_a(sUpdateTileEntityPacket.func_148857_g());
            }
            if (\u2603 && this.field_147299_f.field_71462_r instanceof CommandBlockScreen) {
                ((CommandBlockScreen)this.field_147299_f.field_71462_r).func_184075_a();
            }
        }
    }

    @Override
    public void func_147245_a(SWindowPropertyPacket sWindowPropertyPacket) {
        PacketThreadUtil.func_218797_a(sWindowPropertyPacket, this, this.field_147299_f);
        ClientPlayerEntity clientPlayerEntity = this.field_147299_f.field_71439_g;
        if (clientPlayerEntity.field_71070_bA != null && clientPlayerEntity.field_71070_bA.field_75152_c == sWindowPropertyPacket.func_149182_c()) {
            clientPlayerEntity.field_71070_bA.func_75137_b(sWindowPropertyPacket.func_149181_d(), sWindowPropertyPacket.func_149180_e());
        }
    }

    @Override
    public void func_147242_a(SEntityEquipmentPacket sEntityEquipmentPacket) {
        PacketThreadUtil.func_218797_a(sEntityEquipmentPacket, this, this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(sEntityEquipmentPacket.func_149389_d());
        if (entity != null) {
            entity.func_184201_a(sEntityEquipmentPacket.func_186969_c(), sEntityEquipmentPacket.func_149390_c());
        }
    }

    @Override
    public void func_147276_a(SCloseWindowPacket sCloseWindowPacket) {
        PacketThreadUtil.func_218797_a(sCloseWindowPacket, this, this.field_147299_f);
        this.field_147299_f.field_71439_g.func_175159_q();
    }

    @Override
    public void func_147261_a(SBlockActionPacket sBlockActionPacket) {
        PacketThreadUtil.func_218797_a(sBlockActionPacket, this, this.field_147299_f);
        this.field_147299_f.field_71441_e.func_175641_c(sBlockActionPacket.func_179825_a(), sBlockActionPacket.func_148868_c(), sBlockActionPacket.func_148869_g(), sBlockActionPacket.func_148864_h());
    }

    @Override
    public void func_147294_a(SAnimateBlockBreakPacket sAnimateBlockBreakPacket) {
        PacketThreadUtil.func_218797_a(sAnimateBlockBreakPacket, this, this.field_147299_f);
        this.field_147299_f.field_71441_e.func_175715_c(sAnimateBlockBreakPacket.func_148845_c(), sAnimateBlockBreakPacket.func_179821_b(), sAnimateBlockBreakPacket.func_148846_g());
    }

    @Override
    public void func_147252_a(SChangeGameStatePacket sChangeGameStatePacket) {
        PacketThreadUtil.func_218797_a(sChangeGameStatePacket, this, this.field_147299_f);
        ClientPlayerEntity clientPlayerEntity = this.field_147299_f.field_71439_g;
        int \u26032 = sChangeGameStatePacket.func_149138_c();
        float \u26033 = sChangeGameStatePacket.func_149137_d();
        int \u26034 = MathHelper.func_76141_d(\u26033 + 0.5f);
        if (\u26032 >= 0 && \u26032 < SChangeGameStatePacket.field_149142_a.length && SChangeGameStatePacket.field_149142_a[\u26032] != null) {
            ((PlayerEntity)clientPlayerEntity).func_146105_b(new TranslationTextComponent(SChangeGameStatePacket.field_149142_a[\u26032], new Object[0]), false);
        }
        if (\u26032 == 1) {
            this.field_147300_g.func_72912_H().func_76084_b(true);
            this.field_147300_g.func_72894_k(0.0f);
        } else if (\u26032 == 2) {
            this.field_147300_g.func_72912_H().func_76084_b(false);
            this.field_147300_g.func_72894_k(1.0f);
        } else if (\u26032 == 3) {
            this.field_147299_f.field_71442_b.func_78746_a(GameType.func_77146_a(\u26034));
        } else if (\u26032 == 4) {
            if (\u26034 == 0) {
                this.field_147299_f.field_71439_g.field_71174_a.func_147297_a(new CClientStatusPacket(CClientStatusPacket.State.PERFORM_RESPAWN));
                this.field_147299_f.func_147108_a(new DownloadTerrainScreen());
            } else if (\u26034 == 1) {
                this.field_147299_f.func_147108_a(new WinGameScreen(true, () -> this.field_147299_f.field_71439_g.field_71174_a.func_147297_a(new CClientStatusPacket(CClientStatusPacket.State.PERFORM_RESPAWN))));
            }
        } else if (\u26032 == 5) {
            GameSettings gameSettings = this.field_147299_f.field_71474_y;
            if (\u26033 == 0.0f) {
                this.field_147299_f.func_147108_a(new DemoScreen());
            } else if (\u26033 == 101.0f) {
                this.field_147299_f.field_71456_v.func_146158_b().func_146227_a(new TranslationTextComponent("demo.help.movement", gameSettings.field_74351_w.func_197978_k(), gameSettings.field_74370_x.func_197978_k(), gameSettings.field_74368_y.func_197978_k(), gameSettings.field_74366_z.func_197978_k()));
            } else if (\u26033 == 102.0f) {
                this.field_147299_f.field_71456_v.func_146158_b().func_146227_a(new TranslationTextComponent("demo.help.jump", gameSettings.field_74314_A.func_197978_k()));
            } else if (\u26033 == 103.0f) {
                this.field_147299_f.field_71456_v.func_146158_b().func_146227_a(new TranslationTextComponent("demo.help.inventory", gameSettings.field_151445_Q.func_197978_k()));
            } else if (\u26033 == 104.0f) {
                this.field_147299_f.field_71456_v.func_146158_b().func_146227_a(new TranslationTextComponent("demo.day.6", gameSettings.field_151447_Z.func_197978_k()));
            }
        } else if (\u26032 == 6) {
            this.field_147300_g.func_184148_a(clientPlayerEntity, clientPlayerEntity.func_226277_ct_(), clientPlayerEntity.func_226280_cw_(), clientPlayerEntity.func_226281_cx_(), SoundEvents.field_187734_u, SoundCategory.PLAYERS, 0.18f, 0.45f);
        } else if (\u26032 == 7) {
            this.field_147300_g.func_72894_k(\u26033);
        } else if (\u26032 == 8) {
            this.field_147300_g.func_147442_i(\u26033);
        } else if (\u26032 == 9) {
            this.field_147300_g.func_184148_a(clientPlayerEntity, clientPlayerEntity.func_226277_ct_(), clientPlayerEntity.func_226278_cu_(), clientPlayerEntity.func_226281_cx_(), SoundEvents.field_203830_gs, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        } else if (\u26032 == 10) {
            this.field_147300_g.func_195594_a(ParticleTypes.field_197621_n, clientPlayerEntity.func_226277_ct_(), clientPlayerEntity.func_226278_cu_(), clientPlayerEntity.func_226281_cx_(), 0.0, 0.0, 0.0);
            this.field_147300_g.func_184148_a(clientPlayerEntity, clientPlayerEntity.func_226277_ct_(), clientPlayerEntity.func_226278_cu_(), clientPlayerEntity.func_226281_cx_(), SoundEvents.field_187514_aD, SoundCategory.HOSTILE, 1.0f, 1.0f);
        } else if (\u26032 == 11) {
            this.field_147299_f.field_71439_g.func_228355_a_(\u26033 == 0.0f);
        }
    }

    @Override
    public void func_147264_a(SMapDataPacket sMapDataPacket) {
        PacketThreadUtil.func_218797_a(sMapDataPacket, this, this.field_147299_f);
        MapItemRenderer mapItemRenderer = this.field_147299_f.field_71460_t.func_147701_i();
        String \u26032 = FilledMapItem.func_219993_a(sMapDataPacket.func_149188_c());
        MapData \u26033 = this.field_147299_f.field_71441_e.func_217406_a(\u26032);
        if (\u26033 == null) {
            \u26033 = new MapData(\u26032);
            if (mapItemRenderer.func_191205_a(\u26032) != null && (\u2603 = mapItemRenderer.func_191207_a(mapItemRenderer.func_191205_a(\u26032))) != null) {
                \u26033 = \u2603;
            }
            this.field_147299_f.field_71441_e.func_217399_a(\u26033);
        }
        sMapDataPacket.func_179734_a(\u26033);
        mapItemRenderer.func_148246_a(\u26033);
    }

    @Override
    public void func_147277_a(SPlaySoundEventPacket sPlaySoundEventPacket) {
        PacketThreadUtil.func_218797_a(sPlaySoundEventPacket, this, this.field_147299_f);
        if (sPlaySoundEventPacket.func_149244_c()) {
            this.field_147299_f.field_71441_e.func_175669_a(sPlaySoundEventPacket.func_149242_d(), sPlaySoundEventPacket.func_179746_d(), sPlaySoundEventPacket.func_149241_e());
        } else {
            this.field_147299_f.field_71441_e.func_217379_c(sPlaySoundEventPacket.func_149242_d(), sPlaySoundEventPacket.func_179746_d(), sPlaySoundEventPacket.func_149241_e());
        }
    }

    @Override
    public void func_191981_a(SAdvancementInfoPacket sAdvancementInfoPacket) {
        PacketThreadUtil.func_218797_a(sAdvancementInfoPacket, this, this.field_147299_f);
        this.field_191983_k.func_192799_a(sAdvancementInfoPacket);
    }

    @Override
    public void func_194022_a(SSelectAdvancementsTabPacket sSelectAdvancementsTabPacket) {
        PacketThreadUtil.func_218797_a(sSelectAdvancementsTabPacket, this, this.field_147299_f);
        ResourceLocation resourceLocation = sSelectAdvancementsTabPacket.func_194154_a();
        if (resourceLocation == null) {
            this.field_191983_k.func_194230_a(null, false);
        } else {
            Advancement advancement = this.field_191983_k.func_194229_a().func_192084_a(resourceLocation);
            this.field_191983_k.func_194230_a(advancement, false);
        }
    }

    @Override
    public void func_195511_a(SCommandListPacket sCommandListPacket) {
        PacketThreadUtil.func_218797_a(sCommandListPacket, this, this.field_147299_f);
        this.field_195517_n = new CommandDispatcher(sCommandListPacket.func_197693_a());
    }

    @Override
    public void func_195512_a(SStopSoundPacket sStopSoundPacket) {
        PacketThreadUtil.func_218797_a(sStopSoundPacket, this, this.field_147299_f);
        this.field_147299_f.func_147118_V().func_195478_a(sStopSoundPacket.func_197703_a(), sStopSoundPacket.func_197704_b());
    }

    @Override
    public void func_195510_a(STabCompletePacket sTabCompletePacket) {
        PacketThreadUtil.func_218797_a(sTabCompletePacket, this, this.field_147299_f);
        this.field_195516_l.func_197015_a(sTabCompletePacket.func_197689_a(), sTabCompletePacket.func_197687_b());
    }

    @Override
    public void func_199525_a(SUpdateRecipesPacket sUpdateRecipesPacket) {
        PacketThreadUtil.func_218797_a(sUpdateRecipesPacket, this, this.field_147299_f);
        this.field_199528_o.func_223389_a(sUpdateRecipesPacket.func_199616_a());
        IMutableSearchTree<RecipeList> iMutableSearchTree = this.field_147299_f.func_213253_a(SearchTreeManager.field_194012_b);
        iMutableSearchTree.func_217871_a();
        ClientRecipeBook \u26032 = this.field_147299_f.field_71439_g.func_199507_B();
        \u26032.func_199644_c();
        \u26032.func_199642_d().forEach(iMutableSearchTree::func_217872_a);
        iMutableSearchTree.func_194040_a();
    }

    @Override
    public void func_200232_a(SPlayerLookPacket sPlayerLookPacket) {
        PacketThreadUtil.func_218797_a(sPlayerLookPacket, this, this.field_147299_f);
        Vec3d vec3d = sPlayerLookPacket.func_200531_a(this.field_147300_g);
        if (vec3d != null) {
            this.field_147299_f.field_71439_g.func_200602_a(sPlayerLookPacket.func_201064_a(), vec3d);
        }
    }

    @Override
    public void func_211522_a(SQueryNBTResponsePacket sQueryNBTResponsePacket) {
        PacketThreadUtil.func_218797_a(sQueryNBTResponsePacket, this, this.field_147299_f);
        if (!this.field_211524_l.func_211548_a(sQueryNBTResponsePacket.func_211713_b(), sQueryNBTResponsePacket.func_211712_c())) {
            field_147301_d.debug("Got unhandled response to tag query {}", (Object)sQueryNBTResponsePacket.func_211713_b());
        }
    }

    @Override
    public void func_147293_a(SStatisticsPacket sStatisticsPacket) {
        PacketThreadUtil.func_218797_a(sStatisticsPacket, this, this.field_147299_f);
        for (Map.Entry<Stat<?>, Integer> entry : sStatisticsPacket.func_148974_c().entrySet()) {
            Stat<?> stat = entry.getKey();
            int \u26032 = entry.getValue();
            this.field_147299_f.field_71439_g.func_146107_m().func_150873_a(this.field_147299_f.field_71439_g, stat, \u26032);
        }
        if (this.field_147299_f.field_71462_r instanceof IProgressMeter) {
            ((IProgressMeter)((Object)this.field_147299_f.field_71462_r)).func_193026_g();
        }
    }

    @Override
    public void func_191980_a(SRecipeBookPacket sRecipeBookPacket2) {
        PacketThreadUtil.func_218797_a(sRecipeBookPacket2, this, this.field_147299_f);
        ClientRecipeBook clientRecipeBook = this.field_147299_f.field_71439_g.func_199507_B();
        clientRecipeBook.func_192813_a(sRecipeBookPacket2.func_192593_c());
        clientRecipeBook.func_192810_b(sRecipeBookPacket2.func_192594_d());
        clientRecipeBook.func_202881_c(sRecipeBookPacket2.func_202492_e());
        clientRecipeBook.func_202882_d(sRecipeBookPacket2.func_202493_f());
        SRecipeBookPacket.State \u26032 = sRecipeBookPacket2.func_194151_e();
        switch (\u26032) {
            case REMOVE: {
                for (ResourceLocation resourceLocation : sRecipeBookPacket2.func_192595_a()) {
                    this.field_199528_o.func_215367_a(resourceLocation).ifPresent(clientRecipeBook::func_193831_b);
                }
                break;
            }
            case INIT: {
                SRecipeBookPacket sRecipeBookPacket2;
                for (ResourceLocation \u26033 : sRecipeBookPacket2.func_192595_a()) {
                    this.field_199528_o.func_215367_a(\u26033).ifPresent(clientRecipeBook::func_194073_a);
                }
                for (ResourceLocation \u26033 : sRecipeBookPacket2.func_193644_b()) {
                    this.field_199528_o.func_215367_a(\u26033).ifPresent(clientRecipeBook::func_193825_e);
                }
                break;
            }
            case ADD: {
                for (ResourceLocation \u26034 : sRecipeBookPacket2.func_192595_a()) {
                    this.field_199528_o.func_215367_a(\u26034).ifPresent(iRecipe -> {
                        clientRecipeBook.func_194073_a((IRecipe<?>)iRecipe);
                        clientRecipeBook.func_193825_e((IRecipe<?>)iRecipe);
                        RecipeToast.func_193665_a(this.field_147299_f.func_193033_an(), iRecipe);
                    });
                }
                break;
            }
        }
        clientRecipeBook.func_199642_d().forEach(recipeList -> recipeList.func_194214_a(clientRecipeBook));
        if (this.field_147299_f.field_71462_r instanceof IRecipeShownListener) {
            ((IRecipeShownListener)((Object)this.field_147299_f.field_71462_r)).func_192043_J_();
        }
    }

    @Override
    public void func_147260_a(SPlayEntityEffectPacket sPlayEntityEffectPacket) {
        PacketThreadUtil.func_218797_a(sPlayEntityEffectPacket, this, this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(sPlayEntityEffectPacket.func_149426_d());
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        Effect \u26032 = Effect.func_188412_a(sPlayEntityEffectPacket.func_149427_e());
        if (\u26032 == null) {
            return;
        }
        EffectInstance \u26033 = new EffectInstance(\u26032, sPlayEntityEffectPacket.func_180755_e(), sPlayEntityEffectPacket.func_149428_f(), sPlayEntityEffectPacket.func_186984_g(), sPlayEntityEffectPacket.func_179707_f(), sPlayEntityEffectPacket.func_205527_h());
        \u26033.func_100012_b(sPlayEntityEffectPacket.func_149429_c());
        ((LivingEntity)entity).func_195064_c(\u26033);
    }

    @Override
    public void func_199723_a(STagsListPacket sTagsListPacket) {
        PacketThreadUtil.func_218797_a(sTagsListPacket, this, this.field_147299_f);
        this.field_199725_m = sTagsListPacket.func_199858_a();
        if (!this.field_147302_e.func_150731_c()) {
            BlockTags.func_199895_a(this.field_199725_m.func_199717_a());
            ItemTags.func_199902_a(this.field_199725_m.func_199715_b());
            FluidTags.func_206953_a(this.field_199725_m.func_205704_c());
            EntityTypeTags.func_219759_a(this.field_199725_m.func_215297_d());
        }
        this.field_147299_f.func_213253_a(SearchTreeManager.field_215360_b).func_194040_a();
    }

    @Override
    public void func_175098_a(SCombatPacket sCombatPacket) {
        PacketThreadUtil.func_218797_a(sCombatPacket, this, this.field_147299_f);
        if (sCombatPacket.field_179776_a == SCombatPacket.Event.ENTITY_DIED && (\u2603 = this.field_147300_g.func_73045_a(sCombatPacket.field_179774_b)) == this.field_147299_f.field_71439_g) {
            if (this.field_147299_f.field_71439_g.func_228353_F_()) {
                this.field_147299_f.func_147108_a(new DeathScreen(sCombatPacket.field_179773_e, this.field_147300_g.func_72912_H().func_76093_s()));
            } else {
                this.field_147299_f.field_71439_g.func_71004_bE();
            }
        }
    }

    @Override
    public void func_175101_a(SServerDifficultyPacket sServerDifficultyPacket) {
        PacketThreadUtil.func_218797_a(sServerDifficultyPacket, this, this.field_147299_f);
        this.field_147299_f.field_71441_e.func_72912_H().func_176144_a(sServerDifficultyPacket.func_179831_b());
        this.field_147299_f.field_71441_e.func_72912_H().func_180783_e(sServerDifficultyPacket.func_179830_a());
    }

    @Override
    public void func_175094_a(SCameraPacket sCameraPacket) {
        PacketThreadUtil.func_218797_a(sCameraPacket, this, this.field_147299_f);
        Entity entity = sCameraPacket.func_179780_a(this.field_147300_g);
        if (entity != null) {
            this.field_147299_f.func_175607_a(entity);
        }
    }

    @Override
    public void func_175093_a(SWorldBorderPacket sWorldBorderPacket) {
        PacketThreadUtil.func_218797_a(sWorldBorderPacket, this, this.field_147299_f);
        sWorldBorderPacket.func_179788_a(this.field_147300_g.func_175723_af());
    }

    @Override
    public void func_175099_a(STitlePacket sTitlePacket) {
        PacketThreadUtil.func_218797_a(sTitlePacket, this, this.field_147299_f);
        STitlePacket.Type type = sTitlePacket.func_179807_a();
        String \u26032 = null;
        String \u26033 = null;
        String \u26034 = sTitlePacket.func_179805_b() != null ? sTitlePacket.func_179805_b().func_150254_d() : "";
        switch (type) {
            case TITLE: {
                \u26032 = \u26034;
                break;
            }
            case SUBTITLE: {
                \u26033 = \u26034;
                break;
            }
            case ACTIONBAR: {
                this.field_147299_f.field_71456_v.func_110326_a(\u26034, false);
                return;
            }
            case RESET: {
                this.field_147299_f.field_71456_v.func_175178_a("", "", -1, -1, -1);
                this.field_147299_f.field_71456_v.func_175177_a();
                return;
            }
        }
        this.field_147299_f.field_71456_v.func_175178_a(\u26032, \u26033, sTitlePacket.func_179806_c(), sTitlePacket.func_179804_d(), sTitlePacket.func_179803_e());
    }

    @Override
    public void func_175096_a(SPlayerListHeaderFooterPacket sPlayerListHeaderFooterPacket) {
        this.field_147299_f.field_71456_v.func_175181_h().func_175244_b(sPlayerListHeaderFooterPacket.func_179700_a().func_150254_d().isEmpty() ? null : sPlayerListHeaderFooterPacket.func_179700_a());
        this.field_147299_f.field_71456_v.func_175181_h().func_175248_a(sPlayerListHeaderFooterPacket.func_179701_b().func_150254_d().isEmpty() ? null : sPlayerListHeaderFooterPacket.func_179701_b());
    }

    @Override
    public void func_147262_a(SRemoveEntityEffectPacket sRemoveEntityEffectPacket) {
        PacketThreadUtil.func_218797_a(sRemoveEntityEffectPacket, this, this.field_147299_f);
        Entity entity = sRemoveEntityEffectPacket.func_186967_a(this.field_147300_g);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).func_184596_c(sRemoveEntityEffectPacket.func_186968_a());
        }
    }

    @Override
    public void func_147256_a(SPlayerListItemPacket sPlayerListItemPacket) {
        PacketThreadUtil.func_218797_a(sPlayerListItemPacket, this, this.field_147299_f);
        for (SPlayerListItemPacket.AddPlayerData addPlayerData : sPlayerListItemPacket.func_179767_a()) {
            if (sPlayerListItemPacket.func_179768_b() == SPlayerListItemPacket.Action.REMOVE_PLAYER) {
                this.field_147310_i.remove(addPlayerData.func_179962_a().getId());
                continue;
            }
            NetworkPlayerInfo networkPlayerInfo = this.field_147310_i.get(addPlayerData.func_179962_a().getId());
            if (sPlayerListItemPacket.func_179768_b() == SPlayerListItemPacket.Action.ADD_PLAYER) {
                networkPlayerInfo = new NetworkPlayerInfo(addPlayerData);
                this.field_147310_i.put(networkPlayerInfo.func_178845_a().getId(), networkPlayerInfo);
            }
            if (networkPlayerInfo == null) continue;
            switch (sPlayerListItemPacket.func_179768_b()) {
                case ADD_PLAYER: {
                    networkPlayerInfo.func_178839_a(addPlayerData.func_179960_c());
                    networkPlayerInfo.func_178838_a(addPlayerData.func_179963_b());
                    networkPlayerInfo.func_178859_a(addPlayerData.func_179961_d());
                    break;
                }
                case UPDATE_GAME_MODE: {
                    networkPlayerInfo.func_178839_a(addPlayerData.func_179960_c());
                    break;
                }
                case UPDATE_LATENCY: {
                    networkPlayerInfo.func_178838_a(addPlayerData.func_179963_b());
                    break;
                }
                case UPDATE_DISPLAY_NAME: {
                    networkPlayerInfo.func_178859_a(addPlayerData.func_179961_d());
                }
            }
        }
    }

    @Override
    public void func_147272_a(SKeepAlivePacket sKeepAlivePacket) {
        this.func_147297_a(new CKeepAlivePacket(sKeepAlivePacket.func_149134_c()));
    }

    @Override
    public void func_147270_a(SPlayerAbilitiesPacket sPlayerAbilitiesPacket) {
        PacketThreadUtil.func_218797_a(sPlayerAbilitiesPacket, this, this.field_147299_f);
        ClientPlayerEntity clientPlayerEntity = this.field_147299_f.field_71439_g;
        clientPlayerEntity.field_71075_bZ.field_75100_b = sPlayerAbilitiesPacket.func_149106_d();
        clientPlayerEntity.field_71075_bZ.field_75098_d = sPlayerAbilitiesPacket.func_149103_f();
        clientPlayerEntity.field_71075_bZ.field_75102_a = sPlayerAbilitiesPacket.func_149112_c();
        clientPlayerEntity.field_71075_bZ.field_75101_c = sPlayerAbilitiesPacket.func_149105_e();
        clientPlayerEntity.field_71075_bZ.func_195931_a(sPlayerAbilitiesPacket.func_149101_g());
        clientPlayerEntity.field_71075_bZ.func_82877_b(sPlayerAbilitiesPacket.func_149107_h());
    }

    @Override
    public void func_184327_a(SPlaySoundEffectPacket sPlaySoundEffectPacket) {
        PacketThreadUtil.func_218797_a(sPlaySoundEffectPacket, this, this.field_147299_f);
        this.field_147299_f.field_71441_e.func_184148_a(this.field_147299_f.field_71439_g, sPlaySoundEffectPacket.func_149207_d(), sPlaySoundEffectPacket.func_149211_e(), sPlaySoundEffectPacket.func_149210_f(), sPlaySoundEffectPacket.func_186978_a(), sPlaySoundEffectPacket.func_186977_b(), sPlaySoundEffectPacket.func_149208_g(), sPlaySoundEffectPacket.func_149209_h());
    }

    @Override
    public void func_217266_a(SSpawnMovingSoundEffectPacket sSpawnMovingSoundEffectPacket) {
        PacketThreadUtil.func_218797_a(sSpawnMovingSoundEffectPacket, this, this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(sSpawnMovingSoundEffectPacket.func_218762_d());
        if (entity == null) {
            return;
        }
        this.field_147299_f.field_71441_e.func_217384_a(this.field_147299_f.field_71439_g, entity, sSpawnMovingSoundEffectPacket.func_218763_b(), sSpawnMovingSoundEffectPacket.func_218760_c(), sSpawnMovingSoundEffectPacket.func_218764_e(), sSpawnMovingSoundEffectPacket.func_218761_f());
    }

    @Override
    public void func_184329_a(SPlaySoundPacket sPlaySoundPacket) {
        PacketThreadUtil.func_218797_a(sPlaySoundPacket, this, this.field_147299_f);
        this.field_147299_f.func_147118_V().func_147682_a(new SimpleSound(sPlaySoundPacket.func_197698_a(), sPlaySoundPacket.func_186929_b(), sPlaySoundPacket.func_186927_f(), sPlaySoundPacket.func_186928_g(), false, 0, ISound.AttenuationType.LINEAR, (float)sPlaySoundPacket.func_186932_c(), (float)sPlaySoundPacket.func_186926_d(), (float)sPlaySoundPacket.func_186925_e(), false));
    }

    @Override
    public void func_175095_a(SSendResourcePackPacket sSendResourcePackPacket) {
        String string = sSendResourcePackPacket.func_179783_a();
        \u2603 = sSendResourcePackPacket.func_179784_b();
        if (!this.func_189688_b(string)) {
            return;
        }
        if (string.startsWith("level://")) {
            try {
                unsupportedEncodingException = URLDecoder.decode(string.substring("level://".length()), StandardCharsets.UTF_8.toString());
                File file = new File(this.field_147299_f.field_71412_D, "saves");
                \u2603 = new File(file, unsupportedEncodingException);
                if (\u2603.isFile()) {
                    this.func_217283_a(CResourcePackStatusPacket.Action.ACCEPTED);
                    CompletableFuture<Void> completableFuture = this.field_147299_f.func_195541_I().func_217816_a(\u2603);
                    this.func_217279_a(completableFuture);
                    return;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.func_217283_a(CResourcePackStatusPacket.Action.FAILED_DOWNLOAD);
            return;
        }
        ServerData serverData = this.field_147299_f.func_147104_D();
        if (serverData != null && serverData.func_152586_b() == ServerData.ServerResourceMode.ENABLED) {
            this.func_217283_a(CResourcePackStatusPacket.Action.ACCEPTED);
            this.func_217279_a(this.field_147299_f.func_195541_I().func_217818_a(string, \u2603));
        } else if (serverData == null || serverData.func_152586_b() == ServerData.ServerResourceMode.PROMPT) {
            this.field_147299_f.execute(() -> this.field_147299_f.func_147108_a(new ConfirmScreen(bl -> {
                this.field_147299_f = Minecraft.func_71410_x();
                ServerData serverData = this.field_147299_f.func_147104_D();
                if (bl) {
                    if (serverData != null) {
                        serverData.func_152584_a(ServerData.ServerResourceMode.ENABLED);
                    }
                    this.func_217283_a(CResourcePackStatusPacket.Action.ACCEPTED);
                    this.func_217279_a(this.field_147299_f.func_195541_I().func_217818_a(string, \u2603));
                } else {
                    if (serverData != null) {
                        serverData.func_152584_a(ServerData.ServerResourceMode.DISABLED);
                    }
                    this.func_217283_a(CResourcePackStatusPacket.Action.DECLINED);
                }
                ServerList.func_147414_b(serverData);
                this.field_147299_f.func_147108_a(null);
            }, new TranslationTextComponent("multiplayer.texturePrompt.line1", new Object[0]), new TranslationTextComponent("multiplayer.texturePrompt.line2", new Object[0]))));
        } else {
            this.func_217283_a(CResourcePackStatusPacket.Action.DECLINED);
        }
    }

    private boolean func_189688_b(String string) {
        try {
            URI uRI = new URI(string);
            String \u26032 = uRI.getScheme();
            boolean \u26033 = "level".equals(\u26032);
            if (!("http".equals(\u26032) || "https".equals(\u26032) || \u26033)) {
                throw new URISyntaxException(string, "Wrong protocol");
            }
            if (\u26033 && (string.contains("..") || !string.endsWith("/resources.zip"))) {
                throw new URISyntaxException(string, "Invalid levelstorage resourcepack path");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            this.func_217283_a(CResourcePackStatusPacket.Action.FAILED_DOWNLOAD);
            return false;
        }
        return true;
    }

    private void func_217279_a(CompletableFuture<?> completableFuture) {
        ((CompletableFuture)completableFuture.thenRun(() -> this.func_217283_a(CResourcePackStatusPacket.Action.SUCCESSFULLY_LOADED))).exceptionally(throwable -> {
            this.func_217283_a(CResourcePackStatusPacket.Action.FAILED_DOWNLOAD);
            return null;
        });
    }

    private void func_217283_a(CResourcePackStatusPacket.Action action) {
        this.field_147302_e.func_179290_a(new CResourcePackStatusPacket(action));
    }

    @Override
    public void func_184325_a(SUpdateBossInfoPacket sUpdateBossInfoPacket) {
        PacketThreadUtil.func_218797_a(sUpdateBossInfoPacket, this, this.field_147299_f);
        this.field_147299_f.field_71456_v.func_184046_j().func_184055_a(sUpdateBossInfoPacket);
    }

    @Override
    public void func_184324_a(SCooldownPacket sCooldownPacket) {
        PacketThreadUtil.func_218797_a(sCooldownPacket, this, this.field_147299_f);
        if (sCooldownPacket.func_186922_b() == 0) {
            this.field_147299_f.field_71439_g.func_184811_cZ().func_185142_b(sCooldownPacket.func_186920_a());
        } else {
            this.field_147299_f.field_71439_g.func_184811_cZ().func_185145_a(sCooldownPacket.func_186920_a(), sCooldownPacket.func_186922_b());
        }
    }

    @Override
    public void func_184323_a(SMoveVehiclePacket sMoveVehiclePacket) {
        PacketThreadUtil.func_218797_a(sMoveVehiclePacket, this, this.field_147299_f);
        Entity entity = this.field_147299_f.field_71439_g.func_184208_bv();
        if (entity != this.field_147299_f.field_71439_g && entity.func_184186_bw()) {
            entity.func_70080_a(sMoveVehiclePacket.func_186957_a(), sMoveVehiclePacket.func_186955_b(), sMoveVehiclePacket.func_186956_c(), sMoveVehiclePacket.func_186959_d(), sMoveVehiclePacket.func_186958_e());
            this.field_147302_e.func_179290_a(new CMoveVehiclePacket(entity));
        }
    }

    @Override
    public void func_217268_a(SOpenBookWindowPacket sOpenBookWindowPacket) {
        PacketThreadUtil.func_218797_a(sOpenBookWindowPacket, this, this.field_147299_f);
        ItemStack itemStack = this.field_147299_f.field_71439_g.func_184586_b(sOpenBookWindowPacket.func_218746_b());
        if (itemStack.func_77973_b() == Items.field_151164_bB) {
            this.field_147299_f.func_147108_a(new ReadBookScreen(new ReadBookScreen.WrittenBookInfo(itemStack)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_147240_a(SCustomPayloadPlayPacket sCustomPayloadPlayPacket) {
        PacketThreadUtil.func_218797_a(sCustomPayloadPlayPacket, this, this.field_147299_f);
        ResourceLocation resourceLocation = sCustomPayloadPlayPacket.func_149169_c();
        PacketBuffer \u26032 = null;
        try {
            \u26032 = sCustomPayloadPlayPacket.func_180735_b();
            if (SCustomPayloadPlayPacket.field_209911_b.equals(resourceLocation)) {
                this.field_147299_f.field_71439_g.func_175158_f(\u26032.func_150789_c(Short.MAX_VALUE));
            } else if (SCustomPayloadPlayPacket.field_209913_d.equals(resourceLocation)) {
                int n = \u26032.readInt();
                float \u26033 = \u26032.readFloat();
                Path \u26034 = Path.func_186311_b(\u26032);
                this.field_147299_f.field_184132_p.field_188286_a.func_188289_a(n, \u26034, \u26033);
            } else if (SCustomPayloadPlayPacket.field_209914_e.equals(resourceLocation)) {
                long \u26035 = \u26032.func_179260_f();
                BlockPos \u26036 = \u26032.func_179259_c();
                ((NeighborsUpdateDebugRenderer)this.field_147299_f.field_184132_p.field_191557_f).func_191553_a(\u26035, \u26036);
            } else if (SCustomPayloadPlayPacket.field_209915_f.equals(resourceLocation)) {
                BlockPos \u26037 = \u26032.func_179259_c();
                \u2603 = \u26032.readInt();
                ArrayList \u26038 = Lists.newArrayList();
                ArrayList \u26039 = Lists.newArrayList();
                for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                    \u26038.add(\u26032.func_179259_c());
                    \u26039.add(Float.valueOf(\u26032.readFloat()));
                }
                this.field_147299_f.field_184132_p.field_201747_g.func_201742_a(\u26037, \u26038, \u26039);
            } else if (SCustomPayloadPlayPacket.field_209916_g.equals(resourceLocation)) {
                DimensionType \u260310 = DimensionType.func_186069_a(\u26032.readInt());
                MutableBoundingBox \u260311 = new MutableBoundingBox(\u26032.readInt(), \u26032.readInt(), \u26032.readInt(), \u26032.readInt(), \u26032.readInt(), \u26032.readInt());
                \u2603 = \u26032.readInt();
                ArrayList \u260312 = Lists.newArrayList();
                ArrayList \u260313 = Lists.newArrayList();
                for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                    \u260312.add(new MutableBoundingBox(\u26032.readInt(), \u26032.readInt(), \u26032.readInt(), \u26032.readInt(), \u26032.readInt(), \u26032.readInt()));
                    \u260313.add(\u26032.readBoolean());
                }
                this.field_147299_f.field_184132_p.field_201748_h.func_223454_a(\u260311, \u260312, \u260313, \u260310);
            } else if (SCustomPayloadPlayPacket.field_209917_h.equals(resourceLocation)) {
                ((WorldGenAttemptsDebugRenderer)this.field_147299_f.field_184132_p.field_201750_j).func_201734_a(\u26032.func_179259_c(), \u26032.readFloat(), \u26032.readFloat(), \u26032.readFloat(), \u26032.readFloat(), \u26032.readFloat());
            } else if (SCustomPayloadPlayPacket.field_218699_j.equals(resourceLocation)) {
                \u2603 = \u26032.readInt();
                for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                    this.field_147299_f.field_184132_p.field_217741_m.func_217701_a(\u26032.func_218667_g());
                }
                \u2603 = \u26032.readInt();
                for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                    this.field_147299_f.field_184132_p.field_217741_m.func_217700_b(\u26032.func_218667_g());
                }
            } else if (SCustomPayloadPlayPacket.field_218697_h.equals(resourceLocation)) {
                BlockPos \u260314 = \u26032.func_179259_c();
                String \u260315 = \u26032.func_218666_n();
                \u2603 = \u26032.readInt();
                PointOfInterestDebugRenderer.POIInfo \u260316 = new PointOfInterestDebugRenderer.POIInfo(\u260314, \u260315, \u2603);
                this.field_147299_f.field_184132_p.field_217741_m.func_217691_a(\u260316);
            } else if (SCustomPayloadPlayPacket.field_218698_i.equals(resourceLocation)) {
                BlockPos \u260317 = \u26032.func_179259_c();
                this.field_147299_f.field_184132_p.field_217741_m.func_217698_a(\u260317);
            } else if (SCustomPayloadPlayPacket.field_218696_g.equals(resourceLocation)) {
                BlockPos \u260318 = \u26032.func_179259_c();
                \u2603 = \u26032.readInt();
                this.field_147299_f.field_184132_p.field_217741_m.func_217706_a(\u260318, \u2603);
            } else if (SCustomPayloadPlayPacket.field_218700_k.equals(resourceLocation)) {
                BlockPos \u260319 = \u26032.func_179259_c();
                \u2603 = \u26032.readInt();
                \u2603 = \u26032.readInt();
                ArrayList \u260320 = Lists.newArrayList();
                for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                    \u2603 = \u26032.readInt();
                    boolean bl = \u26032.readBoolean();
                    String \u260321 = \u26032.func_150789_c(255);
                    \u260320.add(new EntityAIDebugRenderer.Entry(\u260319, \u2603, \u260321, bl));
                }
                this.field_147299_f.field_184132_p.field_217742_n.func_217682_a(\u2603, \u260320);
            } else if (SCustomPayloadPlayPacket.field_222945_m.equals(resourceLocation)) {
                int n = \u26032.readInt();
                ArrayList \u260322 = Lists.newArrayList();
                for (\u2603 = 0; \u2603 < n; ++\u2603) {
                    \u260322.add(\u26032.func_179259_c());
                }
                this.field_147299_f.field_184132_p.field_222927_n.func_222906_a(\u260322);
            } else if (SCustomPayloadPlayPacket.field_218701_l.equals(resourceLocation)) {
                double \u260323 = \u26032.readDouble();
                double \u260324 = \u26032.readDouble();
                double \u260325 = \u26032.readDouble();
                Position \u260326 = new Position(\u260323, \u260324, \u260325);
                UUID \u260327 = \u26032.func_179253_g();
                \u2603 = \u26032.readInt();
                String \u260328 = \u26032.func_218666_n();
                String \u260329 = \u26032.func_218666_n();
                \u2603 = \u26032.readInt();
                String \u260330 = \u26032.func_218666_n();
                boolean \u260331 = \u26032.readBoolean();
                Path \u260332 = \u260331 ? Path.func_186311_b(\u26032) : null;
                boolean \u260333 = \u26032.readBoolean();
                PointOfInterestDebugRenderer.BrainInfo \u260334 = new PointOfInterestDebugRenderer.BrainInfo(\u260327, \u2603, \u260328, \u260329, \u2603, \u260326, \u260330, \u260332, \u260333);
                \u2603 = \u26032.readInt();
                for (n = 0; n < \u2603; ++n) {
                    String string = \u26032.func_218666_n();
                    \u260334.field_217751_e.add(string);
                }
                int n = \u26032.readInt();
                for (n2 = 0; n2 < n; ++n2) {
                    String string = \u26032.func_218666_n();
                    \u260334.field_217752_f.add(string);
                }
                int n2 = \u26032.readInt();
                for (n3 = 0; n3 < n2; ++n3) {
                    String string = \u26032.func_218666_n();
                    \u260334.field_217753_g.add(string);
                }
                int n3 = \u26032.readInt();
                for (n4 = 0; n4 < n3; ++n4) {
                    BlockPos blockPos = \u26032.func_179259_c();
                    \u260334.field_217754_h.add(blockPos);
                }
                int n4 = \u26032.readInt();
                for (\u2603 = 0; \u2603 < n4; ++\u2603) {
                    String string = \u26032.func_218666_n();
                    \u260334.field_223457_m.add(string);
                }
                this.field_147299_f.field_184132_p.field_217741_m.func_217692_a(\u260334);
            } else if (SCustomPayloadPlayPacket.field_229727_m_.equals(resourceLocation)) {
                int n;
                double d = \u26032.readDouble();
                \u2603 = \u26032.readDouble();
                \u2603 = \u26032.readDouble();
                Position \u260335 = new Position(d, \u2603, \u2603);
                UUID \u260336 = \u26032.func_179253_g();
                int \u260337 = \u26032.readInt();
                boolean \u260338 = \u26032.readBoolean();
                BlockPos \u260339 = null;
                if (\u260338) {
                    \u260339 = \u26032.func_179259_c();
                }
                boolean \u260340 = \u26032.readBoolean();
                BlockPos \u260341 = null;
                if (\u260340) {
                    \u260341 = \u26032.func_179259_c();
                }
                int \u260342 = \u26032.readInt();
                boolean \u260343 = \u26032.readBoolean();
                Path \u260344 = null;
                if (\u260343) {
                    \u260344 = Path.func_186311_b(\u26032);
                }
                BeeDebugRenderer.Bee \u260345 = new BeeDebugRenderer.Bee(\u260336, \u260337, \u260335, \u260344, \u260339, \u260341, \u260342);
                int \u260346 = \u26032.readInt();
                for (n = 0; n < \u260346; ++n) {
                    String string = \u26032.func_218666_n();
                    \u260345.field_229005_h_.add(string);
                }
                n = \u26032.readInt();
                for (\u2603 = 0; \u2603 < n; ++\u2603) {
                    BlockPos blockPos = \u26032.func_179259_c();
                    \u260345.field_229006_i_.add(blockPos);
                }
                this.field_147299_f.field_184132_p.field_229017_n_.func_228964_a_(\u260345);
            } else if (SCustomPayloadPlayPacket.field_229728_n_.equals(resourceLocation)) {
                BlockPos blockPos = \u26032.func_179259_c();
                String \u260347 = \u26032.func_218666_n();
                int \u260348 = \u26032.readInt();
                int \u260349 = \u26032.readInt();
                boolean \u260350 = \u26032.readBoolean();
                BeeDebugRenderer.Hive \u260351 = new BeeDebugRenderer.Hive(blockPos, \u260347, \u260348, \u260349, \u260350, this.field_147300_g.func_82737_E());
                this.field_147299_f.field_184132_p.field_229017_n_.func_228966_a_(\u260351);
            } else if (SCustomPayloadPlayPacket.field_229730_p_.equals(resourceLocation)) {
                this.field_147299_f.field_184132_p.field_229018_q_.func_217675_a();
            } else if (SCustomPayloadPlayPacket.field_229729_o_.equals(resourceLocation)) {
                \u2603 = \u26032.func_179259_c();
                int \u260352 = \u26032.readInt();
                String \u260353 = \u26032.func_218666_n();
                int \u260354 = \u26032.readInt();
                this.field_147299_f.field_184132_p.field_229018_q_.func_229022_a_(\u2603, \u260352, \u260353, \u260354);
            } else {
                field_147301_d.warn("Unknown custom packed identifier: {}", (Object)resourceLocation);
            }
        }
        finally {
            if (\u26032 != null) {
                \u26032.release();
            }
        }
    }

    @Override
    public void func_147291_a(SScoreboardObjectivePacket sScoreboardObjectivePacket) {
        PacketThreadUtil.func_218797_a(sScoreboardObjectivePacket, this, this.field_147299_f);
        Scoreboard scoreboard = this.field_147300_g.func_96441_U();
        String \u26032 = sScoreboardObjectivePacket.func_149339_c();
        if (sScoreboardObjectivePacket.func_149338_e() == 0) {
            scoreboard.func_199868_a(\u26032, ScoreCriteria.field_96641_b, sScoreboardObjectivePacket.func_149337_d(), sScoreboardObjectivePacket.func_199856_d());
        } else if (scoreboard.func_197900_b(\u26032)) {
            ScoreObjective scoreObjective = scoreboard.func_96518_b(\u26032);
            if (sScoreboardObjectivePacket.func_149338_e() == 1) {
                scoreboard.func_96519_k(scoreObjective);
            } else if (sScoreboardObjectivePacket.func_149338_e() == 2) {
                scoreObjective.func_199866_a(sScoreboardObjectivePacket.func_199856_d());
                scoreObjective.func_199864_a(sScoreboardObjectivePacket.func_149337_d());
            }
        }
    }

    @Override
    public void func_147250_a(SUpdateScorePacket sUpdateScorePacket) {
        PacketThreadUtil.func_218797_a(sUpdateScorePacket, this, this.field_147299_f);
        Scoreboard scoreboard = this.field_147300_g.func_96441_U();
        String \u26032 = sUpdateScorePacket.func_149321_d();
        switch (sUpdateScorePacket.func_197701_d()) {
            case CHANGE: {
                ScoreObjective scoreObjective = scoreboard.func_197899_c(\u26032);
                Score \u26033 = scoreboard.func_96529_a(sUpdateScorePacket.func_149324_c(), scoreObjective);
                \u26033.func_96647_c(sUpdateScorePacket.func_149323_e());
                break;
            }
            case REMOVE: {
                scoreboard.func_178822_d(sUpdateScorePacket.func_149324_c(), scoreboard.func_96518_b(\u26032));
            }
        }
    }

    @Override
    public void func_147254_a(SDisplayObjectivePacket sDisplayObjectivePacket) {
        PacketThreadUtil.func_218797_a(sDisplayObjectivePacket, this, this.field_147299_f);
        Scoreboard scoreboard = this.field_147300_g.func_96441_U();
        String \u26032 = sDisplayObjectivePacket.func_149370_d();
        ScoreObjective \u26033 = \u26032 == null ? null : scoreboard.func_197899_c(\u26032);
        scoreboard.func_96530_a(sDisplayObjectivePacket.func_149371_c(), \u26033);
    }

    @Override
    public void func_147247_a(STeamsPacket sTeamsPacket2) {
        STeamsPacket sTeamsPacket2;
        PacketThreadUtil.func_218797_a(sTeamsPacket2, this, this.field_147299_f);
        Scoreboard scoreboard = this.field_147300_g.func_96441_U();
        ScorePlayerTeam \u26032 = sTeamsPacket2.func_149307_h() == 0 ? scoreboard.func_96527_f(sTeamsPacket2.func_149312_c()) : scoreboard.func_96508_e(sTeamsPacket2.func_149312_c());
        if (sTeamsPacket2.func_149307_h() == 0 || sTeamsPacket2.func_149307_h() == 2) {
            \u26032.func_96664_a(sTeamsPacket2.func_149306_d());
            \u26032.func_178774_a(sTeamsPacket2.func_200537_f());
            \u26032.func_98298_a(sTeamsPacket2.func_149308_i());
            Team.Visible visible = Team.Visible.func_178824_a(sTeamsPacket2.func_179814_i());
            if (visible != null) {
                \u26032.func_178772_a(visible);
            }
            if ((object = Team.CollisionRule.func_186686_a(sTeamsPacket2.func_186975_j())) != null) {
                \u26032.func_186682_a((Team.CollisionRule)((Object)object));
            }
            \u26032.func_207408_a(sTeamsPacket2.func_207507_i());
            \u26032.func_207409_b(sTeamsPacket2.func_207508_j());
        }
        if (sTeamsPacket2.func_149307_h() == 0 || sTeamsPacket2.func_149307_h() == 3) {
            for (Object object : sTeamsPacket2.func_149310_g()) {
                scoreboard.func_197901_a((String)object, \u26032);
            }
        }
        if (sTeamsPacket2.func_149307_h() == 4) {
            for (Object object : sTeamsPacket2.func_149310_g()) {
                scoreboard.func_96512_b((String)object, \u26032);
            }
        }
        if (sTeamsPacket2.func_149307_h() == 1) {
            scoreboard.func_96511_d(\u26032);
        }
    }

    @Override
    public void func_147289_a(SSpawnParticlePacket sSpawnParticlePacket) {
        PacketThreadUtil.func_218797_a(sSpawnParticlePacket, this, this.field_147299_f);
        if (sSpawnParticlePacket.func_149222_k() == 0) {
            double d = sSpawnParticlePacket.func_149227_j() * sSpawnParticlePacket.func_149221_g();
            \u2603 = sSpawnParticlePacket.func_149227_j() * sSpawnParticlePacket.func_149224_h();
            \u2603 = sSpawnParticlePacket.func_149227_j() * sSpawnParticlePacket.func_149223_i();
            try {
                this.field_147300_g.func_195590_a(sSpawnParticlePacket.func_197699_j(), sSpawnParticlePacket.func_179750_b(), sSpawnParticlePacket.func_149220_d(), sSpawnParticlePacket.func_149226_e(), sSpawnParticlePacket.func_149225_f(), d, \u2603, \u2603);
            }
            catch (Throwable \u26032) {
                field_147301_d.warn("Could not spawn particle effect {}", (Object)sSpawnParticlePacket.func_197699_j());
            }
        } else {
            for (int i = 0; i < sSpawnParticlePacket.func_149222_k(); ++i) {
                double d = this.field_147306_l.nextGaussian() * (double)sSpawnParticlePacket.func_149221_g();
                \u2603 = this.field_147306_l.nextGaussian() * (double)sSpawnParticlePacket.func_149224_h();
                \u2603 = this.field_147306_l.nextGaussian() * (double)sSpawnParticlePacket.func_149223_i();
                \u2603 = this.field_147306_l.nextGaussian() * (double)sSpawnParticlePacket.func_149227_j();
                \u2603 = this.field_147306_l.nextGaussian() * (double)sSpawnParticlePacket.func_149227_j();
                \u2603 = this.field_147306_l.nextGaussian() * (double)sSpawnParticlePacket.func_149227_j();
                try {
                    this.field_147300_g.func_195590_a(sSpawnParticlePacket.func_197699_j(), sSpawnParticlePacket.func_179750_b(), sSpawnParticlePacket.func_149220_d() + d, sSpawnParticlePacket.func_149226_e() + \u2603, sSpawnParticlePacket.func_149225_f() + \u2603, \u2603, \u2603, \u2603);
                    continue;
                }
                catch (Throwable \u26033) {
                    field_147301_d.warn("Could not spawn particle effect {}", (Object)sSpawnParticlePacket.func_197699_j());
                    return;
                }
            }
        }
    }

    @Override
    public void func_147290_a(SEntityPropertiesPacket sEntityPropertiesPacket) {
        PacketThreadUtil.func_218797_a(sEntityPropertiesPacket, this, this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(sEntityPropertiesPacket.func_149442_c());
        if (entity == null) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            throw new IllegalStateException("Server tried to update attributes of a non-living entity (actually: " + entity + ")");
        }
        AbstractAttributeMap \u26032 = ((LivingEntity)entity).func_110140_aT();
        for (SEntityPropertiesPacket.Snapshot snapshot : sEntityPropertiesPacket.func_149441_d()) {
            IAttributeInstance iAttributeInstance = \u26032.func_111152_a(snapshot.func_151409_a());
            if (iAttributeInstance == null) {
                iAttributeInstance = \u26032.func_111150_b(new RangedAttribute(null, snapshot.func_151409_a(), 0.0, Double.MIN_NORMAL, Double.MAX_VALUE));
            }
            iAttributeInstance.func_111128_a(snapshot.func_151410_b());
            iAttributeInstance.func_142049_d();
            for (AttributeModifier attributeModifier : snapshot.func_151408_c()) {
                iAttributeInstance.func_111121_a(attributeModifier);
            }
        }
    }

    @Override
    public void func_194307_a(SPlaceGhostRecipePacket sPlaceGhostRecipePacket) {
        PacketThreadUtil.func_218797_a(sPlaceGhostRecipePacket, this, this.field_147299_f);
        Container container = this.field_147299_f.field_71439_g.field_71070_bA;
        if (container.field_75152_c != sPlaceGhostRecipePacket.func_194313_b() || !container.func_75129_b(this.field_147299_f.field_71439_g)) {
            return;
        }
        this.field_199528_o.func_215367_a(sPlaceGhostRecipePacket.func_199615_a()).ifPresent(iRecipe -> {
            if (this.field_147299_f.field_71462_r instanceof IRecipeShownListener) {
                RecipeBookGui recipeBookGui = ((IRecipeShownListener)((Object)this.field_147299_f.field_71462_r)).func_194310_f();
                recipeBookGui.func_193951_a((IRecipe<?>)iRecipe, container.field_75151_b);
            }
        });
    }

    @Override
    public void func_217269_a(SUpdateLightPacket sUpdateLightPacket) {
        PacketThreadUtil.func_218797_a(sUpdateLightPacket, this, this.field_147299_f);
        int n = sUpdateLightPacket.func_218716_b();
        \u2603 = sUpdateLightPacket.func_218714_c();
        WorldLightManager \u26032 = this.field_147300_g.func_72863_F().func_212863_j_();
        \u2603 = sUpdateLightPacket.func_218715_d();
        \u2603 = sUpdateLightPacket.func_218717_e();
        Iterator<byte[]> \u26033 = sUpdateLightPacket.func_218712_f().iterator();
        this.func_217284_a(n, \u2603, \u26032, LightType.SKY, \u2603, \u2603, \u26033);
        \u2603 = sUpdateLightPacket.func_218718_g();
        \u2603 = sUpdateLightPacket.func_218719_h();
        Iterator<byte[]> \u26034 = sUpdateLightPacket.func_218713_i().iterator();
        this.func_217284_a(n, \u2603, \u26032, LightType.BLOCK, \u2603, \u2603, \u26034);
    }

    @Override
    public void func_217273_a(SMerchantOffersPacket sMerchantOffersPacket) {
        PacketThreadUtil.func_218797_a(sMerchantOffersPacket, this, this.field_147299_f);
        Container container = this.field_147299_f.field_71439_g.field_71070_bA;
        if (sMerchantOffersPacket.func_218732_b() == container.field_75152_c && container instanceof MerchantContainer) {
            ((MerchantContainer)container).func_217044_a(new MerchantOffers(sMerchantOffersPacket.func_218733_c().func_222199_a()));
            ((MerchantContainer)container).func_217052_e(sMerchantOffersPacket.func_218734_e());
            ((MerchantContainer)container).func_217043_f(sMerchantOffersPacket.func_218731_d());
            ((MerchantContainer)container).func_217045_a(sMerchantOffersPacket.func_218735_f());
            ((MerchantContainer)container).func_223431_b(sMerchantOffersPacket.func_223477_g());
        }
    }

    @Override
    public void func_217270_a(SUpdateViewDistancePacket sUpdateViewDistancePacket) {
        PacketThreadUtil.func_218797_a(sUpdateViewDistancePacket, this, this.field_147299_f);
        this.field_217287_m = sUpdateViewDistancePacket.func_218758_b();
        this.field_147300_g.func_72863_F().func_217248_a(sUpdateViewDistancePacket.func_218758_b());
    }

    @Override
    public void func_217267_a(SUpdateChunkPositionPacket sUpdateChunkPositionPacket) {
        PacketThreadUtil.func_218797_a(sUpdateChunkPositionPacket, this, this.field_147299_f);
        this.field_147300_g.func_72863_F().func_217251_d(sUpdateChunkPositionPacket.func_218755_b(), sUpdateChunkPositionPacket.func_218754_c());
    }

    @Override
    public void func_225312_a(SPlayerDiggingPacket sPlayerDiggingPacket) {
        PacketThreadUtil.func_218797_a(sPlayerDiggingPacket, this, this.field_147299_f);
        this.field_147299_f.field_71442_b.func_225323_a(this.field_147300_g, sPlayerDiggingPacket.func_225374_c(), sPlayerDiggingPacket.func_225375_b(), sPlayerDiggingPacket.func_225377_e(), sPlayerDiggingPacket.func_225376_d());
    }

    private void func_217284_a(int n, int n2, WorldLightManager worldLightManager, LightType lightType, int n3, int n4, Iterator<byte[]> iterator) {
        for (int i = 0; i < 18; ++i) {
            \u2603 = -1 + i;
            boolean bl = (n3 & 1 << i) != 0;
            boolean bl2 = \u2603 = (n4 & 1 << i) != 0;
            if (!bl && !\u2603) continue;
            worldLightManager.func_215574_a(lightType, SectionPos.func_218154_a(n, \u2603, n2), bl ? new NibbleArray((byte[])iterator.next().clone()) : new NibbleArray());
            this.field_147300_g.func_217427_b(n, \u2603, n2);
        }
    }

    @Override
    public NetworkManager func_147298_b() {
        return this.field_147302_e;
    }

    public Collection<NetworkPlayerInfo> func_175106_d() {
        return this.field_147310_i.values();
    }

    @Nullable
    public NetworkPlayerInfo func_175102_a(UUID uUID) {
        return this.field_147310_i.get(uUID);
    }

    @Nullable
    public NetworkPlayerInfo func_175104_a(String string) {
        for (NetworkPlayerInfo networkPlayerInfo : this.field_147310_i.values()) {
            if (!networkPlayerInfo.func_178845_a().getName().equals(string)) continue;
            return networkPlayerInfo;
        }
        return null;
    }

    public GameProfile func_175105_e() {
        return this.field_175107_d;
    }

    public ClientAdvancementManager func_191982_f() {
        return this.field_191983_k;
    }

    public CommandDispatcher<ISuggestionProvider> func_195515_i() {
        return this.field_195517_n;
    }

    public ClientWorld func_195514_j() {
        return this.field_147300_g;
    }

    public NetworkTagManager func_199724_l() {
        return this.field_199725_m;
    }

    public NBTQueryManager func_211523_k() {
        return this.field_211524_l;
    }

    public UUID func_217277_l() {
        return this.field_217289_q;
    }
}

