/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.google.common.base.Charsets;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.particle.BarrierParticle;
import net.minecraft.client.particle.BreakingParticle;
import net.minecraft.client.particle.BubbleColumnUpParticle;
import net.minecraft.client.particle.BubbleParticle;
import net.minecraft.client.particle.BubblePopParticle;
import net.minecraft.client.particle.CampfireParticle;
import net.minecraft.client.particle.CloudParticle;
import net.minecraft.client.particle.CritParticle;
import net.minecraft.client.particle.CurrentDownParticle;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.DragonBreathParticle;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.EmitterParticle;
import net.minecraft.client.particle.EnchantmentTableParticle;
import net.minecraft.client.particle.EndRodParticle;
import net.minecraft.client.particle.FallingDustParticle;
import net.minecraft.client.particle.FireworkParticle;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.HeartParticle;
import net.minecraft.client.particle.HugeExplosionParticle;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.LargeExplosionParticle;
import net.minecraft.client.particle.LargeSmokeParticle;
import net.minecraft.client.particle.LavaParticle;
import net.minecraft.client.particle.MobAppearanceParticle;
import net.minecraft.client.particle.NoteParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.PoofParticle;
import net.minecraft.client.particle.PortalParticle;
import net.minecraft.client.particle.RainParticle;
import net.minecraft.client.particle.RedstoneParticle;
import net.minecraft.client.particle.SmokeParticle;
import net.minecraft.client.particle.SpellParticle;
import net.minecraft.client.particle.SpitParticle;
import net.minecraft.client.particle.SplashParticle;
import net.minecraft.client.particle.SquidInkParticle;
import net.minecraft.client.particle.SuspendedTownParticle;
import net.minecraft.client.particle.SweepAttackParticle;
import net.minecraft.client.particle.TexturesParticle;
import net.minecraft.client.particle.TotemOfUndyingParticle;
import net.minecraft.client.particle.UnderwaterParticle;
import net.minecraft.client.particle.WaterWakeParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class ParticleManager
implements IFutureReloadListener {
    private static final List<IParticleRenderType> field_215241_b = ImmutableList.of((Object)IParticleRenderType.field_217601_a, (Object)IParticleRenderType.field_217602_b, (Object)IParticleRenderType.field_217604_d, (Object)IParticleRenderType.field_217603_c, (Object)IParticleRenderType.field_217605_e);
    protected World field_78878_a;
    private final Map<IParticleRenderType, Queue<Particle>> field_78876_b = Maps.newIdentityHashMap();
    private final Queue<EmitterParticle> field_178933_d = Queues.newArrayDeque();
    private final TextureManager field_78877_c;
    private final Random field_78875_d = new Random();
    private final Int2ObjectMap<IParticleFactory<?>> field_178932_g = new Int2ObjectOpenHashMap();
    private final Queue<Particle> field_187241_h = Queues.newArrayDeque();
    private final Map<ResourceLocation, AnimatedSpriteImpl> field_215242_i = Maps.newHashMap();
    private final AtlasTexture field_215243_j = new AtlasTexture(AtlasTexture.field_215262_g);

    public ParticleManager(World world, TextureManager textureManager) {
        textureManager.func_229263_a_(this.field_215243_j.func_229223_g_(), this.field_215243_j);
        this.field_78878_a = world;
        this.field_78877_c = textureManager;
        this.func_178930_c();
    }

    private void func_178930_c() {
        this.func_215234_a(ParticleTypes.field_197608_a, SpellParticle.AmbientMobFactory::new);
        this.func_215234_a(ParticleTypes.field_197609_b, HeartParticle.AngryVillagerFactory::new);
        this.func_199283_a(ParticleTypes.field_197610_c, new BarrierParticle.Factory());
        this.func_199283_a(ParticleTypes.field_197611_d, new DiggingParticle.Factory());
        this.func_215234_a(ParticleTypes.field_197612_e, BubbleParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_203220_f, BubbleColumnUpParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_203217_T, BubblePopParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_218417_ae, CampfireParticle.CozySmokeFactory::new);
        this.func_215234_a(ParticleTypes.field_218418_af, CampfireParticle.SignalSmokeFactory::new);
        this.func_215234_a(ParticleTypes.field_197613_f, CloudParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_218420_D, SuspendedTownParticle.ComposterFactory::new);
        this.func_215234_a(ParticleTypes.field_197614_g, CritParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_203218_U, CurrentDownParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197615_h, CritParticle.DamageIndicatorFactory::new);
        this.func_215234_a(ParticleTypes.field_197616_i, DragonBreathParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_206864_X, SuspendedTownParticle.DolphinSpeedFactory::new);
        this.func_215234_a(ParticleTypes.field_197617_j, DripParticle.DrippingLavaFactory::new);
        this.func_215234_a(ParticleTypes.field_218423_k, DripParticle.FallingLavaFactory::new);
        this.func_215234_a(ParticleTypes.field_218424_l, DripParticle.LandingLavaFactory::new);
        this.func_215234_a(ParticleTypes.field_197618_k, DripParticle.DrippingWaterFactory::new);
        this.func_215234_a(ParticleTypes.field_218425_n, DripParticle.FallingWaterFactory::new);
        this.func_215234_a(ParticleTypes.field_197619_l, RedstoneParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197620_m, SpellParticle.Factory::new);
        this.func_199283_a(ParticleTypes.field_197621_n, new MobAppearanceParticle.Factory());
        this.func_215234_a(ParticleTypes.field_197622_o, CritParticle.MagicFactory::new);
        this.func_215234_a(ParticleTypes.field_197623_p, EnchantmentTableParticle.EnchantmentTable::new);
        this.func_215234_a(ParticleTypes.field_197624_q, EndRodParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197625_r, SpellParticle.MobFactory::new);
        this.func_199283_a(ParticleTypes.field_197626_s, new HugeExplosionParticle.Factory());
        this.func_215234_a(ParticleTypes.field_197627_t, LargeExplosionParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197628_u, FallingDustParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197629_v, FireworkParticle.SparkFactory::new);
        this.func_215234_a(ParticleTypes.field_197630_w, WaterWakeParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197631_x, FlameParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_218419_B, FireworkParticle.OverlayFactory::new);
        this.func_215234_a(ParticleTypes.field_197632_y, SuspendedTownParticle.HappyVillagerFactory::new);
        this.func_215234_a(ParticleTypes.field_197633_z, HeartParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197590_A, SpellParticle.InstantFactory::new);
        this.func_199283_a(ParticleTypes.field_197591_B, new BreakingParticle.Factory());
        this.func_199283_a(ParticleTypes.field_197592_C, new BreakingParticle.SlimeFactory());
        this.func_199283_a(ParticleTypes.field_197593_D, new BreakingParticle.SnowballFactory());
        this.func_215234_a(ParticleTypes.field_197594_E, LargeSmokeParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197595_F, LavaParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197596_G, SuspendedTownParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_205167_W, EnchantmentTableParticle.NautilusFactory::new);
        this.func_215234_a(ParticleTypes.field_197597_H, NoteParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197598_I, PoofParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197599_J, PortalParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197600_K, RainParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197601_L, SmokeParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_218421_R, CloudParticle.SneezeFactory::new);
        this.func_215234_a(ParticleTypes.field_197602_M, SpitParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197603_N, SweepAttackParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197604_O, TotemOfUndyingParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_203219_V, SquidInkParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197605_P, UnderwaterParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_218422_X, SplashParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197607_R, SpellParticle.WitchFactory::new);
        this.func_215234_a(ParticleTypes.field_229427_ag_, DripParticle.DrippingHoneyFactory::new);
        this.func_215234_a(ParticleTypes.field_229428_ah_, DripParticle.FallingHoneyFactory::new);
        this.func_215234_a(ParticleTypes.field_229429_ai_, DripParticle.LandingHoneyFactory::new);
        this.func_215234_a(ParticleTypes.field_229430_aj_, DripParticle.FallingNectarFactory::new);
    }

    private <T extends IParticleData> void func_199283_a(ParticleType<T> particleType, IParticleFactory<T> iParticleFactory) {
        this.field_178932_g.put(Registry.field_212632_u.func_148757_b(particleType), iParticleFactory);
    }

    private <T extends IParticleData> void func_215234_a(ParticleType<T> particleType, IParticleMetaFactory<T> iParticleMetaFactory) {
        AnimatedSpriteImpl animatedSpriteImpl = new AnimatedSpriteImpl();
        this.field_215242_i.put(Registry.field_212632_u.func_177774_c(particleType), animatedSpriteImpl);
        this.field_178932_g.put(Registry.field_212632_u.func_148757_b(particleType), iParticleMetaFactory.create(animatedSpriteImpl));
    }

    @Override
    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage iStage, IResourceManager iResourceManager, IProfiler iProfiler, IProfiler iProfiler2, Executor executor, Executor executor2) {
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        CompletableFuture[] \u26032 = (CompletableFuture[])Registry.field_212632_u.func_148742_b().stream().map(resourceLocation -> CompletableFuture.runAsync(() -> this.func_215236_a(iResourceManager, (ResourceLocation)resourceLocation, concurrentMap), executor)).toArray(CompletableFuture[]::new);
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(\u26032).thenApplyAsync(void_ -> {
            iProfiler.func_219894_a();
            iProfiler.func_76320_a("stitching");
            AtlasTexture.SheetData sheetData = this.field_215243_j.func_229220_a_(iResourceManager, concurrentMap.values().stream().flatMap(Collection::stream), iProfiler, 0);
            iProfiler.func_76319_b();
            iProfiler.func_219897_b();
            return sheetData;
        }, executor)).thenCompose(iStage::func_216872_a)).thenAcceptAsync(sheetData -> {
            this.field_78876_b.clear();
            iProfiler2.func_219894_a();
            iProfiler2.func_76320_a("upload");
            this.field_215243_j.func_215260_a((AtlasTexture.SheetData)sheetData);
            iProfiler2.func_219895_b("bindSpriteSets");
            TextureAtlasSprite textureAtlasSprite = this.field_215243_j.func_195424_a(MissingTextureSprite.func_195675_b());
            concurrentMap.forEach((resourceLocation, list) -> {
                ImmutableList immutableList = list.isEmpty() ? ImmutableList.of((Object)textureAtlasSprite) : (ImmutableList)list.stream().map(this.field_215243_j::func_195424_a).collect(ImmutableList.toImmutableList());
                this.field_215242_i.get(resourceLocation).func_217592_a((List<TextureAtlasSprite>)immutableList);
            });
            iProfiler2.func_76319_b();
            iProfiler2.func_219897_b();
        }, executor2);
    }

    public void func_215232_a() {
        this.field_215243_j.func_195419_g();
    }

    private void func_215236_a(IResourceManager iResourceManager, ResourceLocation resourceLocation2, Map<ResourceLocation, List<ResourceLocation>> map) {
        ResourceLocation resourceLocation3 = new ResourceLocation(resourceLocation2.func_110624_b(), "particles/" + resourceLocation2.func_110623_a() + ".json");
        try (IResource iResource = iResourceManager.func_199002_a(resourceLocation3);
             InputStreamReader inputStreamReader = new InputStreamReader(iResource.func_199027_b(), Charsets.UTF_8);){
            TexturesParticle texturesParticle = TexturesParticle.func_217595_a(JSONUtils.func_212743_a(inputStreamReader));
            List<ResourceLocation> \u26032 = texturesParticle.func_217596_a();
            boolean \u26033 = this.field_215242_i.containsKey(resourceLocation2);
            if (\u26032 == null) {
                if (\u26033) {
                    throw new IllegalStateException("Missing texture list for particle " + resourceLocation2);
                }
            } else {
                if (!\u26033) {
                    throw new IllegalStateException("Redundant texture list for particle " + resourceLocation2);
                }
                map.put(resourceLocation2, \u26032.stream().map(resourceLocation -> new ResourceLocation(resourceLocation.func_110624_b(), "particle/" + resourceLocation.func_110623_a())).collect(Collectors.toList()));
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to load description for particle " + resourceLocation2, iOException);
        }
    }

    public void func_199282_a(Entity entity, IParticleData iParticleData) {
        this.field_178933_d.add(new EmitterParticle(this.field_78878_a, entity, iParticleData));
    }

    public void func_199281_a(Entity entity, IParticleData iParticleData, int n) {
        this.field_178933_d.add(new EmitterParticle(this.field_78878_a, entity, iParticleData, n));
    }

    @Nullable
    public Particle func_199280_a(IParticleData iParticleData, double d, double d2, double d3, double d4, double d5, double d6) {
        Particle particle = this.func_199927_b(iParticleData, d, d2, d3, d4, d5, d6);
        if (particle != null) {
            this.func_78873_a(particle);
            return particle;
        }
        return null;
    }

    @Nullable
    private <T extends IParticleData> Particle func_199927_b(T t, double d, double d2, double d3, double d4, double d5, double d6) {
        IParticleFactory iParticleFactory = (IParticleFactory)this.field_178932_g.get(Registry.field_212632_u.func_148757_b(t.func_197554_b()));
        if (iParticleFactory == null) {
            return null;
        }
        return iParticleFactory.func_199234_a(t, this.field_78878_a, d, d2, d3, d4, d5, d6);
    }

    public void func_78873_a(Particle particle) {
        this.field_187241_h.add(particle);
    }

    public void func_78868_a() {
        Object object;
        this.field_78876_b.forEach((iParticleRenderType, queue) -> {
            this.field_78878_a.func_217381_Z().func_76320_a(iParticleRenderType.toString());
            this.func_187240_a((Collection<Particle>)queue);
            this.field_78878_a.func_217381_Z().func_76319_b();
        });
        if (!this.field_178933_d.isEmpty()) {
            object = Lists.newArrayList();
            for (EmitterParticle emitterParticle : this.field_178933_d) {
                emitterParticle.func_189213_a();
                if (emitterParticle.func_187113_k()) continue;
                object.add(emitterParticle);
            }
            this.field_178933_d.removeAll((Collection<?>)object);
        }
        if (!this.field_187241_h.isEmpty()) {
            while ((object = this.field_187241_h.poll()) != null) {
                this.field_78876_b.computeIfAbsent(((Particle)object).func_217558_b(), iParticleRenderType -> EvictingQueue.create((int)16384)).add(object);
            }
        }
    }

    private void func_187240_a(Collection<Particle> collection) {
        if (!collection.isEmpty()) {
            Iterator<Particle> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Particle particle = iterator.next();
                this.func_178923_d(particle);
                if (particle.func_187113_k()) continue;
                iterator.remove();
            }
        }
    }

    private void func_178923_d(Particle particle) {
        try {
            particle.func_189213_a();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Ticking Particle");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Particle being ticked");
            \u26032.func_189529_a("Particle", particle::toString);
            \u26032.func_189529_a("Particle Type", particle.func_217558_b()::toString);
            throw new ReportedException(crashReport);
        }
    }

    public void func_228345_a_(MatrixStack matrixStack, IRenderTypeBuffer.Impl impl, LightTexture lightTexture, ActiveRenderInfo activeRenderInfo, float f) {
        lightTexture.func_205109_c();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.enableFog();
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix(matrixStack.func_227866_c_().func_227870_a_());
        for (IParticleRenderType iParticleRenderType : field_215241_b) {
            Iterable iterable = this.field_78876_b.get(iParticleRenderType);
            if (iterable == null) continue;
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            Tessellator \u26032 = Tessellator.func_178181_a();
            BufferBuilder \u26033 = \u26032.func_178180_c();
            iParticleRenderType.func_217600_a(\u26033, this.field_78877_c);
            for (Particle particle : iterable) {
                try {
                    particle.func_225606_a_(\u26033, activeRenderInfo, f);
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Rendering Particle");
                    CrashReportCategory \u26034 = crashReport.func_85058_a("Particle being rendered");
                    \u26034.func_189529_a("Particle", particle::toString);
                    \u26034.func_189529_a("Particle Type", iParticleRenderType::toString);
                    throw new ReportedException(crashReport);
                }
            }
            iParticleRenderType.func_217599_a(\u26032);
        }
        RenderSystem.popMatrix();
        RenderSystem.depthMask(true);
        RenderSystem.disableBlend();
        RenderSystem.defaultAlphaFunc();
        lightTexture.func_205108_b();
        RenderSystem.disableFog();
    }

    public void func_78870_a(@Nullable World world) {
        this.field_78878_a = world;
        this.field_78876_b.clear();
        this.field_178933_d.clear();
    }

    public void func_180533_a(BlockPos blockPos, BlockState blockState) {
        if (blockState.func_196958_f()) {
            return;
        }
        VoxelShape voxelShape = blockState.func_196954_c(this.field_78878_a, blockPos);
        double \u26032 = 0.25;
        voxelShape.func_197755_b((d, d2, d3, d4, d5, d6) -> {
            \u2603 = Math.min(1.0, d4 - d);
            \u2603 = Math.min(1.0, d5 - d2);
            \u2603 = Math.min(1.0, d6 - d3);
            int n = Math.max(2, MathHelper.func_76143_f(\u2603 / 0.25));
            \u2603 = Math.max(2, MathHelper.func_76143_f(\u2603 / 0.25));
            \u2603 = Math.max(2, MathHelper.func_76143_f(\u2603 / 0.25));
            for (\u2603 = 0; \u2603 < n; ++\u2603) {
                for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                    for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                        double d7 = ((double)\u2603 + 0.5) / (double)n;
                        \u2603 = ((double)\u2603 + 0.5) / (double)\u2603;
                        \u2603 = ((double)\u2603 + 0.5) / (double)\u2603;
                        \u2603 = d7 * \u2603 + d;
                        \u2603 = \u2603 * \u2603 + d2;
                        \u2603 = \u2603 * \u2603 + d3;
                        this.func_78873_a(new DiggingParticle(this.field_78878_a, (double)blockPos.func_177958_n() + \u2603, (double)blockPos.func_177956_o() + \u2603, (double)blockPos.func_177952_p() + \u2603, d7 - 0.5, \u2603 - 0.5, \u2603 - 0.5, blockState).func_174846_a(blockPos));
                    }
                }
            }
        });
    }

    public void func_180532_a(BlockPos blockPos, Direction direction) {
        BlockState blockState = this.field_78878_a.func_180495_p(blockPos);
        if (blockState.func_185901_i() == BlockRenderType.INVISIBLE) {
            return;
        }
        int \u26032 = blockPos.func_177958_n();
        int \u26033 = blockPos.func_177956_o();
        int \u26034 = blockPos.func_177952_p();
        float \u26035 = 0.1f;
        AxisAlignedBB \u26036 = blockState.func_196954_c(this.field_78878_a, blockPos).func_197752_a();
        double \u26037 = (double)\u26032 + this.field_78875_d.nextDouble() * (\u26036.field_72336_d - \u26036.field_72340_a - (double)0.2f) + (double)0.1f + \u26036.field_72340_a;
        double \u26038 = (double)\u26033 + this.field_78875_d.nextDouble() * (\u26036.field_72337_e - \u26036.field_72338_b - (double)0.2f) + (double)0.1f + \u26036.field_72338_b;
        double \u26039 = (double)\u26034 + this.field_78875_d.nextDouble() * (\u26036.field_72334_f - \u26036.field_72339_c - (double)0.2f) + (double)0.1f + \u26036.field_72339_c;
        if (direction == Direction.DOWN) {
            \u26038 = (double)\u26033 + \u26036.field_72338_b - (double)0.1f;
        }
        if (direction == Direction.UP) {
            \u26038 = (double)\u26033 + \u26036.field_72337_e + (double)0.1f;
        }
        if (direction == Direction.NORTH) {
            \u26039 = (double)\u26034 + \u26036.field_72339_c - (double)0.1f;
        }
        if (direction == Direction.SOUTH) {
            \u26039 = (double)\u26034 + \u26036.field_72334_f + (double)0.1f;
        }
        if (direction == Direction.WEST) {
            \u26037 = (double)\u26032 + \u26036.field_72340_a - (double)0.1f;
        }
        if (direction == Direction.EAST) {
            \u26037 = (double)\u26032 + \u26036.field_72336_d + (double)0.1f;
        }
        this.func_78873_a(new DiggingParticle(this.field_78878_a, \u26037, \u26038, \u26039, 0.0, 0.0, 0.0, blockState).func_174846_a(blockPos).func_70543_e(0.2f).func_70541_f(0.6f));
    }

    public String func_78869_b() {
        return String.valueOf(this.field_78876_b.values().stream().mapToInt(Collection::size).sum());
    }

    class AnimatedSpriteImpl
    implements IAnimatedSprite {
        private List<TextureAtlasSprite> field_217594_b;

        private AnimatedSpriteImpl() {
        }

        @Override
        public TextureAtlasSprite func_217591_a(int n, int n2) {
            return this.field_217594_b.get(n * (this.field_217594_b.size() - 1) / n2);
        }

        @Override
        public TextureAtlasSprite func_217590_a(Random random) {
            return this.field_217594_b.get(random.nextInt(this.field_217594_b.size()));
        }

        public void func_217592_a(List<TextureAtlasSprite> list) {
            this.field_217594_b = ImmutableList.copyOf(list);
        }
    }

    @FunctionalInterface
    static interface IParticleMetaFactory<T extends IParticleData> {
        public IParticleFactory<T> create(IAnimatedSprite var1);
    }
}

