/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.FluidBlockRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;

public class BlockRendererDispatcher
implements IResourceManagerReloadListener {
    private final BlockModelShapes field_175028_a;
    private final BlockModelRenderer field_175027_c;
    private final FluidBlockRenderer field_175025_e;
    private final Random field_195476_e = new Random();
    private final BlockColors field_228790_e_;

    public BlockRendererDispatcher(BlockModelShapes blockModelShapes, BlockColors blockColors) {
        this.field_175028_a = blockModelShapes;
        this.field_228790_e_ = blockColors;
        this.field_175027_c = new BlockModelRenderer(this.field_228790_e_);
        this.field_175025_e = new FluidBlockRenderer();
    }

    public BlockModelShapes func_175023_a() {
        return this.field_175028_a;
    }

    public void func_228792_a_(BlockState blockState, BlockPos blockPos, ILightReader iLightReader, MatrixStack matrixStack, IVertexBuilder iVertexBuilder) {
        if (blockState.func_185901_i() != BlockRenderType.MODEL) {
            return;
        }
        IBakedModel iBakedModel = this.field_175028_a.func_178125_b(blockState);
        long \u26032 = blockState.func_209533_a(blockPos);
        this.field_175027_c.func_228802_a_(iLightReader, iBakedModel, blockState, blockPos, matrixStack, iVertexBuilder, true, this.field_195476_e, \u26032, OverlayTexture.field_229196_a_);
    }

    public boolean func_228793_a_(BlockState blockState, BlockPos blockPos, ILightReader iLightReader, MatrixStack matrixStack, IVertexBuilder iVertexBuilder, boolean bl, Random random) {
        try {
            BlockRenderType blockRenderType = blockState.func_185901_i();
            if (blockRenderType != BlockRenderType.MODEL) {
                return false;
            }
            return this.field_175027_c.func_228802_a_(iLightReader, this.func_184389_a(blockState), blockState, blockPos, matrixStack, iVertexBuilder, bl, random, blockState.func_209533_a(blockPos), OverlayTexture.field_229196_a_);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Tesselating block in world");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a(\u26032, blockPos, blockState);
            throw new ReportedException(crashReport);
        }
    }

    public boolean func_228794_a_(BlockPos blockPos, ILightReader iLightReader, IVertexBuilder iVertexBuilder, IFluidState iFluidState) {
        try {
            return this.field_175025_e.func_228796_a_(iLightReader, blockPos, iVertexBuilder, iFluidState);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Tesselating liquid in world");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a(\u26032, blockPos, null);
            throw new ReportedException(crashReport);
        }
    }

    public BlockModelRenderer func_175019_b() {
        return this.field_175027_c;
    }

    public IBakedModel func_184389_a(BlockState blockState) {
        return this.field_175028_a.func_178125_b(blockState);
    }

    public void func_228791_a_(BlockState blockState, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int n, int n2) {
        BlockRenderType blockRenderType = blockState.func_185901_i();
        if (blockRenderType == BlockRenderType.INVISIBLE) {
            return;
        }
        switch (blockRenderType) {
            case MODEL: {
                IBakedModel iBakedModel = this.func_184389_a(blockState);
                int \u26032 = this.field_228790_e_.func_228054_a_(blockState, null, null, 0);
                float \u26033 = (float)(\u26032 >> 16 & 0xFF) / 255.0f;
                float \u26034 = (float)(\u26032 >> 8 & 0xFF) / 255.0f;
                float \u26035 = (float)(\u26032 & 0xFF) / 255.0f;
                this.field_175027_c.func_228804_a_(matrixStack.func_227866_c_(), iRenderTypeBuffer.getBuffer(RenderTypeLookup.func_228394_b_(blockState)), blockState, iBakedModel, \u26033, \u26034, \u26035, n, n2);
                break;
            }
            case ENTITYBLOCK_ANIMATED: {
                ItemStackTileEntityRenderer.field_147719_a.func_228364_a_(new ItemStack(blockState.func_177230_c()), matrixStack, iRenderTypeBuffer, n, n2);
            }
        }
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        this.field_175025_e.func_178268_a();
    }
}

