/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class ItemRenderer
implements IResourceManagerReloadListener {
    public static final ResourceLocation field_110798_h = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final Set<Item> field_195411_c = Sets.newHashSet((Object[])new Item[]{Items.field_190931_a});
    public float field_77023_b;
    private final ItemModelMesher field_175059_m;
    private final TextureManager field_175057_n;
    private final ItemColors field_184395_f;

    public ItemRenderer(TextureManager textureManager, ModelManager modelManager, ItemColors itemColors2) {
        ItemColors itemColors2;
        this.field_175057_n = textureManager;
        this.field_175059_m = new ItemModelMesher(modelManager);
        for (Item item : Registry.field_212630_s) {
            if (field_195411_c.contains(item)) continue;
            this.field_175059_m.func_199311_a(item, new ModelResourceLocation(Registry.field_212630_s.func_177774_c(item), "inventory"));
        }
        this.field_184395_f = itemColors2;
    }

    public ItemModelMesher func_175037_a() {
        return this.field_175059_m;
    }

    private void func_229114_a_(IBakedModel iBakedModel, ItemStack itemStack, int n, int n2, MatrixStack matrixStack, IVertexBuilder iVertexBuilder) {
        Random random = new Random();
        long \u26032 = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            this.func_229112_a_(matrixStack, iVertexBuilder, iBakedModel.func_200117_a(null, direction, random), itemStack, n, n2);
        }
        random.setSeed(42L);
        this.func_229112_a_(matrixStack, iVertexBuilder, iBakedModel.func_200117_a(null, null, random), itemStack, n, n2);
    }

    public void func_229111_a_(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, boolean bl, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int n, int n2, IBakedModel iBakedModel2) {
        IBakedModel iBakedModel2;
        if (itemStack.func_190926_b()) {
            return;
        }
        matrixStack.func_227860_a_();
        boolean bl2 = transformType == ItemCameraTransforms.TransformType.GUI;
        boolean bl3 = \u2603 = bl2 || transformType == ItemCameraTransforms.TransformType.GROUND || transformType == ItemCameraTransforms.TransformType.FIXED;
        if (itemStack.func_77973_b() == Items.field_203184_eO && \u2603) {
            iBakedModel2 = this.field_175059_m.func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
        }
        iBakedModel2.func_177552_f().func_181688_b(transformType).func_228830_a_(bl, matrixStack);
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        if (iBakedModel2.func_188618_c() || itemStack.func_77973_b() == Items.field_203184_eO && !\u2603) {
            ItemStackTileEntityRenderer.field_147719_a.func_228364_a_(itemStack, matrixStack, iRenderTypeBuffer, n, n2);
        } else {
            RenderType renderType = RenderTypeLookup.func_228389_a_(itemStack);
            \u2603 = bl2 && Objects.equals(renderType, Atlases.func_228784_i_()) ? Atlases.func_228785_j_() : renderType;
            IVertexBuilder \u26032 = ItemRenderer.func_229113_a_(iRenderTypeBuffer, \u2603, true, itemStack.func_77962_s());
            this.func_229114_a_(iBakedModel2, itemStack, n, n2, matrixStack, \u26032);
        }
        matrixStack.func_227865_b_();
    }

    public static IVertexBuilder func_229113_a_(IRenderTypeBuffer iRenderTypeBuffer, RenderType renderType, boolean bl, boolean bl2) {
        if (bl2) {
            return VertexBuilderUtils.func_227915_a_(iRenderTypeBuffer.getBuffer(bl ? RenderType.func_228653_j_() : RenderType.func_228655_k_()), iRenderTypeBuffer.getBuffer(renderType));
        }
        return iRenderTypeBuffer.getBuffer(renderType);
    }

    private void func_229112_a_(MatrixStack matrixStack, IVertexBuilder iVertexBuilder, List<BakedQuad> list, ItemStack itemStack, int n, int n2) {
        boolean bl = !itemStack.func_190926_b();
        MatrixStack.Entry \u26032 = matrixStack.func_227866_c_();
        for (BakedQuad bakedQuad : list) {
            int n3 = -1;
            if (bl && bakedQuad.func_178212_b()) {
                n3 = this.field_184395_f.func_186728_a(itemStack, bakedQuad.func_178211_c());
            }
            float \u26033 = (float)(n3 >> 16 & 0xFF) / 255.0f;
            float \u26034 = (float)(n3 >> 8 & 0xFF) / 255.0f;
            float \u26035 = (float)(n3 & 0xFF) / 255.0f;
            iVertexBuilder.func_227889_a_(\u26032, bakedQuad, \u26033, \u26034, \u26035, n, n2);
        }
    }

    public IBakedModel func_184393_a(ItemStack itemStack, @Nullable World world, @Nullable LivingEntity livingEntity) {
        Item item = itemStack.func_77973_b();
        IBakedModel \u26032 = item == Items.field_203184_eO ? this.field_175059_m.func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident_in_hand#inventory")) : this.field_175059_m.func_178089_a(itemStack);
        if (!item.func_185040_i()) {
            return \u26032;
        }
        return this.func_204207_a(\u26032, itemStack, world, livingEntity);
    }

    private IBakedModel func_204207_a(IBakedModel iBakedModel, ItemStack itemStack, @Nullable World world, @Nullable LivingEntity livingEntity) {
        IBakedModel iBakedModel2 = iBakedModel.func_188617_f().func_209581_a(iBakedModel, itemStack, world, livingEntity);
        return iBakedModel2 == null ? this.field_175059_m.func_178083_a().func_174951_a() : iBakedModel2;
    }

    public void func_229110_a_(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, int n, int n2, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer) {
        this.func_229109_a_(null, itemStack, transformType, false, matrixStack, iRenderTypeBuffer, null, n, n2);
    }

    public void func_229109_a_(@Nullable LivingEntity livingEntity, ItemStack itemStack, ItemCameraTransforms.TransformType transformType, boolean bl, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, @Nullable World world, int n, int n2) {
        if (itemStack.func_190926_b()) {
            return;
        }
        IBakedModel iBakedModel = this.func_184393_a(itemStack, world, livingEntity);
        this.func_229111_a_(itemStack, transformType, bl, matrixStack, iRenderTypeBuffer, n, n2, iBakedModel);
    }

    public void func_175042_a(ItemStack itemStack, int n, int n2) {
        this.func_191962_a(itemStack, n, n2, this.func_184393_a(itemStack, null, null));
    }

    protected void func_191962_a(ItemStack itemStack, int n, int n2, IBakedModel iBakedModel) {
        RenderSystem.pushMatrix();
        this.field_175057_n.func_110577_a(AtlasTexture.field_110575_b);
        this.field_175057_n.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.translatef(n, n2, 100.0f + this.field_77023_b);
        RenderSystem.translatef(8.0f, 8.0f, 0.0f);
        RenderSystem.scalef(1.0f, -1.0f, 1.0f);
        RenderSystem.scalef(16.0f, 16.0f, 16.0f);
        MatrixStack matrixStack = new MatrixStack();
        IRenderTypeBuffer.Impl \u26032 = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = \u2603 = !iBakedModel.func_230044_c_();
        if (\u2603) {
            RenderHelper.func_227783_c_();
        }
        this.func_229111_a_(itemStack, ItemCameraTransforms.TransformType.GUI, false, matrixStack, \u26032, 0xF000F0, OverlayTexture.field_229196_a_, iBakedModel);
        \u26032.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (\u2603) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    public void func_180450_b(ItemStack itemStack, int n, int n2) {
        this.func_184391_a(Minecraft.func_71410_x().field_71439_g, itemStack, n, n2);
    }

    public void func_184391_a(@Nullable LivingEntity livingEntity, ItemStack itemStack, int n, int n2) {
        if (itemStack.func_190926_b()) {
            return;
        }
        this.field_77023_b += 50.0f;
        try {
            this.func_191962_a(itemStack, n, n2, this.func_184393_a(itemStack, null, livingEntity));
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Rendering item");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Item being rendered");
            \u26032.func_189529_a("Item Type", () -> String.valueOf(itemStack.func_77973_b()));
            \u26032.func_189529_a("Item Damage", () -> String.valueOf(itemStack.func_77952_i()));
            \u26032.func_189529_a("Item NBT", () -> String.valueOf(itemStack.func_77978_p()));
            \u26032.func_189529_a("Item Foil", () -> String.valueOf(itemStack.func_77962_s()));
            throw new ReportedException(crashReport);
        }
        this.field_77023_b -= 50.0f;
    }

    public void func_175030_a(FontRenderer fontRenderer, ItemStack itemStack, int n, int n2) {
        this.func_180453_a(fontRenderer, itemStack, n, n2, null);
    }

    public void func_180453_a(FontRenderer fontRenderer, ItemStack itemStack2, int n, int n2, @Nullable String string) {
        ItemStack itemStack2;
        Object object;
        if (itemStack2.func_190926_b()) {
            return;
        }
        MatrixStack matrixStack = new MatrixStack();
        if (itemStack2.func_190916_E() != 1 || string != null) {
            object = string == null ? String.valueOf(itemStack2.func_190916_E()) : string;
            matrixStack.func_227861_a_(0.0, 0.0, this.field_77023_b + 200.0f);
            \u2603 = IRenderTypeBuffer.func_228455_a_(Tessellator.func_178181_a().func_178180_c());
            fontRenderer.func_228079_a_((String)object, n + 19 - 2 - fontRenderer.func_78256_a((String)object), n2 + 6 + 3, 0xFFFFFF, true, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)\u2603, false, 0, 0xF000F0);
            ((IRenderTypeBuffer.Impl)\u2603).func_228461_a_();
        }
        if (itemStack2.func_77951_h()) {
            RenderSystem.disableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.disableAlphaTest();
            RenderSystem.disableBlend();
            object = Tessellator.func_178181_a();
            \u2603 = ((Tessellator)object).func_178180_c();
            float \u26032 = itemStack2.func_77952_i();
            float \u26033 = itemStack2.func_77958_k();
            float \u26034 = Math.max(0.0f, (\u26033 - \u26032) / \u26033);
            int \u26035 = Math.round(13.0f - \u26032 * 13.0f / \u26033);
            int \u26036 = MathHelper.func_181758_c(\u26034 / 3.0f, 1.0f, 1.0f);
            this.func_181565_a((BufferBuilder)\u2603, n + 2, n2 + 13, 13, 2, 0, 0, 0, 255);
            this.func_181565_a((BufferBuilder)\u2603, n + 2, n2 + 13, \u26035, 1, \u26036 >> 16 & 0xFF, \u26036 >> 8 & 0xFF, \u26036 & 0xFF, 255);
            RenderSystem.enableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
            RenderSystem.enableDepthTest();
        }
        float f = \u2603 = (object = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : ((PlayerEntity)object).func_184811_cZ().func_185143_a(itemStack2.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
        if (\u2603 > 0.0f) {
            RenderSystem.disableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Tessellator \u26037 = Tessellator.func_178181_a();
            BufferBuilder \u26038 = \u26037.func_178180_c();
            this.func_181565_a(\u26038, n, n2 + MathHelper.func_76141_d(16.0f * (1.0f - \u2603)), 16, MathHelper.func_76123_f(16.0f * \u2603), 255, 255, 255, 127);
            RenderSystem.enableTexture();
            RenderSystem.enableDepthTest();
        }
    }

    private void func_181565_a(BufferBuilder bufferBuilder, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_225582_a_(n + 0, n2 + 0, 0.0).func_225586_a_(n5, n6, n7, n8).func_181675_d();
        bufferBuilder.func_225582_a_(n + 0, n2 + n4, 0.0).func_225586_a_(n5, n6, n7, n8).func_181675_d();
        bufferBuilder.func_225582_a_(n + n3, n2 + n4, 0.0).func_225586_a_(n5, n6, n7, n8).func_181675_d();
        bufferBuilder.func_225582_a_(n + n3, n2 + 0, 0.0).func_225586_a_(n5, n6, n7, n8).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        this.field_175059_m.func_178085_b();
    }
}

