/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public abstract class RenderState {
    protected final String field_228509_a_;
    private final Runnable field_228507_Q_;
    private final Runnable field_228508_R_;
    protected static final TransparencyState field_228510_b_ = new TransparencyState("no_transparency", () -> RenderSystem.disableBlend(), () -> {});
    protected static final TransparencyState field_228511_c_ = new TransparencyState("additive_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final TransparencyState field_228512_d_ = new TransparencyState("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final TransparencyState field_228513_e_ = new TransparencyState("glint_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_COLOR, GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final TransparencyState field_228514_f_ = new TransparencyState("crumbling_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.DST_COLOR, GlStateManager.DestFactor.SRC_COLOR, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final TransparencyState field_228515_g_ = new TransparencyState("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }, () -> RenderSystem.disableBlend());
    protected static final AlphaState field_228516_h_ = new AlphaState(0.0f);
    protected static final AlphaState field_228517_i_ = new AlphaState(0.003921569f);
    protected static final AlphaState field_228518_j_ = new AlphaState(0.5f);
    protected static final ShadeModelState field_228519_k_ = new ShadeModelState(false);
    protected static final ShadeModelState field_228520_l_ = new ShadeModelState(true);
    protected static final TextureState field_228521_m_ = new TextureState(AtlasTexture.field_110575_b, false, true);
    protected static final TextureState field_228522_n_ = new TextureState(AtlasTexture.field_110575_b, false, false);
    protected static final TextureState field_228523_o_ = new TextureState();
    protected static final TexturingState field_228524_p_ = new TexturingState("default_texturing", () -> {}, () -> {});
    protected static final TexturingState field_228525_q_ = new TexturingState("outline_texturing", () -> RenderSystem.setupOutline(), () -> RenderSystem.teardownOutline());
    protected static final TexturingState field_228526_r_ = new TexturingState("glint_texturing", () -> RenderState.func_228548_a_(8.0f), () -> {
        RenderSystem.matrixMode(5890);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode(5888);
    });
    protected static final TexturingState field_228527_s_ = new TexturingState("entity_glint_texturing", () -> RenderState.func_228548_a_(0.16f), () -> {
        RenderSystem.matrixMode(5890);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode(5888);
    });
    protected static final LightmapState field_228528_t_ = new LightmapState(true);
    protected static final LightmapState field_228529_u_ = new LightmapState(false);
    protected static final OverlayState field_228530_v_ = new OverlayState(true);
    protected static final OverlayState field_228531_w_ = new OverlayState(false);
    protected static final DiffuseLightingState field_228532_x_ = new DiffuseLightingState(true);
    protected static final DiffuseLightingState field_228533_y_ = new DiffuseLightingState(false);
    protected static final CullState field_228534_z_ = new CullState(true);
    protected static final CullState field_228491_A_ = new CullState(false);
    protected static final DepthTestState field_228492_B_ = new DepthTestState(519);
    protected static final DepthTestState field_228493_C_ = new DepthTestState(514);
    protected static final DepthTestState field_228494_D_ = new DepthTestState(515);
    protected static final WriteMaskState field_228495_E_ = new WriteMaskState(true, true);
    protected static final WriteMaskState field_228496_F_ = new WriteMaskState(true, false);
    protected static final WriteMaskState field_228497_G_ = new WriteMaskState(false, true);
    protected static final LayerState field_228498_H_ = new LayerState("no_layering", () -> {}, () -> {});
    protected static final LayerState field_228499_I_ = new LayerState("polygon_offset_layering", () -> {
        RenderSystem.polygonOffset(-1.0f, -10.0f);
        RenderSystem.enablePolygonOffset();
    }, () -> {
        RenderSystem.polygonOffset(0.0f, 0.0f);
        RenderSystem.disablePolygonOffset();
    });
    protected static final LayerState field_228500_J_ = new LayerState("projection_layering", () -> {
        RenderSystem.matrixMode(5889);
        RenderSystem.pushMatrix();
        RenderSystem.scalef(1.0f, 1.0f, 0.999f);
        RenderSystem.matrixMode(5888);
    }, () -> {
        RenderSystem.matrixMode(5889);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode(5888);
    });
    protected static final FogState field_228501_K_ = new FogState("no_fog", () -> {}, () -> {});
    protected static final FogState field_228502_L_ = new FogState("fog", () -> {
        FogRenderer.func_228373_b_();
        RenderSystem.enableFog();
    }, () -> RenderSystem.disableFog());
    protected static final FogState field_228503_M_ = new FogState("black_fog", () -> {
        RenderSystem.fog(2918, 0.0f, 0.0f, 0.0f, 1.0f);
        RenderSystem.enableFog();
    }, () -> {
        FogRenderer.func_228373_b_();
        RenderSystem.disableFog();
    });
    protected static final TargetState field_228504_N_ = new TargetState("main_target", () -> {}, () -> {});
    protected static final TargetState field_228505_O_ = new TargetState("outline_target", () -> Minecraft.func_71410_x().field_71438_f.func_228448_p_().func_147610_a(false), () -> Minecraft.func_71410_x().func_147110_a().func_147610_a(false));
    protected static final LineState field_228506_P_ = new LineState(OptionalDouble.of(1.0));

    public RenderState(String string, Runnable runnable, Runnable runnable2) {
        this.field_228509_a_ = string;
        this.field_228507_Q_ = runnable;
        this.field_228508_R_ = runnable2;
    }

    public void func_228547_a_() {
        this.field_228507_Q_.run();
    }

    public void func_228549_b_() {
        this.field_228508_R_.run();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RenderState renderState = (RenderState)object;
        return this.field_228509_a_.equals(renderState.field_228509_a_);
    }

    public int hashCode() {
        return this.field_228509_a_.hashCode();
    }

    private static void func_228548_a_(float f) {
        RenderSystem.matrixMode(5890);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        long l = Util.func_211177_b() * 8L;
        float \u26032 = (float)(l % 110000L) / 110000.0f;
        float \u26033 = (float)(l % 30000L) / 30000.0f;
        RenderSystem.translatef(-\u26032, \u26033, 0.0f);
        RenderSystem.rotatef(10.0f, 0.0f, 0.0f, 1.0f);
        RenderSystem.scalef(f, f, f);
        RenderSystem.matrixMode(5888);
    }

    public static class LineState
    extends RenderState {
        private final OptionalDouble field_228587_Q_;

        public LineState(OptionalDouble optionalDouble) {
            super("alpha", () -> {
                if (!Objects.equals(optionalDouble, OptionalDouble.of(1.0))) {
                    if (optionalDouble.isPresent()) {
                        RenderSystem.lineWidth((float)optionalDouble.getAsDouble());
                    } else {
                        RenderSystem.lineWidth(Math.max(2.5f, (float)Minecraft.func_71410_x().func_228018_at_().func_198109_k() / 1920.0f * 2.5f));
                    }
                }
            }, () -> {
                if (!Objects.equals(optionalDouble, OptionalDouble.of(1.0))) {
                    RenderSystem.lineWidth(1.0f);
                }
            });
            this.field_228587_Q_ = optionalDouble;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            return Objects.equals(this.field_228587_Q_, ((LineState)object).field_228587_Q_);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.field_228587_Q_);
        }
    }

    public static class TargetState
    extends RenderState {
        public TargetState(String string, Runnable runnable, Runnable runnable2) {
            super(string, runnable, runnable2);
        }
    }

    public static class FogState
    extends RenderState {
        public FogState(String string, Runnable runnable, Runnable runnable2) {
            super(string, runnable, runnable2);
        }
    }

    public static class LayerState
    extends RenderState {
        public LayerState(String string, Runnable runnable, Runnable runnable2) {
            super(string, runnable, runnable2);
        }
    }

    public static class WriteMaskState
    extends RenderState {
        private final boolean field_228610_Q_;
        private final boolean field_228611_R_;

        public WriteMaskState(boolean bl, boolean bl2) {
            super("write_mask_state", () -> {
                if (!bl2) {
                    RenderSystem.depthMask(bl2);
                }
                if (!bl) {
                    RenderSystem.colorMask(bl, bl, bl, bl);
                }
            }, () -> {
                if (!bl2) {
                    RenderSystem.depthMask(true);
                }
                if (!bl) {
                    RenderSystem.colorMask(true, true, true, true);
                }
            });
            this.field_228610_Q_ = bl;
            this.field_228611_R_ = bl2;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            WriteMaskState writeMaskState = (WriteMaskState)object;
            return this.field_228610_Q_ == writeMaskState.field_228610_Q_ && this.field_228611_R_ == writeMaskState.field_228611_R_;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.field_228610_Q_, this.field_228611_R_);
        }
    }

    public static class DepthTestState
    extends RenderState {
        private final int field_228580_Q_;

        public DepthTestState(int n) {
            super("depth_test", () -> {
                if (n != 519) {
                    RenderSystem.enableDepthTest();
                    RenderSystem.depthFunc(n);
                }
            }, () -> {
                if (n != 519) {
                    RenderSystem.disableDepthTest();
                    RenderSystem.depthFunc(515);
                }
            });
            this.field_228580_Q_ = n;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DepthTestState depthTestState = (DepthTestState)object;
            return this.field_228580_Q_ == depthTestState.field_228580_Q_;
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.field_228580_Q_);
        }
    }

    public static class CullState
    extends BooleanState {
        public CullState(boolean bl) {
            super("cull", () -> {
                if (bl) {
                    RenderSystem.enableCull();
                }
            }, () -> {
                if (bl) {
                    RenderSystem.disableCull();
                }
            }, bl);
        }
    }

    public static class DiffuseLightingState
    extends BooleanState {
        public DiffuseLightingState(boolean bl) {
            super("diffuse_lighting", () -> {
                if (bl) {
                    RenderHelper.func_227780_a_();
                }
            }, () -> {
                if (bl) {
                    RenderHelper.func_74518_a();
                }
            }, bl);
        }
    }

    public static class OverlayState
    extends BooleanState {
        public OverlayState(boolean bl) {
            super("overlay", () -> {
                if (bl) {
                    Minecraft.func_71410_x().field_71460_t.func_228385_m_().func_229198_a_();
                }
            }, () -> {
                if (bl) {
                    Minecraft.func_71410_x().field_71460_t.func_228385_m_().func_229203_b_();
                }
            }, bl);
        }
    }

    public static class LightmapState
    extends BooleanState {
        public LightmapState(boolean bl) {
            super("lightmap", () -> {
                if (bl) {
                    Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205109_c();
                }
            }, () -> {
                if (bl) {
                    Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205108_b();
                }
            }, bl);
        }
    }

    static class BooleanState
    extends RenderState {
        private final boolean field_228577_Q_;

        public BooleanState(String string, Runnable runnable, Runnable runnable2, boolean bl) {
            super(string, runnable, runnable2);
            this.field_228577_Q_ = bl;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            BooleanState booleanState = (BooleanState)object;
            return this.field_228577_Q_ == booleanState.field_228577_Q_;
        }

        @Override
        public int hashCode() {
            return Boolean.hashCode(this.field_228577_Q_);
        }
    }

    public static final class PortalTexturingState
    extends TexturingState {
        private final int field_228596_Q_;

        public PortalTexturingState(int n) {
            super("portal_texturing", () -> {
                RenderSystem.matrixMode(5890);
                RenderSystem.pushMatrix();
                RenderSystem.loadIdentity();
                RenderSystem.translatef(0.5f, 0.5f, 0.0f);
                RenderSystem.scalef(0.5f, 0.5f, 1.0f);
                RenderSystem.translatef(17.0f / (float)n, (2.0f + (float)n / 1.5f) * ((float)(Util.func_211177_b() % 800000L) / 800000.0f), 0.0f);
                RenderSystem.rotatef(((float)(n * n) * 4321.0f + (float)n * 9.0f) * 2.0f, 0.0f, 0.0f, 1.0f);
                RenderSystem.scalef(4.5f - (float)n / 4.0f, 4.5f - (float)n / 4.0f, 1.0f);
                RenderSystem.mulTextureByProjModelView();
                RenderSystem.matrixMode(5888);
                RenderSystem.setupEndPortalTexGen();
            }, () -> {
                RenderSystem.matrixMode(5890);
                RenderSystem.popMatrix();
                RenderSystem.matrixMode(5888);
                RenderSystem.clearTexGen();
            });
            this.field_228596_Q_ = n;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            PortalTexturingState portalTexturingState = (PortalTexturingState)object;
            return this.field_228596_Q_ == portalTexturingState.field_228596_Q_;
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.field_228596_Q_);
        }
    }

    public static final class OffsetTexturingState
    extends TexturingState {
        private final float field_228590_Q_;
        private final float field_228591_R_;

        public OffsetTexturingState(float f, float f2) {
            super("offset_texturing", () -> {
                RenderSystem.matrixMode(5890);
                RenderSystem.pushMatrix();
                RenderSystem.loadIdentity();
                RenderSystem.translatef(f, f2, 0.0f);
                RenderSystem.matrixMode(5888);
            }, () -> {
                RenderSystem.matrixMode(5890);
                RenderSystem.popMatrix();
                RenderSystem.matrixMode(5888);
            });
            this.field_228590_Q_ = f;
            this.field_228591_R_ = f2;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            OffsetTexturingState offsetTexturingState = (OffsetTexturingState)object;
            return Float.compare(offsetTexturingState.field_228590_Q_, this.field_228590_Q_) == 0 && Float.compare(offsetTexturingState.field_228591_R_, this.field_228591_R_) == 0;
        }

        @Override
        public int hashCode() {
            return Objects.hash(Float.valueOf(this.field_228590_Q_), Float.valueOf(this.field_228591_R_));
        }
    }

    public static class TexturingState
    extends RenderState {
        public TexturingState(String string, Runnable runnable, Runnable runnable2) {
            super(string, runnable, runnable2);
        }
    }

    public static class TextureState
    extends RenderState {
        private final Optional<ResourceLocation> field_228602_Q_;
        private final boolean field_228603_R_;
        private final boolean field_228604_S_;

        public TextureState(ResourceLocation resourceLocation, boolean bl, boolean bl2) {
            super("texture", () -> {
                RenderSystem.enableTexture();
                TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
                textureManager.func_110577_a(resourceLocation);
                textureManager.func_229267_b_(resourceLocation).func_174937_a(bl, bl2);
            }, () -> {});
            this.field_228602_Q_ = Optional.of(resourceLocation);
            this.field_228603_R_ = bl;
            this.field_228604_S_ = bl2;
        }

        public TextureState() {
            super("texture", () -> RenderSystem.disableTexture(), () -> RenderSystem.enableTexture());
            this.field_228602_Q_ = Optional.empty();
            this.field_228603_R_ = false;
            this.field_228604_S_ = false;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TextureState textureState = (TextureState)object;
            return this.field_228602_Q_.equals(textureState.field_228602_Q_) && this.field_228603_R_ == textureState.field_228603_R_ && this.field_228604_S_ == textureState.field_228604_S_;
        }

        @Override
        public int hashCode() {
            return this.field_228602_Q_.hashCode();
        }

        protected Optional<ResourceLocation> func_228606_c_() {
            return this.field_228602_Q_;
        }
    }

    public static class ShadeModelState
    extends RenderState {
        private final boolean field_228599_Q_;

        public ShadeModelState(boolean bl) {
            super("shade_model", () -> RenderSystem.shadeModel(bl ? 7425 : 7424), () -> RenderSystem.shadeModel(7424));
            this.field_228599_Q_ = bl;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ShadeModelState shadeModelState = (ShadeModelState)object;
            return this.field_228599_Q_ == shadeModelState.field_228599_Q_;
        }

        @Override
        public int hashCode() {
            return Boolean.hashCode(this.field_228599_Q_);
        }
    }

    public static class AlphaState
    extends RenderState {
        private final float field_228574_Q_;

        public AlphaState(float f) {
            super("alpha", () -> {
                if (f > 0.0f) {
                    RenderSystem.enableAlphaTest();
                    RenderSystem.alphaFunc(516, f);
                } else {
                    RenderSystem.disableAlphaTest();
                }
            }, () -> {
                RenderSystem.disableAlphaTest();
                RenderSystem.defaultAlphaFunc();
            });
            this.field_228574_Q_ = f;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            return this.field_228574_Q_ == ((AlphaState)object).field_228574_Q_;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), Float.valueOf(this.field_228574_Q_));
        }
    }

    public static class TransparencyState
    extends RenderState {
        public TransparencyState(String string, Runnable runnable, Runnable runnable2) {
            super(string, runnable, runnable2);
        }
    }
}

