/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.tileentity.EndPortalTileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;

public abstract class RenderType
extends RenderState {
    private static final RenderType field_228615_R_ = RenderType.func_228633_a_("solid", DefaultVertexFormats.field_176600_a, 7, 0x200000, true, false, State.func_228694_a_().func_228723_a_(field_228520_l_).func_228719_a_(field_228528_t_).func_228724_a_(field_228521_m_).func_228728_a_(true));
    private static final RenderType field_228616_S_ = RenderType.func_228633_a_("cutout_mipped", DefaultVertexFormats.field_176600_a, 7, 131072, true, false, State.func_228694_a_().func_228723_a_(field_228520_l_).func_228719_a_(field_228528_t_).func_228724_a_(field_228521_m_).func_228713_a_(field_228518_j_).func_228728_a_(true));
    private static final RenderType field_228617_T_ = RenderType.func_228633_a_("cutout", DefaultVertexFormats.field_176600_a, 7, 131072, true, false, State.func_228694_a_().func_228723_a_(field_228520_l_).func_228719_a_(field_228528_t_).func_228724_a_(field_228522_n_).func_228713_a_(field_228518_j_).func_228728_a_(true));
    private static final RenderType field_228618_U_ = RenderType.func_228633_a_("translucent", DefaultVertexFormats.field_176600_a, 7, 262144, true, true, RenderType.func_228666_t_());
    private static final RenderType field_228619_V_ = RenderType.func_228633_a_("translucent_no_crumbling", DefaultVertexFormats.field_176600_a, 7, 262144, false, true, RenderType.func_228666_t_());
    private static final RenderType field_228620_W_ = RenderType.func_228632_a_("leash", DefaultVertexFormats.field_227850_m_, 7, 256, State.func_228694_a_().func_228724_a_(field_228523_o_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228728_a_(false));
    private static final RenderType field_228621_X_ = RenderType.func_228632_a_("water_mask", DefaultVertexFormats.field_181705_e, 7, 256, State.func_228694_a_().func_228724_a_(field_228523_o_).func_228727_a_(field_228497_G_).func_228728_a_(false));
    private static final RenderType field_228622_Y_ = RenderType.func_228632_a_("glint", DefaultVertexFormats.field_181707_g, 7, 256, State.func_228694_a_().func_228724_a_(new RenderState.TextureState(ItemRenderer.field_110798_h, true, false)).func_228727_a_(field_228496_F_).func_228714_a_(field_228491_A_).func_228715_a_(field_228493_C_).func_228726_a_(field_228513_e_).func_228725_a_(field_228526_r_).func_228728_a_(false));
    private static final RenderType field_228623_Z_ = RenderType.func_228632_a_("entity_glint", DefaultVertexFormats.field_181707_g, 7, 256, State.func_228694_a_().func_228724_a_(new RenderState.TextureState(ItemRenderer.field_110798_h, true, false)).func_228727_a_(field_228496_F_).func_228714_a_(field_228491_A_).func_228715_a_(field_228493_C_).func_228726_a_(field_228513_e_).func_228725_a_(field_228527_s_).func_228728_a_(false));
    private static final RenderType field_228624_aa_ = RenderType.func_228633_a_("lightning", DefaultVertexFormats.field_181706_f, 7, 256, false, true, State.func_228694_a_().func_228727_a_(field_228496_F_).func_228726_a_(field_228512_d_).func_228723_a_(field_228520_l_).func_228728_a_(false));
    public static final Type field_228614_Q_ = RenderType.func_228632_a_("lines", DefaultVertexFormats.field_181706_f, 1, 256, State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.empty())).func_228718_a_(field_228500_J_).func_228726_a_(field_228515_g_).func_228727_a_(field_228496_F_).func_228728_a_(false));
    private final VertexFormat field_228625_ab_;
    private final int field_228626_ac_;
    private final int field_228627_ad_;
    private final boolean field_228628_ae_;
    private final boolean field_228629_af_;
    private final Optional<RenderType> field_230166_ag_;

    public static RenderType func_228639_c_() {
        return field_228615_R_;
    }

    public static RenderType func_228641_d_() {
        return field_228616_S_;
    }

    public static RenderType func_228643_e_() {
        return field_228617_T_;
    }

    private static State func_228666_t_() {
        return State.func_228694_a_().func_228723_a_(field_228520_l_).func_228719_a_(field_228528_t_).func_228724_a_(field_228521_m_).func_228726_a_(field_228515_g_).func_228728_a_(true);
    }

    public static RenderType func_228645_f_() {
        return field_228618_U_;
    }

    public static RenderType func_228647_g_() {
        return field_228619_V_;
    }

    public static RenderType func_228634_a_(ResourceLocation resourceLocation) {
        State state = State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228726_a_(field_228510_b_).func_228716_a_(field_228532_x_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
        return RenderType.func_228633_a_("entity_solid", DefaultVertexFormats.field_227849_i_, 7, 256, true, false, state);
    }

    public static RenderType func_228638_b_(ResourceLocation resourceLocation) {
        State state = State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228726_a_(field_228510_b_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
        return RenderType.func_228633_a_("entity_cutout", DefaultVertexFormats.field_227849_i_, 7, 256, true, false, state);
    }

    public static RenderType func_230167_a_(ResourceLocation resourceLocation, boolean bl) {
        State state = State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228726_a_(field_228510_b_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(bl);
        return RenderType.func_228633_a_("entity_cutout_no_cull", DefaultVertexFormats.field_227849_i_, 7, 256, true, false, state);
    }

    public static RenderType func_228640_c_(ResourceLocation resourceLocation) {
        return RenderType.func_230167_a_(resourceLocation, true);
    }

    public static RenderType func_228642_d_(ResourceLocation resourceLocation) {
        State state = State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228726_a_(field_228515_g_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
        return RenderType.func_228633_a_("entity_translucent_cull", DefaultVertexFormats.field_227849_i_, 7, 256, true, true, state);
    }

    public static RenderType func_230168_b_(ResourceLocation resourceLocation, boolean bl) {
        State state = State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228726_a_(field_228515_g_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(bl);
        return RenderType.func_228633_a_("entity_translucent", DefaultVertexFormats.field_227849_i_, 7, 256, true, true, state);
    }

    public static RenderType func_228644_e_(ResourceLocation resourceLocation) {
        return RenderType.func_230168_b_(resourceLocation, true);
    }

    public static RenderType func_228646_f_(ResourceLocation resourceLocation) {
        State state = State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228713_a_(field_228518_j_).func_228716_a_(field_228532_x_).func_228723_a_(field_228520_l_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228728_a_(true);
        return RenderType.func_228632_a_("entity_smooth_cutout", DefaultVertexFormats.field_227849_i_, 7, 256, state);
    }

    public static RenderType func_228637_a_(ResourceLocation resourceLocation, boolean bl) {
        State state = State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228726_a_(bl ? field_228515_g_ : field_228510_b_).func_228727_a_(bl ? field_228496_F_ : field_228495_E_).func_228717_a_(field_228501_K_).func_228728_a_(false);
        return RenderType.func_228633_a_("beacon_beam", DefaultVertexFormats.field_176600_a, 7, 256, false, true, state);
    }

    public static RenderType func_228648_g_(ResourceLocation resourceLocation) {
        State state = State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228715_a_(field_228493_C_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(false);
        return RenderType.func_228632_a_("entity_decal", DefaultVertexFormats.field_227849_i_, 7, 256, state);
    }

    public static RenderType func_228650_h_(ResourceLocation resourceLocation) {
        State state = State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228726_a_(field_228515_g_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228727_a_(field_228496_F_).func_228728_a_(false);
        return RenderType.func_228633_a_("entity_no_outline", DefaultVertexFormats.field_227849_i_, 7, 256, false, true, state);
    }

    public static RenderType func_228635_a_(ResourceLocation resourceLocation, float f) {
        State state = State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228713_a_(new RenderState.AlphaState(f)).func_228714_a_(field_228491_A_).func_228728_a_(true);
        return RenderType.func_228632_a_("entity_alpha", DefaultVertexFormats.field_227849_i_, 7, 256, state);
    }

    public static RenderType func_228652_i_(ResourceLocation resourceLocation) {
        RenderState.TextureState textureState = new RenderState.TextureState(resourceLocation, false, false);
        return RenderType.func_228633_a_("eyes", DefaultVertexFormats.field_227849_i_, 7, 256, false, true, State.func_228694_a_().func_228724_a_(textureState).func_228726_a_(field_228511_c_).func_228727_a_(field_228496_F_).func_228717_a_(field_228503_M_).func_228728_a_(false));
    }

    public static RenderType func_228636_a_(ResourceLocation resourceLocation, float f, float f2) {
        return RenderType.func_228633_a_("energy_swirl", DefaultVertexFormats.field_227849_i_, 7, 256, false, true, State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228725_a_(new RenderState.OffsetTexturingState(f, f2)).func_228717_a_(field_228503_M_).func_228726_a_(field_228511_c_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(false));
    }

    public static RenderType func_228649_h_() {
        return field_228620_W_;
    }

    public static RenderType func_228651_i_() {
        return field_228621_X_;
    }

    public static RenderType func_228654_j_(ResourceLocation resourceLocation) {
        return RenderType.func_228632_a_("outline", DefaultVertexFormats.field_227851_o_, 7, 256, State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228714_a_(field_228491_A_).func_228715_a_(field_228492_B_).func_228713_a_(field_228517_i_).func_228725_a_(field_228525_q_).func_228717_a_(field_228501_K_).func_228721_a_(field_228505_O_).func_230173_a_(OutlineState.IS_OUTLINE));
    }

    public static RenderType func_228653_j_() {
        return field_228622_Y_;
    }

    public static RenderType func_228655_k_() {
        return field_228623_Z_;
    }

    public static RenderType func_228656_k_(ResourceLocation resourceLocation) {
        RenderState.TextureState textureState = new RenderState.TextureState(resourceLocation, false, false);
        return RenderType.func_228633_a_("crumbling", DefaultVertexFormats.field_176600_a, 7, 256, false, true, State.func_228694_a_().func_228724_a_(textureState).func_228713_a_(field_228517_i_).func_228726_a_(field_228514_f_).func_228727_a_(field_228496_F_).func_228718_a_(field_228499_I_).func_228728_a_(false));
    }

    public static RenderType func_228658_l_(ResourceLocation resourceLocation) {
        return RenderType.func_228633_a_("text", DefaultVertexFormats.field_227852_q_, 7, 256, false, true, State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228713_a_(field_228517_i_).func_228726_a_(field_228515_g_).func_228719_a_(field_228528_t_).func_228728_a_(false));
    }

    public static RenderType func_228660_m_(ResourceLocation resourceLocation) {
        return RenderType.func_228633_a_("text_see_through", DefaultVertexFormats.field_227852_q_, 7, 256, false, true, State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228713_a_(field_228517_i_).func_228726_a_(field_228515_g_).func_228719_a_(field_228528_t_).func_228715_a_(field_228492_B_).func_228727_a_(field_228496_F_).func_228728_a_(false));
    }

    public static RenderType func_228657_l_() {
        return field_228624_aa_;
    }

    public static RenderType func_228630_a_(int n) {
        RenderState.TextureState \u26032;
        if (n <= 1) {
            RenderState.TransparencyState transparencyState = field_228515_g_;
            \u26032 = new RenderState.TextureState(EndPortalTileEntityRenderer.field_147529_c, false, false);
        } else {
            transparencyState = field_228511_c_;
            \u26032 = new RenderState.TextureState(EndPortalTileEntityRenderer.field_147526_d, false, false);
        }
        return RenderType.func_228633_a_("end_portal", DefaultVertexFormats.field_181706_f, 7, 256, false, true, State.func_228694_a_().func_228726_a_(transparencyState).func_228724_a_(\u26032).func_228725_a_(new RenderState.PortalTexturingState(n)).func_228717_a_(field_228503_M_).func_228728_a_(false));
    }

    public static RenderType func_228659_m_() {
        return field_228614_Q_;
    }

    public RenderType(String string, VertexFormat vertexFormat, int n, int n2, boolean bl, boolean bl2, Runnable runnable, Runnable runnable2) {
        super(string, runnable, runnable2);
        this.field_228625_ab_ = vertexFormat;
        this.field_228626_ac_ = n;
        this.field_228627_ad_ = n2;
        this.field_228628_ae_ = bl;
        this.field_228629_af_ = bl2;
        this.field_230166_ag_ = Optional.of(this);
    }

    public static Type func_228632_a_(String string, VertexFormat vertexFormat, int n, int n2, State state) {
        return RenderType.func_228633_a_(string, vertexFormat, n, n2, false, false, state);
    }

    public static Type func_228633_a_(String string, VertexFormat vertexFormat, int n, int n2, boolean bl, boolean bl2, State state) {
        return Type.func_228676_c_(string, vertexFormat, n, n2, bl, bl2, state);
    }

    public void func_228631_a_(BufferBuilder bufferBuilder, int n, int n2, int n3) {
        if (!bufferBuilder.func_227834_j_()) {
            return;
        }
        if (this.field_228629_af_) {
            bufferBuilder.func_181674_a(n, n2, n3);
        }
        bufferBuilder.func_178977_d();
        this.func_228547_a_();
        WorldVertexBufferUploader.func_181679_a(bufferBuilder);
        this.func_228549_b_();
    }

    public String toString() {
        return this.field_228509_a_;
    }

    public static List<RenderType> func_228661_n_() {
        return ImmutableList.of((Object)RenderType.func_228639_c_(), (Object)RenderType.func_228641_d_(), (Object)RenderType.func_228643_e_(), (Object)RenderType.func_228645_f_());
    }

    public int func_228662_o_() {
        return this.field_228627_ad_;
    }

    public VertexFormat func_228663_p_() {
        return this.field_228625_ab_;
    }

    public int func_228664_q_() {
        return this.field_228626_ac_;
    }

    public Optional<RenderType> func_225612_r_() {
        return Optional.empty();
    }

    public boolean func_230041_s_() {
        return false;
    }

    public boolean func_228665_s_() {
        return this.field_228628_ae_;
    }

    public Optional<RenderType> func_230169_u_() {
        return this.field_230166_ag_;
    }

    static final class Type
    extends RenderType {
        private static final ObjectOpenCustomHashSet<Type> field_228667_R_ = new ObjectOpenCustomHashSet((Hash.Strategy)EqualityStrategy.INSTANCE);
        private final State field_228668_S_;
        private final int field_228669_T_;
        private final Optional<RenderType> field_228670_U_;
        private final boolean field_230170_V_;

        private Type(String string, VertexFormat vertexFormat, int n, int n2, boolean bl, boolean bl2, State state) {
            super(string, vertexFormat, n, n2, bl, bl2, () -> state.field_228693_q_.forEach(RenderState::func_228547_a_), () -> state.field_228693_q_.forEach(RenderState::func_228549_b_));
            this.field_228668_S_ = state;
            this.field_228670_U_ = state.field_230171_p_ == OutlineState.AFFECTS_OUTLINE ? state.field_228677_a_.func_228606_c_().map(RenderType::func_228654_j_) : Optional.empty();
            this.field_230170_V_ = state.field_230171_p_ == OutlineState.IS_OUTLINE;
            this.field_228669_T_ = Objects.hash(super.hashCode(), state);
        }

        private static Type func_228676_c_(String string, VertexFormat vertexFormat, int n, int n2, boolean bl, boolean bl2, State state) {
            return (Type)field_228667_R_.addOrGet((Object)new Type(string, vertexFormat, n, n2, bl, bl2, state));
        }

        @Override
        public Optional<RenderType> func_225612_r_() {
            return this.field_228670_U_;
        }

        @Override
        public boolean func_230041_s_() {
            return this.field_230170_V_;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return this == object;
        }

        @Override
        public int hashCode() {
            return this.field_228669_T_;
        }

        static enum EqualityStrategy implements Hash.Strategy<Type>
        {
            INSTANCE;


            public int hashCode(@Nullable Type type) {
                if (type == null) {
                    return 0;
                }
                return type.field_228669_T_;
            }

            public boolean equals(@Nullable Type type, @Nullable Type type2) {
                if (type == type2) {
                    return true;
                }
                if (type == null || type2 == null) {
                    return false;
                }
                return Objects.equals(type.field_228668_S_, type2.field_228668_S_);
            }

            public /* synthetic */ boolean equals(@Nullable Object object, @Nullable Object object2) {
                return this.equals((Type)object, (Type)object2);
            }

            public /* synthetic */ int hashCode(@Nullable Object object) {
                return this.hashCode((Type)object);
            }
        }
    }

    public static final class State {
        private final RenderState.TextureState field_228677_a_;
        private final RenderState.TransparencyState field_228678_b_;
        private final RenderState.DiffuseLightingState field_228679_c_;
        private final RenderState.ShadeModelState field_228680_d_;
        private final RenderState.AlphaState field_228681_e_;
        private final RenderState.DepthTestState field_228682_f_;
        private final RenderState.CullState field_228683_g_;
        private final RenderState.LightmapState field_228684_h_;
        private final RenderState.OverlayState field_228685_i_;
        private final RenderState.FogState field_228686_j_;
        private final RenderState.LayerState field_228687_k_;
        private final RenderState.TargetState field_228688_l_;
        private final RenderState.TexturingState field_228689_m_;
        private final RenderState.WriteMaskState field_228690_n_;
        private final RenderState.LineState field_228691_o_;
        private final OutlineState field_230171_p_;
        private final ImmutableList<RenderState> field_228693_q_;

        private State(RenderState.TextureState textureState, RenderState.TransparencyState transparencyState, RenderState.DiffuseLightingState diffuseLightingState, RenderState.ShadeModelState shadeModelState, RenderState.AlphaState alphaState, RenderState.DepthTestState depthTestState, RenderState.CullState cullState, RenderState.LightmapState lightmapState, RenderState.OverlayState overlayState, RenderState.FogState fogState, RenderState.LayerState layerState, RenderState.TargetState targetState, RenderState.TexturingState texturingState, RenderState.WriteMaskState writeMaskState, RenderState.LineState lineState, OutlineState outlineState) {
            this.field_228677_a_ = textureState;
            this.field_228678_b_ = transparencyState;
            this.field_228679_c_ = diffuseLightingState;
            this.field_228680_d_ = shadeModelState;
            this.field_228681_e_ = alphaState;
            this.field_228682_f_ = depthTestState;
            this.field_228683_g_ = cullState;
            this.field_228684_h_ = lightmapState;
            this.field_228685_i_ = overlayState;
            this.field_228686_j_ = fogState;
            this.field_228687_k_ = layerState;
            this.field_228688_l_ = targetState;
            this.field_228689_m_ = texturingState;
            this.field_228690_n_ = writeMaskState;
            this.field_228691_o_ = lineState;
            this.field_230171_p_ = outlineState;
            this.field_228693_q_ = ImmutableList.of((Object)this.field_228677_a_, (Object)this.field_228678_b_, (Object)this.field_228679_c_, (Object)this.field_228680_d_, (Object)this.field_228681_e_, (Object)this.field_228682_f_, (Object)this.field_228683_g_, (Object)this.field_228684_h_, (Object)this.field_228685_i_, (Object)this.field_228686_j_, (Object)this.field_228687_k_, (Object)this.field_228688_l_, (Object[])new RenderState[]{this.field_228689_m_, this.field_228690_n_, this.field_228691_o_});
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            State state = (State)object;
            return this.field_230171_p_ == state.field_230171_p_ && this.field_228693_q_.equals(state.field_228693_q_);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.field_228693_q_, this.field_230171_p_});
        }

        public static Builder func_228694_a_() {
            return new Builder();
        }

        public static class Builder {
            private RenderState.TextureState field_228698_a_ = RenderState.field_228523_o_;
            private RenderState.TransparencyState field_228699_b_ = RenderState.field_228510_b_;
            private RenderState.DiffuseLightingState field_228700_c_ = RenderState.field_228533_y_;
            private RenderState.ShadeModelState field_228701_d_ = RenderState.field_228519_k_;
            private RenderState.AlphaState field_228702_e_ = RenderState.field_228516_h_;
            private RenderState.DepthTestState field_228703_f_ = RenderState.field_228494_D_;
            private RenderState.CullState field_228704_g_ = RenderState.field_228534_z_;
            private RenderState.LightmapState field_228705_h_ = RenderState.field_228529_u_;
            private RenderState.OverlayState field_228706_i_ = RenderState.field_228531_w_;
            private RenderState.FogState field_228707_j_ = RenderState.field_228502_L_;
            private RenderState.LayerState field_228708_k_ = RenderState.field_228498_H_;
            private RenderState.TargetState field_228709_l_ = RenderState.field_228504_N_;
            private RenderState.TexturingState field_228710_m_ = RenderState.field_228524_p_;
            private RenderState.WriteMaskState field_228711_n_ = RenderState.field_228495_E_;
            private RenderState.LineState field_228712_o_ = RenderState.field_228506_P_;

            private Builder() {
            }

            public Builder func_228724_a_(RenderState.TextureState textureState) {
                this.field_228698_a_ = textureState;
                return this;
            }

            public Builder func_228726_a_(RenderState.TransparencyState transparencyState) {
                this.field_228699_b_ = transparencyState;
                return this;
            }

            public Builder func_228716_a_(RenderState.DiffuseLightingState diffuseLightingState) {
                this.field_228700_c_ = diffuseLightingState;
                return this;
            }

            public Builder func_228723_a_(RenderState.ShadeModelState shadeModelState) {
                this.field_228701_d_ = shadeModelState;
                return this;
            }

            public Builder func_228713_a_(RenderState.AlphaState alphaState) {
                this.field_228702_e_ = alphaState;
                return this;
            }

            public Builder func_228715_a_(RenderState.DepthTestState depthTestState) {
                this.field_228703_f_ = depthTestState;
                return this;
            }

            public Builder func_228714_a_(RenderState.CullState cullState) {
                this.field_228704_g_ = cullState;
                return this;
            }

            public Builder func_228719_a_(RenderState.LightmapState lightmapState) {
                this.field_228705_h_ = lightmapState;
                return this;
            }

            public Builder func_228722_a_(RenderState.OverlayState overlayState) {
                this.field_228706_i_ = overlayState;
                return this;
            }

            public Builder func_228717_a_(RenderState.FogState fogState) {
                this.field_228707_j_ = fogState;
                return this;
            }

            public Builder func_228718_a_(RenderState.LayerState layerState) {
                this.field_228708_k_ = layerState;
                return this;
            }

            public Builder func_228721_a_(RenderState.TargetState targetState) {
                this.field_228709_l_ = targetState;
                return this;
            }

            public Builder func_228725_a_(RenderState.TexturingState texturingState) {
                this.field_228710_m_ = texturingState;
                return this;
            }

            public Builder func_228727_a_(RenderState.WriteMaskState writeMaskState) {
                this.field_228711_n_ = writeMaskState;
                return this;
            }

            public Builder func_228720_a_(RenderState.LineState lineState) {
                this.field_228712_o_ = lineState;
                return this;
            }

            public State func_228728_a_(boolean bl) {
                return this.func_230173_a_(bl ? OutlineState.AFFECTS_OUTLINE : OutlineState.NONE);
            }

            public State func_230173_a_(OutlineState outlineState) {
                return new State(this.field_228698_a_, this.field_228699_b_, this.field_228700_c_, this.field_228701_d_, this.field_228702_e_, this.field_228703_f_, this.field_228704_g_, this.field_228705_h_, this.field_228706_i_, this.field_228707_j_, this.field_228708_k_, this.field_228709_l_, this.field_228710_m_, this.field_228711_n_, this.field_228712_o_, outlineState);
            }
        }
    }

    static enum OutlineState {
        NONE,
        IS_OUTLINE,
        AFFECTS_OUTLINE;

    }
}

