/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.MatrixApplyingVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.OutlineLayerBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderTimeManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.settings.AbstractOption;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldRenderer
implements AutoCloseable,
IResourceManagerReloadListener {
    private static final Logger field_147599_m = LogManager.getLogger();
    private static final ResourceLocation field_110927_h = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation field_110928_i = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation field_110925_j = new ResourceLocation("textures/environment/clouds.png");
    private static final ResourceLocation field_110926_k = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation field_175006_g = new ResourceLocation("textures/misc/forcefield.png");
    private static final ResourceLocation field_228413_h_ = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation field_228414_i_ = new ResourceLocation("textures/environment/snow.png");
    public static final Direction[] field_200006_a = Direction.values();
    private final Minecraft field_72777_q;
    private final TextureManager field_72770_i;
    private final EntityRendererManager field_175010_j;
    private final RenderTypeBuffers field_228415_m_;
    private ClientWorld field_72769_h;
    private Set<ChunkRenderDispatcher.ChunkRender> field_175009_l = Sets.newLinkedHashSet();
    private final ObjectList<LocalRenderInformationContainer> field_72755_R = new ObjectArrayList(69696);
    private final Set<TileEntity> field_181024_n = Sets.newHashSet();
    private ViewFrustum field_175008_n;
    private final VertexFormat field_175014_r = DefaultVertexFormats.field_181705_e;
    @Nullable
    private VertexBuffer field_175013_s;
    @Nullable
    private VertexBuffer field_175012_t;
    @Nullable
    private VertexBuffer field_175011_u;
    private boolean field_204607_y = true;
    @Nullable
    private VertexBuffer field_204601_A;
    private RenderTimeManager field_228416_y_ = new RenderTimeManager(100);
    private int field_72773_u;
    private final Int2ObjectMap<DestroyBlockProgress> field_72738_E = new Int2ObjectOpenHashMap();
    private final Long2ObjectMap<SortedSet<DestroyBlockProgress>> field_228407_B_ = new Long2ObjectOpenHashMap();
    private final Map<BlockPos, ISound> field_147593_P = Maps.newHashMap();
    private Framebuffer field_175015_z;
    private ShaderGroup field_174991_A;
    private double field_174992_B = Double.MIN_VALUE;
    private double field_174993_C = Double.MIN_VALUE;
    private double field_174987_D = Double.MIN_VALUE;
    private int field_174988_E = Integer.MIN_VALUE;
    private int field_174989_F = Integer.MIN_VALUE;
    private int field_174990_G = Integer.MIN_VALUE;
    private double field_174997_H = Double.MIN_VALUE;
    private double field_174998_I = Double.MIN_VALUE;
    private double field_174999_J = Double.MIN_VALUE;
    private double field_175000_K = Double.MIN_VALUE;
    private double field_174994_L = Double.MIN_VALUE;
    private int field_204602_S = Integer.MIN_VALUE;
    private int field_204603_T = Integer.MIN_VALUE;
    private int field_204604_U = Integer.MIN_VALUE;
    private Vec3d field_204605_V = Vec3d.field_186680_a;
    private CloudOption field_204800_W;
    private ChunkRenderDispatcher field_174995_M;
    private final VertexFormat field_228408_W_ = DefaultVertexFormats.field_176600_a;
    private int field_72739_F = -1;
    private int field_72749_I;
    private int field_72750_J;
    private boolean field_175002_T;
    @Nullable
    private ClippingHelperImpl field_175001_U;
    private final Vector4f[] field_175004_V = new Vector4f[8];
    private final Vector3d field_175003_W = new Vector3d(0.0, 0.0, 0.0);
    private double field_147596_f;
    private double field_147597_g;
    private double field_147602_h;
    private boolean field_147595_R = true;
    private int field_228409_ai_;
    private int field_228410_aj_;
    private final float[] field_228411_ak_ = new float[1024];
    private final float[] field_228412_al_ = new float[1024];

    public WorldRenderer(Minecraft minecraft, RenderTypeBuffers renderTypeBuffers) {
        this.field_72777_q = minecraft;
        this.field_175010_j = minecraft.func_175598_ae();
        this.field_228415_m_ = renderTypeBuffers;
        this.field_72770_i = minecraft.func_110434_K();
        for (int i = 0; i < 32; ++i) {
            for (\u2603 = 0; \u2603 < 32; ++\u2603) {
                float f = \u2603 - 16;
                \u2603 = i - 16;
                \u2603 = MathHelper.func_76129_c(f * f + \u2603 * \u2603);
                this.field_228411_ak_[i << 5 | \u2603] = -\u2603 / \u2603;
                this.field_228412_al_[i << 5 | \u2603] = f / \u2603;
            }
        }
        this.func_174963_q();
        this.func_174980_p();
        this.func_174964_o();
    }

    private void func_228438_a_(LightTexture lightTexture, float f, double d, double d2, double d3) {
        float f2 = this.field_72777_q.field_71441_e.func_72867_j(f);
        if (f2 <= 0.0f) {
            return;
        }
        lightTexture.func_205109_c();
        ClientWorld \u26032 = this.field_72777_q.field_71441_e;
        int \u26033 = MathHelper.func_76128_c(d);
        int \u26034 = MathHelper.func_76128_c(d2);
        int \u26035 = MathHelper.func_76128_c(d3);
        Tessellator \u26036 = Tessellator.func_178181_a();
        BufferBuilder \u26037 = \u26036.func_178180_c();
        RenderSystem.disableCull();
        RenderSystem.normal3f(0.0f, 1.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.defaultAlphaFunc();
        int \u26038 = 5;
        if (this.field_72777_q.field_71474_y.field_74347_j) {
            \u26038 = 10;
        }
        int \u26039 = -1;
        \u2603 = (float)this.field_72773_u + f;
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        BlockPos.Mutable \u260310 = new BlockPos.Mutable();
        for (int i = \u26035 - \u26038; i <= \u26035 + \u26038; ++i) {
            for (n = \u26033 - \u26038; n <= \u26033 + \u26038; ++n) {
                int n;
                \u2603 = (i - \u26035 + 16) * 32 + n - \u26033 + 16;
                double d4 = (double)this.field_228411_ak_[\u2603] * 0.5;
                \u2603 = (double)this.field_228412_al_[\u2603] * 0.5;
                \u260310.func_181079_c(n, 0, i);
                Biome \u260311 = \u26032.func_226691_t_(\u260310);
                if (\u260311.func_201851_b() == Biome.RainType.NONE) continue;
                int \u260312 = \u26032.func_205770_a(Heightmap.Type.MOTION_BLOCKING, \u260310).func_177956_o();
                int \u260313 = \u26034 - \u26038;
                int \u260314 = \u26034 + \u26038;
                if (\u260313 < \u260312) {
                    \u260313 = \u260312;
                }
                if (\u260314 < \u260312) {
                    \u260314 = \u260312;
                }
                if ((n2 = \u260312) < \u26034) {
                    int n2 = \u26034;
                }
                if (\u260313 == \u260314) continue;
                Random \u260315 = new Random(n * n * 3121 + n * 45238971 ^ i * i * 418711 + i * 13761);
                \u260310.func_181079_c(n, \u260313, i);
                float \u260316 = \u260311.func_225486_c(\u260310);
                if (\u260316 >= 0.15f) {
                    if (\u26039 != 0) {
                        if (\u26039 >= 0) {
                            \u26036.func_78381_a();
                        }
                        \u26039 = 0;
                        this.field_72777_q.func_110434_K().func_110577_a(field_228413_h_);
                        \u26037.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    \u2603 = this.field_72773_u + n * n * 3121 + n * 45238971 + i * i * 418711 + i * 13761 & 0x1F;
                    float f3 = -((float)\u2603 + f) / 32.0f * (3.0f + \u260315.nextFloat());
                    double \u260317 = (double)((float)n + 0.5f) - d;
                    double \u260318 = (double)((float)i + 0.5f) - d3;
                    \u2603 = MathHelper.func_76133_a(\u260317 * \u260317 + \u260318 * \u260318) / (float)\u26038;
                    \u260320 = ((1.0f - \u2603 * \u2603) * 0.5f + 0.5f) * f2;
                    \u260310.func_181079_c(n, n2, i);
                    int \u260319 = WorldRenderer.func_228421_a_(\u26032, \u260310);
                    \u26037.func_225582_a_((double)n - d - d4 + 0.5, (double)\u260314 - d2, (double)i - d3 - \u2603 + 0.5).func_225583_a_(0.0f, (float)\u260313 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, \u260320).func_227886_a_(\u260319).func_181675_d();
                    \u26037.func_225582_a_((double)n - d + d4 + 0.5, (double)\u260314 - d2, (double)i - d3 + \u2603 + 0.5).func_225583_a_(1.0f, (float)\u260313 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, \u260320).func_227886_a_(\u260319).func_181675_d();
                    \u26037.func_225582_a_((double)n - d + d4 + 0.5, (double)\u260313 - d2, (double)i - d3 + \u2603 + 0.5).func_225583_a_(1.0f, (float)\u260314 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, \u260320).func_227886_a_(\u260319).func_181675_d();
                    \u26037.func_225582_a_((double)n - d - d4 + 0.5, (double)\u260313 - d2, (double)i - d3 - \u2603 + 0.5).func_225583_a_(0.0f, (float)\u260314 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, \u260320).func_227886_a_(\u260319).func_181675_d();
                    continue;
                }
                if (\u26039 != 1) {
                    if (\u26039 >= 0) {
                        \u26036.func_78381_a();
                    }
                    \u26039 = 1;
                    this.field_72777_q.func_110434_K().func_110577_a(field_228414_i_);
                    \u26037.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                }
                \u2603 = -((float)(this.field_72773_u & 0x1FF) + f) / 512.0f;
                f3 = (float)(\u260315.nextDouble() + (double)\u2603 * 0.01 * (double)((float)\u260315.nextGaussian()));
                \u2603 = (float)(\u260315.nextDouble() + (double)(\u2603 * (float)\u260315.nextGaussian()) * 0.001);
                double d5 = (double)((float)n + 0.5f) - d;
                \u2603 = (double)((float)i + 0.5f) - d3;
                float \u260320 = MathHelper.func_76133_a(d5 * d5 + \u2603 * \u2603) / (float)\u26038;
                float \u260321 = ((1.0f - \u260320 * \u260320) * 0.3f + 0.5f) * f2;
                \u260310.func_181079_c(n, n2, i);
                int \u260322 = WorldRenderer.func_228421_a_(\u26032, \u260310);
                int \u260323 = \u260322 >> 16 & 0xFFFF;
                int \u260324 = (\u260322 & 0xFFFF) * 3;
                int \u260325 = (\u260323 * 3 + 240) / 4;
                int \u260326 = (\u260324 * 3 + 240) / 4;
                \u26037.func_225582_a_((double)n - d - d4 + 0.5, (double)\u260314 - d2, (double)i - d3 - \u2603 + 0.5).func_225583_a_(0.0f + f3, (float)\u260313 * 0.25f + \u2603 + \u2603).func_227885_a_(1.0f, 1.0f, 1.0f, \u260321).func_225587_b_(\u260326, \u260325).func_181675_d();
                \u26037.func_225582_a_((double)n - d + d4 + 0.5, (double)\u260314 - d2, (double)i - d3 + \u2603 + 0.5).func_225583_a_(1.0f + f3, (float)\u260313 * 0.25f + \u2603 + \u2603).func_227885_a_(1.0f, 1.0f, 1.0f, \u260321).func_225587_b_(\u260326, \u260325).func_181675_d();
                \u26037.func_225582_a_((double)n - d + d4 + 0.5, (double)\u260313 - d2, (double)i - d3 + \u2603 + 0.5).func_225583_a_(1.0f + f3, (float)\u260314 * 0.25f + \u2603 + \u2603).func_227885_a_(1.0f, 1.0f, 1.0f, \u260321).func_225587_b_(\u260326, \u260325).func_181675_d();
                \u26037.func_225582_a_((double)n - d - d4 + 0.5, (double)\u260313 - d2, (double)i - d3 - \u2603 + 0.5).func_225583_a_(0.0f + f3, (float)\u260314 * 0.25f + \u2603 + \u2603).func_227885_a_(1.0f, 1.0f, 1.0f, \u260321).func_225587_b_(\u260326, \u260325).func_181675_d();
            }
        }
        if (\u26039 >= 0) {
            \u26036.func_78381_a();
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.defaultAlphaFunc();
        lightTexture.func_205108_b();
    }

    public void func_228436_a_(ActiveRenderInfo activeRenderInfo) {
        float f = this.field_72777_q.field_71441_e.func_72867_j(1.0f);
        if (!this.field_72777_q.field_71474_y.field_74347_j) {
            f /= 2.0f;
        }
        if (f == 0.0f) {
            return;
        }
        Random \u26032 = new Random((long)this.field_72773_u * 312987231L);
        ClientWorld \u26033 = this.field_72777_q.field_71441_e;
        BlockPos \u26034 = new BlockPos(activeRenderInfo.func_216785_c());
        int \u26035 = 10;
        double \u26036 = 0.0;
        double \u26037 = 0.0;
        double \u26038 = 0.0;
        int \u26039 = 0;
        int \u260310 = (int)(100.0f * f * f);
        if (this.field_72777_q.field_71474_y.field_74362_aa == ParticleStatus.DECREASED) {
            \u260310 >>= 1;
        } else if (this.field_72777_q.field_71474_y.field_74362_aa == ParticleStatus.MINIMAL) {
            \u260310 = 0;
        }
        for (int i = 0; i < \u260310; ++i) {
            double d;
            BlockPos blockPos = \u26033.func_205770_a(Heightmap.Type.MOTION_BLOCKING, \u26034.func_177982_a(\u26032.nextInt(10) - \u26032.nextInt(10), 0, \u26032.nextInt(10) - \u26032.nextInt(10)));
            Biome \u260311 = \u26033.func_226691_t_(blockPos);
            \u2603 = blockPos.func_177977_b();
            if (blockPos.func_177956_o() > \u26034.func_177956_o() + 10 || blockPos.func_177956_o() < \u26034.func_177956_o() - 10 || \u260311.func_201851_b() != Biome.RainType.RAIN || !(\u260311.func_225486_c(blockPos) >= 0.15f)) continue;
            double \u260312 = \u26032.nextDouble();
            double \u260313 = \u26032.nextDouble();
            BlockState \u260314 = \u26033.func_180495_p(\u2603);
            IFluidState \u260315 = \u26033.func_204610_c(blockPos);
            VoxelShape \u260316 = \u260314.func_196952_d(\u26033, \u2603);
            double \u260317 = \u260316.func_197760_b(Direction.Axis.Y, \u260312, \u260313);
            if (\u260317 >= (\u2603 = (double)\u260315.func_215679_a(\u26033, blockPos))) {
                d = \u260317;
                \u2603 = \u260316.func_197764_a(Direction.Axis.Y, \u260312, \u260313);
            } else {
                d = 0.0;
                \u2603 = 0.0;
            }
            if (!(d > -1.7976931348623157E308)) continue;
            if (\u260315.func_206884_a(FluidTags.field_206960_b) || \u260314.func_177230_c() == Blocks.field_196814_hQ || \u260314.func_177230_c() == Blocks.field_222433_lV && \u260314.func_177229_b(CampfireBlock.field_220101_b).booleanValue()) {
                this.field_72777_q.field_71441_e.func_195594_a(ParticleTypes.field_197601_L, (double)blockPos.func_177958_n() + \u260312, (double)((float)blockPos.func_177956_o() + 0.1f) - \u2603, (double)blockPos.func_177952_p() + \u260313, 0.0, 0.0, 0.0);
                continue;
            }
            if (\u26032.nextInt(++\u26039) == 0) {
                \u26036 = (double)\u2603.func_177958_n() + \u260312;
                \u26037 = (double)((float)\u2603.func_177956_o() + 0.1f) + d - 1.0;
                \u26038 = (double)\u2603.func_177952_p() + \u260313;
            }
            this.field_72777_q.field_71441_e.func_195594_a(ParticleTypes.field_197600_K, (double)\u2603.func_177958_n() + \u260312, (double)((float)\u2603.func_177956_o() + 0.1f) + d, (double)\u2603.func_177952_p() + \u260313, 0.0, 0.0, 0.0);
        }
        if (\u26039 > 0 && \u26032.nextInt(3) < this.field_228410_aj_++) {
            this.field_228410_aj_ = 0;
            if (\u26037 > (double)(\u26034.func_177956_o() + 1) && \u26033.func_205770_a(Heightmap.Type.MOTION_BLOCKING, \u26034).func_177956_o() > MathHelper.func_76141_d(\u26034.func_177956_o())) {
                this.field_72777_q.field_71441_e.func_184134_a(\u26036, \u26037, \u26038, SoundEvents.field_187919_gs, SoundCategory.WEATHER, 0.1f, 0.5f, false);
            } else {
                this.field_72777_q.field_71441_e.func_184134_a(\u26036, \u26037, \u26038, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.2f, 1.0f, false);
            }
        }
    }

    @Override
    public void close() {
        if (this.field_174991_A != null) {
            this.field_174991_A.close();
        }
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        this.field_72770_i.func_110577_a(field_175006_g);
        RenderSystem.texParameter(3553, 10242, 10497);
        RenderSystem.texParameter(3553, 10243, 10497);
        RenderSystem.bindTexture(0);
        this.func_174966_b();
    }

    public void func_174966_b() {
        if (this.field_174991_A != null) {
            this.field_174991_A.close();
        }
        ResourceLocation resourceLocation = new ResourceLocation("shaders/post/entity_outline.json");
        try {
            this.field_174991_A = new ShaderGroup(this.field_72777_q.func_110434_K(), this.field_72777_q.func_195551_G(), this.field_72777_q.func_147110_a(), resourceLocation);
            this.field_174991_A.func_148026_a(this.field_72777_q.func_228018_at_().func_198109_k(), this.field_72777_q.func_228018_at_().func_198091_l());
            this.field_175015_z = this.field_174991_A.func_177066_a("final");
        }
        catch (IOException \u26032) {
            field_147599_m.warn("Failed to load shader: {}", (Object)resourceLocation, (Object)\u26032);
            this.field_174991_A = null;
            this.field_175015_z = null;
        }
        catch (JsonSyntaxException \u26033) {
            field_147599_m.warn("Failed to load shader: {}", (Object)resourceLocation, (Object)\u26033);
            this.field_174991_A = null;
            this.field_175015_z = null;
        }
    }

    public void func_174975_c() {
        if (this.func_174985_d()) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
            this.field_175015_z.func_178038_a(this.field_72777_q.func_228018_at_().func_198109_k(), this.field_72777_q.func_228018_at_().func_198091_l(), false);
            RenderSystem.disableBlend();
        }
    }

    protected boolean func_174985_d() {
        return this.field_175015_z != null && this.field_174991_A != null && this.field_72777_q.field_71439_g != null;
    }

    private void func_174964_o() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        if (this.field_175011_u != null) {
            this.field_175011_u.close();
        }
        this.field_175011_u = new VertexBuffer(this.field_175014_r);
        this.func_174968_a(\u26032, -16.0f, true);
        \u26032.func_178977_d();
        this.field_175011_u.func_227875_a_(\u26032);
    }

    private void func_174980_p() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        if (this.field_175012_t != null) {
            this.field_175012_t.close();
        }
        this.field_175012_t = new VertexBuffer(this.field_175014_r);
        this.func_174968_a(\u26032, 16.0f, false);
        \u26032.func_178977_d();
        this.field_175012_t.func_227875_a_(\u26032);
    }

    private void func_174968_a(BufferBuilder bufferBuilder, float f, boolean bl) {
        int n = 64;
        \u2603 = 6;
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (\u2603 = -384; \u2603 <= 384; \u2603 += 64) {
            for (\u2603 = -384; \u2603 <= 384; \u2603 += 64) {
                float f2 = \u2603;
                \u2603 = \u2603 + 64;
                if (bl) {
                    \u2603 = \u2603;
                    f2 = \u2603 + 64;
                }
                bufferBuilder.func_225582_a_(f2, f, \u2603).func_181675_d();
                bufferBuilder.func_225582_a_(\u2603, f, \u2603).func_181675_d();
                bufferBuilder.func_225582_a_(\u2603, f, \u2603 + 64).func_181675_d();
                bufferBuilder.func_225582_a_(f2, f, \u2603 + 64).func_181675_d();
            }
        }
    }

    private void func_174963_q() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        if (this.field_175013_s != null) {
            this.field_175013_s.close();
        }
        this.field_175013_s = new VertexBuffer(this.field_175014_r);
        this.func_180444_a(\u26032);
        \u26032.func_178977_d();
        this.field_175013_s.func_227875_a_(\u26032);
    }

    private void func_180444_a(BufferBuilder bufferBuilder) {
        Random random = new Random(10842L);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 1500; ++i) {
            double d = random.nextFloat() * 2.0f - 1.0f;
            \u2603 = random.nextFloat() * 2.0f - 1.0f;
            \u2603 = random.nextFloat() * 2.0f - 1.0f;
            \u2603 = 0.15f + random.nextFloat() * 0.1f;
            \u2603 = d * d + \u2603 * \u2603 + \u2603 * \u2603;
            if (!(\u2603 < 1.0) || !(\u2603 > 0.01)) continue;
            \u2603 = 1.0 / Math.sqrt(\u2603);
            \u2603 = (d *= \u2603) * 100.0;
            \u2603 = (\u2603 *= \u2603) * 100.0;
            \u2603 = (\u2603 *= \u2603) * 100.0;
            \u2603 = Math.atan2(d, \u2603);
            \u2603 = Math.sin(\u2603);
            \u2603 = Math.cos(\u2603);
            \u2603 = Math.atan2(Math.sqrt(d * d + \u2603 * \u2603), \u2603);
            \u2603 = Math.sin(\u2603);
            \u2603 = Math.cos(\u2603);
            \u2603 = random.nextDouble() * Math.PI * 2.0;
            \u2603 = Math.sin(\u2603);
            \u2603 = Math.cos(\u2603);
            for (int j = 0; j < 4; ++j) {
                double d2 = 0.0;
                \u2603 = (double)((j & 2) - 1) * \u2603;
                \u2603 = (double)((j + 1 & 2) - 1) * \u2603;
                \u2603 = 0.0;
                \u2603 = \u2603 * \u2603 - \u2603 * \u2603;
                \u2603 = \u2603 = \u2603 * \u2603 + \u2603 * \u2603;
                \u2603 = \u2603 * \u2603 + 0.0 * \u2603;
                \u2603 = 0.0 * \u2603 - \u2603 * \u2603;
                \u2603 = \u2603 * \u2603 - \u2603 * \u2603;
                \u2603 = \u2603;
                \u2603 = \u2603 * \u2603 + \u2603 * \u2603;
                bufferBuilder.func_225582_a_(\u2603 + \u2603, \u2603 + \u2603, \u2603 + \u2603).func_181675_d();
            }
        }
    }

    public void func_72732_a(@Nullable ClientWorld clientWorld) {
        this.field_174992_B = Double.MIN_VALUE;
        this.field_174993_C = Double.MIN_VALUE;
        this.field_174987_D = Double.MIN_VALUE;
        this.field_174988_E = Integer.MIN_VALUE;
        this.field_174989_F = Integer.MIN_VALUE;
        this.field_174990_G = Integer.MIN_VALUE;
        this.field_175010_j.func_78717_a(clientWorld);
        this.field_72769_h = clientWorld;
        if (clientWorld != null) {
            this.func_72712_a();
        } else {
            this.field_175009_l.clear();
            this.field_72755_R.clear();
            if (this.field_175008_n != null) {
                this.field_175008_n.func_178160_a();
                this.field_175008_n = null;
            }
            if (this.field_174995_M != null) {
                this.field_174995_M.func_188244_g();
            }
            this.field_174995_M = null;
            this.field_181024_n.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_72712_a() {
        Entity entity;
        if (this.field_72769_h == null) {
            return;
        }
        this.field_72769_h.func_228327_h_();
        if (this.field_174995_M == null) {
            this.field_174995_M = new ChunkRenderDispatcher(this.field_72769_h, this, Util.func_215072_e(), this.field_72777_q.func_147111_S(), this.field_228415_m_.func_228484_a_());
        } else {
            this.field_174995_M.func_228895_a_(this.field_72769_h);
        }
        this.field_147595_R = true;
        this.field_204607_y = true;
        RenderTypeLookup.func_228393_a_(this.field_72777_q.field_71474_y.field_74347_j);
        this.field_72739_F = this.field_72777_q.field_71474_y.field_151451_c;
        if (this.field_175008_n != null) {
            this.field_175008_n.func_178160_a();
        }
        this.func_174986_e();
        Set<TileEntity> set = this.field_181024_n;
        synchronized (set) {
            this.field_181024_n.clear();
        }
        this.field_175008_n = new ViewFrustum(this.field_174995_M, this.field_72769_h, this.field_72777_q.field_71474_y.field_151451_c, this);
        if (this.field_72769_h != null && (entity = this.field_72777_q.func_175606_aa()) != null) {
            this.field_175008_n.func_178163_a(entity.func_226277_ct_(), entity.func_226281_cx_());
        }
    }

    protected void func_174986_e() {
        this.field_175009_l.clear();
        this.field_174995_M.func_178514_b();
    }

    public void func_72720_a(int n, int n2) {
        this.func_174979_m();
        if (this.field_174991_A != null) {
            this.field_174991_A.func_148026_a(n, n2);
        }
    }

    public String func_72735_c() {
        int n = this.field_175008_n.field_178164_f.length;
        \u2603 = this.func_184382_g();
        return String.format("C: %d/%d %sD: %d, %s", \u2603, n, this.field_72777_q.field_175612_E ? "(s) " : "", this.field_72739_F, this.field_174995_M == null ? "null" : this.field_174995_M.func_178504_a());
    }

    protected int func_184382_g() {
        int n = 0;
        for (LocalRenderInformationContainer localRenderInformationContainer : this.field_72755_R) {
            if (localRenderInformationContainer.field_178036_a.func_178571_g().func_178489_a()) continue;
            ++n;
        }
        return n;
    }

    public String func_72723_d() {
        return "E: " + this.field_72749_I + "/" + this.field_72769_h.func_217425_f() + ", B: " + this.field_72750_J;
    }

    private void func_228437_a_(ActiveRenderInfo activeRenderInfo, ClippingHelperImpl clippingHelperImpl, boolean bl, int n, boolean bl2) {
        Collection<ChunkRenderDispatcher.ChunkRender> collection;
        Vec3d vec3d = activeRenderInfo.func_216785_c();
        if (this.field_72777_q.field_71474_y.field_151451_c != this.field_72739_F) {
            this.func_72712_a();
        }
        this.field_72769_h.func_217381_Z().func_76320_a("camera");
        double \u26032 = this.field_72777_q.field_71439_g.func_226277_ct_() - this.field_174992_B;
        double \u26033 = this.field_72777_q.field_71439_g.func_226278_cu_() - this.field_174993_C;
        double \u26034 = this.field_72777_q.field_71439_g.func_226281_cx_() - this.field_174987_D;
        if (this.field_174988_E != this.field_72777_q.field_71439_g.field_70176_ah || this.field_174989_F != this.field_72777_q.field_71439_g.field_70162_ai || this.field_174990_G != this.field_72777_q.field_71439_g.field_70164_aj || \u26032 * \u26032 + \u26033 * \u26033 + \u26034 * \u26034 > 16.0) {
            this.field_174992_B = this.field_72777_q.field_71439_g.func_226277_ct_();
            this.field_174993_C = this.field_72777_q.field_71439_g.func_226278_cu_();
            this.field_174987_D = this.field_72777_q.field_71439_g.func_226281_cx_();
            this.field_174988_E = this.field_72777_q.field_71439_g.field_70176_ah;
            this.field_174989_F = this.field_72777_q.field_71439_g.field_70162_ai;
            this.field_174990_G = this.field_72777_q.field_71439_g.field_70164_aj;
            this.field_175008_n.func_178163_a(this.field_72777_q.field_71439_g.func_226277_ct_(), this.field_72777_q.field_71439_g.func_226281_cx_());
        }
        this.field_174995_M.func_217669_a(vec3d);
        this.field_72769_h.func_217381_Z().func_219895_b("cull");
        this.field_72777_q.func_213239_aq().func_219895_b("culling");
        BlockPos \u26035 = activeRenderInfo.func_216780_d();
        ChunkRenderDispatcher.ChunkRender \u26036 = this.field_175008_n.func_178161_a(\u26035);
        int \u26037 = 16;
        BlockPos \u26038 = new BlockPos(MathHelper.func_76128_c(vec3d.field_72450_a / 16.0) * 16, MathHelper.func_76128_c(vec3d.field_72448_b / 16.0) * 16, MathHelper.func_76128_c(vec3d.field_72449_c / 16.0) * 16);
        float \u26039 = activeRenderInfo.func_216777_e();
        float \u260310 = activeRenderInfo.func_216778_f();
        this.field_147595_R = this.field_147595_R || !this.field_175009_l.isEmpty() || vec3d.field_72450_a != this.field_174997_H || vec3d.field_72448_b != this.field_174998_I || vec3d.field_72449_c != this.field_174999_J || (double)\u26039 != this.field_175000_K || (double)\u260310 != this.field_174994_L;
        this.field_174997_H = vec3d.field_72450_a;
        this.field_174998_I = vec3d.field_72448_b;
        this.field_174999_J = vec3d.field_72449_c;
        this.field_175000_K = \u26039;
        this.field_174994_L = \u260310;
        this.field_72777_q.func_213239_aq().func_219895_b("update");
        if (!bl && this.field_147595_R) {
            Direction[] \u260312;
            int n2;
            this.field_147595_R = false;
            this.field_72755_R.clear();
            collection = Queues.newArrayDeque();
            Entity.func_184227_b(MathHelper.func_151237_a((double)this.field_72777_q.field_71474_y.field_151451_c / 8.0, 1.0, 2.5));
            boolean \u260311 = this.field_72777_q.field_175612_E;
            if (\u26036 == null) {
                n2 = \u26035.func_177956_o() > 0 ? 248 : 8;
                \u2603 = MathHelper.func_76128_c(vec3d.field_72450_a / 16.0) * 16;
                \u2603 = MathHelper.func_76128_c(vec3d.field_72449_c / 16.0) * 16;
                \u260312 = Lists.newArrayList();
                for (\u2603 = -this.field_72739_F; \u2603 <= this.field_72739_F; ++\u2603) {
                    for (\u2603 = -this.field_72739_F; \u2603 <= this.field_72739_F; ++\u2603) {
                        ChunkRenderDispatcher.ChunkRender chunkRender = this.field_175008_n.func_178161_a(new BlockPos(\u2603 + (\u2603 << 4) + 8, n2, \u2603 + (\u2603 << 4) + 8));
                        if (chunkRender == null || !clippingHelperImpl.func_228957_a_(chunkRender.field_178591_c)) continue;
                        chunkRender.func_178577_a(n);
                        \u260312.add(new LocalRenderInformationContainer(chunkRender, null, 0));
                    }
                }
                \u260312.sort(Comparator.comparingDouble(localRenderInformationContainer -> \u26035.func_177951_i(((LocalRenderInformationContainer)localRenderInformationContainer).field_178036_a.func_178568_j().func_177982_a(8, 8, 8))));
                collection.addAll((Collection<ChunkRenderDispatcher.ChunkRender>)\u260312);
            } else {
                n2 = 0;
                LocalRenderInformationContainer \u260313 = new LocalRenderInformationContainer(\u26036, null, 0);
                Set<Direction> \u260314 = this.func_174978_c(\u26035);
                if (\u260314.size() == 1) {
                    \u260312 = activeRenderInfo.func_227996_l_();
                    Direction direction = Direction.func_176737_a(\u260312.func_195899_a(), \u260312.func_195900_b(), \u260312.func_195902_c()).func_176734_d();
                    \u260314.remove(direction);
                }
                if (\u260314.isEmpty()) {
                    n2 = 1;
                }
                if (n2 == 0 || bl2) {
                    if (bl2 && this.field_72769_h.func_180495_p(\u26035).func_200015_d(this.field_72769_h, \u26035)) {
                        \u260311 = false;
                    }
                    \u26036.func_178577_a(n);
                    collection.add((ChunkRenderDispatcher.ChunkRender)((Object)\u260313));
                } else {
                    this.field_72755_R.add((Object)\u260313);
                }
            }
            this.field_72777_q.func_213239_aq().func_76320_a("iteration");
            while (!collection.isEmpty()) {
                LocalRenderInformationContainer localRenderInformationContainer2 = (LocalRenderInformationContainer)collection.poll();
                ChunkRenderDispatcher.ChunkRender \u260315 = localRenderInformationContainer2.field_178036_a;
                Direction \u260316 = localRenderInformationContainer2.field_178034_b;
                this.field_72755_R.add((Object)localRenderInformationContainer2);
                for (Direction direction : field_200006_a) {
                    ChunkRenderDispatcher.ChunkRender chunkRender = this.func_181562_a(\u26038, \u260315, direction);
                    if (\u260311 && localRenderInformationContainer2.func_189560_a(direction.func_176734_d()) || \u260311 && \u260316 != null && !\u260315.func_178571_g().func_178495_a(\u260316.func_176734_d(), direction) || chunkRender == null || !chunkRender.func_217674_b() || !chunkRender.func_178577_a(n) || !clippingHelperImpl.func_228957_a_(chunkRender.field_178591_c)) continue;
                    LocalRenderInformationContainer \u260317 = new LocalRenderInformationContainer(chunkRender, direction, localRenderInformationContainer2.field_178032_d + 1);
                    \u260317.func_189561_a(localRenderInformationContainer2.field_178035_c, direction);
                    collection.add((ChunkRenderDispatcher.ChunkRender)((Object)\u260317));
                }
            }
            this.field_72777_q.func_213239_aq().func_76319_b();
        }
        this.field_72777_q.func_213239_aq().func_219895_b("rebuildNear");
        collection = this.field_175009_l;
        this.field_175009_l = Sets.newLinkedHashSet();
        for (LocalRenderInformationContainer localRenderInformationContainer3 : this.field_72755_R) {
            ChunkRenderDispatcher.ChunkRender chunkRender = localRenderInformationContainer3.field_178036_a;
            if (!chunkRender.func_178569_m() && !collection.contains(chunkRender)) continue;
            this.field_147595_R = true;
            BlockPos \u260318 = chunkRender.func_178568_j().func_177982_a(8, 8, 8);
            boolean bl3 = \u2603 = \u260318.func_177951_i(\u26035) < 768.0;
            if (chunkRender.func_188281_o() || \u2603) {
                this.field_72777_q.func_213239_aq().func_76320_a("build near");
                this.field_174995_M.func_228902_a_(chunkRender);
                chunkRender.func_188282_m();
                this.field_72777_q.func_213239_aq().func_76319_b();
                continue;
            }
            this.field_175009_l.add(chunkRender);
        }
        this.field_175009_l.addAll(collection);
        this.field_72777_q.func_213239_aq().func_76319_b();
    }

    private Set<Direction> func_174978_c(BlockPos blockPos) {
        VisGraph visGraph = new VisGraph();
        BlockPos \u26032 = new BlockPos(blockPos.func_177958_n() >> 4 << 4, blockPos.func_177956_o() >> 4 << 4, blockPos.func_177952_p() >> 4 << 4);
        Chunk \u26033 = this.field_72769_h.func_175726_f(\u26032);
        for (BlockPos blockPos2 : BlockPos.func_218278_a(\u26032, \u26032.func_177982_a(15, 15, 15))) {
            if (!\u26033.func_180495_p(blockPos2).func_200015_d(this.field_72769_h, blockPos2)) continue;
            visGraph.func_178606_a(blockPos2);
        }
        return visGraph.func_178609_b(blockPos);
    }

    @Nullable
    private ChunkRenderDispatcher.ChunkRender func_181562_a(BlockPos blockPos, ChunkRenderDispatcher.ChunkRender chunkRender, Direction direction) {
        BlockPos blockPos2 = chunkRender.func_181701_a(direction);
        if (MathHelper.func_76130_a(blockPos.func_177958_n() - blockPos2.func_177958_n()) > this.field_72739_F * 16) {
            return null;
        }
        if (blockPos2.func_177956_o() < 0 || blockPos2.func_177956_o() >= 256) {
            return null;
        }
        if (MathHelper.func_76130_a(blockPos.func_177952_p() - blockPos2.func_177952_p()) > this.field_72739_F * 16) {
            return null;
        }
        return this.field_175008_n.func_178161_a(blockPos2);
    }

    private void func_228419_a_(Matrix4f matrix4f, Matrix4f matrix4f2, double d, double d2, double d3, ClippingHelperImpl clippingHelperImpl) {
        this.field_175001_U = clippingHelperImpl;
        Matrix4f matrix4f3 = matrix4f2.func_226601_d_();
        matrix4f3.func_226595_a_(matrix4f);
        matrix4f3.func_226600_c_();
        this.field_175003_W.field_181059_a = d;
        this.field_175003_W.field_181060_b = d2;
        this.field_175003_W.field_181061_c = d3;
        this.field_175004_V[0] = new Vector4f(-1.0f, -1.0f, -1.0f, 1.0f);
        this.field_175004_V[1] = new Vector4f(1.0f, -1.0f, -1.0f, 1.0f);
        this.field_175004_V[2] = new Vector4f(1.0f, 1.0f, -1.0f, 1.0f);
        this.field_175004_V[3] = new Vector4f(-1.0f, 1.0f, -1.0f, 1.0f);
        this.field_175004_V[4] = new Vector4f(-1.0f, -1.0f, 1.0f, 1.0f);
        this.field_175004_V[5] = new Vector4f(1.0f, -1.0f, 1.0f, 1.0f);
        this.field_175004_V[6] = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.field_175004_V[7] = new Vector4f(-1.0f, 1.0f, 1.0f, 1.0f);
        for (int i = 0; i < 8; ++i) {
            this.field_175004_V[i].func_229372_a_(matrix4f3);
            this.field_175004_V[i].func_229375_f_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_228426_a_(MatrixStack matrixStack2, float f, long l, boolean bl, ActiveRenderInfo activeRenderInfo, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f matrix4f2) {
        MatrixStack matrixStack2;
        int \u260322;
        Object object2;
        ClippingHelperImpl \u26037;
        TileEntityRendererDispatcher.field_147556_a.func_217665_a(this.field_72769_h, this.field_72777_q.func_110434_K(), this.field_72777_q.field_71466_p, activeRenderInfo, this.field_72777_q.field_71476_x);
        this.field_175010_j.func_229088_a_(this.field_72769_h, activeRenderInfo, this.field_72777_q.field_147125_j);
        IProfiler iProfiler = this.field_72769_h.func_217381_Z();
        iProfiler.func_219895_b("light_updates");
        this.field_72777_q.field_71441_e.func_72863_F().func_212863_j_().func_215575_a(Integer.MAX_VALUE, true, true);
        Vec3d \u26032 = activeRenderInfo.func_216785_c();
        double \u26033 = \u26032.func_82615_a();
        double \u26034 = \u26032.func_82617_b();
        double \u26035 = \u26032.func_82616_c();
        Matrix4f \u26036 = matrixStack2.func_227866_c_().func_227870_a_();
        iProfiler.func_219895_b("culling");
        boolean bl2 = \u2603 = this.field_175001_U != null;
        if (\u2603) {
            \u26037 = this.field_175001_U;
            \u26037.func_228952_a_(this.field_175003_W.field_181059_a, this.field_175003_W.field_181060_b, this.field_175003_W.field_181061_c);
        } else {
            Matrix4f matrix4f2;
            \u26037 = new ClippingHelperImpl(\u26036, matrix4f2);
            \u26037.func_228952_a_(\u26033, \u26034, \u26035);
        }
        this.field_72777_q.func_213239_aq().func_219895_b("captureFrustum");
        if (this.field_175002_T) {
            this.func_228419_a_(\u26036, matrix4f2, \u26032.field_72450_a, \u26032.field_72448_b, \u26032.field_72449_c, \u2603 ? new ClippingHelperImpl(\u26036, matrix4f2) : \u26037);
            this.field_175002_T = false;
        }
        iProfiler.func_219895_b("clear");
        FogRenderer.func_228371_a_(activeRenderInfo, f, this.field_72777_q.field_71441_e, this.field_72777_q.field_71474_y.field_151451_c, gameRenderer.func_205002_d(f));
        RenderSystem.clear(16640, Minecraft.field_142025_a);
        float f2 = gameRenderer.func_205001_m();
        boolean bl3 = \u2603 = this.field_72777_q.field_71441_e.field_73011_w.func_76568_b(MathHelper.func_76128_c(\u26033), MathHelper.func_76128_c(\u26034)) || this.field_72777_q.field_71456_v.func_184046_j().func_184056_f();
        if (this.field_72777_q.field_71474_y.field_151451_c >= 4) {
            FogRenderer.func_228372_a_(activeRenderInfo, FogRenderer.FogType.FOG_SKY, f2, \u2603);
            iProfiler.func_219895_b("sky");
            this.func_228424_a_(matrixStack2, f);
        }
        iProfiler.func_219895_b("fog");
        FogRenderer.func_228372_a_(activeRenderInfo, FogRenderer.FogType.FOG_TERRAIN, Math.max(f2 - 16.0f, 32.0f), \u2603);
        iProfiler.func_219895_b("terrain_setup");
        this.func_228437_a_(activeRenderInfo, \u26037, \u2603, this.field_228409_ai_++, this.field_72777_q.field_71439_g.func_175149_v());
        iProfiler.func_219895_b("updatechunks");
        int \u26038 = 30;
        int \u26039 = this.field_72777_q.field_71474_y.field_74350_i;
        long \u260310 = 33333333L;
        long \u260311 = (double)\u26039 == AbstractOption.field_216701_h.func_216733_c() ? 0L : (long)(1000000000 / \u26039);
        long \u260312 = Util.func_211178_c() - l;
        long \u260313 = this.field_228416_y_.func_228732_a_(\u260312);
        long \u260314 = \u260313 * 3L / 2L;
        long \u260315 = MathHelper.func_226163_a_(\u260314, \u260311, 33333333L);
        this.func_174967_a(l + \u260315);
        iProfiler.func_219895_b("terrain");
        this.func_228441_a_(RenderType.func_228639_c_(), matrixStack2, \u26033, \u26034, \u26035);
        this.func_228441_a_(RenderType.func_228641_d_(), matrixStack2, \u26033, \u26034, \u26035);
        this.func_228441_a_(RenderType.func_228643_e_(), matrixStack2, \u26033, \u26034, \u26035);
        RenderHelper.func_227781_a_(matrixStack2.func_227866_c_().func_227870_a_());
        iProfiler.func_219895_b("entities");
        iProfiler.func_76320_a("prepare");
        this.field_72749_I = 0;
        this.field_72750_J = 0;
        iProfiler.func_219895_b("entities");
        if (this.func_174985_d()) {
            this.field_175015_z.func_216493_b(Minecraft.field_142025_a);
            this.field_72777_q.func_147110_a().func_147610_a(false);
        }
        boolean \u260316 = false;
        IRenderTypeBuffer.Impl \u260317 = this.field_228415_m_.func_228487_b_();
        for (Entity entity : this.field_72769_h.func_217416_b()) {
            if (!this.field_175010_j.func_229086_a_(entity, \u26037, \u26033, \u26034, \u26035) && !entity.func_184215_y(this.field_72777_q.field_71439_g) || entity == activeRenderInfo.func_216773_g() && !activeRenderInfo.func_216770_i() && (!(activeRenderInfo.func_216773_g() instanceof LivingEntity) || !((LivingEntity)activeRenderInfo.func_216773_g()).func_70608_bn()) || entity instanceof ClientPlayerEntity && activeRenderInfo.func_216773_g() != entity) continue;
            ++this.field_72749_I;
            if (entity.field_70173_aa == 0) {
                entity.field_70142_S = entity.func_226277_ct_();
                entity.field_70137_T = entity.func_226278_cu_();
                entity.field_70136_U = entity.func_226281_cx_();
            }
            if (this.func_174985_d() && entity.func_225510_bt_()) {
                \u260316 = true;
                object2 = \u2603 = this.field_228415_m_.func_228490_d_();
                int \u260318 = entity.func_226263_P_();
                int \u260319 = 255;
                int \u260320 = \u260318 >> 16 & 0xFF;
                int \u260321 = \u260318 >> 8 & 0xFF;
                \u260322 = \u260318 & 0xFF;
                ((OutlineLayerBuffer)\u2603).func_228472_a_(\u260320, \u260321, \u260322, 255);
            } else {
                object2 = \u260317;
            }
            this.func_228418_a_(entity, \u26033, \u26034, \u26035, f, matrixStack2, (IRenderTypeBuffer)object2);
        }
        this.func_228423_a_(matrixStack2);
        \u260317.func_228462_a_(RenderType.func_228634_a_(AtlasTexture.field_110575_b));
        \u260317.func_228462_a_(RenderType.func_228638_b_(AtlasTexture.field_110575_b));
        \u260317.func_228462_a_(RenderType.func_228640_c_(AtlasTexture.field_110575_b));
        \u260317.func_228462_a_(RenderType.func_228646_f_(AtlasTexture.field_110575_b));
        iProfiler.func_219895_b("blockentities");
        for (LocalRenderInformationContainer localRenderInformationContainer : this.field_72755_R) {
            object2 = localRenderInformationContainer.field_178036_a.func_178571_g().func_178485_b();
            if (object2.isEmpty()) continue;
            \u2603 = object2.iterator();
            while (\u2603.hasNext()) {
                TileEntity \u260323 = (TileEntity)\u2603.next();
                BlockPos \u260324 = \u260323.func_174877_v();
                IRenderTypeBuffer \u260325 = \u260317;
                matrixStack2.func_227860_a_();
                matrixStack2.func_227861_a_((double)\u260324.func_177958_n() - \u26033, (double)\u260324.func_177956_o() - \u26034, (double)\u260324.func_177952_p() - \u26035);
                SortedSet \u260326 = (SortedSet)this.field_228407_B_.get(\u260324.func_218275_a());
                if (\u260326 != null && !\u260326.isEmpty() && (\u260322 = ((DestroyBlockProgress)\u260326.last()).func_73106_e()) >= 0) {
                    \u2603 = new MatrixApplyingVertexBuilder(this.field_228415_m_.func_228489_c_().getBuffer(ModelBakery.field_229320_k_.get(\u260322)), matrixStack2.func_227866_c_());
                    \u260325 = arg_0 -> WorldRenderer.func_230014_a_(\u260317, (IVertexBuilder)\u2603, arg_0);
                }
                TileEntityRendererDispatcher.field_147556_a.func_228850_a_(\u260323, f, matrixStack2, \u260325);
                matrixStack2.func_227865_b_();
            }
        }
        Set<TileEntity> set = this.field_181024_n;
        synchronized (set) {
            for (Object object2 : this.field_181024_n) {
                \u2603 = ((TileEntity)object2).func_174877_v();
                matrixStack2.func_227860_a_();
                matrixStack2.func_227861_a_((double)((Vec3i)\u2603).func_177958_n() - \u26033, (double)((Vec3i)\u2603).func_177956_o() - \u26034, (double)((Vec3i)\u2603).func_177952_p() - \u26035);
                TileEntityRendererDispatcher.field_147556_a.func_228850_a_(object2, f, matrixStack2, \u260317);
                matrixStack2.func_227865_b_();
            }
        }
        this.func_228423_a_(matrixStack2);
        \u260317.func_228462_a_(RenderType.func_228639_c_());
        \u260317.func_228462_a_(Atlases.func_228782_g_());
        \u260317.func_228462_a_(Atlases.func_228783_h_());
        \u260317.func_228462_a_(Atlases.func_228778_c_());
        \u260317.func_228462_a_(Atlases.func_228779_d_());
        \u260317.func_228462_a_(Atlases.func_228780_e_());
        \u260317.func_228462_a_(Atlases.func_228781_f_());
        this.field_228415_m_.func_228490_d_().func_228471_a_();
        if (\u260316) {
            this.field_174991_A.func_148018_a(f);
            this.field_72777_q.func_147110_a().func_147610_a(false);
        }
        iProfiler.func_219895_b("destroyProgress");
        for (Long2ObjectMap.Entry entry : this.field_228407_B_.long2ObjectEntrySet()) {
            object2 = BlockPos.func_218283_e(entry.getLongKey());
            double d = (double)((Vec3i)object2).func_177958_n() - \u26033;
            if (d * d + (\u2603 = (double)((Vec3i)object2).func_177956_o() - \u26034) * \u2603 + (\u2603 = (double)((Vec3i)object2).func_177952_p() - \u26035) * \u2603 > 1024.0 || (\u2603 = (SortedSet)entry.getValue()) == null || \u2603.isEmpty()) continue;
            int \u260327 = ((DestroyBlockProgress)\u2603.last()).func_73106_e();
            matrixStack2.func_227860_a_();
            matrixStack2.func_227861_a_((double)((Vec3i)object2).func_177958_n() - \u26033, (double)((Vec3i)object2).func_177956_o() - \u26034, (double)((Vec3i)object2).func_177952_p() - \u26035);
            MatrixApplyingVertexBuilder \u260328 = new MatrixApplyingVertexBuilder(this.field_228415_m_.func_228489_c_().getBuffer(ModelBakery.field_229320_k_.get(\u260327)), matrixStack2.func_227866_c_());
            this.field_72777_q.func_175602_ab().func_228792_a_(this.field_72769_h.func_180495_p((BlockPos)object2), (BlockPos)object2, this.field_72769_h, matrixStack2, \u260328);
            matrixStack2.func_227865_b_();
        }
        this.func_228423_a_(matrixStack2);
        iProfiler.func_76319_b();
        RayTraceResult rayTraceResult = this.field_72777_q.field_71476_x;
        if (bl && rayTraceResult != null && rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            iProfiler.func_219895_b("outline");
            BlockPos blockPos = ((BlockRayTraceResult)rayTraceResult).func_216350_a();
            object2 = this.field_72769_h.func_180495_p(blockPos);
            if (!((BlockState)object2).func_196958_f() && this.field_72769_h.func_175723_af().func_177746_a(blockPos)) {
                IVertexBuilder iVertexBuilder = \u260317.getBuffer(RenderType.func_228659_m_());
                this.func_228429_a_(matrixStack2, iVertexBuilder, activeRenderInfo.func_216773_g(), \u26033, \u26034, \u26035, blockPos, (BlockState)object2);
            }
        }
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix(matrixStack2.func_227866_c_().func_227870_a_());
        this.field_72777_q.field_184132_p.func_229019_a_(matrixStack2, \u260317, \u26033, \u26034, \u26035);
        this.func_228447_c_(activeRenderInfo);
        RenderSystem.popMatrix();
        \u260317.func_228462_a_(Atlases.func_228784_i_());
        \u260317.func_228462_a_(Atlases.func_228768_a_());
        \u260317.func_228462_a_(Atlases.func_228776_b_());
        \u260317.func_228462_a_(RenderType.func_228653_j_());
        \u260317.func_228462_a_(RenderType.func_228655_k_());
        \u260317.func_228462_a_(RenderType.func_228651_i_());
        this.field_228415_m_.func_228489_c_().func_228461_a_();
        \u260317.func_228462_a_(RenderType.func_228659_m_());
        \u260317.func_228461_a_();
        iProfiler.func_219895_b("translucent");
        this.func_228441_a_(RenderType.func_228645_f_(), matrixStack2, \u26033, \u26034, \u26035);
        iProfiler.func_219895_b("particles");
        this.field_72777_q.field_71452_i.func_228345_a_(matrixStack2, \u260317, lightTexture, activeRenderInfo, f);
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix(matrixStack2.func_227866_c_().func_227870_a_());
        iProfiler.func_219895_b("cloudsLayers");
        if (this.field_72777_q.field_71474_y.func_216842_e() != CloudOption.OFF) {
            iProfiler.func_219895_b("clouds");
            this.func_228425_a_(matrixStack2, f, \u26033, \u26034, \u26035);
        }
        RenderSystem.depthMask(false);
        iProfiler.func_219895_b("weather");
        this.func_228438_a_(lightTexture, f, \u26033, \u26034, \u26035);
        RenderSystem.depthMask(true);
        this.func_228446_b_(activeRenderInfo);
        RenderSystem.shadeModel(7424);
        RenderSystem.depthMask(true);
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        FogRenderer.func_228370_a_();
    }

    private void func_228423_a_(MatrixStack matrixStack) {
        if (!matrixStack.func_227867_d_()) {
            throw new IllegalStateException("Pose stack not empty");
        }
    }

    private void func_228418_a_(Entity entity, double d, double d2, double d3, float f, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer) {
        double d4 = MathHelper.func_219803_d(f, entity.field_70142_S, entity.func_226277_ct_());
        \u2603 = MathHelper.func_219803_d(f, entity.field_70137_T, entity.func_226278_cu_());
        \u2603 = MathHelper.func_219803_d(f, entity.field_70136_U, entity.func_226281_cx_());
        float \u26032 = MathHelper.func_219799_g(f, entity.field_70126_B, entity.field_70177_z);
        this.field_175010_j.func_229084_a_(entity, d4 - d, \u2603 - d2, \u2603 - d3, \u26032, f, matrixStack, iRenderTypeBuffer, this.field_175010_j.func_229085_a_(entity, f));
    }

    private void func_228441_a_(RenderType renderType2, MatrixStack matrixStack, double d, double d2, double d3) {
        RenderType renderType2;
        renderType2.func_228547_a_();
        if (renderType2 == RenderType.func_228645_f_()) {
            this.field_72777_q.func_213239_aq().func_76320_a("translucent_sort");
            \u2603 = d - this.field_147596_f;
            \u2603 = d2 - this.field_147597_g;
            \u2603 = d3 - this.field_147602_h;
            if (\u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603 > 1.0) {
                this.field_147596_f = d;
                this.field_147597_g = d2;
                this.field_147602_h = d3;
                int n = 0;
                for (LocalRenderInformationContainer localRenderInformationContainer : this.field_72755_R) {
                    if (n >= 15 || !localRenderInformationContainer.field_178036_a.func_228925_a_(renderType2, this.field_174995_M)) continue;
                    ++n;
                }
            }
            this.field_72777_q.func_213239_aq().func_76319_b();
        }
        this.field_72777_q.func_213239_aq().func_76320_a("filterempty");
        this.field_72777_q.func_213239_aq().func_194339_b(() -> "render_" + renderType2);
        boolean \u26032 = renderType2 != RenderType.func_228645_f_();
        ObjectListIterator \u26033 = this.field_72755_R.listIterator(\u26032 ? 0 : this.field_72755_R.size());
        while (\u26032 ? \u26033.hasNext() : \u26033.hasPrevious()) {
            LocalRenderInformationContainer localRenderInformationContainer = \u26032 ? (LocalRenderInformationContainer)\u26033.next() : (LocalRenderInformationContainer)\u26033.previous();
            ChunkRenderDispatcher.ChunkRender \u26034 = localRenderInformationContainer.field_178036_a;
            if (\u26034.func_178571_g().func_228912_a_(renderType2)) continue;
            VertexBuffer \u26035 = \u26034.func_228924_a_(renderType2);
            matrixStack.func_227860_a_();
            BlockPos \u26036 = \u26034.func_178568_j();
            matrixStack.func_227861_a_((double)\u26036.func_177958_n() - d, (double)\u26036.func_177956_o() - d2, (double)\u26036.func_177952_p() - d3);
            \u26035.func_177359_a();
            this.field_228408_W_.func_227892_a_(0L);
            \u26035.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            matrixStack.func_227865_b_();
        }
        VertexBuffer.func_177361_b();
        RenderSystem.clearCurrentColor();
        this.field_228408_W_.func_227895_d_();
        this.field_72777_q.func_213239_aq().func_76319_b();
        renderType2.func_228549_b_();
    }

    private void func_228446_b_(ActiveRenderInfo activeRenderInfo2) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        if (this.field_72777_q.field_228004_B_ || this.field_72777_q.field_228005_C_) {
            double d = activeRenderInfo2.func_216785_c().func_82615_a();
            \u2603 = activeRenderInfo2.func_216785_c().func_82617_b();
            \u2603 = activeRenderInfo2.func_216785_c().func_82616_c();
            RenderSystem.depthMask(true);
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableTexture();
            for (LocalRenderInformationContainer localRenderInformationContainer : this.field_72755_R) {
                ChunkRenderDispatcher.ChunkRender chunkRender = localRenderInformationContainer.field_178036_a;
                RenderSystem.pushMatrix();
                BlockPos \u26033 = chunkRender.func_178568_j();
                RenderSystem.translated((double)\u26033.func_177958_n() - d, (double)\u26033.func_177956_o() - \u2603, (double)\u26033.func_177952_p() - \u2603);
                if (this.field_72777_q.field_228004_B_) {
                    \u26032.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                    RenderSystem.lineWidth(10.0f);
                    int n = localRenderInformationContainer.field_178032_d == 0 ? 0 : MathHelper.func_181758_c((float)localRenderInformationContainer.field_178032_d / 50.0f, 0.9f, 0.9f);
                    \u2603 = n >> 16 & 0xFF;
                    \u2603 = n >> 8 & 0xFF;
                    \u2603 = n & 0xFF;
                    Direction \u26034 = localRenderInformationContainer.field_178034_b;
                    if (\u26034 != null) {
                        \u26032.func_225582_a_(8.0, 8.0, 8.0).func_225586_a_(\u2603, \u2603, \u2603, 255).func_181675_d();
                        \u26032.func_225582_a_(8 - 16 * \u26034.func_82601_c(), 8 - 16 * \u26034.func_96559_d(), 8 - 16 * \u26034.func_82599_e()).func_225586_a_(\u2603, \u2603, \u2603, 255).func_181675_d();
                    }
                    tessellator.func_78381_a();
                    RenderSystem.lineWidth(1.0f);
                }
                if (this.field_72777_q.field_228005_C_ && !chunkRender.func_178571_g().func_178489_a()) {
                    \u26032.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                    RenderSystem.lineWidth(10.0f);
                    n = 0;
                    for (Direction \u26034 : Direction.values()) {
                        for (Direction direction : Direction.values()) {
                            boolean bl = chunkRender.func_178571_g().func_178495_a(\u26034, direction);
                            if (bl) continue;
                            ++n;
                            \u26032.func_225582_a_(8 + 8 * \u26034.func_82601_c(), 8 + 8 * \u26034.func_96559_d(), 8 + 8 * \u26034.func_82599_e()).func_225586_a_(1, 0, 0, 1).func_181675_d();
                            \u26032.func_225582_a_(8 + 8 * direction.func_82601_c(), 8 + 8 * direction.func_96559_d(), 8 + 8 * direction.func_82599_e()).func_225586_a_(1, 0, 0, 1).func_181675_d();
                        }
                    }
                    tessellator.func_78381_a();
                    RenderSystem.lineWidth(1.0f);
                    if (n > 0) {
                        \u26032.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                        float f = 0.5f;
                        \u2603 = 0.2f;
                        \u26032.func_225582_a_(0.5, 15.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(15.5, 15.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(15.5, 15.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(0.5, 15.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(0.5, 0.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(15.5, 0.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(15.5, 0.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(0.5, 0.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(0.5, 15.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(0.5, 15.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(0.5, 0.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(0.5, 0.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(15.5, 0.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(15.5, 0.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(15.5, 15.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(15.5, 15.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(0.5, 0.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(15.5, 0.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(15.5, 15.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(0.5, 15.5, 0.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(0.5, 15.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(15.5, 15.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(15.5, 0.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        \u26032.func_225582_a_(0.5, 0.5, 15.5).func_227885_a_(0.9f, 0.9f, 0.0f, 0.2f).func_181675_d();
                        tessellator.func_78381_a();
                    }
                }
                RenderSystem.popMatrix();
            }
            RenderSystem.depthMask(true);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.enableTexture();
        }
        if (this.field_175001_U != null) {
            ActiveRenderInfo activeRenderInfo2;
            RenderSystem.disableCull();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.lineWidth(10.0f);
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(this.field_175003_W.field_181059_a - activeRenderInfo2.func_216785_c().field_72450_a), (float)(this.field_175003_W.field_181060_b - activeRenderInfo2.func_216785_c().field_72448_b), (float)(this.field_175003_W.field_181061_c - activeRenderInfo2.func_216785_c().field_72449_c));
            RenderSystem.depthMask(true);
            \u26032.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            this.func_228434_a_(\u26032, 0, 1, 2, 3, 0, 1, 1);
            this.func_228434_a_(\u26032, 4, 5, 6, 7, 1, 0, 0);
            this.func_228434_a_(\u26032, 0, 1, 5, 4, 1, 1, 0);
            this.func_228434_a_(\u26032, 2, 3, 7, 6, 0, 0, 1);
            this.func_228434_a_(\u26032, 0, 4, 7, 3, 0, 1, 0);
            this.func_228434_a_(\u26032, 1, 5, 6, 2, 1, 0, 1);
            tessellator.func_78381_a();
            RenderSystem.depthMask(false);
            \u26032.func_181668_a(1, DefaultVertexFormats.field_181705_e);
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.func_228433_a_(\u26032, 0);
            this.func_228433_a_(\u26032, 1);
            this.func_228433_a_(\u26032, 1);
            this.func_228433_a_(\u26032, 2);
            this.func_228433_a_(\u26032, 2);
            this.func_228433_a_(\u26032, 3);
            this.func_228433_a_(\u26032, 3);
            this.func_228433_a_(\u26032, 0);
            this.func_228433_a_(\u26032, 4);
            this.func_228433_a_(\u26032, 5);
            this.func_228433_a_(\u26032, 5);
            this.func_228433_a_(\u26032, 6);
            this.func_228433_a_(\u26032, 6);
            this.func_228433_a_(\u26032, 7);
            this.func_228433_a_(\u26032, 7);
            this.func_228433_a_(\u26032, 4);
            this.func_228433_a_(\u26032, 0);
            this.func_228433_a_(\u26032, 4);
            this.func_228433_a_(\u26032, 1);
            this.func_228433_a_(\u26032, 5);
            this.func_228433_a_(\u26032, 2);
            this.func_228433_a_(\u26032, 6);
            this.func_228433_a_(\u26032, 3);
            this.func_228433_a_(\u26032, 7);
            tessellator.func_78381_a();
            RenderSystem.popMatrix();
            RenderSystem.depthMask(true);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.enableTexture();
            RenderSystem.lineWidth(1.0f);
        }
    }

    private void func_228433_a_(IVertexBuilder iVertexBuilder, int n) {
        iVertexBuilder.func_225582_a_(this.field_175004_V[n].func_195910_a(), this.field_175004_V[n].func_195913_b(), this.field_175004_V[n].func_195914_c()).func_181675_d();
    }

    private void func_228434_a_(IVertexBuilder iVertexBuilder, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f = 0.25f;
        iVertexBuilder.func_225582_a_(this.field_175004_V[n].func_195910_a(), this.field_175004_V[n].func_195913_b(), this.field_175004_V[n].func_195914_c()).func_227885_a_(n5, n6, n7, 0.25f).func_181675_d();
        iVertexBuilder.func_225582_a_(this.field_175004_V[n2].func_195910_a(), this.field_175004_V[n2].func_195913_b(), this.field_175004_V[n2].func_195914_c()).func_227885_a_(n5, n6, n7, 0.25f).func_181675_d();
        iVertexBuilder.func_225582_a_(this.field_175004_V[n3].func_195910_a(), this.field_175004_V[n3].func_195913_b(), this.field_175004_V[n3].func_195914_c()).func_227885_a_(n5, n6, n7, 0.25f).func_181675_d();
        iVertexBuilder.func_225582_a_(this.field_175004_V[n4].func_195910_a(), this.field_175004_V[n4].func_195913_b(), this.field_175004_V[n4].func_195914_c()).func_227885_a_(n5, n6, n7, 0.25f).func_181675_d();
    }

    public void func_72734_e() {
        ++this.field_72773_u;
        if (this.field_72773_u % 20 != 0) {
            return;
        }
        ObjectIterator objectIterator = this.field_72738_E.values().iterator();
        while (objectIterator.hasNext()) {
            DestroyBlockProgress destroyBlockProgress = (DestroyBlockProgress)objectIterator.next();
            int \u26032 = destroyBlockProgress.func_82743_f();
            if (this.field_72773_u - \u26032 <= 400) continue;
            objectIterator.remove();
            this.func_228442_a_(destroyBlockProgress);
        }
    }

    private void func_228442_a_(DestroyBlockProgress destroyBlockProgress) {
        long l = destroyBlockProgress.func_180246_b().func_218275_a();
        Set \u26032 = (Set)this.field_228407_B_.get(l);
        \u26032.remove(destroyBlockProgress);
        if (\u26032.isEmpty()) {
            this.field_228407_B_.remove(l);
        }
    }

    private void func_228444_b_(MatrixStack matrixStack) {
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask(false);
        this.field_72770_i.func_110577_a(field_110926_k);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        for (int i = 0; i < 6; ++i) {
            matrixStack.func_227860_a_();
            if (i == 1) {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            }
            if (i == 2) {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            }
            if (i == 3) {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            }
            if (i == 4) {
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            }
            if (i == 5) {
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
            }
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            \u26032.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            \u26032.func_227888_a_(matrix4f, -100.0f, -100.0f, -100.0f).func_225583_a_(0.0f, 0.0f).func_225586_a_(40, 40, 40, 255).func_181675_d();
            \u26032.func_227888_a_(matrix4f, -100.0f, -100.0f, 100.0f).func_225583_a_(0.0f, 16.0f).func_225586_a_(40, 40, 40, 255).func_181675_d();
            \u26032.func_227888_a_(matrix4f, 100.0f, -100.0f, 100.0f).func_225583_a_(16.0f, 16.0f).func_225586_a_(40, 40, 40, 255).func_181675_d();
            \u26032.func_227888_a_(matrix4f, 100.0f, -100.0f, -100.0f).func_225583_a_(16.0f, 0.0f).func_225586_a_(40, 40, 40, 255).func_181675_d();
            tessellator.func_78381_a();
            matrixStack.func_227865_b_();
        }
        RenderSystem.depthMask(true);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }

    public void func_228424_a_(MatrixStack matrixStack2, float f) {
        MatrixStack matrixStack2;
        float \u260315;
        int \u26038;
        float \u26039;
        if (this.field_72777_q.field_71441_e.field_73011_w.func_186058_p() == DimensionType.field_223229_c_) {
            this.func_228444_b_(matrixStack2);
            return;
        }
        if (!this.field_72777_q.field_71441_e.field_73011_w.func_76569_d()) {
            return;
        }
        RenderSystem.disableTexture();
        Vec3d vec3d = this.field_72769_h.func_228318_a_(this.field_72777_q.field_71460_t.func_215316_n().func_216780_d(), f);
        float \u26032 = (float)vec3d.field_72450_a;
        float \u26033 = (float)vec3d.field_72448_b;
        float \u26034 = (float)vec3d.field_72449_c;
        FogRenderer.func_228373_b_();
        BufferBuilder \u26035 = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.depthMask(false);
        RenderSystem.enableFog();
        RenderSystem.color3f(\u26032, \u26033, \u26034);
        this.field_175012_t.func_177359_a();
        this.field_175014_r.func_227892_a_(0L);
        this.field_175012_t.func_227874_a_(matrixStack2.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        this.field_175014_r.func_227895_d_();
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] \u26036 = this.field_72769_h.field_73011_w.func_76560_a(this.field_72769_h.func_72826_c(f), f);
        if (\u26036 != null) {
            RenderSystem.disableTexture();
            RenderSystem.shadeModel(7425);
            matrixStack2.func_227860_a_();
            matrixStack2.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            \u26039 = MathHelper.func_76126_a(this.field_72769_h.func_72929_e(f)) < 0.0f ? 180.0f : 0.0f;
            matrixStack2.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(\u26039));
            matrixStack2.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            \u2603 = \u26036[0];
            \u260311 = \u26036[1];
            \u2603 = \u26036[2];
            Matrix4f \u26037 = matrixStack2.func_227866_c_().func_227870_a_();
            \u26035.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            \u26035.func_227888_a_(\u26037, 0.0f, 100.0f, 0.0f).func_227885_a_(\u2603, \u260311, \u2603, \u26036[3]).func_181675_d();
            \u26038 = 16;
            for (int i = 0; i <= 16; ++i) {
                \u260315 = (float)i * ((float)Math.PI * 2) / 16.0f;
                \u260316 = MathHelper.func_76126_a(\u260315);
                \u260317 = MathHelper.func_76134_b(\u260315);
                \u26035.func_227888_a_(\u26037, \u260316 * 120.0f, \u260317 * 120.0f, -\u260317 * 40.0f * \u26036[3]).func_227885_a_(\u26036[0], \u26036[1], \u26036[2], 0.0f).func_181675_d();
            }
            \u26035.func_178977_d();
            WorldVertexBufferUploader.func_181679_a(\u26035);
            matrixStack2.func_227865_b_();
            RenderSystem.shadeModel(7424);
        }
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        matrixStack2.func_227860_a_();
        \u26039 = 1.0f - this.field_72769_h.func_72867_j(f);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, \u26039);
        matrixStack2.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStack2.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(this.field_72769_h.func_72826_c(f) * 360.0f));
        Matrix4f \u260310 = matrixStack2.func_227866_c_().func_227870_a_();
        float \u260311 = 30.0f;
        this.field_72770_i.func_110577_a(field_110928_i);
        \u26035.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        \u26035.func_227888_a_(\u260310, -\u260311, 100.0f, -\u260311).func_225583_a_(0.0f, 0.0f).func_181675_d();
        \u26035.func_227888_a_(\u260310, \u260311, 100.0f, -\u260311).func_225583_a_(1.0f, 0.0f).func_181675_d();
        \u26035.func_227888_a_(\u260310, \u260311, 100.0f, \u260311).func_225583_a_(1.0f, 1.0f).func_181675_d();
        \u26035.func_227888_a_(\u260310, -\u260311, 100.0f, \u260311).func_225583_a_(0.0f, 1.0f).func_181675_d();
        \u26035.func_178977_d();
        WorldVertexBufferUploader.func_181679_a(\u26035);
        \u260311 = 20.0f;
        this.field_72770_i.func_110577_a(field_110927_h);
        int \u260312 = this.field_72769_h.func_72853_d();
        int \u260313 = \u260312 % 4;
        \u26038 = \u260312 / 4 % 2;
        float \u260314 = (float)(\u260313 + 0) / 4.0f;
        \u260315 = (float)(\u26038 + 0) / 2.0f;
        float \u260316 = (float)(\u260313 + 1) / 4.0f;
        float \u260317 = (float)(\u26038 + 1) / 2.0f;
        \u26035.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        \u26035.func_227888_a_(\u260310, -\u260311, -100.0f, \u260311).func_225583_a_(\u260316, \u260317).func_181675_d();
        \u26035.func_227888_a_(\u260310, \u260311, -100.0f, \u260311).func_225583_a_(\u260314, \u260317).func_181675_d();
        \u26035.func_227888_a_(\u260310, \u260311, -100.0f, -\u260311).func_225583_a_(\u260314, \u260315).func_181675_d();
        \u26035.func_227888_a_(\u260310, -\u260311, -100.0f, -\u260311).func_225583_a_(\u260316, \u260315).func_181675_d();
        \u26035.func_178977_d();
        WorldVertexBufferUploader.func_181679_a(\u26035);
        RenderSystem.disableTexture();
        float \u260318 = this.field_72769_h.func_228330_j_(f) * \u26039;
        if (\u260318 > 0.0f) {
            RenderSystem.color4f(\u260318, \u260318, \u260318, \u260318);
            this.field_175013_s.func_177359_a();
            this.field_175014_r.func_227892_a_(0L);
            this.field_175013_s.func_227874_a_(matrixStack2.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.field_175014_r.func_227895_d_();
        }
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        matrixStack2.func_227865_b_();
        RenderSystem.disableTexture();
        RenderSystem.color3f(0.0f, 0.0f, 0.0f);
        double \u260319 = this.field_72777_q.field_71439_g.func_174824_e((float)f).field_72448_b - this.field_72769_h.func_228331_m_();
        if (\u260319 < 0.0) {
            matrixStack2.func_227860_a_();
            matrixStack2.func_227861_a_(0.0, 12.0, 0.0);
            this.field_175011_u.func_177359_a();
            this.field_175014_r.func_227892_a_(0L);
            this.field_175011_u.func_227874_a_(matrixStack2.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.field_175014_r.func_227895_d_();
            matrixStack2.func_227865_b_();
        }
        if (this.field_72769_h.field_73011_w.func_76561_g()) {
            RenderSystem.color3f(\u26032 * 0.2f + 0.04f, \u26033 * 0.2f + 0.04f, \u26034 * 0.6f + 0.1f);
        } else {
            RenderSystem.color3f(\u26032, \u26033, \u26034);
        }
        RenderSystem.enableTexture();
        RenderSystem.depthMask(true);
        RenderSystem.disableFog();
    }

    public void func_228425_a_(MatrixStack matrixStack2, float f, double d, double d2, double d3) {
        MatrixStack matrixStack2;
        if (!this.field_72777_q.field_71441_e.field_73011_w.func_76569_d()) {
            return;
        }
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableDepthTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableFog();
        float f2 = 12.0f;
        \u2603 = 4.0f;
        double \u26032 = 2.0E-4;
        double \u26033 = ((float)this.field_72773_u + f) * 0.03f;
        double \u26034 = (d + \u26033) / 12.0;
        double \u26035 = this.field_72769_h.field_73011_w.func_76571_f() - (float)d2 + 0.33f;
        double \u26036 = d3 / 12.0 + (double)0.33f;
        \u26034 -= (double)(MathHelper.func_76128_c(\u26034 / 2048.0) * 2048);
        \u26036 -= (double)(MathHelper.func_76128_c(\u26036 / 2048.0) * 2048);
        \u2603 = (float)(\u26034 - (double)MathHelper.func_76128_c(\u26034));
        \u2603 = (float)(\u26035 / 4.0 - (double)MathHelper.func_76128_c(\u26035 / 4.0)) * 4.0f;
        \u2603 = (float)(\u26036 - (double)MathHelper.func_76128_c(\u26036));
        Vec3d \u26037 = this.field_72769_h.func_228328_h_(f);
        int \u26038 = (int)Math.floor(\u26034);
        int \u26039 = (int)Math.floor(\u26035 / 4.0);
        int \u260310 = (int)Math.floor(\u26036);
        if (\u26038 != this.field_204602_S || \u26039 != this.field_204603_T || \u260310 != this.field_204604_U || this.field_72777_q.field_71474_y.func_216842_e() != this.field_204800_W || this.field_204605_V.func_72436_e(\u26037) > 2.0E-4) {
            this.field_204602_S = \u26038;
            this.field_204603_T = \u26039;
            this.field_204604_U = \u260310;
            this.field_204605_V = \u26037;
            this.field_204800_W = this.field_72777_q.field_71474_y.func_216842_e();
            this.field_204607_y = true;
        }
        if (this.field_204607_y) {
            this.field_204607_y = false;
            BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
            if (this.field_204601_A != null) {
                this.field_204601_A.close();
            }
            this.field_204601_A = new VertexBuffer(DefaultVertexFormats.field_181712_l);
            this.func_204600_a(bufferBuilder, \u26034, \u26035, \u26036, \u26037);
            bufferBuilder.func_178977_d();
            this.field_204601_A.func_227875_a_(bufferBuilder);
        }
        this.field_72770_i.func_110577_a(field_110925_j);
        matrixStack2.func_227860_a_();
        matrixStack2.func_227862_a_(12.0f, 1.0f, 12.0f);
        matrixStack2.func_227861_a_(-\u2603, \u2603, -\u2603);
        if (this.field_204601_A != null) {
            this.field_204601_A.func_177359_a();
            DefaultVertexFormats.field_181712_l.func_227892_a_(0L);
            for (int i = \u2603 = this.field_204800_W == CloudOption.FANCY ? 0 : 1; i < 2; ++i) {
                if (i == 0) {
                    RenderSystem.colorMask(false, false, false, false);
                } else {
                    RenderSystem.colorMask(true, true, true, true);
                }
                this.field_204601_A.func_227874_a_(matrixStack2.func_227866_c_().func_227870_a_(), 7);
            }
            VertexBuffer.func_177361_b();
            DefaultVertexFormats.field_181712_l.func_227895_d_();
        }
        matrixStack2.func_227865_b_();
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableAlphaTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.disableFog();
    }

    private void func_204600_a(BufferBuilder bufferBuilder, double d, double d2, double d3, Vec3d vec3d) {
        float f = 4.0f;
        \u2603 = 0.00390625f;
        int \u26032 = 8;
        int \u26033 = 4;
        \u2603 = 9.765625E-4f;
        \u2603 = (float)MathHelper.func_76128_c(d) * 0.00390625f;
        \u2603 = (float)MathHelper.func_76128_c(d3) * 0.00390625f;
        \u2603 = (float)vec3d.field_72450_a;
        \u2603 = (float)vec3d.field_72448_b;
        \u2603 = (float)vec3d.field_72449_c;
        \u2603 = \u2603 * 0.9f;
        \u2603 = \u2603 * 0.9f;
        \u2603 = \u2603 * 0.9f;
        \u2603 = \u2603 * 0.7f;
        \u2603 = \u2603 * 0.7f;
        \u2603 = \u2603 * 0.7f;
        \u2603 = \u2603 * 0.8f;
        \u2603 = \u2603 * 0.8f;
        \u2603 = \u2603 * 0.8f;
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        \u2603 = (float)Math.floor(d2 / 4.0) * 4.0f;
        if (this.field_204800_W == CloudOption.FANCY) {
            for (int i = -3; i <= 4; ++i) {
                for (\u2603 = -3; \u2603 <= 4; ++\u2603) {
                    float f2 = i * 8;
                    \u2603 = \u2603 * 8;
                    if (\u2603 > -5.0f) {
                        bufferBuilder.func_225582_a_(f2 + 0.0f, \u2603 + 0.0f, \u2603 + 8.0f).func_225583_a_((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                        bufferBuilder.func_225582_a_(f2 + 8.0f, \u2603 + 0.0f, \u2603 + 8.0f).func_225583_a_((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                        bufferBuilder.func_225582_a_(f2 + 8.0f, \u2603 + 0.0f, \u2603 + 0.0f).func_225583_a_((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                        bufferBuilder.func_225582_a_(f2 + 0.0f, \u2603 + 0.0f, \u2603 + 0.0f).func_225583_a_((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                    }
                    if (\u2603 <= 5.0f) {
                        bufferBuilder.func_225582_a_(f2 + 0.0f, \u2603 + 4.0f - 9.765625E-4f, \u2603 + 8.0f).func_225583_a_((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
                        bufferBuilder.func_225582_a_(f2 + 8.0f, \u2603 + 4.0f - 9.765625E-4f, \u2603 + 8.0f).func_225583_a_((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
                        bufferBuilder.func_225582_a_(f2 + 8.0f, \u2603 + 4.0f - 9.765625E-4f, \u2603 + 0.0f).func_225583_a_((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
                        bufferBuilder.func_225582_a_(f2 + 0.0f, \u2603 + 4.0f - 9.765625E-4f, \u2603 + 0.0f).func_225583_a_((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
                    }
                    if (i > -1) {
                        for (int j = 0; j < 8; ++j) {
                            bufferBuilder.func_225582_a_(f2 + (float)j + 0.0f, \u2603 + 0.0f, \u2603 + 8.0f).func_225583_a_((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferBuilder.func_225582_a_(f2 + (float)j + 0.0f, \u2603 + 4.0f, \u2603 + 8.0f).func_225583_a_((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferBuilder.func_225582_a_(f2 + (float)j + 0.0f, \u2603 + 4.0f, \u2603 + 0.0f).func_225583_a_((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferBuilder.func_225582_a_(f2 + (float)j + 0.0f, \u2603 + 0.0f, \u2603 + 0.0f).func_225583_a_((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
                        }
                    }
                    if (i <= 1) {
                        for (j = 0; j < 8; ++j) {
                            bufferBuilder.func_225582_a_(f2 + (float)j + 1.0f - 9.765625E-4f, \u2603 + 0.0f, \u2603 + 8.0f).func_225583_a_((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferBuilder.func_225582_a_(f2 + (float)j + 1.0f - 9.765625E-4f, \u2603 + 4.0f, \u2603 + 8.0f).func_225583_a_((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferBuilder.func_225582_a_(f2 + (float)j + 1.0f - 9.765625E-4f, \u2603 + 4.0f, \u2603 + 0.0f).func_225583_a_((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferBuilder.func_225582_a_(f2 + (float)j + 1.0f - 9.765625E-4f, \u2603 + 0.0f, \u2603 + 0.0f).func_225583_a_((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
                        }
                    }
                    if (\u2603 > -1) {
                        for (j = 0; j < 8; ++j) {
                            bufferBuilder.func_225582_a_(f2 + 0.0f, \u2603 + 4.0f, \u2603 + (float)j + 0.0f).func_225583_a_((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
                            bufferBuilder.func_225582_a_(f2 + 8.0f, \u2603 + 4.0f, \u2603 + (float)j + 0.0f).func_225583_a_((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
                            bufferBuilder.func_225582_a_(f2 + 8.0f, \u2603 + 0.0f, \u2603 + (float)j + 0.0f).func_225583_a_((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
                            bufferBuilder.func_225582_a_(f2 + 0.0f, \u2603 + 0.0f, \u2603 + (float)j + 0.0f).func_225583_a_((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
                        }
                    }
                    if (\u2603 > 1) continue;
                    for (j = 0; j < 8; ++j) {
                        bufferBuilder.func_225582_a_(f2 + 0.0f, \u2603 + 4.0f, \u2603 + (float)j + 1.0f - 9.765625E-4f).func_225583_a_((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
                        bufferBuilder.func_225582_a_(f2 + 8.0f, \u2603 + 4.0f, \u2603 + (float)j + 1.0f - 9.765625E-4f).func_225583_a_((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
                        bufferBuilder.func_225582_a_(f2 + 8.0f, \u2603 + 0.0f, \u2603 + (float)j + 1.0f - 9.765625E-4f).func_225583_a_((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
                        bufferBuilder.func_225582_a_(f2 + 0.0f, \u2603 + 0.0f, \u2603 + (float)j + 1.0f - 9.765625E-4f).func_225583_a_((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
                    }
                }
            }
        } else {
            boolean bl = true;
            int \u26034 = 32;
            for (int i = -32; i < 32; i += 32) {
                for (\u2603 = -32; \u2603 < 32; \u2603 += 32) {
                    bufferBuilder.func_225582_a_(i + 0, \u2603, \u2603 + 32).func_225583_a_((float)(i + 0) * 0.00390625f + \u2603, (float)(\u2603 + 32) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                    bufferBuilder.func_225582_a_(i + 32, \u2603, \u2603 + 32).func_225583_a_((float)(i + 32) * 0.00390625f + \u2603, (float)(\u2603 + 32) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                    bufferBuilder.func_225582_a_(i + 32, \u2603, \u2603 + 0).func_225583_a_((float)(i + 32) * 0.00390625f + \u2603, (float)(\u2603 + 0) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                    bufferBuilder.func_225582_a_(i + 0, \u2603, \u2603 + 0).func_225583_a_((float)(i + 0) * 0.00390625f + \u2603, (float)(\u2603 + 0) * 0.00390625f + \u2603).func_227885_a_(\u2603, \u2603, \u2603, 0.8f).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                }
            }
        }
    }

    private void func_174967_a(long l) {
        this.field_147595_R |= this.field_174995_M.func_228908_d_();
        \u2603 = Util.func_211178_c();
        int n = 0;
        if (!this.field_175009_l.isEmpty()) {
            Iterator<ChunkRenderDispatcher.ChunkRender> iterator = this.field_175009_l.iterator();
            while (iterator.hasNext()) {
                ChunkRenderDispatcher.ChunkRender chunkRender = iterator.next();
                if (chunkRender.func_188281_o()) {
                    this.field_174995_M.func_228902_a_(chunkRender);
                } else {
                    chunkRender.func_228929_a_(this.field_174995_M);
                }
                chunkRender.func_188282_m();
                iterator.remove();
                long \u26032 = Util.func_211178_c();
                long \u26033 = l - \u26032;
                if (\u26033 >= (\u2603 = (\u2603 = \u26032 - \u2603) / (long)(++n))) continue;
                break;
            }
        }
    }

    private void func_228447_c_(ActiveRenderInfo activeRenderInfo) {
        float \u260319;
        double d;
        double \u260318;
        float f;
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        WorldBorder \u26032 = this.field_72769_h.func_175723_af();
        double \u26033 = this.field_72777_q.field_71474_y.field_151451_c * 16;
        if (activeRenderInfo.func_216785_c().field_72450_a < \u26032.func_177728_d() - \u26033 && activeRenderInfo.func_216785_c().field_72450_a > \u26032.func_177726_b() + \u26033 && activeRenderInfo.func_216785_c().field_72449_c < \u26032.func_177733_e() - \u26033 && activeRenderInfo.func_216785_c().field_72449_c > \u26032.func_177736_c() + \u26033) {
            return;
        }
        double \u26034 = 1.0 - \u26032.func_177729_b(activeRenderInfo.func_216785_c().field_72450_a, activeRenderInfo.func_216785_c().field_72449_c) / \u26033;
        \u26034 = Math.pow(\u26034, 4.0);
        double \u26035 = activeRenderInfo.func_216785_c().field_72450_a;
        double \u26036 = activeRenderInfo.func_216785_c().field_72448_b;
        double \u26037 = activeRenderInfo.func_216785_c().field_72449_c;
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        this.field_72770_i.func_110577_a(field_175006_g);
        RenderSystem.depthMask(false);
        RenderSystem.pushMatrix();
        int \u26038 = \u26032.func_177734_a().func_177766_a();
        float \u26039 = (float)(\u26038 >> 16 & 0xFF) / 255.0f;
        float \u260310 = (float)(\u26038 >> 8 & 0xFF) / 255.0f;
        float \u260311 = (float)(\u26038 & 0xFF) / 255.0f;
        RenderSystem.color4f(\u26039, \u260310, \u260311, (float)\u26034);
        RenderSystem.polygonOffset(-3.0f, -3.0f);
        RenderSystem.enablePolygonOffset();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableCull();
        float \u260312 = (float)(Util.func_211177_b() % 3000L) / 3000.0f;
        float \u260313 = 0.0f;
        float \u260314 = 0.0f;
        float \u260315 = 128.0f;
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double \u260316 = Math.max((double)MathHelper.func_76128_c(\u26037 - \u26033), \u26032.func_177736_c());
        double \u260317 = Math.min((double)MathHelper.func_76143_f(\u26037 + \u26033), \u26032.func_177733_e());
        if (\u26035 > \u26032.func_177728_d() - \u26033) {
            f = 0.0f;
            \u260318 = \u260316;
            while (\u260318 < \u260317) {
                d = Math.min(1.0, \u260317 - \u260318);
                \u260319 = (float)d * 0.5f;
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u26032.func_177728_d(), 256, \u260318, \u260312 + f, \u260312 + 0.0f);
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u26032.func_177728_d(), 256, \u260318 + d, \u260312 + \u260319 + f, \u260312 + 0.0f);
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u26032.func_177728_d(), 0, \u260318 + d, \u260312 + \u260319 + f, \u260312 + 128.0f);
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u26032.func_177728_d(), 0, \u260318, \u260312 + f, \u260312 + 128.0f);
                \u260318 += 1.0;
                f += 0.5f;
            }
        }
        if (\u26035 < \u26032.func_177726_b() + \u26033) {
            f = 0.0f;
            \u260318 = \u260316;
            while (\u260318 < \u260317) {
                d = Math.min(1.0, \u260317 - \u260318);
                \u260319 = (float)d * 0.5f;
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u26032.func_177726_b(), 256, \u260318, \u260312 + f, \u260312 + 0.0f);
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u26032.func_177726_b(), 256, \u260318 + d, \u260312 + \u260319 + f, \u260312 + 0.0f);
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u26032.func_177726_b(), 0, \u260318 + d, \u260312 + \u260319 + f, \u260312 + 128.0f);
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u26032.func_177726_b(), 0, \u260318, \u260312 + f, \u260312 + 128.0f);
                \u260318 += 1.0;
                f += 0.5f;
            }
        }
        \u260316 = Math.max((double)MathHelper.func_76128_c(\u26035 - \u26033), \u26032.func_177726_b());
        \u260317 = Math.min((double)MathHelper.func_76143_f(\u26035 + \u26033), \u26032.func_177728_d());
        if (\u26037 > \u26032.func_177733_e() - \u26033) {
            f = 0.0f;
            \u260318 = \u260316;
            while (\u260318 < \u260317) {
                d = Math.min(1.0, \u260317 - \u260318);
                \u260319 = (float)d * 0.5f;
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u260318, 256, \u26032.func_177733_e(), \u260312 + f, \u260312 + 0.0f);
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u260318 + d, 256, \u26032.func_177733_e(), \u260312 + \u260319 + f, \u260312 + 0.0f);
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u260318 + d, 0, \u26032.func_177733_e(), \u260312 + \u260319 + f, \u260312 + 128.0f);
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u260318, 0, \u26032.func_177733_e(), \u260312 + f, \u260312 + 128.0f);
                \u260318 += 1.0;
                f += 0.5f;
            }
        }
        if (\u26037 < \u26032.func_177736_c() + \u26033) {
            f = 0.0f;
            \u260318 = \u260316;
            while (\u260318 < \u260317) {
                d = Math.min(1.0, \u260317 - \u260318);
                \u260319 = (float)d * 0.5f;
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u260318, 256, \u26032.func_177736_c(), \u260312 + f, \u260312 + 0.0f);
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u260318 + d, 256, \u26032.func_177736_c(), \u260312 + \u260319 + f, \u260312 + 0.0f);
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u260318 + d, 0, \u26032.func_177736_c(), \u260312 + \u260319 + f, \u260312 + 128.0f);
                this.func_228422_a_(bufferBuilder, \u26035, \u26036, \u26037, \u260318, 0, \u26032.func_177736_c(), \u260312 + f, \u260312 + 128.0f);
                \u260318 += 1.0;
                f += 0.5f;
            }
        }
        bufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a(bufferBuilder);
        RenderSystem.enableCull();
        RenderSystem.disableAlphaTest();
        RenderSystem.polygonOffset(0.0f, 0.0f);
        RenderSystem.disablePolygonOffset();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        RenderSystem.depthMask(true);
    }

    private void func_228422_a_(BufferBuilder bufferBuilder, double d, double d2, double d3, double d4, int n, double d5, float f, float f2) {
        bufferBuilder.func_225582_a_(d4 - d, (double)n - d2, d5 - d3).func_225583_a_(f, f2).func_181675_d();
    }

    private void func_228429_a_(MatrixStack matrixStack, IVertexBuilder iVertexBuilder, Entity entity, double d, double d2, double d3, BlockPos blockPos, BlockState blockState) {
        WorldRenderer.func_228445_b_(matrixStack, iVertexBuilder, blockState.func_215700_a(this.field_72769_h, blockPos, ISelectionContext.func_216374_a(entity)), (double)blockPos.func_177958_n() - d, (double)blockPos.func_177956_o() - d2, (double)blockPos.func_177952_p() - d3, 0.0f, 0.0f, 0.0f, 0.4f);
    }

    public static void func_228431_a_(MatrixStack matrixStack, IVertexBuilder iVertexBuilder, VoxelShape voxelShape, double d, double d2, double d3, float f, float f2, float f3, float f4) {
        List<AxisAlignedBB> list = voxelShape.func_197756_d();
        int \u26032 = MathHelper.func_76143_f((double)list.size() / 3.0);
        for (int i = 0; i < list.size(); ++i) {
            AxisAlignedBB axisAlignedBB = list.get(i);
            float \u26033 = ((float)i % (float)\u26032 + 1.0f) / (float)\u26032;
            float \u26034 = i / \u26032;
            float \u26035 = \u26033 * (float)(\u26034 == 0.0f ? 1 : 0);
            float \u26036 = \u26033 * (float)(\u26034 == 1.0f ? 1 : 0);
            float \u26037 = \u26033 * (float)(\u26034 == 2.0f ? 1 : 0);
            WorldRenderer.func_228445_b_(matrixStack, iVertexBuilder, VoxelShapes.func_197881_a(axisAlignedBB.func_72317_d(0.0, 0.0, 0.0)), d, d2, d3, \u26035, \u26036, \u26037, 1.0f);
        }
    }

    private static void func_228445_b_(MatrixStack matrixStack, IVertexBuilder iVertexBuilder, VoxelShape voxelShape, double d, double d2, double d3, float f, float f2, float f3, float f4) {
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        voxelShape.func_197754_a((d4, d5, d6, d7, d8, d9) -> {
            iVertexBuilder.func_227888_a_(matrix4f, (float)(d4 + d), (float)(d5 + d2), (float)(d6 + d3)).func_227885_a_(f, f2, f3, f4).func_181675_d();
            iVertexBuilder.func_227888_a_(matrix4f, (float)(d7 + d), (float)(d8 + d2), (float)(d9 + d3)).func_227885_a_(f, f2, f3, f4).func_181675_d();
        });
    }

    public static void func_228432_a_(IVertexBuilder iVertexBuilder, double d, double d2, double d3, double d4, double d5, double d6, float f, float f2, float f3, float f4) {
        WorldRenderer.func_228428_a_(new MatrixStack(), iVertexBuilder, d, d2, d3, d4, d5, d6, f, f2, f3, f4, f, f2, f3);
    }

    public static void func_228430_a_(MatrixStack matrixStack, IVertexBuilder iVertexBuilder, AxisAlignedBB axisAlignedBB, float f, float f2, float f3, float f4) {
        WorldRenderer.func_228428_a_(matrixStack, iVertexBuilder, axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c, axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f, f, f2, f3, f4, f, f2, f3);
    }

    public static void func_228427_a_(MatrixStack matrixStack, IVertexBuilder iVertexBuilder, double d, double d2, double d3, double d4, double d5, double d6, float f, float f2, float f3, float f4) {
        WorldRenderer.func_228428_a_(matrixStack, iVertexBuilder, d, d2, d3, d4, d5, d6, f, f2, f3, f4, f, f2, f3);
    }

    public static void func_228428_a_(MatrixStack matrixStack, IVertexBuilder iVertexBuilder, double d, double d2, double d3, double d4, double d5, double d6, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        float \u26032 = (float)d;
        float \u26033 = (float)d2;
        float \u26034 = (float)d3;
        float \u26035 = (float)d4;
        float \u26036 = (float)d5;
        float \u26037 = (float)d6;
        iVertexBuilder.func_227888_a_(matrix4f, \u26032, \u26033, \u26034).func_227885_a_(f, f6, f7, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26035, \u26033, \u26034).func_227885_a_(f, f6, f7, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26032, \u26033, \u26034).func_227885_a_(f5, f2, f7, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26032, \u26036, \u26034).func_227885_a_(f5, f2, f7, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26032, \u26033, \u26034).func_227885_a_(f5, f6, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26032, \u26033, \u26037).func_227885_a_(f5, f6, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26035, \u26033, \u26034).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26035, \u26036, \u26034).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26035, \u26036, \u26034).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26032, \u26036, \u26034).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26032, \u26036, \u26034).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26032, \u26036, \u26037).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26032, \u26036, \u26037).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26032, \u26033, \u26037).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26032, \u26033, \u26037).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26035, \u26033, \u26037).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26035, \u26033, \u26037).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26035, \u26033, \u26034).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26032, \u26036, \u26037).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26035, \u26036, \u26037).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26035, \u26033, \u26037).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26035, \u26036, \u26037).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26035, \u26036, \u26034).func_227885_a_(f, f2, f3, f4).func_181675_d();
        iVertexBuilder.func_227888_a_(matrix4f, \u26035, \u26036, \u26037).func_227885_a_(f, f2, f3, f4).func_181675_d();
    }

    public static void func_189693_b(BufferBuilder bufferBuilder, double d, double d2, double d3, double d4, double d5, double d6, float f, float f2, float f3, float f4) {
        bufferBuilder.func_225582_a_(d, d2, d3).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d, d2, d3).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d, d2, d3).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d, d2, d6).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d, d5, d3).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d, d5, d6).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d, d5, d6).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d, d2, d6).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d4, d5, d6).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d4, d2, d6).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d4, d2, d6).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d4, d2, d3).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d4, d5, d6).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d4, d5, d3).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d4, d5, d3).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d4, d2, d3).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d, d5, d3).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d, d2, d3).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d, d2, d3).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d4, d2, d3).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d, d2, d6).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d4, d2, d6).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d4, d2, d6).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d, d5, d3).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d, d5, d3).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d, d5, d6).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d4, d5, d3).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d4, d5, d6).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d4, d5, d6).func_227885_a_(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_225582_a_(d4, d5, d6).func_227885_a_(f, f2, f3, f4).func_181675_d();
    }

    public void func_184376_a(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, BlockState blockState2, int n) {
        this.func_215324_a(blockPos, (n & 8) != 0);
    }

    private void func_215324_a(BlockPos blockPos, boolean bl) {
        for (int i = blockPos.func_177952_p() - 1; i <= blockPos.func_177952_p() + 1; ++i) {
            for (\u2603 = blockPos.func_177958_n() - 1; \u2603 <= blockPos.func_177958_n() + 1; ++\u2603) {
                for (\u2603 = blockPos.func_177956_o() - 1; \u2603 <= blockPos.func_177956_o() + 1; ++\u2603) {
                    this.func_215319_a(\u2603 >> 4, \u2603 >> 4, i >> 4, bl);
                }
            }
        }
    }

    public void func_147585_a(int n, int n2, int n3, int n4, int n5, int n6) {
        for (\u2603 = n3 - 1; \u2603 <= n6 + 1; ++\u2603) {
            for (\u2603 = n - 1; \u2603 <= n4 + 1; ++\u2603) {
                for (\u2603 = n2 - 1; \u2603 <= n5 + 1; ++\u2603) {
                    this.func_215328_b(\u2603 >> 4, \u2603 >> 4, \u2603 >> 4);
                }
            }
        }
    }

    public void func_224746_a(BlockPos blockPos, BlockState blockState, BlockState blockState2) {
        if (this.field_72777_q.func_209506_al().func_224742_a(blockState, blockState2)) {
            this.func_147585_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        }
    }

    public void func_215321_a(int n, int n2, int n3) {
        for (\u2603 = n3 - 1; \u2603 <= n3 + 1; ++\u2603) {
            for (\u2603 = n - 1; \u2603 <= n + 1; ++\u2603) {
                for (\u2603 = n2 - 1; \u2603 <= n2 + 1; ++\u2603) {
                    this.func_215328_b(\u2603, \u2603, \u2603);
                }
            }
        }
    }

    public void func_215328_b(int n, int n2, int n3) {
        this.func_215319_a(n, n2, n3, false);
    }

    private void func_215319_a(int n, int n2, int n3, boolean bl) {
        this.field_175008_n.func_217628_a(n, n2, n3, bl);
    }

    public void func_184377_a(@Nullable SoundEvent soundEvent, BlockPos blockPos) {
        ISound \u26032 = this.field_147593_P.get(blockPos);
        if (\u26032 != null) {
            this.field_72777_q.func_147118_V().func_147683_b(\u26032);
            this.field_147593_P.remove(blockPos);
        }
        if (soundEvent != null) {
            MusicDiscItem musicDiscItem = MusicDiscItem.func_185074_a(soundEvent);
            if (musicDiscItem != null) {
                this.field_72777_q.field_71456_v.func_73833_a(musicDiscItem.func_200299_h().func_150254_d());
            }
            \u26032 = SimpleSound.func_184372_a(soundEvent, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            this.field_147593_P.put(blockPos, \u26032);
            this.field_72777_q.func_147118_V().func_147682_a(\u26032);
        }
        this.func_193054_a(this.field_72769_h, blockPos, soundEvent != null);
    }

    private void func_193054_a(World world, BlockPos blockPos, boolean bl) {
        List<LivingEntity> list = world.func_217357_a(LivingEntity.class, new AxisAlignedBB(blockPos).func_186662_g(3.0));
        for (LivingEntity livingEntity : list) {
            livingEntity.func_191987_a(blockPos, bl);
        }
    }

    public void func_195461_a(IParticleData iParticleData, boolean bl, double d, double d2, double d3, double d4, double d5, double d6) {
        this.func_195462_a(iParticleData, bl, false, d, d2, d3, d4, d5, d6);
    }

    public void func_195462_a(IParticleData iParticleData, boolean bl, boolean bl2, double d, double d2, double d3, double d4, double d5, double d6) {
        try {
            this.func_195469_b(iParticleData, bl, bl2, d, d2, d3, d4, d5, d6);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception while adding particle");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Particle being added");
            \u26032.func_71507_a("ID", Registry.field_212632_u.func_177774_c(iParticleData.func_197554_b()));
            \u26032.func_71507_a("Parameters", iParticleData.func_197555_a());
            \u26032.func_189529_a("Position", () -> CrashReportCategory.func_85074_a(d, d2, d3));
            throw new ReportedException(crashReport);
        }
    }

    private <T extends IParticleData> void func_195467_a(T t, double d, double d2, double d3, double d4, double d5, double d6) {
        this.func_195461_a(t, t.func_197554_b().func_197575_f(), d, d2, d3, d4, d5, d6);
    }

    @Nullable
    private Particle func_195471_b(IParticleData iParticleData, boolean bl, double d, double d2, double d3, double d4, double d5, double d6) {
        return this.func_195469_b(iParticleData, bl, false, d, d2, d3, d4, d5, d6);
    }

    @Nullable
    private Particle func_195469_b(IParticleData iParticleData, boolean bl, boolean bl2, double d, double d2, double d3, double d4, double d5, double d6) {
        ActiveRenderInfo activeRenderInfo = this.field_72777_q.field_71460_t.func_215316_n();
        if (this.field_72777_q == null || !activeRenderInfo.func_216786_h() || this.field_72777_q.field_71452_i == null) {
            return null;
        }
        ParticleStatus \u26032 = this.func_215327_a(bl2);
        if (bl) {
            return this.field_72777_q.field_71452_i.func_199280_a(iParticleData, d, d2, d3, d4, d5, d6);
        }
        if (activeRenderInfo.func_216785_c().func_186679_c(d, d2, d3) > 1024.0) {
            return null;
        }
        if (\u26032 == ParticleStatus.MINIMAL) {
            return null;
        }
        return this.field_72777_q.field_71452_i.func_199280_a(iParticleData, d, d2, d3, d4, d5, d6);
    }

    private ParticleStatus func_215327_a(boolean bl) {
        ParticleStatus particleStatus = this.field_72777_q.field_71474_y.field_74362_aa;
        if (bl && particleStatus == ParticleStatus.MINIMAL && this.field_72769_h.field_73012_v.nextInt(10) == 0) {
            particleStatus = ParticleStatus.DECREASED;
        }
        if (particleStatus == ParticleStatus.DECREASED && this.field_72769_h.field_73012_v.nextInt(3) == 0) {
            particleStatus = ParticleStatus.MINIMAL;
        }
        return particleStatus;
    }

    public void func_72728_f() {
    }

    public void func_180440_a(int n, BlockPos blockPos, int n2) {
        switch (n) {
            case 1023: 
            case 1028: 
            case 1038: {
                ActiveRenderInfo activeRenderInfo = this.field_72777_q.field_71460_t.func_215316_n();
                if (!activeRenderInfo.func_216786_h()) break;
                double \u26032 = (double)blockPos.func_177958_n() - activeRenderInfo.func_216785_c().field_72450_a;
                double \u26033 = (double)blockPos.func_177956_o() - activeRenderInfo.func_216785_c().field_72448_b;
                double \u26034 = (double)blockPos.func_177952_p() - activeRenderInfo.func_216785_c().field_72449_c;
                double \u26035 = Math.sqrt(\u26032 * \u26032 + \u26033 * \u26033 + \u26034 * \u26034);
                double \u26036 = activeRenderInfo.func_216785_c().field_72450_a;
                double \u26037 = activeRenderInfo.func_216785_c().field_72448_b;
                double \u26038 = activeRenderInfo.func_216785_c().field_72449_c;
                if (\u26035 > 0.0) {
                    \u26036 += \u26032 / \u26035 * 2.0;
                    \u26037 += \u26033 / \u26035 * 2.0;
                    \u26038 += \u26034 / \u26035 * 2.0;
                }
                if (n == 1023) {
                    this.field_72769_h.func_184134_a(\u26036, \u26037, \u26038, SoundEvents.field_187855_gD, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                if (n == 1038) {
                    this.field_72769_h.func_184134_a(\u26036, \u26037, \u26038, SoundEvents.field_193782_bq, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                this.field_72769_h.func_184134_a(\u26036, \u26037, \u26038, SoundEvents.field_187522_aL, SoundCategory.HOSTILE, 5.0f, 1.0f, false);
            }
        }
    }

    public void func_180439_a(PlayerEntity playerEntity, int n, BlockPos blockPos2, int n22) {
        Random random = this.field_72769_h.field_73012_v;
        switch (n) {
            case 1035: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187621_J, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1033: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187542_ac, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1034: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187540_ab, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1032: {
                this.field_72777_q.func_147118_V().func_147682_a(SimpleSound.func_184371_a(SoundEvents.field_187812_eh, random.nextFloat() * 0.4f + 0.8f));
                break;
            }
            case 1001: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187576_at, SoundCategory.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1000: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187574_as, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1003: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187528_aR, SoundCategory.NEUTRAL, 1.0f, 1.2f, false);
                break;
            }
            case 1004: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187634_bp, SoundCategory.NEUTRAL, 1.0f, 1.2f, false);
                break;
            }
            case 1002: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187578_au, SoundCategory.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 2000: {
                Direction direction = Direction.func_82600_a(n22);
                int \u26032 = direction.func_82601_c();
                int \u26033 = direction.func_96559_d();
                int \u26034 = direction.func_82599_e();
                double \u26035 = (double)blockPos2.func_177958_n() + (double)\u26032 * 0.6 + 0.5;
                double \u26036 = (double)blockPos2.func_177956_o() + (double)\u26033 * 0.6 + 0.5;
                double \u26037 = (double)blockPos2.func_177952_p() + (double)\u26034 * 0.6 + 0.5;
                for (int i = 0; i < 10; ++i) {
                    double d = random.nextDouble() * 0.2 + 0.01;
                    \u2603 = \u26035 + (double)\u26032 * 0.01 + (random.nextDouble() - 0.5) * (double)\u26034 * 0.5;
                    \u2603 = \u26036 + (double)\u26033 * 0.01 + (random.nextDouble() - 0.5) * (double)\u26033 * 0.5;
                    \u2603 = \u26037 + (double)\u26034 * 0.01 + (random.nextDouble() - 0.5) * (double)\u26032 * 0.5;
                    \u2603 = (double)\u26032 * d + random.nextGaussian() * 0.01;
                    \u2603 = (double)\u26033 * d + random.nextGaussian() * 0.01;
                    \u2603 = (double)\u26034 * d + random.nextGaussian() * 0.01;
                    this.func_195467_a(ParticleTypes.field_197601_L, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603);
                }
                break;
            }
            case 2003: {
                BlockPos blockPos2;
                double \u26038 = (double)blockPos2.func_177958_n() + 0.5;
                double \u26039 = blockPos2.func_177956_o();
                double \u260310 = (double)blockPos2.func_177952_p() + 0.5;
                for (int i = 0; i < 8; ++i) {
                    this.func_195467_a(new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack(Items.field_151061_bv)), \u26038, \u26039, \u260310, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
                }
                for (double d = 0.0; d < Math.PI * 2; d += 0.15707963267948966) {
                    this.func_195467_a(ParticleTypes.field_197599_J, \u26038 + Math.cos(d) * 5.0, \u26039 - 0.4, \u260310 + Math.sin(d) * 5.0, Math.cos(d) * -5.0, 0.0, Math.sin(d) * -5.0);
                    this.func_195467_a(ParticleTypes.field_197599_J, \u26038 + Math.cos(d) * 5.0, \u26039 - 0.4, \u260310 + Math.sin(d) * 5.0, Math.cos(d) * -7.0, 0.0, Math.sin(d) * -7.0);
                }
                break;
            }
            case 2002: 
            case 2007: {
                int n22;
                BlockPos blockPos2;
                double \u260311 = blockPos2.func_177958_n();
                double \u260312 = blockPos2.func_177956_o();
                double \u260313 = blockPos2.func_177952_p();
                for (int i = 0; i < 8; ++i) {
                    this.func_195467_a(new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack(Items.field_185155_bH)), \u260311, \u260312, \u260313, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
                }
                float \u260314 = (float)(n22 >> 16 & 0xFF) / 255.0f;
                float \u260315 = (float)(n22 >> 8 & 0xFF) / 255.0f;
                float \u260316 = (float)(n22 >> 0 & 0xFF) / 255.0f;
                BasicParticleType \u260317 = n == 2007 ? ParticleTypes.field_197590_A : ParticleTypes.field_197620_m;
                for (\u2603 = 0; \u2603 < 100; ++\u2603) {
                    double d = random.nextDouble() * 4.0;
                    \u2603 = random.nextDouble() * Math.PI * 2.0;
                    \u2603 = Math.cos(\u2603) * d;
                    \u2603 = 0.01 + random.nextDouble() * 0.5;
                    \u2603 = Math.sin(\u2603) * d;
                    Particle \u260318 = this.func_195471_b(\u260317, \u260317.func_197554_b().func_197575_f(), \u260311 + \u2603 * 0.1, \u260312 + 0.3, \u260313 + \u2603 * 0.1, \u2603, \u2603, \u2603);
                    if (\u260318 == null) continue;
                    float \u260319 = 0.75f + random.nextFloat() * 0.25f;
                    \u260318.func_70538_b(\u260314 * \u260319, \u260315 * \u260319, \u260316 * \u260319);
                    \u260318.func_70543_e((float)d);
                }
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187825_fO, SoundCategory.NEUTRAL, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2001: {
                BlockPos blockPos2;
                BlockState blockState = Block.func_196257_b(n22);
                if (!blockState.func_196958_f()) {
                    SoundType soundType = blockState.func_215695_r();
                    this.field_72769_h.func_184156_a(blockPos2, soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, false);
                }
                this.field_72777_q.field_71452_i.func_180533_a(blockPos2, blockState);
                break;
            }
            case 2004: {
                for (int i = 0; i < 20; ++i) {
                    double d = (double)blockPos2.func_177958_n() + 0.5 + ((double)this.field_72769_h.field_73012_v.nextFloat() - 0.5) * 2.0;
                    \u2603 = (double)blockPos2.func_177956_o() + 0.5 + ((double)this.field_72769_h.field_73012_v.nextFloat() - 0.5) * 2.0;
                    \u2603 = (double)blockPos2.func_177952_p() + 0.5 + ((double)this.field_72769_h.field_73012_v.nextFloat() - 0.5) * 2.0;
                    this.field_72769_h.func_195594_a(ParticleTypes.field_197601_L, d, \u2603, \u2603, 0.0, 0.0, 0.0);
                    this.field_72769_h.func_195594_a(ParticleTypes.field_197631_x, d, \u2603, \u2603, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 2005: {
                BlockPos blockPos2;
                BoneMealItem.func_195965_a(this.field_72769_h, blockPos2, n22);
                break;
            }
            case 2008: {
                BlockPos blockPos2;
                this.field_72769_h.func_195594_a(ParticleTypes.field_197627_t, (double)blockPos2.func_177958_n() + 0.5, (double)blockPos2.func_177956_o() + 0.5, (double)blockPos2.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                break;
            }
            case 1500: {
                BlockPos blockPos2;
                ComposterBlock.func_220292_a(this.field_72769_h, blockPos2, n22 > 0);
                break;
            }
            case 1501: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.field_72769_h.func_201674_k().nextFloat() - this.field_72769_h.func_201674_k().nextFloat()) * 0.8f, false);
                for (int i = 0; i < 8; ++i) {
                    this.field_72769_h.func_195594_a(ParticleTypes.field_197594_E, (double)blockPos2.func_177958_n() + Math.random(), (double)blockPos2.func_177956_o() + 1.2, (double)blockPos2.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1502: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.field_72769_h.field_73012_v.nextFloat() - this.field_72769_h.field_73012_v.nextFloat()) * 0.8f, false);
                for (int i = 0; i < 5; ++i) {
                    double d = (double)blockPos2.func_177958_n() + random.nextDouble() * 0.6 + 0.2;
                    \u2603 = (double)blockPos2.func_177956_o() + random.nextDouble() * 0.6 + 0.2;
                    \u2603 = (double)blockPos2.func_177952_p() + random.nextDouble() * 0.6 + 0.2;
                    this.field_72769_h.func_195594_a(ParticleTypes.field_197601_L, d, \u2603, \u2603, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1503: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                for (int i = 0; i < 16; ++i) {
                    double d = (float)blockPos2.func_177958_n() + (5.0f + random.nextFloat() * 6.0f) / 16.0f;
                    \u2603 = (float)blockPos2.func_177956_o() + 0.8125f;
                    \u2603 = (float)blockPos2.func_177952_p() + (5.0f + random.nextFloat() * 6.0f) / 16.0f;
                    \u2603 = 0.0;
                    \u2603 = 0.0;
                    \u2603 = 0.0;
                    this.field_72769_h.func_195594_a(ParticleTypes.field_197601_L, d, \u2603, \u2603, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 2006: {
                for (int i = 0; i < 200; ++i) {
                    float f = random.nextFloat() * 4.0f;
                    \u2603 = random.nextFloat() * ((float)Math.PI * 2);
                    double \u260320 = MathHelper.func_76134_b(\u2603) * f;
                    double \u260321 = 0.01 + random.nextDouble() * 0.5;
                    double \u260322 = MathHelper.func_76126_a(\u2603) * f;
                    Particle \u260323 = this.func_195471_b(ParticleTypes.field_197616_i, false, (double)blockPos2.func_177958_n() + \u260320 * 0.1, (double)blockPos2.func_177956_o() + 0.3, (double)blockPos2.func_177952_p() + \u260322 * 0.1, \u260320, \u260321, \u260322);
                    if (\u260323 == null) continue;
                    \u260323.func_70543_e(f);
                }
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187523_aM, SoundCategory.HOSTILE, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2009: {
                for (int i = 0; i < 8; ++i) {
                    this.field_72769_h.func_195594_a(ParticleTypes.field_197613_f, (double)blockPos2.func_177958_n() + Math.random(), (double)blockPos2.func_177956_o() + 1.2, (double)blockPos2.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1012: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187873_gM, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1036: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187614_cJ, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1013: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187877_gO, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1014: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187610_bh, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1011: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187608_cH, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1006: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187875_gN, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1007: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187879_gP, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1037: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187617_cK, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1008: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187613_bi, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1005: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187611_cI, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1009: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f, false);
                break;
            }
            case 1029: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187680_c, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1030: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187698_i, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1031: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.3f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1039: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_203257_fu, SoundCategory.HOSTILE, 0.3f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1010: {
                int n22;
                if (Item.func_150899_d(n22) instanceof MusicDiscItem) {
                    this.func_184377_a(((MusicDiscItem)Item.func_150899_d(n22)).func_185075_h(), blockPos2);
                    break;
                }
                this.func_184377_a(null, blockPos2);
                break;
            }
            case 1015: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187559_bL, SoundCategory.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1017: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187527_aQ, SoundCategory.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1016: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187557_bK, SoundCategory.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1019: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187927_ha, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1022: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187926_gz, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1021: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187929_hc, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1020: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187928_hb, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1018: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187606_E, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1024: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187853_gC, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1026: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187945_hs, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1027: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187941_ho, SoundCategory.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1040: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_204783_kG, SoundCategory.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1041: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_207378_dT, SoundCategory.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1025: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187744_z, SoundCategory.NEUTRAL, 0.05f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1042: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_219642_eu, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1043: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_219617_ah, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 3000: {
                BlockPos blockPos2;
                this.field_72769_h.func_195590_a(ParticleTypes.field_197626_s, true, (double)blockPos2.func_177958_n() + 0.5, (double)blockPos2.func_177956_o() + 0.5, (double)blockPos2.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187598_bd, SoundCategory.BLOCKS, 10.0f, (1.0f + (this.field_72769_h.field_73012_v.nextFloat() - this.field_72769_h.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
                break;
            }
            case 3001: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187525_aO, SoundCategory.HOSTILE, 64.0f, 0.8f + this.field_72769_h.field_73012_v.nextFloat() * 0.3f, false);
            }
        }
    }

    public void func_180441_b(int n3, BlockPos blockPos, int n2) {
        if (n2 < 0 || n2 >= 10) {
            DestroyBlockProgress destroyBlockProgress = (DestroyBlockProgress)this.field_72738_E.remove(n3);
            if (destroyBlockProgress != null) {
                this.func_228442_a_(destroyBlockProgress);
            }
        } else {
            int n3;
            DestroyBlockProgress \u26032 = (DestroyBlockProgress)this.field_72738_E.get(n3);
            if (\u26032 != null) {
                this.func_228442_a_(\u26032);
            }
            if (\u26032 == null || \u26032.func_180246_b().func_177958_n() != blockPos.func_177958_n() || \u26032.func_180246_b().func_177956_o() != blockPos.func_177956_o() || \u26032.func_180246_b().func_177952_p() != blockPos.func_177952_p()) {
                \u26032 = new DestroyBlockProgress(n3, blockPos);
                this.field_72738_E.put(n3, (Object)\u26032);
            }
            \u26032.func_73107_a(n2);
            \u26032.func_82744_b(this.field_72773_u);
            ((SortedSet)this.field_228407_B_.computeIfAbsent(\u26032.func_180246_b().func_218275_a(), l -> Sets.newTreeSet())).add(\u26032);
        }
    }

    public boolean func_184384_n() {
        return this.field_175009_l.isEmpty() && this.field_174995_M.func_188247_f();
    }

    public void func_174979_m() {
        this.field_147595_R = true;
        this.field_204607_y = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_181023_a(Collection<TileEntity> collection, Collection<TileEntity> collection2) {
        Set<TileEntity> set = this.field_181024_n;
        synchronized (set) {
            this.field_181024_n.removeAll(collection);
            this.field_181024_n.addAll(collection2);
        }
    }

    public static int func_228421_a_(ILightReader iLightReader, BlockPos blockPos) {
        return WorldRenderer.func_228420_a_(iLightReader, iLightReader.func_180495_p(blockPos), blockPos);
    }

    public static int func_228420_a_(ILightReader iLightReader, BlockState blockState, BlockPos blockPos) {
        if (blockState.func_227035_k_()) {
            return 0xF000F0;
        }
        int n = iLightReader.func_226658_a_(LightType.SKY, blockPos);
        \u2603 = iLightReader.func_226658_a_(LightType.BLOCK, blockPos);
        if (\u2603 < (\u2603 = blockState.func_185906_d())) {
            \u2603 = \u2603;
        }
        return n << 20 | \u2603 << 4;
    }

    public Framebuffer func_228448_p_() {
        return this.field_175015_z;
    }

    private static /* synthetic */ IVertexBuilder func_230014_a_(IRenderTypeBuffer.Impl impl, IVertexBuilder iVertexBuilder, RenderType renderType) {
        IVertexBuilder iVertexBuilder2 = impl.getBuffer(renderType);
        if (renderType.func_228665_s_()) {
            return VertexBuilderUtils.func_227915_a_(iVertexBuilder, iVertexBuilder2);
        }
        return iVertexBuilder2;
    }

    class LocalRenderInformationContainer {
        private final ChunkRenderDispatcher.ChunkRender field_178036_a;
        private final Direction field_178034_b;
        private byte field_178035_c;
        private final int field_178032_d;

        private LocalRenderInformationContainer(ChunkRenderDispatcher.ChunkRender chunkRender, @Nullable Direction direction, int n) {
            this.field_178036_a = chunkRender;
            this.field_178034_b = direction;
            this.field_178032_d = n;
        }

        public void func_189561_a(byte by, Direction direction) {
            this.field_178035_c = (byte)(this.field_178035_c | (by | 1 << direction.ordinal()));
        }

        public boolean func_189560_a(Direction direction) {
            return (this.field_178035_c & 1 << direction.ordinal()) > 0;
        }
    }
}

