/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.debug.PathfindingDebugRenderer;
import net.minecraft.dispenser.IPosition;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.RandomObjectDescriptor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;

public class BeeDebugRenderer
implements DebugRenderer.IDebugRenderer {
    private final Minecraft field_228958_a_;
    private final Map<BlockPos, Hive> field_228959_b_ = Maps.newHashMap();
    private final Map<UUID, Bee> field_228960_c_ = Maps.newHashMap();
    private UUID field_228961_d_;

    public BeeDebugRenderer(Minecraft minecraft) {
        this.field_228958_a_ = minecraft;
    }

    @Override
    public void func_217675_a() {
        this.field_228959_b_.clear();
        this.field_228960_c_.clear();
        this.field_228961_d_ = null;
    }

    public void func_228966_a_(Hive hive) {
        this.field_228959_b_.put(hive.field_229011_a_, hive);
    }

    public void func_228964_a_(Bee bee) {
        this.field_228960_c_.put(bee.field_228998_a_, bee);
    }

    @Override
    public void func_225619_a_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, double d, double d2, double d3) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableTexture();
        this.func_228987_c_();
        this.func_228981_b_();
        this.func_228989_d_();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        if (!this.field_228958_a_.field_71439_g.func_175149_v()) {
            this.func_228997_i_();
        }
    }

    private void func_228981_b_() {
        this.field_228960_c_.entrySet().removeIf(entry -> this.field_228958_a_.field_71441_e.func_73045_a(((Bee)entry.getValue()).field_228999_b_) == null);
    }

    private void func_228987_c_() {
        long l = this.field_228958_a_.field_71441_e.func_82737_E() - 20L;
        this.field_228959_b_.entrySet().removeIf(entry -> ((Hive)entry.getValue()).field_229016_f_ < l);
    }

    private void func_228989_d_() {
        BlockPos blockPos = this.func_228995_g_().func_216780_d();
        this.field_228960_c_.values().forEach(bee -> {
            if (this.func_228992_e_((Bee)bee)) {
                this.func_228988_c_((Bee)bee);
            }
        });
        this.func_228993_f_();
        for (BlockPos blockPos3 : this.field_228959_b_.keySet()) {
            if (!blockPos.func_218141_a(blockPos3, 30.0)) continue;
            BeeDebugRenderer.func_228968_a_(blockPos3);
        }
        Map<BlockPos, Set<UUID>> \u26032 = this.func_228991_e_();
        this.field_228959_b_.values().forEach(hive -> {
            if (blockPos.func_218141_a(hive.field_229011_a_, 30.0)) {
                Set set = (Set)\u26032.get(hive.field_229011_a_);
                this.func_228967_a_((Hive)hive, set == null ? Sets.newHashSet() : set);
            }
        });
        this.func_228996_h_().forEach((blockPos2, list) -> {
            if (blockPos.func_218141_a((Vec3i)blockPos2, 30.0)) {
                this.func_228972_a_((BlockPos)blockPos2, (List<String>)list);
            }
        });
    }

    private Map<BlockPos, Set<UUID>> func_228991_e_() {
        HashMap hashMap = Maps.newHashMap();
        this.field_228960_c_.values().forEach(bee -> bee.field_229006_i_.forEach(blockPos -> BeeDebugRenderer.func_228980_a_(hashMap, bee, blockPos)));
        return hashMap;
    }

    private void func_228993_f_() {
        HashMap hashMap = Maps.newHashMap();
        this.field_228960_c_.values().stream().filter(Bee::func_229010_c_).forEach(bee -> {
            Set set = (Set)hashMap.get(bee.field_229003_f_);
            if (set == null) {
                set = Sets.newHashSet();
                hashMap.put(bee.field_229003_f_, set);
            }
            set.add(bee.func_229007_a_());
        });
        hashMap.entrySet().forEach(entry -> {
            BlockPos blockPos = (BlockPos)entry.getKey();
            Set \u26032 = (Set)entry.getValue();
            Set \u26033 = \u26032.stream().map(RandomObjectDescriptor::func_229748_a_).collect(Collectors.toSet());
            int \u26034 = 1;
            BeeDebugRenderer.func_228976_a_(\u26033.toString(), blockPos, \u26034++, -256);
            BeeDebugRenderer.func_228976_a_("Flower", blockPos, \u26034++, -1);
            float \u26035 = 0.05f;
            BeeDebugRenderer.func_228969_a_(blockPos, 0.05f, 0.8f, 0.8f, 0.0f, 0.3f);
        });
    }

    private static String func_228977_a_(Collection<UUID> collection) {
        if (collection.isEmpty()) {
            return "-";
        }
        if (collection.size() > 3) {
            return "" + collection.size() + " bees";
        }
        return collection.stream().map(RandomObjectDescriptor::func_229748_a_).collect(Collectors.toSet()).toString();
    }

    private static void func_228980_a_(Map<BlockPos, Set<UUID>> map, Bee bee, BlockPos blockPos) {
        HashSet hashSet = map.get(blockPos);
        if (hashSet == null) {
            hashSet = Sets.newHashSet();
            map.put(blockPos, hashSet);
        }
        hashSet.add(bee.func_229007_a_());
    }

    private static void func_228968_a_(BlockPos blockPos) {
        float f = 0.05f;
        BeeDebugRenderer.func_228969_a_(blockPos, 0.05f, 0.2f, 0.2f, 1.0f, 0.3f);
    }

    private void func_228972_a_(BlockPos blockPos, List<String> list) {
        float f = 0.05f;
        BeeDebugRenderer.func_228969_a_(blockPos, 0.05f, 0.2f, 0.2f, 1.0f, 0.3f);
        BeeDebugRenderer.func_228976_a_("" + list, blockPos, 0, -256);
        BeeDebugRenderer.func_228976_a_("Ghost Hive", blockPos, 1, -65536);
    }

    private static void func_228969_a_(BlockPos blockPos, float f, float f2, float f3, float f4, float f5) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        DebugRenderer.func_217736_a(blockPos, f, f2, f3, f4, f5);
    }

    private void func_228967_a_(Hive hive, Collection<UUID> collection) {
        int n = 0;
        if (!collection.isEmpty()) {
            BeeDebugRenderer.func_228975_a_("Blacklisted by " + BeeDebugRenderer.func_228977_a_(collection), hive, n++, -65536);
        }
        BeeDebugRenderer.func_228975_a_("Out: " + BeeDebugRenderer.func_228977_a_(this.func_228983_b_(hive.field_229011_a_)), hive, n++, -3355444);
        if (hive.field_229013_c_ == 0) {
            BeeDebugRenderer.func_228975_a_("In: -", hive, n++, -256);
        } else if (hive.field_229013_c_ == 1) {
            BeeDebugRenderer.func_228975_a_("In: 1 bee", hive, n++, -256);
        } else {
            BeeDebugRenderer.func_228975_a_("In: " + hive.field_229013_c_ + " bees", hive, n++, -256);
        }
        BeeDebugRenderer.func_228975_a_("Honey: " + hive.field_229014_d_, hive, n++, -23296);
        BeeDebugRenderer.func_228975_a_(hive.field_229012_b_ + (hive.field_229015_e_ ? " (sedated)" : ""), hive, n++, -1);
    }

    private void func_228982_b_(Bee bee) {
        if (bee.field_229001_d_ != null) {
            PathfindingDebugRenderer.func_229032_a_(bee.field_229001_d_, 0.5f, false, false, this.func_228995_g_().func_216785_c().func_82615_a(), this.func_228995_g_().func_216785_c().func_82617_b(), this.func_228995_g_().func_216785_c().func_82616_c());
        }
    }

    private void func_228988_c_(Bee bee) {
        boolean bl = this.func_228990_d_(bee);
        int \u26032 = 0;
        BeeDebugRenderer.func_228974_a_(bee.field_229000_c_, \u26032++, bee.toString(), -1, 0.03f);
        if (bee.field_229002_e_ == null) {
            BeeDebugRenderer.func_228974_a_(bee.field_229000_c_, \u26032++, "No hive", -98404, 0.02f);
        } else {
            BeeDebugRenderer.func_228974_a_(bee.field_229000_c_, \u26032++, "Hive: " + this.func_228965_a_(bee, bee.field_229002_e_), -256, 0.02f);
        }
        if (bee.field_229003_f_ == null) {
            BeeDebugRenderer.func_228974_a_(bee.field_229000_c_, \u26032++, "No flower", -98404, 0.02f);
        } else {
            BeeDebugRenderer.func_228974_a_(bee.field_229000_c_, \u26032++, "Flower: " + this.func_228965_a_(bee, bee.field_229003_f_), -256, 0.02f);
        }
        for (String string : bee.field_229005_h_) {
            BeeDebugRenderer.func_228974_a_(bee.field_229000_c_, \u26032++, string, -16711936, 0.02f);
        }
        if (bl) {
            this.func_228982_b_(bee);
        }
        if (bee.field_229004_g_ > 0) {
            int n = bee.field_229004_g_ < 600 ? -3355444 : -23296;
            BeeDebugRenderer.func_228974_a_(bee.field_229000_c_, \u26032++, "Travelling: " + bee.field_229004_g_ + " ticks", n, 0.02f);
        }
    }

    private static void func_228975_a_(String string, Hive hive, int n, int n2) {
        BlockPos blockPos = hive.field_229011_a_;
        BeeDebugRenderer.func_228976_a_(string, blockPos, n, n2);
    }

    private static void func_228976_a_(String string, BlockPos blockPos, int n, int n2) {
        double d = 1.3;
        \u2603 = 0.2;
        \u2603 = (double)blockPos.func_177958_n() + 0.5;
        \u2603 = (double)blockPos.func_177956_o() + 1.3 + (double)n * 0.2;
        \u2603 = (double)blockPos.func_177952_p() + 0.5;
        DebugRenderer.func_217734_a(string, \u2603, \u2603, \u2603, n2, 0.02f, true, 0.0f, true);
    }

    private static void func_228974_a_(IPosition iPosition, int n, String string, int n2, float f) {
        double d = 2.4;
        \u2603 = 0.25;
        BlockPos \u26032 = new BlockPos(iPosition);
        \u2603 = (double)\u26032.func_177958_n() + 0.5;
        \u2603 = iPosition.func_82617_b() + 2.4 + (double)n * 0.25;
        \u2603 = (double)\u26032.func_177952_p() + 0.5;
        float \u26033 = 0.5f;
        DebugRenderer.func_217734_a(string, \u2603, \u2603, \u2603, n2, f, false, 0.5f, true);
    }

    private ActiveRenderInfo func_228995_g_() {
        return this.field_228958_a_.field_71460_t.func_215316_n();
    }

    private String func_228965_a_(Bee bee, BlockPos blockPos) {
        float f = MathHelper.func_76133_a(blockPos.func_218140_a(bee.field_229000_c_.func_82615_a(), bee.field_229000_c_.func_82617_b(), bee.field_229000_c_.func_82616_c(), true));
        double \u26032 = (double)Math.round(f * 10.0f) / 10.0;
        return blockPos.func_229422_x_() + " (dist " + \u26032 + ")";
    }

    private boolean func_228990_d_(Bee bee) {
        return Objects.equals(this.field_228961_d_, bee.field_228998_a_);
    }

    private boolean func_228992_e_(Bee bee) {
        ClientPlayerEntity clientPlayerEntity = this.field_228958_a_.field_71439_g;
        BlockPos \u26032 = new BlockPos(clientPlayerEntity.func_226277_ct_(), bee.field_229000_c_.func_82617_b(), clientPlayerEntity.func_226281_cx_());
        BlockPos \u26033 = new BlockPos(bee.field_229000_c_);
        return \u26032.func_218141_a(\u26033, 30.0);
    }

    private Collection<UUID> func_228983_b_(BlockPos blockPos) {
        return this.field_228960_c_.values().stream().filter(bee -> bee.func_229008_a_(blockPos)).map(Bee::func_229007_a_).collect(Collectors.toSet());
    }

    private Map<BlockPos, List<String>> func_228996_h_() {
        HashMap hashMap = Maps.newHashMap();
        for (Bee bee : this.field_228960_c_.values()) {
            if (bee.field_229002_e_ == null || this.field_228959_b_.containsKey(bee.field_229002_e_)) continue;
            List list = (List)hashMap.get(bee.field_229002_e_);
            if (list == null) {
                list = Lists.newArrayList();
                hashMap.put(bee.field_229002_e_, list);
            }
            list.add(bee.func_229009_b_());
        }
        return hashMap;
    }

    private void func_228997_i_() {
        DebugRenderer.func_217728_a(this.field_228958_a_.func_175606_aa(), 8).ifPresent(entity -> {
            this.field_228961_d_ = entity.func_110124_au();
        });
    }

    public static class Bee {
        public final UUID field_228998_a_;
        public final int field_228999_b_;
        public final IPosition field_229000_c_;
        @Nullable
        public final Path field_229001_d_;
        @Nullable
        public final BlockPos field_229002_e_;
        @Nullable
        public final BlockPos field_229003_f_;
        public final int field_229004_g_;
        public final List<String> field_229005_h_ = Lists.newArrayList();
        public final Set<BlockPos> field_229006_i_ = Sets.newHashSet();

        public Bee(UUID uUID, int n, IPosition iPosition, Path path, BlockPos blockPos, BlockPos blockPos2, int n2) {
            this.field_228998_a_ = uUID;
            this.field_228999_b_ = n;
            this.field_229000_c_ = iPosition;
            this.field_229001_d_ = path;
            this.field_229002_e_ = blockPos;
            this.field_229003_f_ = blockPos2;
            this.field_229004_g_ = n2;
        }

        public boolean func_229008_a_(BlockPos blockPos) {
            return this.field_229002_e_ != null && this.field_229002_e_.equals(blockPos);
        }

        public UUID func_229007_a_() {
            return this.field_228998_a_;
        }

        public String func_229009_b_() {
            return RandomObjectDescriptor.func_229748_a_(this.field_228998_a_);
        }

        public String toString() {
            return this.func_229009_b_();
        }

        public boolean func_229010_c_() {
            return this.field_229003_f_ != null;
        }
    }

    public static class Hive {
        public final BlockPos field_229011_a_;
        public final String field_229012_b_;
        public final int field_229013_c_;
        public final int field_229014_d_;
        public final boolean field_229015_e_;
        public final long field_229016_f_;

        public Hive(BlockPos blockPos, String string, int n, int n2, boolean bl, long l) {
            this.field_229011_a_ = blockPos;
            this.field_229012_b_ = string;
            this.field_229013_c_ = n;
            this.field_229014_d_ = n2;
            this.field_229015_e_ = bl;
            this.field_229016_f_ = l;
        }
    }
}

