/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.debug.BeeDebugRenderer;
import net.minecraft.client.renderer.debug.CaveDebugRenderer;
import net.minecraft.client.renderer.debug.ChunkBorderDebugRenderer;
import net.minecraft.client.renderer.debug.ChunkInfoDebugRenderer;
import net.minecraft.client.renderer.debug.CollisionBoxDebugRenderer;
import net.minecraft.client.renderer.debug.EntityAIDebugRenderer;
import net.minecraft.client.renderer.debug.GameTestDebugRenderer;
import net.minecraft.client.renderer.debug.HeightMapDebugRenderer;
import net.minecraft.client.renderer.debug.LightDebugRenderer;
import net.minecraft.client.renderer.debug.NeighborsUpdateDebugRenderer;
import net.minecraft.client.renderer.debug.PathfindingDebugRenderer;
import net.minecraft.client.renderer.debug.PointOfInterestDebugRenderer;
import net.minecraft.client.renderer.debug.RaidDebugRenderer;
import net.minecraft.client.renderer.debug.SolidFaceDebugRenderer;
import net.minecraft.client.renderer.debug.StructureDebugRenderer;
import net.minecraft.client.renderer.debug.WaterDebugRenderer;
import net.minecraft.client.renderer.debug.WorldGenAttemptsDebugRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.Vec3d;

public class DebugRenderer {
    public final PathfindingDebugRenderer field_188286_a = new PathfindingDebugRenderer();
    public final IDebugRenderer field_188287_b;
    public final IDebugRenderer field_190077_c;
    public final IDebugRenderer field_190078_d;
    public final IDebugRenderer field_191325_e;
    public final IDebugRenderer field_191557_f;
    public final CaveDebugRenderer field_201747_g;
    public final StructureDebugRenderer field_201748_h;
    public final IDebugRenderer field_201749_i;
    public final IDebugRenderer field_201750_j;
    public final IDebugRenderer field_193852_g;
    public final IDebugRenderer field_217740_l;
    public final PointOfInterestDebugRenderer field_217741_m;
    public final BeeDebugRenderer field_229017_n_;
    public final RaidDebugRenderer field_222927_n;
    public final EntityAIDebugRenderer field_217742_n;
    public final GameTestDebugRenderer field_229018_q_;
    private boolean field_190079_e;

    public DebugRenderer(Minecraft minecraft) {
        this.field_188287_b = new WaterDebugRenderer(minecraft);
        this.field_190077_c = new ChunkBorderDebugRenderer(minecraft);
        this.field_190078_d = new HeightMapDebugRenderer(minecraft);
        this.field_191325_e = new CollisionBoxDebugRenderer(minecraft);
        this.field_191557_f = new NeighborsUpdateDebugRenderer(minecraft);
        this.field_201747_g = new CaveDebugRenderer();
        this.field_201748_h = new StructureDebugRenderer(minecraft);
        this.field_201749_i = new LightDebugRenderer(minecraft);
        this.field_201750_j = new WorldGenAttemptsDebugRenderer();
        this.field_193852_g = new SolidFaceDebugRenderer(minecraft);
        this.field_217740_l = new ChunkInfoDebugRenderer(minecraft);
        this.field_217741_m = new PointOfInterestDebugRenderer(minecraft);
        this.field_229017_n_ = new BeeDebugRenderer(minecraft);
        this.field_222927_n = new RaidDebugRenderer(minecraft);
        this.field_217742_n = new EntityAIDebugRenderer(minecraft);
        this.field_229018_q_ = new GameTestDebugRenderer();
    }

    public void func_217737_a() {
        this.field_188286_a.func_217675_a();
        this.field_188287_b.func_217675_a();
        this.field_190077_c.func_217675_a();
        this.field_190078_d.func_217675_a();
        this.field_191325_e.func_217675_a();
        this.field_191557_f.func_217675_a();
        this.field_201747_g.func_217675_a();
        this.field_201748_h.func_217675_a();
        this.field_201749_i.func_217675_a();
        this.field_201750_j.func_217675_a();
        this.field_193852_g.func_217675_a();
        this.field_217740_l.func_217675_a();
        this.field_217741_m.func_217675_a();
        this.field_229017_n_.func_217675_a();
        this.field_222927_n.func_217675_a();
        this.field_217742_n.func_217675_a();
        this.field_229018_q_.func_217675_a();
    }

    public boolean func_190075_b() {
        this.field_190079_e = !this.field_190079_e;
        return this.field_190079_e;
    }

    public void func_229019_a_(MatrixStack matrixStack, IRenderTypeBuffer.Impl impl, double d, double d2, double d3) {
        if (this.field_190079_e && !Minecraft.func_71410_x().func_189648_am()) {
            this.field_190077_c.func_225619_a_(matrixStack, impl, d, d2, d3);
        }
        this.field_229018_q_.func_225619_a_(matrixStack, impl, d, d2, d3);
    }

    public static Optional<Entity> func_217728_a(@Nullable Entity entity2, int n) {
        if (entity2 == null) {
            return Optional.empty();
        }
        Vec3d vec3d = entity2.func_174824_e(1.0f);
        EntityRayTraceResult \u26032 = ProjectileHelper.func_221273_a(entity2, vec3d, \u2603 = vec3d.func_178787_e(\u2603 = entity2.func_70676_i(1.0f).func_186678_a(n)), \u2603 = entity2.func_174813_aQ().func_216361_a(\u2603).func_186662_g(1.0), \u2603 = entity -> !entity.func_175149_v() && entity.func_70067_L(), \u2603 = n * n);
        if (\u26032 == null) {
            return Optional.empty();
        }
        if (vec3d.func_72436_e(\u26032.func_216347_e()) > (double)\u2603) {
            return Optional.empty();
        }
        return Optional.of(\u26032.func_216348_a());
    }

    public static void func_217735_a(BlockPos blockPos, BlockPos blockPos2, float f, float f2, float f3, float f4) {
        ActiveRenderInfo activeRenderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        if (!activeRenderInfo.func_216786_h()) {
            return;
        }
        Vec3d \u26032 = activeRenderInfo.func_216785_c().func_216371_e();
        AxisAlignedBB \u26033 = new AxisAlignedBB(blockPos, blockPos2).func_191194_a(\u26032);
        DebugRenderer.func_217730_a(\u26033, f, f2, f3, f4);
    }

    public static void func_217736_a(BlockPos blockPos, float f, float f2, float f3, float f4, float f5) {
        ActiveRenderInfo activeRenderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        if (!activeRenderInfo.func_216786_h()) {
            return;
        }
        Vec3d \u26032 = activeRenderInfo.func_216785_c().func_216371_e();
        AxisAlignedBB \u26033 = new AxisAlignedBB(blockPos).func_191194_a(\u26032).func_186662_g(f);
        DebugRenderer.func_217730_a(\u26033, f2, f3, f4, f5);
    }

    public static void func_217730_a(AxisAlignedBB axisAlignedBB, float f, float f2, float f3, float f4) {
        DebugRenderer.func_217733_a(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c, axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f, f, f2, f3, f4);
    }

    public static void func_217733_a(double d, double d2, double d3, double d4, double d5, double d6, float f, float f2, float f3, float f4) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        \u26032.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        WorldRenderer.func_189693_b(\u26032, d, d2, d3, d4, d5, d6, f, f2, f3, f4);
        tessellator.func_78381_a();
    }

    public static void func_217731_a(String string, int n, int n2, int n3, int n4) {
        DebugRenderer.func_217732_a(string, (double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, n4);
    }

    public static void func_217732_a(String string, double d, double d2, double d3, int n) {
        DebugRenderer.func_217729_a(string, d, d2, d3, n, 0.02f);
    }

    public static void func_217729_a(String string, double d, double d2, double d3, int n, float f) {
        DebugRenderer.func_217734_a(string, d, d2, d3, n, f, true, 0.0f, false);
    }

    public static void func_217734_a(String string, double d, double d2, double d3, int n, float f, boolean bl, float f2, boolean bl2) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ActiveRenderInfo \u26032 = minecraft.field_71460_t.func_215316_n();
        if (!\u26032.func_216786_h() || minecraft.func_175598_ae().field_78733_k == null) {
            return;
        }
        FontRenderer \u26033 = minecraft.field_71466_p;
        double \u26034 = \u26032.func_216785_c().field_72450_a;
        double \u26035 = \u26032.func_216785_c().field_72448_b;
        double \u26036 = \u26032.func_216785_c().field_72449_c;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(d - \u26034), (float)(d2 - \u26035) + 0.07f, (float)(d3 - \u26036));
        RenderSystem.normal3f(0.0f, 1.0f, 0.0f);
        RenderSystem.multMatrix(new Matrix4f(\u26032.func_227995_f_()));
        RenderSystem.scalef(f, -f, f);
        RenderSystem.enableTexture();
        if (bl2) {
            RenderSystem.disableDepthTest();
        } else {
            RenderSystem.enableDepthTest();
        }
        RenderSystem.depthMask(true);
        RenderSystem.scalef(-1.0f, 1.0f, 1.0f);
        float \u26037 = bl ? (float)(-\u26033.func_78256_a(string)) / 2.0f : 0.0f;
        RenderSystem.enableAlphaTest();
        IRenderTypeBuffer.Impl \u26038 = IRenderTypeBuffer.func_228455_a_(Tessellator.func_178181_a().func_178180_c());
        \u26033.func_228079_a_(string, \u26037 -= f2 / f, 0.0f, n, false, TransformationMatrix.func_227983_a_().func_227988_c_(), \u26038, bl2, 0, 0xF000F0);
        \u26038.func_228461_a_();
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.popMatrix();
    }

    public static interface IDebugRenderer {
        public void func_225619_a_(MatrixStack var1, IRenderTypeBuffer var2, double var3, double var5, double var7);

        default public void func_217675_a() {
        }
    }
}

