/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class PathfindingDebugRenderer
implements DebugRenderer.IDebugRenderer {
    private final Map<Integer, Path> field_188291_b = Maps.newHashMap();
    private final Map<Integer, Float> field_188292_c = Maps.newHashMap();
    private final Map<Integer, Long> field_188293_d = Maps.newHashMap();

    public void func_188289_a(int n, Path path, float f) {
        this.field_188291_b.put(n, path);
        this.field_188293_d.put(n, Util.func_211177_b());
        this.field_188292_c.put(n, Float.valueOf(f));
    }

    @Override
    public void func_225619_a_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, double d, double d2, double d3) {
        if (this.field_188291_b.isEmpty()) {
            return;
        }
        long l = Util.func_211177_b();
        for (Integer n : this.field_188291_b.keySet()) {
            Path path = this.field_188291_b.get(n);
            float \u26032 = this.field_188292_c.get(n).floatValue();
            PathfindingDebugRenderer.func_229032_a_(path, \u26032, true, true, d, d2, d3);
        }
        for (Integer n : this.field_188293_d.keySet().toArray(new Integer[0])) {
            if (l - this.field_188293_d.get(n) <= 5000L) continue;
            this.field_188291_b.remove(n);
            this.field_188293_d.remove(n);
        }
    }

    public static void func_229032_a_(Path path, float f, boolean bl, boolean bl2, double d, double d2, double d3) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.color4f(0.0f, 1.0f, 0.0f, 0.75f);
        RenderSystem.disableTexture();
        RenderSystem.lineWidth(6.0f);
        PathfindingDebugRenderer.func_229034_b_(path, f, bl, bl2, d, d2, d3);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }

    private static void func_229034_b_(Path path, float f, boolean bl, boolean bl2, double d, double d2, double d3) {
        int n;
        PathfindingDebugRenderer.func_229031_a_(path, d, d2, d3);
        BlockPos blockPos = path.func_224770_k();
        if (PathfindingDebugRenderer.func_229033_a_(blockPos, d, d2, d3) <= 80.0f) {
            DebugRenderer.func_217730_a(new AxisAlignedBB((float)blockPos.func_177958_n() + 0.25f, (float)blockPos.func_177956_o() + 0.25f, (double)blockPos.func_177952_p() + 0.25, (float)blockPos.func_177958_n() + 0.75f, (float)blockPos.func_177956_o() + 0.75f, (float)blockPos.func_177952_p() + 0.75f).func_72317_d(-d, -d2, -d3), 0.0f, 1.0f, 0.0f, 0.5f);
            for (n = 0; n < path.func_75874_d(); ++n) {
                PathPoint pathPoint = path.func_75877_a(n);
                if (!(PathfindingDebugRenderer.func_229033_a_(pathPoint.func_224759_a(), d, d2, d3) <= 80.0f)) continue;
                float \u26032 = n == path.func_75873_e() ? 1.0f : 0.0f;
                float \u26033 = n == path.func_75873_e() ? 0.0f : 1.0f;
                DebugRenderer.func_217730_a(new AxisAlignedBB((float)pathPoint.field_75839_a + 0.5f - f, (float)pathPoint.field_75837_b + 0.01f * (float)n, (float)pathPoint.field_75838_c + 0.5f - f, (float)pathPoint.field_75839_a + 0.5f + f, (float)pathPoint.field_75837_b + 0.25f + 0.01f * (float)n, (float)pathPoint.field_75838_c + 0.5f + f).func_72317_d(-d, -d2, -d3), \u26032, 0.0f, \u26033, 0.5f);
            }
        }
        if (bl) {
            for (PathPoint pathPoint : path.func_189965_h()) {
                if (!(PathfindingDebugRenderer.func_229033_a_(pathPoint.func_224759_a(), d, d2, d3) <= 80.0f)) continue;
                DebugRenderer.func_217730_a(new AxisAlignedBB((float)pathPoint.field_75839_a + 0.5f - f / 2.0f, (float)pathPoint.field_75837_b + 0.01f, (float)pathPoint.field_75838_c + 0.5f - f / 2.0f, (float)pathPoint.field_75839_a + 0.5f + f / 2.0f, (double)pathPoint.field_75837_b + 0.1, (float)pathPoint.field_75838_c + 0.5f + f / 2.0f).func_72317_d(-d, -d2, -d3), 1.0f, 0.8f, 0.8f, 0.5f);
            }
            for (PathPoint pathPoint : path.func_189966_g()) {
                if (!(PathfindingDebugRenderer.func_229033_a_(pathPoint.func_224759_a(), d, d2, d3) <= 80.0f)) continue;
                DebugRenderer.func_217730_a(new AxisAlignedBB((float)pathPoint.field_75839_a + 0.5f - f / 2.0f, (float)pathPoint.field_75837_b + 0.01f, (float)pathPoint.field_75838_c + 0.5f - f / 2.0f, (float)pathPoint.field_75839_a + 0.5f + f / 2.0f, (double)pathPoint.field_75837_b + 0.1, (float)pathPoint.field_75838_c + 0.5f + f / 2.0f).func_72317_d(-d, -d2, -d3), 0.8f, 1.0f, 1.0f, 0.5f);
            }
        }
        if (bl2) {
            for (n = 0; n < path.func_75874_d(); ++n) {
                PathPoint pathPoint = path.func_75877_a(n);
                if (!(PathfindingDebugRenderer.func_229033_a_(pathPoint.func_224759_a(), d, d2, d3) <= 80.0f)) continue;
                DebugRenderer.func_217732_a(String.format("%s", new Object[]{pathPoint.field_186287_m}), (double)pathPoint.field_75839_a + 0.5, (double)pathPoint.field_75837_b + 0.75, (double)pathPoint.field_75838_c + 0.5, -1);
                DebugRenderer.func_217732_a(String.format(Locale.ROOT, "%.2f", Float.valueOf(pathPoint.field_186286_l)), (double)pathPoint.field_75839_a + 0.5, (double)pathPoint.field_75837_b + 0.25, (double)pathPoint.field_75838_c + 0.5, -1);
            }
        }
    }

    public static void func_229031_a_(Path path, double d, double d2, double d3) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        \u26032.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i < path.func_75874_d(); ++i) {
            PathPoint pathPoint = path.func_75877_a(i);
            if (PathfindingDebugRenderer.func_229033_a_(pathPoint.func_224759_a(), d, d2, d3) > 80.0f) continue;
            float \u26033 = (float)i / (float)path.func_75874_d() * 0.33f;
            int \u26034 = i == 0 ? 0 : MathHelper.func_181758_c(\u26033, 0.9f, 0.9f);
            int \u26035 = \u26034 >> 16 & 0xFF;
            int \u26036 = \u26034 >> 8 & 0xFF;
            int \u26037 = \u26034 & 0xFF;
            \u26032.func_225582_a_((double)pathPoint.field_75839_a - d + 0.5, (double)pathPoint.field_75837_b - d2 + 0.5, (double)pathPoint.field_75838_c - d3 + 0.5).func_225586_a_(\u26035, \u26036, \u26037, 255).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    private static float func_229033_a_(BlockPos blockPos, double d, double d2, double d3) {
        return (float)(Math.abs((double)blockPos.func_177958_n() - d) + Math.abs((double)blockPos.func_177956_o() - d2) + Math.abs((double)blockPos.func_177952_p() - d3));
    }
}

