/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LivingRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements IEntityRenderer<T, M> {
    private static final Logger field_147923_a = LogManager.getLogger();
    protected M field_77045_g;
    protected final List<LayerRenderer<T, M>> field_177097_h = Lists.newArrayList();

    public LivingRenderer(EntityRendererManager entityRendererManager, M m, float f) {
        super(entityRendererManager);
        this.field_77045_g = m;
        this.field_76989_e = f;
    }

    protected final boolean func_177094_a(LayerRenderer<T, M> layerRenderer) {
        return this.field_177097_h.add(layerRenderer);
    }

    @Override
    public M func_217764_d() {
        return this.field_77045_g;
    }

    @Override
    public void func_225623_a_(T t, float f, float f2, MatrixStack matrixStack2, IRenderTypeBuffer iRenderTypeBuffer, int n) {
        MatrixStack matrixStack2;
        float \u26033;
        matrixStack2.func_227860_a_();
        ((EntityModel)this.field_77045_g).field_217112_c = this.func_77040_d(t, f2);
        ((EntityModel)this.field_77045_g).field_217113_d = ((Entity)t).func_184218_aH();
        ((EntityModel)this.field_77045_g).field_217114_e = ((LivingEntity)t).func_70631_g_();
        float \u26032 = MathHelper.func_219805_h(f2, ((LivingEntity)t).field_70760_ar, ((LivingEntity)t).field_70761_aq);
        \u2603 = MathHelper.func_219805_h(f2, ((LivingEntity)t).field_70758_at, ((LivingEntity)t).field_70759_as);
        \u26033 = \u2603 - \u26032;
        if (((Entity)t).func_184218_aH() && ((Entity)t).func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)((Entity)t).func_184187_bx();
            \u26032 = MathHelper.func_219805_h(f2, livingEntity.field_70760_ar, livingEntity.field_70761_aq);
            \u26033 = \u2603 - \u26032;
            float \u26034 = MathHelper.func_76142_g(\u26033);
            if (\u26034 < -85.0f) {
                \u26034 = -85.0f;
            }
            if (\u26034 >= 85.0f) {
                \u26034 = 85.0f;
            }
            \u26032 = \u2603 - \u26034;
            if (\u26034 * \u26034 > 2500.0f) {
                \u26032 += \u26034 * 0.2f;
            }
            \u26033 = \u2603 - \u26032;
        }
        float f3 = MathHelper.func_219799_g(f2, ((LivingEntity)t).field_70127_C, ((LivingEntity)t).field_70125_A);
        if (((Entity)t).func_213283_Z() == Pose.SLEEPING && (\u2603 = ((LivingEntity)t).func_213376_dz()) != null) {
            \u2603 = ((Entity)t).func_213307_e(Pose.STANDING) - 0.1f;
            matrixStack2.func_227861_a_((float)(-\u2603.func_82601_c()) * \u2603, 0.0, (float)(-\u2603.func_82599_e()) * \u2603);
        }
        \u2603 = this.func_77044_a(t, f2);
        this.func_225621_a_(t, matrixStack2, \u2603, \u26032, f2);
        matrixStack2.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.func_225620_a_(t, matrixStack2, f2);
        matrixStack2.func_227861_a_(0.0, -1.501f, 0.0);
        \u2603 = 0.0f;
        \u2603 = 0.0f;
        if (!((Entity)t).func_184218_aH() && ((LivingEntity)t).func_70089_S()) {
            \u2603 = MathHelper.func_219799_g(f2, ((LivingEntity)t).field_184618_aE, ((LivingEntity)t).field_70721_aZ);
            \u2603 = ((LivingEntity)t).field_184619_aG - ((LivingEntity)t).field_70721_aZ * (1.0f - f2);
            if (((LivingEntity)t).func_70631_g_()) {
                \u2603 *= 3.0f;
            }
            if (\u2603 > 1.0f) {
                \u2603 = 1.0f;
            }
        }
        ((EntityModel)this.field_77045_g).func_212843_a_(t, \u2603, \u2603, f2);
        ((EntityModel)this.field_77045_g).func_225597_a_(t, \u2603, \u2603, \u2603, \u26033, f3);
        boolean \u26035 = this.func_225622_a_(t);
        boolean \u26036 = !\u26035 && !((Entity)t).func_98034_c(Minecraft.func_71410_x().field_71439_g);
        RenderType \u26037 = this.func_230042_a_(t, \u26035, \u26036);
        if (\u26037 != null) {
            IVertexBuilder iVertexBuilder = iRenderTypeBuffer.getBuffer(\u26037);
            int \u26038 = LivingRenderer.func_229117_c_(t, this.func_225625_b_(t, f2));
            ((Model)this.field_77045_g).func_225598_a_(matrixStack2, iVertexBuilder, n, \u26038, 1.0f, 1.0f, 1.0f, \u26036 ? 0.15f : 1.0f);
        }
        if (!((Entity)t).func_175149_v()) {
            for (LayerRenderer<T, M> layerRenderer : this.field_177097_h) {
                layerRenderer.func_225628_a_(matrixStack2, iRenderTypeBuffer, n, t, \u2603, \u2603, f2, \u2603, \u26033, f3);
            }
        }
        matrixStack2.func_227865_b_();
        super.func_225623_a_(t, f, f2, matrixStack2, iRenderTypeBuffer, n);
    }

    @Nullable
    protected RenderType func_230042_a_(T t, boolean bl, boolean bl2) {
        ResourceLocation resourceLocation = this.func_110775_a(t);
        if (bl2) {
            return RenderType.func_228644_e_(resourceLocation);
        }
        if (bl) {
            return ((Model)this.field_77045_g).func_228282_a_(resourceLocation);
        }
        if (((Entity)t).func_225510_bt_()) {
            return RenderType.func_228654_j_(resourceLocation);
        }
        return null;
    }

    public static int func_229117_c_(LivingEntity livingEntity, float f) {
        return OverlayTexture.func_229201_a_(OverlayTexture.func_229199_a_(f), OverlayTexture.func_229202_a_(livingEntity.field_70737_aN > 0 || livingEntity.field_70725_aQ > 0));
    }

    protected boolean func_225622_a_(T t) {
        return !((Entity)t).func_82150_aj();
    }

    private static float func_217765_a(Direction direction) {
        switch (direction) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected void func_225621_a_(T t2, MatrixStack matrixStack, float f, float f2, float f3) {
        T t2;
        Pose pose = ((Entity)t2).func_213283_Z();
        if (pose != Pose.SLEEPING) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - f2));
        }
        if (((LivingEntity)t2).field_70725_aQ > 0) {
            float f4 = ((float)((LivingEntity)t2).field_70725_aQ + f3 - 1.0f) / 20.0f * 1.6f;
            if ((f4 = MathHelper.func_76129_c(f4)) > 1.0f) {
                f4 = 1.0f;
            }
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f4 * this.func_77037_a(t2)));
        } else if (((LivingEntity)t2).func_204805_cN()) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f - ((LivingEntity)t2).field_70125_A));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)((LivingEntity)t2).field_70173_aa + f3) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction direction = ((LivingEntity)t2).func_213376_dz();
            float \u26032 = direction != null ? LivingRenderer.func_217765_a(direction) : f2;
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(\u26032));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(this.func_77037_a(t2)));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
        } else if ((((Entity)t2).func_145818_k_() || t2 instanceof PlayerEntity) && ("Dinnerbone".equals(\u2603 = TextFormatting.func_110646_a(((Entity)t2).func_200200_C_().getString())) || "Grumm".equals(\u2603)) && (!(t2 instanceof PlayerEntity) || ((PlayerEntity)t2).func_175148_a(PlayerModelPart.CAPE))) {
            matrixStack.func_227861_a_(0.0, ((Entity)t2).func_213302_cg() + 0.1f, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        }
    }

    protected float func_77040_d(T t, float f) {
        return ((LivingEntity)t).func_70678_g(f);
    }

    protected float func_77044_a(T t, float f) {
        return (float)((LivingEntity)t).field_70173_aa + f;
    }

    protected float func_77037_a(T t) {
        return 90.0f;
    }

    protected float func_225625_b_(T t, float f) {
        return 0.0f;
    }

    protected void func_225620_a_(T t, MatrixStack matrixStack, float f) {
    }

    @Override
    protected boolean func_177070_b(T t2) {
        T t2;
        double d = this.field_76990_c.func_229099_b_((Entity)t2);
        float f = \u2603 = ((Entity)t2).func_226273_bm_() ? 32.0f : 64.0f;
        if (d >= (double)(\u2603 * \u2603)) {
            return false;
        }
        Minecraft \u26032 = Minecraft.func_71410_x();
        ClientPlayerEntity \u26033 = \u26032.field_71439_g;
        boolean bl = \u2603 = !((Entity)t2).func_98034_c(\u26033);
        if (t2 != \u26033) {
            Team team = ((Entity)t2).func_96124_cp();
            \u2603 = \u26033.func_96124_cp();
            if (team != null) {
                Team.Visible visible = team.func_178770_i();
                switch (visible) {
                    case ALWAYS: {
                        return \u2603;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return \u2603 == null ? \u2603 : team.func_142054_a(\u2603) && (team.func_98297_h() || \u2603);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return \u2603 == null ? \u2603 : !team.func_142054_a(\u2603) && \u2603;
                    }
                }
                return true;
            }
        }
        return Minecraft.func_71382_s() && t2 != \u26032.func_175606_aa() && \u2603 && !((Entity)t2).func_184207_aI();
    }

    @Override
    protected /* synthetic */ boolean func_177070_b(Entity entity) {
        return this.func_177070_b((T)((LivingEntity)entity));
    }
}

