/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class ArmorLayer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends LayerRenderer<T, M> {
    protected final A field_177189_c;
    protected final A field_177186_d;
    private static final Map<String, ResourceLocation> field_177191_j = Maps.newHashMap();

    protected ArmorLayer(IEntityRenderer<T, M> iEntityRenderer, A a, A a2) {
        super(iEntityRenderer);
        this.field_177189_c = a;
        this.field_177186_d = a2;
    }

    @Override
    public void func_225628_a_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int n, T t, float f, float f2, float f3, float f4, float f5, float f6) {
        this.func_229129_a_(matrixStack, iRenderTypeBuffer, t, f, f2, f3, f4, f5, f6, EquipmentSlotType.CHEST, n);
        this.func_229129_a_(matrixStack, iRenderTypeBuffer, t, f, f2, f3, f4, f5, f6, EquipmentSlotType.LEGS, n);
        this.func_229129_a_(matrixStack, iRenderTypeBuffer, t, f, f2, f3, f4, f5, f6, EquipmentSlotType.FEET, n);
        this.func_229129_a_(matrixStack, iRenderTypeBuffer, t, f, f2, f3, f4, f5, f6, EquipmentSlotType.HEAD, n);
    }

    private void func_229129_a_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, T t, float f, float f2, float f3, float f4, float f5, float f6, EquipmentSlotType equipmentSlotType, int n) {
        ItemStack itemStack = ((LivingEntity)t).func_184582_a(equipmentSlotType);
        if (!(itemStack.func_77973_b() instanceof ArmorItem)) {
            return;
        }
        ArmorItem \u26032 = (ArmorItem)itemStack.func_77973_b();
        if (\u26032.func_185083_B_() != equipmentSlotType) {
            return;
        }
        A \u26033 = this.func_215337_a(equipmentSlotType);
        ((BipedModel)this.func_215332_c()).func_217148_a(\u26033);
        ((BipedModel)\u26033).func_212843_a_(t, f, f2, f3);
        this.func_188359_a(\u26033, equipmentSlotType);
        ((BipedModel)\u26033).func_225597_a_(t, f, f2, f4, f5, f6);
        boolean \u26034 = this.func_188363_b(equipmentSlotType);
        boolean \u26035 = itemStack.func_77962_s();
        if (\u26032 instanceof DyeableArmorItem) {
            int n2 = ((DyeableArmorItem)\u26032).func_200886_f(itemStack);
            float \u26036 = (float)(n2 >> 16 & 0xFF) / 255.0f;
            float \u26037 = (float)(n2 >> 8 & 0xFF) / 255.0f;
            float \u26038 = (float)(n2 & 0xFF) / 255.0f;
            this.func_229128_a_(matrixStack, iRenderTypeBuffer, n, \u26032, \u26035, \u26033, \u26034, \u26036, \u26037, \u26038, null);
            this.func_229128_a_(matrixStack, iRenderTypeBuffer, n, \u26032, \u26035, \u26033, \u26034, 1.0f, 1.0f, 1.0f, "overlay");
        } else {
            this.func_229128_a_(matrixStack, iRenderTypeBuffer, n, \u26032, \u26035, \u26033, \u26034, 1.0f, 1.0f, 1.0f, null);
        }
    }

    private void func_229128_a_(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int n, ArmorItem armorItem, boolean bl, A a, boolean bl2, float f, float f2, float f3, @Nullable String string) {
        IVertexBuilder iVertexBuilder = ItemRenderer.func_229113_a_(iRenderTypeBuffer, RenderType.func_228640_c_(this.func_177178_a(armorItem, bl2, string)), false, bl);
        ((AgeableModel)a).func_225598_a_(matrixStack, iVertexBuilder, n, OverlayTexture.field_229196_a_, f, f2, f3, 1.0f);
    }

    public A func_215337_a(EquipmentSlotType equipmentSlotType) {
        return this.func_188363_b(equipmentSlotType) ? this.field_177189_c : this.field_177186_d;
    }

    private boolean func_188363_b(EquipmentSlotType equipmentSlotType) {
        return equipmentSlotType == EquipmentSlotType.LEGS;
    }

    private ResourceLocation func_177178_a(ArmorItem armorItem, boolean bl, @Nullable String string) {
        \u2603 = "textures/models/armor/" + armorItem.func_200880_d().func_200897_d() + "_layer_" + (bl ? 2 : 1) + (string == null ? "" : "_" + string) + ".png";
        return field_177191_j.computeIfAbsent(\u2603, ResourceLocation::new);
    }

    protected abstract void func_188359_a(A var1, EquipmentSlotType var2);

    protected abstract void func_177194_a(A var1);
}

