/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import net.minecraft.client.renderer.texture.NativeImage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryUtil;

public class TextureUtil {
    private static final Logger field_225676_a_ = LogManager.getLogger();

    public static int func_225678_a_() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GlStateManager.func_227622_J_();
    }

    public static void func_225679_a_(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.func_227758_s_(n);
    }

    public static void func_225680_a_(int n, int n2, int n3) {
        TextureUtil.func_225683_a_(NativeImage.PixelFormatGLCode.RGBA, n, 0, n2, n3);
    }

    public static void func_225682_a_(NativeImage.PixelFormatGLCode pixelFormatGLCode, int n, int n2, int n3) {
        TextureUtil.func_225683_a_(pixelFormatGLCode, n, 0, n2, n3);
    }

    public static void func_225681_a_(int n, int n2, int n3, int n4) {
        TextureUtil.func_225683_a_(NativeImage.PixelFormatGLCode.RGBA, n, n2, n3, n4);
    }

    public static void func_225683_a_(NativeImage.PixelFormatGLCode pixelFormatGLCode, int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        TextureUtil.func_225686_b_(n);
        if (n2 >= 0) {
            GlStateManager.func_227677_b_(3553, 33085, n2);
            GlStateManager.func_227677_b_(3553, 33082, 0);
            GlStateManager.func_227677_b_(3553, 33083, n2);
            GlStateManager.func_227642_a_(3553, 34049, 0.0f);
        }
        for (\u2603 = 0; \u2603 <= n2; ++\u2603) {
            GlStateManager.func_227647_a_(3553, \u2603, pixelFormatGLCode.func_211672_a(), n3 >> \u2603, n4 >> \u2603, 0, 6408, 5121, null);
        }
    }

    private static void func_225686_b_(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.func_227760_t_(n);
    }

    public static ByteBuffer func_225684_a_(InputStream inputStream) throws IOException {
        ByteBuffer \u26033;
        if (inputStream instanceof FileInputStream) {
            FileInputStream fileInputStream = (FileInputStream)inputStream;
            FileChannel \u26032 = fileInputStream.getChannel();
            \u26033 = MemoryUtil.memAlloc((int)((int)\u26032.size() + 1));
            while (\u26032.read(\u26033) != -1) {
            }
        } else {
            \u26033 = MemoryUtil.memAlloc((int)8192);
            ReadableByteChannel \u26034 = Channels.newChannel(inputStream);
            while (\u26034.read(\u26033) != -1) {
                if (\u26033.remaining() != 0) continue;
                \u26033 = MemoryUtil.memRealloc((ByteBuffer)\u26033, (int)(\u26033.capacity() * 2));
            }
        }
        return \u26033;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String func_225687_b_(InputStream inputStream) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = TextureUtil.func_225684_a_(inputStream);
            int n = byteBuffer.position();
            byteBuffer.rewind();
            String string = MemoryUtil.memASCII((ByteBuffer)byteBuffer, (int)n);
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (byteBuffer != null) {
                MemoryUtil.memFree((Buffer)byteBuffer);
            }
        }
        return null;
    }

    public static void func_225685_a_(IntBuffer intBuffer, int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glPixelStorei((int)3312, (int)0);
        GL11.glPixelStorei((int)3313, (int)0);
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3317, (int)4);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)n, (int)n2, (int)0, (int)32993, (int)33639, (IntBuffer)intBuffer);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
    }
}

