/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.vertex;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class VertexBuffer
implements AutoCloseable {
    private int field_177365_a;
    private final VertexFormat field_177363_b;
    private int field_177364_c;

    public VertexBuffer(VertexFormat vertexFormat) {
        this.field_177363_b = vertexFormat;
        RenderSystem.glGenBuffers(n -> {
            this.field_177365_a = n;
        });
    }

    public void func_177359_a() {
        RenderSystem.glBindBuffer(34962, () -> this.field_177365_a);
    }

    public void func_227875_a_(BufferBuilder bufferBuilder) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.func_227880_c_(bufferBuilder));
        } else {
            this.func_227880_c_(bufferBuilder);
        }
    }

    public CompletableFuture<Void> func_227878_b_(BufferBuilder bufferBuilder) {
        if (!RenderSystem.isOnRenderThread()) {
            return CompletableFuture.runAsync(() -> this.func_227880_c_(bufferBuilder), runnable -> RenderSystem.recordRenderCall(runnable::run));
        }
        this.func_227880_c_(bufferBuilder);
        return CompletableFuture.completedFuture(null);
    }

    private void func_227880_c_(BufferBuilder bufferBuilder) {
        Pair<BufferBuilder.DrawState, ByteBuffer> pair = bufferBuilder.func_227832_f_();
        if (this.field_177365_a == -1) {
            return;
        }
        ByteBuffer \u26032 = (ByteBuffer)pair.getSecond();
        this.field_177364_c = \u26032.remaining() / this.field_177363_b.func_177338_f();
        this.func_177359_a();
        RenderSystem.glBufferData(34962, \u26032, 35044);
        VertexBuffer.func_177361_b();
    }

    public void func_227874_a_(Matrix4f matrix4f, int n) {
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.multMatrix(matrix4f);
        RenderSystem.drawArrays(n, 0, this.field_177364_c);
        RenderSystem.popMatrix();
    }

    public static void func_177361_b() {
        RenderSystem.glBindBuffer(34962, () -> 0);
    }

    @Override
    public void close() {
        if (this.field_177365_a >= 0) {
            RenderSystem.glDeleteBuffers(this.field_177365_a);
            this.field_177365_a = -1;
        }
    }
}

