/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.Locale;
import net.minecraft.client.resources.data.LanguageMetadataSection;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.resources.IResourcePack;
import net.minecraft.util.text.LanguageMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LanguageManager
implements IResourceManagerReloadListener {
    private static final Logger field_147648_b = LogManager.getLogger();
    protected static final Locale field_135049_a = new Locale();
    private String field_135048_c;
    private final Map<String, Language> field_135046_d = Maps.newHashMap();

    public LanguageManager(String string) {
        this.field_135048_c = string;
        I18n.func_135051_a(field_135049_a);
    }

    public void func_135043_a(List<IResourcePack> list) {
        this.field_135046_d.clear();
        for (IResourcePack iResourcePack : list) {
            try {
                LanguageMetadataSection languageMetadataSection = iResourcePack.func_195760_a(LanguageMetadataSection.field_195818_a);
                if (languageMetadataSection == null) continue;
                for (Language language : languageMetadataSection.func_135018_a()) {
                    if (this.field_135046_d.containsKey(language.getCode())) continue;
                    this.field_135046_d.put(language.getCode(), language);
                }
            }
            catch (IOException | RuntimeException exception) {
                field_147648_b.warn("Unable to parse language metadata section of resourcepack: {}", (Object)iResourcePack.func_195762_a(), (Object)exception);
            }
        }
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{"en_us"});
        if (!"en_us".equals(this.field_135048_c)) {
            arrayList.add(this.field_135048_c);
        }
        field_135049_a.func_195811_a(iResourceManager, arrayList);
        LanguageMap.func_135063_a(LanguageManager.field_135049_a.field_135032_a);
    }

    public boolean func_135044_b() {
        return this.func_135041_c() != null && this.func_135041_c().func_135035_b();
    }

    public void func_135045_a(Language language) {
        this.field_135048_c = language.getCode();
    }

    public Language func_135041_c() {
        String string = this.field_135046_d.containsKey(this.field_135048_c) ? this.field_135048_c : "en_us";
        return this.field_135046_d.get(string);
    }

    public SortedSet<Language> func_135040_d() {
        return Sets.newTreeSet(this.field_135046_d.values());
    }

    public Language func_191960_a(String string) {
        return this.field_135046_d.get(string);
    }
}

