/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.InsecureTextureException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DownloadingTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public class SkinManager {
    private final TextureManager field_152795_c;
    private final File field_152796_d;
    private final MinecraftSessionService field_152797_e;
    private final LoadingCache<GameProfile, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>> field_152798_f;

    public SkinManager(TextureManager textureManager, File file, MinecraftSessionService minecraftSessionService) {
        this.field_152795_c = textureManager;
        this.field_152796_d = file;
        this.field_152797_e = minecraftSessionService;
        this.field_152798_f = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<GameProfile, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>>(){

            public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> load(GameProfile gameProfile) throws Exception {
                try {
                    return Minecraft.func_71410_x().func_152347_ac().getTextures(gameProfile, false);
                }
                catch (Throwable throwable) {
                    return Maps.newHashMap();
                }
            }

            public /* synthetic */ Object load(Object object) throws Exception {
                return this.load((GameProfile)object);
            }
        });
    }

    public ResourceLocation func_152792_a(MinecraftProfileTexture minecraftProfileTexture, MinecraftProfileTexture.Type type) {
        return this.func_152789_a(minecraftProfileTexture, type, null);
    }

    public ResourceLocation func_152789_a(MinecraftProfileTexture minecraftProfileTexture, MinecraftProfileTexture.Type type, @Nullable ISkinAvailableCallback iSkinAvailableCallback) {
        String string = Hashing.sha1().hashUnencodedChars((CharSequence)minecraftProfileTexture.getHash()).toString();
        ResourceLocation \u26032 = new ResourceLocation("skins/" + string);
        Texture \u26033 = this.field_152795_c.func_229267_b_(\u26032);
        if (\u26033 != null) {
            if (iSkinAvailableCallback != null) {
                iSkinAvailableCallback.onSkinTextureAvailable(type, \u26032, minecraftProfileTexture);
            }
        } else {
            File file = new File(this.field_152796_d, string.length() > 2 ? string.substring(0, 2) : "xx");
            \u2603 = new File(file, string);
            DownloadingTexture \u26034 = new DownloadingTexture(\u2603, minecraftProfileTexture.getUrl(), DefaultPlayerSkin.func_177335_a(), type == MinecraftProfileTexture.Type.SKIN, () -> {
                if (iSkinAvailableCallback != null) {
                    iSkinAvailableCallback.onSkinTextureAvailable(type, \u26032, minecraftProfileTexture);
                }
            });
            this.field_152795_c.func_229263_a_(\u26032, \u26034);
        }
        return \u26032;
    }

    public void func_152790_a(GameProfile gameProfile, ISkinAvailableCallback iSkinAvailableCallback, boolean bl) {
        Runnable runnable = () -> {
            HashMap hashMap = Maps.newHashMap();
            try {
                hashMap.putAll(this.field_152797_e.getTextures(gameProfile, bl));
            }
            catch (InsecureTextureException insecureTextureException) {
                // empty catch block
            }
            if (hashMap.isEmpty()) {
                gameProfile.getProperties().clear();
                if (gameProfile.getId().equals(Minecraft.func_71410_x().func_110432_I().func_148256_e().getId())) {
                    gameProfile.getProperties().putAll((Multimap)Minecraft.func_71410_x().func_181037_M());
                    hashMap.putAll(this.field_152797_e.getTextures(gameProfile, false));
                } else {
                    this.field_152797_e.fillProfileProperties(gameProfile, bl);
                    try {
                        hashMap.putAll(this.field_152797_e.getTextures(gameProfile, bl));
                    }
                    catch (InsecureTextureException insecureTextureException) {
                        // empty catch block
                    }
                }
            }
            Minecraft.func_71410_x().execute(() -> RenderSystem.recordRenderCall(() -> ImmutableList.of((Object)MinecraftProfileTexture.Type.SKIN, (Object)MinecraftProfileTexture.Type.CAPE).forEach(type -> {
                if (hashMap.containsKey(type)) {
                    this.func_152789_a((MinecraftProfileTexture)hashMap.get(type), (MinecraftProfileTexture.Type)type, iSkinAvailableCallback);
                }
            })));
        };
        Util.func_215072_e().execute(runnable);
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> func_152788_a(GameProfile gameProfile) {
        return (Map)this.field_152798_f.getUnchecked((Object)gameProfile);
    }

    public static interface ISkinAvailableCallback {
        public void onSkinTextureAvailable(MinecraftProfileTexture.Type var1, ResourceLocation var2, MinecraftProfileTexture var3);
    }
}

