/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.settings;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Monitor;
import net.minecraft.client.renderer.VideoMode;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.SliderPercentageOption;

public class FullscreenResolutionOption
extends SliderPercentageOption {
    public FullscreenResolutionOption(MainWindow mainWindow) {
        this(mainWindow, mainWindow.func_224796_s());
    }

    private FullscreenResolutionOption(MainWindow mainWindow, @Nullable Monitor monitor) {
        super("options.fullscreen.resolution", -1.0, monitor != null ? (double)(monitor.func_197994_e() - 1) : -1.0, 1.0f, gameSettings -> {
            if (monitor == null) {
                return -1.0;
            }
            Optional<VideoMode> optional = mainWindow.func_198106_d();
            return optional.map(videoMode -> monitor.func_224794_a((VideoMode)videoMode)).orElse(-1.0);
        }, (gameSettings, d) -> {
            if (monitor == null) {
                return;
            }
            if (d == -1.0) {
                mainWindow.func_224797_a(Optional.empty());
            } else {
                mainWindow.func_224797_a(Optional.of(monitor.func_197991_a(d.intValue())));
            }
        }, (gameSettings, sliderPercentageOption) -> {
            if (monitor == null) {
                return I18n.func_135052_a("options.fullscreen.unavailable", new Object[0]);
            }
            double d = sliderPercentageOption.func_216729_a((GameSettings)gameSettings);
            String \u26032 = sliderPercentageOption.func_216617_a();
            if (d == -1.0) {
                return \u26032 + I18n.func_135052_a("options.fullscreen.current", new Object[0]);
            }
            return monitor.func_197991_a((int)d).toString();
        });
    }
}

