/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.IShaderManager;
import net.minecraft.client.shader.ShaderDefault;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.client.shader.ShaderLoader;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.client.util.JSONBlendingMode;
import net.minecraft.client.util.JSONException;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShaderInstance
implements IShaderManager,
AutoCloseable {
    private static final Logger field_216545_a = LogManager.getLogger();
    private static final ShaderDefault field_216546_b = new ShaderDefault();
    private static ShaderInstance field_216547_c;
    private static int field_216548_d;
    private final Map<String, Object> field_216549_e = Maps.newHashMap();
    private final List<String> field_216550_f = Lists.newArrayList();
    private final List<Integer> field_216551_g = Lists.newArrayList();
    private final List<ShaderUniform> field_216552_h = Lists.newArrayList();
    private final List<Integer> field_216553_i = Lists.newArrayList();
    private final Map<String, ShaderUniform> field_216554_j = Maps.newHashMap();
    private final int field_216555_k;
    private final String field_216556_l;
    private final boolean field_216557_m;
    private boolean field_216558_n;
    private final JSONBlendingMode field_216559_o;
    private final List<Integer> field_216560_p;
    private final List<String> field_216561_q;
    private final ShaderLoader field_216562_r;
    private final ShaderLoader field_216563_s;

    public ShaderInstance(IResourceManager iResourceManager, String string) throws IOException {
        ResourceLocation resourceLocation = new ResourceLocation("shaders/program/" + string + ".json");
        this.field_216556_l = string;
        IResource \u26032 = null;
        try {
            JsonArray jsonArray;
            JsonArray jsonArray2;
            \u26032 = iResourceManager.func_199002_a(resourceLocation);
            JsonObject jsonObject = JSONUtils.func_212743_a(new InputStreamReader(\u26032.func_199027_b(), StandardCharsets.UTF_8));
            String \u26033 = JSONUtils.func_151200_h(jsonObject, "vertex");
            String \u26034 = JSONUtils.func_151200_h(jsonObject, "fragment");
            JsonArray \u26035 = JSONUtils.func_151213_a(jsonObject, "samplers", null);
            if (\u26035 != null) {
                int n = 0;
                for (Object object : \u26035) {
                    try {
                        this.func_216541_a((JsonElement)object);
                    }
                    catch (Exception exception) {
                        JSONException jSONException = JSONException.func_151379_a(exception);
                        jSONException.func_151380_a("samplers[" + n + "]");
                        throw jSONException;
                    }
                    ++n;
                }
            }
            if ((jsonArray2 = JSONUtils.func_151213_a(jsonObject, "attributes", null)) != null) {
                int n = 0;
                this.field_216560_p = Lists.newArrayListWithCapacity((int)jsonArray2.size());
                this.field_216561_q = Lists.newArrayListWithCapacity((int)jsonArray2.size());
                for (JsonElement jsonElement : jsonArray2) {
                    try {
                        this.field_216561_q.add(JSONUtils.func_151206_a(jsonElement, "attribute"));
                    }
                    catch (Exception exception) {
                        JSONException jSONException = JSONException.func_151379_a(exception);
                        jSONException.func_151380_a("attributes[" + n + "]");
                        throw jSONException;
                    }
                    ++n;
                }
            } else {
                this.field_216560_p = null;
                this.field_216561_q = null;
            }
            if ((jsonArray = JSONUtils.func_151213_a(jsonObject, "uniforms", null)) != null) {
                int n = 0;
                for (JsonElement jsonElement : jsonArray) {
                    try {
                        this.func_216540_b(jsonElement);
                    }
                    catch (Exception exception) {
                        JSONException jSONException = JSONException.func_151379_a(exception);
                        jSONException.func_151380_a("uniforms[" + n + "]");
                        throw jSONException;
                    }
                    ++n;
                }
            }
            this.field_216559_o = ShaderInstance.func_216543_a(JSONUtils.func_151218_a(jsonObject, "blend", null));
            this.field_216557_m = JSONUtils.func_151209_a(jsonObject, "cull", true);
            this.field_216562_r = ShaderInstance.func_216542_a(iResourceManager, ShaderLoader.ShaderType.VERTEX, \u26033);
            this.field_216563_s = ShaderInstance.func_216542_a(iResourceManager, ShaderLoader.ShaderType.FRAGMENT, \u26034);
            this.field_216555_k = ShaderLinkHelper.func_148078_c();
            ShaderLinkHelper.func_148075_b(this);
            this.func_216536_h();
            if (this.field_216561_q != null) {
                for (String string2 : this.field_216561_q) {
                    int n = ShaderUniform.func_227807_b_(this.field_216555_k, string2);
                    this.field_216560_p.add(n);
                }
            }
        }
        catch (Exception exception) {
            JSONException jSONException = JSONException.func_151379_a(exception);
            jSONException.func_151381_b(resourceLocation.func_110623_a());
            throw jSONException;
        }
        finally {
            IOUtils.closeQuietly((Closeable)\u26032);
        }
        this.func_147985_d();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShaderLoader func_216542_a(IResourceManager iResourceManager, ShaderLoader.ShaderType shaderType, String string) throws IOException {
        ShaderLoader shaderLoader = shaderType.func_148064_d().get(string);
        if (shaderLoader == null) {
            ResourceLocation resourceLocation = new ResourceLocation("shaders/program/" + string + shaderType.func_148063_b());
            IResource \u26032 = iResourceManager.func_199002_a(resourceLocation);
            try {
                shaderLoader = ShaderLoader.func_216534_a(shaderType, string, \u26032.func_199027_b());
            }
            finally {
                IOUtils.closeQuietly((Closeable)\u26032);
            }
        }
        return shaderLoader;
    }

    public static JSONBlendingMode func_216543_a(JsonObject jsonObject) {
        if (jsonObject == null) {
            return new JSONBlendingMode();
        }
        int n = 32774;
        \u2603 = 1;
        \u2603 = 0;
        \u2603 = 1;
        \u2603 = 0;
        boolean \u26032 = true;
        boolean \u26033 = false;
        if (JSONUtils.func_151205_a(jsonObject, "func") && (n = JSONBlendingMode.func_148108_a(jsonObject.get("func").getAsString())) != 32774) {
            \u26032 = false;
        }
        if (JSONUtils.func_151205_a(jsonObject, "srcrgb") && (\u2603 = JSONBlendingMode.func_148107_b(jsonObject.get("srcrgb").getAsString())) != 1) {
            \u26032 = false;
        }
        if (JSONUtils.func_151205_a(jsonObject, "dstrgb") && (\u2603 = JSONBlendingMode.func_148107_b(jsonObject.get("dstrgb").getAsString())) != 0) {
            \u26032 = false;
        }
        if (JSONUtils.func_151205_a(jsonObject, "srcalpha")) {
            \u2603 = JSONBlendingMode.func_148107_b(jsonObject.get("srcalpha").getAsString());
            if (\u2603 != 1) {
                \u26032 = false;
            }
            \u26033 = true;
        }
        if (JSONUtils.func_151205_a(jsonObject, "dstalpha")) {
            \u2603 = JSONBlendingMode.func_148107_b(jsonObject.get("dstalpha").getAsString());
            if (\u2603 != 0) {
                \u26032 = false;
            }
            \u26033 = true;
        }
        if (\u26032) {
            return new JSONBlendingMode();
        }
        if (\u26033) {
            return new JSONBlendingMode(\u2603, \u2603, \u2603, \u2603, n);
        }
        return new JSONBlendingMode(\u2603, \u2603, n);
    }

    @Override
    public void close() {
        for (ShaderUniform shaderUniform : this.field_216552_h) {
            shaderUniform.close();
        }
        ShaderLinkHelper.func_148077_a(this);
    }

    public void func_216544_e() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        ShaderLinkHelper.func_227804_a_(0);
        field_216548_d = -1;
        field_216547_c = null;
        for (int i = 0; i < this.field_216551_g.size(); ++i) {
            if (this.field_216549_e.get(this.field_216550_f.get(i)) == null) continue;
            GlStateManager.func_227756_r_(33984 + i);
            GlStateManager.func_227760_t_(0);
        }
    }

    public void func_216535_f() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        this.field_216558_n = false;
        field_216547_c = this;
        this.field_216559_o.func_148109_a();
        if (this.field_216555_k != field_216548_d) {
            ShaderLinkHelper.func_227804_a_(this.field_216555_k);
            field_216548_d = this.field_216555_k;
        }
        if (this.field_216557_m) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
        for (int i = 0; i < this.field_216551_g.size(); ++i) {
            if (this.field_216549_e.get(this.field_216550_f.get(i)) == null) continue;
            RenderSystem.activeTexture(33984 + i);
            RenderSystem.enableTexture();
            Object object = this.field_216549_e.get(this.field_216550_f.get(i));
            int \u26032 = -1;
            if (object instanceof Framebuffer) {
                \u26032 = ((Framebuffer)object).field_147617_g;
            } else if (object instanceof Texture) {
                \u26032 = ((Texture)object).func_110552_b();
            } else if (object instanceof Integer) {
                \u26032 = (Integer)object;
            }
            if (\u26032 == -1) continue;
            RenderSystem.bindTexture(\u26032);
            ShaderUniform.func_227805_a_(ShaderUniform.func_227806_a_(this.field_216555_k, this.field_216550_f.get(i)), i);
        }
        for (ShaderUniform shaderUniform : this.field_216552_h) {
            shaderUniform.func_148093_b();
        }
    }

    @Override
    public void func_147985_d() {
        this.field_216558_n = true;
    }

    @Nullable
    public ShaderUniform func_216539_a(String string) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return this.field_216554_j.get(string);
    }

    public ShaderDefault func_216538_b(String string) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        ShaderUniform shaderUniform = this.func_216539_a(string);
        return shaderUniform == null ? field_216546_b : shaderUniform;
    }

    private void func_216536_h() {
        int \u26032;
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        int n = 0;
        \u2603 = 0;
        while (n < this.field_216550_f.size()) {
            String string = this.field_216550_f.get(n);
            \u26032 = ShaderUniform.func_227806_a_(this.field_216555_k, string);
            if (\u26032 == -1) {
                field_216545_a.warn("Shader {}could not find sampler named {} in the specified shader program.", (Object)this.field_216556_l, (Object)string);
                this.field_216549_e.remove(string);
                this.field_216550_f.remove(\u2603);
                --\u2603;
            } else {
                this.field_216551_g.add(\u26032);
            }
            ++n;
            ++\u2603;
        }
        for (ShaderUniform \u26033 : this.field_216552_h) {
            string = \u26033.func_148086_a();
            \u26032 = ShaderUniform.func_227806_a_(this.field_216555_k, string);
            if (\u26032 == -1) {
                field_216545_a.warn("Could not find uniform named {} in the specified shader program.", (Object)string);
                continue;
            }
            this.field_216553_i.add(\u26032);
            \u26033.func_148084_b(\u26032);
            this.field_216554_j.put(string, \u26033);
        }
    }

    private void func_216541_a(JsonElement jsonElement) {
        JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "sampler");
        String \u26032 = JSONUtils.func_151200_h(jsonObject, "name");
        if (!JSONUtils.func_151205_a(jsonObject, "file")) {
            this.field_216549_e.put(\u26032, null);
            this.field_216550_f.add(\u26032);
            return;
        }
        this.field_216550_f.add(\u26032);
    }

    public void func_216537_a(String string, Object object) {
        if (this.field_216549_e.containsKey(string)) {
            this.field_216549_e.remove(string);
        }
        this.field_216549_e.put(string, object);
        this.func_147985_d();
    }

    private void func_216540_b(JsonElement jsonElement) throws JSONException {
        Object \u260382;
        JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "uniform");
        String \u26032 = JSONUtils.func_151200_h(jsonObject, "name");
        int \u26033 = ShaderUniform.func_148085_a(JSONUtils.func_151200_h(jsonObject, "type"));
        int \u26034 = JSONUtils.func_151203_m(jsonObject, "count");
        float[] \u26035 = new float[Math.max(\u26034, 16)];
        JsonArray \u26036 = JSONUtils.func_151214_t(jsonObject, "values");
        if (\u26036.size() != \u26034 && \u26036.size() > 1) {
            throw new JSONException("Invalid amount of values specified (expected " + \u26034 + ", found " + \u26036.size() + ")");
        }
        int \u26037 = 0;
        for (Object \u260382 : \u26036) {
            try {
                \u26035[\u26037] = JSONUtils.func_151220_d((JsonElement)\u260382, "value");
            }
            catch (Exception exception) {
                JSONException jSONException = JSONException.func_151379_a(exception);
                jSONException.func_151380_a("values[" + \u26037 + "]");
                throw jSONException;
            }
            ++\u26037;
        }
        if (\u26034 > 1 && \u26036.size() == 1) {
            while (\u26037 < \u26034) {
                \u26035[\u26037] = \u26035[0];
                ++\u26037;
            }
        }
        int n = \u26034 > 1 && \u26034 <= 4 && \u26033 < 8 ? \u26034 - 1 : 0;
        \u260382 = new ShaderUniform(\u26032, \u26033 + n, \u26034, this);
        if (\u26033 <= 3) {
            ((ShaderUniform)\u260382).func_148083_a((int)\u26035[0], (int)\u26035[1], (int)\u26035[2], (int)\u26035[3]);
        } else if (\u26033 <= 7) {
            ((ShaderUniform)\u260382).func_148092_b(\u26035[0], \u26035[1], \u26035[2], \u26035[3]);
        } else {
            ((ShaderUniform)\u260382).func_148097_a(\u26035);
        }
        this.field_216552_h.add((ShaderUniform)\u260382);
    }

    @Override
    public ShaderLoader func_147989_e() {
        return this.field_216562_r;
    }

    @Override
    public ShaderLoader func_147994_f() {
        return this.field_216563_s;
    }

    @Override
    public int func_147986_h() {
        return this.field_216555_k;
    }

    static {
        field_216548_d = -1;
    }
}

