/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.shader.IShaderManager;
import net.minecraft.client.shader.ShaderDefault;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.MemoryUtil;

public class ShaderUniform
extends ShaderDefault
implements AutoCloseable {
    private static final Logger field_148104_a = LogManager.getLogger();
    private int field_148102_b;
    private final int field_148103_c;
    private final int field_148100_d;
    private final IntBuffer field_148101_e;
    private final FloatBuffer field_148098_f;
    private final String field_148099_g;
    private boolean field_148105_h;
    private final IShaderManager field_148106_i;

    public ShaderUniform(String string, int n, int n2, IShaderManager iShaderManager) {
        this.field_148099_g = string;
        this.field_148103_c = n2;
        this.field_148100_d = n;
        this.field_148106_i = iShaderManager;
        if (n <= 3) {
            this.field_148101_e = MemoryUtil.memAllocInt((int)n2);
            this.field_148098_f = null;
        } else {
            this.field_148101_e = null;
            this.field_148098_f = MemoryUtil.memAllocFloat((int)n2);
        }
        this.field_148102_b = -1;
        this.func_148096_h();
    }

    public static int func_227806_a_(int n, CharSequence charSequence) {
        return GlStateManager.func_227680_b_(n, charSequence);
    }

    public static void func_227805_a_(int n, int n2) {
        RenderSystem.glUniform1i(n, n2);
    }

    public static int func_227807_b_(int n, CharSequence charSequence) {
        return GlStateManager.func_227695_c_(n, charSequence);
    }

    @Override
    public void close() {
        if (this.field_148101_e != null) {
            MemoryUtil.memFree((Buffer)this.field_148101_e);
        }
        if (this.field_148098_f != null) {
            MemoryUtil.memFree((Buffer)this.field_148098_f);
        }
    }

    private void func_148096_h() {
        this.field_148105_h = true;
        if (this.field_148106_i != null) {
            this.field_148106_i.func_147985_d();
        }
    }

    public static int func_148085_a(String string) {
        int n = -1;
        if ("int".equals(string)) {
            n = 0;
        } else if ("float".equals(string)) {
            n = 4;
        } else if (string.startsWith("matrix")) {
            if (string.endsWith("2x2")) {
                n = 8;
            } else if (string.endsWith("3x3")) {
                n = 9;
            } else if (string.endsWith("4x4")) {
                n = 10;
            }
        }
        return n;
    }

    public void func_148084_b(int n) {
        this.field_148102_b = n;
    }

    public String func_148086_a() {
        return this.field_148099_g;
    }

    @Override
    public void func_148090_a(float f) {
        this.field_148098_f.position(0);
        this.field_148098_f.put(0, f);
        this.func_148096_h();
    }

    @Override
    public void func_148087_a(float f, float f2) {
        this.field_148098_f.position(0);
        this.field_148098_f.put(0, f);
        this.field_148098_f.put(1, f2);
        this.func_148096_h();
    }

    @Override
    public void func_148095_a(float f, float f2, float f3) {
        this.field_148098_f.position(0);
        this.field_148098_f.put(0, f);
        this.field_148098_f.put(1, f2);
        this.field_148098_f.put(2, f3);
        this.func_148096_h();
    }

    @Override
    public void func_148081_a(float f, float f2, float f3, float f4) {
        this.field_148098_f.position(0);
        this.field_148098_f.put(f);
        this.field_148098_f.put(f2);
        this.field_148098_f.put(f3);
        this.field_148098_f.put(f4);
        this.field_148098_f.flip();
        this.func_148096_h();
    }

    @Override
    public void func_148092_b(float f, float f2, float f3, float f4) {
        this.field_148098_f.position(0);
        if (this.field_148100_d >= 4) {
            this.field_148098_f.put(0, f);
        }
        if (this.field_148100_d >= 5) {
            this.field_148098_f.put(1, f2);
        }
        if (this.field_148100_d >= 6) {
            this.field_148098_f.put(2, f3);
        }
        if (this.field_148100_d >= 7) {
            this.field_148098_f.put(3, f4);
        }
        this.func_148096_h();
    }

    @Override
    public void func_148083_a(int n, int n2, int n3, int n4) {
        this.field_148101_e.position(0);
        if (this.field_148100_d >= 0) {
            this.field_148101_e.put(0, n);
        }
        if (this.field_148100_d >= 1) {
            this.field_148101_e.put(1, n2);
        }
        if (this.field_148100_d >= 2) {
            this.field_148101_e.put(2, n3);
        }
        if (this.field_148100_d >= 3) {
            this.field_148101_e.put(3, n4);
        }
        this.func_148096_h();
    }

    @Override
    public void func_148097_a(float[] fArray) {
        if (fArray.length < this.field_148103_c) {
            field_148104_a.warn("Uniform.set called with a too-small value array (expected {}, got {}). Ignoring.", (Object)this.field_148103_c, (Object)fArray.length);
            return;
        }
        this.field_148098_f.position(0);
        this.field_148098_f.put(fArray);
        this.field_148098_f.position(0);
        this.func_148096_h();
    }

    @Override
    public void func_195652_a(Matrix4f matrix4f) {
        this.field_148098_f.position(0);
        matrix4f.func_195879_b(this.field_148098_f);
        this.func_148096_h();
    }

    public void func_148093_b() {
        if (!this.field_148105_h) {
            // empty if block
        }
        this.field_148105_h = false;
        if (this.field_148100_d <= 3) {
            this.func_148091_i();
        } else if (this.field_148100_d <= 7) {
            this.func_148089_j();
        } else if (this.field_148100_d <= 10) {
            this.func_148082_k();
        } else {
            field_148104_a.warn("Uniform.upload called, but type value ({}) is not a valid type. Ignoring.", (Object)this.field_148100_d);
            return;
        }
    }

    private void func_148091_i() {
        this.field_148098_f.clear();
        switch (this.field_148100_d) {
            case 0: {
                RenderSystem.glUniform1(this.field_148102_b, this.field_148101_e);
                break;
            }
            case 1: {
                RenderSystem.glUniform2(this.field_148102_b, this.field_148101_e);
                break;
            }
            case 2: {
                RenderSystem.glUniform3(this.field_148102_b, this.field_148101_e);
                break;
            }
            case 3: {
                RenderSystem.glUniform4(this.field_148102_b, this.field_148101_e);
                break;
            }
            default: {
                field_148104_a.warn("Uniform.upload called, but count value ({}) is  not in the range of 1 to 4. Ignoring.", (Object)this.field_148103_c);
            }
        }
    }

    private void func_148089_j() {
        this.field_148098_f.clear();
        switch (this.field_148100_d) {
            case 4: {
                RenderSystem.glUniform1(this.field_148102_b, this.field_148098_f);
                break;
            }
            case 5: {
                RenderSystem.glUniform2(this.field_148102_b, this.field_148098_f);
                break;
            }
            case 6: {
                RenderSystem.glUniform3(this.field_148102_b, this.field_148098_f);
                break;
            }
            case 7: {
                RenderSystem.glUniform4(this.field_148102_b, this.field_148098_f);
                break;
            }
            default: {
                field_148104_a.warn("Uniform.upload called, but count value ({}) is not in the range of 1 to 4. Ignoring.", (Object)this.field_148103_c);
            }
        }
    }

    private void func_148082_k() {
        this.field_148098_f.clear();
        switch (this.field_148100_d) {
            case 8: {
                RenderSystem.glUniformMatrix2(this.field_148102_b, false, this.field_148098_f);
                break;
            }
            case 9: {
                RenderSystem.glUniformMatrix3(this.field_148102_b, false, this.field_148098_f);
                break;
            }
            case 10: {
                RenderSystem.glUniformMatrix4(this.field_148102_b, false, this.field_148098_f);
            }
        }
    }
}

