/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.EntityTickableSound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.particle.FireworkParticle;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.color.ColorCache;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.profiler.IProfiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.EmptyTickList;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.ITickList;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldInfo;

public class ClientWorld
extends World {
    private final List<Entity> field_217428_a = Lists.newArrayList();
    private final Int2ObjectMap<Entity> field_217429_b = new Int2ObjectOpenHashMap();
    private final ClientPlayNetHandler field_73035_a;
    private final WorldRenderer field_217430_d;
    private final Minecraft field_73037_M = Minecraft.func_71410_x();
    private final List<AbstractClientPlayerEntity> field_217431_w = Lists.newArrayList();
    private int field_184158_M = this.field_73012_v.nextInt(12000);
    private Scoreboard field_200261_M = new Scoreboard();
    private final Map<String, MapData> field_217432_z = Maps.newHashMap();
    private int field_228314_A_;
    private final Object2ObjectArrayMap<ColorResolver, ColorCache> field_228315_B_ = Util.func_200696_a(new Object2ObjectArrayMap(3), object2ObjectArrayMap -> {
        object2ObjectArrayMap.put((Object)BiomeColors.field_180291_a, (Object)new ColorCache());
        object2ObjectArrayMap.put((Object)BiomeColors.field_180289_b, (Object)new ColorCache());
        object2ObjectArrayMap.put((Object)BiomeColors.field_180290_c, (Object)new ColorCache());
    });

    public ClientWorld(ClientPlayNetHandler clientPlayNetHandler, WorldSettings worldSettings, DimensionType dimensionType, int n, IProfiler iProfiler, WorldRenderer worldRenderer) {
        super(new WorldInfo(worldSettings, "MpServer"), dimensionType, (world, dimension) -> new ClientChunkProvider((ClientWorld)world, n), iProfiler, true);
        this.field_73035_a = clientPlayNetHandler;
        this.field_217430_d = worldRenderer;
        this.func_175652_B(new BlockPos(8, 64, 8));
        this.func_72966_v();
        this.func_72947_a();
    }

    public void func_72835_b(BooleanSupplier booleanSupplier) {
        this.func_175723_af().func_212673_r();
        this.func_217389_a();
        this.func_217381_Z().func_76320_a("blocks");
        this.field_73020_y.func_217207_a(booleanSupplier);
        this.func_217426_j();
        this.func_217381_Z().func_76319_b();
    }

    public Iterable<Entity> func_217416_b() {
        return Iterables.concat((Iterable)this.field_217429_b.values(), this.field_217428_a);
    }

    public void func_217419_d() {
        Entity entity2;
        IProfiler iProfiler = this.func_217381_Z();
        iProfiler.func_76320_a("entities");
        iProfiler.func_76320_a("global");
        for (int i = 0; i < this.field_217428_a.size(); ++i) {
            entity2 = this.field_217428_a.get(i);
            this.func_217390_a(entity -> {
                ++entity.field_70173_aa;
                entity.func_70071_h_();
            }, entity2);
            if (!entity2.field_70128_L) continue;
            this.field_217428_a.remove(i--);
        }
        iProfiler.func_219895_b("regular");
        ObjectIterator \u26032 = this.field_217429_b.int2ObjectEntrySet().iterator();
        while (\u26032.hasNext()) {
            entity2 = (Int2ObjectMap.Entry)\u26032.next();
            \u2603 = (Entity)entity2.getValue();
            if (\u2603.func_184218_aH()) continue;
            iProfiler.func_76320_a("tick");
            if (!\u2603.field_70128_L) {
                this.func_217390_a(this::func_217418_a, \u2603);
            }
            iProfiler.func_76319_b();
            iProfiler.func_76320_a("remove");
            if (\u2603.field_70128_L) {
                \u26032.remove();
                this.func_217414_d(\u2603);
            }
            iProfiler.func_76319_b();
        }
        iProfiler.func_76319_b();
        this.func_217391_K();
        iProfiler.func_76319_b();
    }

    public void func_217418_a(Entity entity) {
        if (!(entity instanceof PlayerEntity) && !this.func_72863_F().func_217204_a(entity)) {
            return;
        }
        entity.func_226286_f_(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        entity.field_70126_B = entity.field_70177_z;
        entity.field_70127_C = entity.field_70125_A;
        if (entity.field_70175_ag || entity.func_175149_v()) {
            ++entity.field_70173_aa;
            this.func_217381_Z().func_194340_a(() -> Registry.field_212629_r.func_177774_c(entity.func_200600_R()).toString());
            entity.func_70071_h_();
            this.func_217381_Z().func_76319_b();
        }
        this.func_217423_b(entity);
        if (entity.field_70175_ag) {
            for (Entity entity2 : entity.func_184188_bt()) {
                this.func_217420_a(entity, entity2);
            }
        }
    }

    public void func_217420_a(Entity entity, Entity entity2) {
        if (entity2.field_70128_L || entity2.func_184187_bx() != entity) {
            entity2.func_184210_p();
            return;
        }
        if (!(entity2 instanceof PlayerEntity) && !this.func_72863_F().func_217204_a(entity2)) {
            return;
        }
        entity2.func_226286_f_(entity2.func_226277_ct_(), entity2.func_226278_cu_(), entity2.func_226281_cx_());
        entity2.field_70126_B = entity2.field_70177_z;
        entity2.field_70127_C = entity2.field_70125_A;
        if (entity2.field_70175_ag) {
            ++entity2.field_70173_aa;
            entity2.func_70098_U();
        }
        this.func_217423_b(entity2);
        if (entity2.field_70175_ag) {
            for (Entity entity3 : entity2.func_184188_bt()) {
                this.func_217420_a(entity2, entity3);
            }
        }
    }

    public void func_217423_b(Entity entity) {
        this.func_217381_Z().func_76320_a("chunkCheck");
        int n = MathHelper.func_76128_c(entity.func_226277_ct_() / 16.0);
        \u2603 = MathHelper.func_76128_c(entity.func_226278_cu_() / 16.0);
        \u2603 = MathHelper.func_76128_c(entity.func_226281_cx_() / 16.0);
        if (!entity.field_70175_ag || entity.field_70176_ah != n || entity.field_70162_ai != \u2603 || entity.field_70164_aj != \u2603) {
            if (entity.field_70175_ag && this.func_217354_b(entity.field_70176_ah, entity.field_70164_aj)) {
                this.func_212866_a_(entity.field_70176_ah, entity.field_70164_aj).func_76608_a(entity, entity.field_70162_ai);
            }
            if (entity.func_184189_br() || this.func_217354_b(n, \u2603)) {
                this.func_212866_a_(n, \u2603).func_76612_a(entity);
            } else {
                entity.field_70175_ag = false;
            }
        }
        this.func_217381_Z().func_76319_b();
    }

    public void func_217409_a(Chunk chunk) {
        this.field_147483_b.addAll(chunk.func_177434_r().values());
        this.field_73020_y.func_212863_j_().func_215571_a(chunk.func_76632_l(), false);
    }

    public void func_228323_e_(int n, int n2) {
        this.field_228315_B_.forEach((colorResolver, colorCache) -> colorCache.func_228070_a_(n, n2));
    }

    public void func_228327_h_() {
        this.field_228315_B_.forEach((colorResolver, colorCache) -> colorCache.func_228069_a_());
    }

    @Override
    public boolean func_217354_b(int n, int n2) {
        return true;
    }

    private void func_217426_j() {
        if (this.field_73037_M.field_71439_g == null) {
            return;
        }
        if (this.field_184158_M > 0) {
            --this.field_184158_M;
            return;
        }
        BlockPos blockPos = new BlockPos(this.field_73037_M.field_71439_g);
        \u2603 = blockPos.func_177982_a(4 * (this.field_73012_v.nextInt(3) - 1), 4 * (this.field_73012_v.nextInt(3) - 1), 4 * (this.field_73012_v.nextInt(3) - 1));
        double \u26032 = blockPos.func_177951_i(\u2603);
        if (\u26032 >= 4.0 && \u26032 <= 256.0 && (\u2603 = this.func_180495_p(\u2603)).func_196958_f() && this.func_226659_b_(\u2603, 0) <= this.field_73012_v.nextInt(8) && this.func_226658_a_(LightType.SKY, \u2603) <= 0) {
            this.func_184134_a((double)\u2603.func_177958_n() + 0.5, (double)\u2603.func_177956_o() + 0.5, (double)\u2603.func_177952_p() + 0.5, SoundEvents.field_187674_a, SoundCategory.AMBIENT, 0.7f, 0.8f + this.field_73012_v.nextFloat() * 0.2f, false);
            this.field_184158_M = this.field_73012_v.nextInt(12000) + 6000;
        }
    }

    public int func_217425_f() {
        return this.field_217429_b.size();
    }

    public void func_217410_a(LightningBoltEntity lightningBoltEntity) {
        this.field_217428_a.add(lightningBoltEntity);
    }

    public void func_217408_a(int n, AbstractClientPlayerEntity abstractClientPlayerEntity) {
        this.func_217424_b(n, abstractClientPlayerEntity);
        this.field_217431_w.add(abstractClientPlayerEntity);
    }

    public void func_217411_a(int n, Entity entity) {
        this.func_217424_b(n, entity);
    }

    private void func_217424_b(int n, Entity entity) {
        this.func_217413_d(n);
        this.field_217429_b.put(n, (Object)entity);
        this.func_72863_F().func_212849_a_(MathHelper.func_76128_c(entity.func_226277_ct_() / 16.0), MathHelper.func_76128_c(entity.func_226281_cx_() / 16.0), ChunkStatus.field_222617_m, true).func_76612_a(entity);
    }

    public void func_217413_d(int n) {
        Entity entity = (Entity)this.field_217429_b.remove(n);
        if (entity != null) {
            entity.func_70106_y();
            this.func_217414_d(entity);
        }
    }

    private void func_217414_d(Entity entity) {
        entity.func_213319_R();
        if (entity.field_70175_ag) {
            this.func_212866_a_(entity.field_70176_ah, entity.field_70164_aj).func_76622_b(entity);
        }
        this.field_217431_w.remove(entity);
    }

    public void func_217417_b(Chunk chunk) {
        for (Int2ObjectMap.Entry entry : this.field_217429_b.int2ObjectEntrySet()) {
            Entity entity = (Entity)entry.getValue();
            int \u26032 = MathHelper.func_76128_c(entity.func_226277_ct_() / 16.0);
            int \u26033 = MathHelper.func_76128_c(entity.func_226281_cx_() / 16.0);
            if (\u26032 != chunk.func_76632_l().field_77276_a || \u26033 != chunk.func_76632_l().field_77275_b) continue;
            chunk.func_76612_a(entity);
        }
    }

    @Override
    @Nullable
    public Entity func_73045_a(int n) {
        return (Entity)this.field_217429_b.get(n);
    }

    public void func_195597_b(BlockPos blockPos, BlockState blockState) {
        this.func_180501_a(blockPos, blockState, 19);
    }

    @Override
    public void func_72882_A() {
        this.field_73035_a.func_147298_b().func_150718_a(new TranslationTextComponent("multiplayer.status.quitting", new Object[0]));
    }

    public void func_73029_E(int n, int n2, int n3) {
        \u2603 = 32;
        Random random = new Random();
        boolean \u26032 = false;
        if (this.field_73037_M.field_71442_b.func_178889_l() == GameType.CREATIVE) {
            for (ItemStack itemStack : this.field_73037_M.field_71439_g.func_184214_aD()) {
                if (itemStack.func_77973_b() != Blocks.field_180401_cv.func_199767_j()) continue;
                \u26032 = true;
                break;
            }
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int i = 0; i < 667; ++i) {
            this.func_184153_a(n, n2, n3, 16, random, \u26032, mutable);
            this.func_184153_a(n, n2, n3, 32, random, \u26032, mutable);
        }
    }

    public void func_184153_a(int n, int n2, int n3, int n4, Random random, boolean bl, BlockPos.Mutable mutable) {
        int n5 = n + this.field_73012_v.nextInt(n4) - this.field_73012_v.nextInt(n4);
        \u2603 = n2 + this.field_73012_v.nextInt(n4) - this.field_73012_v.nextInt(n4);
        \u2603 = n3 + this.field_73012_v.nextInt(n4) - this.field_73012_v.nextInt(n4);
        mutable.func_181079_c(n5, \u2603, \u2603);
        BlockState \u26032 = this.func_180495_p(mutable);
        \u26032.func_177230_c().func_180655_c(\u26032, this, mutable, random);
        IFluidState \u26033 = this.func_204610_c(mutable);
        if (!\u26033.func_206888_e()) {
            \u26033.func_206881_a(this, mutable, random);
            IParticleData iParticleData = \u26033.func_204521_c();
            if (iParticleData != null && this.field_73012_v.nextInt(10) == 0) {
                boolean bl2 = \u26032.func_224755_d(this, mutable, Direction.DOWN);
                Vec3i \u26034 = mutable.func_177977_b();
                this.func_211530_a((BlockPos)\u26034, this.func_180495_p((BlockPos)\u26034), iParticleData, bl2);
            }
        }
        if (bl && \u26032.func_177230_c() == Blocks.field_180401_cv) {
            this.func_195594_a(ParticleTypes.field_197610_c, (double)n5 + 0.5, (double)\u2603 + 0.5, (double)\u2603 + 0.5, 0.0, 0.0, 0.0);
        }
    }

    private void func_211530_a(BlockPos blockPos, BlockState blockState, IParticleData iParticleData, boolean bl) {
        if (!blockState.func_204520_s().func_206888_e()) {
            return;
        }
        VoxelShape voxelShape = blockState.func_196952_d(this, blockPos);
        double \u26032 = voxelShape.func_197758_c(Direction.Axis.Y);
        if (\u26032 < 1.0) {
            if (bl) {
                this.func_211834_a(blockPos.func_177958_n(), blockPos.func_177958_n() + 1, blockPos.func_177952_p(), blockPos.func_177952_p() + 1, (double)(blockPos.func_177956_o() + 1) - 0.05, iParticleData);
            }
        } else if (!blockState.func_203425_a(BlockTags.field_211923_H)) {
            double d = voxelShape.func_197762_b(Direction.Axis.Y);
            if (d > 0.0) {
                this.func_211835_a(blockPos, iParticleData, voxelShape, (double)blockPos.func_177956_o() + d - 0.05);
            } else {
                BlockPos blockPos2 = blockPos.func_177977_b();
                BlockState \u26033 = this.func_180495_p(blockPos2);
                VoxelShape \u26034 = \u26033.func_196952_d(this, blockPos2);
                double \u26035 = \u26034.func_197758_c(Direction.Axis.Y);
                if (\u26035 < 1.0 && \u26033.func_204520_s().func_206888_e()) {
                    this.func_211835_a(blockPos, iParticleData, voxelShape, (double)blockPos.func_177956_o() - 0.05);
                }
            }
        }
    }

    private void func_211835_a(BlockPos blockPos, IParticleData iParticleData, VoxelShape voxelShape, double d) {
        this.func_211834_a((double)blockPos.func_177958_n() + voxelShape.func_197762_b(Direction.Axis.X), (double)blockPos.func_177958_n() + voxelShape.func_197758_c(Direction.Axis.X), (double)blockPos.func_177952_p() + voxelShape.func_197762_b(Direction.Axis.Z), (double)blockPos.func_177952_p() + voxelShape.func_197758_c(Direction.Axis.Z), d, iParticleData);
    }

    private void func_211834_a(double d, double d2, double d3, double d4, double d5, IParticleData iParticleData) {
        this.func_195594_a(iParticleData, MathHelper.func_219803_d(this.field_73012_v.nextDouble(), d, d2), d5, MathHelper.func_219803_d(this.field_73012_v.nextDouble(), d3, d4), 0.0, 0.0, 0.0);
    }

    public void func_73022_a() {
        ObjectIterator objectIterator = this.field_217429_b.int2ObjectEntrySet().iterator();
        while (objectIterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator.next();
            Entity \u26032 = (Entity)entry.getValue();
            if (!\u26032.field_70128_L) continue;
            objectIterator.remove();
            this.func_217414_d(\u26032);
        }
    }

    @Override
    public CrashReportCategory func_72914_a(CrashReport crashReport) {
        CrashReportCategory crashReportCategory = super.func_72914_a(crashReport);
        crashReportCategory.func_189529_a("Server brand", () -> this.field_73037_M.field_71439_g.func_142021_k());
        crashReportCategory.func_189529_a("Server type", () -> this.field_73037_M.func_71401_C() == null ? "Non-integrated multiplayer server" : "Integrated singleplayer server");
        return crashReportCategory;
    }

    @Override
    public void func_184148_a(@Nullable PlayerEntity playerEntity, double d, double d2, double d3, SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2) {
        if (playerEntity == this.field_73037_M.field_71439_g) {
            this.func_184134_a(d, d2, d3, soundEvent, soundCategory, f, f2, false);
        }
    }

    @Override
    public void func_217384_a(@Nullable PlayerEntity playerEntity, Entity entity, SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2) {
        if (playerEntity == this.field_73037_M.field_71439_g) {
            this.field_73037_M.func_147118_V().func_147682_a(new EntityTickableSound(soundEvent, soundCategory, entity));
        }
    }

    public void func_184156_a(BlockPos blockPos, SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2, boolean bl) {
        this.func_184134_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, soundEvent, soundCategory, f, f2, bl);
    }

    @Override
    public void func_184134_a(double d, double d2, double d3, SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2, boolean bl) {
        double d4 = this.field_73037_M.field_71460_t.func_215316_n().func_216785_c().func_186679_c(d, d2, d3);
        SimpleSound \u26032 = new SimpleSound(soundEvent, soundCategory, f, f2, (float)d, (float)d2, (float)d3);
        if (bl && d4 > 100.0) {
            \u2603 = Math.sqrt(d4) / 40.0;
            this.field_73037_M.func_147118_V().func_147681_a(\u26032, (int)(\u2603 * 20.0));
        } else {
            this.field_73037_M.func_147118_V().func_147682_a(\u26032);
        }
    }

    @Override
    public void func_92088_a(double d, double d2, double d3, double d4, double d5, double d6, @Nullable CompoundNBT compoundNBT) {
        this.field_73037_M.field_71452_i.func_78873_a(new FireworkParticle.Starter(this, d, d2, d3, d4, d5, d6, this.field_73037_M.field_71452_i, compoundNBT));
    }

    @Override
    public void func_184135_a(IPacket<?> iPacket) {
        this.field_73035_a.func_147297_a(iPacket);
    }

    @Override
    public RecipeManager func_199532_z() {
        return this.field_73035_a.func_199526_e();
    }

    public void func_96443_a(Scoreboard scoreboard) {
        this.field_200261_M = scoreboard;
    }

    @Override
    public void func_72877_b(long l) {
        if (l < 0L) {
            l = -l;
            this.func_82736_K().func_223585_a(GameRules.field_223607_j).func_223570_a(false, null);
        } else {
            this.func_82736_K().func_223585_a(GameRules.field_223607_j).func_223570_a(true, null);
        }
        super.func_72877_b(l);
    }

    @Override
    public ITickList<Block> func_205220_G_() {
        return EmptyTickList.func_205388_a();
    }

    @Override
    public ITickList<Fluid> func_205219_F_() {
        return EmptyTickList.func_205388_a();
    }

    @Override
    public ClientChunkProvider func_72863_F() {
        return (ClientChunkProvider)super.func_72863_F();
    }

    @Override
    @Nullable
    public MapData func_217406_a(String string) {
        return this.field_217432_z.get(string);
    }

    @Override
    public void func_217399_a(MapData mapData) {
        this.field_217432_z.put(mapData.func_195925_e(), mapData);
    }

    @Override
    public int func_217395_y() {
        return 0;
    }

    @Override
    public Scoreboard func_96441_U() {
        return this.field_200261_M;
    }

    @Override
    public NetworkTagManager func_205772_D() {
        return this.field_73035_a.func_199724_l();
    }

    @Override
    public void func_184138_a(BlockPos blockPos, BlockState blockState, BlockState blockState2, int n) {
        this.field_217430_d.func_184376_a(this, blockPos, blockState, blockState2, n);
    }

    @Override
    public void func_225319_b(BlockPos blockPos, BlockState blockState, BlockState blockState2) {
        this.field_217430_d.func_224746_a(blockPos, blockState, blockState2);
    }

    public void func_217427_b(int n, int n2, int n3) {
        this.field_217430_d.func_215321_a(n, n2, n3);
    }

    @Override
    public void func_175715_c(int n, BlockPos blockPos, int n2) {
        this.field_217430_d.func_180441_b(n, blockPos, n2);
    }

    @Override
    public void func_175669_a(int n, BlockPos blockPos, int n2) {
        this.field_217430_d.func_180440_a(n, blockPos, n2);
    }

    @Override
    public void func_217378_a(@Nullable PlayerEntity playerEntity, int n, BlockPos blockPos, int n2) {
        try {
            this.field_217430_d.func_180439_a(playerEntity, n, blockPos, n2);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Playing level event");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Level event being played");
            \u26032.func_71507_a("Block coordinates", CrashReportCategory.func_180522_a(blockPos));
            \u26032.func_71507_a("Event source", playerEntity);
            \u26032.func_71507_a("Event type", n);
            \u26032.func_71507_a("Event data", n2);
            throw new ReportedException(crashReport);
        }
    }

    @Override
    public void func_195594_a(IParticleData iParticleData, double d, double d2, double d3, double d4, double d5, double d6) {
        this.field_217430_d.func_195461_a(iParticleData, iParticleData.func_197554_b().func_197575_f(), d, d2, d3, d4, d5, d6);
    }

    @Override
    public void func_195590_a(IParticleData iParticleData, boolean bl, double d, double d2, double d3, double d4, double d5, double d6) {
        this.field_217430_d.func_195461_a(iParticleData, iParticleData.func_197554_b().func_197575_f() || bl, d, d2, d3, d4, d5, d6);
    }

    @Override
    public void func_195589_b(IParticleData iParticleData, double d, double d2, double d3, double d4, double d5, double d6) {
        this.field_217430_d.func_195462_a(iParticleData, false, true, d, d2, d3, d4, d5, d6);
    }

    @Override
    public void func_217404_b(IParticleData iParticleData, boolean bl, double d, double d2, double d3, double d4, double d5, double d6) {
        this.field_217430_d.func_195462_a(iParticleData, iParticleData.func_197554_b().func_197575_f() || bl, true, d, d2, d3, d4, d5, d6);
    }

    public List<AbstractClientPlayerEntity> func_217369_A() {
        return this.field_217431_w;
    }

    @Override
    public Biome func_225604_a_(int n, int n2, int n3) {
        return Biomes.field_76772_c;
    }

    public float func_228326_g_(float f) {
        \u2603 = this.func_72826_c(f);
        \u2603 = 1.0f - (MathHelper.func_76134_b(\u2603 * ((float)Math.PI * 2)) * 2.0f + 0.2f);
        \u2603 = MathHelper.func_76131_a(\u2603, 0.0f, 1.0f);
        \u2603 = 1.0f - \u2603;
        \u2603 = (float)((double)\u2603 * (1.0 - (double)(this.func_72867_j(f) * 5.0f) / 16.0));
        \u2603 = (float)((double)\u2603 * (1.0 - (double)(this.func_72819_i(f) * 5.0f) / 16.0));
        return \u2603 * 0.8f + 0.2f;
    }

    public Vec3d func_228318_a_(BlockPos blockPos, float f) {
        float f2;
        \u2603 = this.func_72826_c(f);
        \u2603 = MathHelper.func_76134_b(\u2603 * ((float)Math.PI * 2)) * 2.0f + 0.5f;
        \u2603 = MathHelper.func_76131_a(\u2603, 0.0f, 1.0f);
        Biome biome = this.func_226691_t_(blockPos);
        int \u26032 = biome.func_225529_c_();
        float \u26033 = (float)(\u26032 >> 16 & 0xFF) / 255.0f;
        float \u26034 = (float)(\u26032 >> 8 & 0xFF) / 255.0f;
        float \u26035 = (float)(\u26032 & 0xFF) / 255.0f;
        \u26033 *= \u2603;
        \u26034 *= \u2603;
        \u26035 *= \u2603;
        float \u26036 = this.func_72867_j(f);
        if (\u26036 > 0.0f) {
            f2 = (\u26033 * 0.3f + \u26034 * 0.59f + \u26035 * 0.11f) * 0.6f;
            \u2603 = 1.0f - \u26036 * 0.75f;
            \u26033 = \u26033 * \u2603 + f2 * (1.0f - \u2603);
            \u26034 = \u26034 * \u2603 + f2 * (1.0f - \u2603);
            \u26035 = \u26035 * \u2603 + f2 * (1.0f - \u2603);
        }
        if ((f2 = this.func_72819_i(f)) > 0.0f) {
            \u2603 = (\u26033 * 0.3f + \u26034 * 0.59f + \u26035 * 0.11f) * 0.2f;
            \u2603 = 1.0f - f2 * 0.75f;
            \u26033 = \u26033 * \u2603 + \u2603 * (1.0f - \u2603);
            \u26034 = \u26034 * \u2603 + \u2603 * (1.0f - \u2603);
            \u26035 = \u26035 * \u2603 + \u2603 * (1.0f - \u2603);
        }
        if (this.field_228314_A_ > 0) {
            \u2603 = (float)this.field_228314_A_ - f;
            if (\u2603 > 1.0f) {
                \u2603 = 1.0f;
            }
            \u26033 = \u26033 * (1.0f - (\u2603 *= 0.45f)) + 0.8f * \u2603;
            \u26034 = \u26034 * (1.0f - \u2603) + 0.8f * \u2603;
            \u26035 = \u26035 * (1.0f - \u2603) + 1.0f * \u2603;
        }
        return new Vec3d(\u26033, \u26034, \u26035);
    }

    public Vec3d func_228328_h_(float f) {
        \u2603 = this.func_72826_c(f);
        \u2603 = MathHelper.func_76134_b(\u2603 * ((float)Math.PI * 2)) * 2.0f + 0.5f;
        \u2603 = MathHelper.func_76131_a(\u2603, 0.0f, 1.0f);
        \u2603 = 1.0f;
        \u2603 = 1.0f;
        \u2603 = 1.0f;
        \u2603 = this.func_72867_j(f);
        if (\u2603 > 0.0f) {
            \u2603 = (\u2603 * 0.3f + \u2603 * 0.59f + \u2603 * 0.11f) * 0.6f;
            \u2603 = 1.0f - \u2603 * 0.95f;
            \u2603 = \u2603 * \u2603 + \u2603 * (1.0f - \u2603);
            \u2603 = \u2603 * \u2603 + \u2603 * (1.0f - \u2603);
            \u2603 = \u2603 * \u2603 + \u2603 * (1.0f - \u2603);
        }
        \u2603 *= \u2603 * 0.9f + 0.1f;
        \u2603 *= \u2603 * 0.9f + 0.1f;
        \u2603 *= \u2603 * 0.85f + 0.15f;
        \u2603 = this.func_72819_i(f);
        if (\u2603 > 0.0f) {
            \u2603 = (\u2603 * 0.3f + \u2603 * 0.59f + \u2603 * 0.11f) * 0.2f;
            \u2603 = 1.0f - \u2603 * 0.95f;
            \u2603 = \u2603 * \u2603 + \u2603 * (1.0f - \u2603);
            \u2603 = \u2603 * \u2603 + \u2603 * (1.0f - \u2603);
            \u2603 = \u2603 * \u2603 + \u2603 * (1.0f - \u2603);
        }
        return new Vec3d(\u2603, \u2603, \u2603);
    }

    public Vec3d func_228329_i_(float f) {
        \u2603 = this.func_72826_c(f);
        return this.field_73011_w.func_76562_b(\u2603, f);
    }

    public float func_228330_j_(float f) {
        \u2603 = this.func_72826_c(f);
        \u2603 = 1.0f - (MathHelper.func_76134_b(\u2603 * ((float)Math.PI * 2)) * 2.0f + 0.25f);
        \u2603 = MathHelper.func_76131_a(\u2603, 0.0f, 1.0f);
        return \u2603 * \u2603 * 0.5f;
    }

    public double func_228331_m_() {
        if (this.field_72986_A.func_76067_t() == WorldType.field_77138_c) {
            return 0.0;
        }
        return 63.0;
    }

    public int func_228332_n_() {
        return this.field_228314_A_;
    }

    @Override
    public void func_225605_c_(int n) {
        this.field_228314_A_ = n;
    }

    @Override
    public int func_225525_a_(BlockPos blockPos, ColorResolver colorResolver) {
        ColorCache colorCache = (ColorCache)this.field_228315_B_.get((Object)colorResolver);
        return colorCache.func_228071_a_(blockPos, () -> this.func_228321_b_(blockPos, colorResolver));
    }

    public int func_228321_b_(BlockPos blockPos, ColorResolver colorResolver) {
        int n = Minecraft.func_71410_x().field_71474_y.field_205217_U;
        if (n == 0) {
            return colorResolver.getColor(this.func_226691_t_(blockPos), blockPos.func_177958_n(), blockPos.func_177952_p());
        }
        \u2603 = (n * 2 + 1) * (n * 2 + 1);
        \u2603 = 0;
        \u2603 = 0;
        \u2603 = 0;
        CubeCoordinateIterator \u26032 = new CubeCoordinateIterator(blockPos.func_177958_n() - n, blockPos.func_177956_o(), blockPos.func_177952_p() - n, blockPos.func_177958_n() + n, blockPos.func_177956_o(), blockPos.func_177952_p() + n);
        BlockPos.Mutable \u26033 = new BlockPos.Mutable();
        while (\u26032.func_218301_a()) {
            \u26033.func_181079_c(\u26032.func_218304_b(), \u26032.func_218302_c(), \u26032.func_218303_d());
            \u2603 = colorResolver.getColor(this.func_226691_t_(\u26033), \u26033.func_177958_n(), \u26033.func_177952_p());
            \u2603 += (\u2603 & 0xFF0000) >> 16;
            \u2603 += (\u2603 & 0xFF00) >> 8;
            \u2603 += \u2603 & 0xFF;
        }
        return (\u2603 / \u2603 & 0xFF) << 16 | (\u2603 / \u2603 & 0xFF) << 8 | \u2603 / \u2603 & 0xFF;
    }

    @Override
    public /* synthetic */ AbstractChunkProvider func_72863_F() {
        return this.func_72863_F();
    }
}

