/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.attributes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;

public class ModifiableAttributeInstance
implements IAttributeInstance {
    private final AbstractAttributeMap field_111138_a;
    private final IAttribute field_111136_b;
    private final Map<AttributeModifier.Operation, Set<AttributeModifier>> field_111137_c = Maps.newEnumMap(AttributeModifier.Operation.class);
    private final Map<String, Set<AttributeModifier>> field_111134_d = Maps.newHashMap();
    private final Map<UUID, AttributeModifier> field_111135_e = Maps.newHashMap();
    private double field_111132_f;
    private boolean field_111133_g = true;
    private double field_111139_h;

    public ModifiableAttributeInstance(AbstractAttributeMap abstractAttributeMap, IAttribute iAttribute) {
        this.field_111138_a = abstractAttributeMap;
        this.field_111136_b = iAttribute;
        this.field_111132_f = iAttribute.func_111110_b();
        for (AttributeModifier.Operation operation : AttributeModifier.Operation.values()) {
            this.field_111137_c.put(operation, Sets.newHashSet());
        }
    }

    @Override
    public IAttribute func_111123_a() {
        return this.field_111136_b;
    }

    @Override
    public double func_111125_b() {
        return this.field_111132_f;
    }

    @Override
    public void func_111128_a(double d) {
        if (d == this.func_111125_b()) {
            return;
        }
        this.field_111132_f = d;
        this.func_111131_f();
    }

    @Override
    public Set<AttributeModifier> func_225504_a_(AttributeModifier.Operation operation) {
        return this.field_111137_c.get((Object)operation);
    }

    @Override
    public Set<AttributeModifier> func_225505_c_() {
        HashSet hashSet = Sets.newHashSet();
        for (AttributeModifier.Operation operation : AttributeModifier.Operation.values()) {
            hashSet.addAll(this.func_225504_a_(operation));
        }
        return hashSet;
    }

    @Override
    @Nullable
    public AttributeModifier func_111127_a(UUID uUID) {
        return this.field_111135_e.get(uUID);
    }

    @Override
    public boolean func_180374_a(AttributeModifier attributeModifier) {
        return this.field_111135_e.get(attributeModifier.func_111167_a()) != null;
    }

    @Override
    public void func_111121_a(AttributeModifier attributeModifier) {
        if (this.func_111127_a(attributeModifier.func_111167_a()) != null) {
            throw new IllegalArgumentException("Modifier is already applied on this attribute!");
        }
        Set set = this.field_111134_d.computeIfAbsent(attributeModifier.func_111166_b(), string -> Sets.newHashSet());
        this.field_111137_c.get((Object)attributeModifier.func_220375_c()).add(attributeModifier);
        set.add(attributeModifier);
        this.field_111135_e.put(attributeModifier.func_111167_a(), attributeModifier);
        this.func_111131_f();
    }

    protected void func_111131_f() {
        this.field_111133_g = true;
        this.field_111138_a.func_180794_a(this);
    }

    @Override
    public void func_111124_b(AttributeModifier attributeModifier2) {
        AttributeModifier attributeModifier2;
        for (AttributeModifier.Operation operation : AttributeModifier.Operation.values()) {
            this.field_111137_c.get((Object)operation).remove(attributeModifier2);
        }
        Set<AttributeModifier> \u26032 = this.field_111134_d.get(attributeModifier2.func_111166_b());
        if (\u26032 != null) {
            \u26032.remove(attributeModifier2);
            if (\u26032.isEmpty()) {
                this.field_111134_d.remove(attributeModifier2.func_111166_b());
            }
        }
        this.field_111135_e.remove(attributeModifier2.func_111167_a());
        this.func_111131_f();
    }

    @Override
    public void func_188479_b(UUID uUID) {
        AttributeModifier attributeModifier = this.func_111127_a(uUID);
        if (attributeModifier != null) {
            this.func_111124_b(attributeModifier);
        }
    }

    @Override
    public void func_142049_d() {
        Collection<AttributeModifier> collection = this.func_225505_c_();
        if (collection == null) {
            return;
        }
        collection = Lists.newArrayList(collection);
        for (AttributeModifier attributeModifier : collection) {
            this.func_111124_b(attributeModifier);
        }
    }

    @Override
    public double func_111126_e() {
        if (this.field_111133_g) {
            this.field_111139_h = this.func_111129_g();
            this.field_111133_g = false;
        }
        return this.field_111139_h;
    }

    private double func_111129_g() {
        double d;
        double d2 = this.func_111125_b();
        for (AttributeModifier attributeModifier : this.func_220370_b(AttributeModifier.Operation.ADDITION)) {
            d2 += attributeModifier.func_111164_d();
        }
        d = d2;
        for (AttributeModifier attributeModifier : this.func_220370_b(AttributeModifier.Operation.MULTIPLY_BASE)) {
            d += d2 * attributeModifier.func_111164_d();
        }
        for (AttributeModifier attributeModifier : this.func_220370_b(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
            d *= 1.0 + attributeModifier.func_111164_d();
        }
        return this.field_111136_b.func_111109_a(d);
    }

    private Collection<AttributeModifier> func_220370_b(AttributeModifier.Operation operation) {
        HashSet hashSet = Sets.newHashSet(this.func_225504_a_(operation));
        for (IAttribute iAttribute = this.field_111136_b.func_180372_d(); iAttribute != null; iAttribute = iAttribute.func_180372_d()) {
            IAttributeInstance iAttributeInstance = this.field_111138_a.func_111151_a(iAttribute);
            if (iAttributeInstance == null) continue;
            hashSet.addAll(iAttributeInstance.func_225504_a_(operation));
        }
        return hashSet;
    }
}

