/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ArmorStandEntity
extends LivingEntity {
    private static final Rotations field_175435_a = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations field_175433_b = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations field_175434_c = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations field_175431_d = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations field_175432_e = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations field_175429_f = new Rotations(1.0f, 0.0f, 1.0f);
    public static final DataParameter<Byte> field_184801_a = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187191_a);
    public static final DataParameter<Rotations> field_184802_b = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184803_c = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184804_d = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184805_e = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184806_f = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184807_g = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    private static final Predicate<Entity> field_184798_bv = entity -> entity instanceof AbstractMinecartEntity && ((AbstractMinecartEntity)entity).func_184264_v() == AbstractMinecartEntity.Type.RIDEABLE;
    private final NonNullList<ItemStack> field_184799_bw = NonNullList.func_191197_a(2, ItemStack.field_190927_a);
    private final NonNullList<ItemStack> field_184800_bx = NonNullList.func_191197_a(4, ItemStack.field_190927_a);
    private boolean field_175436_h;
    public long field_175437_i;
    private int field_175442_bg;
    private Rotations field_175443_bh = field_175435_a;
    private Rotations field_175444_bi = field_175433_b;
    private Rotations field_175438_bj = field_175434_c;
    private Rotations field_175439_bk = field_175431_d;
    private Rotations field_175440_bl = field_175432_e;
    private Rotations field_175441_bm = field_175429_f;

    public ArmorStandEntity(EntityType<? extends ArmorStandEntity> entityType, World world) {
        super((EntityType<? extends LivingEntity>)entityType, world);
        this.field_70138_W = 0.0f;
    }

    public ArmorStandEntity(World world, double d, double d2, double d3) {
        this((EntityType<? extends ArmorStandEntity>)EntityType.field_200789_c, world);
        this.func_70107_b(d, d2, d3);
    }

    @Override
    public void func_213323_x_() {
        double d = this.func_226277_ct_();
        \u2603 = this.func_226278_cu_();
        \u2603 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d, \u2603, \u2603);
    }

    private boolean func_213814_A() {
        return !this.func_181026_s() && !this.func_189652_ae();
    }

    @Override
    public boolean func_70613_aW() {
        return super.func_70613_aW() && this.func_213814_A();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184801_a, (byte)0);
        this.field_70180_af.func_187214_a(field_184802_b, field_175435_a);
        this.field_70180_af.func_187214_a(field_184803_c, field_175433_b);
        this.field_70180_af.func_187214_a(field_184804_d, field_175434_c);
        this.field_70180_af.func_187214_a(field_184805_e, field_175431_d);
        this.field_70180_af.func_187214_a(field_184806_f, field_175432_e);
        this.field_70180_af.func_187214_a(field_184807_g, field_175429_f);
    }

    @Override
    public Iterable<ItemStack> func_184214_aD() {
        return this.field_184799_bw;
    }

    @Override
    public Iterable<ItemStack> func_184193_aE() {
        return this.field_184800_bx;
    }

    @Override
    public ItemStack func_184582_a(EquipmentSlotType equipmentSlotType) {
        switch (equipmentSlotType.func_188453_a()) {
            case HAND: {
                return this.field_184799_bw.get(equipmentSlotType.func_188454_b());
            }
            case ARMOR: {
                return this.field_184800_bx.get(equipmentSlotType.func_188454_b());
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_184201_a(EquipmentSlotType equipmentSlotType, ItemStack itemStack) {
        switch (equipmentSlotType.func_188453_a()) {
            case HAND: {
                this.func_184606_a_(itemStack);
                this.field_184799_bw.set(equipmentSlotType.func_188454_b(), itemStack);
                break;
            }
            case ARMOR: {
                this.func_184606_a_(itemStack);
                this.field_184800_bx.set(equipmentSlotType.func_188454_b(), itemStack);
            }
        }
    }

    @Override
    public boolean func_174820_d(int n2, ItemStack itemStack2) {
        ItemStack itemStack2;
        int n2;
        EquipmentSlotType equipmentSlotType;
        if (n2 == 98) {
            equipmentSlotType = EquipmentSlotType.MAINHAND;
        } else if (n2 == 99) {
            equipmentSlotType = EquipmentSlotType.OFFHAND;
        } else if (n2 == 100 + EquipmentSlotType.HEAD.func_188454_b()) {
            equipmentSlotType = EquipmentSlotType.HEAD;
        } else if (n2 == 100 + EquipmentSlotType.CHEST.func_188454_b()) {
            equipmentSlotType = EquipmentSlotType.CHEST;
        } else if (n2 == 100 + EquipmentSlotType.LEGS.func_188454_b()) {
            equipmentSlotType = EquipmentSlotType.LEGS;
        } else if (n2 == 100 + EquipmentSlotType.FEET.func_188454_b()) {
            equipmentSlotType = EquipmentSlotType.FEET;
        } else {
            return false;
        }
        if (itemStack2.func_190926_b() || MobEntity.func_184648_b(equipmentSlotType, itemStack2) || equipmentSlotType == EquipmentSlotType.HEAD) {
            this.func_184201_a(equipmentSlotType, itemStack2);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_213365_e(ItemStack itemStack) {
        EquipmentSlotType equipmentSlotType = MobEntity.func_184640_d(itemStack);
        return this.func_184582_a(equipmentSlotType).func_190926_b() && !this.func_184796_b(equipmentSlotType);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT2) {
        super.func_213281_b(compoundNBT2);
        ListNBT listNBT = new ListNBT();
        for (ItemStack itemStack : this.field_184800_bx) {
            CompoundNBT compoundNBT = new CompoundNBT();
            if (!itemStack.func_190926_b()) {
                itemStack.func_77955_b(compoundNBT);
            }
            listNBT.add(compoundNBT);
        }
        compoundNBT2.func_218657_a("ArmorItems", listNBT);
        ListNBT \u26032 = new ListNBT();
        for (ItemStack itemStack : this.field_184799_bw) {
            CompoundNBT compoundNBT3 = new CompoundNBT();
            if (!itemStack.func_190926_b()) {
                itemStack.func_77955_b(compoundNBT3);
            }
            \u26032.add(compoundNBT3);
        }
        compoundNBT2.func_218657_a("HandItems", \u26032);
        compoundNBT2.func_74757_a("Invisible", this.func_82150_aj());
        compoundNBT2.func_74757_a("Small", this.func_175410_n());
        compoundNBT2.func_74757_a("ShowArms", this.func_175402_q());
        compoundNBT2.func_74768_a("DisabledSlots", this.field_175442_bg);
        compoundNBT2.func_74757_a("NoBasePlate", this.func_175414_r());
        if (this.func_181026_s()) {
            compoundNBT2.func_74757_a("Marker", this.func_181026_s());
        }
        compoundNBT2.func_218657_a("Pose", this.func_175419_y());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        int n;
        INBT \u26032;
        super.func_70037_a(compoundNBT2);
        if (compoundNBT2.func_150297_b("ArmorItems", 9)) {
            \u26032 = compoundNBT2.func_150295_c("ArmorItems", 10);
            for (n = 0; n < this.field_184800_bx.size(); ++n) {
                this.field_184800_bx.set(n, ItemStack.func_199557_a(\u26032.func_150305_b(n)));
            }
        }
        if (compoundNBT2.func_150297_b("HandItems", 9)) {
            \u26032 = compoundNBT2.func_150295_c("HandItems", 10);
            for (n = 0; n < this.field_184799_bw.size(); ++n) {
                this.field_184799_bw.set(n, ItemStack.func_199557_a(\u26032.func_150305_b(n)));
            }
        }
        this.func_82142_c(compoundNBT2.func_74767_n("Invisible"));
        this.func_175420_a(compoundNBT2.func_74767_n("Small"));
        this.func_175413_k(compoundNBT2.func_74767_n("ShowArms"));
        this.field_175442_bg = compoundNBT2.func_74762_e("DisabledSlots");
        this.func_175426_l(compoundNBT2.func_74767_n("NoBasePlate"));
        this.func_181027_m(compoundNBT2.func_74767_n("Marker"));
        this.field_70145_X = !this.func_213814_A();
        \u26032 = compoundNBT2.func_74775_l("Pose");
        this.func_175416_h((CompoundNBT)\u26032);
    }

    private void func_175416_h(CompoundNBT compoundNBT) {
        ListNBT listNBT = compoundNBT.func_150295_c("Head", 5);
        this.func_175415_a(listNBT.isEmpty() ? field_175435_a : new Rotations(listNBT));
        \u2603 = compoundNBT.func_150295_c("Body", 5);
        this.func_175424_b(\u2603.isEmpty() ? field_175433_b : new Rotations(\u2603));
        \u2603 = compoundNBT.func_150295_c("LeftArm", 5);
        this.func_175405_c(\u2603.isEmpty() ? field_175434_c : new Rotations(\u2603));
        \u2603 = compoundNBT.func_150295_c("RightArm", 5);
        this.func_175428_d(\u2603.isEmpty() ? field_175431_d : new Rotations(\u2603));
        \u2603 = compoundNBT.func_150295_c("LeftLeg", 5);
        this.func_175417_e(\u2603.isEmpty() ? field_175432_e : new Rotations(\u2603));
        \u2603 = compoundNBT.func_150295_c("RightLeg", 5);
        this.func_175427_f(\u2603.isEmpty() ? field_175429_f : new Rotations(\u2603));
    }

    private CompoundNBT func_175419_y() {
        CompoundNBT compoundNBT = new CompoundNBT();
        if (!field_175435_a.equals(this.field_175443_bh)) {
            compoundNBT.func_218657_a("Head", this.field_175443_bh.func_179414_a());
        }
        if (!field_175433_b.equals(this.field_175444_bi)) {
            compoundNBT.func_218657_a("Body", this.field_175444_bi.func_179414_a());
        }
        if (!field_175434_c.equals(this.field_175438_bj)) {
            compoundNBT.func_218657_a("LeftArm", this.field_175438_bj.func_179414_a());
        }
        if (!field_175431_d.equals(this.field_175439_bk)) {
            compoundNBT.func_218657_a("RightArm", this.field_175439_bk.func_179414_a());
        }
        if (!field_175432_e.equals(this.field_175440_bl)) {
            compoundNBT.func_218657_a("LeftLeg", this.field_175440_bl.func_179414_a());
        }
        if (!field_175429_f.equals(this.field_175441_bm)) {
            compoundNBT.func_218657_a("RightLeg", this.field_175441_bm.func_179414_a());
        }
        return compoundNBT;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    protected void func_82167_n(Entity entity) {
    }

    @Override
    protected void func_85033_bc() {
        List<Entity> list = this.field_70170_p.func_175674_a(this, this.func_174813_aQ(), field_184798_bv);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = list.get(i);
            if (!(this.func_70068_e(entity) <= 0.2)) continue;
            entity.func_70108_f(this);
        }
    }

    @Override
    public ActionResultType func_184199_a(PlayerEntity playerEntity2, Vec3d vec3d, Hand hand) {
        ItemStack itemStack = playerEntity2.func_184586_b(hand);
        if (this.func_181026_s() || itemStack.func_77973_b() == Items.field_151057_cb) {
            return ActionResultType.PASS;
        }
        if (playerEntity2.func_175149_v()) {
            return ActionResultType.SUCCESS;
        }
        if (playerEntity2.field_70170_p.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        EquipmentSlotType \u26032 = MobEntity.func_184640_d(itemStack);
        if (itemStack.func_190926_b()) {
            EquipmentSlotType equipmentSlotType = this.func_190772_a(vec3d);
            EquipmentSlotType equipmentSlotType2 = \u2603 = this.func_184796_b(equipmentSlotType) ? \u26032 : equipmentSlotType;
            if (this.func_190630_a(\u2603) && this.func_226529_a_(playerEntity2, \u2603, itemStack, hand)) {
                return ActionResultType.SUCCESS;
            }
        } else {
            PlayerEntity playerEntity2;
            if (this.func_184796_b(\u26032)) {
                return ActionResultType.FAIL;
            }
            if (\u26032.func_188453_a() == EquipmentSlotType.Group.HAND && !this.func_175402_q()) {
                return ActionResultType.FAIL;
            }
            if (this.func_226529_a_(playerEntity2, \u26032, itemStack, hand)) {
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EquipmentSlotType func_190772_a(Vec3d vec3d) {
        EquipmentSlotType equipmentSlotType = EquipmentSlotType.MAINHAND;
        boolean \u26032 = this.func_175410_n();
        double \u26033 = \u26032 ? vec3d.field_72448_b * 2.0 : vec3d.field_72448_b;
        \u2603 = EquipmentSlotType.FEET;
        if (\u26033 >= 0.1) {
            double d = \u26032 ? 0.8 : 0.45;
            if (\u26033 < 0.1 + d && this.func_190630_a(\u2603)) {
                return EquipmentSlotType.FEET;
            }
        }
        double d = \u26032 ? 0.3 : 0.0;
        if (\u26033 >= 0.9 + d) {
            double d2 = \u26032 ? 1.0 : 0.7;
            if (\u26033 < 0.9 + d2 && this.func_190630_a(EquipmentSlotType.CHEST)) {
                return EquipmentSlotType.CHEST;
            }
        }
        if (\u26033 >= 0.4) {
            double d3 = \u26032 ? 1.0 : 0.8;
            if (\u26033 < 0.4 + d3 && this.func_190630_a(EquipmentSlotType.LEGS)) {
                return EquipmentSlotType.LEGS;
            }
        }
        if (\u26033 >= 1.6 && this.func_190630_a(EquipmentSlotType.HEAD)) {
            return EquipmentSlotType.HEAD;
        }
        if (this.func_190630_a(EquipmentSlotType.MAINHAND)) return equipmentSlotType;
        if (!this.func_190630_a(EquipmentSlotType.OFFHAND)) return equipmentSlotType;
        return EquipmentSlotType.OFFHAND;
    }

    private boolean func_184796_b(EquipmentSlotType equipmentSlotType) {
        return (this.field_175442_bg & 1 << equipmentSlotType.func_188452_c()) != 0 || equipmentSlotType.func_188453_a() == EquipmentSlotType.Group.HAND && !this.func_175402_q();
    }

    private boolean func_226529_a_(PlayerEntity playerEntity, EquipmentSlotType equipmentSlotType, ItemStack itemStack, Hand hand) {
        ItemStack itemStack2 = this.func_184582_a(equipmentSlotType);
        if (!itemStack2.func_190926_b() && (this.field_175442_bg & 1 << equipmentSlotType.func_188452_c() + 8) != 0) {
            return false;
        }
        if (itemStack2.func_190926_b() && (this.field_175442_bg & 1 << equipmentSlotType.func_188452_c() + 16) != 0) {
            return false;
        }
        if (playerEntity.field_71075_bZ.field_75098_d && itemStack2.func_190926_b() && !itemStack.func_190926_b()) {
            \u2603 = itemStack.func_77946_l();
            \u2603.func_190920_e(1);
            this.func_184201_a(equipmentSlotType, \u2603);
            return true;
        }
        if (!itemStack.func_190926_b() && itemStack.func_190916_E() > 1) {
            if (!itemStack2.func_190926_b()) {
                return false;
            }
            \u2603 = itemStack.func_77946_l();
            \u2603.func_190920_e(1);
            this.func_184201_a(equipmentSlotType, \u2603);
            itemStack.func_190918_g(1);
            return true;
        }
        this.func_184201_a(equipmentSlotType, itemStack);
        playerEntity.func_184611_a(hand, itemStack2);
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return false;
        }
        if (DamageSource.field_76380_i.equals(damageSource)) {
            this.func_70106_y();
            return false;
        }
        if (this.func_180431_b(damageSource) || this.field_175436_h || this.func_181026_s()) {
            return false;
        }
        if (damageSource.func_94541_c()) {
            this.func_213816_g(damageSource);
            this.func_70106_y();
            return false;
        }
        if (DamageSource.field_76372_a.equals(damageSource)) {
            if (this.func_70027_ad()) {
                this.func_213817_e(damageSource, 0.15f);
            } else {
                this.func_70015_d(5);
            }
            return false;
        }
        if (DamageSource.field_76370_b.equals(damageSource) && this.func_110143_aJ() > 0.5f) {
            this.func_213817_e(damageSource, 4.0f);
            return false;
        }
        boolean bl = damageSource.func_76364_f() instanceof AbstractArrowEntity;
        \u2603 = bl && ((AbstractArrowEntity)damageSource.func_76364_f()).func_213874_s() > 0;
        \u2603 = "player".equals(damageSource.func_76355_l());
        if (!\u2603 && !bl) {
            return false;
        }
        if (damageSource.func_76346_g() instanceof PlayerEntity && !((PlayerEntity)damageSource.func_76346_g()).field_71075_bZ.field_75099_e) {
            return false;
        }
        if (damageSource.func_180136_u()) {
            this.func_190773_I();
            this.func_175412_z();
            this.func_70106_y();
            return \u2603;
        }
        long \u26032 = this.field_70170_p.func_82737_E();
        if (\u26032 - this.field_175437_i <= 5L || bl) {
            this.func_213815_f(damageSource);
            this.func_175412_z();
            this.func_70106_y();
        } else {
            this.field_70170_p.func_72960_a(this, (byte)32);
            this.field_175437_i = \u26032;
        }
        return true;
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 32) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187707_l, this.func_184176_by(), 0.3f, 1.0f, false);
                this.field_175437_i = this.field_70170_p.func_82737_E();
            }
        } else {
            super.func_70103_a(by);
        }
    }

    @Override
    public boolean func_70112_a(double d) {
        \u2603 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(\u2603) || \u2603 == 0.0) {
            \u2603 = 4.0;
        }
        return d < (\u2603 *= 64.0) * \u2603;
    }

    private void func_175412_z() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a(new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196662_n.func_176223_P()), this.func_226277_ct_(), this.func_226283_e_(0.6666666666666666), this.func_226281_cx_(), 10, this.func_213311_cf() / 4.0f, this.func_213302_cg() / 4.0f, this.func_213311_cf() / 4.0f, 0.05);
        }
    }

    private void func_213817_e(DamageSource damageSource, float f) {
        \u2603 = this.func_110143_aJ();
        if ((\u2603 -= f) <= 0.5f) {
            this.func_213816_g(damageSource);
            this.func_70106_y();
        } else {
            this.func_70606_j(\u2603);
        }
    }

    private void func_213815_f(DamageSource damageSource) {
        Block.func_180635_a(this.field_70170_p, new BlockPos(this), new ItemStack(Items.field_179565_cj));
        this.func_213816_g(damageSource);
    }

    private void func_213816_g(DamageSource damageSource) {
        ItemStack itemStack;
        int n;
        this.func_190773_I();
        this.func_213345_d(damageSource);
        for (n = 0; n < this.field_184799_bw.size(); ++n) {
            itemStack = this.field_184799_bw.get(n);
            if (itemStack.func_190926_b()) continue;
            Block.func_180635_a(this.field_70170_p, new BlockPos(this).func_177984_a(), itemStack);
            this.field_184799_bw.set(n, ItemStack.field_190927_a);
        }
        for (n = 0; n < this.field_184800_bx.size(); ++n) {
            itemStack = this.field_184800_bx.get(n);
            if (itemStack.func_190926_b()) continue;
            Block.func_180635_a(this.field_70170_p, new BlockPos(this).func_177984_a(), itemStack);
            this.field_184800_bx.set(n, ItemStack.field_190927_a);
        }
    }

    private void func_190773_I() {
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187701_j, this.func_184176_by(), 1.0f, 1.0f);
    }

    @Override
    protected float func_110146_f(float f, float f2) {
        this.field_70760_ar = this.field_70126_B;
        this.field_70761_aq = this.field_70177_z;
        return 0.0f;
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return entitySize.field_220316_b * (this.func_70631_g_() ? 0.5f : 0.9f);
    }

    @Override
    public double func_70033_W() {
        return this.func_181026_s() ? 0.0 : (double)0.1f;
    }

    @Override
    public void func_213352_e(Vec3d vec3d) {
        if (!this.func_213814_A()) {
            return;
        }
        super.func_213352_e(vec3d);
    }

    @Override
    public void func_181013_g(float f) {
        this.field_70760_ar = this.field_70126_B = f;
        this.field_70758_at = this.field_70759_as = f;
    }

    @Override
    public void func_70034_d(float f) {
        this.field_70760_ar = this.field_70126_B = f;
        this.field_70758_at = this.field_70759_as = f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        Rotations rotations = this.field_70180_af.func_187225_a(field_184802_b);
        if (!this.field_175443_bh.equals(rotations)) {
            this.func_175415_a(rotations);
        }
        if (!this.field_175444_bi.equals(\u2603 = this.field_70180_af.func_187225_a(field_184803_c))) {
            this.func_175424_b(\u2603);
        }
        if (!this.field_175438_bj.equals(\u2603 = this.field_70180_af.func_187225_a(field_184804_d))) {
            this.func_175405_c(\u2603);
        }
        if (!this.field_175439_bk.equals(\u2603 = this.field_70180_af.func_187225_a(field_184805_e))) {
            this.func_175428_d(\u2603);
        }
        if (!this.field_175440_bl.equals(\u2603 = this.field_70180_af.func_187225_a(field_184806_f))) {
            this.func_175417_e(\u2603);
        }
        if (!this.field_175441_bm.equals(\u2603 = this.field_70180_af.func_187225_a(field_184807_g))) {
            this.func_175427_f(\u2603);
        }
    }

    @Override
    protected void func_175135_B() {
        this.func_82142_c(this.field_175436_h);
    }

    @Override
    public void func_82142_c(boolean bl) {
        this.field_175436_h = bl;
        super.func_82142_c(bl);
    }

    @Override
    public boolean func_70631_g_() {
        return this.func_175410_n();
    }

    @Override
    public void func_174812_G() {
        this.func_70106_y();
    }

    @Override
    public boolean func_180427_aV() {
        return this.func_82150_aj();
    }

    @Override
    public PushReaction func_184192_z() {
        if (this.func_181026_s()) {
            return PushReaction.IGNORE;
        }
        return super.func_184192_z();
    }

    private void func_175420_a(boolean bl) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 1, bl));
    }

    public boolean func_175410_n() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 1) != 0;
    }

    private void func_175413_k(boolean bl) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 4, bl));
    }

    public boolean func_175402_q() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 4) != 0;
    }

    private void func_175426_l(boolean bl) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 8, bl));
    }

    public boolean func_175414_r() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 8) != 0;
    }

    private void func_181027_m(boolean bl) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 16, bl));
    }

    public boolean func_181026_s() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 0x10) != 0;
    }

    private byte func_184797_a(byte by2, int n, boolean bl) {
        byte by2 = bl ? (byte)(by2 | n) : (byte)(by2 & ~n);
        return by2;
    }

    public void func_175415_a(Rotations rotations) {
        this.field_175443_bh = rotations;
        this.field_70180_af.func_187227_b(field_184802_b, rotations);
    }

    public void func_175424_b(Rotations rotations) {
        this.field_175444_bi = rotations;
        this.field_70180_af.func_187227_b(field_184803_c, rotations);
    }

    public void func_175405_c(Rotations rotations) {
        this.field_175438_bj = rotations;
        this.field_70180_af.func_187227_b(field_184804_d, rotations);
    }

    public void func_175428_d(Rotations rotations) {
        this.field_175439_bk = rotations;
        this.field_70180_af.func_187227_b(field_184805_e, rotations);
    }

    public void func_175417_e(Rotations rotations) {
        this.field_175440_bl = rotations;
        this.field_70180_af.func_187227_b(field_184806_f, rotations);
    }

    public void func_175427_f(Rotations rotations) {
        this.field_175441_bm = rotations;
        this.field_70180_af.func_187227_b(field_184807_g, rotations);
    }

    public Rotations func_175418_s() {
        return this.field_175443_bh;
    }

    public Rotations func_175408_t() {
        return this.field_175444_bi;
    }

    public Rotations func_175404_u() {
        return this.field_175438_bj;
    }

    public Rotations func_175411_v() {
        return this.field_175439_bk;
    }

    public Rotations func_175403_w() {
        return this.field_175440_bl;
    }

    public Rotations func_175407_x() {
        return this.field_175441_bm;
    }

    @Override
    public boolean func_70067_L() {
        return super.func_70067_L() && !this.func_181026_s();
    }

    @Override
    public boolean func_85031_j(Entity entity) {
        return entity instanceof PlayerEntity && !this.field_70170_p.func_175660_a((PlayerEntity)entity, new BlockPos(this));
    }

    @Override
    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    @Override
    protected SoundEvent func_184588_d(int n) {
        return SoundEvents.field_187704_k;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187707_l;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187701_j;
    }

    @Override
    public void func_70077_a(LightningBoltEntity lightningBoltEntity) {
    }

    @Override
    public boolean func_184603_cC() {
        return false;
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_184801_a.equals(dataParameter)) {
            this.func_213323_x_();
            this.field_70156_m = !this.func_181026_s();
        }
        super.func_184206_a(dataParameter);
    }

    @Override
    public boolean func_190631_cK() {
        return false;
    }

    @Override
    public EntitySize func_213305_a(Pose pose) {
        float f = this.func_181026_s() ? 0.0f : (this.func_70631_g_() ? 0.5f : 1.0f);
        return this.func_200600_R().func_220334_j().func_220313_a(f);
    }
}

